/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.invest.sheet.formula;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.data.DimensionMsgCache;
import kd.fi.bcm.business.formula.register.ExternalFormulaLoader;
import kd.fi.bcm.business.integrationnew.provider.formula.FormulaConstant;
import kd.fi.bcm.business.model.formula.Formula;
import kd.fi.bcm.business.util.ResourcesLoaderUtil;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.formplugin.BcmBasePluginUtil;
import kd.fi.bcm.formplugin.intergration.formula.validate.FTicket;
import kd.fi.bcm.formplugin.intergration.formula.validate.FormulaTicketer;
import kd.fi.bcm.formplugin.intergration.formula.validate.IValidate;
import kd.fi.bcm.formplugin.intergration.formula.validate.NotNullValidate;
import kd.fi.bcm.spread.domain.view.js.SpreadProperties;

public class InvestFormulaRegisterHelper {
    public static List<Formula> getInvestFormulaList() {
        return (List)ThreadCache.get((Object)"getInvestFormulaList", () -> (List)GlobalCacheServiceHelper.getCommonCache().getOrLoad("getInvestFormulaList", () -> {
            ArrayList result = new ArrayList(10);
            ResourcesLoaderUtil.getMapListFromResources((String)"bcmformula/inv_formulas_list.json").forEach(f -> result.add(InvestFormulaRegisterHelper.getFormulaFromResources(f.get("number").toString())));
            return result;
        }));
    }

    public static List<Formula> getRptFormulaList() {
        return (List)ThreadCache.get((Object)"getRptFormulaList", () -> (List)GlobalCacheServiceHelper.getCommonCache().getOrLoad("getRptFormulaList", () -> {
            ArrayList result = new ArrayList(10);
            ResourcesLoaderUtil.getMapListFromResources((String)"bcmformula/rpt_formulas_list.json").forEach(f -> result.add(InvestFormulaRegisterHelper.getFormulaFromResources(f.get("number").toString())));
            ResourcesLoaderUtil.getMapListFromResources((String)"bcmformula/rptinv_formulas_list.json").forEach(f -> result.add(InvestFormulaRegisterHelper.getFormulaFromResources(f.get("number").toString())));
            ExternalFormulaLoader.getInstance().loadExternalFormulaConfig().forEach(cfg -> {
                for (Map formula : cfg.getFormulas()) {
                    String number = (String)formula.get("number");
                    result.add(ResourcesLoaderUtil.getFormulaByNumber((String)number));
                }
            });
            return result;
        }));
    }

    public static List<Map<String, Object>> getRegisterInvestFormulaList(Long modelId) {
        List<Map<String, Object>> invFormulaList = InvestFormulaRegisterHelper.getInvestFormulaList().stream().map(InvestFormulaRegisterHelper::createFormulaMap).collect(Collectors.toList());
        invFormulaList.forEach(f -> InvestFormulaRegisterHelper.dealFunction(modelId, f));
        return invFormulaList;
    }

    public static List<Map<String, String>> getInvestShowFxPlanelFormulaList() {
        return (List)ThreadCache.get((Object)"getInvestShowFxPlanelFormulaList", () -> (List)GlobalCacheServiceHelper.getCommonCache().getOrLoad("getInvestShowFxPlanelFormulaList", () -> InvestFormulaRegisterHelper.getInvestFormulaList().stream().filter(s -> !FormulaConstant.IGNORFORMULAS.contains(s.getNumber().toLowerCase(Locale.ENGLISH))).map(InvestFormulaRegisterHelper::createShowFxPlanelFormulaMap).collect(Collectors.toList())));
    }

    public static List<Map<String, String>> getRptShowFxPlanelFormulaList() {
        return (List)ThreadCache.get((Object)"getRptShowFxPlanelFormulaList", () -> (List)GlobalCacheServiceHelper.getCommonCache().getOrLoad("getRptShowFxPlanelFormulaList", () -> InvestFormulaRegisterHelper.getRptFormulaList().stream().map(InvestFormulaRegisterHelper::createShowFxPlanelFormulaMap).collect(Collectors.toList())));
    }

    private static Map<String, String> createShowFxPlanelFormulaMap(Formula formula) {
        String number = formula.getNumber();
        String catalog = formula.getCatalog();
        String name = formula.getName();
        String description = formula.getDescription();
        return MapInitHelper.ofMap((Object)"number", (Object)number.toLowerCase(), (Object)"catalog", (Object)catalog, (Object)"name", (Object)name, (Object)"description", (Object)description);
    }

    private static Map<String, Object> createFormulaMap(final Formula f) {
        return new HashMap(){
            {
                this.put(SpreadProperties.RegisterCustomFormulaMethod.FORMULANAME.k(), f.getNumber());
                this.put(SpreadProperties.RegisterCustomFormulaMethod.ARGSNUM.k(), f.getParam().size());
                this.put(SpreadProperties.RegisterCustomFormulaMethod.RETURENTYPE.k(), 1);
                if (f.getMinArgs() != null) {
                    this.put("minArgs", f.getMinArgs());
                }
                HashMap<String, Object> description = new HashMap<String, Object>();
                description.put(SpreadProperties.RegisterCustomFormulaMethod.DESCRIPTION.k(), f.getName());
                description.put(SpreadProperties.RegisterCustomFormulaMethod.PARAMETERS.k(), f.getParam());
                this.put(SpreadProperties.RegisterCustomFormulaMethod.DESCRIPTIONIFNO.k(), description);
            }
        };
    }

    private static void dealFunction(Long modelId, Map<String, Object> f) {
        if ("v".equalsIgnoreCase(f.get(SpreadProperties.RegisterCustomFormulaMethod.FORMULANAME.k()).toString())) {
            DynamicObjectCollection dcs = QueryServiceHelper.query((String)"bcm_dimension", (String)"name,shortnumber", (QFilter[])new QFilter[]{QFilter.of((String)"model =?", (Object[])new Object[]{modelId})});
            f.put(SpreadProperties.RegisterCustomFormulaMethod.ARGSNUM.k(), dcs.size());
            Map description = (Map)f.get(SpreadProperties.RegisterCustomFormulaMethod.DESCRIPTIONIFNO.k());
            ArrayList<Map> params = new ArrayList<Map>(dcs.size());
            params.add(MapInitHelper.ofMap((Object)SpreadProperties.RegisterCustomFormulaMethod.NAME.k(), (Object)ResManager.loadKDString((String)"\u7ef4\u5ea6\u7b80\u7801.\u7ef4\u5ea6\u6210\u5458\u7f16\u7801,...", (String)"MultiViewTemplateProcess_76", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
            description.put(SpreadProperties.RegisterCustomFormulaMethod.PARAMETERS.k(), params);
            StringBuilder sb = new StringBuilder();
            for (DynamicObject dimension : dcs) {
                sb.append(dimension.getString("shortnumber")).append(":").append(dimension.getString("name")).append("  ");
            }
            description.put(SpreadProperties.RegisterCustomFormulaMethod.DESCRIPTION.k(), sb.toString());
            f.put(SpreadProperties.RegisterCustomFormulaMethod.DESCRIPTIONIFNO.k(), description);
        }
    }

    private static Formula getFormulaFromResources(String formulaNum) {
        return ResourcesLoaderUtil.getFormulaFromResources((String)("bcmformula/" + formulaNum.toLowerCase() + ".json"));
    }

    public static FormulaTicketer<DynamicObject> buildExcRateTicketer(Formula formula, Long modelId) {
        FormulaTicketer<DynamicObject> ticketer = new FormulaTicketer<DynamicObject>();
        if (!formula.getParam().isEmpty()) {
            DimensionMsgCache dim = new DimensionMsgCache(modelId.longValue());
            HashMap dims = new HashMap();
            dim.getAllDimensionMsg().forEach(d -> dims.put(d.getNumber().toLowerCase(Locale.ENGLISH), d.getName()));
            IValidate notnull = (IValidate)IValidate.build(NotNullValidate.class);
            for (Map map : formula.getParam()) {
                boolean isVisable = true;
                if ("process".equals(map.get("number")) || "currency".equals(map.get("number"))) continue;
                IValidate v = null;
                boolean mustinput = false;
                if ("true".equals(String.valueOf(map.get("mustinput")))) {
                    v = notnull;
                    mustinput = true;
                }
                FTicket ti = new FTicket(String.valueOf(map.get("value")), String.valueOf(map.get("name")), v, true, isVisable, mustinput);
                if (map.get("filter") != null) {
                    Map filter = (Map)map.get("filter");
                    String sql = (String)filter.get("sql");
                    sql = "model = " + modelId + " and " + sql;
                    ti.setFilterString(sql);
                }
                ticketer.addTicket(String.valueOf(map.get("value")), ti);
                dims.remove(String.valueOf(map.get("number")));
            }
            for (Map.Entry entry : dims.entrySet()) {
                String number = (String)entry.getKey();
                String entity = DimEntityNumEnum.getEntieyNumByNumber((String)number);
                ticketer.addTicket(BcmBasePluginUtil.sugarF7Key(entity, number), new FTicket(entity, (String)entry.getValue(), null, false, false));
            }
        }
        return ticketer;
    }
}

