/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.invest.sheet.formula;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.FormulaEditHelper;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.formula.express.FormulaAnalyze;
import kd.fi.bcm.business.formula.register.FormulaConfig;
import kd.fi.bcm.business.model.formula.Formula;
import kd.fi.bcm.business.util.ResourcesLoaderUtil;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.intergration.formula.validate.FTicket;
import kd.fi.bcm.formplugin.intergration.formula.validate.FormulaTicketer;
import kd.fi.bcm.formplugin.intergration.formula.validate.IValidate;
import kd.fi.bcm.formplugin.intergration.formula.validate.NotNullValidate;
import kd.fi.bcm.formplugin.intergration.util.ShowFormulaUtil;
import kd.fi.bcm.formplugin.invest.sheet.formula.InvestFormulaRegisterHelper;
import kd.fi.bcm.spread.formula.ExcelFormulaPaserHelper;
import kd.fi.bcm.spread.formula.expr.FunctionExpr;

public class InvestRptFormulaPlugin
extends AbstractBaseFormPlugin {
    private static final Map<String, String> operationCharacter = new HashMap<String, String>();
    private static final String[] operators = new String[]{"+", "-", "*", "/", "<>"};
    private static final String catalog_list = "CATALOG_LIST";
    private static final String TEXT_AREA = "txtadvance";
    private static final String TEXT_AREA_TAG = "txtadvance_tag";
    private static final String RPTMODEL_EDIT = "bcm_invrptformulaedit";
    private static final String RPT_CALLBACK = "formulaedit";
    private static final String RPT_UPDATE_FORMULA = "updateFormula";
    public static final String IS_DRAFT = "is_draft";

    protected List<Map<String, String>> getFormulaList() {
        return InvestFormulaRegisterHelper.getInvestShowFxPlanelFormulaList();
    }

    private List<Map<String, String>> getCatalogList() {
        return FormulaConfig.getInstance().getCatalogList();
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        List<Map<String, String>> formulaList = this.getFormulaList();
        formulaList.sort((o1, o2) -> ((String)o1.get("number")).compareToIgnoreCase((String)o2.get("number")));
        ComboEdit comboEdit = (ComboEdit)this.getControl("cmbtype");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(10);
        List<String> cats = this.getCatalogFilter();
        List<Map<String, String>> catalogList = this.getCatalogList();
        for (Map<String, String> catalog : catalogList) {
            if (!cats.contains(catalog.get("number"))) continue;
            String number = catalog.get("number");
            if (number.contains("-")) {
                number = catalog.get("number").replace("-", "_");
            }
            String name = ResManager.loadKDString((String)catalog.get("name"), (String)("InvestRptFormulaPlugin_" + number), (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            items.add(new ComboItem(new LocaleString(name), catalog.get("number")));
        }
        comboEdit.setComboItems(items);
        this.getModel().setValue("cmbtype", (Object)"all");
        this.setFormulaTree("all");
        Object txtadvance = this.getFormCustomParam(TEXT_AREA);
        if (txtadvance != null) {
            this.getModel().setValue(TEXT_AREA_TAG, txtadvance);
        }
    }

    private List<String> getFormulaFilter() {
        String filter = (String)this.getFormCustomParam("filter");
        ArrayList<String> filters = new ArrayList();
        if (StringUtils.isNotEmpty((CharSequence)filter)) {
            filters = Arrays.asList(filter.split(","));
        } else {
            List<Map<String, String>> formulaList = this.getFormulaList();
            for (Map<String, String> formula : formulaList) {
                String formulaNum = formula.get("number");
                if (formulaNum.equals("rptdate") || formulaNum.equals("rptinfo")) continue;
                filters.add(formulaNum);
            }
        }
        return filters;
    }

    private List<String> getCatalogFilter() {
        List<String> formulas = this.getFormulaFilter();
        ArrayList<String> filters = new ArrayList<String>();
        filters.add("all");
        List<Map<String, String>> formulaList = this.getFormulaList();
        for (Map<String, String> formula : formulaList) {
            if (!formulas.contains(formula.get("number"))) continue;
            filters.add(formula.get("catalog"));
        }
        return filters;
    }

    private void setFormulaTree(String type) {
        TreeView tree = (TreeView)this.getControl("formulatree");
        tree.deleteAllNodes();
        ArrayList<TreeNode> catalogList = new ArrayList<TreeNode>();
        List<String> fors = this.getFormulaFilter();
        List<Map<String, String>> formulaList = this.getFormulaList();
        if ("all".equals(type)) {
            for (Map<String, String> formula : formulaList) {
                if (!fors.contains(formula.get("number"))) continue;
                TreeNode node = new TreeNode();
                node.setId(formula.get("number"));
                String number = formula.get("number");
                if (number.contains("-")) {
                    number = formula.get("number").replace("-", "_");
                }
                String name = ResManager.loadKDString((String)formula.get("name"), (String)("InvestRptFormulaPlugin_" + number), (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                node.setText(formula.get("number") + name);
                node.setParentid("");
                tree.addNode(node);
                catalogList.add(node);
            }
        } else {
            for (Map<String, String> formula : formulaList) {
                if (!formula.get("catalog").equals(type) || !fors.contains(formula.get("number"))) continue;
                TreeNode node = new TreeNode();
                node.setId(formula.get("number"));
                String number = formula.get("number");
                if (number.contains("-")) {
                    number = formula.get("number").replace("-", "_");
                }
                String name = ResManager.loadKDString((String)formula.get("name"), (String)("InvestRptFormulaPlugin_" + number), (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                node.setText(formula.get("number") + name);
                node.setParentid("");
                tree.addNode(node);
                catalogList.add(node);
            }
        }
        this.getPageCache().put(catalog_list, SerializationUtils.serializeToBase64(catalogList));
        this.focusFirstNode(catalogList);
    }

    private void focusFirstNode(List<TreeNode> catalogList) {
        TreeView tree = (TreeView)this.getControl("formulatree");
        if (!catalogList.isEmpty()) {
            TreeNode node = catalogList.get(0);
            tree.focusNode(node);
            tree.treeNodeClick(node.getParentid(), node.getId());
        }
    }

    @Override
    public void click(EventObject evt) {
        String key;
        super.click(evt);
        String formula = this.getModel().getValue(TEXT_AREA_TAG).toString();
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnconfirm": {
                if (StringUtils.isNotEmpty((CharSequence)formula)) {
                    this.returnFormulaToParent(formula);
                    break;
                }
                this.openFormulaEdit();
                break;
            }
            case "btnremove": {
                this.getModel().setValue(TEXT_AREA, (Object)"");
                this.getModel().setValue(TEXT_AREA_TAG, (Object)"");
                break;
            }
            case "btnformula": {
                if (formula.toLowerCase(Locale.ENGLISH).contains("if")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"if\u516c\u5f0f\u8bf7\u6309\u7167Excel\u683c\u5f0f\u624b\u52a8\u7ef4\u62a4\u3002", (String)"InvestRptFormulaPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                List lstFormula = FormulaAnalyze.analyticFun((String)formula);
                if (lstFormula == null || lstFormula.size() == 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u516c\u5f0f\u89e3\u6790\u9519\u8bef,\u8bf7\u68c0\u67e5\u53f3\u4fa7\u8f93\u5165\u516c\u5f0f\u3002", (String)"InvestRptFormulaPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                this.showListByFormula(formula);
                break;
            }
            default: {
                String character = operationCharacter.get(key);
                FormulaEditHelper.insertExpression((IFormView)this.getView(), (String)key, (String)TEXT_AREA_TAG, (String)character);
            }
        }
    }

    private void returnFormulaToParent(String formula) {
        formula = formula.replaceAll("\\p{C}", "");
        try {
            ExcelFormulaPaserHelper.parse((String)formula);
        }
        catch (Exception e) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u516c\u5f0f\u3002", (String)"InvestRptFormulaPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().returnDataToParent((Object)formula);
        this.getView().close();
    }

    private void showListByFormula(String formula) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(RPTMODEL_EDIT);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.EDIT);
        parameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        parameter.setCustomParam("formulas", (Object)formula);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, RPT_CALLBACK);
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
    }

    private void openFormulaEdit() {
        TreeView tree = (TreeView)this.getControl("formulatree");
        String selectedNodeNumber = (String)tree.getTreeState().getSelectedNodeId().get(0);
        Formula formula = ResourcesLoaderUtil.getFormulaByNumber((String)selectedNodeNumber);
        FormShowParameter parameter = new FormShowParameter();
        this.selectGuidePage(formula, parameter);
        parameter.setCaption(String.format(ResManager.loadKDString((String)"%s\u516c\u5f0f\u5411\u5bfc", (String)"InvestRptFormulaPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), formula.getNumber()));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.EDIT);
        parameter.setCustomParam("accttype", (Object)selectedNodeNumber);
        parameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "setFormula");
        parameter.setCloseCallBack(closeCallBack);
        parameter.setCustomParam("invrelationtype", this.getFormCustomParam("invrelationtype"));
        if (formula.getNumber().equalsIgnoreCase("v")) {
            parameter.setFormId("bcm_invvformula");
            FormulaTicketer<DynamicObject> ticketer = this.buildTicketer(formula);
            parameter.setCustomParam("FormulaTicketer", (Object)this.toByteSerialized(ticketer));
            parameter.setCustomParam(IS_DRAFT, (Object)true);
        } else if (formula.getNumber().equalsIgnoreCase("esp")) {
            parameter.setCustomParam(IS_DRAFT, (Object)true);
            parameter.setFormId("bcm_espfunctionset");
        } else if (formula.getNumber().equalsIgnoreCase("p")) {
            HashSet disableBtn = Sets.newHashSet((Object[])new String[]{"inv", "bn", "excrate"});
            parameter.setCustomParam(IS_DRAFT, (Object)true);
            parameter.setCustomParam("disable_btn", (Object)disableBtn);
            parameter.setFormId("bcm_invchangeformula");
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "setPFormula"));
        } else if (formula.getNumber().equalsIgnoreCase("desp")) {
            parameter.setCustomParam(IS_DRAFT, (Object)true);
            parameter.setFormId("bcm_despfunctionset");
        } else if (formula.getNumber().equalsIgnoreCase("getjlentry")) {
            parameter.setFormId("bcm_getjlentryformula_inv");
        } else if (formula.getNumber().equalsIgnoreCase("excrate")) {
            FormulaTicketer<DynamicObject> ticketer = this.buildTicketer(formula);
            parameter.setCustomParam("FormulaTicketer", (Object)this.toByteSerialized(ticketer));
            parameter.setFormId("bcm_invexrateformula");
        }
        this.getView().showForm(parameter);
    }

    private FormulaTicketer<DynamicObject> buildTicketer(Formula formula) {
        FormulaTicketer<DynamicObject> ticketer = new FormulaTicketer<DynamicObject>();
        if (formula.getNumber().equalsIgnoreCase("excrate")) {
            return InvestFormulaRegisterHelper.buildExcRateTicketer(formula, this.getModelId());
        }
        IValidate notnull = (IValidate)IValidate.build(NotNullValidate.class);
        DynamicObjectCollection alldims = QueryDimensionServiceHelper.getDimensionBaseInfos((Object)this.getModelId());
        for (DynamicObject obj : alldims) {
            String sign;
            String entity = obj.getString("membermodel");
            String number = obj.getString("number");
            String name = obj.getString("name");
            if ("bcm_entitymembertree".equals(entity) || "bcm_icmembertree".equals(entity) || "bcm_mycompanymembertree".equals(entity) || "bcm_currencymembertree".equals(entity)) {
                ticketer.addTicket(entity, new FTicket(entity, name, null, false, false));
                continue;
            }
            if ("bcm_accountmembertree".equals(entity) || "bcm_changetypemembertree".equals(entity) || "bcm_userdefinedmembertree".equals(entity) || "bcm_audittrialmembertree".equals(entity)) {
                sign = this.sugarF7Key(entity, number);
                ticketer.addTicket(sign, new FTicket(entity, name, notnull, true, true, true));
                continue;
            }
            if ("bcm_scenemembertree".equals(entity) || "bcm_fymembertree".equals(entity) || "bcm_periodmembertree".equals(entity) || "bcm_processmembertree".equals(entity)) {
                ticketer.addTicket(entity, new FTicket(entity, name, null, true, true));
                continue;
            }
            sign = this.sugarF7Key(entity, number);
            ticketer.addTicket(sign, new FTicket(entity, name, notnull, true, true, true));
        }
        return ticketer;
    }

    private void selectGuidePage(Formula formula, FormShowParameter parameter) {
        String ti = (String)this.getFormCustomParam("vticketer");
        if (StringUtils.isNotEmpty((CharSequence)ti)) {
            parameter.setCustomParam("vticketer", (Object)ti);
        }
        ShowFormulaUtil.selectGuidePage(formula, parameter, this.getModelId());
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "cmbtype": {
                this.changeType();
                break;
            }
        }
    }

    private void changeType() {
        String type = (String)this.getModel().getValue("cmbtype");
        this.setFormulaTree(type);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "setFormula": {
                if (closedCallBackEvent.getReturnData() == null) break;
                String formula = this.getFormula(closedCallBackEvent);
                this.buildAndReturn(formula);
                break;
            }
            case "setPFormula": {
                Object returnData = closedCallBackEvent.getReturnData();
                if (!(returnData instanceof Map)) break;
                Map data = (Map)returnData;
                String formula = String.format("P(%s)", data.get("formula"));
                if (this.getPageCache().get("rowSelect") != null) {
                    this.update2Formula(this.getModel(), formula);
                    break;
                }
                this.buildAndReturn(formula);
                break;
            }
            case "formulaedit": {
                Map formulaMap;
                if (closedCallBackEvent.getReturnData() == null || (formulaMap = (Map)closedCallBackEvent.getReturnData()) == null) break;
                String formula = (String)formulaMap.get("formula");
                if (formulaMap.get("rowSelect") != null) {
                    this.getPageCache().put("rowSelect", formulaMap.get("rowSelect").toString());
                }
                String selectedNodeNumber = formula.substring(0, formula.indexOf(40)).toLowerCase(Locale.ENGLISH);
                this.showFormulaEdit(selectedNodeNumber, RPT_UPDATE_FORMULA, formula);
                break;
            }
            case "updateFormula": {
                if (closedCallBackEvent.getReturnData() != null) {
                    String formula = closedCallBackEvent.getReturnData().toString();
                    if (closedCallBackEvent.getReturnData() instanceof Map) {
                        formula = ((Map)closedCallBackEvent.getReturnData()).get("formula").toString();
                    }
                    this.update2Formula(this.getModel(), formula);
                    break;
                }
                String formula = this.getModel().getValue(TEXT_AREA_TAG).toString();
                this.showListByFormula(formula);
                break;
            }
        }
    }

    private void buildAndReturn(String formula) {
        String oldtxt = this.getModel().getValue(TEXT_AREA_TAG).toString().trim();
        if (StringUtils.isNotBlank((CharSequence)oldtxt)) {
            String str = oldtxt.substring(oldtxt.length() - 1);
            if (!Arrays.asList(operators).contains(str)) {
                oldtxt = oldtxt + " + ";
            }
        }
        String newformula = oldtxt + formula;
        this.returnFormulaToParent(newformula);
    }

    private String getFormula(ClosedCallBackEvent evt) {
        Object returnData = evt.getReturnData();
        if (returnData instanceof Map) {
            Map data = (Map)returnData;
            String formula = (String)data.get("formula");
            return formula;
        }
        return returnData.toString();
    }

    @Override
    public void initialize() {
        super.initialize();
        this.addClickListeners("btnformula", "btnconfirm", "btnremove", "btnadd", "btnsubtract", "btnmultiply", "btndivide", "btnnotequal");
        operationCharacter.put("btnadd", "+");
        operationCharacter.put("btnsubtract", "-");
        operationCharacter.put("btnmultiply", "*");
        operationCharacter.put("btndivide", "/");
        operationCharacter.put("btnnotequal", "<>");
        TreeView tree = (TreeView)this.getControl("formulatree");
        tree.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                InvestRptFormulaPlugin.this.refreshFormulaDescriptionAndContent();
            }

            public void treeNodeDoubleClick(TreeNodeEvent evt) {
                InvestRptFormulaPlugin.this.openFormulaEdit();
            }
        });
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener(searchEnterEvent -> {
            String text = searchEnterEvent.getText();
            this.searchAndFocusNode(text);
        });
    }

    private void searchAndFocusNode(String text) {
        String str = this.getPageCache().get(catalog_list);
        List catalogList = (List)SerializationUtils.deSerializeFromBase64((String)str);
        TreeView tree = (TreeView)this.getControl("formulatree");
        for (TreeNode node : catalogList) {
            if (!node.getText().contains(text)) continue;
            tree.focusNode(node);
            tree.treeNodeClick(node.getParentid(), node.getId());
        }
    }

    private void refreshFormulaDescriptionAndContent() {
        TreeView tree = (TreeView)this.getControl("formulatree");
        String selectedNodeNumber = (String)tree.getTreeState().getSelectedNodeId().get(0);
        Formula formula = ResourcesLoaderUtil.getFormulaByNumber((String)selectedNodeNumber);
        String des_trans = ResManager.loadKDString((String)formula.getDescription(), (String)("InvestRptFormulaPlugin_des_" + formula.getNumber().toLowerCase()), (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        this.getModel().setValue("txtdesc", (Object)des_trans.replace("?", "\n"));
    }

    protected void showFormulaEdit(String selectedNodeNumber, String actionId, String formula) {
        Formula formula1 = null;
        try {
            formula1 = ResourcesLoaderUtil.getFormulaByNumber((String)selectedNodeNumber);
        }
        catch (Exception e) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u516c\u5f0f\u4e0d\u5b58\u5728\u516c\u5f0f\u5411\u5bfc\u3002", (String)"InvestRptFormulaPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            String textFormula = this.getModel().getValue(TEXT_AREA_TAG).toString();
            this.showListByFormula(textFormula);
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        this.selectGuidePage(formula1, parameter);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.EDIT);
        parameter.setCustomParam("accttype", (Object)selectedNodeNumber);
        parameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        if (formula != null) {
            parameter.setCustomParam("formula", (Object)this.formula2LowerCase(formula));
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, actionId);
        parameter.setCloseCallBack(closeCallBack);
        if (formula1.getNumber().equalsIgnoreCase("v")) {
            parameter.setFormId("bcm_invvformula");
            FormulaTicketer<DynamicObject> ticketer = this.buildTicketer(formula1);
            parameter.setCustomParam("FormulaTicketer", (Object)this.toByteSerialized(ticketer));
            parameter.setCustomParam(IS_DRAFT, (Object)true);
        } else if (formula1.getNumber().equalsIgnoreCase("esp")) {
            parameter.setCustomParam(IS_DRAFT, (Object)true);
            parameter.setFormId("bcm_espfunctionset");
        } else if (formula1.getNumber().equalsIgnoreCase("p")) {
            HashSet disableBtn = Sets.newHashSet((Object[])new String[]{"inv", "bn"});
            parameter.setCustomParam(IS_DRAFT, (Object)true);
            parameter.setCustomParam("disable_btn", (Object)disableBtn);
            parameter.setFormId("bcm_invchangeformula");
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "setPFormula"));
            if (formula != null) {
                parameter.setCustomParam("formula", (Object)ShowFormulaUtil.formula2LowerCase(formula.substring(2, formula.length() - 1)));
            }
        } else if (formula1.getNumber().equalsIgnoreCase("excrate")) {
            FormulaTicketer<DynamicObject> ticketer = this.buildTicketer(formula1);
            parameter.setCustomParam("FormulaTicketer", (Object)this.toByteSerialized(ticketer));
            parameter.setFormId("bcm_invexrateformula");
        }
        this.getView().showForm(parameter);
    }

    private String formula2LowerCase(String formulaStr) {
        return ShowFormulaUtil.formula2LowerCase(formulaStr);
    }

    private void update2Formula(IDataModel model, String formula) {
        formula = this.formula2LowerCase(formula);
        String oldtxt = model.getValue(TEXT_AREA_TAG).toString().trim();
        List lstFormula = FormulaAnalyze.analyticFun((String)oldtxt);
        int row = 0;
        if (this.getPageCache().get("rowSelect") != null) {
            row = Integer.parseInt(this.getPageCache().get("rowSelect"));
        }
        StringBuilder subtxt = new StringBuilder();
        if (row > 0) {
            for (int i = 0; i < row; ++i) {
                String formulaStr = ((FunctionExpr)lstFormula.get(i)).toString().replaceAll(" ", "");
                formulaStr = this.formula2LowerCase(formulaStr);
                int indexOf = oldtxt.indexOf(formulaStr);
                subtxt.append(oldtxt, 0, indexOf + formulaStr.length());
                oldtxt = oldtxt.substring(indexOf + formulaStr.length());
            }
        }
        String expr = ((FunctionExpr)lstFormula.get(row)).toString().replaceAll(" ", "");
        expr = this.formula2LowerCase(expr);
        int indexOf = oldtxt.toLowerCase(Locale.ENGLISH).indexOf(expr.toLowerCase(Locale.ENGLISH));
        subtxt.append(oldtxt, 0, indexOf);
        oldtxt = oldtxt.substring(indexOf + expr.length());
        this.getModel().setValue(TEXT_AREA, (Object)(subtxt + formula + oldtxt));
        this.getModel().setValue(TEXT_AREA_TAG, (Object)(subtxt + formula + oldtxt));
        this.getView().updateView();
    }
}

