/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.invest.util;

import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;

public class TreeBillPermUtil {
    private static final String FI_BCM_FORM_PLUGIN = "fi-bcm-formplugin";
    private static final String L_TREE = "l_tree_readOnly";
    private static final String R_BILL = "r_bill_readOnly";
    private IFormView view;
    private String modelId;
    private String entityNameLTree;
    private String entityNameRBill;
    private String billCatalogFieldName = "templatecatalog";
    private String treeParentFieldName = "parent";
    private String treeModelFieldName = "model";
    private UnaryOperator<QFilter> billFilter = qFilter -> qFilter;

    public TreeBillPermUtil(IFormView view) {
        this.view = view;
    }

    public static boolean isReadOnlyCatalog(IFormView view, Long catalogId, String modelId) {
        boolean adminUserBol = MemberPermHelper.ifUserHasRootPermByModel((long)RequestContext.get().getCurrUserId(), (String)modelId);
        if (adminUserBol) {
            return false;
        }
        List treeList = (List)SerializationUtils.fromJsonString((String)view.getPageCache().get(L_TREE), List.class);
        TreeBillPermUtil.pleaseCache(treeList);
        return treeList.contains(catalogId);
    }

    public static boolean isReadOnlyEntry(IFormView view, Long id, String modelId) {
        boolean adminUserBol = MemberPermHelper.ifUserHasRootPermByModel((long)RequestContext.get().getCurrUserId(), (String)modelId);
        if (adminUserBol) {
            return false;
        }
        List treeList = (List)SerializationUtils.fromJsonString((String)view.getPageCache().get(R_BILL), List.class);
        TreeBillPermUtil.pleaseCache(treeList);
        return treeList.contains(id);
    }

    public List<Long> noPermEntryIds() {
        boolean adminUserBol = MemberPermHelper.ifUserHasRootPermByModel((long)RequestContext.get().getCurrUserId(), (String)this.modelId);
        if (adminUserBol) {
            return Collections.emptyList();
        }
        ArrayListMultimap<String, Long> permissionMapBill = this.getPermissionMap(this.entityNameRBill);
        List noPermBill = permissionMapBill.get((Object)PermClassEntityHelper.PermClassEnum.NOPERM.getValue());
        List<Long> noPermTree = this.collectTreePerm(PermClassEntityHelper.PermClassEnum.NOPERM);
        noPermBill.addAll(this.queryBillByCatalog(noPermTree));
        return noPermBill;
    }

    public void cacheReadOnly() {
        this.validateBeforeCache();
        boolean adminUserBol = MemberPermHelper.ifUserHasRootPermByModel((long)RequestContext.get().getCurrUserId(), (String)this.modelId);
        if (adminUserBol) {
            return;
        }
        List<Long> readOnlyTree = this.cacheLTree();
        this.cacheRBill(readOnlyTree);
    }

    private void validateBeforeCache() {
        if (this.view == null || this.modelId == null || this.entityNameLTree == null || this.entityNameRBill == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u89c6\u56fe\u3001\u4f53\u7cfb\u3001\u5de6\u6811\u6807\u8bc6\u3001\u53f3\u8868\u6807\u8bc6\u7b49\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TreeBillPermUtil_0", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]));
        }
    }

    private static void pleaseCache(List<Long> treeList) {
        if (Objects.isNull(treeList)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5728\u52a0\u8f7d\u5de6\u6811\u53f3\u8868\u65f6\u7f13\u5b58\u3002", (String)"TreeBillPermUtil_1", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]));
        }
    }

    private void cacheRBill(List<Long> readOnlyLTree) {
        ArrayListMultimap<String, Long> permissionMapBill = this.getPermissionMap(this.entityNameRBill);
        List readOnlyBill = permissionMapBill.get((Object)PermClassEntityHelper.PermClassEnum.READONLY.getValue());
        Collection<Long> readOnlyCase = this.queryBillByCatalog(readOnlyLTree);
        List noPermBill = permissionMapBill.get((Object)PermClassEntityHelper.PermClassEnum.NOPERM.getValue());
        readOnlyCase.removeAll(noPermBill);
        readOnlyBill.addAll(readOnlyCase);
        String jsonReadOnly = ObjectSerialUtil.toJson((Object)readOnlyBill);
        this.view.getPageCache().put(R_BILL, jsonReadOnly);
    }

    private List<Long> cacheLTree() {
        List<Long> readOnly = this.collectTreePerm(PermClassEntityHelper.PermClassEnum.READONLY);
        String json = ObjectSerialUtil.toJson(readOnly);
        this.view.getPageCache().put(L_TREE, json);
        return readOnly;
    }

    private List<Long> collectTreePerm(PermClassEntityHelper.PermClassEnum permClassEnum) {
        ArrayListMultimap<String, Long> permissionMap = this.getPermissionMap(this.entityNameLTree);
        QFBuilder qfBuilder = new QFBuilder(this.treeModelFieldName, "=", (Object)Long.parseLong(this.modelId));
        if (permClassEnum == PermClassEntityHelper.PermClassEnum.READONLY) {
            List noPerm = permissionMap.get((Object)PermClassEntityHelper.PermClassEnum.NOPERM.getValue());
            qfBuilder.and("id", "not in", (Object)noPerm).and(this.treeParentFieldName, "not in", (Object)noPerm);
        }
        DynamicObjectCollection catalogMap = QueryServiceHelper.query((String)this.entityNameLTree, (String)("id," + this.treeParentFieldName), (QFilter[])qfBuilder.toArray());
        HashMap<Long, List<Long>> parent2Children = new HashMap<Long, List<Long>>(16);
        for (DynamicObject task : catalogMap) {
            long id = task.getLong("id");
            long parent = task.getLong(this.treeParentFieldName);
            parent2Children.computeIfAbsent(parent, value -> new ArrayList()).add(id);
        }
        ArrayList<Long> collector = new ArrayList<Long>(permissionMap.get((Object)permClassEnum.getValue()));
        HashSet<Long> deadCycleUtil = new HashSet<Long>(16);
        this.collectAll(collector, 0L, parent2Children, deadCycleUtil);
        return collector;
    }

    private void collectAll(List<Long> collector, long parent, Map<Long, List<Long>> parent2Children, Set<Long> deadCycleUtil) {
        List children = parent2Children.getOrDefault(parent, Collections.emptyList());
        for (Long child : children) {
            if (collector.contains(parent) && parent != 0L) {
                collector.add(child);
            }
            if (!deadCycleUtil.add(child)) continue;
            this.collectAll(collector, child, parent2Children, deadCycleUtil);
        }
    }

    private Collection<Long> queryBillByCatalog(List<Long> treeIds) {
        QFilter filter = new QFilter(this.billCatalogFieldName, "in", treeIds);
        QFilter finalFilter = (QFilter)this.billFilter.apply(filter);
        return QueryServiceHelper.query((String)this.entityNameRBill, (String)"id", (QFilter[])new QFilter[]{finalFilter}).stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
    }

    private ArrayListMultimap<String, Long> getPermissionMap(String entityNameRBill) {
        return PermClassEntityHelper.getPermissionMap((String)entityNameRBill, (String)this.modelId, (String)String.valueOf(RequestContext.get().getCurrUserId()));
    }

    public TreeBillPermUtil setModelId(String modelId) {
        this.modelId = modelId;
        return this;
    }

    public TreeBillPermUtil setEntityNameLTree(String entityNameLTree) {
        this.entityNameLTree = entityNameLTree;
        return this;
    }

    public TreeBillPermUtil setEntityNameRBill(String entityNameRBill) {
        this.entityNameRBill = entityNameRBill;
        return this;
    }
}

