/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.invest.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.fi.bcm.business.tree.AbstractTreeNode;
import kd.fi.bcm.business.tree.ITreeNode;
import kd.fi.bcm.business.tree.TreeModel;

public class TreeNodeSearchUtil {
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private static final String ROW_LIST = "treeNodeSearchUtil_row_list";
    private static final String FOCUS_NUMBER = "treeNodeSearchUtil_focus_number";
    private static final String BEFORE_TEXT = "treeNodeSearchUtil_text";
    private IFormView view;
    private String treeKey;
    private String treeModelKey;
    private int maxRowCount;

    public TreeNodeSearchUtil(IFormView view, String treeKey, String treeModelKey) {
        this.view = view;
        this.treeKey = treeKey;
        this.treeModelKey = treeModelKey;
    }

    public void searchMember(String text) {
        ArrayList<String> list = new ArrayList<String>(10);
        TreeView treeView = (TreeView)this.view.getControl(this.treeKey);
        TreeModel treeModel = TreeModel.toTreeModel((IPageCache)this.view.getPageCache(), (String)this.treeModelKey);
        if (Objects.isNull(treeModel)) {
            this.noTreeTip();
            return;
        }
        ITreeNode root = treeModel.getRoot();
        List lists = treeModel.seekAllChildrenIf(root.getId(), p -> p.getName().toLowerCase(Locale.ENGLISH).contains(text.toLowerCase(Locale.ENGLISH)));
        for (AbstractTreeNode node : lists) {
            list.add(node.getId());
        }
        if (!list.isEmpty()) {
            int nextRow = 0;
            this.maxRowCount = list.size() - 1;
            String newListString = SerializationUtils.toJsonString(list);
            nextRow = this.getNextRow(text, nextRow, newListString);
            this.view.getPageCache().put(ROW_LIST, newListString);
            this.view.getPageCache().put(FOCUS_NUMBER, String.valueOf(nextRow));
            this.view.getPageCache().put(BEFORE_TEXT, text);
            this.focus(treeView, treeModel, (String)list.get(nextRow));
        } else {
            this.noTreeTip();
        }
    }

    public void searchBefore() {
        this.search(rowCount -> {
            if (0 == rowCount.get()) {
                this.view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u7b2c\u4e00\u6761\u5185\u5bb9\u3002", (String)"TreeNodeSearchUtil_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return Boolean.TRUE;
            }
            rowCount.decrementAndGet();
            return Boolean.FALSE;
        });
    }

    public void searchNext() {
        this.search(rowCount -> {
            if (this.maxRowCount == rowCount.get()) {
                this.view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u6700\u540e\u4e00\u6761\u5185\u5bb9\u3002", (String)"TreeNodeSearchUtil_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return Boolean.TRUE;
            }
            rowCount.incrementAndGet();
            return Boolean.FALSE;
        });
    }

    private void search(Predicate<? super AtomicInteger> predicate) {
        int rowCount = 0;
        TreeView treeView = (TreeView)this.view.getControl(this.treeKey);
        TreeModel treeModel = TreeModel.toTreeModel((IPageCache)this.view.getPageCache(), (String)this.treeModelKey);
        if (Objects.isNull(treeModel)) {
            this.noTreeTip();
            return;
        }
        String rowCache = this.view.getPageCache().get(ROW_LIST);
        String count = this.view.getPageCache().get(FOCUS_NUMBER);
        if (count != null) {
            rowCount = Integer.parseInt(count);
        }
        if (rowCache == null) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u9700\u8981\u641c\u7d22\u7684\u5185\u5bb9\u540e\u6309\u56de\u8f66\u952e\u3002", (String)"TreeNodeSearchUtil_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        List rowList = (List)SerializationUtils.fromJsonString((String)rowCache, List.class);
        this.maxRowCount = rowList.size() - 1;
        AtomicInteger atomicInteger = new AtomicInteger(rowCount);
        if (predicate.test(atomicInteger)) {
            return;
        }
        rowCount = atomicInteger.get();
        this.view.getPageCache().put(FOCUS_NUMBER, String.valueOf(rowCount));
        this.focus(treeView, treeModel, (String)rowList.get(rowCount));
    }

    private void focus(TreeView treeView, TreeModel<?> treeModel, String focusNode) {
        ITreeNode parent = treeModel.searchByNodeId(focusNode).getParent();
        String parentId = parent == null ? null : parent.getId();
        treeView.focusNode(new TreeNode(parentId, focusNode, ""));
        treeView.treeNodeClick(parentId, focusNode);
        while (parentId != null) {
            String temp = parentId;
            treeView.expand(temp);
            if (treeModel.searchByNodeId(temp).getParent() == null) break;
            parentId = treeModel.searchByNodeId(temp).getParent().getId();
        }
    }

    private int getNextRow(String text, int nextRow, String newListString) {
        String oldListString;
        String oldText = this.view.getPageCache().get(BEFORE_TEXT);
        if (Objects.equals(text, oldText) && Objects.equals(newListString, oldListString = this.view.getPageCache().get(ROW_LIST))) {
            String currentRowCache = this.view.getPageCache().get(FOCUS_NUMBER);
            int currentRow = Integer.parseInt(currentRowCache);
            nextRow = currentRow + 1 > this.maxRowCount ? 0 : currentRow + 1;
        }
        return nextRow;
    }

    private void noTreeTip() {
        this.view.showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"TreeNodeSearchUtil_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
    }
}

