/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.licence;

import com.google.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.fs.util.StringUtils;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.formplugin.licence.Version;
import kd.fi.bcm.formplugin.licence.VersionService;

public class BcmLicenceControl {
    private static final String PLATFORM_VERSION = "4.0.000.0";
    public static final String FIDIMANDFAR_VERSION = "5.0.011.0";
    public static final String RPA_VERSION = "5.0.011.0";
    private static final String SHOW_LOCK_VERSION = "6.0.0";
    private static final String TREE_IMAGE_VERSION = "6.0.2";
    private static List<String> bcmLic = Arrays.asList("bcm_report_list", "bcm_cslreport_list", "bcm_rptadjustentry_merge", "bcm_rptadjustentry_offset", "bcm_report_search", "bcm_rptadjustquery_list", "bcm_cwpreport_list", "bcm_checkrecordlist", "bcm_rptadjustentry_djust");
    private static List<String> SPECIAL_LIC = Collections.singletonList("bcm_isrptschemelist");
    private static Set<String> VERSION_FORMS = Sets.newHashSet((Object[])new String[]{"bcm_isrptschemelist"});
    protected static WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, BcmLicenceControl.class);
    private static Method invokeShowMessageWindowMethod = null;
    private static Method invokeGetShowMessageMethod = null;

    public static LicenseCheckResult check(String appId, String formId) {
        if (bcmLic.contains(formId)) {
            String platFormVersion;
            Long userId = Long.valueOf(RequestContext.get().getUserId());
            if (StringUtils.isEmpty((String)appId)) {
                appId = ApplicationTypeEnum.CM.getAppnum();
            }
            if (StringUtils.isNotEmpty((String)(platFormVersion = BcmLicenceControl.getPlatFormVersion())) && platFormVersion.compareToIgnoreCase(PLATFORM_VERSION) > 0) {
                return LicenseServiceHelper.checkByAppAndBizObj((String)AppMetadataCache.getAppInfo((String)appId).getId(), (String)"bcm_report_list", (Long)userId);
            }
            return new LicenseCheckResult(Boolean.valueOf(true), "1");
        }
        if (SPECIAL_LIC.contains(formId)) {
            return BcmLicenceControl.checkSpecialLicense();
        }
        return null;
    }

    private static LicenseCheckResult checkSpecialLicense() {
        LicenseCheckResult re = null;
        String productVersion = LicenseServiceHelper.getProductVersion();
        BigDecimal licenseVersion = new BigDecimal(productVersion.trim());
        if (licenseVersion.compareTo(new BigDecimal("1.0")) > 0 && licenseVersion.compareTo(new BigDecimal("7.0")) < 0) {
            re = LicenseServiceHelper.checkPerformGroup((String)"PRO_CMRPA");
        }
        return re;
    }

    public static String getPlatFormVersion() {
        Set<Version> versions = VersionService.getVersionInfos();
        Version versionInfo = versions.stream().filter(x -> Objects.equals(x.getProductNumber(), "cosmic_bos")).findAny().orElse(null);
        if (null != versionInfo) {
            return versionInfo.getVersion();
        }
        return "";
    }

    public static String getPlatFormCorrectVersion() {
        Set<Version> versions = VersionService.getVersionCorrectInfos();
        Version versionInfo = versions.stream().filter(x -> Objects.equals(x.getProductNumber(), "cosmic_bos")).findAny().orElse(null);
        if (null != versionInfo) {
            return versionInfo.getVersion();
        }
        return "";
    }

    public static String checkByVersion(FormShowParameter fs) {
        String msg = null;
        if (VERSION_FORMS.contains(fs.getFormId())) {
            String platFormVersion = BcmLicenceControl.getPlatFormVersion();
            msg = BcmLicenceControl.checkRPA(fs, platFormVersion);
        }
        return msg;
    }

    private static String checkRPA(FormShowParameter fs, String platFormVersion) {
        if (StringUtils.isNotEmpty((String)platFormVersion) && platFormVersion.compareToIgnoreCase("5.0.011.0") >= 0) {
            return null;
        }
        if (!ConfigServiceHelper.getGlobalBoolParam((String)"isShowRPA")) {
            return String.format(ResManager.loadKDString((String)"\u8bf7\u5347\u7ea7\u5e73\u53f0\u7248\u672c\u5230%s\u53ca\u4ee5\u4e0a\uff0c\u5e76\u83b7\u53d6\u8bb8\u53ef\u540e\u91cd\u8bd5\u3002", (String)"BcmLicenceControl_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), "5.0.011.0");
        }
        return null;
    }

    public static boolean lessThanV6() {
        return (Boolean)ThreadCache.get((Object)"lessThanV6", () -> {
            String version = BcmLicenceControl.getPlatFormVersion();
            if (StringUtils.isNotEmpty((String)version) && version.compareToIgnoreCase(SHOW_LOCK_VERSION) >= 0) {
                return false;
            }
            return true;
        });
    }

    public static boolean lessThan602() {
        return (Boolean)ThreadCache.get((Object)"lessThan602", () -> {
            try {
                String version = BcmLicenceControl.getPlatFormCorrectVersion();
                Comparator<String> comparator = VersionService.getVersionComparetor();
                if (StringUtils.isNotEmpty((String)version) && comparator.compare(version, TREE_IMAGE_VERSION) >= 0) {
                    return false;
                }
                return true;
            }
            catch (Exception e) {
                return true;
            }
        });
    }

    public static void setStandardPlatformLicWindowMsg(PreOpenFormEventArgs evt, LicenseCheckResult checkResult) {
        try {
            if (invokeShowMessageWindowMethod != null && invokeGetShowMessageMethod != null) {
                invokeShowMessageWindowMethod.invoke((Object)evt, (String)invokeGetShowMessageMethod.invoke((Object)checkResult, new Object[0]));
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            log.error("Low platform version lic set StandardPlatform message error\uff1a" + e);
        }
    }

    public static void setCustomLicWindowMsg(PreOpenFormEventArgs evt, String customMsg) {
        try {
            if (invokeShowMessageWindowMethod != null && invokeGetShowMessageMethod != null) {
                invokeShowMessageWindowMethod.invoke((Object)evt, customMsg);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            log.error("Low platform version lic set custom message error\uff1a" + e);
        }
    }

    static {
        try {
            invokeShowMessageWindowMethod = PreOpenFormEventArgs.class.getDeclaredMethod("setCancelFormShowParameter", String.class);
            invokeGetShowMessageMethod = LicenseCheckResult.class.getDeclaredMethod("getCancelFormShowParameter", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            log.error("Low Platform Version Method is not exist.");
        }
    }
}

