/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.licence;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bcm.formplugin.licence.Version;

public class VersionService {
    private static Log logger = LogFactory.getLog(VersionService.class);

    public static Set<Version> getVersionInfos() {
        String sql = "select fid, fproductnumber, fversion, fupgradetime from t_bas_industry_version where fproductnumber = 'cosmic_bos' or fproductnumber like 'constellation_%';";
        HashSet<Version> versions = new HashSet<Version>();
        try {
            List allVersion = (List)DB.query((DBRoute)DBRoute.meta, (String)sql, resultSet -> {
                ArrayList<Version> result = new ArrayList<Version>(resultSet.getRow());
                while (resultSet.next()) {
                    Version version = new Version();
                    version.setId(resultSet.getString("fid"));
                    version.setVersion(resultSet.getString("fversion"));
                    version.setProductNumber(resultSet.getString("fproductnumber"));
                    version.setUpgradeTime(resultSet.getDate("fupgradetime"));
                    result.add(version);
                }
                return result;
            });
            for (Version version : allVersion) {
                if (!"cosmic_bos".equals(version.getProductNumber())) continue;
                versions.add(version);
                break;
            }
            allVersion.removeAll(versions);
            allVersion.stream().max(Comparator.comparing(Version::getVersion)).ifPresent(versions::add);
        }
        catch (Exception var5) {
            logger.error("\u67e5\u8be2\u53d1\u5e03\u7248\u672c\u4fe1\u606f\u5f02\u5e38...", (Throwable)var5);
        }
        return versions;
    }

    public static Set<Version> getVersionCorrectInfos() {
        String sql = "select fid, fproductnumber, fversion, fupgradetime from t_bas_industry_version where fproductnumber = 'cosmic_bos' or fproductnumber like 'constellation_%';";
        HashSet<Version> versions = new HashSet();
        try {
            List allVersion = (List)DB.query((DBRoute)DBRoute.meta, (String)sql, resultSet -> {
                ArrayList<Version> result = new ArrayList<Version>(resultSet.getRow());
                while (resultSet.next()) {
                    Version version = new Version();
                    version.setId(resultSet.getString("fid"));
                    version.setVersion(resultSet.getString("fversion"));
                    version.setProductNumber(resultSet.getString("fproductnumber"));
                    version.setUpgradeTime(resultSet.getDate("fupgradetime"));
                    result.add(version);
                }
                return result;
            });
            for (Version version : allVersion) {
                if (!"cosmic_bos".equals(version.getProductNumber())) continue;
                versions.add(version);
                break;
            }
            allVersion.removeAll(versions);
            Comparator comparator = (c1, c2) -> {
                String[] str2s;
                String[] str1s = c1.getVersion().split("\\.");
                int size = str1s.length > (str2s = c2.getVersion().split("\\.")).length ? str2s.length : str1s.length;
                for (int i = 0; i < size; ++i) {
                    if (Integer.valueOf(str1s[i]).compareTo(Integer.valueOf(str2s[i])) > 0) {
                        return 1;
                    }
                    if (Integer.valueOf(str1s[i]).compareTo(Integer.valueOf(str2s[i])) >= 0) continue;
                    return -1;
                }
                if (str1s.length > str2s.length) {
                    return 1;
                }
                if (str1s.length < str2s.length) {
                    return -1;
                }
                return 0;
            };
            allVersion.stream().max(comparator).ifPresent(versions::add);
        }
        catch (Exception var5) {
            versions = VersionService.getVersionInfos();
            logger.error("\u67e5\u8be2\u53d1\u5e03\u7248\u672c\u4fe1\u606f\u5f02\u5e38...", (Throwable)var5);
        }
        return versions;
    }

    public static Comparator<String> getVersionComparetor() {
        return (c1, c2) -> {
            String[] str2s;
            String[] str1s = c1.split("\\.");
            int size = str1s.length > (str2s = c2.split("\\.")).length ? str2s.length : str1s.length;
            for (int i = 0; i < size; ++i) {
                if (Integer.valueOf(str1s[i]).compareTo(Integer.valueOf(str2s[i])) > 0) {
                    return 1;
                }
                if (Integer.valueOf(str1s[i]).compareTo(Integer.valueOf(str2s[i])) >= 0) continue;
                return -1;
            }
            if (str1s.length > str2s.length) {
                return 1;
            }
            if (str1s.length < str2s.length) {
                return -1;
            }
            return 0;
        };
    }
}

