/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.linkagemapping;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FieldsetPanelAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.util.DataEntityUtils;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.database.BasedataEditSingleMemberF7;
import kd.fi.bcm.formplugin.util.SingleMemberF7Util;

public class LinkageDimSelect
extends AbstractBaseFormPlugin {
    private static final String f7MapCACHEKEY = "f7KeyValueMap";
    private static final String f7KeyPrefix = "bcm_";
    private static final String f7FieldsKey = "f7FieldsKey";
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private static final String NUMBER = "number";

    @Override
    public void initialize() {
        super.initialize();
        this.addClickListeners("btnok");
        this.bindCtrlMapping();
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Long modelId = (Long)fsp.getCustomParam("modelId");
        this.getPageCache().put("KEY_MODEL_ID", modelId.toString());
        this.initPage();
    }

    private void initPage() {
        this.initPageViewPanel();
        this.bindCtrlMapping();
        this.initDefaultFirstMemberFromModel();
        this.getView().updateView("fieldsetpanelap");
    }

    private void bindCtrlMapping() {
        String f7MapFields = this.getPageCache().get("f7MapFields");
        if (StringUtils.isEmpty((String)f7MapFields)) {
            return;
        }
        String[] fields = f7MapFields.split(";");
        MainEntityType mainEntityType = this.getModel().getDataEntityType();
        DataEntityPropertyCollection props = mainEntityType.getProperties();
        for (String field : fields) {
            if (props.containsKey((Object)field)) continue;
            DataEntityUtils.addBasedataF7ToMainEntity((Container)((Container)this.getControl("fieldsetpanelap")), (MainEntityType)mainEntityType, (String)field, (String)this.unpackEntityNumber(field), (IDataModel)this.getModel(), (IFormView)this.getView());
        }
    }

    private String unpackEntityNumber(String f7Key) {
        return f7Key.substring(0, f7Key.lastIndexOf(95));
    }

    private void initPageViewPanel() {
        FieldsetPanelAp fieldsetpanelap = new FieldsetPanelAp();
        fieldsetpanelap.setKey("fieldsetpanelap");
        fieldsetpanelap.setGrow(0);
        this.addF7Items((ContainerAp<Container>)fieldsetpanelap);
        this.getView().updateControlMetadata("fieldsetpanelap", fieldsetpanelap.createControl());
        StringBuilder sb = new StringBuilder();
        for (ControlAp ap : fieldsetpanelap.getItems()) {
            if (!ap.getKey().startsWith(f7KeyPrefix)) continue;
            sb.append(ap.getKey()).append(';');
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        this.getPageCache().put("f7MapFields", sb.toString());
        this.getView().updateView("fieldsetpanelap");
    }

    private void addF7Items(ContainerAp<Container> pageviewpanel) {
        BasedataField basedata = null;
        HashMap<String, Long> f7KeyValueMap = new HashMap<String, Long>();
        DynamicObjectCollection dimensionBaseInfos = QueryDimensionServiceHelper.getDimensionBaseInfos((Object)this.getModelId());
        HashMap<String, String> f7Fields = new HashMap<String, String>();
        for (DynamicObject dy : dimensionBaseInfos) {
            String membermodel = dy.getString("membermodel");
            if (!"bcm_accountmembertree".equals(membermodel) && !"bcm_changetypemembertree".equals(membermodel) && !"bcm_icmembertree".equals(membermodel) && !"bcm_userdefinedmembertree".equals(membermodel) && !"bcm_mycompanymembertree".equals(membermodel) && !"bcm_audittrialmembertree".equals(membermodel)) continue;
            EntryFieldAp f7Field = new EntryFieldAp();
            basedata = new BasedataField();
            basedata.setViewDetail(false);
            f7Field.setName(new LocaleString(dy.getString("name")));
            String f7key = (membermodel + "_" + dy.getString(NUMBER)).toLowerCase(Locale.ENGLISH);
            f7Fields.put(f7key, dy.getString("name") + "|" + dy.getString(NUMBER));
            f7Field.setKey(f7key);
            f7Field.setLabelDirection("h");
            f7Field.setField((Field)basedata);
            f7Field.setFieldTextAlign("center");
            f7Field.setAlignSelf("center");
            f7Field.setTextAlign("left");
            f7Field.setFontSize(12);
            f7Field.setQuickAddNew(false);
            Style style = new Style();
            Margin margin = new Margin();
            margin.setRight("1px");
            margin.setTop("1px");
            margin.setBottom("10px");
            style.setMargin(margin);
            f7Field.setStyle(style);
            basedata.setKey(membermodel);
            basedata.setBaseEntityId(membermodel);
            f7Field.setField((Field)basedata);
            f7KeyValueMap.put(this.splitDimNumByF7key(f7key), dy.getLong("id"));
            pageviewpanel.getItems().add(f7Field);
        }
        this.getPageCache().put(f7MapCACHEKEY, SerializationUtils.toJsonString(f7KeyValueMap));
        this.getPageCache().put(f7FieldsKey, this.toByteSerialized(f7Fields));
    }

    private String splitDimNumByF7key(String f7key) {
        return f7key.substring(f7key.lastIndexOf(95) + 1);
    }

    private void initDefaultFirstMemberFromModel() {
        String defaultDim = (String)this.getView().getFormShowParameter().getCustomParam("defaultDim");
        if (defaultDim != null) {
            List list = (List)this.deSerializedBytes(defaultDim);
            for (Map member : list) {
                String entityNum = member.get("membermodel").toString();
                String actionId = this.sugarF7Key(entityNum, member.get("dimNum").toString());
                DynamicObject memberDyna = BusinessDataServiceHelper.newDynamicObject((String)entityNum);
                memberDyna.set("id", member.get("id"));
                memberDyna.set(NUMBER, member.get(NUMBER));
                String textValue = (Boolean)member.get("isleaf") != false ? member.get("name").toString() : String.format(ResManager.loadKDString((String)"%s\u7684\u6240\u6709\u4e0b\u7ea7\u660e\u7ec6\u6210\u5458", (String)"LinkageDimSelect_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), member.get("name"));
                memberDyna.set("name", (Object)textValue);
                this.getModel().setValue(actionId, (Object)memberDyna);
                this.getView().updateView(actionId);
            }
        }
    }

    @Override
    protected String sugarF7Key(String memberEntityNumber, String dimNumber) {
        return (memberEntityNumber + "_" + dimNumber).toLowerCase(Locale.ENGLISH);
    }

    @Override
    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String ctrlKey = e.getKey();
        if (ctrlKey.startsWith(f7KeyPrefix)) {
            String dimNum = this.splitDimNumByF7key(ctrlKey);
            long dimId = 0L;
            Map f7map = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(f7MapCACHEKEY), Map.class);
            dimId = Long.parseLong(String.valueOf(f7map.get(dimNum)));
            if (dimId == 0L) {
                throw new KDBizException("not found dimension number ->" + dimNum);
            }
            SingleF7TypeEnum f7Type = ctrlKey.contains("changetype") ? SingleF7TypeEnum.LEAF : SingleF7TypeEnum.COMMON;
            BasedataEditSingleMemberF7 sf7 = SingleMemberF7Util.createBasedataEditSingleMemberF7(this.getView(), this.getModel(), this.getModelId(), dimId, ctrlKey, this, false, f7Type);
            sf7.setCallBackClassName(this.getClass().getName());
            sf7.setF7title(ResManager.loadKDString((String)"\u6210\u5458\u9009\u62e9", (String)"LinkageDimSelect_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            QFBuilder qfBuilder = new QFBuilder("dimension", "=", (Object)dimId);
            if (ctrlKey.contains("changetype")) {
                qfBuilder.add("isleaf", "=", (Object)true);
            }
            if (ctrlKey.contains("audittrial")) {
                sf7.setCustomFilter(new QFilter("datasource", "not in", (Object)new String[]{"1", "5", "4"}));
            }
            sf7.setQFilters(qfBuilder.toList());
            e.setControl((Control)sf7);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        DynamicObject dy;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.startsWith("bcm") && (dy = (DynamicObject)closedCallBackEvent.getReturnData()) != null) {
            String textValue = dy.getBoolean("isleaf") ? dy.getString("name") : String.format(ResManager.loadKDString((String)"%s\u7684\u6240\u6709\u4e0b\u7ea7\u660e\u7ec6\u6210\u5458", (String)"LinkageDimSelect_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), dy.getString("name"));
            DynamicObject memberDyna = BusinessDataServiceHelper.newDynamicObject((String)actionId.substring(0, actionId.lastIndexOf(95)));
            memberDyna.set("id", (Object)dy.getLong("id"));
            memberDyna.set("name", (Object)textValue);
            memberDyna.set(NUMBER, (Object)dy.getString(NUMBER));
            memberDyna.set("isleaf", (Object)dy.getBoolean("isleaf"));
            this.getModel().setValue(actionId, (Object)memberDyna);
            this.getView().updateView(actionId);
        }
    }

    @Override
    public void click(EventObject evt) {
        Button btn = (Button)evt.getSource();
        String key = btn.getKey();
        if (key.equals("btnok")) {
            Map f7Fields = (Map)this.deSerializedBytes(this.getPageCache().get(f7FieldsKey));
            HashMap<String, String> showDimmembers = new HashMap<String, String>(16);
            for (Map.Entry entry : f7Fields.entrySet()) {
                DynamicObject dy = (DynamicObject)this.getModel().getValue((String)entry.getKey());
                String[] nameAndNumber = ((String)entry.getValue()).split("\\|");
                if (dy == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9", (String)"LinkageDimSelect_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]).concat(nameAndNumber[0]).concat("\u3002"));
                    return;
                }
                showDimmembers.put(nameAndNumber[1], dy.getString(NUMBER));
            }
            this.getView().returnDataToParent(showDimmembers);
            this.getView().close();
        }
    }

    @Override
    public void getEntityType(GetEntityTypeEventArgs e) {
        try {
            e.setNewEntityType((MainEntityType)e.getOriginalEntityType().clone());
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }
}

