/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.linkagemapping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.IDataModelChangeListener;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.container.TabPage;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.adjust.link.LinkageMappingServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.permission.permclass.PermClassCache;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.common.Recorder;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.LinkageTypeEnum;
import kd.fi.bcm.common.enums.Permission.DataTypeEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.pageinteraction.CommandParam;
import kd.fi.bcm.formplugin.pageinteraction.MainPage;
import kd.fi.bcm.formplugin.report.multi.ReportTabInfo;
import kd.fi.bcm.formplugin.report.multi.ReportTabManager;
import kd.fi.bcm.formplugin.util.CodeRuleUtil;
import kd.fi.bcm.formplugin.util.EffectiveYearPeriodUtil;
import kd.fi.bcm.spread.model.StatusBarModel;
import org.apache.commons.collections.CollectionUtils;

public class LinkageMappingAddPlugin
extends AbstractBaseFormPlugin
implements MainPage {
    private static final String entity = "entity";
    private static final String tabpageap = "tabpageap";
    private static final String dimensions_cache_key = "dimensions_cache_key";
    private static final String userdim_cache_key = "userdim_cache_key";
    private static final String select_table_row = "select_table_row";
    private static final String CURRENT_TABINDEX = "current_tabindex";
    private static final String CURRENT_TEMPLATE_ID = "current_templateId";
    private static final String enter_templateNumber = "enter_templateNumber";
    private static final String IDS_KEY = "ids_key";
    private static final String previous_or_next = "previous_or_next";
    private static final String showStyle_key = "showStyle_key";
    private static final String selectnames_cache_key = "selectnames_cache_key";
    private static final String selectnumbers_cache_key = "selectnumbers_cache_key";
    private static final String groupNames_key = "groupNames_key";
    public static final String SCENARIOSET = "scenarioset";
    public static final String APPLYENTITY = "applyentity";
    private static final String DATA_NOPERM_FLAG = "dataNoPermFlag";
    private String[] groupNames_default = new String[]{ResManager.loadKDString((String)"\u7ec4\u4e00", (String)"LinkageMappingAddPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ec4\u4e8c", (String)"LinkageMappingAddPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ec4\u4e09", (String)"LinkageMappingAddPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ec4\u56db", (String)"LinkageMappingAddPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ec4\u4e94", (String)"LinkageMappingAddPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ec4\u516d", (String)"LinkageMappingAddPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ec4\u4e03", (String)"LinkageMappingAddPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ec4\u516b", (String)"LinkageMappingAddPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ec4\u4e5d", (String)"LinkageMappingAddPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ec4\u5341", (String)"LinkageMappingAddPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0])};
    private static String[] columes = new String[]{"showtext", "linkagetype", "weight", "operator", "template", "account", "audittrial", "changetype", "mycompany", "intercompany", "userdefined1", "userdefined2", "userdefined3", "userdefined4", "userdefined5", "userdefined6", "dimshow", "accountrange", "changetyperange", "mycompanyRange", "intercompanyrange", "userdefinedrange1", "userdefinedrange2", "userdefinedrange3", "userdefinedrange4", "userdefinedrange5", "userdefinedrange6"};
    private static String[] dimWhitMyCompanyArray = new String[]{"account", "changetype", "mycompany", "intercompany", "audittrial"};
    private static String[] dimArray = new String[]{"account", "changetype", "intercompany", "audittrial"};
    private static String[] memberModelsWhitMyCompany = new String[]{"bcm_accountmembertree", "bcm_changetypemembertree", "bcm_mycompanymembertree", "bcm_icmembertree", "bcm_audittrialmembertree"};
    private static String[] memberModels = new String[]{"bcm_accountmembertree", "bcm_changetypemembertree", "bcm_icmembertree", "bcm_audittrialmembertree"};
    private static final String CHANGEDATA = "changedatasave";

    private OpNameMultiLangEnumBridge getOperationSave() {
        return new OpNameMultiLangEnumBridge("\u4fdd\u5b58", "LinkageMappingAddPlugin_0", "fi-bcm-formplugin", "Save");
    }

    private String getOperationStstusSuccess() {
        return ResManager.loadKDString((String)"\u6210\u529f", (String)"LinkageMappingAddPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    @Override
    public void initialize() {
        super.initialize();
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener(arg0 -> {
            String tab1 = arg0.getTabKey();
            IPageCache pageCache = this.getPageCache();
            pageCache.put(CURRENT_TABINDEX, tab1.split(tabpageap)[1]);
        });
        for (int i = 1; i < 10; ++i) {
            EntryGrid entryentity = (EntryGrid)this.getControl(entity + i);
            entryentity.addCellClickListener(new CellClickListener(){

                public void cellDoubleClick(CellClickEvent arg0) {
                    if (arg0.getFieldKey().contains("showtext")) {
                        LinkageMappingAddPlugin.this.openLinkageDimSelectForm(arg0.getRow());
                    }
                }

                public void cellClick(CellClickEvent arg0) {
                }
            });
            entryentity.addRowClickListener(new RowClickEventListener(){

                public void entryRowClick(RowClickEvent evt) {
                    LinkageMappingAddPlugin.this.getPageCache().put(LinkageMappingAddPlugin.select_table_row, String.valueOf(evt.getRow()));
                }
            });
        }
    }

    private void openLinkageDimSelectForm(int row) {
        int tabIndex = Integer.parseInt(this.getPageCache().get(CURRENT_TABINDEX));
        DynamicObject toView = this.getModel().getEntryRowEntity(entity + tabIndex, row);
        ArrayList list = null;
        if (toView.get("showtext" + tabIndex) != null && !StringUtils.isBlank((CharSequence)toView.get("showtext" + tabIndex).toString())) {
            int i;
            boolean isSpptMyCompany = DimensionServiceHelper.existsMyCompanyDim((long)this.getModelId());
            String[] dims = isSpptMyCompany ? dimWhitMyCompanyArray : dimArray;
            String[] membermodels = isSpptMyCompany ? memberModelsWhitMyCompany : memberModels;
            list = new ArrayList(dims.length);
            for (i = 0; i < dims.length; ++i) {
                String memId = toView.getString(dims[i] + tabIndex);
                DynamicObject memMsg = QueryDimensionServiceHelper.getMemMsgById((String)memId, (String)membermodels[i]);
                if (memMsg == null) continue;
                HashMap<String, Object> mem = new HashMap<String, Object>();
                mem.put("id", memId);
                mem.put("name", memMsg.getString("name"));
                mem.put("number", memMsg.get("number"));
                mem.put("isleaf", memMsg.get("isleaf"));
                mem.put("membermodel", membermodels[i]);
                mem.put("dimNum", memMsg.get("dimension.number"));
                list.add(mem);
            }
            for (i = 1; i <= 6; ++i) {
                long id = toView.getLong("userdefined" + i + tabIndex);
                if (id == 0L) continue;
                DynamicObject memMsg = QueryDimensionServiceHelper.getMemMsgById((String)String.valueOf(id), (String)"bcm_userdefinedmembertree");
                HashMap<String, Object> mem = new HashMap<String, Object>();
                mem.put("id", id);
                mem.put("name", memMsg.getString("name"));
                mem.put("number", memMsg.get("number"));
                mem.put("isleaf", memMsg.get("isleaf"));
                mem.put("membermodel", "bcm_userdefinedmembertree");
                mem.put("dimNum", memMsg.get("dimension.number"));
                list.add(mem);
            }
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bcm_linkagedimselect");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("modelId", (Object)this.getModelId());
        if (list != null) {
            showParameter.setCustomParam("defaultDim", (Object)this.toByteSerialized(list));
        }
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "backfill");
        showParameter.setCloseCallBack(callBack);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        if ("backfill".equals(actionId)) {
            IPageCache pageCache = this.getPageCache();
            Map showDimmembers = (Map)evt.getReturnData();
            if (showDimmembers != null) {
                this.setIsChange(true);
                this.setRowText(Integer.parseInt(pageCache.get(CURRENT_TABINDEX)), Integer.parseInt(pageCache.get(select_table_row)), showDimmembers, false, false);
            }
        } else if ("dimShowSelect".equals(actionId)) {
            Map returnData = (Map)evt.getReturnData();
            if (returnData != null) {
                this.getPageCache().put(returnData);
                this.refreshNameOrNumber();
            }
        } else if ("baseInfo".equals(actionId)) {
            Map returnData = (Map)evt.getReturnData();
            if (returnData != null) {
                this.setIsChange(true);
                this.getPageCache().put("baseInfo", this.toByteSerialized(returnData));
            }
        } else if ("addBaseInfo".equals(actionId)) {
            Map returnData = (Map)evt.getReturnData();
            if (returnData != null) {
                this.clearShowData(returnData);
                CommandParam com = new CommandParam("bcm_linkagemappingconfig", "bcm_linkagescopeofcreate", "bar_add", new Object[0]);
                this.sendMsg(this.getView(), com);
            }
        } else if ("modifyGroupName".equals(actionId)) {
            IPageCache pageCache = this.getPageCache();
            String returnData = (String)evt.getReturnData();
            if (returnData != null) {
                this.setIsChange(true);
                String currentTabIndex = pageCache.get(CURRENT_TABINDEX);
                TabPage page = (TabPage)this.getControl(tabpageap + currentTabIndex);
                page.setText(new LocaleString(returnData));
                Map groupNames = (Map)this.deSerializedBytes(pageCache.get(groupNames_key));
                groupNames.put(currentTabIndex, returnData);
                pageCache.put(groupNames_key, this.toByteSerialized(groupNames));
            }
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners("toolbar");
        this.getModel().addDataModelChangeListener(new IDataModelChangeListener(){

            public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
                int size = LinkageMappingAddPlugin.this.getModel().getEntryEntity(e.getEntryProp().getName()).size();
                if (size == 1) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u81f3\u5c11\u4fdd\u7559\u4e00\u884c\uff0c\u5982\u6709\u9700\u8981\u8bf7\u5220\u9664\u8be5\u7ec4\u3002", (String)"LinkageMappingAddPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                LinkageMappingAddPlugin.this.setIsChange(true);
            }

            public void afterAddRow(AfterAddRowEventArgs e) {
                if (e.getInsertRow() == -1) {
                    return;
                }
                LinkageMappingAddPlugin.this.setIsChange(true);
            }
        });
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initCaches();
        this.setEditData();
        this.showFromView("bottom_template", "bcm_adjusttemplate_tmp");
    }

    private boolean isEnable() {
        DynamicObject currentLinkage = this.getCurrentLinkage();
        return currentLinkage != null && currentLinkage.getBoolean("status");
    }

    private DynamicObject getCurrentLinkage() {
        String viewId = this.getPageCache().get("viewId");
        if (StringUtils.isBlank((CharSequence)viewId) && StringUtils.isBlank((CharSequence)(viewId = (String)this.getView().getFormShowParameter().getCustomParam("viewId")))) {
            return null;
        }
        try {
            return BusinessDataServiceHelper.loadSingle((Object)viewId, (String)"bcm_linkagemapping");
        }
        catch (Throwable t) {
            return null;
        }
    }

    private void setToolBarStyle() {
        boolean noPerm = "1".equals(this.getPageCache().get(DATA_NOPERM_FLAG));
        boolean flag = !this.isEnable() && !noPerm;
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"bar_save"});
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"bar_addgroup", "bar_delgroup"});
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"bar_modifygroupname"});
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"bar_add"});
        this.getView().setEnable(Boolean.valueOf(!noPerm), new String[]{"bar_enable", "bar_disable"});
    }

    private void setEditData() {
        String viewId = (String)this.getView().getFormShowParameter().getCustomParam("viewId");
        if (StringUtils.isBlank((CharSequence)viewId)) {
            return;
        }
        IPageCache pageCache = this.getPageCache();
        Map<Integer, List<DynamicObject>> viewData = this.queryById(Long.parseLong(viewId));
        this.viewDimensionInfo(Long.valueOf(viewId), viewData);
        this.setSelect(pageCache.get(CURRENT_TABINDEX));
        this.setToolBarStyle();
    }

    private void initCaches() {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Long modelId = (Long)fsp.getCustomParam("modelId");
        DynamicObjectCollection dimensionBaseInfos = QueryDimensionServiceHelper.getDimensionBaseInfos((Object)modelId);
        LinkedHashMap dimensions = new LinkedHashMap();
        HashMap userDimensions = new HashMap();
        ArrayList defaultSelectDims = new ArrayList();
        dimensionBaseInfos.forEach(d -> {
            String number = d.getString("number");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", d.getLong("id"));
            map.put("name", d.getString("name"));
            map.put("number", number);
            map.put("membermodel", d.getString("membermodel"));
            map.put("issysdimension", d.getBoolean("issysdimension"));
            map.put("fieldmapped", d.getString("fieldmapped"));
            map.put("dseq", d.getInt("dseq"));
            dimensions.put(number, map);
            if (DimTypesEnum.ACCOUNT.getNumber().equals(number) || DimTypesEnum.INTERCOMPANY.getNumber().equals(number) || DimTypesEnum.CHANGETYPE.getNumber().equals(number) || !d.getBoolean("issysdimension") || DimTypesEnum.MYCOMPANY.getNumber().equals(number) || DimTypesEnum.AUDITTRIAL.getNumber().equals(number)) {
                defaultSelectDims.add(number);
            }
            if (!d.getBoolean("issysdimension")) {
                userDimensions.put(d.getString("number"), map);
            }
        });
        HashMap<String, String> batchCache = new HashMap<String, String>();
        batchCache.put(dimensions_cache_key, this.toByteSerialized(dimensions));
        batchCache.put(userdim_cache_key, this.toByteSerialized(userDimensions));
        batchCache.put(CURRENT_TABINDEX, "1");
        batchCache.put("KEY_MODEL_ID", modelId.toString());
        batchCache.put(selectnames_cache_key, this.toByteSerialized(defaultSelectDims));
        batchCache.put(selectnumbers_cache_key, this.toByteSerialized(defaultSelectDims));
        if (fsp.getCustomParam("selectIds") != null) {
            batchCache.put(IDS_KEY, this.toByteSerialized(fsp.getCustomParam("selectIds")));
        } else {
            batchCache.put(IDS_KEY, this.toByteSerialized(new ArrayList(16)));
        }
        batchCache.put(showStyle_key, "name");
        String viewId = (String)fsp.getCustomParam("viewId");
        if (StringUtils.isBlank((CharSequence)viewId)) {
            batchCache.put("baseInfo", this.toByteSerialized(fsp.getCustomParam("baseInfo")));
            batchCache.put("isAddFromListPage", "true");
            this.setTabPageApVisible(new boolean[]{true, true, false, false, false, false, false, false, false, false});
            HashMap<String, String> groupNames = new HashMap<String, String>(10);
            for (int i = 1; i <= 10; ++i) {
                groupNames.put(String.valueOf(i), this.groupNames_default[i - 1]);
            }
            batchCache.put(groupNames_key, this.toByteSerialized(groupNames));
        }
        String enterTemplateId = (String)fsp.getCustomParam("templateId");
        this.getPageCache().put(batchCache);
        if ("0".equals(enterTemplateId)) {
            this.getPageCache().put(enter_templateNumber, "DEFAULT");
        } else {
            TemplateModel template = this.loadTreeClick(enterTemplateId);
            if (template != null) {
                this.getPageCache().put(enter_templateNumber, template.getNumber());
            } else {
                this.getPageCache().put(enter_templateNumber, "DEFAULT");
            }
        }
    }

    private void setRowText(Object entryObj) {
        Map firstRowMap;
        Map entryMap;
        if (entryObj instanceof Map && !(entryMap = (Map)entryObj).isEmpty()) {
            Map.Entry next = entryMap.entrySet().iterator().next();
            firstRowMap = (Map)next.getValue();
            String key = (String)next.getKey();
            String[] split = key.split("_");
            if (split.length > 0) {
                this.getPageCache().put(CURRENT_TEMPLATE_ID, split[0]);
            }
        } else {
            firstRowMap = Collections.emptyMap();
        }
        if (!firstRowMap.isEmpty()) {
            Map<String, String> dim2MemberNumber = this.toStringStringMap(firstRowMap);
            IPageCache pageCache = this.getPageCache();
            int currentTabIndex = Integer.parseInt(pageCache.get(CURRENT_TABINDEX));
            EntryGrid entryEntity = (EntryGrid)this.getControl(entity + currentTabIndex);
            int selectRow = 0;
            int[] selectRows = entryEntity.getSelectRows();
            if (selectRows.length == 0) {
                if (pageCache.get("viewId") != null) {
                    return;
                }
            } else {
                selectRow = selectRows[0];
            }
            this.setRowText(currentTabIndex, selectRow, dim2MemberNumber, false, true);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u586b\u5199\u4efb\u4f55\u503c\u3002", (String)"LinkageMappingAddPlugin_49", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private Map<String, String> toStringStringMap(Map<?, ?> firstRowMap) {
        if (firstRowMap.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> stringStringMap = new HashMap<String, String>();
        firstRowMap.entrySet().stream().filter(entry -> entry.getKey() instanceof String && entry.getValue() instanceof String).forEach(entry -> stringStringMap.put((String)entry.getKey(), (String)entry.getValue()));
        return stringStringMap;
    }

    private void setRowText(int currentTabIndex, int selectRow, Map<String, String> showDimmembers, boolean isChangeStyle, boolean isFromSelectCell) {
        int i;
        IPageCache pageCache = this.getPageCache();
        String selectTable = entity + currentTabIndex;
        DynamicObject select = this.getModel().getEntryRowEntity(selectTable, selectRow);
        while (select == null) {
            this.getModel().createNewEntryRow(selectTable);
            select = this.getModel().getEntryRowEntity(selectTable, selectRow);
        }
        boolean isShowName = "name".equals(pageCache.get(showStyle_key));
        List selectDims = isShowName ? (List)this.deSerializedBytes(pageCache.get(selectnames_cache_key)) : (List)this.deSerializedBytes(pageCache.get(selectnumbers_cache_key));
        String account = null;
        int accountRange = 0;
        String audittrial = null;
        String changetype = null;
        String mycompany = null;
        int mycompanyRange = 0;
        String intercompany = null;
        int intercompanyRange = 0;
        int audittrialRange = 0;
        String[] userDefined = new String[6];
        int[] userDefinedRange = new int[6];
        String[] showOrder = new String[11];
        String[] dimShowData = new String[11];
        Map userDimensions = (Map)this.deSerializedBytes(pageCache.get(userdim_cache_key));
        for (Map.Entry<String, String> entry : showDimmembers.entrySet()) {
            String rangeText;
            String key = entry.getKey();
            Map<String, Object> dimensionInfo = this.getDimensionInfo(key);
            Map<String, Object> memberInfo = this.getMemberInfo(key, entry.getValue());
            boolean isleaf = Boolean.parseBoolean(memberInfo.get("isleaf").toString());
            String storagetype = memberInfo.get("storagetype").toString();
            if (isFromSelectCell && DimTypesEnum.CHANGETYPE.getNumber().equals(key) && (!isleaf || StorageTypeEnum.LABEL.index.equals(storagetype))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u975e\u660e\u7ec6\u6210\u5458\u6216\u6807\u7b7e\u7c7b\u6210\u5458\u4e0d\u5141\u8bb8\u9009\u62e9\u5355\u5143\u683c\u3002", (String)"LinkageMappingAddPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            String string = rangeText = isleaf ? "\u3010%1$s\uff01%2$s\u3011 " : ResManager.loadKDString((String)"\u3010%1$s\uff01%2$s\u7684\u6240\u6709\u4e0b\u7ea7\u660e\u7ec6\u6210\u5458\u3011 ", (String)"LinkageMappingAddPlugin_50", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            if (DimTypesEnum.ACCOUNT.getNumber().equals(key)) {
                account = memberInfo.get("id").toString();
                showOrder[0] = isShowName ? String.format(rangeText, dimensionInfo.get("name"), memberInfo.get("name")) : String.format(rangeText, dimensionInfo.get("number"), memberInfo.get("number"));
                dimShowData[0] = String.format(rangeText, dimensionInfo.get("name"), memberInfo.get("name"));
                accountRange = isleaf ? RangeEnum.VALUE_10.getValue() : RangeEnum.VALUE_90.getValue();
                continue;
            }
            if (DimTypesEnum.AUDITTRIAL.getNumber().equals(key)) {
                audittrial = memberInfo.get("id").toString();
                showOrder[1] = isShowName ? String.format(rangeText, dimensionInfo.get("name"), memberInfo.get("name")) : String.format(rangeText, dimensionInfo.get("number"), memberInfo.get("number"));
                dimShowData[1] = String.format(rangeText, dimensionInfo.get("name"), memberInfo.get("name"));
                audittrialRange = isleaf ? RangeEnum.VALUE_10.getValue() : RangeEnum.VALUE_90.getValue();
                continue;
            }
            if (this.isExistChangeTypeDimension() && DimTypesEnum.CHANGETYPE.getNumber().equals(key)) {
                changetype = memberInfo.get("id").toString();
                if (selectDims.contains(key)) {
                    showOrder[2] = isShowName ? String.format(rangeText, dimensionInfo.get("name"), memberInfo.get("name")) : String.format(rangeText, dimensionInfo.get("number"), memberInfo.get("number"));
                }
                dimShowData[2] = String.format(rangeText, dimensionInfo.get("name"), memberInfo.get("name"));
                continue;
            }
            if (DimTypesEnum.MYCOMPANY.getNumber().equals(key)) {
                mycompany = memberInfo.get("id").toString();
                if (selectDims.contains(key)) {
                    showOrder[3] = isShowName ? String.format(rangeText, dimensionInfo.get("name"), memberInfo.get("name")) : String.format(rangeText, dimensionInfo.get("number"), memberInfo.get("number"));
                }
                dimShowData[3] = String.format(rangeText, dimensionInfo.get("name"), memberInfo.get("name"));
                mycompanyRange = isleaf ? RangeEnum.VALUE_10.getValue() : RangeEnum.VALUE_90.getValue();
                continue;
            }
            if (DimTypesEnum.INTERCOMPANY.getNumber().equals(key)) {
                intercompany = memberInfo.get("id").toString();
                if (selectDims.contains(key)) {
                    showOrder[4] = isShowName ? String.format(rangeText, dimensionInfo.get("name"), memberInfo.get("name")) : String.format(rangeText, dimensionInfo.get("number"), memberInfo.get("number"));
                }
                dimShowData[4] = String.format(rangeText, dimensionInfo.get("name"), memberInfo.get("name"));
                intercompanyRange = isleaf ? RangeEnum.VALUE_10.getValue() : RangeEnum.VALUE_90.getValue();
                continue;
            }
            if (!userDimensions.containsKey(key)) continue;
            String fieldmapped = dimensionInfo.get("fieldmapped").toString();
            int userDefinedIndex = Integer.parseInt(fieldmapped.substring(3));
            userDefined[userDefinedIndex - 1] = memberInfo.get("id").toString();
            int fieldIndex = 4 + userDefinedIndex;
            if (selectDims.contains(key)) {
                showOrder[fieldIndex] = isShowName ? String.format(rangeText, dimensionInfo.get("name"), memberInfo.get("name")) : String.format(rangeText, dimensionInfo.get("number"), memberInfo.get("number"));
            }
            dimShowData[fieldIndex] = String.format(rangeText, dimensionInfo.get("name"), memberInfo.get("name"));
            userDefinedRange[userDefinedIndex - 1] = isleaf ? RangeEnum.VALUE_10.getValue() : RangeEnum.VALUE_90.getValue();
        }
        StringBuilder showSb = new StringBuilder();
        StringBuilder dimShow = new StringBuilder();
        for (i = 0; i < showOrder.length; ++i) {
            if (StringUtils.isBlank((CharSequence)showOrder[i])) continue;
            showSb.append(showOrder[i]);
        }
        for (i = 0; i < dimShowData.length; ++i) {
            if (StringUtils.isBlank((CharSequence)dimShowData[i])) continue;
            dimShow.append(dimShowData[i]);
        }
        this.getModel().setValue("showtext" + currentTabIndex, (Object)showSb.toString(), selectRow);
        if (isChangeStyle) {
            return;
        }
        this.getModel().setValue("account" + currentTabIndex, (Object)account, selectRow);
        this.getModel().setValue("accountrange" + currentTabIndex, (Object)accountRange, selectRow);
        this.getModel().setValue("audittrial" + currentTabIndex, (Object)audittrial, selectRow);
        this.getModel().setValue("audittrialrange" + currentTabIndex, (Object)audittrialRange, selectRow);
        this.getModel().setValue("changetype" + currentTabIndex, (Object)changetype, selectRow);
        this.getModel().setValue("mycompany" + currentTabIndex, (Object)mycompany, selectRow);
        this.getModel().setValue("mycompanyrange" + currentTabIndex, (Object)mycompanyRange, selectRow);
        this.getModel().setValue("intercompany" + currentTabIndex, (Object)intercompany, selectRow);
        this.getModel().setValue("intercompanyrange" + currentTabIndex, (Object)intercompanyRange, selectRow);
        if (isFromSelectCell) {
            String templateId = pageCache.get(CURRENT_TEMPLATE_ID);
            this.getModel().setValue("template" + currentTabIndex, (Object)templateId, selectRow);
        } else if (StringUtils.isBlank((CharSequence)this.getModel().getValue("template" + currentTabIndex, selectRow).toString())) {
            this.getModel().setValue("template" + currentTabIndex, (Object)0, selectRow);
        }
        for (int i2 = 0; i2 < userDefined.length; ++i2) {
            if (!StringUtils.isBlank((CharSequence)userDefined[i2])) {
                this.getModel().setValue("userdefined" + (i2 + 1) + currentTabIndex, (Object)userDefined[i2], selectRow);
                this.getModel().setValue("userdefinedrange" + (i2 + 1) + currentTabIndex, (Object)userDefinedRange[i2], selectRow);
                continue;
            }
            this.getModel().setValue("userdefined" + (i2 + 1) + currentTabIndex, (Object)0, selectRow);
        }
        this.getModel().setValue("dimshow" + currentTabIndex, (Object)dimShow.toString(), selectRow);
        String setDimensionStr = pageCache.get("setDimension");
        Map setDimensionMap = null;
        setDimensionMap = setDimensionStr != null ? (Map)this.deSerializedBytes(setDimensionStr) : new LinkedHashMap();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("currentTabIndex", currentTabIndex);
        map.put("selectRow", selectRow);
        map.put("showDimmembers", showDimmembers);
        setDimensionMap.put(String.valueOf(currentTabIndex) + selectRow, map);
        pageCache.put("setDimension", this.toByteSerialized(setDimensionMap));
    }

    private Map<String, Object> getDimensionInfo(String dimemsionNumber) {
        IPageCache pageCache = this.getPageCache();
        String strDimensions = pageCache.get(dimensions_cache_key);
        Map dimensions = (Map)this.deSerializedBytes(strDimensions);
        return (Map)dimensions.get(dimemsionNumber);
    }

    private Map<String, Object> getMemberInfo(String dimemsionNumber, String memberNumber) {
        IDNumberTreeNode memNode = MemberReader.findMemberByNumber((String)this.getCurModelNumber(), (String)dimemsionNumber, (String)memberNumber);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", memNode.getId());
        map.put("name", memNode.getName());
        map.put("number", memNode.getNumber());
        map.put("isleaf", memNode.isLeaf());
        map.put("storagetype", memNode.getStorageType().index);
        return map;
    }

    @Override
    public void checkPerm(String opkey) {
        if ("bar_close".equals(opkey) || "bar_next".equals(opkey) || "bar_previous".equals(opkey) || "bar_showname".equals(opkey) || "bar_shownum".equals(opkey)) {
            return;
        }
        if ("bar_disable".equals(opkey) || "bar_enable".equals(opkey)) {
            super.checkPerm(opkey, "bcm_linkagemappinglist");
        } else {
            super.checkPerm("bar_updatelinktag", "bcm_linkagemappinglist");
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("bar_add".equals(key)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("bcm_linkagebaseinfoset");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCustomParam("number", (Object)(this.getPageCache().get(enter_templateNumber) + "-" + CodeRuleUtil.getCodeRuleNumber("bcm_linkagemapping", "modifytime")));
            showParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
            showParameter.setCustomParam("KEY_SCENARIO_ID", (Object)this.getScenarioId());
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "addBaseInfo");
            showParameter.setCloseCallBack(callBack);
            this.getView().showForm(showParameter);
        } else if ("bar_save".equals(key)) {
            this.actionSave();
        } else if ("bar_previous".equals(key)) {
            IPageCache pageCache = this.getPageCache();
            List ids = (List)this.deSerializedBytes(pageCache.get(IDS_KEY));
            String viewId = pageCache.get("viewId");
            if (StringUtils.isBlank((CharSequence)viewId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6620\u5c04\u4fe1\u606f\u3002", (String)"LinkageMappingAddPlugin_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            int indexInt = ids.indexOf(LongUtil.toLong((Object)pageCache.get("viewId")));
            if (--indexInt < 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u662f\u7b2c\u4e00\u6761\u6570\u636e\u3002", (String)"LinkageMappingAddPlugin_23", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            Long id = (Long)ids.get(indexInt);
            HashMap<String, Number> param = new HashMap<String, Number>();
            param.put("id", id);
            param.put("indexInt", indexInt);
            CommandParam com = new CommandParam("bcm_linkagescopeofcreate", "bcm_linkagemappingconfig", "bar_previous", param);
            this.sendMsg(this.getView(), com);
        } else if ("bar_next".equals(key)) {
            IPageCache pageCache = this.getPageCache();
            List ids = (List)this.deSerializedBytes(pageCache.get(IDS_KEY));
            String viewId = pageCache.get("viewId");
            if (StringUtils.isBlank((CharSequence)viewId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6620\u5c04\u4fe1\u606f\u3002", (String)"LinkageMappingAddPlugin_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            int indexInt = ids.indexOf(LongUtil.toLong((Object)pageCache.get("viewId")));
            if (++indexInt > ids.size() - 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u662f\u6700\u540e\u4e00\u6761\u6570\u636e\u3002", (String)"LinkageMappingAddPlugin_24", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            Long id = (Long)ids.get(indexInt);
            HashMap<String, Number> param = new HashMap<String, Number>();
            param.put("id", id);
            param.put("indexInt", indexInt);
            CommandParam com = new CommandParam("bcm_linkagescopeofcreate", "bcm_linkagemappingconfig", "bar_next", param);
            this.sendMsg(this.getView(), com);
        } else if ("bar_showname".equals(key)) {
            this.getPageCache().put(showStyle_key, "name");
            this.refreshNameOrNumber();
        } else if ("bar_shownum".equals(key)) {
            this.getPageCache().put(showStyle_key, "number");
            this.refreshNameOrNumber();
        } else if ("bar_selectdim".equals(key)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("bcm_linkagedimshowselect");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCustomParam("modelId", (Object)this.getModelId());
            showParameter.setCustomParam("dimensions", (Object)this.getPageCache().get(dimensions_cache_key));
            showParameter.setCustomParam(selectnames_cache_key, (Object)this.getPageCache().get(selectnames_cache_key));
            showParameter.setCustomParam(selectnumbers_cache_key, (Object)this.getPageCache().get(selectnumbers_cache_key));
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "dimShowSelect");
            showParameter.setCloseCallBack(callBack);
            this.getView().showForm(showParameter);
        } else if ("bar_baseinfo".equals(key)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("bcm_linkagebaseinfoset");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCustomParam("baseInfo", (Object)this.getPageCache().get("baseInfo"));
            showParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
            showParameter.setCustomParam("KEY_SCENARIO_ID", (Object)this.getScenarioId());
            showParameter.setCustomParam("viewId", (Object)this.getPageCache().get("viewId"));
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "baseInfo");
            showParameter.setCloseCallBack(callBack);
            this.getView().showForm(showParameter);
        } else if ("bar_addgroup".equals(key)) {
            boolean[] visibleValue = (boolean[])this.deSerializedBytes(this.getPageCache().get("visibleValue"));
            boolean isSuccess = false;
            for (int i = 0; i < visibleValue.length; ++i) {
                if (visibleValue[i]) continue;
                visibleValue[i] = true;
                isSuccess = true;
                this.getView().setVisible(Boolean.valueOf(true), new String[]{tabpageap + (1 + i)});
                Tab tab = (Tab)this.getControl("tabap");
                tab.activeTab(tabpageap + (1 + i));
                break;
            }
            if (isSuccess) {
                this.setIsChange(true);
                this.getPageCache().put("visibleValue", this.toByteSerialized(visibleValue));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u591a\u53ea\u80fd\u670910\u4e2a\u5206\u7ec4\u3002", (String)"LinkageMappingAddPlugin_25", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        } else if ("bar_delgroup".equals(key)) {
            boolean[] visibleValue = (boolean[])this.deSerializedBytes(this.getPageCache().get("visibleValue"));
            int visible = 0;
            for (int i = 0; i < visibleValue.length; ++i) {
                if (!visibleValue[i]) continue;
                ++visible;
            }
            if (visible == 2) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u81f3\u5c11\u4fdd\u75592\u4e2a\u5206\u7ec4\u3002", (String)"LinkageMappingAddPlugin_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u5220\u9664\u5f53\u524d\u5206\u7ec4\uff1f", (String)"LinkageMappingAddPlugin_27", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("comfirm_delete", (IFormPlugin)this));
        } else if ("bar_modifygroupname".equals(key)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("bcm_modifygroupname");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            IPageCache pageCache = this.getPageCache();
            Map groupNames = (Map)this.deSerializedBytes(pageCache.get(groupNames_key));
            showParameter.setCustomParam("groupName", groupNames.get(pageCache.get(CURRENT_TABINDEX)));
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "modifyGroupName");
            showParameter.setCloseCallBack(callBack);
            this.getView().showForm(showParameter);
        } else if ("bar_enable".equals(key)) {
            this.updateStatus("1");
        } else if ("bar_disable".equals(key)) {
            this.updateStatus("0");
        }
        this.setToolBarStyle();
    }

    private void updateStatus(String status) {
        String statusName;
        DynamicObject currentLinkage = this.getCurrentLinkage();
        String string = statusName = "0".equals(status) ? OpItemEnum.DISABLE.getName() : OpItemEnum.ENABLE.getName();
        if (currentLinkage == null || this.getPageCache().get(CHANGEDATA) != null && "1".equals(status)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u8054\u52a8\u914d\u7f6e\uff0c\u518d\u8bbe\u7f6e\u72b6\u6001:%s\u3002", (String)"LinkageMappingAddPlugin_44", (String)"fi-bcm-formplugin", (Object[])new Object[0]), statusName));
            return;
        }
        if (currentLinkage.getString("status").equals(status)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5df2%1$s\uff0c\u65e0\u9700\u518d%2$s\u3002", (String)"LinkageMappingAddPlugin_45", (String)"fi-bcm-formplugin", (Object[])new Object[0]), statusName, statusName));
            return;
        }
        currentLinkage.set("status", (Object)status);
        SaveServiceHelper.update((DynamicObject)currentLinkage);
        this.setDisplayContent(statusName);
        this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"%s\u6210\u529f\u3002", (String)"LinkageMappingAddPlugin_46", (String)"fi-bcm-formplugin", (Object[])new Object[0]), statusName));
    }

    private boolean actionSave() {
        if (this.isEnable()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u8054\u52a8\u914d\u7f6e\u5df2\u542f\u7528\uff0c\u4e0d\u53ef\u4fdd\u5b58\u3002", (String)"LinkageMappingAddPlugin_43", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        boolean isEmpty = true;
        for (int i = 1; i <= 10; ++i) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entity + i);
            for (int j = 0; j < entryEntity.size(); ++j) {
                Object showtext = ((DynamicObject)entryEntity.get(j)).get("showtext" + i);
                if (showtext == null || StringUtils.isBlank((CharSequence)showtext.toString())) continue;
                isEmpty = false;
            }
        }
        if (isEmpty) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u914d\u7f6e\u4e24\u7ec4\u6709\u6548\u7684\u6570\u636e\u3002", (String)"LinkageMappingAddPlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (this.saveLinkageMapping()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"LinkageMappingAddPlugin_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    @Override
    public void dealMsg(CommandParam com) {
        String operation = com.getOperation();
        if (com.getParam() == null) {
            return;
        }
        if ("bar_previous".equals(operation) || "bar_next".equals(operation)) {
            Map param = (Map)com.getParam().get(0);
            long id = Long.parseLong(param.get("id").toString());
            Map<Integer, List<DynamicObject>> viewData = this.queryById(id);
            this.viewDimensionInfo(id, viewData);
            IPageCache pageCache = this.getPageCache();
            this.setSelect(pageCache.get(CURRENT_TABINDEX));
            this.setToolBarStyle();
        } else if ("addSelectedTap".equals(com.getOperation())) {
            List<Object> param = com.getParam();
            ReportTabManager reportTabManager = (ReportTabManager)param.get(0);
            ReportTabInfo currentTabInfo = reportTabManager.getCurrSelectReportTabInfo();
            if (currentTabInfo != null) {
                this.getPageCache().put(CURRENT_TEMPLATE_ID, String.valueOf(currentTabInfo.getTemplateId()));
            } else {
                this.getPageCache().remove(CURRENT_TEMPLATE_ID);
            }
        } else if ("returnEntry".equals(com.getOperation())) {
            this.setRowText(com.getParam().get(0));
        }
    }

    private void refreshNameOrNumber() {
        String setDimensionStr = this.getPageCache().get("setDimension");
        if (setDimensionStr != null) {
            Map setDimensionMap = (Map)this.deSerializedBytes(setDimensionStr);
            setDimensionMap.values().forEach(map -> this.setRowText(Integer.parseInt(map.get("currentTabIndex").toString()), Integer.parseInt(map.get("selectRow").toString()), (Map)map.get("showDimmembers"), true, false));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        String callBackId;
        super.confirmCallBack(mbce);
        switch (callBackId = mbce.getCallBackId()) {
            case "comfirm_delete": {
                if (mbce.getResult().getValue() != MessageBoxResult.Yes.getValue()) break;
                IPageCache pageCache = this.getPageCache();
                boolean[] visibleValue = (boolean[])this.deSerializedBytes(pageCache.get("visibleValue"));
                int currentTabIndex = Integer.parseInt(pageCache.get(CURRENT_TABINDEX));
                Map groupNames = (Map)this.deSerializedBytes(pageCache.get(groupNames_key));
                int toHide = 0;
                Map setDimensionMap = new HashMap();
                if (pageCache.get("setDimension") != null) {
                    setDimensionMap = (Map)this.deSerializedBytes(pageCache.get("setDimension"));
                }
                for (int i = currentTabIndex; i <= 10; ++i) {
                    this.getModel().deleteEntryData(entity + i);
                    Recorder tabIndex = new Recorder((Object)i);
                    setDimensionMap.entrySet().removeIf(entry -> ((String)entry.getKey()).startsWith(String.valueOf(tabIndex.getRecord())));
                    if (i < 10) {
                        if (visibleValue[i]) {
                            String nextTabName = (String)groupNames.get(String.valueOf(i + 1));
                            groupNames.put(String.valueOf(i), nextTabName);
                            TabPage page = (TabPage)this.getControl(tabpageap + i);
                            page.setText(new LocaleString(nextTabName));
                            DynamicObjectCollection nextEntity = this.getModel().getEntryEntity(entity + (i + 1));
                            DynamicObjectType currentType = this.getModel().getEntryEntity(entity + i).getDynamicObjectType();
                            for (int j = 0; j < nextEntity.size(); ++j) {
                                DynamicObject dy = new DynamicObject(currentType);
                                for (int k = 0; k < columes.length; ++k) {
                                    dy.set(columes[k] + i, ((DynamicObject)nextEntity.get(j)).get(columes[k] + (i + 1)));
                                }
                                this.getModel().batchCreateNewEntryRow(entity + i, dy, 1);
                                if (StringUtils.isBlank((CharSequence)((DynamicObject)nextEntity.get(j)).getString("showtext" + (i + 1)))) continue;
                                boolean isSource = LinkageTypeEnum.SOURCE.getIndex().equals(((DynamicObject)nextEntity.get(j)).getString("linkagetype" + (i + 1)));
                                if (isSource) {
                                    this.getView().setEnable(Boolean.valueOf(false), j, new String[]{"weight" + i});
                                } else {
                                    this.getModel().setValue("weight" + i, (Object)((DynamicObject)nextEntity.get(j)).getInt("weight" + (i + 1)), j);
                                }
                                Map nextMap = (Map)setDimensionMap.get(String.valueOf(i + 1) + j);
                                if (nextMap == null) continue;
                                HashMap<String, Integer> map = new HashMap<String, Integer>();
                                map.put("currentTabIndex", i);
                                map.put("selectRow", j);
                                map.put("showDimmembers", (Integer)nextMap.get("showDimmembers"));
                                setDimensionMap.put(String.valueOf(i) + j, map);
                            }
                            continue;
                        }
                        toHide = i;
                        this.getModel().batchCreateNewEntryRow(entity + i, 3);
                        break;
                    }
                    this.getModel().batchCreateNewEntryRow(entity + i, 3);
                    toHide = i;
                }
                TabPage page = (TabPage)this.getControl(tabpageap + toHide);
                page.setText(new LocaleString(this.groupNames_default[toHide - 1]));
                Tab tab = (Tab)this.getControl("tabap");
                tab.activeTab("tabpageap1");
                groupNames.put(String.valueOf(toHide), this.groupNames_default[toHide - 1]);
                pageCache.put(groupNames_key, this.toByteSerialized(groupNames));
                pageCache.put("setDimension", this.toByteSerialized(setDimensionMap));
                visibleValue[toHide - 1] = false;
                this.setTabPageApVisible(visibleValue);
                this.setIsChange(true);
                break;
            }
            case "change2save_comfirm": {
                if (mbce.getResult().getValue() == MessageBoxResult.No.getValue()) {
                    this.setIsChange(false);
                    this.getView().close();
                    break;
                }
                if (mbce.getResult().getValue() != MessageBoxResult.Yes.getValue()) break;
                if (!this.isEPM()) {
                    this.checkPerm("bar_save");
                }
                if (!this.actionSave()) break;
                this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"LinkageMappingAddPlugin_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                this.getView().close();
                break;
            }
        }
    }

    private void setTabPageApVisible(boolean[] visibleValue) {
        for (int i = 0; i < visibleValue.length; ++i) {
            this.getView().setVisible(Boolean.valueOf(visibleValue[i]), new String[]{tabpageap + (1 + i)});
        }
        this.getPageCache().put("visibleValue", this.toByteSerialized(visibleValue));
    }

    private void initDataPerm(Map<Integer, List<DynamicObject>> viewData) {
        Set permClassIds = PermClassCache.getPermClassIds((Long)this.getModelId(), (String)"bcm_templateentity", (DataTypeEnum[])new DataTypeEnum[]{DataTypeEnum.NO, DataTypeEnum.READ});
        if (viewData.values().stream().flatMap(e -> e.stream()).anyMatch(e -> e.getLong("entryentity.template.id") != 0L && permClassIds.contains(e.getLong("entryentity.template.id")))) {
            this.getPageCache().put(DATA_NOPERM_FLAG, "1");
        } else {
            this.getPageCache().put(DATA_NOPERM_FLAG, "0");
        }
    }

    private void viewDimensionInfo(Long id, Map<Integer, List<DynamicObject>> viewData) {
        IPageCache pageCache = this.getPageCache();
        HashMap<String, String> cache = new HashMap<String, String>();
        cache.put("viewId", id.toString());
        this.initDataPerm(viewData);
        boolean isShowName = "name".equals(pageCache.get(showStyle_key));
        List selectDims = isShowName ? (List)this.deSerializedBytes(pageCache.get(selectnames_cache_key)) : (List)this.deSerializedBytes(pageCache.get(selectnumbers_cache_key));
        boolean[] visibleValue = new boolean[10];
        boolean isCacheBaseInfo = false;
        HashMap<String, String> groupNames = new HashMap<String, String>();
        LinkedHashMap<String, Map<String, Object>> setDimensionMap = new LinkedHashMap<String, Map<String, Object>>();
        boolean isSpptMyCompany = DimensionServiceHelper.existsMyCompanyDim((long)this.getModelId());
        for (int i = 1; i <= 10; ++i) {
            List<DynamicObject> list = viewData.get(i);
            if (list != null && !list.isEmpty()) {
                visibleValue[i - 1] = true;
                if (!isCacheBaseInfo) {
                    isCacheBaseInfo = true;
                    HashMap<String, String> baseInfo = new HashMap<String, String>(16);
                    baseInfo.put("name", list.get(0).getString("name"));
                    baseInfo.put("number", list.get(0).getString("number"));
                    baseInfo.put("description", list.get(0).getString("description"));
                    baseInfo.putAll(this.getApplyInfo(id));
                    cache.put("baseInfo", this.toByteSerialized(baseInfo));
                    this.setDisplayContent(list.get(0).getBoolean("status") ? OpItemEnum.ENABLE.getName() : OpItemEnum.DISABLE.getName());
                    cache.put("editStatus", list.get(0).getString("status"));
                    cache.put(CURRENT_TABINDEX, String.valueOf(i));
                }
                this.getModel().deleteEntryData(entity + i);
                this.getModel().batchCreateNewEntryRow(entity + i, list.size());
                String groupName = list.get(0).getString("entryentity.groupname");
                TabPage page = (TabPage)this.getControl(tabpageap + i);
                page.setText(new LocaleString(groupName));
                groupNames.put(String.valueOf(i), groupName);
                for (int j = 0; j < list.size(); ++j) {
                    DynamicObject linkage = list.get(j);
                    DynamicObject toView = this.getModel().getEntryRowEntity(entity + i, j);
                    StringBuilder showText = new StringBuilder();
                    StringBuilder dimShow = new StringBuilder();
                    toView.set("id", (Object)linkage.getLong("entryentity.id"));
                    String linkagetype = linkage.getString("entryentity.linkagetype");
                    toView.set("linkagetype" + i, (Object)linkagetype);
                    this.getView().setEnable(Boolean.valueOf(!LinkageTypeEnum.SOURCE.getIndex().equals(linkagetype)), j, new String[]{"weight" + i, "operator" + i});
                    toView.set("weight" + i, (Object)linkage.getInt("entryentity.weight"));
                    toView.set("operator" + i, (Object)linkage.getString("entryentity.operator"));
                    toView.set("template" + i, (Object)linkage.getString("entryentity.template.id"));
                    toView.set("account" + i, (Object)linkage.getString("entryentity.account.id"));
                    toView.set("audittrial" + i, (Object)linkage.getString("entryentity.audittrial.id"));
                    toView.set("changetype" + i, (Object)linkage.getString("entryentity.changetype.id"));
                    toView.set("mycompany" + i, (Object)linkage.getString("entryentity.mycompany.id"));
                    toView.set("intercompany" + i, (Object)linkage.getString("entryentity.intercompany.id"));
                    toView.set("accountrange" + i, (Object)linkage.getInt("entryentity.accountrange"));
                    toView.set("audittrialrange" + i, (Object)linkage.getInt("entryentity.audittrialrange"));
                    toView.set("changetyperange" + i, (Object)linkage.getInt("entryentity.changetyperange"));
                    toView.set("mycompanyrange" + i, (Object)linkage.getInt("entryentity.mycompanyrange"));
                    toView.set("intercompanyrange" + i, (Object)linkage.getInt("entryentity.intercompanyrange"));
                    showText.append(String.format(linkage.getInt("entryentity.accountrange") == 10 ? "\u3010%1$s\uff01%2$s\u3011 " : ResManager.loadKDString((String)"\u3010%1$s\uff01%2$s\u7684\u6240\u6709\u4e0b\u7ea7\u660e\u7ec6\u6210\u5458\u3011 ", (String)"LinkageMappingAddPlugin_50", (String)"fi-bcm-formplugin", (Object[])new Object[0]), isShowName ? DimTypesEnum.ACCOUNT.getName() : DimTypesEnum.ACCOUNT.getNumber(), isShowName ? linkage.getString("entryentity.account.name") : linkage.getString("entryentity.account.number")));
                    dimShow.append(String.format(linkage.getInt("entryentity.accountrange") == 10 ? "\u3010%1$s\uff01%2$s\u3011 " : ResManager.loadKDString((String)"\u3010%1$s\uff01%2$s\u7684\u6240\u6709\u4e0b\u7ea7\u660e\u7ec6\u6210\u5458\u3011 ", (String)"LinkageMappingAddPlugin_50", (String)"fi-bcm-formplugin", (Object[])new Object[0]), DimTypesEnum.ACCOUNT.getName(), linkage.getString("entryentity.account.name")));
                    if (selectDims.contains(DimTypesEnum.AUDITTRIAL.getNumber())) {
                        showText.append(String.format(linkage.getInt("entryentity.audittrialrange") == 10 ? "\u3010%1$s\uff01%2$s\u3011 " : ResManager.loadKDString((String)"\u3010%1$s\uff01%2$s\u7684\u6240\u6709\u4e0b\u7ea7\u660e\u7ec6\u6210\u5458\u3011 ", (String)"LinkageMappingAddPlugin_50", (String)"fi-bcm-formplugin", (Object[])new Object[0]), isShowName ? DimTypesEnum.AUDITTRIAL.getName() : DimTypesEnum.AUDITTRIAL.getNumber(), isShowName ? linkage.getString("entryentity.audittrial.name") : linkage.getString("entryentity.audittrial.number")));
                        dimShow.append(String.format(linkage.getInt("entryentity.audittrialrange") == 10 ? "\u3010%1$s\uff01%2$s\u3011 " : ResManager.loadKDString((String)"\u3010%1$s\uff01%2$s\u7684\u6240\u6709\u4e0b\u7ea7\u660e\u7ec6\u6210\u5458\u3011 ", (String)"LinkageMappingAddPlugin_50", (String)"fi-bcm-formplugin", (Object[])new Object[0]), DimTypesEnum.AUDITTRIAL.getName(), linkage.getString("entryentity.audittrial.name")));
                    }
                    if (selectDims.contains(DimTypesEnum.CHANGETYPE.getNumber())) {
                        showText.append(String.format(linkage.getInt("entryentity.changetyperange") == 10 ? "\u3010%1$s\uff01%2$s\u3011 " : ResManager.loadKDString((String)"\u3010%1$s\uff01%2$s\u7684\u6240\u6709\u4e0b\u7ea7\u660e\u7ec6\u6210\u5458\u3011 ", (String)"LinkageMappingAddPlugin_50", (String)"fi-bcm-formplugin", (Object[])new Object[0]), isShowName ? DimTypesEnum.CHANGETYPE.getName() : DimTypesEnum.CHANGETYPE.getNumber(), isShowName ? linkage.getString("entryentity.changetype.name") : linkage.getString("entryentity.changetype.number")));
                        dimShow.append(String.format(linkage.getInt("entryentity.changetyperange") == 10 ? "\u3010%1$s\uff01%2$s\u3011 " : ResManager.loadKDString((String)"\u3010%1$s\uff01%2$s\u7684\u6240\u6709\u4e0b\u7ea7\u660e\u7ec6\u6210\u5458\u3011 ", (String)"LinkageMappingAddPlugin_50", (String)"fi-bcm-formplugin", (Object[])new Object[0]), DimTypesEnum.CHANGETYPE.getName(), linkage.getString("entryentity.changetype.name")));
                    }
                    if (selectDims.contains(DimTypesEnum.MYCOMPANY.getNumber())) {
                        showText.append(String.format(linkage.getInt("entryentity.mycompanyrange") == 10 ? "\u3010%1$s\uff01%2$s\u3011 " : ResManager.loadKDString((String)"\u3010%1$s\uff01%2$s\u7684\u6240\u6709\u4e0b\u7ea7\u660e\u7ec6\u6210\u5458\u3011 ", (String)"LinkageMappingAddPlugin_50", (String)"fi-bcm-formplugin", (Object[])new Object[0]), isShowName ? DimTypesEnum.MYCOMPANY.getName() : DimTypesEnum.MYCOMPANY.getNumber(), isShowName ? linkage.getString("entryentity.mycompany.name") : linkage.getString("entryentity.mycompany.number")));
                        dimShow.append(String.format(linkage.getInt("entryentity.mycompanyrange") == 10 ? "\u3010%1$s\uff01%2$s\u3011 " : ResManager.loadKDString((String)"\u3010%1$s\uff01%2$s\u7684\u6240\u6709\u4e0b\u7ea7\u660e\u7ec6\u6210\u5458\u3011 ", (String)"LinkageMappingAddPlugin_50", (String)"fi-bcm-formplugin", (Object[])new Object[0]), DimTypesEnum.MYCOMPANY.getName(), linkage.getString("entryentity.mycompany.name")));
                    }
                    if (selectDims.contains(DimTypesEnum.INTERCOMPANY.getNumber())) {
                        showText.append(String.format(linkage.getInt("entryentity.intercompanyrange") == 10 ? "\u3010%1$s\uff01%2$s\u3011 " : ResManager.loadKDString((String)"\u3010%1$s\uff01%2$s\u7684\u6240\u6709\u4e0b\u7ea7\u660e\u7ec6\u6210\u5458\u3011 ", (String)"LinkageMappingAddPlugin_50", (String)"fi-bcm-formplugin", (Object[])new Object[0]), isShowName ? DimTypesEnum.INTERCOMPANY.getName() : DimTypesEnum.INTERCOMPANY.getNumber(), isShowName ? linkage.getString("entryentity.intercompany.name") : linkage.getString("entryentity.intercompany.number")));
                        dimShow.append(String.format(linkage.getInt("entryentity.intercompanyrange") == 10 ? "\u3010%1$s\uff01%2$s\u3011 " : ResManager.loadKDString((String)"\u3010%1$s\uff01%2$s\u7684\u6240\u6709\u4e0b\u7ea7\u660e\u7ec6\u6210\u5458\u3011 ", (String)"LinkageMappingAddPlugin_50", (String)"fi-bcm-formplugin", (Object[])new Object[0]), DimTypesEnum.INTERCOMPANY.getName(), linkage.getString("entryentity.intercompany.name")));
                    }
                    for (int k = 1; k <= 6; ++k) {
                        long userdefinedId = linkage.getLong("entryentity.userdefined" + k + ".id");
                        toView.set("userdefined" + k + i, (Object)userdefinedId);
                        toView.set("userdefinedrange" + k + i, (Object)linkage.getInt("entryentity.userdefinedrange" + k));
                        if (userdefinedId == 0L) continue;
                        Map<String, Object> dimensionInfo = this.getDimensionInfo(linkage.getString("entryentity.userdefined" + k + ".dimension.number"));
                        if (selectDims.contains(dimensionInfo.get("number"))) {
                            showText.append(String.format(linkage.getInt("entryentity.userdefinedrange" + k) == 10 ? "\u3010%1$s\uff01%2$s\u3011 " : ResManager.loadKDString((String)"\u3010%1$s\uff01%2$s\u7684\u6240\u6709\u4e0b\u7ea7\u660e\u7ec6\u6210\u5458\u3011 ", (String)"LinkageMappingAddPlugin_50", (String)"fi-bcm-formplugin", (Object[])new Object[0]), isShowName ? dimensionInfo.get("name") : dimensionInfo.get("number"), isShowName ? linkage.getString("entryentity.userdefined" + k + ".name") : linkage.getString("entryentity.userdefined" + k + ".number")));
                        }
                        dimShow.append(String.format(linkage.getInt("entryentity.userdefinedrange" + k) == 10 ? "\u3010%1$s\uff01%2$s\u3011 " : ResManager.loadKDString((String)"\u3010%1$s\uff01%2$s\u7684\u6240\u6709\u4e0b\u7ea7\u660e\u7ec6\u6210\u5458\u3011 ", (String)"LinkageMappingAddPlugin_50", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dimensionInfo.get("name"), linkage.getString("entryentity.userdefined" + k + ".name")));
                    }
                    toView.set("showtext" + i, (Object)showText.toString());
                    toView.set("dimshow" + i, (Object)dimShow.toString());
                    this.setRowDataCache(setDimensionMap, i, j, linkage, isSpptMyCompany);
                }
            } else {
                visibleValue[i - 1] = false;
                groupNames.put(String.valueOf(i), this.groupNames_default[i - 1]);
            }
            this.getView().updateView(entity + i);
        }
        this.setTabPageApVisible(visibleValue);
        cache.put(groupNames_key, this.toByteSerialized(groupNames));
        cache.put("setDimension", this.toByteSerialized(setDimensionMap));
        pageCache.put(cache);
    }

    private Map<String, String> getApplyInfo(Long id) {
        HashMap<String, String> result = new HashMap<String, String>(16);
        QFBuilder qb = new QFBuilder("id", "=", (Object)id);
        DynamicObject dyns = BusinessDataServiceHelper.loadSingle((String)"bcm_linkagemapping", (String)"id,scenarios,scenarios.isexcept,scenarios.scenariomeb,scenarios.scenarioscope,applyentity,applyentity.entityisexcept,applyentity.entitymeb,applyentity.property,applyentity.propertyvalue,applyentity.entityrange", (QFilter[])qb.toArray());
        if (dyns != null && dyns.getDynamicObjectCollection("scenarios") != null) {
            ArrayList sceneItems = new ArrayList(16);
            dyns.getDynamicObjectCollection("scenarios").forEach(dy -> sceneItems.add(MapInitHelper.ofMap((Object)"id", (Object)dy.getLong("scenariomeb.id"), (Object)"scope", (Object)dy.getString("scenarioscope"), (Object)"isexcept", (Object)dy.getString("isexcept"))));
            result.put(SCENARIOSET, this.toByteSerialized(sceneItems));
        }
        if (dyns != null && dyns.getDynamicObjectCollection(APPLYENTITY) != null) {
            ArrayList entityItems = new ArrayList(16);
            dyns.getDynamicObjectCollection(APPLYENTITY).forEach(dy -> entityItems.add(MapInitHelper.ofMap((Object)"id", (Object)(dy.getLong("entitymeb.id") == 0L ? dy.getLong("propertyvalue.id") : dy.getLong("entitymeb.id")), (Object)"scope", (Object)dy.getString("entityrange"), (Object)"isexcept", (Object)dy.getString("entityisexcept"), (Object)"pid", (Object)dy.getLong("property.id"))));
            result.put(APPLYENTITY, this.toByteSerialized(entityItems));
        }
        return result;
    }

    private void setRowDataCache(Map<String, Map<String, Object>> setDimensionMap, int tabIndex, int rowIndex, DynamicObject linkage, boolean isSpptMyCompany) {
        HashMap<String, String> showDimmembers = new HashMap<String, String>();
        showDimmembers.put(linkage.getString("entryentity.account.dimension.number"), linkage.getString("entryentity.account.number"));
        if (this.isExistChangeTypeDimension()) {
            showDimmembers.put(linkage.getString("entryentity.changetype.dimension.number"), linkage.getString("entryentity.changetype.number"));
        }
        if (this.isExistAuditTrailDimension()) {
            showDimmembers.put(linkage.getString("entryentity.audittrial.dimension.number"), linkage.getString("entryentity.audittrial.number"));
        }
        if (isSpptMyCompany) {
            showDimmembers.put(linkage.getString("entryentity.mycompany.dimension.number"), linkage.getString("entryentity.mycompany.number"));
        }
        showDimmembers.put(linkage.getString("entryentity.intercompany.dimension.number"), linkage.getString("entryentity.intercompany.number"));
        for (int i = 1; i <= 6; ++i) {
            long userdefinedId = linkage.getLong("entryentity.userdefined" + i + ".id");
            if (userdefinedId == 0L) continue;
            showDimmembers.put(linkage.getString("entryentity.userdefined" + i + ".dimension.number"), linkage.getString("entryentity.userdefined" + i + ".number"));
        }
        showDimmembers.remove(null);
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("currentTabIndex", Integer.valueOf(tabIndex));
        map.put("selectRow", Integer.valueOf(rowIndex));
        map.put("showDimmembers", showDimmembers);
        setDimensionMap.put(String.valueOf(tabIndex) + rowIndex, map);
    }

    private Map<Integer, List<DynamicObject>> queryById(long id) {
        DynamicObjectCollection linkageMappings = LinkageMappingServiceHelper.queryById((Long)id);
        HashMap<Integer, List<DynamicObject>> map = new HashMap<Integer, List<DynamicObject>>();
        linkageMappings.forEach(link -> {
            int groupnum = link.getInt("entryentity.groupnum");
            ArrayList<DynamicObject> cols = (ArrayList<DynamicObject>)map.get(groupnum);
            if (cols == null) {
                cols = new ArrayList<DynamicObject>();
                map.put(groupnum, cols);
            }
            cols.add((DynamicObject)link);
        });
        return map;
    }

    private boolean saveLinkageMapping() {
        Map item;
        int i;
        List selecteditems;
        DynamicObject modifier = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
        modifier.set("id", (Object)RequestContext.get().getUserId());
        modifier.set("name", (Object)RequestContext.get().getUserName());
        IPageCache pageCache = this.getPageCache();
        long modelId = this.getModelId();
        Map baseInfo = (Map)this.deSerializedBytes(pageCache.get("baseInfo"));
        String number = baseInfo.get("number").toString();
        String name = baseInfo.get("name").toString();
        String status = "0";
        DynamicObject linkageMapping = this.getCurrentLinkage();
        if (linkageMapping == null) {
            linkageMapping = BusinessDataServiceHelper.newDynamicObject((String)"bcm_linkagemapping");
            QFilter[] array = new QFBuilder("model", "=", (Object)modelId).add("number", "=", (Object)number).toArray();
            if (QueryServiceHelper.exists((String)"bcm_linkagemapping", (QFilter[])array)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201c%s\u201d\u5df2\u5b58\u5728\u3002", (String)"LinkageMappingAddPlugin_30", (String)"fi-bcm-formplugin", (Object[])new Object[0]), number));
                return false;
            }
        }
        int effectiveGroupNum = 0;
        linkageMapping.set("model", (Object)modelId);
        linkageMapping.set("number", (Object)number);
        linkageMapping.set("name", baseInfo.get("name"));
        linkageMapping.set("status", (Object)status);
        linkageMapping.set("description", baseInfo.get("description"));
        linkageMapping.set("modifier", (Object)modifier);
        linkageMapping.set("modifytime", (Object)TimeServiceHelper.now());
        if (baseInfo.get(SCENARIOSET) != null) {
            selecteditems = (List)this.deSerializedBytes(baseInfo.get(SCENARIOSET).toString());
            DynamicObjectCollection scenarios = linkageMapping.getDynamicObjectCollection("scenarios");
            scenarios.clear();
            if (CollectionUtils.isNotEmpty((Collection)selecteditems)) {
                for (i = 0; i < selecteditems.size(); ++i) {
                    item = (Map)selecteditems.get(i);
                    DynamicObject scenario = scenarios.addNew();
                    scenario.set("scenariomeb_id", (Object)((Long)item.get("id")));
                    scenario.set("scenarioscope", (Object)((String)item.get("scope")));
                    scenario.set("isexcept", (Object)((String)item.get("isexcept")));
                }
            }
        }
        if (baseInfo.get(APPLYENTITY) != null) {
            selecteditems = (List)this.deSerializedBytes(baseInfo.get(APPLYENTITY).toString());
            DynamicObjectCollection applyentity = linkageMapping.getDynamicObjectCollection(APPLYENTITY);
            applyentity.clear();
            if (CollectionUtils.isNotEmpty((Collection)selecteditems)) {
                for (i = 0; i < selecteditems.size(); ++i) {
                    item = (Map)selecteditems.get(i);
                    DynamicObject entityItem = applyentity.addNew();
                    if (LongUtil.toLong(item.get("pid")) == 0L) {
                        entityItem.set("entitymeb_id", (Object)LongUtil.toLong(item.get("id")));
                    } else {
                        entityItem.set("propertyvalue_id", (Object)LongUtil.toLong(item.get("id")));
                        entityItem.set("property_id", (Object)LongUtil.toLong(item.get("pid")));
                    }
                    entityItem.set("entityrange", (Object)((String)item.get("scope")));
                    entityItem.set("entityisexcept", (Object)((String)item.get("isexcept")));
                }
            }
        }
        EffectiveYearPeriodUtil.saveEffectiveInfo(linkageMapping, (Map)baseInfo.get("effective"));
        DynamicObjectCollection entryentitys = linkageMapping.getDynamicObjectCollection("entryentity");
        entryentitys.clear();
        DynamicObjectType entryType = entryentitys.getDynamicObjectType();
        Map groupNames = (Map)this.deSerializedBytes(pageCache.get(groupNames_key));
        boolean[] visibleValue = (boolean[])this.deSerializedBytes(this.getPageCache().get("visibleValue"));
        HashMap<Integer, List> toDelete = new HashMap<Integer, List>();
        for (int i2 = 1; i2 <= 10; ++i2) {
            if (!visibleValue[i2 - 1]) continue;
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entity + i2);
            int targetWeight = 0;
            boolean isEffective = false;
            String groupName = (String)groupNames.get(String.valueOf(i2));
            for (int j = 0; j < entryEntity.size(); ++j) {
                DynamicObject dy = (DynamicObject)entryEntity.get(j);
                Object showtext = dy.get("showtext" + i2);
                if (showtext != null && !StringUtils.isBlank((CharSequence)showtext.toString())) {
                    DynamicObject entry = new DynamicObject(entryType);
                    entry.set("groupnum", (Object)i2);
                    entry.set("groupname", (Object)groupName);
                    entry.set("seq", (Object)(j + 1));
                    entry.set("operator", dy.get("operator" + i2));
                    String linkagetype = dy.getString("linkagetype" + i2);
                    if (linkagetype == null) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u7ec4\u201c%1$s\u201c\u7b2c %2$d\u884c\u8054\u52a8\u7c7b\u578b\u3002", (String)"LinkageMappingAddPlugin_32", (String)"fi-bcm-formplugin", (Object[])new Object[0]), groupName, j + 1));
                        return false;
                    }
                    entry.set("linkagetype", (Object)linkagetype);
                    int weight = dy.getInt("weight" + i2);
                    if (LinkageTypeEnum.ALL.getIndex().equals(linkagetype) || LinkageTypeEnum.TARGET.getIndex().equals(linkagetype)) {
                        if (weight == 0) {
                            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u7ec4\u201c%1$s\u201c\u7b2c %2$d\u884c\u6743\u91cd\u503c\u3002", (String)"LinkageMappingAddPlugin_35", (String)"fi-bcm-formplugin", (Object[])new Object[0]), groupName, j + 1));
                            return false;
                        }
                        targetWeight += weight;
                    } else {
                        weight = 0;
                    }
                    entry.set("weight", (Object)weight);
                    entry.set("template", (Object)dy.getLong("template" + i2));
                    entry.set("account", (Object)dy.getLong("account" + i2));
                    entry.set("audittrial", (Object)dy.getLong("audittrial" + i2));
                    entry.set("changetype", (Object)dy.getLong("changetype" + i2));
                    entry.set("mycompany", (Object)dy.getLong("mycompany" + i2));
                    entry.set("intercompany", (Object)dy.getLong("intercompany" + i2));
                    for (int k2 = 1; k2 <= 6; ++k2) {
                        entry.set("userdefined" + k2, (Object)dy.getLong("userdefined" + k2 + i2));
                        entry.set("userdefinedrange" + k2, (Object)dy.getInt("userdefinedrange" + k2 + i2));
                    }
                    entry.set("accountrange", (Object)dy.getInt("accountrange" + i2));
                    entry.set("audittrialrange", (Object)dy.getLong("audittrialrange" + i2));
                    entry.set("changetyperange", (Object)dy.getInt("changetyperange" + i2));
                    entry.set("mycompanyrange", (Object)dy.getInt("mycompanyrange" + i2));
                    entry.set("intercompanyrange", (Object)dy.getInt("intercompanyrange" + i2));
                    entry.set("dimshow", showtext);
                    entryentitys.add((Object)entry);
                    isEffective = true;
                    continue;
                }
                ArrayList<Integer> nullValueRowIndexs2 = (ArrayList<Integer>)toDelete.get(i2);
                if (nullValueRowIndexs2 == null) {
                    nullValueRowIndexs2 = new ArrayList<Integer>();
                    toDelete.put(i2, nullValueRowIndexs2);
                }
                nullValueRowIndexs2.add(j);
            }
            if (!isEffective) continue;
            if (targetWeight != 0 && targetWeight != 100) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5206\u7ec4\u201c%1$s\u201d\u76ee\u6807\u6743\u91cd\u4e4b\u548c\u4e0d\u7b49\u4e8e%2$s\uff0c\u8bf7\u4fee\u6539\u3002", (String)"LinkageMappingAddPlugin_37", (String)"fi-bcm-formplugin", (Object[])new Object[0]), groupName, "100%"));
                return false;
            }
            ++effectiveGroupNum;
        }
        if (effectiveGroupNum < 2) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u81f3\u5c11\u9700\u8981\u914d\u7f6e\u4e24\u7ec4\u6709\u6548\u7684\u6570\u636e\u3002", (String)"LinkageMappingAddPlugin_39", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        Set noPerms = PermClassCache.getPermClassIds((Long)this.getModelId(), (String)"bcm_templateentity", (DataTypeEnum[])new DataTypeEnum[]{DataTypeEnum.NO, DataTypeEnum.READ});
        List collect = entryentitys.stream().filter(e -> e.getLong("template") != 0L && noPerms.contains(e.getLong("template"))).collect(Collectors.toList());
        if (!collect.isEmpty()) {
            Set templateIds = collect.stream().map(e -> e.getLong("template")).collect(Collectors.toSet());
            Map<Long, String> tmpMap = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("id", "in", templateIds)}).stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v.getString("name")));
            String msg = ResManager.loadKDString((String)"%1$s \u5173\u8054\u7684\u6a21\u677f\u3010%2$s\u3011\u65e0\u64cd\u4f5c\u6743\u9650", (String)"LinkageMappingAddPlugin_48", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            String errorMsg = collect.stream().map(e -> String.format(msg, e.getString("groupname"), tmpMap.get(e.getLong("template")))).collect(Collectors.toSet()).stream().collect(Collectors.joining("\n"));
            this.getView().showTipNotification(errorMsg);
            return false;
        }
        toDelete.forEach((groupIdx, nullValueRowIndexs) -> {
            int[] del = new int[nullValueRowIndexs.size()];
            for (int m = 0; m < del.length; ++m) {
                del[m] = (Integer)nullValueRowIndexs.get(m);
            }
            this.getModel().deleteEntryRows(entity + groupIdx, del);
        });
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{linkageMapping});
        HashMap<String, String> batchCache = new HashMap<String, String>();
        batchCache.put("viewId", linkageMapping.getString("id"));
        List ids = (List)this.deSerializedBytes(pageCache.get(IDS_KEY));
        if (!ids.contains(linkageMapping.getLong("id"))) {
            ids.add(linkageMapping.getLong("id"));
            batchCache.put(IDS_KEY, this.toByteSerialized(ids));
        }
        batchCache.put("editStatus", status);
        batchCache.put("baseInfo", this.toByteSerialized(baseInfo));
        pageCache.put(batchCache);
        this.setDisplayContent("0".equals(status) ? OpItemEnum.DISABLE.getName() : OpItemEnum.ENABLE.getName());
        this.setIsChange(false);
        this.writeOperationLog(this.getOperationSave(), number, name, this.getOperationStstusSuccess());
        return true;
    }

    protected boolean isTemplatePlugin() {
        return false;
    }

    private TemplateModel loadTreeClick(String selectedNodeId) {
        if (!QueryServiceHelper.exists((String)"bcm_templateentity", (Object)Long.valueOf(selectedNodeId))) {
            return null;
        }
        DynamicObject templateInfo = BusinessDataServiceHelper.loadSingle((Object)selectedNodeId, (String)"bcm_templateentity");
        TemplateModel template = new TemplateModel();
        template.loadDynaObj2Model(templateInfo);
        this.initPageviewPanelValues(selectedNodeId);
        return template;
    }

    private void clearShowData(Map<String, Object> returnData) {
        IPageCache pageCache = this.getPageCache();
        HashMap<String, String> batchCache = new HashMap<String, String>();
        batchCache.put("baseInfo", this.toByteSerialized(returnData));
        batchCache.put(CURRENT_TABINDEX, "1");
        HashMap<String, String> groupNames = new HashMap<String, String>(10);
        for (int i = 1; i <= 10; ++i) {
            TabPage page = (TabPage)this.getControl(tabpageap + i);
            page.setText(new LocaleString(this.groupNames_default[i - 1]));
            groupNames.put(String.valueOf(i), this.groupNames_default[i - 1]);
            this.getModel().deleteEntryData(entity + i);
            this.getModel().batchCreateNewEntryRow(entity + i, 3);
        }
        this.getView().updateView();
        this.setDisplayContent("");
        this.setTabPageApVisible(new boolean[]{true, true, false, false, false, false, false, false, false, false});
        this.setSelect("1");
        batchCache.put(groupNames_key, this.toByteSerialized(groupNames));
        pageCache.remove("setDimension");
        pageCache.remove("viewId");
        pageCache.put(batchCache);
    }

    private void setSelect(String currentTabIndex) {
        Tab tab = (Tab)this.getControl("tabap");
        tab.activeTab(tabpageap + currentTabIndex);
    }

    private void initPageviewPanelValues(String selectedNodeId) {
        IPageCache pageCache = this.getPageCache();
        HashMap allDims = new HashMap();
        pageCache.put(selectedNodeId, this.toByteSerialized(allDims));
    }

    private void setDisplayContent(String status) {
        if (status != null) {
            StatusBarModel statusBarModel = new StatusBarModel();
            statusBarModel.setStatus(status);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        this.setIsChange(true);
        if (propName.contains("linkagetype")) {
            IPageCache pageCache = this.getPageCache();
            int currentTabIndex = Integer.parseInt(pageCache.get(CURRENT_TABINDEX));
            int selectTableRow = Integer.parseInt(pageCache.get(select_table_row));
            String linkagetype = (String)this.getModel().getValue("linkagetype" + currentTabIndex, selectTableRow);
            if (LinkageTypeEnum.SOURCE.getIndex().equals(linkagetype)) {
                this.getModel().setValue("weight" + currentTabIndex, (Object)0, selectTableRow);
                this.getModel().setValue("operator" + currentTabIndex, null, selectTableRow);
            } else {
                int weight = (Integer)this.getModel().getValue("weight" + currentTabIndex, selectTableRow);
                if (weight == 0) {
                    this.getModel().setValue("weight" + currentTabIndex, (Object)this.calculateCurrentWeight(currentTabIndex), selectTableRow);
                }
                this.getModel().setValue("operator" + currentTabIndex, (Object)1, selectTableRow);
            }
            this.getView().setEnable(Boolean.valueOf(!LinkageTypeEnum.SOURCE.getIndex().equals(linkagetype)), selectTableRow, new String[]{"weight" + currentTabIndex, "operator" + currentTabIndex});
        }
    }

    private int calculateCurrentWeight(int currentTabIndex) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entity + currentTabIndex);
        int result = 100;
        for (DynamicObject row : entryEntity) {
            int rowWeight = row.getInt("weight" + currentTabIndex);
            result -= rowWeight;
        }
        return Math.max(result, 0);
    }

    private void setIsChange(boolean isChange) {
        if (isChange) {
            this.getPageCache().put(CHANGEDATA, "1");
        } else {
            this.getPageCache().put(CHANGEDATA, null);
        }
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (this.getPageCache().get(CHANGEDATA) != null) {
            e.setCancel(true);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4fee\u6539\uff0c\u662f\u5426\u8981\u4fdd\u5b58\uff1f", (String)"LinkageMappingAddPlugin_42", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("change2save_comfirm", (IFormPlugin)this));
        }
    }

    private void showFromView(String tab, String form) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey(tab);
        formShowParameter.setFormId(form);
        formShowParameter.setPageId(this.getPageIdAndCache(this.getPageCache(), form, true));
        formShowParameter.setCustomParam("model", (Object)this.getModelId());
        formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        formShowParameter.setCustomParam("notshoworgtab", (Object)false);
        formShowParameter.setCustomParam("iscross", (Object)true);
        formShowParameter.setCustomParam("frompage", (Object)this.getView().getEntityId());
        formShowParameter.setCustomParam("isReportTabVisible", (Object)Boolean.FALSE);
        formShowParameter.setCustomParam("isOpenSelectCellAction", (Object)Boolean.TRUE);
        formShowParameter.setCustomParam("templateId", this.getFormCustomParam("templateId"));
        formShowParameter.setCustomParam("isAudit", (Object)Boolean.TRUE);
        this.getView().showForm(formShowParameter);
    }
}

