/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.linkagemapping;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.IImportPlugin;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.adjust.util.ApplyEntityHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.permission.permclass.PermClassCache;
import kd.fi.bcm.business.util.BCMNumberRule;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DataSourceEnum;
import kd.fi.bcm.common.enums.Permission.DataTypeEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.papertemplate.PaperTemplateScenarioSettingConstant;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.fel.common.StringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class LinkageMappingImport
implements IImportPlugin {
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private static final String NUMBER = "number";
    private static final String MODEL = "model";
    private static final String ACCOUNT = "account";
    private static final String MY_COMPANY = "mycompany";
    private static Log log = LogFactory.getLog(LinkageMappingImport.class);
    private List<Map<String, Object>> effectivedate;
    private List<Map<String, Object>> scenarioList;
    private List<Map<String, Object>> applyEntityList;
    private String entityName = "bcm_linkagemapping";
    private Long modelId = 0L;

    public boolean beforeImportData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        try {
            return this.invalidate(data, importlogs);
        }
        catch (Exception e) {
            importlogs.add(new ImportLogger.ImportLog(this.printError(e)));
            return false;
        }
    }

    private String printError(Throwable t) {
        return ThrowableHelper.toString((Throwable)t);
    }

    private boolean invalidate(Map<String, Object> data, List<ImportLogger.ImportLog> importlogs) {
        String number = (String)data.get(NUMBER);
        String name = (String)data.get("name");
        if (StringUtils.isBlank((CharSequence)number) || StringUtils.isBlank((CharSequence)name)) {
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u540d\u79f0\u6216\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LinkageMappingImport_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0])));
            return false;
        }
        if (this.checkStrLenth(number, 50) || this.checkStrLenth(name, 50)) {
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u540d\u79f0\u6216\u7f16\u7801\u4e0d\u80fd\u8d85\u8fc750\u4e2a\u5b57\u7b26\u3002", (String)"LinkageMappingImport_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0])));
            return false;
        }
        if (!BCMNumberRule.checkNumber((String)number)) {
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u6a21\u677f\u7f16\u7801\u4e0d\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u4ee5\u5916\u7684\u5b57\u7b26\uff0c\u4e0d\u53ef\u4ee5\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e4b\u95f4\u5fc5\u987b\u6709\u5176\u4ed6\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"LinkageMappingImport_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0])));
            return false;
        }
        JSONObject modelJson = (JSONObject)data.get(MODEL);
        if (modelJson == null || modelJson.isEmpty()) {
            String msg = ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"LinkageMappingImport_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
            importlogs.add(new ImportLogger.ImportLog(msg));
            return false;
        }
        DynamicObject model = this.getModelData(data);
        if (model == null) {
            String msg = ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u5bfc\u5165\u7684\u4f53\u7cfb\u7f16\u7801\u3002", (String)"LinkageMappingImport_5", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
            importlogs.add(new ImportLogger.ImportLog(msg));
            return false;
        }
        this.modelId = model.getLong("id");
        List entryentityJson = (List)data.get("entryentity");
        HashSet<Integer> groupNums = new HashSet<Integer>(20);
        HashMap<Integer, Integer> grpWeightMap = new HashMap<Integer, Integer>();
        HashMap<String, Map<String, DynamicObject>> checkDimensionMemberCache = new HashMap<String, Map<String, DynamicObject>>();
        Map<String, DynamicObject> tempCache = this.getCache("bcm_templateentity", (JSONArray)data.get("entryentity"), "template", this.modelId);
        for (Map map : entryentityJson) {
            DynamicObject icCompany;
            Map dataJson = map;
            if (dataJson.get("groupname") == null || ((String)dataJson.get("groupname")).length() > 10) {
                importlogs.add(new ImportLogger.ImportLog("\u7ec4\u540d\u5e94\u57281-10\u4e2a\u5b57\u7b26\u4ee5\u5185"));
                return false;
            }
            JSONObject templateJson = (JSONObject)dataJson.get("template");
            if (templateJson != null) {
                String tempnumber = templateJson.getString(NUMBER);
                DynamicObject template = tempCache.get(tempnumber);
                if (template == null) {
                    importlogs.add(new ImportLogger.ImportLog(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u6a21\u677f\u7684\u7f16\u7801\u4e0d\u5b58\u5728\u3002", (String)"LinkageMappingImport_6", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), (String)"LinkageMappingImport_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0])));
                    return false;
                }
                if (this.isNoPermTemplate(this.modelId, template.getLong("id"))) {
                    importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u6a21\u677f\u7f16\u7801\uff08%s\uff09\u4e3a\u201c\u65e0\u6743\u201d\u6216\u201c\u53ea\u8bfb\u201d\u72b6\u6001\uff0c\u4e0d\u53ef\u5bfc\u5165\u3002", (String)"LinkageMappingImport_7", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[]{tempnumber})));
                    return false;
                }
                dataJson.put("template", template);
            } else {
                dataJson.put("template", null);
            }
            DynamicObject account = this.getCheckDimensionMemberCache(checkDimensionMemberCache, entryentityJson, map, ACCOUNT, "Account");
            if (account == null) {
                importlogs.add(new ImportLogger.ImportLog("\u79d1\u76ee\u6210\u5458\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728"));
                return false;
            }
            dataJson.put(ACCOUNT, account);
            if (MemberReader.isExistChangeTypeDimension((long)this.modelId)) {
                DynamicObject changeType = this.getCheckDimensionMemberCache(checkDimensionMemberCache, entryentityJson, map, "changetype", "ChangeType");
                if (changeType == null) {
                    importlogs.add(new ImportLogger.ImportLog(ResManager.loadResFormat((String)"\u53d8\u52a8\u7c7b\u578b\u6210\u5458\u7684\u7f16\u7801\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"LinkageMappingImport_8", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0])));
                    return false;
                }
                if (!changeType.getBoolean("isleaf")) {
                    importlogs.add(new ImportLogger.ImportLog(ResManager.loadResFormat((String)"\u53d8\u52a8\u7c7b\u578b\u6210\u5458\u5fc5\u987b\u662f\u660e\u7ec6\u8282\u70b9\u3002", (String)"LinkageMappingImport_9", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0])));
                    return false;
                }
                dataJson.put("changetype", changeType);
            }
            if (QueryServiceHelper.exists((String)"bcm_dimension", (QFilter[])new QFilter(MODEL, "=", (Object)this.modelId).and(NUMBER, "=", (Object)"MyCompany").toArray())) {
                DynamicObject myCompany = this.getCheckDimensionMemberCache(checkDimensionMemberCache, entryentityJson, map, MY_COMPANY, "MyCompany");
                if (myCompany == null) {
                    importlogs.add(new ImportLogger.ImportLog(ResManager.loadResFormat((String)"\u6211\u65b9\u7ec4\u7ec7\u6210\u5458\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728", (String)"LinkageMappingImport_10", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0])));
                    return false;
                }
                dataJson.put(MY_COMPANY, myCompany);
            }
            if ((icCompany = this.getCheckDimensionMemberCache(checkDimensionMemberCache, entryentityJson, map, "intercompany", "InternalCompany")) == null) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadResFormat((String)"\u5f80\u6765\u7ec4\u7ec7\u6210\u5458\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728", (String)"LinkageMappingImport_11", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0])));
                return false;
            }
            dataJson.put("intercompany", icCompany);
            if (MemberReader.isExistAuditTrailDimension((long)this.modelId)) {
                DynamicObject att = this.getCheckDimensionMemberCache(checkDimensionMemberCache, entryentityJson, map, "audittrial", "AuditTrail");
                if (att == null) {
                    importlogs.add(new ImportLogger.ImportLog(ResManager.loadResFormat((String)"\u5ba1\u8ba1\u7ebf\u7d22\u6210\u5458\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728", (String)"LinkageMappingImport_12", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0])));
                    return false;
                }
                int datasource = att.getInt("datasource");
                if (DataSourceEnum.REPORTENTRY.getCode() == datasource || DataSourceEnum.TABLEADJUSTMENT.getCode() == datasource || DataSourceEnum.AUTOMATICCALCULATION.getCode() == datasource) {
                    importlogs.add(new ImportLogger.ImportLog(ResManager.loadResFormat((String)"\u5ba1\u8ba1\u7ebf\u7d22\u6210\u5458\u4e0d\u7b26\u5408\u5206\u5f55\u8c03\u6574\u7684\u5ba1\u8ba1\u7ebf\u7d22\u8981\u6c42", (String)"LinkageMappingImport_13", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0])));
                    return false;
                }
                dataJson.put("audittrial", att);
            }
            Map dimensionMap = MemberReader.getUsetDefineDimNumberMapNameById((long)this.modelId);
            int i = 1;
            for (String dimKey : dimensionMap.keySet()) {
                DynamicObject userdefine = this.getCheckDimensionMemberCache(checkDimensionMemberCache, entryentityJson, map, "userdefined" + i, dimKey);
                if (ObjectUtils.isEmpty((Object)userdefine)) {
                    importlogs.add(new ImportLogger.ImportLog(ResManager.loadResFormat((String)"\u81ea\u5b9a\u4e49\u7ef4\u5ea6%s\u7f16\u7801\u4e0d\u5b58\u5728", (String)"LinkageMappingImport_14", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[]{i})));
                    return false;
                }
                dataJson.put("userdefined" + i++, userdefine);
            }
            Integer grpnum = this.getNumber(dataJson.get("groupnum"));
            if (grpnum == null || grpnum < 1 || grpnum > 10) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadResFormat((String)"\u5206\u7ec4\u7f16\u7801\u4e0d\u6b63\u786e\uff0c\u7f16\u7801\u53ea\u80fd\u662f1-10\u7684\u6570\u5b57\u3002", (String)"LinkageMappingImport_15", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0])));
                return false;
            }
            Integer weight = this.getNumber(dataJson.get("weight"));
            String linkagetype = (String)dataJson.get("linkagetype");
            if ("3".equals(linkagetype)) {
                dataJson.put("weight", null);
                dataJson.put("operator", null);
            } else {
                if (weight == null || weight < 1 || weight > 100) {
                    importlogs.add(new ImportLogger.ImportLog("\u8054\u52a8\u7c7b\u578b\u4e3a\u201c\u76ee\u6807\u201d,\u6743\u91cd\u9700\u8981\u586b\u5199\u6570\u503c1-100"));
                    return false;
                }
                if (ObjectUtils.isEmpty(dataJson.get("operator"))) {
                    importlogs.add(new ImportLogger.ImportLog("\u8054\u52a8\u7c7b\u578b\u4e3a\u201c\u76ee\u6807\u201d,\u5f71\u54cd\u4e0d\u80fd\u4e3a\u7a7a"));
                    return false;
                }
            }
            grpWeightMap.compute(grpnum, (k, v) -> {
                if ("3".equals(linkagetype)) {
                    return v;
                }
                return v == null ? weight : weight + v;
            });
            groupNums.add(grpnum);
        }
        if (groupNums.size() < 2) {
            importlogs.add(new ImportLogger.ImportLog("\u81f3\u5c11\u9700\u8981\u4e24\u7ec4\u6570\u636e"));
            return false;
        }
        for (Map.Entry entry : grpWeightMap.entrySet()) {
            Integer value = (Integer)entry.getValue();
            if (value == null || value == 100) continue;
            Integer key = (Integer)entry.getKey();
            importlogs.add(new ImportLogger.ImportLog("\u7ec4" + key + "\u76ee\u6807\u6743\u91cd\u548c\u4e0d\u7b49\u4e8e100"));
            return false;
        }
        String msg = this.checkeffectivedate(data);
        if (StringUtils.isNotEmpty((CharSequence)msg)) {
            importlogs.add(new ImportLogger.ImportLog(msg));
            return false;
        }
        String string = this.checkScenarios(data);
        if (StringUtils.isNotEmpty((CharSequence)string)) {
            importlogs.add(new ImportLogger.ImportLog(string));
            return false;
        }
        String msgApplyEntity = this.checkApplyEntity(data);
        if (StringUtils.isNotEmpty((CharSequence)msgApplyEntity)) {
            importlogs.add(new ImportLogger.ImportLog(msgApplyEntity));
            return false;
        }
        checkDimensionMemberCache.clear();
        return true;
    }

    private String checkApplyEntity(Map<String, Object> data) {
        this.applyEntityList = new ArrayList<Map<String, Object>>(16);
        JSONArray entityJson = (JSONArray)data.get("applyentity");
        if (entityJson == null || entityJson.isEmpty()) {
            return "";
        }
        DynamicObjectCollection entityProperty = ApplyEntityHelper.getSysProperty((Long)this.modelId, (String)"Entity");
        Map<String, DynamicObject> propertyMap = entityProperty.stream().collect(Collectors.toMap(k -> k.getString(NUMBER), v -> v, (v1, v2) -> v1));
        DynamicObjectCollection entityPropertyValue = ApplyEntityHelper.getSysPropertyValue((Long)this.modelId, (String)"Entity");
        Map<String, DynamicObject> propertyValueMap = entityPropertyValue.stream().collect(Collectors.toMap(k -> k.getString(NUMBER), v -> v, (v1, v2) -> v1));
        String modelNumber = MemberReader.findModelNumberById((Object)this.modelId);
        int seq = 1;
        for (Object item : entityJson) {
            Object isexcept = ((JSONObject)item).get((Object)"entityisexcept");
            Object entitynum = ((JSONObject)item).get((Object)"entitynum");
            Object entityrange = ((JSONObject)item).get((Object)"entityrange");
            if (ObjectUtils.isEmpty((Object)isexcept) || ObjectUtils.isEmpty((Object)entitynum) || ObjectUtils.isEmpty((Object)entityrange)) {
                return ResManager.loadKDString((String)"\u9002\u7528\u7ec4\u7ec7\u586b\u5199\u4e0d\u5b8c\u6574\u3002", (String)"LinkageMappingImport_16", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
            }
            HashMap<String, Object> rowObj = new HashMap<String, Object>(16);
            rowObj.put("seq", seq++);
            rowObj.put("entityisexcept", isexcept);
            rowObj.put("entityrange", entityrange);
            if (entitynum.toString().contains(":")) {
                String[] split = entitynum.toString().split(":");
                DynamicObject property = propertyMap.get(split[0]);
                DynamicObject propertyValue = propertyValueMap.get(split[1]);
                if (propertyValue == null || property == null) {
                    return ResManager.loadKDString((String)"\u9002\u7528\u7ec4\u7ec7\u7684\u201c\u81ea\u5b9a\u4e49\u5c5e\u6027\u201d\u7684\u7f16\u7801\u586b\u5199\u4e0d\u6b63\u786e\u3002", (String)"LinkageMappingImport_17", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
                }
                DynamicObject propertyDyn = BusinessDataServiceHelper.newDynamicObject((String)"bcm_definedproperty");
                propertyDyn.set("id", (Object)property.getLong("id"));
                rowObj.put("property", propertyDyn);
                DynamicObject propertyValueDyn = BusinessDataServiceHelper.newDynamicObject((String)"bcm_definedpropertyvalue");
                propertyValueDyn.set("id", (Object)propertyValue.getLong("id"));
                rowObj.put("propertyvalue", propertyValueDyn);
            } else {
                IDNumberTreeNode entityTreeNode = MemberReader.findEntityMemberByNum((String)modelNumber, (String)entitynum.toString());
                if (entityTreeNode == IDNumberTreeNode.NotFoundTreeNode) {
                    return ResManager.loadKDString((String)"\u9002\u7528\u7ec4\u7ec7\u7684\u201c\u7f16\u7801\u201d\u586b\u5199\u4e0d\u6b63\u786e\u3002", (String)"LinkageMappingImport_18", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
                }
                DynamicObject entityDyn = BusinessDataServiceHelper.newDynamicObject((String)"bcm_entitymembertree");
                entityDyn.set("id", (Object)entityTreeNode.getId());
                rowObj.put("entitymeb", entityDyn);
            }
            this.applyEntityList.add(rowObj);
        }
        return "";
    }

    private String checkScenarios(Map<String, Object> data) {
        this.scenarioList = new ArrayList<Map<String, Object>>(16);
        JSONArray scenariosJson = (JSONArray)data.get("scenarios");
        if (scenariosJson == null || scenariosJson.isEmpty()) {
            return ResManager.loadKDString((String)"\u9002\u7528\u60c5\u666f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LinkageMappingImport_19", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
        }
        int seq = 1;
        for (Object entryJson : scenariosJson) {
            Object isexcept = ((JSONObject)entryJson).get((Object)"isexcept");
            Object scenariomeb = ((JSONObject)entryJson).get((Object)"scenariomeb");
            Object scope = ((JSONObject)entryJson).get((Object)"scenarioscope");
            if (ObjectUtils.isEmpty((Object)isexcept) || ObjectUtils.isEmpty((Object)scenariomeb) || ObjectUtils.isEmpty((Object)scope)) {
                return ResManager.loadKDString((String)"\u9002\u7528\u60c5\u666f\u586b\u5199\u4e0d\u5b8c\u6574\u3002", (String)"LinkageMappingImport_20", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
            }
            String sceneNum = ((JSONObject)scenariomeb).getString(NUMBER);
            if (StringUtils.isEmpty((CharSequence)sceneNum)) {
                return ResManager.loadKDString((String)"\u9002\u7528\u60c5\u666f\u586b\u5199\u4e0d\u5b8c\u6574\u3002", (String)"LinkageMappingImport_20", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
            }
            IDNumberTreeNode scene = MemberReader.findScenaMemberByNum((String)MemberReader.findModelNumberById((Object)this.modelId), (String)sceneNum);
            if (scene == IDNumberTreeNode.NotFoundTreeNode) {
                return ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u5bfc\u5165\u7684\u60c5\u666f\u7f16\u7801\u3002", (String)"LinkageMappingImport_21", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
            }
            HashMap<String, Object> rowObj = new HashMap<String, Object>(16);
            rowObj.put("seq", seq);
            rowObj.put("isexcept", isexcept);
            DynamicObject member = BusinessDataServiceHelper.newDynamicObject((String)"bcm_scenemembertree");
            member.set("id", (Object)scene.getId());
            rowObj.put("scenariomeb", member);
            rowObj.put("scenarioscope", scope);
            ++seq;
            this.scenarioList.add(rowObj);
        }
        return this.checkEffectiveScenario(this.scenarioList);
    }

    private String checkEffectiveScenario(List<Map<String, Object>> settings) {
        if (!settings.isEmpty()) {
            HashMap membRangeItemCache = new HashMap(16);
            HashSet applyScenarios = new HashSet(16);
            HashSet noScenarios = new HashSet(16);
            settings.forEach(map -> {
                IDNumberTreeNode sceneTreeNode = MemberReader.findScenaMemberById((Long)this.modelId, (Long)((DynamicObject)map.get("scenariomeb")).getLong("id"));
                if (!sceneTreeNode.isLeaf() && Integer.parseInt(map.get("scenarioscope").toString()) == RangeEnum.VALUE_10.getValue()) {
                    return;
                }
                MembRangeItem item = new MembRangeItem("bcm_scenemembertree", Long.valueOf(((DynamicObject)map.get("scenariomeb")).getLong("id")), ((DynamicObject)map.get("scenariomeb")).getString(NUMBER), Integer.parseInt(map.get("scenarioscope").toString()), false, (Object)this.modelId);
                String key = item.genKey((Object)"");
                Set nums = membRangeItemCache.computeIfAbsent(key, v -> {
                    HashSet numberSet = new HashSet(16);
                    item.matchItems(c -> numberSet.add(Pair.onePair((Object)c.getId(), (Object)c.getNumber())));
                    return numberSet;
                });
                if (PaperTemplateScenarioSettingConstant.ExceptEnum.APPLICABLE.getCode().equals(map.get("isexcept").toString())) {
                    applyScenarios.addAll(nums);
                } else {
                    noScenarios.addAll(nums);
                }
            });
            applyScenarios.removeAll(noScenarios);
            if (applyScenarios.isEmpty()) {
                return ResManager.loadKDString((String)"\u60c5\u666f\u89e3\u6790\u540e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002", (String)"LinkageMappingImport_22", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
            }
        }
        return "";
    }

    private Integer getNumber(Object obj) {
        Integer res = null;
        try {
            if (obj != null) {
                res = Integer.parseInt(obj.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return res;
    }

    private String checkeffectivedate(Map<String, Object> data) {
        this.effectivedate = new ArrayList<Map<String, Object>>();
        JSONArray effectiveJson = (JSONArray)data.get("effective");
        if (effectiveJson != null && effectiveJson.size() > 0) {
            Map<String, DynamicObject> effectiveyearCache = this.getCache("bcm_fymembertree", effectiveJson, "effectiveyear", this.modelId);
            Map<String, DynamicObject> effectiveperiodCache = this.getCache("bcm_periodmembertree", effectiveJson, "effectiveperiod", this.modelId);
            for (Object entryJson : effectiveJson) {
                HashMap<String, Object> effectivedateMap = new HashMap<String, Object>();
                Object applytype = ((JSONObject)entryJson).get((Object)"applytype");
                Object yearscope = ((JSONObject)entryJson).get((Object)"yearscope");
                if (ObjectUtils.isEmpty((Object)applytype) && ObjectUtils.isEmpty((Object)yearscope)) continue;
                if (ObjectUtils.isEmpty((Object)applytype) || ObjectUtils.isEmpty((Object)yearscope)) {
                    return ResManager.loadKDString((String)"\u5206\u7ec4\u540d\u79f0\uff0c\u8d22\u5e74\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a", (String)"LinkageMappingImport_23", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
                }
                effectivedateMap.put("applytype", applytype);
                effectivedateMap.put("yearscope", yearscope);
                JSONObject yearJson = (JSONObject)((JSONObject)entryJson).get((Object)"effectiveyear");
                JSONObject periodJson = (JSONObject)((JSONObject)entryJson).get((Object)"effectiveperiod");
                DynamicObject year = null;
                DynamicObject period = null;
                if (yearJson != null) {
                    year = effectiveyearCache.get(yearJson.getString(NUMBER));
                    if (year == null) {
                        return ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u8d22\u5e74\u7f16\u7801\u4e0d\u5b58\u5728", (String)"LinkageMappingImport_24", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), (String)"LinkageMappingImport_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
                    }
                    effectivedateMap.put("effectiveyear", year);
                }
                if (periodJson != null) {
                    period = effectiveperiodCache.get(periodJson.getString(NUMBER));
                    if (period == null) {
                        return ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u671f\u95f4\u7f16\u7801\u4e0d\u5b58\u5728", (String)"LinkageMappingImport_25", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), (String)"LinkageMappingImport_5", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
                    }
                    effectivedateMap.put("effectiveperiod", period);
                }
                if (ObjectUtils.isEmpty(year) && ObjectUtils.isEmpty(period)) {
                    return ResManager.loadKDString((String)"\u8d22\u5e74\u671f\u95f4\u4e0d\u80fd\u90fd\u4e3a\u7a7a", (String)"LinkageMappingImport_26", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
                }
                this.effectivedate.add(effectivedateMap);
            }
        }
        return "";
    }

    @Deprecated
    private DynamicObject checkDimensionMember(Map<String, Object> data, String dimensionnumber) {
        JSONObject scenJson = (JSONObject)data.get(dimensionnumber);
        if (scenJson != null && !scenJson.isEmpty()) {
            switch (dimensionnumber) {
                case "intercompany": {
                    dimensionnumber = "InternalCompany";
                    break;
                }
                case "audittrial": {
                    dimensionnumber = "audittrail";
                    break;
                }
            }
            String entity = DimensionServiceHelper.getDimMembEntityNumByDimNum((String)dimensionnumber);
            String select = "id,isleaf,name,number" + ("bcm_userdefinedmembertree".equalsIgnoreCase(entity) ? ",dimension" : "");
            return BusinessDataServiceHelper.loadSingleFromCache((String)entity, (String)select, (QFilter[])new QFilter(MODEL, "=", (Object)this.modelId).and(NUMBER, "=", scenJson.get((Object)NUMBER)).toArray());
        }
        return null;
    }

    private DynamicObject getCheckDimensionMemberCache(Map<String, Map<String, DynamicObject>> checkDimensionMemberCache, List<Map<String, Object>> entryentityJson, Map<String, Object> data, String dimensionnumber, String dimKey) {
        if (MapUtils.isNotEmpty(data) && data.get(dimensionnumber) != null) {
            JSONObject scenJson = (JSONObject)data.get(dimensionnumber);
            String key = scenJson.getString(NUMBER);
            if (checkDimensionMemberCache.containsKey(dimensionnumber)) {
                Map<String, DynamicObject> dyMap = checkDimensionMemberCache.get(dimensionnumber);
                return dyMap.get(key);
            }
            Set<String> numberSet = new HashSet<String>();
            if (entryentityJson == null) {
                numberSet.add(key);
            } else {
                String finalDimensionnumber = dimensionnumber;
                numberSet = entryentityJson.stream().map(r -> r.getOrDefault(finalDimensionnumber, new JSONObject()).get((Object)NUMBER)).collect(Collectors.toSet());
            }
            String dimenNumberKey = dimensionnumber;
            switch (dimensionnumber) {
                case "intercompany": {
                    dimensionnumber = "InternalCompany";
                    break;
                }
                case "audittrial": {
                    dimensionnumber = "audittrail";
                    break;
                }
            }
            String entity = DimensionServiceHelper.getDimMembEntityNumByDimNum((String)dimensionnumber);
            String select = "id,isleaf,name,number,storagetype" + ("bcm_userdefinedmembertree".equalsIgnoreCase(entity) ? ",dimension" : "");
            if ("bcm_audittrialmembertree".equalsIgnoreCase(entity)) {
                select = select + ",datasource";
            }
            QFBuilder qb = new QFBuilder(MODEL, "=", (Object)this.modelId).and(NUMBER, "in", numberSet);
            if (!"bcm_entitymembertree".equalsIgnoreCase(entity)) {
                qb.add("storagetype", "!=", (Object)StorageTypeEnum.SHARE.getOIndex());
                if ("bcm_userdefinedmembertree".equalsIgnoreCase(entity)) {
                    qb.add("dimension.number", "=", (Object)dimKey);
                }
            }
            DynamicObject[] dyArray = BusinessDataServiceHelper.load((String)entity, (String)select, (QFilter[])qb.toArray());
            HashMap<String, DynamicObject> collect = new HashMap<String, DynamicObject>(dyArray.length);
            for (DynamicObject dy : dyArray) {
                collect.computeIfAbsent(dy.getString(NUMBER), a -> dy);
            }
            checkDimensionMemberCache.put(dimenNumberKey, collect);
            return (DynamicObject)collect.get(key);
        }
        return null;
    }

    private boolean checkStrLenth(String name, int length) {
        if (name == null) {
            return true;
        }
        return name.length() > length;
    }

    public List<Object> importData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        String action;
        switch (action = (String)option.get("importtype")) {
            case "overridenew": {
                return this.overridenew(data, option, importlogs);
            }
            case "override": {
                return this.override(data, option, importlogs);
            }
            case "new": {
                return this.addNew(data, option, importlogs);
            }
        }
        return new ArrayList<Object>();
    }

    private List<Object> addNew(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        ArrayList<Object> success = new ArrayList<Object>();
        DynamicObjectCollection temp = QueryServiceHelper.query((String)this.entityName, (String)"id", (QFilter[])this.getUniqueFilters(data));
        try (TXHandle tx = TX.required();){
            try {
                if (temp == null || temp.isEmpty()) {
                    DynamicObject newDyn = this.buildDyn(data, option, importlogs, false);
                    if (newDyn != null) {
                        DynamicObject[] sucessIds = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newDyn});
                        success.add(sucessIds[0].get("id"));
                    }
                } else {
                    String msg = ResManager.loadKDString((String)"\u7f16\u7801\u5b58\u5728\u91cd\u590d\uff0c\u65e0\u6cd5\u65b0\u589e", (String)"LinkageMappingImport_27", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
                    importlogs.add(new ImportLogger.ImportLog(msg));
                }
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
        return success;
    }

    private List<Object> override(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        ArrayList<Object> success = new ArrayList<Object>();
        try (TXHandle tx = TX.required();){
            try {
                if (this.deleteRepeatData(data)) {
                    DynamicObject newDyn = this.buildDyn(data, option, importlogs, true);
                    if (newDyn != null) {
                        DynamicObject[] sucessIds = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newDyn});
                        success.add(sucessIds[0].get("id"));
                    }
                } else {
                    String msg = ResManager.loadKDString((String)"\u672c\u6761\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8986\u76d6\u5931\u8d25", (String)"LinkageMappingImport_28", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
                    importlogs.add(new ImportLogger.ImportLog(msg));
                }
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
        return success;
    }

    private List<Object> overridenew(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        ArrayList<Object> success = new ArrayList<Object>();
        try (TXHandle tx = TX.required();){
            try {
                boolean isModify = this.deleteRepeatData(data);
                DynamicObject newDyn = this.buildDyn(data, option, importlogs, isModify);
                if (newDyn != null) {
                    DynamicObject[] sucessIds = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newDyn});
                    success.add(sucessIds[0].get("id"));
                }
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
        return success;
    }

    public boolean deleteRepeatData(Map<String, Object> data) {
        QFilter[] filters = this.getUniqueFilters(data);
        DynamicObject createData = BusinessDataServiceHelper.loadSingle((String)this.entityName, (String)"id,creator,createtime", (QFilter[])filters);
        if (createData != null) {
            DeleteServiceHelper.delete((String)this.entityName, (QFilter[])filters);
            return true;
        }
        return false;
    }

    private QFilter[] getUniqueFilters(Map<String, Object> data) {
        QFilter modelFilter = new QFilter(MODEL, "=", (Object)this.modelId);
        QFilter nameQf = new QFilter(NUMBER, "=", data.get(NUMBER));
        return new QFilter[]{modelFilter, nameQf};
    }

    private DynamicObject buildDyn(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs, boolean isModify) {
        DynamicObject dyn = BusinessDataServiceHelper.newDynamicObject((String)this.entityName);
        Object name = data.get("name");
        if (name instanceof Map) {
            dyn.set("name", (Object)LocaleString.fromMap((Map)((Map)name)).toString().trim());
        } else {
            dyn.set("name", (Object)name.toString().trim());
        }
        dyn.set(NUMBER, data.get(NUMBER));
        dyn.set(MODEL, (Object)this.modelId);
        dyn.set("status", data.get("status") == null ? Integer.valueOf(0) : data.get("status"));
        dyn.set("description", data.get("description"));
        dyn = this.buildEntryentityData(data, dyn, importlogs);
        if (dyn == null) {
            return dyn;
        }
        this.buildEffectiveData(data, dyn, importlogs);
        this.buildApply(data, dyn, importlogs);
        dyn.set("modifier", (Object)Long.valueOf(RequestContext.get().getUserId()));
        dyn.set("modifytime", (Object)TimeServiceHelper.now());
        return dyn;
    }

    private Map<String, DynamicObject> getCache(String entityName, JSONArray entryentityJson, String entryKey, Long modelId) {
        HashMap<String, DynamicObject> resultMap = new HashMap<String, DynamicObject>();
        HashSet<String> queryParam = new HashSet<String>();
        for (Object entryJson : entryentityJson) {
            JSONObject dataJson = (JSONObject)entryJson;
            JSONObject jsonObject = (JSONObject)dataJson.get((Object)entryKey);
            if (jsonObject == null) continue;
            queryParam.add(jsonObject.getString(NUMBER));
        }
        if (CollectionUtils.isNotEmpty(queryParam)) {
            QFilter q = new QFilter(NUMBER, "in", queryParam);
            QFilter f = new QFilter(MODEL, "=", (Object)modelId);
            Map map = BusinessDataServiceHelper.loadFromCache((String)entityName, (String)"id", (QFilter[])new QFilter[]{q, f});
            if (map != null) {
                map.values().forEach(r -> resultMap.computeIfAbsent(r.getString(NUMBER), a -> r));
            }
        }
        return resultMap;
    }

    private boolean isNoPermTemplate(long modelId, long templateId) {
        return ((Set)ThreadCache.get((Object)("templatePerm" + modelId), () -> PermClassCache.getPermClassIds((Long)modelId, (String)"bcm_templateentity", (DataTypeEnum[])new DataTypeEnum[]{DataTypeEnum.READ, DataTypeEnum.NO}))).contains(templateId);
    }

    private DynamicObject buildEntryentityData(Map<String, Object> data, DynamicObject dyn, List<ImportLogger.ImportLog> importlogs) {
        DynamicObjectCollection entry = dyn.getDynamicObjectCollection("entryentity");
        JSONArray entryentityJson = (JSONArray)data.get("entryentity");
        if (entryentityJson == null) {
            return dyn;
        }
        for (Object entryJson : entryentityJson) {
            DynamicObject att;
            DynamicObject newEntryObj = entry.addNew();
            JSONObject dataJson = (JSONObject)entryJson;
            ArrayList<String> dimShows = new ArrayList<String>(10);
            newEntryObj.set("template", dataJson.get((Object)"template"));
            newEntryObj.set("groupnum", dataJson.get((Object)"groupnum"));
            newEntryObj.set("groupname", dataJson.get((Object)"groupname"));
            newEntryObj.set("linkagetype", dataJson.get((Object)"linkagetype"));
            newEntryObj.set("weight", (Object)dataJson.getInteger("weight"));
            newEntryObj.set("operator", dataJson.get((Object)"operator"));
            newEntryObj.set("accountrange", (Object)10);
            DynamicObject account = (DynamicObject)dataJson.get((Object)ACCOUNT);
            newEntryObj.set("accountrange", (Object)(account.getBoolean("isleaf") ? 10 : 90));
            newEntryObj.set(ACCOUNT, (Object)account);
            String rangeText = this.getRangeText(account);
            String dimShow = "\u3010" + ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u79d1\u76ee", (String)"LinkageMappingImport_29", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), (String)"LinkageMappingImport_9", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]) + "\uff01" + (!rangeText.isEmpty() ? String.format(rangeText, account.get("name")) : account.get("name")) + "\u3011 ";
            dimShows.add(dimShow);
            if (MemberReader.isExistChangeTypeDimension((long)this.modelId) && dataJson.get((Object)"changetype") instanceof DynamicObject) {
                newEntryObj.set("changetyperange", (Object)10);
                DynamicObject changetype = (DynamicObject)dataJson.get((Object)"changetype");
                newEntryObj.set("changetype", (Object)changetype);
                rangeText = this.getRangeText(changetype);
                dimShow = "\u3010" + ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u53d8\u52a8\u7c7b\u578b", (String)"LinkageMappingImport_30", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), (String)"LinkageMappingImport_10", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]) + "\uff01" + (!rangeText.isEmpty() ? String.format(rangeText, changetype.get("name")) : changetype.get("name")) + "\u3011 ";
                dimShows.add(dimShow);
            }
            if (!ObjectUtils.isEmpty((Object)dataJson.get((Object)MY_COMPANY)) && dataJson.get((Object)MY_COMPANY) instanceof DynamicObject) {
                DynamicObject mycompany = (DynamicObject)dataJson.get((Object)MY_COMPANY);
                newEntryObj.set(MY_COMPANY, (Object)mycompany);
                rangeText = this.getRangeText(mycompany);
                dimShow = "\u3010" + ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u6211\u65b9\u7ec4\u7ec7", (String)"LinkageMappingImport_31", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), (String)"LinkageMappingImport_11", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]) + "\uff01" + (!rangeText.isEmpty() ? String.format(rangeText, mycompany.get("name")) : mycompany.get("name")) + "\u3011 ";
                dimShows.add(dimShow);
                newEntryObj.set("mycompanyrange", (Object)(mycompany.getBoolean("isleaf") ? 10 : 90));
            }
            if (dataJson.get((Object)"intercompany") instanceof DynamicObject) {
                DynamicObject intercompany = (DynamicObject)dataJson.get((Object)"intercompany");
                newEntryObj.set("intercompany", (Object)intercompany);
                rangeText = this.getRangeText(intercompany);
                dimShow = "\u3010" + ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u5f80\u6765\u7ec4\u7ec7", (String)"LinkageMappingImport_32", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), (String)"LinkageMappingImport_12", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]) + "\uff01" + (!rangeText.isEmpty() ? String.format(rangeText, intercompany.get("name")) : intercompany.get("name")) + "\u3011 ";
                dimShows.add(dimShow);
                newEntryObj.set("intercompanyrange", (Object)(intercompany.getBoolean("isleaf") ? 10 : 90));
            }
            if (dataJson.get((Object)"audittrial") instanceof DynamicObject && (att = (DynamicObject)dataJson.get((Object)"audittrial")) != null) {
                newEntryObj.set("audittrial", (Object)att);
                rangeText = this.getRangeText(att);
                dimShow = "\u3010" + ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u5ba1\u8ba1\u7ebf\u7d22", (String)"LinkageMappingImport_33", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), (String)"LinkageMappingImport_12", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]) + "\uff01" + (!rangeText.isEmpty() ? String.format(rangeText, att.get("name")) : att.get("name")) + "\u3011 ";
                dimShows.add(dimShow);
            }
            for (int i = 1; i <= 6; ++i) {
                DynamicObject userdfine;
                if (!(dataJson.get((Object)("userdefined" + i)) instanceof DynamicObject) || (userdfine = (DynamicObject)dataJson.get((Object)("userdefined" + i))) == null) continue;
                rangeText = this.getRangeText(userdfine);
                newEntryObj.set("userdefined" + i, (Object)userdfine);
                newEntryObj.set("userdefinedrange" + i, (Object)(userdfine.getBoolean("isleaf") ? 10 : 90));
                dimShows.add("\u3010" + userdfine.getString("dimension.name") + "\uff01" + (!rangeText.isEmpty() ? String.format(rangeText, userdfine.get("name")) : userdfine.get("name")) + "\u3011 ");
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < dimShows.size(); ++i) {
                if (StringUtils.isBlank((CharSequence)((CharSequence)dimShows.get(i)))) continue;
                sb.append((String)dimShows.get(i));
            }
            newEntryObj.set("dimshow", (Object)sb.toString());
            newEntryObj.set("seq", (Object)1);
        }
        return dyn;
    }

    private String getRangeText(DynamicObject member) {
        boolean isleaf = Boolean.parseBoolean(member.get("isleaf").toString());
        return isleaf ? "" : ResManager.loadKDString((String)"%s\u7684\u6240\u6709\u4e0b\u7ea7\u660e\u7ec6\u6210\u5458", (String)"LinkageMappingImport_34", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    private void buildEffectiveData(Map<String, Object> data, DynamicObject dyn, List<ImportLogger.ImportLog> importlogs) {
        DynamicObjectCollection entry = dyn.getDynamicObjectCollection("effective");
        this.effectivedate.stream().forEach(p -> {
            DynamicObject newEntryObj = entry.addNew();
            newEntryObj.set("applytype", p.get("applytype"));
            DynamicObject year = (DynamicObject)p.get("effectiveyear");
            newEntryObj.set("effectiveyear", (Object)year);
            newEntryObj.set("yearscope", (Object)(ObjectUtils.isEmpty(p.get("yearscope")) ? Integer.valueOf(2) : p.get("yearscope")));
            DynamicObject period = (DynamicObject)p.get("effectiveperiod");
            newEntryObj.set("effectiveperiod", (Object)period);
        });
    }

    private void buildApply(Map<String, Object> data, DynamicObject dyn, List<ImportLogger.ImportLog> importlogs) {
        DynamicObjectCollection scenarios = dyn.getDynamicObjectCollection("scenarios");
        this.scenarioList.forEach(map -> {
            DynamicObject rowObj = scenarios.addNew();
            map.entrySet().forEach(entry -> rowObj.set((String)entry.getKey(), entry.getValue()));
        });
        if (this.applyEntityList != null && !this.applyEntityList.isEmpty()) {
            DynamicObjectCollection applyEntity = dyn.getDynamicObjectCollection("applyentity");
            this.applyEntityList.forEach(map -> {
                DynamicObject rowObj = applyEntity.addNew();
                map.entrySet().forEach(entry -> rowObj.set((String)entry.getKey(), entry.getValue()));
            });
        }
    }

    private DynamicObject getModelData(Map<String, Object> data) {
        JSONObject modelJson = (JSONObject)data.get(MODEL);
        String number = (String)modelJson.get((Object)"shownumber");
        QFilter numberFilter = new QFilter("shownumber", "=", (Object)number);
        DynamicObject model = BusinessDataServiceHelper.loadSingle((String)"bcm_model", (String)"id", (QFilter[])new QFilter[]{numberFilter});
        if (model != null) {
            return model;
        }
        return null;
    }
}

