/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.linkagemapping;

import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.adjust.link.LinkageMappingServiceHelper;
import kd.fi.bcm.business.adjust.util.ApplyEntityHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.model.UserSelectModel;
import kd.fi.bcm.business.permission.permclass.PermClassCache;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.common.MessageConstant;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.Permission.DataTypeEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.TemplateCatalogTypeEnum;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.papertemplate.PaperTemplateSceneSettingHelper;
import kd.fi.bcm.common.util.BCMTreeUtils;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.guidemenu.GuidePageUtils;
import kd.fi.bcm.formplugin.linkagemapping.util.LinkageMappingUtil;
import kd.fi.bcm.formplugin.util.CodeRuleUtil;
import kd.fi.bcm.formplugin.util.ReportListUtil;
import kd.fi.bcm.formplugin.util.SearchUtil;
import kd.fi.bcm.formplugin.util.ShowOperationMsgUtil;
import kd.fi.bcm.formplugin.util.UserSelectUtil;
import kd.fi.bcm.spread.common.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;

public class LinkageMappingListPlugin
extends AbstractBaseListPlugin {
    private static final String TEMPLATE_TREE = "treeviewap";
    private static final String BILLLISTAP = "billlistap";
    private static final String ZERO_STR = "0";
    private static final String TREE_CACHE = "tree_cache";
    private static final String NOTEMPLATEID = "NOTEMPLATEID123456";
    private static final String CATALOG_ID_LIST = "CATALOG_ID_LIST";
    private static final String INCLUDENOMAPPING = "includenomapping";
    private static final String NUMBER = "number";
    private static final String CACHE_KEY_SCENARIOTEXT = "cache_key_scenariotext";
    private static final String CACHE_KEY_ENTITYTEXT = "cache_key_entitytext";

    private String getOperationDoubleCheck() {
        return ResManager.loadKDString((String)"\u91cd\u590d\u6821\u9a8c", (String)"LinkageMappingListPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getOperationUpdate() {
        return ResManager.loadKDString((String)"\u66f4\u65b0\u5168\u90e8\u6807\u8bc6", (String)"LinkageMappingListPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    @Override
    public void initialize() {
        super.initialize();
        HashMap map = new HashMap(16);
        this.asMapF7toType(Collections.singletonList("scenario"), SingleF7TypeEnum.LEAF, map);
        this.initSingleMemberF7(map);
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        billList.setBillFormId("bcm_linkagemapping");
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("vectorap_up", "vectorap_down");
        TreeView tree = (TreeView)this.getControl(TEMPLATE_TREE);
        tree.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                if (LinkageMappingListPlugin.this.isNoModel()) {
                    return;
                }
                LinkageMappingListPlugin.this.getPageCache().put("selectFocusTemplateId", (String)evt.getNodeId());
                LinkageMappingListPlugin.this.refreshList();
            }
        });
        IFormView view = this.getView();
        IPageCache pageCache = this.getPageCache();
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener(event -> {
            if (StringUtils.isNotEmpty((String)event.getText())) {
                SearchUtil.searchMember(event.getText(), view, pageCache, tree, TREE_CACHE);
            } else {
                pageCache.put("resultlist", null);
                this.getView().showTipNotification(MessageConstant.getMEMBER_NOINPUT());
            }
        });
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        args.setCancel(true);
        BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
        ArrayList<Object> selectIds = new ArrayList<Object>(16);
        list.getSelectedRows().forEach(e -> {
            if (!selectIds.contains(e.getPrimaryKeyValue())) {
                selectIds.add(e.getPrimaryKeyValue());
            }
        });
        this.showLinkageMappingEditForm(list.getFocusRowPkId().toString(), null, selectIds);
        DynamicObject data = QueryServiceHelper.queryOne((String)"bcm_linkagemapping", (String)"id, status,name,number", (QFilter[])new QFBuilder("id", "in", this.getSelectedRowIds()).toArray());
        this.writeOperationLog(OpItemEnum.LOOKUP.getName(), data.getString(NUMBER), data.getString("name"), ResultStatusEnum.SUCCESS.getName());
    }

    @Override
    public void listRowDoubleClick(ListRowClickEvent evt) {
        super.listRowDoubleClick(evt);
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        this.showLinkageMappingEditForm(billList.getSelectedRows().get(0).getPrimaryKeyValue().toString(), null, null);
        evt.setCancel(true);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String modelId = (String)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        if (!(GuidePageUtils.isFromGuide(this.getView()) || StringUtils.isEmpty((String)modelId) || ZERO_STR.equals(modelId))) {
            UserSelectUtil.saveUserSelectWhenModelChange(this.getView(), modelId);
            UserSelectModel sm = UserSelectUtil.getUserSelectAfterCreateNewData(this.getView(), modelId, false);
            String scenarioId = sm.getScene();
            if (StringUtil.isEmptyString((String)scenarioId) || ZERO_STR.equals(scenarioId)) {
                scenarioId = this.getDefaultScenarioId(modelId);
                sm.setScene(scenarioId);
            }
            this.savetUserSelectWhenOtherChange("scenario", new UserSelectModel());
        }
        this.refreshBillByUserSelect(Collections.singletonList("scenario"), false);
        this.getPageCache().put("KEY_MODEL_ID", this.getModel().getValue("model_id").toString());
        this.refreshTemplateTree();
        this.refreshList(false);
    }

    private String getDefaultScenarioId(String modelId) {
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        qf.and("isleaf", "=", (Object)true);
        DynamicObject object = QueryServiceHelper.queryOne((String)"bcm_scenemembertree", (String)"id", (QFilter[])qf.toArray());
        return object == null ? ZERO_STR : object.getString("id");
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        if (!this.getModelSign().equals(((BasedataEdit)beforeF7SelectEvent.getSource()).getKey()) && this.getModelId() == 0L) {
            beforeF7SelectEvent.setCancel(true);
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"LinkageMappingListPlugin_41", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        super.beforeF7Select(beforeF7SelectEvent);
    }

    private void refreshTemplateTree() {
        long modelId = Long.parseLong(this.getPageCache().get("KEY_MODEL_ID"));
        TreeView treeView = (TreeView)this.getControl(TEMPLATE_TREE);
        treeView.deleteAllNodes();
        boolean flag = (Boolean)this.getModel().getValue(INCLUDENOMAPPING);
        DynamicObjectCollection templateCollection = this.getTemplateCollection(modelId);
        if (!flag) {
            this.removeTemNoLinkagemapping(templateCollection, modelId);
        }
        List noPermIds = null;
        if (!MemberPermHelper.ifUserHasRootPermByModel((long)Long.parseLong(RequestContext.get().getUserId()), (String)String.valueOf(modelId))) {
            ArrayListMultimap map = PermClassEntityHelper.getPermissionMap((String)"bcm_templateentity", (String)String.valueOf(this.getModelId()), (String)String.valueOf(this.getUserId()));
            noPermIds = map.get((Object)"1");
        }
        if (noPermIds == null) {
            noPermIds = Collections.emptyList();
        }
        TemplateUtil.filterVersionTemplateTree((Collection)templateCollection);
        HashSet<Long> parents = new HashSet<Long>();
        Iterator it = templateCollection.iterator();
        while (it.hasNext()) {
            DynamicObject object = (DynamicObject)it.next();
            long templateId = object.getLong("id");
            if (noPermIds.contains(templateId)) {
                it.remove();
                continue;
            }
            parents.add(object.getLong("templatecatalog"));
        }
        DynamicObjectCollection templateCatalogCollection = this.getTemplateCatalogCollection(modelId);
        int a = parents.size();
        int b = -1;
        while (a != b) {
            a = parents.size();
            for (DynamicObject object : templateCatalogCollection) {
                long id = object.getLong("id");
                if (!parents.contains(id)) continue;
                parents.add(object.getLong("parent"));
            }
            b = parents.size();
        }
        Iterator iterator = templateCatalogCollection.iterator();
        while (iterator.hasNext()) {
            DynamicObject object;
            object = (DynamicObject)iterator.next();
            long catalogId = object.getLong("id");
            if (parents.contains(catalogId)) continue;
            iterator.remove();
        }
        ArrayList catalogIdList = new ArrayList();
        templateCatalogCollection.forEach(e -> catalogIdList.add(e.getLong("id")));
        this.getPageCache().put(CATALOG_ID_LIST, SerializationUtils.toJsonString(catalogIdList));
        TreeNode rootNode = ReportListUtil.getTemplateTree(templateCatalogCollection, templateCollection, new ArrayList<TreeNode>(), ZERO_STR, new TreeNode());
        BCMTreeUtils.spreadAllNode((TreeNode)rootNode);
        treeView.addNode(rootNode);
        List chil = rootNode.getChildren();
        if (chil == null || chil.isEmpty()) {
            return;
        }
        this.getPageCache().put(TREE_CACHE, SerializationUtils.toJsonString(chil.get(0)));
        treeView.focusNode((TreeNode)chil.get(0));
        if (flag) {
            List list = ((TreeNode)chil.get(0)).getChildren();
            if (list == null) {
                ((TreeNode)chil.get(0)).addChild(new TreeNode(rootNode.getId(), NOTEMPLATEID, ResManager.loadKDString((String)"\u4e0d\u533a\u5206\u6a21\u677f", (String)"LinkageMappingListPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
            } else {
                list.add(0, new TreeNode(rootNode.getId(), NOTEMPLATEID, ResManager.loadKDString((String)"\u4e0d\u533a\u5206\u6a21\u677f", (String)"LinkageMappingListPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
            }
        }
    }

    private void removeTemNoLinkagemapping(DynamicObjectCollection templateCollection, long modelId) {
        ArrayList<Long> dbids;
        Iterator iterator;
        block27: {
            iterator = templateCollection.iterator();
            ArrayList<Long> ids = new ArrayList<Long>();
            dbids = new ArrayList<Long>();
            while (iterator.hasNext()) {
                DynamicObject object = (DynamicObject)iterator.next();
                long templateId = object.getLong("id");
                ids.add(templateId);
            }
            QFilter q = new QFilter("entryentity.template", "in", ids);
            q.and(new QFilter("model", "=", (Object)modelId));
            q.and("id", "in", (Object)LinkageMappingServiceHelper.queryIds((long)modelId, (long)LongUtil.toLong((Object)this.getScenarioId())));
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bcm_linkagemapping", (String)"entryentity.template", (QFilter[])q.toArray(), null);){
                if (ds == null) break block27;
                GroupbyDataSet dss = ds.groupBy(new String[]{"entryentity.template"});
                try (DataSet dsg = dss.finish();){
                    for (Row row : dsg) {
                        dbids.add(row.getLong("entryentity.template"));
                    }
                }
            }
        }
        iterator = templateCollection.iterator();
        while (iterator.hasNext()) {
            DynamicObject object = (DynamicObject)iterator.next();
            long templateId = object.getLong("id");
            if (dbids.contains(templateId)) continue;
            iterator.remove();
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Vector)evt.getSource()).getKey();
        if ("vectorap_up".equals(key) || "vectorap_down".equals(key)) {
            String[] btns = new String[]{"vectorap_up", "vectorap_down"};
            SearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), key, (TreeView)this.getControl(TEMPLATE_TREE), btns, TREE_CACHE);
        }
    }

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        HashMap param = new HashMap(16);
        Map userDefinedDimSet = DimensionServiceHelper.getUserDefineDimensionNameAndMapByModel((Object)this.getModelId(), (boolean)true);
        HashMap temp = new HashMap(userDefinedDimSet.size());
        userDefinedDimSet.forEach((dimNum, dimName) -> temp.put(dimNum.replaceFirst("dim", "userdefined") + ".name", dimName));
        boolean isSpptMyCompany = DimensionServiceHelper.existsMyCompanyDim((long)this.getModelId());
        if (args.getListColumns() != null) {
            List listColumns = args.getListColumns();
            listColumns.removeIf(e -> {
                if (e.getListFieldKey().contains("userdefined")) {
                    if (!temp.containsKey(e.getListFieldKey())) {
                        return true;
                    }
                    e.setCaption(new LocaleString((String)temp.get(e.getListFieldKey())));
                } else if (e.getListFieldKey().equals("mycompany.name")) {
                    if (isSpptMyCompany) {
                        e.setVisible(1);
                    } else {
                        e.setVisible(0);
                    }
                }
                param.put(e.getListFieldKey(), e.getVisible() != 0);
                return false;
            });
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.getQFilters().add(this.buildListQfilter());
        e.setOrderBy("number,modifytime,entryentity.groupnum,entryentity.seq");
    }

    @Override
    public void handleDys(DynamicObject[] dys) {
        if (dys == null || dys.length == 0) {
            return;
        }
        Arrays.sort(dys, Comparator.comparing(dy -> ((DynamicObject)dy).getString(NUMBER)).thenComparing(dy -> ((DynamicObject)dy).getDate("modifytime")));
        for (DynamicObject dy2 : dys) {
            DynamicObjectCollection entities = dy2.getDynamicObjectCollection("entryentity");
            if (CollectionUtil.isEmpty((Collection)entities)) continue;
            int size = entities.size();
            DynamicObject[] dynamicObjects = new DynamicObject[size];
            for (int i = 0; i < size; ++i) {
                dynamicObjects[size - 1 - i] = (DynamicObject)entities.get(i);
            }
            entities.clear();
            Arrays.sort(dynamicObjects, Comparator.comparing(row -> ((DynamicObject)row).getString("groupnum")).thenComparing(row -> ((DynamicObject)row).getInt("seq")));
            entities.addAll(Arrays.asList(dynamicObjects));
        }
        Arrays.asList(dys).forEach(dynamicObject -> {
            if (dynamicObject.getDynamicObjectCollection("applyentity") != null && !dynamicObject.getDynamicObjectCollection("applyentity").isEmpty()) {
                dynamicObject.getDynamicObjectCollection("applyentity").forEach(entry -> {
                    if (entry.getDynamicObject("entitymeb") != null) {
                        entry.set("entitynum", (Object)entry.getString("entitymeb.number"));
                    } else {
                        entry.set("entitynum", (Object)String.format("%s:%s", entry.getString("property.number"), entry.getString("propertyvalue.number")));
                    }
                });
            }
        });
    }

    private void refreshList() {
        this.refreshList(true);
    }

    private void refreshList(boolean needRefresh) {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        billList.clearSelection();
        billList.setFilter(this.buildListQfilter());
        billList.setOrderBy("number,modifytime,entryentity.groupnum,entryentity.seq");
        if (needRefresh) {
            billList.refresh();
        }
    }

    private QFilter buildListQfilter() {
        long modelID = (Long)this.getModel().getValue("model_id");
        String focusNodeId = this.getSelectFocusTreeId();
        QFilter qm = new QFilter("model", "=", (Object)modelID);
        QFilter qs = new QFilter("id", "in", (Object)LinkageMappingServiceHelper.queryIds((long)this.getModelId(), (long)LongUtil.toLong((Object)this.getScenarioId())));
        QFilter qt = null;
        if (StringUtils.isNotEmpty((String)focusNodeId)) {
            if (NOTEMPLATEID.equals(focusNodeId)) {
                qt = new QFilter("entryentity.template", "=", (Object)0L);
            } else if (this.isTemplateCatalog(Long.parseLong(focusNodeId))) {
                TreeNode treenode;
                TreeNode selectedNode;
                String treeCache = this.getPageCache().get(TREE_CACHE);
                if (StringUtils.isNotEmpty((String)treeCache) && (selectedNode = this.findFocusNode(focusNodeId, treenode = (TreeNode)SerializationUtils.fromJsonString((String)treeCache, TreeNode.class))) != null) {
                    List list = TemplateUtil.getTemplateIds((Long)this.getModelId(), (Long)Long.valueOf(selectedNode.getId()));
                    list.removeAll(PermClassCache.getPermClassIds((Long)this.getModelId(), (String)"bcm_templateentity", (DataTypeEnum[])new DataTypeEnum[]{DataTypeEnum.NO}));
                    if (focusNodeId.equals(treenode.getId())) {
                        list.add(0L);
                    }
                    qt = new QFilter("entryentity.template", "in", (Object)list);
                }
            } else {
                DynamicObject template = QueryServiceHelper.queryOne((String)"bcm_templateentity", (String)"group", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(focusNodeId))});
                if (template != null) {
                    Long groupId = template.getLong("group");
                    qt = new QFilter("entryentity.template.group", "=", (Object)groupId);
                }
            }
        }
        ArrayList list = new ArrayList();
        try (DataSet dataset = QueryServiceHelper.queryDataSet((String)"bcm_linkagemapping", (String)"bcm_linkagemapping", (String)"id", (QFilter[])new QFilter[]{qm, qs, qt}, null);){
            dataset.distinct().forEachRemaining(row -> list.add(row.getLong("id")));
        }
        QFilter listQfilter = new QFilter("id", "in", list);
        listQfilter.and(qm);
        listQfilter.and(qs);
        return listQfilter;
    }

    private TreeNode findFocusNode(String focusNodeId, TreeNode treenode) {
        String id = treenode.getId();
        if (focusNodeId.equals(id)) {
            return treenode;
        }
        List subList = treenode.getChildren();
        if (subList != null && !subList.isEmpty()) {
            for (TreeNode treeNode2 : subList) {
                TreeNode n = this.findFocusNode(focusNodeId, treeNode2);
                if (n == null) continue;
                return n;
            }
        } else {
            return null;
        }
        return null;
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        if (INCLUDENOMAPPING.equals(propName)) {
            this.refreshTemplateTree();
            this.refreshList();
        } else if ("model".equals(propName)) {
            String modelId = UserSelectUtil.getF7SelectId(this.getView(), "model");
            if (modelId != null) {
                if (modelId.equals(this.getPageCache().get("KEY_MODEL_ID"))) {
                    return;
                }
                this.getPageCache().put("KEY_MODEL_ID", modelId);
                this.getModel().setValue("scenario", null);
                this.clearTreeAndList();
                UserSelectUtil.saveUserSelectWhenModelChange(this.getView(), modelId);
                this.refreshTreeAndList();
            } else {
                this.getModel().setValue("model", (Object)this.getPageCache().get("KEY_MODEL_ID"));
            }
        } else if ("scenario".equals(propName)) {
            String scenarioId = UserSelectUtil.getF7SelectId(this.getView(), "scenario");
            if (scenarioId != null) {
                this.savetUserSelectWhenOtherChange("scenario", new UserSelectModel());
            }
            this.refreshTemplateTree();
            this.refreshList();
        }
    }

    private void clearTreeAndList() {
        TreeNode treenode;
        this.getPageCache().remove("selectFocusTemplateId");
        TreeView treeView = (TreeView)this.getControl(TEMPLATE_TREE);
        treeView.deleteAllNodes();
        String treeCache = this.getPageCache().get(TREE_CACHE);
        if (StringUtils.isNotEmpty((String)treeCache) && (treenode = (TreeNode)SerializationUtils.fromJsonString((String)treeCache, TreeNode.class)) != null) {
            boolean flag;
            List l = treenode.getChildren();
            if (l != null) {
                l.clear();
            }
            if (flag = ((Boolean)this.getModel().getValue(INCLUDENOMAPPING)).booleanValue()) {
                treenode.addChild(new TreeNode(treenode.getId(), NOTEMPLATEID, ResManager.loadKDString((String)"\u4e0d\u533a\u5206\u6a21\u677f", (String)"LinkageMappingListPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
            }
            TreeNode t = new TreeNode();
            t.addChild(treenode);
            treeView.addNode(t);
            BCMTreeUtils.spreadAllNode((TreeNode)t);
            this.getPageCache().put(TREE_CACHE, SerializationUtils.toJsonString((Object)treenode));
        }
    }

    private long getFocusTemplateId(boolean isShowTip) {
        String focusNodeId = this.getSelectFocusTreeId();
        if (StringUtils.isEmpty((String)focusNodeId)) {
            if (isShowTip) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u62a5\u8868\u6a21\u677f\u3002", (String)"LinkageMappingListPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            }
            return 0L;
        }
        if (NOTEMPLATEID.equals(focusNodeId)) {
            return 0L;
        }
        if (this.isTemplateCatalog(Long.parseLong(focusNodeId))) {
            if (isShowTip) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u62a5\u8868\u6a21\u677f\u3002", (String)"LinkageMappingListPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            }
            return 0L;
        }
        return Long.parseLong(focusNodeId);
    }

    private boolean isTemplateCatalog(long focusNodeId) {
        List catalogIdList = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(CATALOG_ID_LIST), List.class);
        return catalogIdList.contains(focusNodeId);
    }

    private DynamicObjectCollection getTemplateCatalogCollection(long modelId) {
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        return QueryServiceHelper.query((String)"bcm_templatecatalog", (String)"id,number,name,parent,isleaf", (QFilter[])filter.toArray(), (String)"sequence");
    }

    private DynamicObjectCollection getTemplateCollection(long modelId) {
        QFBuilder filter = new QFBuilder("model", "=", (Object)modelId);
        filter.add("templatecatalog.catalogtype", "not in", (Object)TemplateCatalogTypeEnum.getNoTemplateCalcog()).or("templatecatalog.number", "=", (Object)"root");
        filter.and("templatetype", "not in", (Object)new String[]{Integer.toString(TemplateTypeEnum.MSN.getType()), Integer.toString(TemplateTypeEnum.OTHERWP.getType()), Integer.toString(TemplateTypeEnum.DYNAMICREPORT.getType())});
        filter.add(new QFilter("issavebydim", "=", (Object)"1"));
        return QueryServiceHelper.query((String)"bcm_templateentity", (String)"id,name,templatecatalog,number,versionnumber,group", (QFilter[])filter.toArray(), (String)NUMBER);
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "bar_add": {
                this.addLinkageMapping();
                break;
            }
            case "bar_delete": {
                BillList entryGrid = (BillList)this.getView().getControl(BILLLISTAP);
                ListSelectedRowCollection idxs = entryGrid.getSelectedRows();
                if (idxs == null || idxs.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"LinkageMappingListPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                int length = idxs.getPrimaryKeyValues().length;
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5df2\u9009\u62e9%1$d\u6761\uff08%2$d\uff09\u5f20\uff0c\u662f\u5426\u5220\u9664\u9009\u62e9\u7684\u6570\u636e\uff1f", (String)"LinkageMappingListPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]), idxs.size(), length), MessageBoxOptions.YesNo, new ConfirmCallBackListener("comfirm_delete", (IFormPlugin)this));
                break;
            }
            case "bar_refresh": {
                this.refreshTreeAndList();
                break;
            }
            case "bar_import": {
                this.writeOperationLog(OpItemEnum.IMPORT.getName(), ResultStatusEnum.SUCCESS.getName());
                this.invokeOperation("bcm_linkagemapping", "kd.fi.bcm.formplugin.linkagemapping.LinkageMappingImport", ResManager.loadKDString((String)"\u8054\u52a8\u6620\u5c04", (String)"LinkageMappingListPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]), "LinkageMappingImport");
                break;
            }
            case "bar_export": {
                try {
                    BillList billList = (BillList)this.getControl(BILLLISTAP);
                    ListSelectedRowCollection ls = billList.getSelectedRows();
                    if (ls.isEmpty()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8bb0\u5f55\u3002", (String)"LinkageMappingListPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    HashSet<Object> set = new HashSet<Object>();
                    for (ListSelectedRow row : ls) {
                        set.add(row.getPrimaryKeyValue());
                    }
                    this.exportData("bcm_linkagemapping", new QFilter("id", "in", set).toArray(), null, "bcm_linkagemappinglist", "1G2FW/G3YIL8");
                    this.writeOperationLog(OpItemEnum.EXPORT.getName(), ResultStatusEnum.SUCCESS.getName());
                    break;
                }
                catch (Exception e) {
                    this.writeOperationLog(OpItemEnum.EXPORT.getName(), ResultStatusEnum.FAIL.getName());
                    throw new KDBizException(e.getMessage());
                }
            }
            case "bar_enable": {
                if (this.isNoSelectedRow()) {
                    return;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u542f\u7528\u9009\u62e9\u7684\u6570\u636e\uff1f", (String)"LinkageMappingListPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("comfirm_enable", (IFormPlugin)this));
                break;
            }
            case "bar_disable": {
                if (this.isNoSelectedRow()) {
                    return;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u7981\u7528\u9009\u62e9\u7684\u6570\u636e\uff1f", (String)"LinkageMappingListPlugin_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("comfirm_disable", (IFormPlugin)this));
                break;
            }
            case "bar_check": {
                this.check();
                break;
            }
            case "bar_upgrade": {
                this.upgrade();
                break;
            }
            case "bar_updatelinktag": {
                this.updateLinkTag();
                break;
            }
            case "bar_copy": {
                this.copy();
                this.refreshTreeAndList();
                break;
            }
        }
    }

    private void copy() {
        try (TXHandle h = TX.requiresNew();){
            DynamicObject[] records = this.getSelectedRecords(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u590d\u5236\u7684\u8bb0\u5f55\u3002", (String)"LinkageMappingListPlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            try {
                if (records != null) {
                    DynamicObject[] copyDy = new DynamicObject[records.length];
                    for (int i = 0; i < records.length; ++i) {
                        copyDy[i] = (DynamicObject)OrmUtils.clone((IDataEntityBase)records[i], (boolean)false, (boolean)true);
                    }
                    for (DynamicObject obj : records = copyDy) {
                        String codeRuleNumber = CodeRuleUtil.getCodeRuleNumber("bcm_linkagemapping", "modifytime");
                        if (codeRuleNumber == null) {
                            obj.set(NUMBER, (Object)(obj.getString(NUMBER).length() > 56 ? obj.getString(NUMBER).substring(0, 55) + "copy" : obj.getString(NUMBER) + "copy"));
                        } else {
                            obj.set(NUMBER, (Object)codeRuleNumber);
                        }
                        obj.set("name", (Object)new LocaleString(obj.getString("name").length() > 56 ? obj.getString("name").substring(0, 55) + "copy" : obj.getString("name") + "copy"));
                        obj.set("status", (Object)ZERO_STR);
                    }
                    SaveServiceHelper.save((DynamicObject[])records);
                    for (DynamicObject obj : records) {
                        this.writeOperationLog(OpItemEnum.COPY.getName(), obj.getString(NUMBER), obj.getString("name"), ResultStatusEnum.SUCCESS.getName());
                    }
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u590d\u5236\u6210\u529f\u3002", (String)"LinkageMappingListPlugin_42", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
            }
            catch (Exception e) {
                h.markRollback();
                for (DynamicObject obj : records) {
                    this.writeOperationLog(OpItemEnum.COPY.getName(), obj.getString(NUMBER), obj.getString("name"), ResultStatusEnum.FAIL.getName());
                }
                throw new KDBizException(e.getMessage());
            }
        }
    }

    private DynamicObject[] getSelectedRecords(String noSelectedMsg) {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        if (billList.getSelectedRows().isEmpty()) {
            if (StringUtils.isNotEmpty((String)noSelectedMsg)) {
                this.getView().showTipNotification(noSelectedMsg);
            }
            return null;
        }
        return BusinessDataServiceHelper.load((Object[])billList.getSelectedRows().getPrimaryKeyValues(), (DynamicObjectType)billList.getEntityType());
    }

    private void upgrade() {
        long modelId = this.getModelId();
        if (modelId != 0L) {
            QFBuilder qf = new QFBuilder("model", "=", (Object)modelId);
            qf.add(NUMBER, "=", (Object)"MCNone");
            DynamicObject mcNone = BusinessDataServiceHelper.loadSingle((String)"bcm_mycompanymembertree", (String)"id", (QFilter[])qf.toArray());
            if (mcNone != null) {
                DynamicObject[] toUpgrade;
                QFBuilder qfu = new QFBuilder("model", "=", (Object)modelId);
                qfu.add("entryentity.mycompany", "=", (Object)0);
                for (DynamicObject dy : toUpgrade = BusinessDataServiceHelper.load((String)"bcm_linkagemapping", (String)"entryentity.mycompany, entryentity.mycompanyrange", (QFilter[])qfu.toArray())) {
                    DynamicObjectCollection entrys = dy.getDynamicObjectCollection("entryentity");
                    for (DynamicObject entry : entrys) {
                        entry.set("mycompany", (Object)mcNone);
                        entry.set("mycompanyrange", (Object)10);
                    }
                }
                SaveServiceHelper.save((DynamicObject[])toUpgrade);
            }
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5347\u7ea7\u5b8c\u6210\u3002", (String)"LinkageMappingListPlugin_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    private void check() {
        if (this.getScenarioId() == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u60c5\u666f\u3002", (String)"LinkageMappingListPlugin_37", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList ids = new ArrayList();
        this.getSelectedRowIds().forEach(id -> ids.add(Long.valueOf(id.toString())));
        String validateResult = LinkageMappingServiceHelper.validateAll((long)this.getModelId(), (long)LongUtil.toLong((Object)this.getScenarioId()), ids);
        if (validateResult.length() > 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u68c0\u67e5\u7ed3\u679c\u5982\u4e0b\uff0c\u8bf7\u70b9\u51fb\u201c\u5c55\u793a\u8be6\u60c5\u201d\u3002", (String)"LinkageMappingListPlugin_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]), validateResult, MessageTypes.Default);
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u65e0\u91cd\u590d\u6570\u636e\u3002", (String)"LinkageMappingListPlugin_23", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        DynamicObjectCollection data = QueryServiceHelper.query((String)"bcm_linkagemapping", (String)"id, status,name,number", (QFilter[])new QFBuilder("id", "in", this.getSelectedRowIds()).toArray());
        for (DynamicObject datum : data) {
            this.writeOperationLog(this.getOperationDoubleCheck(), datum.getString(NUMBER), datum.getString("name"), ResultStatusEnum.SUCCESS.getName());
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        super.confirmCallBack(mbce);
        String callBackId = mbce.getCallBackId();
        int result = mbce.getResult().getValue();
        switch (callBackId) {
            case "comfirm_delete": {
                if (result != 6) break;
                this.deleteLinkageMapping();
                break;
            }
            case "comfirm_enable": {
                if (result != 6) break;
                this.setEnable();
                break;
            }
            case "comfirm_disable": {
                if (result != 6) break;
                this.setDisable();
                break;
            }
        }
    }

    private Object getScenarioId() {
        if (this.getModel().getDataEntity().getDynamicObject("scenario") != null) {
            return this.getModel().getDataEntity().getDynamicObject("scenario").getLong("id");
        }
        return null;
    }

    private void setEnable() {
        DynamicObject[] mappingCollection = BusinessDataServiceHelper.load((String)"bcm_linkagemapping", (String)"id, status,name,number", (QFilter[])new QFBuilder("id", "in", this.getSelectedRowIds()).toArray(), (String)NUMBER);
        StringBuilder failMessage = new StringBuilder();
        failMessage.append(ResManager.loadKDString((String)"\u4e0b\u5217\u6570\u636e\u5b58\u5728\u5185\u90e8\u91cd\u590d\uff0c\u542f\u7528\u5931\u8d25\n", (String)"LinkageMappingListPlugin_24", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        boolean hasFail = false;
        List status = Stream.of(mappingCollection).filter(r -> r.getBoolean("status")).map(r -> r.getString(NUMBER)).collect(Collectors.toList());
        int count = mappingCollection.length;
        int successCount = 0;
        for (DynamicObject dy : mappingCollection) {
            if (dy.getBoolean("status")) continue;
            dy.set("status", (Object)"1");
            ++successCount;
            this.writeOperationLog(OpItemEnum.ENABLE.getName(), dy.getString(NUMBER), dy.getString("name"), ResultStatusEnum.SUCCESS.getName());
        }
        if (hasFail) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u542f\u7528\u7ed3\u679c\u5982\u4e0b\uff0c\u8bf7\u70b9\u51fb\u201c\u5c55\u793a\u8be6\u60c5\u201d\u3002", (String)"LinkageMappingListPlugin_25", (String)"fi-bcm-formplugin", (Object[])new Object[0]), failMessage.toString(), MessageTypes.Default);
        } else if (CollectionUtils.isEmpty(status)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"LinkageMappingListPlugin_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        } else {
            String msg = String.format(ResManager.loadKDString((String)"\n\u5b58\u5728\u5df2\u542f\u7528\u7684\u6570\u636e\u4e0d\u80fd\u518d\u6b21\u542f\u7528\u3002%s", (String)"LinkageMappingListPlugin_27", (String)"fi-bcm-formplugin", (Object[])new Object[0]), status);
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6210\u529f\u542f\u7528%1$d\u6761\uff0c\u5931\u8d25%2$d\u6761\u3002%3$s", (String)"LinkageMappingListPlugin_28", (String)"fi-bcm-formplugin", (Object[])new Object[0]), successCount, count - successCount, msg));
        }
        SaveServiceHelper.save((DynamicObject[])mappingCollection);
        this.refreshList();
    }

    private void setDisable() {
        DynamicObject[] mappingCollection = BusinessDataServiceHelper.load((String)"bcm_linkagemapping", (String)"id, status,name,number", (QFilter[])new QFBuilder("id", "in", this.getSelectedRowIds()).toArray(), (String)NUMBER);
        int count = mappingCollection.length;
        int sucessCount = 0;
        ArrayList<String> status = new ArrayList<String>();
        for (DynamicObject dyn : mappingCollection) {
            if (dyn.getBoolean("status")) {
                dyn.set("status", (Object)ZERO_STR);
                ++sucessCount;
                this.writeOperationLog(OpItemEnum.DISABLE.getName(), dyn.getString(NUMBER), dyn.getString("name"), ResultStatusEnum.SUCCESS.getName());
                continue;
            }
            status.add(dyn.getString(NUMBER));
        }
        SaveServiceHelper.save((DynamicObject[])mappingCollection);
        if (CollectionUtils.isEmpty(status)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"LinkageMappingListPlugin_29", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        } else {
            String msg = String.format(ResManager.loadKDString((String)"\n\u5b58\u5728\u5df2\u7981\u7528\u7684\u6570\u636e\u4e0d\u80fd\u518d\u6b21\u7981\u7528\u3002%s", (String)"LinkageMappingListPlugin_30", (String)"fi-bcm-formplugin", (Object[])new Object[0]), status);
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6210\u529f\u7981\u7528%1$d\u6761\uff0c\u5931\u8d25%2$d\u6761\u3002", (String)"LinkageMappingListPlugin_31", (String)"fi-bcm-formplugin", (Object[])new Object[0]), sucessCount, count - sucessCount).concat(msg));
        }
        this.refreshList();
    }

    public void packageData(PackageDataEvent e) {
        super.packageData(e);
        if (ColumnDesc.class.isAssignableFrom(e.getSource().getClass())) {
            String key = ((ColumnDesc)e.getSource()).getKey();
            if ("scenariotext".equals(key)) {
                String name = this.getApplyNameFromPageCache(CACHE_KEY_SCENARIOTEXT, LongUtil.toLong((Object)e.getRowData().getPkValue()));
                if (StringUtils.isNotEmpty((String)name)) {
                    e.setFormatValue((Object)name);
                }
            } else if ("entitytext".equals(key)) {
                String name = this.getApplyNameFromPageCache(CACHE_KEY_ENTITYTEXT, LongUtil.toLong((Object)e.getRowData().getPkValue()));
                if (StringUtils.isNotEmpty((String)name)) {
                    e.setFormatValue((Object)name);
                }
            } else if ("audittrial.name".equals(key)) {
                Object audittrial = e.getRowData().get("entryentity.audittrial");
                if (audittrial instanceof DynamicObject) {
                    IDNumberTreeNode audittrialMember = MemberReader.findMemberById((long)this.getModelId(), (String)"bcm_audittrialmembertree", (Long)((DynamicObject)audittrial).getLong("id"));
                    if (audittrialMember.isLeaf()) {
                        e.setFormatValue((Object)audittrialMember.getName());
                    } else {
                        e.setFormatValue((Object)String.format(ResManager.loadKDString((String)"%s\u7684\u6240\u6709\u4e0b\u7ea7\u660e\u7ec6\u6210\u5458", (String)"LinkageMappingDataListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), audittrialMember.getName()));
                    }
                } else {
                    e.setFormatValue((Object)"");
                }
            } else if ("account.name".equals(key)) {
                Object account = e.getRowData().get("entryentity.account");
                if (account instanceof DynamicObject) {
                    IDNumberTreeNode accountNode = MemberReader.findMemberById((long)this.getModelId(), (String)"bcm_accountmembertree", (Long)((DynamicObject)account).getLong("id"));
                    if (accountNode.isLeaf()) {
                        e.setFormatValue((Object)accountNode.getName());
                    } else {
                        e.setFormatValue((Object)String.format(ResManager.loadKDString((String)"%s\u7684\u6240\u6709\u4e0b\u7ea7\u660e\u7ec6\u6210\u5458", (String)"LinkageMappingDataListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), accountNode.getName()));
                    }
                } else {
                    e.setFormatValue((Object)"");
                }
            }
        }
    }

    @Override
    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection doc = super.getData(start, limit);
                if (doc.isEmpty()) {
                    return doc;
                }
                Set ids = doc.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
                HashMap scenariosNameMap = new HashMap(16);
                DynamicObjectCollection scenariosDyns = QueryServiceHelper.query((String)"bcm_linkagemapping", (String)"id,scenarios.scenariomeb.id as scenariomeb.id,scenarios.scenariomeb.number as scenariomeb.number,scenarios.scenariomeb.name as scenariomeb.name,scenarios.scenarioscope as scenarioscope,scenarios.isexcept as isexcept", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
                scenariosDyns.removeIf(o -> o.getLong("scenariomeb.id") == 0L);
                Map<Long, List<DynamicObject>> scenariosDynsMap = scenariosDyns.stream().collect(Collectors.groupingBy(e -> e.getLong("id")));
                scenariosDynsMap.forEach((id, entries) -> {
                    DynamicObjectCollection dynamicObjects = new DynamicObjectCollection();
                    dynamicObjects.addAll((Collection)entries);
                    Pair p = PaperTemplateSceneSettingHelper.getItemAndNameByDyn((DynamicObjectCollection)dynamicObjects);
                    scenariosNameMap.put(id, p.p1);
                });
                HashMap entityNameMap = new HashMap(16);
                DynamicObjectCollection entityDyns = QueryServiceHelper.query((String)"bcm_linkagemapping", (String)"id,applyentity.entityisexcept,applyentity.entitymeb.id,applyentity.property.id,applyentity.propertyvalue.id,applyentity.entityrange", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
                entityDyns.removeIf(o -> StringUtil.isEmptyString((String)o.getString("applyentity.entityisexcept")));
                Map<Long, List<DynamicObject>> entityDynsMap = entityDyns.stream().collect(Collectors.groupingBy(e -> e.getLong("id")));
                entityDynsMap.forEach((id, entries) -> {
                    DynamicObjectCollection dynamicObjects = new DynamicObjectCollection();
                    dynamicObjects.addAll((Collection)entries);
                    Pair p = ApplyEntityHelper.getItemAndNameByDyn((Long)LinkageMappingListPlugin.this.getModelId(), (DynamicObjectCollection)dynamicObjects);
                    entityNameMap.put(id, p.p1);
                });
                LinkageMappingListPlugin.this.getPageCache().put(LinkageMappingListPlugin.CACHE_KEY_SCENARIOTEXT, ObjectSerialUtil.toByteSerialized(scenariosNameMap));
                LinkageMappingListPlugin.this.getPageCache().put(LinkageMappingListPlugin.CACHE_KEY_ENTITYTEXT, ObjectSerialUtil.toByteSerialized(entityNameMap));
                return doc;
            }
        });
    }

    private String getApplyNameFromPageCache(String cacheKey, Long id) {
        Map nameMap = (Map)ThreadCache.get((Object)("ThreadCache" + cacheKey), () -> {
            HashMap result = new HashMap(16);
            String s = this.getPageCache().get(cacheKey);
            if (StringUtils.isNotEmpty((String)s)) {
                Map r = (Map)ObjectSerialUtil.deSerializedBytes((String)s);
                result.putAll(r);
            }
            return result;
        });
        return (String)nameMap.get(id);
    }

    private String getSelectFocusTreeId() {
        String focusId = this.getPageCache().get("selectFocusTemplateId");
        if (StringUtils.isEmpty((String)focusId)) {
            focusId = ((TreeView)this.getControl(TEMPLATE_TREE)).getTreeState().getFocusNodeId();
        }
        return focusId;
    }

    private void refreshTreeAndList() {
        TreeView treeView = (TreeView)this.getControl(TEMPLATE_TREE);
        this.refreshTemplateTree();
        String focusNodeId = this.getSelectFocusTreeId();
        TreeNode node = new TreeNode("", focusNodeId, "");
        treeView.focusNode(node);
        this.refreshList();
    }

    private void deleteLinkageMapping() {
        this.writeOperationLog(OpItemEnum.DELETE.getName(), ResultStatusEnum.SUCCESS.getName());
        int delete = DeleteServiceHelper.delete((String)"bcm_linkagemapping", (QFilter[])new QFBuilder("id", "in", (Object)this.getSelectedRowIds().toArray()).and("status", "=", (Object)ZERO_STR).toArray());
        DynamicObjectCollection mappingCollection = QueryServiceHelper.query((String)"bcm_linkagemapping", (String)"id, status,name,number", (QFilter[])new QFBuilder("id", "in", this.getSelectedRowIds()).toArray());
        List<String> failMsg = mappingCollection.stream().filter(r -> r.getBoolean("status")).map(r -> String.format(ResManager.loadKDString((String)"%s\uff1a\u53ea\u80fd\u5220\u9664\u672a\u542f\u7528\u7684\u6570\u636e\u3002", (String)"LinkageMappingListPlugin_33", (String)"fi-bcm-formplugin", (Object[])new Object[0]), r.getString(NUMBER))).collect(Collectors.toList());
        String msg = String.format(ResManager.loadKDString((String)"\u5171%1$s\u5f20\u5355\u636e\uff0c\u6210\u529f%2$s\u5f20\uff0c\u5931\u8d25%3$s\u5f20\u3002", (String)"LinkageMappingListPlugin_34", (String)"fi-bcm-formplugin", (Object[])new Object[0]), this.getSelectedRowIds().size(), delete, this.getSelectedRowIds().size() - delete);
        ShowOperationMsgUtil.showOperationResultMulti(failMsg, "", this.getView(), msg);
        this.refreshList();
    }

    private boolean isNoSelectedRow() {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        if (billList.getSelectedRows().isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"LinkageMappingListPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private Set<Object> getSelectedRowIds() {
        HashSet<Object> set = new HashSet<Object>();
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        for (ListSelectedRow row : billList.getSelectedRows()) {
            set.add(row.getPrimaryKeyValue());
        }
        return set;
    }

    private void addLinkageMapping() {
        if (this.getModel().getValue("model") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LinkageMappingListPlugin_35", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        String focusNodeId = this.getSelectFocusTreeId();
        long focusTemplateId = this.getFocusTemplateId(true);
        if (focusTemplateId == 0L && !NOTEMPLATEID.equals(focusNodeId)) {
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bcm_linkagebaseinfoset");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        showParameter.setCustomParam("KEY_SCENARIO_ID", this.getScenarioId());
        DynamicObject template = QueryServiceHelper.queryOne((String)"bcm_templateentity", (String)"id, number", (QFilter[])new QFBuilder("id", "=", (Object)focusTemplateId).toArray());
        showParameter.setCustomParam(NUMBER, (Object)((template == null ? "DEFAULT" : template.getString(NUMBER)) + "-" + CodeRuleUtil.getCodeRuleNumber("bcm_linkagemapping", "modifytime")));
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "addLinkageMapping");
        showParameter.setCloseCallBack(callBack);
        this.getView().showForm(showParameter);
    }

    private boolean isNoModel() {
        if (this.getModel().getValue("model") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"LinkageMappingListPlugin_38", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void showLinkageMappingEditForm(String viewId, Map<String, Object> addMap, List<Object> selectIds) {
        IFormView mainPageView = this.getView().getMainView();
        IFormView parentView = this.getView().getParentView();
        String pageId = this.getView().getPageId() + viewId;
        if (mainPageView == null || mainPageView.getView(pageId) == null) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("bcm_linkagemappingconfig");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setCustomParam("modelId", (Object)this.getModelId());
            showParameter.setCustomParam("KEY_SCENARIO_ID", this.getScenarioId());
            showParameter.setCustomParam("templateId", (Object)String.valueOf(this.getFocusTemplateId(false)));
            if (viewId != null) {
                showParameter.setCustomParam("viewId", (Object)viewId);
            }
            if (addMap != null) {
                showParameter.setCustomParam("baseInfo", addMap);
            }
            if (selectIds != null) {
                showParameter.setCustomParam("selectIds", selectIds);
            }
            showParameter.setPageId(pageId);
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "refresh");
            showParameter.setCloseCallBack(callBack);
            if (parentView == null) {
                this.getView().showForm(showParameter);
            } else {
                parentView.showForm(showParameter);
                this.getView().sendFormAction(parentView);
            }
        } else {
            IFormView childFormView = mainPageView.getView(pageId);
            childFormView.activate();
            this.getView().sendFormAction(childFormView);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        if ("refresh".equals(actionId) || "import".equals(actionId)) {
            this.refreshList();
            if ("import".equals(actionId) && evt.getReturnData() != null) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"LinkageMappingListPlugin_39", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        } else if ("addLinkageMapping".equals(actionId)) {
            Map addMap = (Map)evt.getReturnData();
            if (addMap != null) {
                this.showLinkageMappingEditForm(null, addMap, null);
            }
        } else if ("LinkageMappingImport".equals(actionId)) {
            this.refreshList();
        }
    }

    private void updateLinkTag() {
        if (this.getModelId() == 0L) {
            this.writeOperationLog(this.getOperationUpdate(), ResultStatusEnum.FAIL.getName());
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"LinkageMappingListPlugin_41", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        long modelId = this.getModelId();
        LinkageMappingUtil.clearAllLinkTag(modelId);
        LinkageMappingUtil.setLinkTag(modelId, null);
        this.getView().showMessage(ResManager.loadKDString((String)"\u66f4\u65b0\u5168\u90e8\u6a21\u677f\u8054\u52a8\u6807\u8bc6\u6210\u529f\u3002", (String)"LinkageMappingListPlugin_40", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        this.writeOperationLog(this.getOperationUpdate(), ResultStatusEnum.SUCCESS.getName());
    }
}

