/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.linkagemapping;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.IListColumn;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;

public class LinkageMappingViewPlugin
extends AbstractBaseListPlugin {
    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getPageCache().put("modelid", Long.toString((Long)this.getFormCustomParam("modelid")));
    }

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        this.setUserDefinedFeildsVisble(args);
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.getQFilters().add(this.buildListQfilter());
        e.setOrderBy("number,modifytime,entryentity.groupnum");
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
    }

    @Override
    public void listRowDoubleClick(ListRowClickEvent evt) {
        evt.setCancel(true);
    }

    private QFilter buildListQfilter() {
        String linkageIds = (String)this.getFormCustomParam("linkageIds");
        String[] linkageId = linkageIds.split(",");
        return new QFilter("id", "in", Arrays.stream(linkageId).map(p -> LongUtil.toLong((Object)p)).collect(Collectors.toSet()));
    }

    @Override
    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection doc = super.getData(start, limit);
                if (doc.isEmpty()) {
                    return doc;
                }
                DataEntityPropertyCollection properties = ((DynamicObject)doc.get(0)).getDataEntityType().getProperties();
                String suffix = ResManager.loadKDString((String)"%s\u7684\u6240\u6709\u4e0b\u7ea7\u660e\u7ec6\u6210\u5458", (String)"LinkageMappingListPlugin_32", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                for (DynamicObject d : doc) {
                    DynamicObject mc;
                    DynamicObject ic = (DynamicObject)d.get("entryentity.intercompany");
                    if (ic != null && !ic.getBoolean("isleaf") && !ic.getString("name").contains(suffix)) {
                        ic.set("name", (Object)String.format(suffix, ic.getString("name")));
                    }
                    if (properties.containsKey((Object)"entryentity.mycompany") && (mc = (DynamicObject)d.get("entryentity.mycompany")) != null && !mc.getBoolean("isleaf") && !mc.getString("name").contains(suffix)) {
                        mc.set("name", (Object)String.format(suffix, mc.getString("name")));
                    }
                    for (int i = 1; i <= 6; ++i) {
                        DynamicObject udf;
                        if (!properties.containsKey((Object)("entryentity.userdefined" + i)) || (udf = (DynamicObject)d.get("entryentity.userdefined" + i)) == null || udf.getBoolean("isleaf") || udf.getString("name").contains(suffix)) continue;
                        udf.set("name", (Object)String.format(suffix, udf.getString("name")));
                    }
                }
                return doc;
            }
        });
    }

    private void setUserDefinedFeildsVisble(BeforeCreateListColumnsArgs args) {
        List list = args.getListColumns();
        QFilter filter = new QFilter("model", "=", (Object)LongUtil.toLong((Object)this.getPageCache().get("modelid")));
        filter.and(new QFilter("issysdimension", "=", (Object)"0"));
        DynamicObjectCollection dimensionCollection = QueryServiceHelper.query((String)"bcm_dimension", (String)"number, name, fieldmapped", (QFilter[])new QFilter[]{filter}, (String)"fieldmapped");
        int size = dimensionCollection == null ? 0 : dimensionCollection.size();
        int i = 0;
        boolean isSpptMyCompany = DimensionServiceHelper.existsMyCompanyDim((long)Long.parseLong(this.getPageCache().get("modelid")));
        if (list != null) {
            for (IListColumn iListColumn : list) {
                if (iListColumn.getListFieldKey().contains("userdefined")) {
                    if (i < size && i < 6) {
                        iListColumn.setVisible(1);
                        iListColumn.setCaption(new LocaleString(((DynamicObject)dimensionCollection.get(i)).getString("name")));
                        ++i;
                        continue;
                    }
                    iListColumn.setVisible(0);
                    continue;
                }
                if (!iListColumn.getListFieldKey().equals("mycompany.name")) continue;
                if (isSpptMyCompany) {
                    iListColumn.setVisible(1);
                    continue;
                }
                iListColumn.setVisible(0);
            }
        }
        args.setListColumns(list);
    }
}

