/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.linkagemapping.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.adjust.link.LinkageMappingServiceHelper;
import kd.fi.bcm.business.serviceHelper.QueryMemberDetailsHelper;
import kd.fi.bcm.business.serviceHelper.TemplateServiceHelper;
import kd.fi.bcm.business.template.model.BaseEntry;
import kd.fi.bcm.business.template.model.PageDimensionEntry;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.template.model.ViewPointDimensionEntry;
import kd.fi.bcm.business.util.TemplateRangeService;
import kd.fi.bcm.common.enums.DetailTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.model.IDimMember;

public class LinkageMappingUtil {
    public static boolean hasLinkageMapping(long templateId) {
        return QueryServiceHelper.exists((String)"bcm_linkagemapping", (QFilter[])new QFilter[]{new QFilter("targettemplate", "=", (Object)templateId)});
    }

    public static void clearAllLinkTag(long modelid) {
        Set tmplids = TemplateRangeService.getAllTemplateIdByModel((Object)modelid);
        DynamicObject[] templates = BusinessDataServiceHelper.load((Object[])tmplids.toArray(), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"bcm_templateentity").getDynamicObjectType());
        HashMap<Long, DynamicObject> needChangeTmpls = new HashMap<Long, DynamicObject>();
        for (DynamicObject doc : templates) {
            HashSet ischanged = new HashSet();
            if (StringUtils.isEmpty((String)doc.getString("rptdata"))) continue;
            SpreadManager rptdata = JsonSerializerUtil.toSpreadManager((String)doc.getString("rptdata"));
            rptdata.getBook().getSheet(0).iteratorCells(cell -> {
                if (cell.getRow() == 1 && cell.getCol() == 1 && cell.getUserObject("linkageIdsMaybe") != null) {
                    ischanged.add(true);
                    cell.removeUserObject("linkageIdsMaybe");
                } else if (cell.getRow() == 1 && cell.getCol() == 1 && cell.getUserObject("linkageIdsMay") != null) {
                    ischanged.add(true);
                    cell.removeUserObject("linkageIdsMay");
                }
                if (cell.isMdDataDomain() && cell.getUserObject("linkageIds") != null) {
                    ischanged.add(true);
                    cell.removeUserObject("linkageIds");
                }
            });
            if (ischanged.size() <= 0) continue;
            doc.set("rptdata", (Object)JsonSerializerUtil.toJson((SpreadManager)rptdata));
            needChangeTmpls.put(doc.getLong("id"), doc);
        }
        SaveServiceHelper.save((DynamicObject[])needChangeTmpls.values().toArray(new DynamicObject[0]));
        TemplateServiceHelper.removeTemplateModelCacheByIds((Object)modelid, (Object[])needChangeTmpls.keySet().toArray());
    }

    public static void setLinkTagForTemplateModels(long modelid, List<TemplateModel> tms) {
        DynamicObject[] templates;
        List linkMappingIds = LinkageMappingServiceHelper.queryEnableIdsByModelid((long)modelid);
        DynamicObjectCollection linkMappingCol = LinkageMappingServiceHelper.queryByIds((List)linkMappingIds);
        HashMap<Long, TemplateModel> needSaveTmpl = new HashMap<Long, TemplateModel>();
        Map userdefinedDim = LinkageMappingServiceHelper.getUserDefinedDim((Object)modelid);
        for (TemplateModel tm : tms) {
            if (StringUtils.isEmpty((String)tm.getRptData())) continue;
            SpreadManager sm = JsonSerializerUtil.toSpreadManager((String)tm.getRptData());
            for (DynamicObject linkmapping : linkMappingCol) {
                boolean isHitViewDim;
                boolean isHitPageDim;
                if (!tm.getNumber().equals(linkmapping.getString("entryentity.template.number")) || !(isHitPageDim = (isHitViewDim = LinkageMappingUtil.isHitViewDim(modelid, userdefinedDim, tm, linkmapping)) ? LinkageMappingUtil.isHitPageDim(modelid, userdefinedDim, tm, linkmapping) : false)) continue;
                LinkageMappingUtil.hitRowColDim(modelid, userdefinedDim, tm, linkmapping, needSaveTmpl, sm);
            }
        }
        for (DynamicObject template : templates = BusinessDataServiceHelper.load((Object[])needSaveTmpl.keySet().toArray(), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"bcm_templateentity").getDynamicObjectType())) {
            template.set("rptdata", (Object)((TemplateModel)needSaveTmpl.get(template.getPkValue())).getRptData());
        }
        if (templates.length > 0) {
            SaveServiceHelper.save((DynamicObject[])templates);
            TemplateServiceHelper.removeTemplateModelCacheByIds((Object)modelid, (Object[])needSaveTmpl.keySet().toArray());
            TemplateServiceHelper.cacheTemplateWholeModel((TemplateModel[])needSaveTmpl.values().toArray(new TemplateModel[0]));
        }
    }

    public static void setLinkTag(long modelid, Set<Long> tmplids) {
        if (tmplids == null) {
            tmplids = TemplateRangeService.getAllTemplateIdByModel((Object)modelid);
        }
        List tmpllist = TemplateRangeService.getCompleteTemplateModels(tmplids);
        LinkageMappingUtil.setLinkTagForTemplateModels(modelid, tmpllist);
    }

    private static boolean isHitViewDim(Object modelid, Map<String, String> userdefinedDim, TemplateModel tm, DynamicObject linkmappingEntry) {
        boolean hitview = true;
        List viewpointlist = tm.getViewPointDimensionEntries();
        for (ViewPointDimensionEntry viewpointDimension : viewpointlist) {
            Set<String> linkMemNumbers;
            String number = viewpointDimension.getDimension().getNumber();
            if (!DimTypesEnum.ACCOUNT.getNumber().equals(number) && !DimTypesEnum.INTERCOMPANY.getNumber().equals(number) && !DimTypesEnum.CHANGETYPE.getNumber().equals(number) && !DimTypesEnum.MYCOMPANY.getNumber().equals(number) && (userdefinedDim.size() <= 0 || !userdefinedDim.containsKey(number)) || (linkMemNumbers = LinkageMappingUtil.getLinkMemNumbers(modelid, userdefinedDim, number, (BaseEntry)viewpointDimension, linkmappingEntry)).contains(viewpointDimension.getMember().getNumber())) continue;
            return false;
        }
        return hitview;
    }

    private static boolean isHitPageDim(Object modelid, Map<String, String> userdefinedDim, TemplateModel tm, DynamicObject linkmappingEntry) {
        boolean hitpage = true;
        List pagelist = tm.getPageDimensionEntries();
        for (PageDimensionEntry pageDimension : pagelist) {
            Set<String> memNumbers;
            Set<String> linkMemNumbers;
            String number = pageDimension.getDimension().getNumber();
            if (!DimTypesEnum.ACCOUNT.getNumber().equals(number) && !DimTypesEnum.INTERCOMPANY.getNumber().equals(number) && !DimTypesEnum.CHANGETYPE.getNumber().equals(number) && !DimTypesEnum.MYCOMPANY.getNumber().equals(number) && (userdefinedDim.size() <= 0 || !userdefinedDim.containsKey(number)) || (linkMemNumbers = LinkageMappingUtil.getLinkMemNumbers(modelid, userdefinedDim, number, (BaseEntry)pageDimension, linkmappingEntry)).containsAll(memNumbers = LinkageMappingUtil.getMemNumbers(modelid, number, userdefinedDim, pageDimension))) continue;
            return false;
        }
        return hitpage;
    }

    private static void hitRowColDim(Object modelid, Map<String, String> userdefinedDim, TemplateModel tm, DynamicObject linkmappingEntry, Map<Long, TemplateModel> needSaveTmpl, SpreadManager sm) {
        Cell linkageCell;
        HashMap linkDimNubmersMap = new HashMap();
        HashSet<Boolean> ischanged = new HashSet<Boolean>();
        if (TemplateTypeEnum.DYNA.getType() == tm.getTemplateType().intValue()) {
            linkageCell = sm.getBook().getSheet(0).getCell(1, 1);
            String newlinkageIdMaybe = Long.toString(linkmappingEntry.getLong("entryentity.id"));
            if (linkageCell.getUserObject("linkageIdsMaybe") != null && !StringUtils.isEmpty((String)((String)linkageCell.getUserObject("linkageIdsMaybe")))) {
                newlinkageIdMaybe = newlinkageIdMaybe + "," + (String)linkageCell.getUserObject("linkageIdsMaybe");
            }
            linkageCell.setUserObject("linkageIdsMaybe", (Object)newlinkageIdMaybe);
            ischanged.add(true);
        } else {
            sm.getBook().getSheet(0).iteratorCells(cell -> {
                if (cell.isMdDataDomain()) {
                    boolean isHit = true;
                    List userObject = cell.getMemberFromUserObject();
                    if (userObject != null && userObject.size() > 0) {
                        ListIterator idimmember = userObject.listIterator();
                        while (idimmember.hasNext()) {
                            IDimMember idim = (IDimMember)idimmember.next();
                            String number = idim.getDimension().getNumber();
                            if (!DimTypesEnum.ACCOUNT.getNumber().equals(number) && !DimTypesEnum.INTERCOMPANY.getNumber().equals(number) && !DimTypesEnum.CHANGETYPE.getNumber().equals(number) && !DimTypesEnum.MYCOMPANY.getNumber().equals(number) && (userdefinedDim.size() <= 0 || !userdefinedDim.containsKey(number))) continue;
                            if (linkDimNubmersMap.get(number) == null) {
                                linkDimNubmersMap.put(number, LinkageMappingServiceHelper.getRowColLinkMemNumbers((Object)modelid, (Map)userdefinedDim, (String)number, (String)idim.getDimension().getNumber(), (DynamicObject)linkmappingEntry));
                            }
                            if (((Set)linkDimNubmersMap.get(number)).contains(idim.getNumber())) continue;
                            isHit = false;
                            break;
                        }
                        if (isHit) {
                            ischanged.add(true);
                            String newlinkageId = Long.toString(linkmappingEntry.getLong("entryentity.id"));
                            if (cell.getUserObject("linkageIds") != null && !StringUtils.isEmpty((String)((String)cell.getUserObject("linkageIds")))) {
                                newlinkageId = newlinkageId + "," + (String)cell.getUserObject("linkageIds");
                            }
                            cell.setUserObject("linkageIds", (Object)newlinkageId);
                        }
                    }
                }
            });
        }
        if (ischanged.size() > 0) {
            if (TemplateTypeEnum.DYNA.getType() != tm.getTemplateType().intValue()) {
                linkageCell = sm.getBook().getSheet(0).getCell(1, 1);
                String newlinkageIdMay = Long.toString(linkmappingEntry.getLong("entryentity.id"));
                if (linkageCell.getUserObject("linkageIdsMay") != null && !StringUtils.isEmpty((String)((String)linkageCell.getUserObject("linkageIdsMay")))) {
                    newlinkageIdMay = newlinkageIdMay + "," + (String)linkageCell.getUserObject("linkageIdsMay");
                }
                linkageCell.setUserObject("linkageIdsMay", (Object)newlinkageIdMay);
            }
            tm.setRptData(JsonSerializerUtil.toJson((SpreadManager)sm));
            needSaveTmpl.put(tm.getId(), tm);
        }
    }

    private static Set<String> getLinkMemNumbers(Object modelid, Map<String, String> userdefinedDim, String number, BaseEntry dimension, DynamicObject linkmappingEntry) {
        String numberStr = userdefinedDim.get(number);
        String queryNubmer = "entryentity." + (userdefinedDim.size() > 0 && numberStr != null ? "userdefined" + numberStr.replace("dim", "") : (DimTypesEnum.INTERCOMPANY.getNumber().equals(number) ? "intercompany" : number.toLowerCase(Locale.ENGLISH))) + ".number";
        String queryid = "entryentity." + (userdefinedDim.size() > 0 && numberStr != null ? "userdefined" + numberStr.replace("dim", "") : (DimTypesEnum.INTERCOMPANY.getNumber().equals(number) ? "intercompany" : number.toLowerCase(Locale.ENGLISH))) + ".id";
        String queryRange = "entryentity." + (userdefinedDim.size() > 0 && numberStr != null ? "userdefinedrange" + numberStr.replace("dim", "") : (DimTypesEnum.INTERCOMPANY.getNumber().equals(number) ? "intercompany" : number.toLowerCase(Locale.ENGLISH)) + "range");
        Long linkid = linkmappingEntry.getLong(queryid);
        String linkNumber = linkmappingEntry.getString(queryNubmer);
        int linkRange = linkmappingEntry.getInt(queryRange);
        Set memNumbers = QueryMemberDetailsHelper.queryMemberNumbersByRange((String)dimension.getDimension().getMemberEntityNumber(), (Long)linkid, (String)linkNumber, (int)linkRange, (String)String.valueOf(modelid), (DetailTypeEnum)DetailTypeEnum.OTHERS);
        return memNumbers;
    }

    private static Set<String> getMemNumbers(Object modelid, String number, Map<String, String> userdefinedDim, PageDimensionEntry dimension) {
        HashSet<String> memNumbers = new HashSet<String>();
        dimension.getMembers().forEach(e -> {
            if (userdefinedDim.containsKey(number)) {
                memNumbers.addAll(QueryMemberDetailsHelper.getDetailNumbers((String)dimension.getDimension().getMemberEntityNumber(), (Long)e.getId(), (int)e.getScope(), (String)String.valueOf(modelid), (DetailTypeEnum)DetailTypeEnum.OTHERS).keySet());
            } else {
                memNumbers.addAll(QueryMemberDetailsHelper.queryMemberNumbersByRange((String)dimension.getDimension().getMemberEntityNumber(), (Long)e.getId(), (String)e.getNumber(), (int)e.getScope(), (String)String.valueOf(modelid), (DetailTypeEnum)DetailTypeEnum.OTHERS));
            }
        });
        return memNumbers;
    }
}

