/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.linkdata;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.adjust.servicehelper.AdjustQueryServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.integrationnew.model.DataTraceFrom;
import kd.fi.bcm.business.integrationnew.service.DataTrace2FromService;
import kd.fi.bcm.business.linkquery.LinkQueryService;
import kd.fi.bcm.business.permission.BcmFunPermissionHelper;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.permission.cache.VersionParam;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.sql.MDResultSet;
import kd.fi.bcm.business.sql.SQLBuilder;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.AggOprtEnum;
import kd.fi.bcm.common.enums.DataSourceEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.enums.OlapSourceEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.common.util.NumberUtils;
import kd.fi.bcm.common.util.OlapCommandUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.intergration.util.LinkExtDataUtil;
import kd.fi.bcm.spread.common.util.DateTimeUtils;

public class DataDetailPlugin
extends AbstractBaseFormPlugin
implements RowClickEventListener {
    public static final String REDATA = "redata";
    public static final String PAGE = "page";
    public static final String SPLIT = "|";
    public static final String DATA = "data";
    public static final String ENTRY_ENTITY = "entryentity";
    public static final String BTN_REFRESH = "btn_refresh";
    public static final String BTN_LINK = "btn_link";
    private static final List<String> DEFAULT_DIMS_SET = Collections.unmodifiableList(Arrays.asList(PresetConstant.SCENE_DIM, PresetConstant.FY_DIM, PresetConstant.ENTITY_DIM, PresetConstant.PERIOD_DIM, PresetConstant.PROCESS_DIM, PresetConstant.CURRENCY_DIM, PresetConstant.AUDITTRIAL_DIM));
    private static final Set<String> doNotShowHyperlink = new HashSet<String>(Arrays.asList("ADJT", "SADJ", "EJET", "SEJE", "CCTotal", "CC", "PRPT", "ARPT", "Rpt", "ERpt", "CT", "CSTE", "SRPT", "SCADJ", "SCCADJ", "SEIC", "SEOE", "SEOther", "SEIT", "SECF"));
    private static final List<String> ALL_ENTRY_COLS = Collections.unmodifiableList(Arrays.asList("scenario", "year", "entity", "period", "process", "currency", "audittrail", "account", "changetype", "internalcompany", "mycompany", "datasort", "multigaap", "dim1", "dim2", "dim3", "dim4", "dim5", "dim6"));
    private static final Set<String> doNotIncludeSub = new HashSet<String>(Arrays.asList("Account", "ChangeType", "Currency", "Process", "AuditTrail"));
    private static final Map<String, String> TRANSFER_PROCESS = MapInitHelper.ofMap((Object)"SADJ", (Object)"ADJ", (Object)"SCADJ", (Object)"CADJ", (Object)"SCCADJ", (Object)"CCADJ");
    private static final List<String> FIX_HEAD = Arrays.asList("process", "audittrail", "entity", "account", "changetype", "currency");
    private static final List<String> NOT_INCLUDE_DIM_FILTER = Arrays.asList(SysDimensionEnum.Scenario.getNumber(), SysDimensionEnum.Year.getNumber(), SysDimensionEnum.Period.getNumber());
    private static final List<String> IN_STORAGE_TYPES = Arrays.asList(StorageTypeEnum.STORAGE.getOIndex(), StorageTypeEnum.SHARE.getOIndex(), StorageTypeEnum.UNSHARE.getOIndex());
    private static final DecimalFormat df = new DecimalFormat(",###,##0.00####");

    @Override
    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.getModel().setValue(REDATA, (Object)(customParams.get(REDATA) == null ? "" : DataDetailPlugin.parseNumber(customParams.get(REDATA).toString())));
        Map dimNumNameMap = MemberReader.getDimNumberMapNameById((long)this.getModelId());
        LinkedHashSet map = new LinkedHashSet(dimNumNameMap.keySet());
        ArrayList<String> list = new ArrayList<String>(DEFAULT_DIMS_SET);
        DEFAULT_DIMS_SET.forEach(map::remove);
        list.addAll(map);
        String modelNum = MemberReader.findModelNumberById((Object)this.getModelId());
        ArrayList<List<String>> dimensionValue = new ArrayList<List<String>>(10);
        ArrayList<HashMap<String, String>> dimNameMap = new ArrayList<HashMap<String, String>>(10);
        ArrayList<String> dimList = new ArrayList<String>(10);
        StringJoiner dimSB = new StringJoiner(",");
        for (String dim : list) {
            Pair<Long, String> pair = this.transferJSONObjectToPair(customParams.get(dim));
            IDNumberTreeNode node = MemberReader.findMemberById((long)this.getModelId(), (String)MemberReader.getEntityNumberByDim((String)modelNum, (String)dim), (Long)((Long)pair.p1));
            if (node == IDNumberTreeNode.NotFoundTreeNode) {
                return;
            }
            ArrayList<Object> dims = new ArrayList<Object>(10);
            String showValue = node.getNumber() + SPLIT + node.getName();
            dimSB.add(showValue);
            HashMap<String, String> temp = new HashMap<String, String>(16);
            if (SysDimensionEnum.Process.getNumber().equals(dim) && node.getNumber().equals("Rpt")) {
                node.getAllChildren().stream().filter(child -> IN_STORAGE_TYPES.contains(child.getStorageType().getOIndex()) && !AggOprtEnum.SKIP.name.equals(child.getAggOprt())).forEach(child -> {
                    dims.add(child.getNumber());
                    temp.put(child.getNumber(), child.getName());
                });
            } else if (node.getStorageType() == StorageTypeEnum.DYNAMIC || node.getNumber().equals(dim)) {
                this.getValidChildNode(node, temp);
                this.matchIC(customParams, dim, temp);
                if (!temp.isEmpty()) {
                    dims.addAll(temp.keySet());
                }
            } else if (node.getStorageType() == StorageTypeEnum.SHARE && node.getBaseTreeNode().getStorageType() == StorageTypeEnum.DYNAMIC && !node.isLeaf()) {
                node = MemberReader.findMemberByNumber((String)this.getModelNumber(), (String)dim, (String)node.getNumber());
                this.getValidChildNode(node, temp);
                if (!temp.isEmpty()) {
                    dims.addAll(temp.keySet());
                }
            }
            if (dims.isEmpty()) continue;
            if (SysDimensionEnum.Process.getNumber().equals(dim)) {
                int index2;
                int index1 = dims.indexOf("EIRpt");
                if (index1 >= 0) {
                    dims.set(index1, "IRpt");
                }
                if ((index2 = dims.indexOf("ERAdj")) >= 0) {
                    dims.set(index2, "RAdj");
                }
            }
            dimensionValue.add(dims);
            dimList.add(dim);
            dimNameMap.add(temp);
        }
        if (dimSB.length() > 0) {
            this.getModel().setValue(PAGE, (Object)dimSB.toString());
        }
        Map dimensionNumMapped = DimensionServiceHelper.getDimensionNumMapped((Object)this.getModelId());
        HashMap mapToDim = new HashMap(16);
        dimensionNumMapped.forEach((key, val) -> mapToDim.put(val, key));
        List appears = dimList.stream().map(dimensionNumMapped::get).collect(Collectors.toList());
        HashMap updateNameMap = new HashMap(8);
        appears.stream().filter(appear -> appear.startsWith("dim")).forEach(appear -> {
            HashMap temp = new HashMap(8);
            temp.put("zh_CN", dimNumNameMap.get(mapToDim.get(appear)));
            updateNameMap.put(appear, temp);
        });
        this.getView().updateControlMetadata(ENTRY_ENTITY, updateNameMap);
        this.getView().setVisible(Boolean.valueOf(false), (String[])ALL_ENTRY_COLS.stream().filter(col -> !appears.contains(col)).toArray(String[]::new));
        if (!this.isShowDataSource()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"source"});
        }
        boolean appearDynProcess = this.isAppearDynProcess(dimList, this.transferJSONObjectToPair(customParams.get(SysDimensionEnum.Process.getNumber())));
        if (!dimensionValue.isEmpty()) {
            MDResultSet olapData = this.getOlapData(modelNum, list, dimList, dimensionValue);
            LinkedHashMap<String, String> moneyMap = new LinkedHashMap<String, String>(16);
            HashMap<String, Object> sourceMap = new HashMap<String, Object>(16);
            HashMap<String, String> rowSourceMap = new HashMap<String, String>(16);
            boolean exist = dimList.contains(SysDimensionEnum.Process.getNumber());
            while (olapData.next()) {
                StringJoiner key2 = new StringJoiner(SPLIT);
                for (String dim : dimList) {
                    key2.add(olapData.getString(dim));
                }
                String money = olapData.getString(FacTabFieldDefEnum.FIELD_MONEY.getField());
                if (money != null) {
                    BigDecimal bigDecimal = null;
                    try {
                        bigDecimal = new BigDecimal(money);
                    }
                    catch (Exception exp) {
                        log.info("linkdetail\uff1a" + money);
                    }
                    if (bigDecimal != null && BigDecimal.ZERO.compareTo(bigDecimal) == 0) continue;
                    money = DataDetailPlugin.parseNumber(money);
                }
                moneyMap.put(key2.toString(), money);
                if (!this.isShowDataSource()) continue;
                sourceMap.put(key2.toString(), olapData.getString(FacTabFieldDefEnum.FIELD_SOURCE.getField()));
            }
            if (!moneyMap.isEmpty()) {
                EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
                this.getModel().beginInit();
                this.getModel().deleteEntryData(ENTRY_ENTITY);
                this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, moneyMap.size());
                int processIndex = dimList.indexOf(SysDimensionEnum.Process.getNumber());
                int row = 0;
                boolean setSource = !sourceMap.isEmpty();
                for (Map.Entry entry : moneyMap.entrySet()) {
                    String key3 = (String)entry.getKey();
                    String[] split = key3.split("\\|");
                    if (split.length != dimList.size()) continue;
                    if (setSource) {
                        Long o = sourceMap.getOrDefault(key3, 0L);
                        if (o == null) {
                            o = 0L;
                        }
                        this.getModel().setValue("source", (Object)OlapSourceEnum.getName((Object)Long.parseLong(((Object)o).toString())), row);
                        rowSourceMap.put(key3, ((Object)o).toString());
                    }
                    this.getModel().setValue(DATA, entry.getValue(), row);
                    for (int j = 0; j < dimList.size(); ++j) {
                        String name;
                        if (processIndex == j && appearDynProcess) {
                            String process = split[j];
                            if ("IRpt".equals(process)) {
                                process = "EIRpt";
                            } else if ("RAdj".equals(process)) {
                                process = "ERAdj";
                            }
                            name = MemberReader.findProcessMemberByNum((String)modelNum, (String)process).getName();
                            this.getModel().setValue((String)dimensionNumMapped.get(dimList.get(j)), (Object)(process + SPLIT + name), row);
                            continue;
                        }
                        Map nameMap = (Map)dimNameMap.get(j);
                        name = nameMap.getOrDefault(split[j], "");
                        this.getModel().setValue((String)dimensionNumMapped.get(dimList.get(j)), (Object)(split[j] + SPLIT + name), row);
                    }
                    ++row;
                }
                this.getView().getPageCache().put("selectDim", this.toByteSerialized(dimList));
                this.getView().getPageCache().put("keySourceMap", this.toByteSerialized(rowSourceMap));
            }
            this.getModel().endInit();
            ((EntryProp)this.getModel().getProperty(ENTRY_ENTITY)).setDisplayName(new LocaleString(String.format(ResManager.loadKDString((String)"\u8054\u67e5\u660e\u7ec6\u6765\u6e90_\u660e\u7ec6\u6570\u636e_%s", (String)"DataDetailPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), DateTimeUtils.getYear((Date)new Date()))));
        }
    }

    private void matchIC(Map<String, Object> customParams, String dim, Map<String, String> temp) {
        try {
            if (DimTypesEnum.INTERCOMPANY.getNumber().equals(dim)) {
                long sceneId = (Long)this.transferJSONObjectToPair((Object)customParams.get((Object)DimTypesEnum.SCENARIO.getNumber())).p1;
                long yearId = (Long)this.transferJSONObjectToPair((Object)customParams.get((Object)DimTypesEnum.YEAR.getNumber())).p1;
                long periodId = (Long)this.transferJSONObjectToPair((Object)customParams.get((Object)DimTypesEnum.PERIOD.getNumber())).p1;
                long icId = (Long)this.transferJSONObjectToPair((Object)customParams.get((Object)DimTypesEnum.INTERCOMPANY.getNumber())).p1;
                String icNumber = (String)this.transferJSONObjectToPair((Object)customParams.get((Object)DimTypesEnum.INTERCOMPANY.getNumber())).p2;
                VersionParam param = new VersionParam(this.getModelId(), sceneId, yearId, periodId);
                HashSet icValidNums = new HashSet(16);
                new MembRangeItem("bcm_icmembertree", Long.valueOf(icId), icNumber, RangeEnum.VALUE_90, false, (Object)this.getModelId()).matchItem4Ic(param, item -> icValidNums.add(item.getNumber()));
                temp.keySet().retainAll(icValidNums);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    private void getValidChildNode(IDNumberTreeNode node, Map<String, String> temp) {
        if (node.isLeaf()) {
            if (IN_STORAGE_TYPES.contains(node.getStorageType().getOIndex()) && !AggOprtEnum.SKIP.name.equals(node.getAggOprt())) {
                temp.put(node.getNumber(), node.getName());
            }
        } else {
            for (IDNumberTreeNode child : node.getChildren()) {
                if (IN_STORAGE_TYPES.contains(child.getStorageType().getOIndex()) && !AggOprtEnum.SKIP.name.equals(child.getAggOprt())) {
                    if (child.isShare() && !child.isLeaf()) {
                        for (IDNumberTreeNode childChild : child.getBaseTreeNode().getChildren()) {
                            this.getValidChildNode(childChild, temp);
                        }
                        continue;
                    }
                    temp.put(child.getNumber(), child.getName());
                    continue;
                }
                if (child.getStorageType() != StorageTypeEnum.DYNAMIC) continue;
                for (IDNumberTreeNode childChild : child.getChildren()) {
                    this.getValidChildNode(childChild, temp);
                }
            }
        }
    }

    private boolean isAppearDynProcess(List<String> dimList, Pair<Long, String> pair) {
        if (dimList.contains(SysDimensionEnum.Process.getNumber())) {
            IDNumberTreeNode processNode = MemberReader.findProcessMemberById((String)this.getModelNumber(), (Long)((Long)pair.p1));
            return processNode.getAllChildren().stream().anyMatch(child -> child.getNumber().equals("EIRpt") || child.getNumber().equals("ERAdj"));
        }
        return false;
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (BTN_REFRESH.equals(itemKey)) {
            this.afterCreateNewData(null);
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
            entryGrid.clearEntryState();
            this.showSourceInfoPanel(-1);
        } else if (BTN_LINK.equals(itemKey)) {
            this.closeLastForm();
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u660e\u7ec6\u6570\u636e\u884c\u3002", (String)"DataDetailPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            } else if (!this.showSourceInfo(selectRows[0])) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u884c\u65e0\u8054\u67e5\u8bb0\u5f55\u3002", (String)"DataDetailPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
        this.addItemClickListeners("toolbarap");
    }

    public void entryRowClick(RowClickEvent evt) {
        this.showSourceInfoPanel(evt.getRow());
    }

    private void closeLastForm() {
        String pageId = this.getPageCache().get("lastPageId");
        IFormView childView = this.getView().getView(pageId);
        if (StringUtils.isNotEmpty((CharSequence)pageId) && childView != null) {
            childView.close();
            this.getView().sendFormAction(childView);
            this.getPageCache().remove("lastPageId");
        }
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        int row = evt.getRow();
        this.showSourceInfoPanel(row);
    }

    @Override
    public long getModelId() {
        return (Long)this.getFormCustomParam("model");
    }

    @Override
    public String getModelNumber() {
        return MemberReader.findModelNumberById((Object)this.getFormCustomParam("model"));
    }

    private boolean showSourceInfo(int row) {
        boolean newForm = false;
        Map rowSourceMap = (Map)this.deSerializedBytes(this.getView().getPageCache().get("keySourceMap"));
        StringJoiner key = this.getRowKey(row);
        String sourceType = rowSourceMap.getOrDefault(key.toString(), "0");
        OlapSourceEnum enumByType = OlapSourceEnum.getSourceEnumByType((int)Integer.parseInt(sourceType));
        Map<String, String> dimMap = this.getRowDimMap(row);
        Map<String, Long> dimIdMap = this.getRowDimIdMap(row);
        String dimStr = LinkExtDataUtil.getTotalDimStr(dimMap, this.getModelId());
        if (enumByType == null) {
            newForm = this.showFormulaSource(dimMap, dimIdMap);
            if (!newForm && this.checkExistAdjustData(dimMap, dimIdMap)) {
                this.openAdjustForm(dimMap, dimIdMap);
                newForm = true;
            } else if (LinkExtDataUtil.existExtData(dimStr, this.getModelId(), false)) {
                FormShowParameter parameter = LinkExtDataUtil.getLinkExtDataParameter(this.getModelId(), dimMap, dimStr);
                this.getView().showForm(parameter);
                newForm = true;
            }
        } else {
            switch (enumByType) {
                case F1: 
                case I1: {
                    newForm = this.showFormulaSource(dimMap, dimIdMap);
                    break;
                }
                case J1: {
                    this.openAdjustForm(dimMap, dimIdMap);
                    newForm = true;
                    break;
                }
                case X1: {
                    if (!LinkExtDataUtil.existExtData(dimStr, this.getModelId(), true)) break;
                    FormShowParameter parameter = LinkExtDataUtil.getLinkExtDataParameter(this.getModelId(), dimMap, dimStr);
                    this.getView().showForm(parameter);
                    newForm = true;
                    break;
                }
            }
        }
        return newForm;
    }

    private StringJoiner getRowKey(int row) {
        List selectDim = (List)this.deSerializedBytes(this.getView().getPageCache().get("selectDim"));
        Map dimensionNumMapped = DimensionServiceHelper.getDimensionNumMapped((Object)this.getModelId());
        StringJoiner key = new StringJoiner(SPLIT);
        for (String select : selectDim) {
            String numAndName = this.getModel().getValue((String)dimensionNumMapped.get(select), row).toString();
            if (numAndName.contains(SPLIT)) {
                numAndName = numAndName.split("\\|")[0];
            }
            if (select.equals(SysDimensionEnum.Process.getNumber())) {
                numAndName = this.switchProcess(numAndName);
            }
            key.add(numAndName);
        }
        return key;
    }

    private boolean checkExistAdjustData(Map<String, String> dimMap, Map<String, Long> dimIdMap) {
        Long scenario = dimIdMap.get(SysDimensionEnum.Scenario.getNumber());
        Long year = dimIdMap.get(SysDimensionEnum.Year.getNumber());
        Long period = dimIdMap.get(SysDimensionEnum.Period.getNumber());
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        Map dimensionNumMapped = DimensionServiceHelper.getDimensionNumMapped((Object)this.getModelId());
        for (Map.Entry<String, String> entry : dimMap.entrySet()) {
            if (NOT_INCLUDE_DIM_FILTER.contains(entry.getKey())) continue;
            QFilter qFilter = null;
            if (SysDimensionEnum.Entity.getNumber().equals(entry.getKey())) {
                qFilter = new QFilter("olaporg", "=", (Object)entry.getValue());
            } else if (SysDimensionEnum.Process.getNumber().equals(entry.getKey())) {
                if (dimMap.get(SysDimensionEnum.Process.getNumber()).equals("RAdj") || dimMap.get(SysDimensionEnum.Process.getNumber()).equals("ERAdj")) {
                    Long rAdj = MemberReader.findProcessMemberByNum((String)this.getModelNumber(), (String)"RAdj").getId();
                    Long erAdj = MemberReader.findProcessMemberByNum((String)this.getModelNumber(), (String)"ERAdj").getId();
                    qFilter = new QFilter("process", "in", Arrays.asList(rAdj, erAdj));
                } else {
                    qFilter = new QFilter("process", "=", (Object)dimIdMap.get(SysDimensionEnum.Process.getNumber()));
                }
            } else if (dimensionNumMapped.get(entry.getKey()) != null) {
                qFilter = new QFilter((String)dimensionNumMapped.get(entry.getKey()), "=", (Object)dimIdMap.get(entry.getKey()));
            }
            if (qFilter == null) continue;
            filters.add(qFilter);
        }
        return !AdjustQueryServiceHelper.queryAdjustIds((long)this.getModelId(), (long)scenario, (long)year, (long)period, null, filters).isEmpty();
    }

    private void openAdjustForm(Map<String, String> dimMap, Map<String, Long> dimIdMap) {
        String processNum = dimMap.get(SysDimensionEnum.Process.getNumber());
        String auditNum = dimMap.get(SysDimensionEnum.AuditTrail.getNumber());
        IDNumberTreeNode processNode = MemberReader.findProcessMemberByNum((String)this.getModelNumber(), (String)processNum);
        if (!(doNotShowHyperlink.contains(processNum) || "EJE".equals(processNum) && !processNode.isLeaf() || auditNum == null)) {
            this.closeLastForm();
            Long auditId = dimIdMap.get(SysDimensionEnum.AuditTrail.getNumber());
            DynamicObjectCollection query = QueryServiceHelper.query((String)MemberReader.getEntityNumberByDim((String)this.getModelNumber(), (String)SysDimensionEnum.AuditTrail.getNumber()), (String)"datasource", (QFilter[])new QFBuilder("id", "=", (Object)auditId).toArray());
            IDNumberTreeNode accountNode = MemberReader.findMemberByNumber((String)this.getModelNumber(), (String)SysDimensionEnum.Account.getNumber(), (String)dimMap.get(SysDimensionEnum.Account.getNumber()));
            if (!query.isEmpty() && DataSourceEnum.ENTRYADJUSTMENT.getOIndex().equals(((DynamicObject)query.get(0)).getString("datasource")) && accountNode.isLeaf()) {
                if (!BcmFunPermissionHelper.isHasModelFuncPermToPage((long)this.getModelId(), (String)"bcm_rptadjustquery_list")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u8c03\u6574\u62b5\u9500\u5206\u5f55\u67e5\u8be2\u5217\u8868\u7684\u529f\u80fd\u6743\u9650\uff0c\u65e0\u6cd5\u4f7f\u7528\u8be5\u529f\u80fd\u3002", (String)"DataTracePlugin_23", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                ListShowParameter showParameter = new ListShowParameter();
                showParameter.setCustomParam("datatrace", (Object)1);
                showParameter.setCustomParam("model", (Object)this.getModelId());
                showParameter.setCustomParam("KEY_MODEL_ID", (Object)String.valueOf(this.getModelId()));
                Long year = dimIdMap.get(SysDimensionEnum.Year.getNumber());
                showParameter.setCustomParam("year", (Object)year);
                showParameter.setCustomParam("yearName", (Object)MemberReader.findFyMemberById((Long)this.getModelId(), (Long)year).getName());
                showParameter.setCustomParam("yearScope", (Object)"10");
                Long period = dimIdMap.get(SysDimensionEnum.Period.getNumber());
                showParameter.setCustomParam("period", (Object)period);
                showParameter.setCustomParam("periodName", (Object)MemberReader.findPeriodMemberById((Long)this.getModelId(), (Long)period).getName());
                showParameter.setCustomParam("periodScope", (Object)"10");
                Long scenario = dimIdMap.get(SysDimensionEnum.Scenario.getNumber());
                showParameter.setCustomParam("scenario", (Object)scenario);
                showParameter.setCustomParam("scenarioName", (Object)MemberReader.findScenaMemberById((Long)this.getModelId(), (Long)scenario).getName());
                showParameter.setCustomParam("scenarioScope", (Object)"10");
                IDNumberTreeNode entityNode = MemberReader.findEntityMemberById((Long)this.getModelId(), (Long)dimIdMap.get(SysDimensionEnum.Entity.getNumber()));
                showParameter.setCustomParam("schemeId", entityNode.getProperty("cslscheme.id"));
                for (Map.Entry<String, String> entry : dimMap.entrySet()) {
                    String scope = "10";
                    String dimNum = entry.getKey().toLowerCase();
                    IDNumberTreeNode node = MemberReader.findMemberById((long)this.getModelId(), (String)MemberReader.getEntityNumberByDim((String)this.getModelNumber(), (String)entry.getKey()), (Long)dimIdMap.get(entry.getKey()));
                    if (SysDimensionEnum.Entity.getNumber().equals(entry.getKey())) {
                        if (OrgRelaProcessMembPool.isRelaProcess((String)dimMap.get(SysDimensionEnum.Process.getNumber()))) {
                            showParameter.setCustomParam("mergeId", (Object)entityNode.getParent().getId());
                        }
                        showParameter.setCustomParam(dimNum + "Number", (Object)entry.getValue());
                    } else if (!doNotIncludeSub.contains(entry.getKey()) && node.isLeaf()) {
                        scope = Integer.toString(RangeEnum.VALUE_90.getValue());
                    } else if (SysDimensionEnum.Process.getNumber().equals(entry.getKey())) {
                        if (TRANSFER_PROCESS.containsKey(entry.getKey())) {
                            showParameter.setCustomParam(dimNum + "Number", (Object)TRANSFER_PROCESS.get(entry.getKey()));
                        }
                        String audiNum = dimMap.get(SysDimensionEnum.AuditTrail.getNumber());
                        if ("EJE".equalsIgnoreCase(entry.getValue()) && ("ADJE".equalsIgnoreCase(audiNum) || "ManualJournal".equalsIgnoreCase(audiNum) || "AutoJournal".equalsIgnoreCase(audiNum) || "LinkageJournal".equalsIgnoreCase(audiNum))) {
                            scope = "30";
                        }
                        if ("ADJT".equalsIgnoreCase(entry.getValue())) {
                            showParameter.setCustomParam("specialAdjt", (Object)true);
                        }
                    } else if (!FIX_HEAD.contains(dimNum)) {
                        scope = Integer.toString(RangeEnum.VALUE_90.getValue());
                    } else if (SysDimensionEnum.AuditTrail.getNumber().equals(entry.getKey()) && "ADJE".equals(entry.getValue())) {
                        scope = "30";
                    }
                    showParameter.setCustomParam(entry.getKey().toLowerCase(), (Object)dimIdMap.get(entry.getKey()));
                    showParameter.setCustomParam(entry.getKey().toLowerCase() + "Name", (Object)node.getName());
                    showParameter.setCustomParam(entry.getKey().toLowerCase() + "Scope", (Object)scope);
                }
                showParameter.setCustomParam("status", (Object)"3");
                showParameter.setBillFormId("bcm_rptadjustdata");
                showParameter.setFormId("bcm_rptadjustquery_edit");
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setCaption(ResManager.loadKDString((String)"\u8c03\u6574\u62b5\u9500\u5206\u5f55\u67e5\u8be2\u5217\u8868", (String)"DataTracePlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                String pageId = UUID.randomUUID().toString();
                showParameter.setPageId(pageId);
                this.getView().showForm((FormShowParameter)showParameter);
                this.getPageCache().put("lastPageId", pageId);
            }
        }
    }

    @Override
    public void afterBindData(EventObject e) {
    }

    private boolean showFormulaSource(Map<String, String> dimMap, Map<String, Long> dimIdMap) {
        DataTrace2FromService service = new DataTrace2FromService(Long.valueOf(this.getModelId()), Long.valueOf(0L));
        DataTraceFrom dtf = service.queryDataTraceFrom(dimMap);
        if (dtf == null) {
            return false;
        }
        LinkQueryService linkService = new LinkQueryService(this.getModelId(), this.getView());
        Map<String, Object> commParam = this.collectCommonParams(dimMap.get("Entity"), dimMap.get("Year"), dimMap.get("Period"), dimMap);
        commParam.putAll(dimIdMap);
        String lastPageId = linkService.link(dtf, dimMap, true, commParam);
        this.getPageCache().put("lastPageId", lastPageId);
        return true;
    }

    private Map<String, Object> collectCommonParams(String org, String yearNum, String periodNum, Map<String, String> memberMap) {
        HashMap<String, Object> commParam = new HashMap<String, Object>(16);
        commParam.put("org", org);
        commParam.put("fy", yearNum);
        commParam.put("period", periodNum);
        commParam.put("model", this.getModelId());
        commParam.put("memberMap", memberMap);
        return commParam;
    }

    private MDResultSet getOlapData(String modelNum, List<String> allDims, List<String> selectDims, List<List<String>> result) {
        SQLBuilder sql = new SQLBuilder(modelNum);
        sql.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        if (this.isShowDataSource()) {
            sql.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_SOURCE.getField()});
        }
        sql.addSelectField(selectDims.toArray(new String[0]));
        Map dimMap = this.getView().getFormShowParameter().getCustomParams();
        for (String dim : allDims) {
            Pair<Long, String> pair = this.transferJSONObjectToPair(dimMap.get(dim));
            int index = selectDims.indexOf(dim);
            if (index < 0) {
                String value = (String)pair.p2;
                if (SysDimensionEnum.Process.getNumber().equals(dim)) {
                    value = this.switchProcess(value);
                }
                if (SysDimensionEnum.Entity.getNumber().equals(dim)) {
                    IDNumberTreeNode node = MemberReader.findEntityMemberById((String)modelNum, (Long)((Long)pair.p1));
                    sql.addFilter(dim, new String[]{value, node.getParent_SonNumber()});
                    continue;
                }
                sql.addFilter(dim, new String[]{value});
                continue;
            }
            sql.addFilter(dim, result.get(index).toArray(new String[0]));
        }
        return OlapServiceHelper.queryData((SQLBuilder)sql, (boolean)true);
    }

    private boolean isShowDataSource() {
        return OlapCommandUtil.checkMeasure((String)MemberReader.findModelNumberById((Object)this.getModelId()), (String)FacTabFieldDefEnum.FIELD_SOURCE.getField());
    }

    private String switchProcess(String process) {
        String res = process;
        if ("EIRpt".equals(process)) {
            res = "IRpt";
        } else if ("ERAdj".equals(process)) {
            res = "RAdj";
        }
        return res;
    }

    private Pair<Long, String> transferJSONObjectToPair(Object pairObject) {
        JSONObject jsonObject;
        Pair pair = Pair.onePair((Object)0L, (Object)"");
        if (pairObject instanceof JSONObject && (jsonObject = (JSONObject)pairObject).containsKey((Object)"p1") && jsonObject.containsKey((Object)"p2")) {
            long p1 = 0L;
            String p2 = "";
            if (jsonObject.get((Object)"p1") instanceof Long) {
                p1 = (Long)jsonObject.get((Object)"p1");
            }
            if (jsonObject.get((Object)"p2") instanceof String) {
                p2 = (String)jsonObject.get((Object)"p2");
            }
            pair = Pair.onePair((Object)p1, (Object)p2);
        }
        return pair;
    }

    private void showSourceInfoPanel(int row) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bcm_sourcedetail_panel");
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey("flexpanelap3");
        if (row >= 0) {
            Map<String, String> dimMap = this.getRowDimMap(row);
            formShowParameter.setCustomParam("dimMap", dimMap);
            Map rowSourceMap = (Map)this.deSerializedBytes(this.getView().getPageCache().get("keySourceMap"));
            StringJoiner key = this.getRowKey(row);
            String sourceType = (String)rowSourceMap.get(key.toString());
            if (sourceType == null) {
                String dimStr = LinkExtDataUtil.getTotalDimStr(dimMap, this.getModelId());
                if (LinkExtDataUtil.existExtData(dimStr, this.getModelId(), false)) {
                    sourceType = String.valueOf(OlapSourceEnum.R1.getType());
                }
            } else if (String.valueOf(OlapSourceEnum.X1.getType()).equals(sourceType)) {
                sourceType = String.valueOf(OlapSourceEnum.R1.getType());
            }
            formShowParameter.setCustomParam("sourceType", (Object)sourceType);
            formShowParameter.setCustomParam("model", (Object)this.getModelId());
        }
        this.getView().showForm(formShowParameter);
    }

    private Map<String, Long> getRowDimIdMap(int row) {
        if (row < 0) {
            return Collections.emptyMap();
        }
        List selectDim = (List)this.deSerializedBytes(this.getView().getPageCache().get("selectDim"));
        Set allDim = MemberReader.getDimNumberMapNameById((long)this.getModelId()).keySet();
        HashMap<String, Long> dimIdMap = new HashMap<String, Long>(16);
        Map<String, Integer> dimIndexMap = selectDim.stream().collect(Collectors.toMap(k -> k, selectDim::indexOf));
        for (String dim : allDim) {
            Integer index = dimIndexMap.getOrDefault(dim, -1);
            if (index < 0) {
                Pair<Long, String> pair = this.transferJSONObjectToPair(this.getView().getFormShowParameter().getCustomParams().get(dim));
                String memNum = (String)pair.p2;
                dimIdMap.put(dim, (Long)pair.p1);
                if (!SysDimensionEnum.Process.getNumber().equals(dim)) continue;
                memNum = this.switchProcess(memNum);
                dimIdMap.put(dim, MemberReader.findProcessMemberByNum((String)this.getModelNumber(), (String)memNum).getId());
                continue;
            }
            String memNum = this.switchDimIdMap(row, dim);
            dimIdMap.put(dim, MemberReader.findMemberByNumber((String)this.getModelNumber(), (String)dim, (String)memNum).getId());
        }
        return dimIdMap;
    }

    private String switchDimIdMap(int row, String dim) {
        Map dimensionNumMapped = DimensionServiceHelper.getDimensionNumMapped((Object)this.getModelId());
        String memNum = this.getModel().getValue((String)dimensionNumMapped.get(dim), row).toString();
        if (SysDimensionEnum.Process.getNumber().equals(dim)) {
            memNum = this.switchProcess(memNum);
        }
        if (memNum.contains(SPLIT)) {
            memNum = memNum.split("\\|")[0];
        }
        return memNum;
    }

    private Map<String, String> getRowDimMap(int row) {
        if (row < 0) {
            return Collections.emptyMap();
        }
        List selectDim = (List)this.deSerializedBytes(this.getView().getPageCache().get("selectDim"));
        Set allDim = MemberReader.getDimNumberMapNameById((long)this.getModelId()).keySet();
        LinkedHashMap<String, String> dimMap = new LinkedHashMap<String, String>(16);
        Map<String, Integer> dimIndexMap = selectDim.stream().collect(Collectors.toMap(k -> k, selectDim::indexOf));
        for (String dim : allDim) {
            Integer index = dimIndexMap.getOrDefault(dim, -1);
            if (index < 0) {
                Pair<Long, String> pair = this.transferJSONObjectToPair(this.getView().getFormShowParameter().getCustomParams().get(dim));
                String memNum = (String)pair.p2;
                dimMap.put(dim, memNum);
                if (!SysDimensionEnum.Process.getNumber().equals(dim)) continue;
                memNum = this.switchProcess(memNum);
                dimMap.put(dim, memNum);
                continue;
            }
            String memNum = this.switchDimIdMap(row, dim);
            dimMap.put(dim, memNum);
        }
        if (OrgRelaProcessMembPool.isRelaProcess((String)((String)dimMap.get(SysDimensionEnum.Process.getNumber())))) {
            Pair<Long, String> pair = this.transferJSONObjectToPair(this.getView().getFormShowParameter().getCustomParams().get(SysDimensionEnum.Entity.getNumber()));
            IDNumberTreeNode node = MemberReader.findEntityMemberById((Long)this.getModelId(), (Long)((Long)pair.p1));
            dimMap.put(SysDimensionEnum.Entity.getNumber(), node.getParent_SonNumber());
        }
        return dimMap;
    }

    public static String parseNumber(String value) {
        String tra = value;
        if (NumberUtils.isNumber((String)value)) {
            BigDecimal bd = new BigDecimal(value);
            tra = df.format(bd);
        }
        return tra;
    }
}

