/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.linkdata;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ValueTextItem;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.list.F7SelectedList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.tree.ITreeNode;
import kd.fi.bcm.business.tree.TreeModel;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.linkdata.util.DataTraceSchemeUtils;
import kd.fi.bcm.formplugin.tree.dimension.AbstractDimensionTreeNode;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;

public class DataTraceExpandPathPlugin
extends AbstractBaseFormPlugin
implements TreeNodeClickListener {
    private static final String MEMBER_TREE = "treeviewap";
    private static final String F7_SELECTED = "f7selectedlistap";
    private static final String BTN_OK = "btnok";
    private static final String CACHE_CHECKED_NUMBER = "checkedNumber";

    @Override
    public void registerListener(EventObject e) {
        this.addClickListeners(BTN_OK);
        TreeView treeView = (TreeView)this.getView().getControl(MEMBER_TREE);
        treeView.addTreeNodeCheckListener(this::treeNodeClick);
        F7SelectedList f7SelectedList = (F7SelectedList)this.getView().getControl(F7_SELECTED);
        f7SelectedList.addF7SelectedListRemoveListener(f7SelectedListRemoveEvent -> {
            Object param = f7SelectedListRemoveEvent.getParam();
            if (param != null) {
                treeView.uncheckNode(param.toString());
                List checkedNodeIds = treeView.getTreeState().getCheckedNodeIds();
                if (checkedNodeIds.isEmpty()) {
                    this.getPageCache().put(CACHE_CHECKED_NUMBER, "");
                } else {
                    Collection allProcess = MemberReader.getAllNodeByDimNum((String)"Process", (String)MemberReader.findModelNumberById((Object)this.getModelId()));
                    Map<String, IDNumberTreeNode> bpId2NodeMap = allProcess.stream().collect(Collectors.toMap(p -> String.valueOf(p.getId()), p -> p));
                    StringJoiner sj = new StringJoiner(",");
                    checkedNodeIds.forEach(n -> {
                        IDNumberTreeNode node = (IDNumberTreeNode)bpId2NodeMap.get(n);
                        if (node != null) {
                            sj.add(node.getNumber());
                        }
                    });
                    this.getView().getPageCache().put(CACHE_CHECKED_NUMBER, sj.toString());
                }
            }
        });
        f7SelectedList.addF7SelectedListRemoveAllListener(f7SelectedListRemoveEvent -> {
            List nodeIds = MemberReader.getAllNodeByDimNum((String)"Process", (String)MemberReader.findModelNumberById((Object)this.getModelId())).stream().map(p -> String.valueOf(p.getId())).collect(Collectors.toList());
            treeView.uncheckNodes(nodeIds);
            this.getPageCache().put(CACHE_CHECKED_NUMBER, "");
        });
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.buildLeftTree();
        this.initCheckedNodeAndF7SelectedList();
    }

    private void initCheckedNodeAndF7SelectedList() {
        if (this.getView().getFormShowParameter().getCustomParam("expandPath") != null) {
            String expandPath = this.getView().getFormShowParameter().getCustomParam("expandPath").toString();
            TreeView treeView = (TreeView)this.getView().getControl(MEMBER_TREE);
            F7SelectedList f7SelectedList = (F7SelectedList)this.getView().getControl(F7_SELECTED);
            Map<String, IDNumberTreeNode> bpNumber2NodeMap = MemberReader.getAllNodeByDimNum((String)"Process", (String)MemberReader.findModelNumberById((Object)this.getModelId())).stream().filter(p -> !p.isShare()).collect(Collectors.toMap(IDNumberTreeNode::getNumber, p -> p));
            ArrayList checkedNodeList = new ArrayList(10);
            ArrayList listValue = new ArrayList(10);
            StringJoiner sj = new StringJoiner(",");
            Arrays.stream(expandPath.split(",")).forEach(p -> {
                IDNumberTreeNode node = (IDNumberTreeNode)bpNumber2NodeMap.get(p);
                if (node != null) {
                    TreeNode treeNode = new TreeNode();
                    treeNode.setId(String.valueOf(node.getId()));
                    checkedNodeList.add(treeNode);
                    ValueTextItem valueText = new ValueTextItem(String.valueOf(node.getId()), node.getNumber() + " " + node.getName());
                    listValue.add(valueText);
                    sj.add(node.getNumber());
                }
            });
            treeView.checkNodes(checkedNodeList);
            f7SelectedList.addItems(listValue);
            this.getView().getPageCache().put(CACHE_CHECKED_NUMBER, sj.toString());
        }
    }

    private void buildLeftTree() {
        AbstractDimensionTreeNode root = this.initMemberTree();
        if (root.getChildren() == null) {
            return;
        }
        TreeView tree = (TreeView)this.getView().getControl(MEMBER_TREE);
        TreeModel treeModel = new TreeModel((ITreeNode)root);
        TreeNode nodeRoot = treeModel.buildEntryTree(tree);
        String expandProcess = "";
        if (this.getView().getFormShowParameter().getCustomParam("expandProcess") != null) {
            expandProcess = this.getView().getFormShowParameter().getCustomParam("expandProcess").toString();
        }
        Set<String> checkableIdSet = this.getCheckableIdSetByNumber(expandProcess);
        nodeRoot.iterate(999, v -> {
            v.setIsOpened(true);
            v.setExpend(true);
            if (!checkableIdSet.contains(v.getId())) {
                v.setDisabled(true);
            }
        });
    }

    private AbstractDimensionTreeNode initMemberTree() {
        DynamicObjectCollection process = QueryServiceHelper.query((String)"bcm_processmembertree", (String)"id,number,name,storagetype,parent", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.getModelId()), new QFilter("longnumber", "like", (Object)"Process!CCTotal%").or(new QFilter("longnumber", "like", (Object)"Process!CT%")).or(new QFilter("number", "=", (Object)"DIF"))}, (String)"dseq");
        IDNumberTreeNode processNode = MemberReader.findProcessMemberByNum((String)MemberReader.findModelNumberById((Object)this.getModelId()), (String)"Process");
        AbstractDimensionTreeNode root = new AbstractDimensionTreeNode(String.valueOf(processNode.getId()), processNode.getName());
        root.SetIsOpened(true);
        HashMap<Long, List<AbstractDimensionTreeNode>> map = new HashMap<Long, List<AbstractDimensionTreeNode>>(16);
        for (DynamicObject dyn : process) {
            AbstractDimensionTreeNode child = new AbstractDimensionTreeNode(dyn.getString("id"), dyn.getString("number") + " " + dyn.getString("name"), dyn.getString("number"), dyn.getString("storagetype"));
            map.computeIfAbsent(dyn.getLong("parent"), p -> Lists.newArrayList()).add(child);
        }
        this.createTreeNode(root, map, (List)map.get(LongUtil.toLong((Object)root.getId())));
        return root;
    }

    private void createTreeNode(AbstractDimensionTreeNode root, HashMap<Long, List<AbstractDimensionTreeNode>> map, List<AbstractDimensionTreeNode> childNodes) {
        for (AbstractDimensionTreeNode childNode : childNodes) {
            root.addChild((ITreeNode<Object>)childNode);
            childNode.setParent((ITreeNode)root);
            List<AbstractDimensionTreeNode> grandchildNodes = map.get(LongUtil.toLong((Object)childNode.getId()));
            if (!CollectionUtils.isNotEmpty(grandchildNodes)) continue;
            this.createTreeNode(childNode, map, grandchildNodes);
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        Object nodeId = evt.getNodeId();
        if (nodeId == null) {
            return;
        }
        TreeView treeView = (TreeView)this.getView().getControl(MEMBER_TREE);
        F7SelectedList f7SelectedList = (F7SelectedList)this.getView().getControl(F7_SELECTED);
        List checkedNodeIds = treeView.getTreeState().getCheckedNodeIds();
        boolean isCancel = !checkedNodeIds.contains(nodeId.toString());
        Collection allProcess = MemberReader.getAllNodeByDimNum((String)"Process", (String)MemberReader.findModelNumberById((Object)this.getModelId()));
        Map<String, IDNumberTreeNode> bpId2NodeMap = allProcess.stream().collect(Collectors.toMap(p -> String.valueOf(p.getId()), p -> p));
        Map<String, IDNumberTreeNode> bpNumber2NodeMap = allProcess.stream().filter(p -> !p.isShare()).collect(Collectors.toMap(IDNumberTreeNode::getNumber, p -> p));
        HashSet<String> exclusions = new HashSet<String>();
        IDNumberTreeNode selectNode = bpId2NodeMap.get(nodeId.toString());
        this.collectParentAndChildExclusions(selectNode, exclusions);
        this.collectSpecialExclusions(selectNode, exclusions, bpNumber2NodeMap);
        ArrayList listValue = new ArrayList();
        StringJoiner sj = new StringJoiner(",");
        ArrayList uncheckedNodeIds = new ArrayList(10);
        checkedNodeIds.forEach(n -> {
            IDNumberTreeNode node = (IDNumberTreeNode)bpId2NodeMap.get(n);
            if (node != null && !exclusions.contains(n)) {
                ValueTextItem valueText = new ValueTextItem(n, node.getNumber() + " " + node.getName());
                listValue.add(valueText);
                sj.add(node.getNumber());
            } else {
                uncheckedNodeIds.add(n);
            }
        });
        treeView.uncheckNodes(uncheckedNodeIds);
        if (!isCancel) {
            TreeNode treeNode = new TreeNode();
            treeNode.setId(nodeId.toString());
            treeView.checkNode(treeNode);
        }
        f7SelectedList.addItems(listValue);
        this.getView().getPageCache().put(CACHE_CHECKED_NUMBER, sj.toString());
    }

    private void collectParentAndChildExclusions(IDNumberTreeNode selectNode, Set<String> exclusions) {
        exclusions.addAll(selectNode.getAllChildren().stream().map(n -> String.valueOf(n.getId())).collect(Collectors.toList()));
        this.addAllParentNode(selectNode, exclusions);
    }

    private void collectSpecialExclusions(IDNumberTreeNode selectNode, Set<String> exclusions, Map<String, IDNumberTreeNode> bpNumber2Node) {
        String number = selectNode.getNumber();
        boolean isOldModel = DataTraceSchemeUtils.judgeOldModelByEJE(this.getModelId());
        switch (number) {
            case "SRPT": {
                this.addId2Exclusions(exclusions, bpNumber2Node, "Rpt", "ERAdj", "EIRpt", "CCTotal");
                break;
            }
            case "Rpt": {
                this.addId2Exclusions(exclusions, bpNumber2Node, "SRPT", "ERAdj", "EIRpt");
                break;
            }
            case "SADJ": {
                this.addId2Exclusions(exclusions, bpNumber2Node, "ADJ", "CCTotal");
                break;
            }
            case "ADJT": {
                this.addId2Exclusions(exclusions, bpNumber2Node, "ADJ", "CADJ", "CCADJ", "CCTotal");
                break;
            }
            case "ADJ": {
                this.addId2Exclusions(exclusions, bpNumber2Node, "SADJ", "ADJT");
                break;
            }
            case "SCADJ": {
                this.addId2Exclusions(exclusions, bpNumber2Node, "CADJ", "CCTotal");
                break;
            }
            case "CADJ": {
                this.addId2Exclusions(exclusions, bpNumber2Node, "SCADJ", "ADJT");
                break;
            }
            case "SCCADJ": {
                this.addId2Exclusions(exclusions, bpNumber2Node, "ADJT", "CADJ", "CCTotal");
                break;
            }
            case "CCADJ": {
                this.addId2Exclusions(exclusions, bpNumber2Node, "SCCADJ", "ADJT");
                break;
            }
            case "SEJE": {
                this.addId2Exclusions(exclusions, bpNumber2Node, "EJE", "CCTotal");
                if (!isOldModel) break;
                this.addId2Exclusions(exclusions, bpNumber2Node, "EICA", "EOE", "EIT", "ECF", "EOther");
                break;
            }
            case "SEIC": {
                this.addId2Exclusions(exclusions, bpNumber2Node, "EICA");
                break;
            }
            case "SEOE": {
                this.addId2Exclusions(exclusions, bpNumber2Node, "EOE");
                break;
            }
            case "SEIT": {
                this.addId2Exclusions(exclusions, bpNumber2Node, "EIT");
                break;
            }
            case "SECF": {
                this.addId2Exclusions(exclusions, bpNumber2Node, "ECF");
                break;
            }
            case "SEOther": {
                this.addId2Exclusions(exclusions, bpNumber2Node, "EOther");
                break;
            }
            case "EJET": {
                this.addId2Exclusions(exclusions, bpNumber2Node, "EJE", "CCTotal");
                if (!isOldModel) break;
                this.addId2Exclusions(exclusions, bpNumber2Node, "EICA", "EOE", "EIT", "ECF", "EOther");
                break;
            }
            case "EJE": {
                this.addId2Exclusions(exclusions, bpNumber2Node, "SEJE", "EJET");
                break;
            }
            case "EICA": {
                this.addId2Exclusions(exclusions, bpNumber2Node, "EJET", "SEJE", "SEIC");
                break;
            }
            case "EOE": {
                this.addId2Exclusions(exclusions, bpNumber2Node, "EJET", "SEJE", "SEOE");
                break;
            }
            case "EIT": {
                this.addId2Exclusions(exclusions, bpNumber2Node, "EJET", "SEJE", "SEIT");
                break;
            }
            case "ECF": {
                this.addId2Exclusions(exclusions, bpNumber2Node, "EJET", "SEJE", "SECF");
                break;
            }
            case "EOther": {
                this.addId2Exclusions(exclusions, bpNumber2Node, "EJET", "SEJE", "SEOther");
                break;
            }
            case "ERAdj": {
                this.addId2Exclusions(exclusions, bpNumber2Node, "DIF", "SRPT", "Rpt");
                break;
            }
            case "EIRpt": {
                this.addId2Exclusions(exclusions, bpNumber2Node, "DIF", "SRPT", "Rpt");
                break;
            }
            case "DIF": {
                this.addId2Exclusions(exclusions, bpNumber2Node, "ERAdj", "EIRpt");
                break;
            }
            case "CCTotal": {
                this.addId2Exclusions(exclusions, bpNumber2Node, "SRPT", "ADJT", "EJET", "SADJ", "SCADJ", "SCCADJ", "SEJE");
            }
        }
    }

    private void addId2Exclusions(Set<String> exclusions, Map<String, IDNumberTreeNode> bpNumber2Node, String ... bpNumbers) {
        for (String bpNumber : bpNumbers) {
            if (bpNumber2Node.get(bpNumber) == null) continue;
            exclusions.add(String.valueOf(bpNumber2Node.get(bpNumber).getId()));
        }
    }

    private void addAllParentNode(IDNumberTreeNode selectNode, Set<String> exclusions) {
        if (selectNode.getParent() != null) {
            exclusions.add(String.valueOf(selectNode.getParent().getId()));
            this.addAllParentNode(selectNode.getParent(), exclusions);
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_OK.equals(key)) {
            this.getView().returnDataToParent((Object)this.getView().getPageCache().get(CACHE_CHECKED_NUMBER));
            this.getView().close();
        }
    }

    private Set<String> getCheckableNumberSetByNumber(String number) {
        boolean isOldModel = DataTraceSchemeUtils.judgeOldModelByEJE(this.getModelId());
        switch (number) {
            case "CCTotal": {
                return Sets.newHashSet((Object[])new String[]{"CCADJ", "CC", "EJE", "PRPT", "CADJ", "ARPT", "ADJ", "Rpt", "IRpt", "RAdj"});
            }
            case "CC": {
                return Sets.newHashSet((Object[])new String[]{"EJE", "PRPT", "CADJ", "ARPT", "ADJ", "Rpt", "IRpt", "RAdj"});
            }
            case "PRPT": {
                return Sets.newHashSet((Object[])new String[]{"CADJ", "ARPT", "ADJ", "Rpt", "IRpt", "RAdj"});
            }
            case "ARPT": {
                return Sets.newHashSet((Object[])new String[]{"ADJ", "Rpt", "IRpt", "RAdj"});
            }
            case "Rpt": {
                return Sets.newHashSet((Object[])new String[]{"IRpt", "RAdj"});
            }
            case "IRpt": {
                return Sets.newHashSet((Object[])new String[]{"ERpt", "EIRpt", "ERAdj"});
            }
            case "ERpt": {
                return Sets.newHashSet((Object[])new String[]{"EIRpt", "ERAdj", "DIF", "SRPT", "Rpt"});
            }
            case "EIRpt": {
                return Sets.newHashSet((Object[])new String[]{"SRPT", "Rpt", "ADJT", "SADJ", "ADJ", "SCADJ", "CADJ", "SCCADJ", "CCADJ", "DADJ", "EJET", "SEJE", "EJE", "DEJE", "CCTotal"});
            }
            case "CT": {
                return Sets.newHashSet((Object[])new String[]{"CSTE", "SRPT", "ADJT", "EJET"});
            }
            case "EJE": {
                if (isOldModel) {
                    return Sets.newHashSet((Object[])new String[]{"EICA", "EOE", "EIT", "ECF", "EOther"});
                }
            }
            case "SRPT": {
                return Sets.newHashSet((Object[])new String[]{"Rpt"});
            }
            case "ADJT": {
                return Sets.newHashSet((Object[])new String[]{"SADJ", "ADJ", "SCADJ", "CADJ", "SCCADJ", "CADJ", "CCADJ", "DADJ"});
            }
            case "SADJ": {
                return Sets.newHashSet((Object[])new String[]{"ADJ"});
            }
            case "SCADJ": {
                return Sets.newHashSet((Object[])new String[]{"CADJ"});
            }
            case "SCCADJ": {
                return Sets.newHashSet((Object[])new String[]{"CCADJ"});
            }
            case "EJET": {
                if (isOldModel) {
                    return Sets.newHashSet((Object[])new String[]{"SEJE", "SEIC", "SEOE", "SEIT", "SECF", "SEOther", "EJE", "EICA", "EOE", "EIT", "ECF", "EOther", "DEJE"});
                }
                return Sets.newHashSet((Object[])new String[]{"SEJE", "EJE", "DEJE"});
            }
            case "SEJE": {
                if (isOldModel) {
                    return Sets.newHashSet((Object[])new String[]{"SEIC", "SEOE", "SEIT", "SECF", "SEOther", "EJE", "EICA", "EOE", "EIT", "ECF", "EOther"});
                }
                return Sets.newHashSet((Object[])new String[]{"EJE"});
            }
            case "SEIC": {
                if (isOldModel) {
                    return Sets.newHashSet((Object[])new String[]{"EICA"});
                }
            }
            case "SEOE": {
                if (isOldModel) {
                    return Sets.newHashSet((Object[])new String[]{"EOE"});
                }
            }
            case "SEIT": {
                if (isOldModel) {
                    return Sets.newHashSet((Object[])new String[]{"EIT"});
                }
            }
            case "SECF": {
                if (isOldModel) {
                    return Sets.newHashSet((Object[])new String[]{"ECF"});
                }
            }
            case "SEOther": {
                if (isOldModel) {
                    return Sets.newHashSet((Object[])new String[]{"EOther"});
                }
            }
            case "DIF": {
                HashSet bpSet = Sets.newHashSet((Object[])new String[]{"ERAdj", "ADJT", "SADJ", "ADJ", "SCADJ", "CADJ", "SCCADJ", "CCADJ", "DADJ", "EJET", "SEJE", "EJE", "DEJE"});
                if (isOldModel) {
                    bpSet.addAll(Sets.newHashSet((Object[])new String[]{"SEIC", "SEOE", "SEIT", "SECF", "SEOther", "EJE", "EICA", "EOE", "EIT", "ECF", "EOther"}));
                }
                return bpSet;
            }
        }
        return Sets.newHashSet();
    }

    private Set<String> getCheckableIdSetByNumber(String number) {
        Set<String> checkableNumbers = this.getCheckableNumberSetByNumber(number);
        if (checkableNumbers.isEmpty()) {
            return checkableNumbers;
        }
        Map<String, Long> number2IdMap = MemberReader.getAllNodeByDimNum((String)"Process", (String)MemberReader.findModelNumberById((Object)this.getModelId())).stream().filter(p -> !p.isShare()).collect(Collectors.toMap(IDNumberTreeNode::getNumber, IDNumberTreeNode::getId));
        HashSet<String> set = new HashSet<String>(checkableNumbers.size());
        checkableNumbers.forEach(p -> set.add(String.valueOf(number2IdMap.get(p))));
        return set;
    }
}

