/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.linkdata;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.upgrade.DimensionNode;
import kd.fi.bcm.business.upgrade.DimensionTree;
import kd.fi.bcm.business.util.BCMNumberRule;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.cache.factory.CacheGenFactory;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.linkdata.VisibleScopeEnum;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.linkdata.util.DataTraceSchemeUtils;
import org.apache.commons.lang3.StringUtils;

public class DataTraceSchemePlugin
extends AbstractBaseFormPlugin
implements ProgresssListener {
    private static final String TREE_ENTRY_ENTITY = "treeentryentity";
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String VISIBLE_SCOPE = "visiblescope";
    private static final String PERM_CLASS = "permclass";
    private static final String CREATOR_NAME = "creatorname";
    private static final String BTN_OK = "btnok";
    private static final String EXPAND_PATH = "expandpath";

    @Override
    public void registerListener(EventObject e) {
        this.addClickListeners(BTN_OK, EXPAND_PATH);
        ((ProgressBar)this.getControl("progressbarap")).addProgressListener((ProgresssListener)this);
        BasedataEdit permClass = (BasedataEdit)this.getControl(PERM_CLASS);
        PermClassEntityHelper.setPermClassFilter((BasedataEdit)((BasedataEdit)this.getControl(PERM_CLASS)), (Object)this.getModelId());
        permClass.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (this.getView().getFormShowParameter().getCustomParam("bcm_datatracescheme") != null) {
            DynamicObject dy = BusinessDataServiceHelper.loadSingle((Object)this.getView().getFormShowParameter().getCustomParam("bcm_datatracescheme"), (String)"bcm_datatracescheme");
            this.buildBasicInfo(dy);
            this.setDisableControl(dy);
            this.getModel().setValue(CREATOR_NAME, (Object)dy.getString("creator.name"));
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{PERM_CLASS});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{CREATOR_NAME});
        }
        this.initEntry();
        if (!"preScheme".equals(this.getModel().getValue(NUMBER))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{TREE_ENTRY_ENTITY});
            ((ProgressBar)this.getControl("progressbarap")).start();
            HashMap<String, Integer> m = new HashMap<String, Integer>(16);
            m.put("itime", 50);
            this.getView().updateControlMetadata("progressbarap", m);
        }
    }

    private void setDisableControl(DynamicObject dy) {
        this.getView().setEnable(Boolean.valueOf(false), new String[]{CREATOR_NAME});
        long currUserId = RequestContext.get().getCurrUserId();
        boolean isCreator = dy.getLong("creator.id") == currUserId;
        boolean isModelAdmin = this.isCurModelAdmin(this.getModelId());
        Set writeDataPermission = PermClassEntityHelper.getWriteDataPermission((String)String.valueOf(this.getModelId()));
        if (!isCreator && !isModelAdmin) {
            if (this.getModel().getValue(PERM_CLASS) != null && writeDataPermission.contains(((DynamicObject)this.getModel().getValue(PERM_CLASS)).getLong("id"))) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{VISIBLE_SCOPE});
            } else {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{NUMBER, NAME, DESCRIPTION, VISIBLE_SCOPE, PERM_CLASS, EXPAND_PATH});
            }
        }
        if (!VisibleScopeEnum.PERM_CLASS.getScopeType().equals(this.getModel().getValue(VISIBLE_SCOPE))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{PERM_CLASS});
        }
    }

    private void buildBasicInfo(DynamicObject dy) {
        this.getModel().setValue(NUMBER, (Object)dy.getString(NUMBER));
        this.getModel().setValue(NAME, (Object)dy.getString(NAME));
        this.getModel().setValue(DESCRIPTION, (Object)dy.getString(DESCRIPTION));
        this.getModel().setValue(VISIBLE_SCOPE, (Object)dy.getString(VISIBLE_SCOPE));
        if (VisibleScopeEnum.PERM_CLASS.getScopeType().equals(this.getModel().getValue(VISIBLE_SCOPE))) {
            Map id2PermClass = PermClassEntityHelper.batchGetPermissionClassByEntityAndId((long)this.getModelId(), (String)"bcm_datatracescheme", (Set)Sets.newHashSet((Object[])new Long[]{dy.getLong("id")}));
            this.getModel().setValue(PERM_CLASS, id2PermClass.get(dy.getLong("id")) == null ? null : ((DynamicObject)id2PermClass.get(dy.getLong("id"))).getDynamicObject(PERM_CLASS));
        }
        if ("preScheme".equals(dy.getString(NUMBER))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{NUMBER, NAME, DESCRIPTION, VISIBLE_SCOPE, PERM_CLASS, BTN_OK, TREE_ENTRY_ENTITY});
        }
    }

    private void initEntry() {
        DynamicObject processDim = MemberReader.getDimensionDynById((long)MemberReader.getDimensionIdByNum((long)this.getModelId(), (String)DimTypesEnum.PROCESS.getNumber()));
        DynamicObjectCollection process = QueryServiceHelper.query((String)"bcm_processmembertree", (String)"id,name,number,parent,storagetype,isleaf,copyfrom,aggoprt,modifytime,modifier,dseq", (QFilter[])new QFilter("model", "=", (Object)this.getModelId()).and(new QFilter("longnumber", "like", (Object)"Process!CCTotal%").or(new QFilter("longnumber", "like", (Object)"Process!CT%")).or(new QFilter(NUMBER, "in", Arrays.asList("Process", "DIF")))).toArray(), (String)"dseq");
        this.buildTreeEntry(this.getModel(), process, Collections.singletonList("process"));
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(TREE_ENTRY_ENTITY);
        treeEntry.selectRows(0);
        treeEntry.setCollapse(false);
    }

    private void buildTreeEntry(IDataModel dataModel, DynamicObjectCollection dync, List<String> entryFields) {
        IDataModel model = this.getModel();
        model.deleteEntryData(TREE_ENTRY_ENTITY);
        model.getDataEntity(true);
        DimensionTree tree = DimensionNode.createDimTreeWithShareRef((DynamicObject[])((DynamicObject[])dync.toArray((Object[])new DynamicObject[0])));
        if (tree == null) {
            return;
        }
        Map<Object, Object> bp2ExpandPath = new HashMap(16);
        if (this.getView().getFormShowParameter().getCustomParam("bcm_datatracescheme") != null) {
            DynamicObject scheme = BusinessDataServiceHelper.loadSingle((Object)this.getView().getFormShowParameter().getCustomParam("bcm_datatracescheme"), (String)"bcm_datatracescheme");
            bp2ExpandPath = scheme.getDynamicObjectCollection("entryentity").stream().collect(Collectors.toMap(d -> d.getLong("process.id"), d -> d.getString(EXPAND_PATH)));
        }
        List children = tree.getChildren();
        children.sort(Comparator.comparingInt(o -> ((DimensionNode)o.getData()).getDseq()));
        model.beginInit();
        model.batchCreateNewEntryRow(TREE_ENTRY_ENTITY, tree.count());
        model.endInit();
        Map<Object, Object> finalBp2ExpandPath = bp2ExpandPath;
        tree.dfsWithIdx((t, idx) -> {
            DimensionNode node = (DimensionNode)t.getData();
            DynamicObject rowObj = model.getEntryRowEntity(TREE_ENTRY_ENTITY, idx.intValue());
            rowObj.set("process", (Object)(node.getNumber() + "-" + node.getDyn().get(NAME)));
            rowObj.set(EXPAND_PATH, finalBp2ExpandPath.get(node.getId()));
            rowObj.set("id", (Object)node.getId());
            rowObj.set("pid", (Object)node.getParent());
        }, Integer.valueOf(0));
        model.getEntryEntity(TREE_ENTRY_ENTITY).remove(0);
    }

    @Override
    public void click(EventObject evt) {
        int[] selectRows;
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_OK.equals(key)) {
            this.saveScheme();
            this.getView().returnDataToParent((Object)"1");
            this.getView().close();
        } else if (EXPAND_PATH.equals(key) && (selectRows = ((TreeEntryGrid)this.getView().getControl(TREE_ENTRY_ENTITY)).getSelectRows()).length > 0) {
            this.showExpandPathForm(selectRows[0]);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (VISIBLE_SCOPE.equals(name)) {
            if (!VisibleScopeEnum.PERM_CLASS.getScopeType().equals(e.getChangeSet()[0].getNewValue())) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{PERM_CLASS});
                this.getModel().setValue(PERM_CLASS, null);
            } else {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{PERM_CLASS});
            }
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        super.beforeF7Select(evt);
        String key = evt.getProperty().getName();
        if (PERM_CLASS.equals(key)) {
            evt.addCustomQFilter(new QFilter("model", "=", (Object)this.getModelId()));
        }
    }

    private void saveScheme() {
        DynamicObject dyn;
        if (this.getView().getFormShowParameter().getCustomParam("bcm_datatracescheme") != null) {
            dyn = BusinessDataServiceHelper.loadSingle((Object)this.getView().getFormShowParameter().getCustomParam("bcm_datatracescheme"), (String)"bcm_datatracescheme");
        } else {
            dyn = BusinessDataServiceHelper.newDynamicObject((String)"bcm_datatracescheme");
            dyn.set("id", (Object)GlobalIdUtil.genGlobalLongId());
            dyn.set("model", (Object)this.getModelId());
            dyn.set("creator", (Object)RequestContext.get().getCurrUserId());
            dyn.set("createtime", (Object)TimeServiceHelper.now());
            DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_datatracescheme", (String)"id,seqnum,createtime", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.getModelId())}, (String)"seqnum");
            dyn.set("seqnum", (Object)(((DynamicObject)query.get(query.size() - 1)).getInt("seqnum") + 1));
        }
        this.validInput(dyn.getLong("id"));
        dyn.set(NUMBER, this.getModel().getValue(NUMBER));
        dyn.set(NAME, this.getModel().getValue(NAME));
        dyn.set(VISIBLE_SCOPE, this.getModel().getValue(VISIBLE_SCOPE));
        dyn.set(DESCRIPTION, this.getModel().getValue(DESCRIPTION));
        dyn.set("modifier", (Object)RequestContext.get().getCurrUserId());
        dyn.set("modifytime", (Object)TimeServiceHelper.now());
        DynamicObjectCollection doc = new DynamicObjectCollection();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(TREE_ENTRY_ENTITY);
        for (DynamicObject entry : entryEntity) {
            DynamicObject dynamicObject = new DynamicObject(dyn.getDynamicObjectCollection("entryentity").getDynamicObjectType(), (Object)DB.genGlobalLongId());
            dynamicObject.set("process", (Object)entry.getLong("id"));
            dynamicObject.set(EXPAND_PATH, (Object)entry.getString(EXPAND_PATH));
            doc.add((Object)dynamicObject);
        }
        dyn.set("entryentity", (Object)doc);
        try (TXHandle tx = TX.required();){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyn});
                PermClassEntityHelper.deleteEntities(Collections.singletonList(dyn.getLong("id")), (Long)this.getModelId());
                if (VisibleScopeEnum.PERM_CLASS.getScopeType().equals(this.getModel().getValue(VISIBLE_SCOPE))) {
                    PermClassEntityHelper.savePermClass((String)"bcm_datatracescheme", (Object)dyn.getPkValue(), (Object)this.getModelId(), (Object)this.getModel().getValue(PERM_CLASS));
                }
                CacheGenFactory.getCommonCache().invalidateByKey(this.getModelId() + dyn.getString("id"));
            }
            catch (Exception e) {
                tx.markRollback();
                this.getView().showErrorNotification(e.getMessage());
                log.error(ThrowableHelper.toString((Exception)e));
            }
        }
    }

    private void validInput(long id) {
        String number = (String)this.getModel().getValue(NUMBER);
        if (StringUtils.isEmpty((CharSequence)number)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7f16\u7801\u3002", (String)"DataTraceSchemePlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (!BCMNumberRule.checkNumber((String)number)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65b9\u6848\u7f16\u7801\u4e0d\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u4ee5\u5916\u7684\u5b57\u7b26\uff0c\u4e0d\u53ef\u4ee5\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e4b\u95f4\u5fc5\u987b\u6709\u5176\u4ed6\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"DataTraceSchemePlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        QFilter qf = new QFilter("model", "=", (Object)this.getModelId());
        QFilter numberFilter = new QFilter(NUMBER, "=", (Object)number);
        if (id != 0L) {
            qf.and(new QFilter("id", "!=", (Object)id));
        }
        if (QueryServiceHelper.exists((String)"bcm_datatracescheme", (QFilter[])new QFilter[]{qf, numberFilter})) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u4e0b\u5df2\u5b58\u5728\u76f8\u540c\u7f16\u7801\u7684\u65b9\u6848\uff0c\u8bf7\u66f4\u6362\u7f16\u7801\u3002", (String)"DataTraceSchemePlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)this.getModel().getValue(NAME).toString())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u540d\u79f0\u3002", (String)"DataTraceSchemePlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        QFilter nameFilter = new QFilter(NAME, "=", (Object)((OrmLocaleValue)this.getModel().getValue(NAME)).getLocaleValue());
        if (QueryServiceHelper.exists((String)"bcm_datatracescheme", (QFilter[])new QFilter[]{qf, nameFilter})) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u4e0b\u5df2\u5b58\u5728\u76f8\u540c\u540d\u79f0\u7684\u65b9\u6848\uff0c\u8bf7\u66f4\u6362\u540d\u79f0\u3002", (String)"DataTraceSchemePlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (this.getModel().getValue(VISIBLE_SCOPE) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53ef\u89c1\u8303\u56f4\u3002", (String)"DataTraceSchemePlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (VisibleScopeEnum.PERM_CLASS.getScopeType().equals(this.getModel().getValue(VISIBLE_SCOPE)) && this.getModel().getValue(PERM_CLASS) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6743\u9650\u7c7b\u3002", (String)"DataTraceSchemePlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private void showExpandPathForm(int selectRow) {
        String processNumber = "";
        Object process = this.getModel().getValue("process", selectRow);
        if (process != null) {
            processNumber = process.toString().split("-")[0];
        }
        if (DataTraceSchemeUtils.canExpandPath(processNumber, DataTraceSchemeUtils.judgeOldModelByEJE(this.getModelId()))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b64\u8fc7\u7a0b\u4e0d\u53ef\u8bbe\u7f6e\u5c55\u5f00\u8def\u5f84\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u8fc7\u7a0b\u3002", (String)"DataTraceSchemePlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bcm_expandpathtree");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)String.valueOf(this.getModelId()));
        formShowParameter.setCustomParam("expandProcess", (Object)processNumber);
        formShowParameter.setCustomParam("expandPath", this.getModel().getValue(EXPAND_PATH, selectRow));
        formShowParameter.setCaption(String.format(ResManager.loadKDString((String)"%s \u5c55\u5f00\u8def\u5f84", (String)"DataTraceSchemePlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), process));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "bcm_expandpathtree");
        formShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Object returnData;
        String actionId = evt.getActionId();
        if ("bcm_expandpathtree".equals(actionId) && (returnData = evt.getReturnData()) != null) {
            TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(TREE_ENTRY_ENTITY);
            if (treeEntry.getSelectRows().length > 0) {
                this.getModel().setValue(EXPAND_PATH, returnData, treeEntry.getSelectRows()[0]);
            } else {
                this.getModel().setValue(EXPAND_PATH, returnData);
            }
        }
    }

    public void onProgress(ProgressEvent progressEvent) {
        if (this.getView().getFormShowParameter().getCustomParam("bcm_datatracescheme") != null) {
            DynamicObject dy = BusinessDataServiceHelper.loadSingle((Object)this.getView().getFormShowParameter().getCustomParam("bcm_datatracescheme"), (String)"bcm_datatracescheme");
            List writeDataPermission = PermClassEntityHelper.getPermissionMap((String)"bcm_datatracescheme", (String)String.valueOf(this.getModelId()), (String)String.valueOf(this.getUserId())).get((Object)"3");
            long currUserId = RequestContext.get().getCurrUserId();
            if (dy.getLong("creator.id") != currUserId && !this.isCurModelAdmin(this.getModelId()) && !writeDataPermission.contains(dy.getLong("id"))) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{TREE_ENTRY_ENTITY});
            } else {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{TREE_ENTRY_ENTITY});
            }
        } else {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{TREE_ENTRY_ENTITY});
        }
        ((ProgressBar)this.getControl("progressbarap")).stop();
        this.getView().updateView(TREE_ENTRY_ENTITY);
    }
}

