/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.linkdata.util;

import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.util.LanguageUtil;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.CacheTypeEnum;
import kd.fi.bcm.common.enums.linkdata.VisibleScopeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.linkdata.DataTraceSchemeConstant;

public class DataTraceSchemeUtils {
    private static WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, DataTraceSchemeUtils.class);

    public static DynamicObject querySchemeById(long modelId, String schemeId) {
        return (DynamicObject)GlobalCacheServiceHelper.getOrLoadFromCommonCache((String)(modelId + schemeId), () -> {
            QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId).and(new QFBuilder("id", "=", (Object)LongUtil.toLong((Object)schemeId)));
            return BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_datatracescheme", (QFilter[])qfBuilder.toArray());
        });
    }

    public static boolean judgeOldModelByEJE(long modelId) {
        IDNumberTreeNode EJENode = MemberReader.findProcessMemberByNum((String)MemberReader.findModelNumberById((Object)modelId), (String)"EJE");
        return !EJENode.isLeaf();
    }

    public static void prepareScheme(long modelId, boolean isCreateDifProcess) {
        StringJoiner sj;
        DynamicObject dynamicObject;
        long id;
        DynamicObject dyn;
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId).and(new QFBuilder("number", "=", (Object)"preScheme"));
        DynamicObject oldDyn = QueryServiceHelper.queryOne((String)"bcm_datatracescheme", (String)"id,visiblescope", (QFilter[])qfBuilder.toArray());
        if (oldDyn != null && VisibleScopeEnum.ONLY_SELF.getScopeType().equals(oldDyn.getString("visiblescope"))) {
            try {
                DataTraceSchemeUtils.update(modelId);
            }
            catch (Exception e) {
                log.error(String.format("[%s]\u66f4\u65b0\u6570\u636e\u5931\u8d25\uff1a", modelId), (Throwable)e);
            }
        }
        if (oldDyn != null && !isCreateDifProcess) {
            return;
        }
        if (oldDyn != null) {
            dyn = BusinessDataServiceHelper.loadSingle((Object)oldDyn.get("id"), (String)"bcm_datatracescheme");
            id = dyn.getLong("id");
        } else {
            dyn = BusinessDataServiceHelper.newDynamicObject((String)"bcm_datatracescheme");
            id = GlobalIdUtil.genGlobalLongId();
            dyn.set("id", (Object)id);
            dyn.set("model", (Object)modelId);
            dyn.set("creator", (Object)0L);
            dyn.set("createtime", (Object)TimeServiceHelper.now());
            dyn.set("seqnum", (Object)0);
            dyn.set("number", (Object)"preScheme");
            String preName = ResManager.loadKDString((String)"\u9884\u7f6e\u65b9\u6848", (String)"DataTraceSchemeUtils_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            Map translate = LanguageUtil.getTranslate((String)preName, (String)"DataTraceSchemeUtils_0", (String)"fi-bcm-formplugin");
            dyn.set("name", LanguageUtil.getName((String)preName, (Map)translate));
            dyn.set("isdefault", (Object)Boolean.TRUE);
            dyn.set("modifier", (Object)0L);
            dyn.set("modifytime", (Object)TimeServiceHelper.now());
            dyn.set("visiblescope", (Object)VisibleScopeEnum.EVERY_ONE.getScopeType());
        }
        DynamicObjectCollection doc = new DynamicObjectCollection();
        Map<String, IDNumberTreeNode> bpNumber2NodeMap = MemberReader.getAllNodeByDimNum((String)"Process", (String)MemberReader.findModelNumberById((Object)modelId)).stream().filter(p -> !p.isShare()).collect(Collectors.toMap(IDNumberTreeNode::getNumber, p -> p));
        boolean isOldModel = DataTraceSchemeUtils.judgeOldModelByEJE(modelId);
        IDNumberTreeNode node = null;
        node = bpNumber2NodeMap.get("CCTotal");
        if (node != null) {
            dynamicObject = new DynamicObject(dyn.getDynamicObjectCollection("entryentity").getDynamicObjectType(), (Object)DB.genGlobalLongId());
            dynamicObject.set("process", (Object)node.getId());
            sj = new StringJoiner(",");
            dynamicObject.set("expandpath", (Object)sj.add("CCADJ").add("CC").toString());
            doc.add((Object)dynamicObject);
        }
        if ((node = bpNumber2NodeMap.get("CC")) != null) {
            dynamicObject = new DynamicObject(dyn.getDynamicObjectCollection("entryentity").getDynamicObjectType(), (Object)DB.genGlobalLongId());
            dynamicObject.set("process", (Object)node.getId());
            sj = new StringJoiner(",");
            dynamicObject.set("expandpath", (Object)sj.add("EJE").add("PRPT").toString());
            doc.add((Object)dynamicObject);
        }
        if ((node = bpNumber2NodeMap.get("PRPT")) != null) {
            dynamicObject = new DynamicObject(dyn.getDynamicObjectCollection("entryentity").getDynamicObjectType(), (Object)DB.genGlobalLongId());
            dynamicObject.set("process", (Object)node.getId());
            sj = new StringJoiner(",");
            dynamicObject.set("expandpath", (Object)sj.add("CADJ").add("ARPT").toString());
            doc.add((Object)dynamicObject);
        }
        if ((node = bpNumber2NodeMap.get("ARPT")) != null) {
            dynamicObject = new DynamicObject(dyn.getDynamicObjectCollection("entryentity").getDynamicObjectType(), (Object)DB.genGlobalLongId());
            dynamicObject.set("process", (Object)node.getId());
            sj = new StringJoiner(",");
            dynamicObject.set("expandpath", (Object)sj.add("ADJ").add("Rpt").toString());
            doc.add((Object)dynamicObject);
        }
        if ((node = bpNumber2NodeMap.get("Rpt")) != null) {
            dynamicObject = new DynamicObject(dyn.getDynamicObjectCollection("entryentity").getDynamicObjectType(), (Object)DB.genGlobalLongId());
            dynamicObject.set("process", (Object)node.getId());
            sj = new StringJoiner(",");
            dynamicObject.set("expandpath", (Object)sj.add("IRpt").add("RAdj").toString());
            doc.add((Object)dynamicObject);
        }
        if ((node = bpNumber2NodeMap.get("IRpt")) != null) {
            dynamicObject = new DynamicObject(dyn.getDynamicObjectCollection("entryentity").getDynamicObjectType(), (Object)DB.genGlobalLongId());
            dynamicObject.set("process", (Object)node.getId());
            sj = new StringJoiner(",");
            dynamicObject.set("expandpath", (Object)sj.add("EIRpt").add("ERAdj").toString());
            doc.add((Object)dynamicObject);
        }
        if ((node = bpNumber2NodeMap.get("ERpt")) != null) {
            dynamicObject = new DynamicObject(dyn.getDynamicObjectCollection("entryentity").getDynamicObjectType(), (Object)DB.genGlobalLongId());
            dynamicObject.set("process", (Object)node.getId());
            sj = new StringJoiner(",");
            dynamicObject.set("expandpath", (Object)sj.add("EIRpt").add("ERAdj").toString());
            doc.add((Object)dynamicObject);
        }
        if ((node = bpNumber2NodeMap.get("EIRpt")) != null) {
            dynamicObject = new DynamicObject(dyn.getDynamicObjectCollection("entryentity").getDynamicObjectType(), (Object)DB.genGlobalLongId());
            dynamicObject.set("process", (Object)node.getId());
            sj = new StringJoiner(",");
            dynamicObject.set("expandpath", (Object)sj.add("SRPT").add("ADJT").add("EJET").toString());
            doc.add((Object)dynamicObject);
        }
        if ((node = bpNumber2NodeMap.get("CT")) != null) {
            dynamicObject = new DynamicObject(dyn.getDynamicObjectCollection("entryentity").getDynamicObjectType(), (Object)DB.genGlobalLongId());
            dynamicObject.set("process", (Object)node.getId());
            sj = new StringJoiner(",");
            dynamicObject.set("expandpath", (Object)sj.add("CSTE").add("SRPT").add("ADJT").add("EJET").toString());
            doc.add((Object)dynamicObject);
        }
        if ((node = bpNumber2NodeMap.get("SRPT")) != null) {
            dynamicObject = new DynamicObject(dyn.getDynamicObjectCollection("entryentity").getDynamicObjectType(), (Object)DB.genGlobalLongId());
            dynamicObject.set("process", (Object)node.getId());
            dynamicObject.set("expandpath", (Object)"Rpt");
            doc.add((Object)dynamicObject);
        }
        if ((node = bpNumber2NodeMap.get("ADJT")) != null) {
            dynamicObject = new DynamicObject(dyn.getDynamicObjectCollection("entryentity").getDynamicObjectType(), (Object)DB.genGlobalLongId());
            dynamicObject.set("process", (Object)node.getId());
            sj = new StringJoiner(",");
            dynamicObject.set("expandpath", (Object)sj.add("ADJ").add("CADJ").add("CCADJ").add("DADJ").toString());
            doc.add((Object)dynamicObject);
        }
        if ((node = bpNumber2NodeMap.get("SADJ")) != null) {
            dynamicObject = new DynamicObject(dyn.getDynamicObjectCollection("entryentity").getDynamicObjectType(), (Object)DB.genGlobalLongId());
            dynamicObject.set("process", (Object)node.getId());
            dynamicObject.set("expandpath", (Object)"ADJ");
            doc.add((Object)dynamicObject);
        }
        if ((node = bpNumber2NodeMap.get("SCADJ")) != null) {
            dynamicObject = new DynamicObject(dyn.getDynamicObjectCollection("entryentity").getDynamicObjectType(), (Object)DB.genGlobalLongId());
            dynamicObject.set("process", (Object)node.getId());
            dynamicObject.set("expandpath", (Object)"CADJ");
            doc.add((Object)dynamicObject);
        }
        if ((node = bpNumber2NodeMap.get("SCCADJ")) != null) {
            dynamicObject = new DynamicObject(dyn.getDynamicObjectCollection("entryentity").getDynamicObjectType(), (Object)DB.genGlobalLongId());
            dynamicObject.set("process", (Object)node.getId());
            dynamicObject.set("expandpath", (Object)"CCADJ");
            doc.add((Object)dynamicObject);
        }
        if ((node = bpNumber2NodeMap.get("EJET")) != null) {
            dynamicObject = new DynamicObject(dyn.getDynamicObjectCollection("entryentity").getDynamicObjectType(), (Object)DB.genGlobalLongId());
            dynamicObject.set("process", (Object)node.getId());
            sj = new StringJoiner(",");
            if (isOldModel) {
                dynamicObject.set("expandpath", (Object)sj.add("SEJE").add("DEJE").toString());
            } else {
                dynamicObject.set("expandpath", (Object)sj.add("EJE").add("DEJE").toString());
            }
            doc.add((Object)dynamicObject);
        }
        if ((node = bpNumber2NodeMap.get("SEJE")) != null) {
            dynamicObject = new DynamicObject(dyn.getDynamicObjectCollection("entryentity").getDynamicObjectType(), (Object)DB.genGlobalLongId());
            dynamicObject.set("process", (Object)node.getId());
            sj = new StringJoiner(",");
            if (isOldModel) {
                dynamicObject.set("expandpath", (Object)sj.add("SEIC").add("SEOE").add("SEIT").add("SECF").add("SEOther").toString());
            } else {
                dynamicObject.set("expandpath", (Object)"EJE");
            }
            doc.add((Object)dynamicObject);
        }
        if (isOldModel && (node = bpNumber2NodeMap.get("SEIC")) != null) {
            dynamicObject = new DynamicObject(dyn.getDynamicObjectCollection("entryentity").getDynamicObjectType(), (Object)DB.genGlobalLongId());
            dynamicObject.set("process", (Object)node.getId());
            dynamicObject.set("expandpath", (Object)"EICA");
            doc.add((Object)dynamicObject);
        }
        if (isOldModel && (node = bpNumber2NodeMap.get("SEOE")) != null) {
            dynamicObject = new DynamicObject(dyn.getDynamicObjectCollection("entryentity").getDynamicObjectType(), (Object)DB.genGlobalLongId());
            dynamicObject.set("process", (Object)node.getId());
            dynamicObject.set("expandpath", (Object)"EOE");
            doc.add((Object)dynamicObject);
        }
        if (isOldModel && (node = bpNumber2NodeMap.get("SEIT")) != null) {
            dynamicObject = new DynamicObject(dyn.getDynamicObjectCollection("entryentity").getDynamicObjectType(), (Object)DB.genGlobalLongId());
            dynamicObject.set("process", (Object)node.getId());
            dynamicObject.set("expandpath", (Object)"EIT");
            doc.add((Object)dynamicObject);
        }
        if (isOldModel && (node = bpNumber2NodeMap.get("SECF")) != null) {
            dynamicObject = new DynamicObject(dyn.getDynamicObjectCollection("entryentity").getDynamicObjectType(), (Object)DB.genGlobalLongId());
            dynamicObject.set("process", (Object)node.getId());
            dynamicObject.set("expandpath", (Object)"ECF");
            doc.add((Object)dynamicObject);
        }
        if (isOldModel && (node = bpNumber2NodeMap.get("SEOther")) != null) {
            dynamicObject = new DynamicObject(dyn.getDynamicObjectCollection("entryentity").getDynamicObjectType(), (Object)DB.genGlobalLongId());
            dynamicObject.set("process", (Object)node.getId());
            dynamicObject.set("expandpath", (Object)"EOther");
            doc.add((Object)dynamicObject);
        }
        if (isOldModel && (node = bpNumber2NodeMap.get("EJE")) != null) {
            dynamicObject = new DynamicObject(dyn.getDynamicObjectCollection("entryentity").getDynamicObjectType(), (Object)DB.genGlobalLongId());
            dynamicObject.set("process", (Object)node.getId());
            sj = new StringJoiner(",");
            dynamicObject.set("expandpath", (Object)sj.add("EICA").add("EIT").add("EOE").add("ECF").add("EOther").toString());
            doc.add((Object)dynamicObject);
        }
        if ((node = bpNumber2NodeMap.get("DIF")) != null || isCreateDifProcess) {
            if (isCreateDifProcess) {
                DynamicObject dif = QueryServiceHelper.queryOne((String)"bcm_processmembertree", (String)"id", (QFilter[])new QFilter("model", "=", (Object)modelId).and("number", "=", (Object)"DIF").toArray());
                DynamicObject dynamicObject2 = new DynamicObject(dyn.getDynamicObjectCollection("entryentity").getDynamicObjectType(), (Object)DB.genGlobalLongId());
                dynamicObject2.set("process", (Object)dif.getLong("id"));
                StringJoiner sj2 = new StringJoiner(",");
                dynamicObject2.set("expandpath", (Object)sj2.add("ERAdj").add("ADJT").add("EJET").toString());
                doc.add((Object)dynamicObject2);
            } else {
                dynamicObject = new DynamicObject(dyn.getDynamicObjectCollection("entryentity").getDynamicObjectType(), (Object)DB.genGlobalLongId());
                dynamicObject.set("process", (Object)node.getId());
                sj = new StringJoiner(",");
                dynamicObject.set("expandpath", (Object)sj.add("ERAdj").add("ADJT").add("EJET").toString());
                doc.add((Object)dynamicObject);
            }
        }
        for (String number : DataTraceSchemeConstant.canNotExpandNumberSet) {
            node = bpNumber2NodeMap.get(number);
            if (node == null || !DataTraceSchemeUtils.canExpandPath(number, isOldModel)) continue;
            DynamicObject dynamicObject3 = new DynamicObject(dyn.getDynamicObjectCollection("entryentity").getDynamicObjectType(), (Object)DB.genGlobalLongId());
            dynamicObject3.set("process", (Object)node.getId());
            doc.add((Object)dynamicObject3);
        }
        dyn.set("entryentity", (Object)doc);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyn});
        GlobalCacheServiceHelper.replaceCache((CacheTypeEnum)CacheTypeEnum.CommonCache, (String)(modelId + String.valueOf(id)), (Object)dyn);
    }

    private static void update(long modelId) {
        List ids = QueryServiceHelper.queryPrimaryKeys((String)"bcm_datatracescheme", (QFilter[])new QFilter("model", "=", (Object)modelId).toArray(), (String)"createtime", (int)-1);
        DynamicObject[] load = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bcm_datatracescheme"));
        for (int i = 0; i < load.length; ++i) {
            DynamicObject dyn = load[i];
            dyn.set("seqnum", (Object)i);
            dyn.set("isdefault", (Object)false);
        }
        load[0].set("visiblescope", (Object)VisibleScopeEnum.EVERY_ONE.getScopeType());
        load[0].set("isdefault", (Object)true);
        SaveServiceHelper.save((DynamicObject[])load);
    }

    public static boolean canExpandPath(String number, boolean isOldModel) {
        if (!isOldModel) {
            return DataTraceSchemeConstant.canNotExpandNumberSet.contains(number);
        }
        return DataTraceSchemeConstant.canNotExpandNumberSet.contains(number) && !"EJE".equals(number);
    }
}

