/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.logmanage;

import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.orm.query.QFilter;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.formplugin.template.MultipleMemberF7TemPlugin;
import org.apache.commons.lang3.StringUtils;

public class AuditLogMultipleMemberF7Plugin
extends MultipleMemberF7TemPlugin {
    private static final String CACHE_KEY_INIT_SELECTED_ITEMS = "init_selected_items";
    private static final String KEY_CLOSE = "btnclose";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(KEY_CLOSE);
    }

    @Override
    public void click(EventObject evt) {
        if (KEY_CLOSE.equals(((Control)evt.getSource()).getKey())) {
            String initSelectedItems = this.getPageCache().get(CACHE_KEY_INIT_SELECTED_ITEMS);
            DynamicObjectCollection initSelectedItem = (DynamicObjectCollection)SerializationUtils.deSerializeFromBase64((String)initSelectedItems);
            this.getView().returnDataToParent((Object)initSelectedItem);
            this.getView().close();
        } else {
            super.click(evt);
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IPageCache pageCache = this.getPageCache();
        DynamicObjectCollection selectedItem = this.getModel().getEntryEntity(this.entryentity);
        pageCache.put(CACHE_KEY_INIT_SELECTED_ITEMS, SerializationUtils.serializeToBase64((Object)selectedItem));
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        super.beforeF7Select(e);
        String key = ((Control)e.getSource()).getKey();
        if ("cslscheme".equals(key)) {
            List<Long> noPermListIds = this.getAllNoPermListIds();
            QFilter qFilter = new QFilter("id", "not in", noPermListIds);
            e.getCustomQFilters().add(qFilter);
        }
    }

    private List<Long> getAllNoPermListIds() {
        List<Long> noPermListIds = new ArrayList<Long>();
        String modelId = String.valueOf(this.getModelId());
        if (StringUtils.isNotEmpty((CharSequence)modelId)) {
            ArrayListMultimap permissionMapBatch = PermClassEntityHelper.getPermissionMapBatch((String)"bcm_cslscheme", (String)modelId, (String)RequestContext.get().getUserId());
            noPermListIds = permissionMapBatch.get((Object)"1");
        }
        return noPermListIds;
    }
}

