/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.logmanage;

import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FieldsetPanelAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.log.AuditLogESHelper;
import kd.fi.bcm.business.model.UserSelectModel;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.serviceHelper.UserSelectServiceHelper;
import kd.fi.bcm.common.OlapEnhancementHelper;
import kd.fi.bcm.common.Page;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.auditlog.AuditLogBill;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.BcmBasePluginUtil;
import kd.fi.bcm.formplugin.dimension.util.ModelUtil;
import kd.fi.bcm.formplugin.util.UserSelectUtil;
import org.apache.commons.collections4.CollectionUtils;

public class BcmAuditLogListPlugin
extends AbstractBaseFormPlugin {
    private static final String F7KEYPREFIX = "bcm_";
    private static final String START_DATETIME = "startdatetime";
    private static final String END_DATETIME = "enddatetime";
    private static final String USER = "user";
    private static final String TRANSACTION_TYPE = "transactiontype";
    private static final String MODEL = "model";
    private static final String SEL_MEMBER_AP = "selmemberap";
    private static final String KEY_ICMEMBERTREE_INTERNALCOMPANY = "bcm_icmembertree_internalcompany";
    private static final String F7MAPFIELDSCACHEKEY = "f7MapFields";
    private static final String BCM_AUDIT_LOG = "bcm_audit_log";
    private static final String TOOLBARAP = "toolbarap";
    private static final String BARITEMSHOWLOG = "baritemshowlog";
    private static final String BARITEMREFRESH = "baritemrefresh";
    private static final String BARITEMRESET = "baritemreset";
    private static final String BARITEMDOWNLOAD = "baritemdownload";
    private static final String ENTRYENTITY = "entryentity";
    private static final List<String> hide_list = Arrays.asList("c1", "c2", "c3", "c4", "c5", "c6");
    private static final int DEFAULT_PAGE = 1;
    private static final int DEFAULT_PAGESIZE = 10000;
    private static final String CACHE_PREFIX_F7KEY_TO_DIMENSION_NUMBER_MAP = "controlKeyToDimensionNumberMap:";
    private static final String CACHE_PREFIX_F7KEY_TO_Entity_NUMBER_MAP = "controlKeyToEntityNumberMap:";
    private static final String MEMBERMODEL = "membermodel";
    private static final String DATASORT = "datasort";
    private static final String ID = "id";
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(BcmAuditLogListPlugin.class);

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(TOOLBARAP);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initModel();
        this.setDefaultValue();
        this.getView().setEnable(Boolean.FALSE, new String[]{ENTRYENTITY});
        this.getView().setVisible(Boolean.FALSE, new String[]{DATASORT});
        this.hideRow();
        this.createBatchDimensionComponents();
        this.baritemshowlogVisiable();
    }

    private void baritemshowlogVisiable() {
        int num = BcmBasePluginUtil.checkPermission(this.getUserId(), this.getModelId(), AppMetadataCache.getAppInfo((String)this.getBizAppId()).getId(), this.getView().getEntityId(), "47150e89000000ac");
        this.getView().setVisible(Boolean.valueOf(0 != num), new String[]{BARITEMSHOWLOG});
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.createBatchDimensionComponents();
    }

    private void setDefaultValue() {
        LocalDate now = LocalDate.now();
        ZonedDateTime zonedDateTime = now.atStartOfDay().atZone(ZoneId.systemDefault());
        Date startTime = Date.from(zonedDateTime.toInstant());
        this.getModel().setValue(START_DATETIME, (Object)startTime);
    }

    private void initModel() {
        UserSelectModel user = UserSelectServiceHelper.getUserSelect((String)Long.toString(this.getUserId()), (String)"issummury,id,model,model.id,isadjustlisttype,application,entity,year,period,scenario,currency,modifier,modifydate,onlymodel,formid,version,cslscheme,dmmodel", (ApplicationTypeEnum)ApplicationTypeEnum.CM);
        String modelId = user.getModel();
        if (StringUtils.isNotEmpty((String)modelId)) {
            List<QFilter> modelFilter = ModelUtil.getModelFilter(this.getView());
            modelFilter.add(new QFilter(ID, "=", (Object)LongUtil.toLong((Object)modelId)));
            DynamicObject modelDy = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_model", (QFilter[])modelFilter.toArray(new QFilter[0]));
            if (Objects.isNull(modelDy)) {
                this.getModel().setValue(MODEL, null);
            } else {
                this.getModel().setValue(MODEL, (Object)modelDy);
            }
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        Optional<String> validateMsg;
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ((BARITEMSHOWLOG.equals(itemKey) || BARITEMREFRESH.equals(itemKey)) && (validateMsg = this.validate()).isPresent()) {
            this.getView().showTipNotification(validateMsg.get());
            return;
        }
        switch (itemKey) {
            case "baritemshowlog": 
            case "baritemrefresh": {
                try {
                    this.loadEntityData();
                    break;
                }
                catch (Exception exception) {
                    this.getView().showErrorNotification(exception.getMessage());
                    logger.error((Throwable)exception);
                    return;
                }
            }
            case "baritemreset": {
                if (Objects.isNull(this.getValue(MODEL))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"BcmAuditLogListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                MainEntityType dataEntityType = this.getModel().getDataEntityType();
                Map allEntities = dataEntityType.getAllEntities();
                EntityType bcmAuditLogFields = (EntityType)allEntities.get(BCM_AUDIT_LOG);
                Map fieldsMap = bcmAuditLogFields.getFields();
                fieldsMap.forEach((key, v) -> {
                    if (!MODEL.equals(key)) {
                        this.getModel().setValue(key, (Object)"");
                        if (key.startsWith(F7KEYPREFIX)) {
                            this.getPageCache().remove(key);
                        }
                    }
                });
                this.setDefaultValue();
                this.getView().updateView();
                break;
            }
        }
    }

    private Optional<String> validate() {
        String modeNumber;
        boolean isOpenAudit;
        IDataModel model = this.getModel();
        DynamicObject modelValue = (DynamicObject)model.getValue(MODEL);
        if (Objects.isNull(modelValue)) {
            return Optional.of(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"BcmAuditLogListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        Date startTime = (Date)model.getValue(START_DATETIME);
        if (Objects.isNull(startTime)) {
            return Optional.of(ResManager.loadKDString((String)"\u8bf7\u6307\u5b9a\u5f00\u59cb\u65f6\u95f4\u3002", (String)"BcmAuditLogListPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        Date curDate = new Date();
        if (startTime.getTime() > curDate.getTime()) {
            return Optional.of(ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u5f53\u524d\u65f6\u95f4\u3002", (String)"BcmAuditLogListPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        Date endTime = (Date)model.getValue(END_DATETIME);
        if (Objects.nonNull(endTime) && startTime.getTime() > endTime.getTime()) {
            return Optional.of(ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4\u3002", (String)"BcmAuditLogListPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        Set<String> selectedCurrencies = this.extractSpecificDimSelectedNumbers("Currency");
        if (!selectedCurrencies.isEmpty() && CollectionUtils.containsAny(selectedCurrencies, (Collection)AuditLogESHelper.getSpecialCurrency())) {
            Set<String> selectedOrgs = this.extractSpecificDimSelectedNumbers("Entity");
            Set<String> selectedProcess = this.extractSpecificDimSelectedNumbers("Process");
            if (selectedOrgs.isEmpty() || selectedProcess.isEmpty()) {
                return Optional.of(ResManager.loadKDString((String)"\u6307\u5b9a\u201c\u5e01\u79cd\u201d\u7ef4\u5ea6\u4e3a\u9ed8\u8ba4\u5e01\u6216\u672c\u5e01\u6216\u6298\u7b97\u5e01\u7684\u540c\u65f6\u9700\u8981\u6307\u5b9a\u4e00\u4e2a\u201c\u7ec4\u7ec7\u201d\u7ef4\u5ea6\u4ee5\u53ca\u81f3\u5c11\u4e00\u4e2a\u201c\u8fc7\u7a0b\u201d\u7ef4\u5ea6\u3002", (String)"BcmAuditLogListPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            if (selectedOrgs.size() > 1) {
                return Optional.of(ResManager.loadKDString((String)"\u6307\u5b9a\u201c\u5e01\u79cd\u201d\u7ef4\u5ea6\u4e3a\u9ed8\u8ba4\u5e01\u6216\u672c\u5e01\u6216\u6298\u7b97\u5e01\u65f6\u53ea\u5141\u8bb8\u6307\u5b9a\u4e00\u4e2a\u201c\u7ec4\u7ec7\u201d\u7ef4\u5ea6\u3002", (String)"BcmAuditLogListPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        }
        if (!(isOpenAudit = OlapEnhancementHelper.isCubeEnableAudit((String)(modeNumber = ((DynamicObject)model.getValue(MODEL)).getString(NUMBER))))) {
            return Optional.of(ResManager.loadKDString((String)"\u672a\u5f00\u542f\u5ba1\u8ba1\u65e5\u5fd7\u3002", (String)"BcmAuditLogListPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        return Optional.empty();
    }

    private Set<String> extractSpecificDimSelectedNumbers(String specificDimNum) {
        if (StringUtils.isEmpty((String)specificDimNum)) {
            throw new IllegalArgumentException("param 'specificDimNum' is empty");
        }
        String cachedSelectedDims = this.getPageCache().get(F7MAPFIELDSCACHEKEY);
        List<String> dimensionCtrlList = StringUtils.isEmpty((String)cachedSelectedDims) ? Collections.emptyList() : Arrays.asList(cachedSelectedDims.split(";"));
        for (String dimComponentKey : dimensionCtrlList) {
            String dimenNumber = this.getPageCache().get(CACHE_PREFIX_F7KEY_TO_DIMENSION_NUMBER_MAP + dimComponentKey);
            if (!specificDimNum.equals(dimenNumber)) continue;
            String selectedItemStr = this.getPageCache().get(dimComponentKey);
            return this.fetchMemberNumbersByRange(dimComponentKey, selectedItemStr);
        }
        return Collections.emptySet();
    }

    private void loadEntityData() {
        this.clearEntity();
        IDataModel model = this.getModel();
        DynamicObject modelValue = (DynamicObject)model.getValue(MODEL);
        Date startTime = (Date)model.getValue(START_DATETIME);
        Date endTime = Objects.isNull(model.getValue(END_DATETIME)) ? new Date() : (Date)model.getValue(END_DATETIME);
        String cachedSelectedDims = this.getPageCache().get(F7MAPFIELDSCACHEKEY);
        List<String> dimensionCtrlList = StringUtils.isEmpty((String)cachedSelectedDims) ? Collections.emptyList() : Arrays.asList(cachedSelectedDims.split(";"));
        AuditLogESHelper.AuditLogQueryParam.Builder builder = new AuditLogESHelper.AuditLogQueryParam.Builder(modelValue.getLong(ID), startTime, endTime);
        if (Objects.nonNull(model.getValue(USER))) {
            builder.setUserId(Long.valueOf(((DynamicObject)model.getValue(USER)).getLong(ID)));
        }
        if (Objects.nonNull(model.getValue(TRANSACTION_TYPE))) {
            builder.setTransactionTag(model.getValue(TRANSACTION_TYPE).toString());
        }
        ArrayList dimensionList = Lists.newArrayListWithExpectedSize((int)1);
        dimensionCtrlList.forEach(dimComponentKey -> {
            String selectedItemStr = this.getPageCache().get(dimComponentKey);
            Set<String> memberNumbers = this.fetchMemberNumbersByRange((String)dimComponentKey, selectedItemStr);
            String dimenNumber = this.getPageCache().get(CACHE_PREFIX_F7KEY_TO_DIMENSION_NUMBER_MAP + dimComponentKey);
            if (memberNumbers.size() > 0 && dimensionList.size() == 0) {
                dimensionList.add(1);
            }
            switch (dimenNumber) {
                case "Entity": {
                    builder.setEntityDims(memberNumbers);
                    break;
                }
                case "Account": {
                    builder.setAccountDims(memberNumbers);
                    break;
                }
                case "Year": {
                    builder.setYearDims(memberNumbers);
                    break;
                }
                case "Period": {
                    builder.setPeriodDims(memberNumbers);
                    break;
                }
                case "Scenario": {
                    builder.setScenarioDims(memberNumbers);
                    break;
                }
                case "Process": {
                    builder.setProcessDims(memberNumbers);
                    break;
                }
                case "Currency": {
                    builder.setCurrencyDims(memberNumbers);
                    break;
                }
                case "AuditTrail": {
                    builder.setAuditTrailDims(memberNumbers);
                    break;
                }
                case "ChangeType": {
                    builder.setChangeTypeDims(memberNumbers);
                    break;
                }
                case "InternalCompany": {
                    builder.setInternalCompanyDims(memberNumbers);
                    break;
                }
                case "DataSort": {
                    builder.setDataSortDims(memberNumbers);
                    break;
                }
                case "MultiGAAP": {
                    builder.setMultiGAAPDims(memberNumbers);
                    break;
                }
                case "MyCompany": {
                    builder.setMyCompanyDims(memberNumbers);
                    break;
                }
                default: {
                    builder.addCustomDims(dimenNumber, memberNumbers);
                }
            }
        });
        boolean flag = false;
        if (dimensionList.size() > 0) {
            flag = true;
        }
        Map result = AuditLogESHelper.search((long)modelValue.getLong(ID), (AuditLogESHelper.AuditLogQueryParam)builder.build(), (Integer)1, (Integer)10000, (Boolean)flag);
        Page pageBill = (Page)result.get("pageResult");
        List records = pageBill.getRecords();
        String message = (String)result.get("message");
        if (!StringUtils.isEmpty((String)message)) {
            this.getView().showTipNotification(message);
        }
        if (records.size() == 0) {
            Label title = (Label)this.getControl("listtips");
            title.setText(String.format(ResManager.loadKDString((String)"\u5171%s\u6761", (String)"BcmAuditLogListPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), 0));
            return;
        }
        Label title = (Label)this.getControl("listtips");
        title.setText(String.format(ResManager.loadKDString((String)"\u5171%s\u6761", (String)"BcmAuditLogListPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), pageBill.getTotal()));
        model.deleteEntryData(ENTRYENTITY);
        model.getDataEntity(true);
        if (!pageBill.getRecords().isEmpty()) {
            model.beginInit();
            model.batchCreateNewEntryRow(ENTRYENTITY, pageBill.getRecords().size());
            model.endInit();
            DynamicObjectCollection entryRows = model.getEntryEntity(ENTRYENTITY);
            for (int i = 0; i < entryRows.size(); ++i) {
                DynamicObject entity = (DynamicObject)entryRows.get(i);
                AuditLogBill x = (AuditLogBill)pageBill.getRecords().get(i);
                entity.set("eventid", (Object)x.getEventId());
                entity.set("opuser", (Object)x.getUserDy());
                entity.set("ipfield", (Object)x.getIp());
                entity.set("transaction", (Object)x.getTransactionType());
                entity.set("optime", (Object)x.getOperateTime());
                entity.set("amount", (Object)x.getNewValue());
                entity.set("entity", (Object)x.getEntityDy());
                entity.set("account", (Object)x.getAccountDy());
                entity.set("scenario", (Object)x.getScenarioDy());
                entity.set("year", (Object)x.getYearDy());
                entity.set("period", (Object)x.getPeriodDy());
                entity.set("process", (Object)x.getProcessDy());
                entity.set("currency", (Object)x.getCurrencyDy());
                entity.set("audittrail", (Object)x.getAuditTrailDy());
                entity.set("changetype", (Object)x.getChangeTypeDy());
                entity.set("internalcompany", (Object)x.getInternalCompanyDy());
                if (x.getDataSortDy() != null && x.getDataSortDy().getLong(ID) != 0L) {
                    entity.set(DATASORT, (Object)x.getDataSortDy());
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{DATASORT});
                }
                if (x.getMultiGAAPDy() != null && x.getMultiGAAPDy().getLong(ID) != 0L) {
                    entity.set("multigaap", (Object)x.getMultiGAAPDy());
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"multigaap"});
                }
                if (x.getMyCompanyDy() != null && x.getMyCompanyDy().getLong(ID) != 0L) {
                    entity.set("mycompany", (Object)x.getMyCompanyDy());
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"mycompany"});
                }
                if (x.getC1Dy() != null && x.getC1Dy().getLong(ID) != 0L) {
                    entity.set("c1", (Object)x.getC1Dy());
                }
                if (x.getC2Dy() != null && x.getC2Dy().getLong(ID) != 0L) {
                    entity.set("c2", (Object)x.getC2Dy());
                }
                if (x.getC3Dy() != null && x.getC3Dy().getLong(ID) != 0L) {
                    entity.set("c3", (Object)x.getC3Dy());
                }
                if (x.getC4Dy() != null && x.getC4Dy().getLong(ID) != 0L) {
                    entity.set("c4", (Object)x.getC4Dy());
                }
                if (x.getC5Dy() != null && x.getC5Dy().getLong(ID) != 0L) {
                    entity.set("c5", (Object)x.getC5Dy());
                }
                if (x.getC6Dy() == null || x.getC6Dy().getLong(ID) == 0L) continue;
                entity.set("c6", (Object)x.getC6Dy());
            }
            this.getView().updateView(ENTRYENTITY);
        }
    }

    private Set<String> fetchMemberNumbersByRange(String dimComponentKey, String rangeItemsSerialStr) {
        if (StringUtils.isEmpty((String)rangeItemsSerialStr)) {
            return Collections.emptySet();
        }
        List memberSelectItems = SerializationUtils.fromJsonStringToList((String)rangeItemsSerialStr, Map.class);
        long modelId = ((DynamicObject)this.getModel().getValue(MODEL)).getLong(ID);
        String dimEntity = this.getPageCache().get(CACHE_PREFIX_F7KEY_TO_Entity_NUMBER_MAP + dimComponentKey);
        return memberSelectItems.stream().flatMap(item -> {
            HashSet numbers = new HashSet(8);
            RangeEnum range = RangeEnum.getRangeByVal((int)Integer.parseInt((String)item.get("scope")));
            new MembRangeItem(dimEntity, Long.valueOf(item.get(ID).toString()), item.get(NUMBER).toString(), range, false, (Object)modelId).matchItems(e -> numbers.add(e.number));
            return numbers.stream();
        }).collect(Collectors.toSet());
    }

    @Override
    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType newMainType;
        MainEntityType oldMainType = e.getOriginalEntityType();
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("CheckItemParamSetFormPlugin", exp.getMessage()), new Object[0]);
        }
        this.registDynamicProps(newMainType);
        e.setNewEntityType(newMainType);
    }

    private void registDynamicProps(MainEntityType newMainType) {
        String[] fields;
        String f7MapFields = this.getPageCache().get(F7MAPFIELDSCACHEKEY);
        if (StringUtils.isEmpty((String)f7MapFields)) {
            return;
        }
        for (String key : fields = f7MapFields.split(";")) {
            TextProp fieldprop = new TextProp();
            fieldprop.setName(key);
            fieldprop.setDbIgnore(false);
            newMainType.registerSimpleProperty((DynamicSimpleProperty)fieldprop);
        }
    }

    @Override
    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String ctrlKey = e.getKey();
        if (ctrlKey.startsWith(F7KEYPREFIX)) {
            TextEdit edit = new TextEdit();
            edit.setKey(ctrlKey);
            edit.setModel(this.getModel());
            edit.setView(this.getView());
            edit.setDraggable(true);
            edit.setDroppable(true);
            edit.addClickListener((ClickListener)this);
            e.setControl((Control)edit);
        }
        this.getPageCache().put("KEY_MODEL_ID", String.valueOf(this.getModelId()));
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (key.startsWith(F7KEYPREFIX)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            if (!key.contains("bcm_icmembertree")) {
                formShowParameter.setFormId("bcm_multiplememberf7__inh");
            } else {
                formShowParameter.setFormId("bcm_mulmemberf7_tem_ic");
            }
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            HashMap<String, String> params = new HashMap<String, String>(16);
            int paramValue = Integer.parseInt(key.substring(key.lastIndexOf(95) + 1));
            params.put("dimension", paramValue + "");
            params.put("sign", key);
            formShowParameter.setCustomParams(params);
            if (key.contains(KEY_ICMEMBERTREE_INTERNALCOMPANY)) {
                StyleCss inlineStyleCss = new StyleCss();
                inlineStyleCss.setHeight("730");
                inlineStyleCss.setWidth("1380");
                formShowParameter.getOpenStyle().setInlineStyleCss(inlineStyleCss);
            }
            IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
            String modelId = pageCache.get("KEY_MODEL_ID");
            formShowParameter.setShowClose(false);
            formShowParameter.setCaption(String.format(ResManager.loadKDString((String)"%s - \u6210\u5458\u9009\u62e9", (String)"BcmAuditLogListPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), QueryDimensionServiceHelper.getDimByDseq((int)paramValue, (String)modelId).getString(NAME)));
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
            formShowParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(formShowParameter);
        }
    }

    public static Map<String, String> getDimensionShortNumber2NumberMap(String modelNum) {
        return (Map)GlobalCacheServiceHelper.getOrLoadFromCommonCache((String)("dim-number-short-" + modelNum), () -> {
            HashMap<String, String> cacheMap = new HashMap<String, String>(16);
            DynamicObjectCollection data = QueryServiceHelper.query((String)"bcm_dimension", (String)"number,shortnumber", (QFilter[])new QFilter("model.number", "=", (Object)modelNum).toArray());
            for (DynamicObject datum : data) {
                cacheMap.put(datum.getString("shortnumber"), datum.getString(NUMBER));
            }
            return Collections.unmodifiableMap(cacheMap);
        });
    }

    @Override
    public boolean isExistChangeTypeDimension() {
        DynamicObject model = (DynamicObject)this.getValue(MODEL);
        return BcmAuditLogListPlugin.getDimensionShortNumber2NumberMap(MemberReader.findModelNumberById((Object)model.getLong(ID))).containsValue(PresetConstant.CHANGETYPE_DIM);
    }

    @Override
    public boolean isExistAuditTrailDimension() {
        DynamicObject model = (DynamicObject)this.getValue(MODEL);
        return BcmAuditLogListPlugin.getDimensionShortNumber2NumberMap(MemberReader.findModelNumberById((Object)model.getLong(ID))).containsValue(PresetConstant.AUDITTRIAL_DIM);
    }

    public void closedCallBack(ClosedCallBackEvent cbe) {
        super.closedCallBack(cbe);
        String actionId = cbe.getActionId();
        String s = this.getPageCache().get(F7MAPFIELDSCACHEKEY);
        List<String> strList = Arrays.asList(s.split(";"));
        if (strList.contains(actionId)) {
            Object returnData = cbe.getReturnData();
            if (ObjectUtils.isEmpty((Object)returnData)) {
                this.getModel().setValue(actionId, null);
                this.getPageCache().remove(actionId);
            } else {
                DynamicObjectCollection collection = (DynamicObjectCollection)returnData;
                int size = collection.size();
                StringBuilder str = new StringBuilder();
                ArrayList list = new ArrayList(size);
                for (DynamicObject dyn : collection) {
                    HashMap<String, String> map = new HashMap<String, String>(16);
                    map.put(ID, dyn.get(4).toString());
                    map.put("scope", dyn.get(5).toString());
                    map.put(NUMBER, dyn.get(2).toString());
                    map.put(NAME, dyn.get(3).toString());
                    map.put("pid", dyn.get(6).toString());
                    this.buildPageViewShowName(str, dyn.get(3).toString(), dyn.getInt(5));
                    list.add(map);
                }
                this.getModel().setValue(actionId, (Object)str.substring(0, str.length() - 1));
                this.getPageCache().put(actionId, SerializationUtils.toJsonString(list));
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String controlName = e.getProperty().getName();
        if (MODEL.equals(controlName)) {
            this.createBatchDimensionComponents();
            DynamicObject model = (DynamicObject)this.getValue(MODEL);
            if (Objects.nonNull(model) && model.getLong(ID) != 0L) {
                this.hideATAndCT(this.getView(), "bcm_audittrialmembertree", this.isExistAuditTrailDimension());
                this.hideATAndCT(this.getView(), "bcm_changetypemembertree", this.isExistChangeTypeDimension());
            }
        } else if (controlName.startsWith(F7KEYPREFIX)) {
            String selectedItemStr = this.getPageCache().get(controlName);
            String dimTextNewValue = (String)this.getModel().getValue(controlName);
            if (StringUtils.isEmpty((String)dimTextNewValue) && StringUtils.isNotEmpty((String)selectedItemStr)) {
                this.getPageCache().remove(controlName);
            }
        }
    }

    private void createBatchDimensionComponents() {
        DynamicObject value = (DynamicObject)this.getModel().getValue(MODEL);
        if (value == null) {
            return;
        }
        this.saveUserSelectWhenOtherChange(new UserSelectModel());
        String modelId = value.getString(ID);
        String selectFields = "id,name,number,shortnumber,membermodel,issysdimension,dseq";
        QFilter fmodelId = new QFilter(MODEL, "=", (Object)ConvertUtil.convertStrToLong((String)modelId));
        QFilter[] filters = new QFilter[]{fmodelId};
        String orderBys = "dseq";
        DynamicObjectCollection dimension = QueryServiceHelper.query((String)"bcm_dimension", (String)selectFields, (QFilter[])filters, (String)orderBys);
        FieldsetPanelAp fieldsetpanelap = new FieldsetPanelAp();
        fieldsetpanelap.setKey(SEL_MEMBER_AP);
        fieldsetpanelap.setGrow(0);
        fieldsetpanelap.setName(new LocaleString(ResManager.loadKDString((String)"\u901a\u7528\u7ef4\u5ea6", (String)"BcmAuditLogListPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
        this.addF7Items((ContainerAp<Container>)fieldsetpanelap, dimension);
        this.getView().updateControlMetadata(SEL_MEMBER_AP, fieldsetpanelap.createControl());
        StringBuilder sb = new StringBuilder();
        for (ControlAp ap : fieldsetpanelap.getItems()) {
            if (!ap.getKey().startsWith(F7KEYPREFIX)) continue;
            if (sb.length() > 0) {
                sb.append(";");
            }
            sb.append(ap.getKey());
        }
        this.hideRow();
        int index = 0;
        for (DynamicObject obj : dimension) {
            String membermodel = obj.getString(MEMBERMODEL);
            if (!membermodel.equals("bcm_userdefinedmembertree") && !membermodel.equals("bcm_datasortmembertree")) continue;
            String name = obj.getString(NAME);
            String number = obj.getString(NUMBER);
            if (DATASORT.equalsIgnoreCase(number)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{number});
                continue;
            }
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
            String cnProp = hide_list.get(index);
            this.getView().setVisible(Boolean.TRUE, new String[]{cnProp});
            this.getModel().getProperty(cnProp).getDisplayName().setLocaleValue(name);
            entryGrid.setColumnProperty(cnProp, "header", (Object)new LocaleString(name));
            ++index;
        }
        this.getPageCache().put(F7MAPFIELDSCACHEKEY, sb.toString());
        this.getView().updateView(SEL_MEMBER_AP);
        this.registDynamicProps(this.getModel().getDataEntityType());
    }

    private void clearEntity() {
        int entryRowCount = this.getModel().getEntryRowCount(ENTRYENTITY);
        if (entryRowCount > 0) {
            this.getModel().deleteEntryData(ENTRYENTITY);
        }
    }

    private void hideRow() {
        hide_list.forEach(rol -> this.getView().setVisible(Boolean.FALSE, new String[]{rol}));
    }

    private void addF7Items(ContainerAp<Container> pageViewPanel, DynamicObjectCollection dimension) {
        for (DynamicObject e : dimension) {
            EntryFieldAp f7Field = new EntryFieldAp();
            f7Field.setName(new LocaleString(e.getString(NAME)));
            String f7key = e.getString(MEMBERMODEL) + '_' + e.getString(NUMBER).toLowerCase(Locale.ENGLISH) + '_' + e.getInt("dseq");
            this.getPageCache().put(CACHE_PREFIX_F7KEY_TO_DIMENSION_NUMBER_MAP + f7key, e.getString(NUMBER));
            this.getPageCache().put(CACHE_PREFIX_F7KEY_TO_Entity_NUMBER_MAP + f7key, e.getString(MEMBERMODEL));
            f7Field.setKey(f7key);
            f7Field.setLabelDirection("v");
            f7Field.setShowTitle(false);
            TextField basedata = new TextField();
            basedata.setId(f7key);
            basedata.setKey(f7key);
            basedata.setEditStyle(1);
            f7Field.setShowTitle(true);
            f7Field.setField((Field)basedata);
            f7Field.setFieldTextAlign("center");
            f7Field.setAlignSelf("center");
            f7Field.setTextAlign("left");
            f7Field.setFontSize(12);
            Style style = new Style();
            Margin margin = new Margin();
            margin.setRight("10px");
            margin.setTop("20px");
            margin.setBottom("10px");
            style.setMargin(margin);
            f7Field.setStyle(style);
            f7Field.setFireUpdEvt(true);
            pageViewPanel.getItems().add(f7Field);
            this.addClickListeners(f7key);
        }
    }

    protected void saveUserSelectWhenOtherChange(UserSelectModel userSelectModel) {
        String modelId = UserSelectUtil.getF7SelectId(this.getView(), MODEL);
        if (modelId == null) {
            return;
        }
        ApplicationTypeEnum application = ModelUtil.queryApp(this.getView());
        userSelectModel.setModel(modelId);
        userSelectModel.setModifier(RequestContext.get().getUserId());
        userSelectModel.setApplication(application);
        userSelectModel.setOnlyModel(true);
        UserSelectServiceHelper.saveUserSelect((UserSelectModel)userSelectModel);
        UserSelectUtil.savetUserSelect(userSelectModel);
    }

    private void buildPageViewShowName(StringBuilder str, String name, int val) {
        if (RangeEnum.getRangeByVal((int)val) == RangeEnum.VALUE_10) {
            str.append(name).append(',');
        } else {
            str.append(name).append(ResManager.loadKDString((String)"\u7684", (String)"BcmAuditLogListPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(RangeEnum.getRangeByVal((int)val).getName()).append(',');
        }
    }
}

