/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.logmanage;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.common.OlapEnhancementHelper;
import kd.fi.bcm.common.auditlog.ESConnectHelper;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.util.UserSelectUtil;

public class BcmLogManageFormPlugin
extends AbstractBaseFormPlugin {
    private static final String MODEL = "model";
    private static final String all = "all";
    private static final Map<String, String> transactionTypeFieldList = new HashMap<String, String>();

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners("toolbarap");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"isopenauditlog"});
        String modelId = UserSelectUtil.getModelIdAfterCreateNewData(this.getView(), MODEL);
        Set modelIds = MemberPermHelper.getLimitedModelListByUser();
        if (StringUtils.isNotEmpty((CharSequence)modelId) && !modelIds.contains(Long.parseLong(modelId))) {
            modelId = null;
        }
        this.getModel().setValue(MODEL, (Object)(StringUtils.isEmpty((CharSequence)modelId) ? null : Long.valueOf(modelId)));
        this.changeModel();
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "save": {
                this.save();
                break;
            }
            case "reset": {
                this.reset();
                break;
            }
            case "close": {
                this.getView().close();
                break;
            }
        }
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (this.getModel().getDataChanged()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4fee\u6539\uff0c\u9000\u51fa\u4f1a\u4e22\u5931\u4fee\u6539\u7684\u5185\u5bb9\uff0c\u662f\u5426\u786e\u8ba4\u9000\u51fa\uff1f", (String)"BcmLogManageFormPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("close_Confirm", (IFormPlugin)this));
            e.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent mcEvt) {
        super.confirmCallBack(mcEvt);
        String callBackId = mcEvt.getCallBackId();
        if (StringUtils.equals((CharSequence)callBackId, (CharSequence)"close_Confirm") && MessageBoxResult.Yes.equals((Object)mcEvt.getResult())) {
            this.getModel().setDataChanged(false);
            this.getView().close();
        }
    }

    private void changeModel() {
        DynamicObject modelDy = (DynamicObject)this.getModel().getValue(MODEL);
        if (modelDy == null) {
            this.reset();
            return;
        }
        UserSelectUtil.saveUserSelectWhenModelChange(this.getView(), modelDy.getString("id"));
        Map<String, Boolean> logSetMap = this.buildFormData(modelDy);
        if (logSetMap.size() == 0) {
            this.reset();
        }
        for (Map.Entry<String, Boolean> entry : logSetMap.entrySet()) {
            this.getModel().setValue(entry.getKey(), (Object)entry.getValue());
        }
        this.markAll();
    }

    private void markAll() {
        int cnt = 0;
        IDataModel model = this.getModel();
        for (String transactionType : transactionTypeFieldList.keySet()) {
            if (!Boolean.parseBoolean(String.valueOf(model.getValue(transactionType)))) continue;
            ++cnt;
        }
        model.beginInit();
        model.setValue(all, (Object)false);
        if (cnt == transactionTypeFieldList.size()) {
            model.setValue(all, (Object)true);
        }
        model.endInit();
        this.getView().updateView(all);
    }

    private Map<String, Boolean> buildFormData(DynamicObject modelDy) {
        Long modelId = modelDy.getLong("id");
        DynamicObject logSetting = BusinessDataServiceHelper.loadSingle((String)"bcm_logsetting", (String)"isopenauditlog,transactionlogsetting.number,transactionlogsetting.isenable", (QFilter[])new QFilter(MODEL, "=", (Object)modelId).toArray());
        HashMap<String, Boolean> logSetMap = new HashMap<String, Boolean>();
        if (logSetting == null) {
            return logSetMap;
        }
        logSetMap.put("isopenauditlog", logSetting.getBoolean("isopenauditlog"));
        DynamicObjectCollection transactionLogSet = logSetting.getDynamicObjectCollection("transactionlogsetting");
        transactionLogSet.forEach(x -> {
            if (x != null && transactionTypeFieldList.containsKey(x.getString("number"))) {
                logSetMap.put(x.getString("number"), x.getBoolean("isenable"));
            }
        });
        return logSetMap;
    }

    private void reset() {
        IDataModel model = this.getModel();
        DynamicObject modelDy = (DynamicObject)model.getValue(MODEL);
        if (modelDy == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u4f53\u7cfb\u540e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"BcmLogManageFormPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        model.beginInit();
        model.setValue("isopenauditlog", (Object)false);
        for (String transactionType : transactionTypeFieldList.keySet()) {
            this.getModel().setValue(transactionType, (Object)false);
        }
        model.setValue(all, (Object)false);
        model.endInit();
        this.getView().updateView();
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        IDataModel model = this.getModel();
        switch (key) {
            case "all": {
                model.beginInit();
                Boolean flag = Boolean.valueOf(String.valueOf(e.getChangeSet()[0].getNewValue()));
                for (String transactionType : transactionTypeFieldList.keySet()) {
                    this.getModel().setValue(transactionType, (Object)flag);
                    this.getView().updateView(transactionType);
                }
                model.endInit();
                break;
            }
            case "model": {
                this.changeModel();
                break;
            }
            default: {
                this.markAll();
            }
        }
    }

    private void save() {
        IDataModel model = this.getModel();
        DynamicObject modelDy = (DynamicObject)model.getValue(MODEL);
        if (modelDy == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u4f53\u7cfb\u540e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"BcmLogManageFormPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean hasOpen = false;
        Boolean isOpenAuditlog = Boolean.valueOf(String.valueOf(model.getValue("isopenauditlog")));
        Long modelId = modelDy.getLong("id");
        DynamicObject logSettingDy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_logsetting");
        logSettingDy.set(MODEL, (Object)modelId);
        logSettingDy.set("isopenauditlog", (Object)isOpenAuditlog);
        hasOpen = hasOpen || isOpenAuditlog != false;
        DynamicObjectCollection transactionLogManageEntry = logSettingDy.getDynamicObjectCollection("transactionlogsetting");
        for (Map.Entry<String, String> transactionType : transactionTypeFieldList.entrySet()) {
            DynamicObject cur2 = transactionLogManageEntry.addNew();
            cur2.set("number", (Object)transactionType.getKey());
            cur2.set("type", (Object)transactionType.getValue());
            boolean isOpenTranslog = Boolean.parseBoolean(String.valueOf(model.getValue(transactionType.getKey())));
            cur2.set("isenable", (Object)isOpenTranslog);
            hasOpen = hasOpen || isOpenTranslog;
        }
        try (TXHandle tx = TX.required();){
            try {
                if (hasOpen && !ESConnectHelper.isConnecting()) {
                    logSettingDy.set("isopenauditlog", (Object)Boolean.FALSE);
                    model.setValue("isopenauditlog", (Object)Boolean.FALSE);
                    transactionLogManageEntry.forEach(cur -> {
                        cur.set("isenable", (Object)Boolean.FALSE);
                        model.setValue(cur.getString("number"), (Object)Boolean.FALSE);
                    });
                }
                DeleteServiceHelper.delete((String)"bcm_logsetting", (QFilter[])new QFilter(MODEL, "=", (Object)modelId).toArray());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{logSettingDy});
                this.getModel().setDataChanged(false);
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
        if (hasOpen && !ESConnectHelper.isConnecting()) {
            String msg = ResManager.loadKDString((String)"\u65e5\u5fd7\u670d\u52a1\u8fde\u63a5\u5f02\u5e38\uff0c\u5df2\u81ea\u52a8\u5173\u95ed\u5ba1\u8ba1\u65e5\u5fd7\u548c\u5173\u952e\u4e8b\u52a1\u65e5\u5fd7\u3002", (String)"BcmLogManageFormPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            return;
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"TaskConfigPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        GlobalCacheServiceHelper.getCommonCache().invalidateByKeys(new String[]{"bcm_logsetting-OpLogHelper"});
        OlapEnhancementHelper.updateCubeEnableAudit((String)modelDy.getString("number"), (Boolean)isOpenAuditlog);
        this.writeOplog(modelDy.getString("shownumber"));
    }

    private void writeOplog(String modelShowNumber) {
        OpNameMultiLangEnumBridge opName = OpNameMultiLangEnumBridge.genOpNameBridge((MultiLangEnumBridge)OpItemEnum.SAVE.getMultiLangEnumBridge(), (String)"save");
        this.writeSuccessLog(opName, modelShowNumber + " " + ResManager.loadKDString((String)"\u65e5\u5fd7\u8bbe\u7f6e", (String)"BcmLogManageFormPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    static {
        for (TransactionTypeEnum transactionType : TransactionTypeEnum.values()) {
            transactionTypeFieldList.put(transactionType.number, transactionType.type);
        }
    }

    public static enum TransactionTypeEnum {
        DIMENSIONCREATEORIMPORT(new MultiLangEnumBridge("\u7ef4\u5ea6\u521b\u5efa/\u5bfc\u5165", "BcmLogManageFormPlugin_0", "fi-bcm-formplugin"), "1", "dimensioncreate"),
        MERGE(new MultiLangEnumBridge("\u667a\u80fd\u5408\u5e76", "BcmLogManageFormPlugin_1", "fi-bcm-formplugin"), "2", "merge"),
        REPORTEDIT(new MultiLangEnumBridge("\u62a5\u8868\u7f16\u5236", "BcmLogManageFormPlugin_2", "fi-bcm-formplugin"), "3", "reportedit"),
        ADJUSTENTRY(new MultiLangEnumBridge("\u8c03\u6574\u62b5\u6d88\u5206\u5f55", "BcmLogManageFormPlugin_3", "fi-bcm-formplugin"), "4", "adjustentry"),
        COLLECT(new MultiLangEnumBridge("\u4e1a\u52a1\u96c6\u6210", "BcmLogManageFormPlugin_4", "fi-bcm-formplugin"), "5", "collect"),
        EXECUTERULE(new MultiLangEnumBridge("\u6267\u884c\u89c4\u5219", "BcmLogManageFormPlugin_5", "fi-bcm-formplugin"), "6", "executerule");

        MultiLangEnumBridge bridge;
        String type;
        String number;

        private TransactionTypeEnum(MultiLangEnumBridge bridge, String type, String number) {
            this.bridge = bridge;
            this.type = type;
            this.number = number;
        }
    }
}

