/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.logmanage;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.fi.bcm.business.log.TransactionLogESHelper;
import kd.fi.bcm.common.Page;
import kd.fi.bcm.common.auditlog.TransactionLogBill;
import kd.fi.bcm.common.oplog.OpLogs;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;

public class BcmOpLogListPlugin
extends AbstractBaseListPlugin {
    private static final String MODEL = "model";
    private static final String TOOLBARAP = "toolbarap";
    private static final String BARITEMSHOWLOG = "baritemshowlog";
    private static final String BARITEMREFRESH = "baritemrefresh";
    private static final String BARITEMRESET = "baritemreset";
    private static final String BARITEMDOWNLOAD = "baritemdownload";
    private static final String ENTRYENTITY = "entryentity";
    private static final int DEFAULT_PAGE = 1;
    private static final int DEFAULT_PAGESIZE = 10000;
    private static final String START_DATETIME = "startdatetime";
    private static final String END_DATETIME = "enddatetime";
    private static final String TRANSACTION = "opcategories";
    private static final String USER = "user";
    private static final String F7KEYPREFIX = "bcm_";

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(TOOLBARAP);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setDefaultValue();
        this.refreshBillByUserSelect(new ArrayList<String>(), false);
        this.getView().setEnable(Boolean.FALSE, new String[]{ENTRYENTITY});
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    private void setDefaultValue() {
        LocalDate now = LocalDate.now();
        ZonedDateTime zonedDateTime = now.atStartOfDay().atZone(ZoneId.systemDefault());
        Date startTime = Date.from(zonedDateTime.toInstant());
        this.getModel().setValue(START_DATETIME, (Object)startTime);
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        Optional<String> validateMsg;
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ((BARITEMSHOWLOG.equals(itemKey) || BARITEMREFRESH.equals(itemKey)) && (validateMsg = this.validate()).isPresent()) {
            this.getView().showTipNotification(validateMsg.get());
            return;
        }
        switch (itemKey) {
            case "baritemshowlog": 
            case "baritemrefresh": {
                this.loadEntityData();
                break;
            }
            case "baritemreset": {
                MainEntityType dataEntityType = this.getModel().getDataEntityType();
                Map allEntities = dataEntityType.getAllEntities();
                EntityType bcmAuditLogFields = (EntityType)allEntities.get("bcm_transaction_log");
                Map fieldsMap = bcmAuditLogFields.getFields();
                fieldsMap.forEach((key, v) -> {
                    if (MODEL.equals(key)) {
                        return;
                    }
                    this.getModel().setValue(key, (Object)"");
                    if (key.startsWith(F7KEYPREFIX)) {
                        this.getPageCache().remove(key);
                    }
                });
                this.setDefaultValue();
                this.getView().updateView();
                break;
            }
            case "baritemdownload": {
                break;
            }
        }
    }

    private Optional<String> validate() {
        IDataModel model = this.getModel();
        DynamicObject modelValue = (DynamicObject)model.getValue(MODEL);
        if (Objects.isNull(modelValue)) {
            return Optional.of(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"BcmAuditLogListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        Date startTime = (Date)model.getValue(START_DATETIME);
        if (Objects.isNull(startTime)) {
            return Optional.of(ResManager.loadKDString((String)"\u8bf7\u6307\u5b9a\u5f00\u59cb\u65f6\u95f4\u3002", (String)"BcmAuditLogListPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        Date endTime = (Date)model.getValue(END_DATETIME);
        if (Objects.nonNull(endTime) && startTime.getTime() > endTime.getTime()) {
            return Optional.of(ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4\u3002", (String)"BcmAuditLogListPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        return Optional.empty();
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent cbe) {
        super.closedCallBack(cbe);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
    }

    private void clearEntity() {
        int entryRowCount = this.getModel().getEntryRowCount(ENTRYENTITY);
        if (entryRowCount > 0) {
            this.getModel().deleteEntryData(ENTRYENTITY);
        }
    }

    private void loadEntityData() {
        Page pageBill;
        Date endTime;
        this.clearEntity();
        IDataModel model = this.getModel();
        DynamicObject modelValue = (DynamicObject)model.getValue(MODEL);
        Date startTime = (Date)model.getValue(START_DATETIME);
        Date date = endTime = Objects.isNull(model.getValue(END_DATETIME)) ? new Date() : (Date)model.getValue(END_DATETIME);
        if (startTime.getTime() > new Date().getTime()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u5f53\u524d\u65f6\u95f4\u3002", (String)"BcmAuditLogListPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        TransactionLogESHelper.TransactionLogQueryParam.Builder builder = new TransactionLogESHelper.TransactionLogQueryParam.Builder(modelValue.getLong("id"), startTime, endTime);
        if (Objects.nonNull(model.getValue(TRANSACTION)) && !"".equals(model.getValue(TRANSACTION))) {
            builder.setTransactionType(model.getValue(TRANSACTION).toString());
        }
        if (Objects.nonNull(model.getValue(USER))) {
            builder.setUserId(Long.valueOf(((DynamicObject)model.getValue(USER)).getLong("id")));
        }
        if ((pageBill = TransactionLogESHelper.search((long)modelValue.getLong("id"), (TransactionLogESHelper.TransactionLogQueryParam)builder.build(), (Integer)1, (Integer)10000)).getTotal() == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u6570\u636e\uff0c\u8bf7\u5728\u65e5\u5fd7\u8bbe\u7f6e\u4e2d\u5f00\u542f\u5173\u952e\u4e8b\u52a1\u65e5\u5fd7\u9879\u3002", (String)"BcmAuditLogListPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        Label title = (Label)this.getControl("listtips");
        if (pageBill.getTotal() > pageBill.getSize()) {
            title.setText(String.format(ResManager.loadKDString((String)"\u5171%1$s\u6761\uff0c\u5217\u51fa%2$s\u6761\u3002", (String)"BcmOpLogListPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), pageBill.getTotal(), pageBill.getSize()));
        } else {
            title.setText(String.format(ResManager.loadKDString((String)"\u5171%1$s\u6761", (String)"BcmOpLogListPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), pageBill.getTotal()));
        }
        model.deleteEntryData(ENTRYENTITY);
        model.getDataEntity(true);
        if (!pageBill.getRecords().isEmpty()) {
            model.beginInit();
            model.batchCreateNewEntryRow(ENTRYENTITY, pageBill.getRecords().size());
            model.endInit();
            DynamicObjectCollection entryRows = model.getEntryEntity(ENTRYENTITY);
            for (int i = 0; i < entryRows.size(); ++i) {
                DynamicObject entity = (DynamicObject)entryRows.get(i);
                TransactionLogBill x = (TransactionLogBill)pageBill.getRecords().get(i);
                entity.set("opuser", (Object)x.getUser());
                entity.set("ipfield", (Object)x.getIp());
                entity.set("op", (Object)OpLogs.OpCategory.getTextByCode((int)x.getOperateType()));
                entity.set("subsourcekey", (Object)x.getOperate());
                entity.set("status", (Object)OpLogs.OpStatus.getTextByName((String)x.getStatus()));
                entity.set("opstarttime", (Object)x.getOperateBeginTime());
                entity.set("opendtime", (Object)x.getOperateEndTime());
                entity.set("costtime", (Object)x.getCosttime());
            }
            this.getView().updateView(ENTRYENTITY);
        }
    }
}

