/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.logmanage;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.log.AuditLogESHelper;
import kd.fi.bcm.business.page.model.TextEditElement;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.common.Page;
import kd.fi.bcm.common.auditlog.AuditLogBill;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.pageinteraction.DynamicPage;

public class BcmRowHistoryDataLogPlugin
extends AbstractBaseFormPlugin
implements DynamicPage {
    private static Long MODELID = 0L;
    private static JSONArray array;
    private static JSONArray rowAndCellArr;
    private static final String FIELD_SET_PANEL = "fieldsetpanelap";
    private static final String TEXTMAPFIELDSCACHEKEY = "textMapFields";
    private static final String SHORTCUT_SELECT = "shortcut_select";
    private static final String AUDITTRAIL = "AuditTrail";
    private static final HashMap<String, String> DIMENSION_ENTRY_MAP;
    private static final String TOOLBAR = "toolbarap";
    private static final String REFRESH_BAR = "refreshbar";
    private static final int DEFAULT_PAGE = 1;
    private static final int DEFAULT_PAGESIZE = 10000;
    private static final String ENTRYENTITY = "entryentity";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(TOOLBAR);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        MODELID = (Long)this.getView().getFormShowParameter().getCustomParam("modelid");
        array = (JSONArray)this.getView().getFormShowParameter().getCustomParam("dimensionsList");
        rowAndCellArr = (JSONArray)this.getView().getFormShowParameter().getCustomParam("rowAndCellList");
        if (MODELID == 0L) {
            return;
        }
        this.initNewStylePageViewPanel(MODELID);
        this.bindCtrlMapping();
        this.getView().setEnable(Boolean.FALSE, new String[]{ENTRYENTITY});
        JSONObject jsonObject = this.ruleCustomParamData();
        this.setDefaultValue(jsonObject);
        try {
            this.loadEntryData(jsonObject, MODELID);
        }
        catch (Exception ex) {
            this.getView().showErrorNotification(ex.getMessage());
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (REFRESH_BAR.equals(itemKey)) {
            try {
                this.loadEntryData(this.ruleCustomParamData(), MODELID);
            }
            catch (Exception ex) {
                this.getView().showErrorNotification(ex.getMessage());
            }
            this.getView().updateView(ENTRYENTITY);
        }
    }

    private void loadEntryData(JSONObject jsonObject, Long modelId) {
        String selectFields = "createtime";
        QFilter fmodelid = new QFilter("model", "=", (Object)modelId);
        QFilter[] filters = new QFilter[]{fmodelid};
        DynamicObject queryOne = (DynamicObject)QueryServiceHelper.query((String)"bcm_dimension", (String)selectFields, (QFilter[])filters, (String)"createtime", (int)1).get(0);
        Timestamp timestamp = (Timestamp)queryOne.get(selectFields);
        Date startTime = new Date();
        startTime.setTime(timestamp.getTime());
        Date endTime = new Date();
        AuditLogESHelper.AuditLogQueryParam.Builder builder = new AuditLogESHelper.AuditLogQueryParam.Builder(modelId.longValue(), startTime, endTime);
        DIMENSION_ENTRY_MAP.forEach((dimenNumber, value) -> {
            boolean bol;
            JSONObject json = jsonObject.getJSONObject(dimenNumber);
            if (json == null) {
                return;
            }
            String number = json.getString("number");
            if (number == null) {
                return;
            }
            HashSet<String> numberSet = new HashSet<String>(16);
            Object map = this.getView().getFormShowParameter().getCustomParam("initMap");
            JSONObject jsonObj = (JSONObject)map;
            String selectValue = jsonObj.getString(SHORTCUT_SELECT);
            boolean bl = bol = StringUtils.isEmpty((String)selectValue) && AUDITTRAIL.equals(value);
            if (bol) {
                QFilter qFilter = new QFilter("model", "=", (Object)MODELID);
                qFilter.and(new QFilter("number", "=", (Object)number));
                DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)dimenNumber, (String)"id,number,name", (QFilter[])qFilter.toArray());
                ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>();
                HashMap<String, String> map1 = new HashMap<String, String>();
                map1.put("number", number);
                map1.put("id", dynamicObject.getString("id"));
                map1.put("scope", "40");
                maps.add(map1);
                numberSet.addAll(this.fetchMemberNumbersByRange((String)dimenNumber, (List<Map<String, Object>>)maps));
            } else {
                numberSet.add(number);
            }
            switch (value) {
                case "Entity": {
                    builder.setEntityDims(numberSet);
                    break;
                }
                case "Account": {
                    builder.setAccountDims(numberSet);
                    break;
                }
                case "Year": {
                    builder.setYearDims(numberSet);
                    break;
                }
                case "Period": {
                    builder.setPeriodDims(numberSet);
                    break;
                }
                case "Scenario": {
                    builder.setScenarioDims(numberSet);
                    break;
                }
                case "Process": {
                    builder.setProcessDims(numberSet);
                    break;
                }
                case "Currency": {
                    builder.setCurrencyDims(numberSet);
                    break;
                }
                case "AuditTrail": {
                    builder.setAuditTrailDims(numberSet);
                    break;
                }
                case "ChangeType": {
                    builder.setChangeTypeDims(numberSet);
                    break;
                }
                case "InternalCompany": {
                    builder.setInternalCompanyDims(numberSet);
                    break;
                }
                default: {
                    builder.addCustomDims(value, numberSet);
                }
            }
        });
        Page pageBill = AuditLogESHelper.search((long)modelId, (AuditLogESHelper.AuditLogQueryParam)builder.build(), (Integer)1, (Integer)10000);
        List records = pageBill.getRecords();
        if (records.size() == 0) {
            return;
        }
        IDataModel model = this.getModel();
        int entryRowCount = model.getEntryRowCount(ENTRYENTITY);
        if (entryRowCount > 0) {
            model.deleteEntryData(ENTRYENTITY);
            model.getDataEntity(true);
        }
        model.beginInit();
        model.batchCreateNewEntryRow(ENTRYENTITY, records.size());
        model.endInit();
        DynamicObjectCollection entryRows = model.getEntryEntity(ENTRYENTITY);
        for (int i = 0; i < entryRows.size(); ++i) {
            DynamicObject entity = (DynamicObject)entryRows.get(i);
            AuditLogBill x = (AuditLogBill)pageBill.getRecords().get(i);
            entity.set("userfield", (Object)x.getUserDy());
            entity.set("ipfield", (Object)x.getIp());
            entity.set("datetimefield", (Object)x.getOperateTime());
            entity.set("amountfield", (Object)x.getNewValue());
            entity.set("transaction", (Object)x.getTransactionType());
        }
        this.getView().updateView(ENTRYENTITY);
    }

    private void setDefaultValue(JSONObject initMap) {
        array.forEach(key -> {
            String name = initMap.getJSONObject(key.toString()).getString("name");
            this.getModel().setValue(key.toString(), (Object)name);
        });
        rowAndCellArr.forEach(key -> {
            String name = initMap.getJSONObject(key.toString()).getString("name");
            this.getModel().setValue(key.toString(), (Object)name);
        });
        Object map = this.getView().getFormShowParameter().getCustomParam("initMap");
        JSONObject jsonObject = (JSONObject)map;
        String shortcutJson = jsonObject.getString(SHORTCUT_SELECT);
        if (shortcutJson != null) {
            this.getModel().setValue(SHORTCUT_SELECT, (Object)shortcutJson);
        }
    }

    private Set<String> fetchMemberNumbersByRange(String dimEntity, List<Map<String, Object>> maps) {
        return maps.stream().flatMap(item -> {
            HashSet numbers = new HashSet(8);
            RangeEnum range = RangeEnum.getRangeByVal((int)Integer.parseInt((String)item.get("scope")));
            new MembRangeItem(dimEntity, Long.valueOf(item.get("id").toString()), item.get("number").toString(), range, false, (Object)MODELID).matchItems(e -> numbers.add(e.number));
            return numbers.stream();
        }).collect(Collectors.toSet());
    }

    private void initNewStylePageViewPanel(Long modelId) {
        FlexPanelAp fieldsetpanelap = new FlexPanelAp();
        fieldsetpanelap.setKey(FIELD_SET_PANEL);
        fieldsetpanelap.setGrow(0);
        fieldsetpanelap.setName(new LocaleString(ResManager.loadKDString((String)"\u89c6\u70b9\u9875\u9762\u7ef4", (String)"BcmRowHistoryDataLogPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
        fieldsetpanelap.setOverflow("visible");
        DynamicObjectCollection dynamicObjects = BcmRowHistoryDataLogPlugin.getIntiDimension(modelId);
        this.addF7Items(fieldsetpanelap, dynamicObjects, array);
        this.addF7Items(fieldsetpanelap, dynamicObjects, rowAndCellArr);
        this.getView().updateControlMetadata(FIELD_SET_PANEL, fieldsetpanelap.createControl());
        StringBuilder sb = new StringBuilder();
        for (ControlAp ap : fieldsetpanelap.getItems()) {
            if (!this.checkControlKeyPrefix(this.getView(), ap.getKey())) continue;
            sb.append(ap.getKey()).append(';');
        }
        sb.append(SHORTCUT_SELECT).append(";");
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        this.getPageCache().put(TEXTMAPFIELDSCACHEKEY, sb.toString());
    }

    private static DynamicObjectCollection getIntiDimension(Long modelId) {
        String selectFields = "id,name,number,shortnumber,membermodel,issysdimension,dseq";
        QFilter fmodelid = new QFilter("model", "=", (Object)modelId);
        QFilter[] filters = new QFilter[]{fmodelid};
        return QueryServiceHelper.query((String)"bcm_dimension", (String)selectFields, (QFilter[])filters, (String)"dseq");
    }

    private void addF7Items(FlexPanelAp flexPanelAp, DynamicObjectCollection dimension, JSONArray array) {
        for (DynamicObject e : dimension) {
            String membermodel = e.getString("membermodel");
            String membermodelFieldKdy = this.sugarF7Key(membermodel, e.getString("number"));
            DIMENSION_ENTRY_MAP.put(membermodelFieldKdy, e.getString("number"));
            if (!array.contains((Object)membermodelFieldKdy)) continue;
            EntryFieldAp f7Field = new EntryFieldAp();
            f7Field.setQuickAddNew(false);
            BasedataField basedata = new BasedataField();
            f7Field.setName(new LocaleString(e.getString("name")));
            f7Field.setLabelDirection("h");
            f7Field.setKey(membermodelFieldKdy);
            f7Field.setLock("new,edit,view");
            this.initEntryFieldStyle((FieldAp)f7Field);
            basedata.setKey(membermodelFieldKdy);
            f7Field.setField((Field)basedata);
            flexPanelAp.getItems().add(f7Field);
        }
    }

    private void initEntryFieldStyle(FieldAp f7Field) {
        if (ApplicationTypeEnum.BGM.getAppnum().equals(this.getView().getFormShowParameter().getAppId())) {
            f7Field.setFieldTextAlign("left");
            f7Field.setTextAlign("left");
            f7Field.setAlignSelf("center");
            f7Field.setWidth(new LocaleString("250px"));
            Style style = new Style();
            Margin margin = new Margin();
            margin.setLeft("30px");
            margin.setBottom("22px");
            style.setMargin(margin);
            f7Field.setStyle(style);
        } else {
            f7Field.setFieldTextAlign("left");
            f7Field.setTextAlign("left");
            f7Field.setAlignSelf("center");
            f7Field.setLabelWidth(new LocaleString("60px"));
            f7Field.setWidth(new LocaleString("250px"));
            f7Field.setStyle(this.getDefaultStyle());
        }
    }

    private Style getDefaultStyle() {
        Style style = new Style();
        Margin margin = new Margin();
        margin.setRight("1px");
        margin.setLeft("20px");
        margin.setTop("1px");
        margin.setBottom("10px");
        style.setMargin(margin);
        return style;
    }

    @Override
    public void getEntityType(GetEntityTypeEventArgs e) {
        try {
            e.setNewEntityType((MainEntityType)e.getOriginalEntityType().clone());
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void bindCtrlMapping() {
        String f7MapFields = this.getPageCache().get(TEXTMAPFIELDSCACHEKEY);
        if (StringUtils.isEmpty((String)f7MapFields)) {
            return;
        }
        String[] fields = f7MapFields.split(";");
        MainEntityType mainEntityType = this.getModel().getDataEntityType();
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)mainEntityType.getName(), (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        EntityMetadata entityMeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)formMeta.getEntityId(), (MetaCategory)MetaCategory.Entity);
        DataEntityPropertyCollection props = mainEntityType.getProperties();
        for (String field : fields) {
            if (props.containsKey((Object)field)) continue;
            TextEditElement.addTextFieldToMainEntity((Container)((Container)this.getControl(FIELD_SET_PANEL)), (MainEntityType)mainEntityType, (EntityMetadata)entityMeta, (String)field, (IDataModel)this.getModel(), (IFormView)this.getView(), (boolean)false);
        }
    }

    private JSONObject ruleCustomParamData() {
        Object initMap = this.getView().getFormShowParameter().getCustomParam("initMap");
        if (initMap == null) {
            return new JSONObject();
        }
        JSONObject jsonObject = (JSONObject)initMap;
        return jsonObject.getJSONObject("domainMap");
    }

    static {
        DIMENSION_ENTRY_MAP = new HashMap(16);
    }
}

