/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.logmanage;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.filter.FilterContainer;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.fi.bcm.business.model.UserSelectModel;
import kd.fi.bcm.business.serviceHelper.UserSelectServiceHelper;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.dimension.util.ModelUtil;

public class DimensionModifyLogListPlugin
extends AbstractBaseListPlugin
implements SetFilterListener {
    private static final String BTN_REFRESH = "btn_refresh";
    private static final String BTN_EXPORT = "btn_export";
    private static final String MODEL = "model";

    @Override
    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.addSetFilterListener((SetFilterListener)this);
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        filterContainer.getContext();
        filterContainer.setBillFormId("bcm_dimensionmodifylog");
        filterContainer.setTitle(new LocaleString(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u53d8\u52a8\u65e5\u5fd7", (String)"DimensionModifyLogListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
        filterContainer.addSearchClickListener(this::doRefreshBillList);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList billList = (BillList)this.getView().getControl("billlistap");
        this.addItemClickListeners("toolbarap");
        billList.addCreateListColumnsListener(this::beforeCreateListColumns);
    }

    private void doRefreshBillList(SearchClickEvent evt) {
        FilterParameter filterParameter = evt.getFilterParameter();
        List fastQFilters = evt.getFastQFilters();
        List commonFilters = filterParameter.getQFilters();
        QFilter qFilter = new QFilter(MODEL, "=", (Object)this.getModelId());
        if (fastQFilters != null && fastQFilters.size() > 0) {
            for (QFilter fastFilter : fastQFilters) {
                qFilter.and(fastFilter);
            }
        }
        if (commonFilters != null && commonFilters.size() > 0) {
            for (QFilter commonFilter : commonFilters) {
                qFilter.and(commonFilter);
            }
        }
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.clearSelection();
        billList.setFilter(qFilter);
        billList.refresh();
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        UserSelectModel user = UserSelectServiceHelper.getUserSelect((String)Long.toString(this.getUserId()), (String)"issummury,id,model,model.id,isadjustlisttype,application,entity,year,period,scenario,currency,modifier,modifydate,onlymodel,formid,version,cslscheme,dmmodel", (ApplicationTypeEnum)ApplicationTypeEnum.CM);
        long modelId = LongUtil.toLong((Object)user.getModel());
        if (ModelUtil.getHasPermissionModels(this.getView()).contains(modelId)) {
            this.getModel().setValue(MODEL, (Object)modelId);
        }
        this.refreshBillList();
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String controlName = e.getProperty().getName();
        if (MODEL.equals(controlName)) {
            this.refreshBillList();
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        QFilter modelFilter = new QFilter(MODEL, "=", (Object)this.getModelId());
        e.getQFilters().add(modelFilter);
        e.setOrderBy("createtime desc");
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btn_refresh": {
                this.refreshBillList();
                break;
            }
            case "btn_export": {
                if (this.getModelId() == 0L) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"AbstractBaseListPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                BillList list = (BillList)this.getControl("billlistap");
                List qFilters = list.getFilterParameter().getQFilters();
                if (list.getSelectedRows().size() != 0) {
                    ListSelectedRowCollection rows = list.getSelectedRows();
                    ArrayList ids = Lists.newArrayListWithCapacity((int)rows.size());
                    for (ListSelectedRow row : rows) {
                        ids.add(row.getPrimaryKeyValue());
                    }
                    QFilter id = new QFilter("id", "in", (Object)ids);
                    qFilters.add(id);
                }
                QFilter[] objects = new QFilter[qFilters.size()];
                qFilters.toArray(objects);
                this.exportData("bcm_dimensionmodifylog", objects, ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u53d8\u52a8\u65e5\u5fd7", (String)"DimensionModifyLogListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), "bcm_dimensionmodifylog_li", "47150e89000000ac");
                OpNameMultiLangEnumBridge opName = new OpNameMultiLangEnumBridge("\u5bfc\u51fa", "DataPermLogListPlugin_2", "fi-bcm-formplugin", "export");
                OPDescMultiLangEnumBridge opDes = new OPDescMultiLangEnumBridge("\u5168\u90e8\u5bfc\u51fa\u6210\u529f\u3002", "DataPermLogListPlugin_3", "fi-bcm-formplugin", null);
                this.writeMultiLangLog(opName, opDes);
                break;
            }
        }
    }

    private void refreshBillList() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        FilterParameter filterParameter = new FilterParameter();
        filterParameter.getQFilters().add(new QFilter(MODEL, "=", (Object)this.getModelId()));
        filterParameter.setOrderBy("createtime desc");
        billList.setFilterParameter(filterParameter);
        billList.refresh();
        billList.clearSelection();
        billList.refreshData();
    }
}

