/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.logmanage;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.epbs.business.log.CommonOlapLogListFunction;
import kd.epm.epbs.business.log.IOlapLogListFunction;
import kd.epm.epbs.business.log.audit.AuditLogQueryParam;
import kd.epm.epbs.business.log.trace.TraceOpLogService;
import kd.epm.epbs.business.member.f7.NewF7Utils;
import kd.epm.epbs.common.cache.model.Dimension;
import kd.epm.epbs.common.cache.model.Member;
import kd.epm.epbs.common.enums.MultiLangEnumBridge;
import kd.epm.epbs.common.enums.ShowTypeEnum;
import kd.epm.epbs.common.member.f7.AbstractMemberF7Parameter;
import kd.epm.epbs.formplugin.log.olap.AbstractOlapLogPlugin;
import kd.fi.bcm.business.log.AuditLogESHelper;
import kd.fi.bcm.business.util.TransMemberUtil;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.auditlog.LogESHelper;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.log.OlapOpTargetEnum;
import kd.fi.bcm.common.enums.log.OlapOpTypeEnum;
import kd.fi.bcm.formplugin.dimension.memberf7.BcmMemberF7Parameter;
import kd.fi.bcm.formplugin.logmanage.BcmTraceOpLogService;
import org.apache.commons.collections4.CollectionUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.jetbrains.annotations.NotNull;

public class EpbsOlapLogNewPlugin
extends AbstractOlapLogPlugin {
    private static final Set<String> singleDims = new HashSet<String>(Arrays.asList(DimTypesEnum.ENTITY.getNumber(), DimTypesEnum.PERIOD.getNumber(), DimTypesEnum.YEAR.getNumber(), DimTypesEnum.CURRENCY.getNumber(), DimTypesEnum.SCENARIO.getNumber(), DimTypesEnum.INTERCOMPANY.getNumber()));
    private static final Set<String> SPECIAL_CURRENCY = AuditLogESHelper.SPECIAL_CURRENCY;
    private Map<String, String> entityMap = null;
    private static Map<String, MultiLangEnumBridge> CustomOpTargetMap = new HashMap(){
        {
            this.put("custoc_epm", new MultiLangEnumBridge("EPM\u5ba2\u6237\u7aef", "ExcelActionHelper_1", "fi-bcm-common"));
            this.put("bcm_exchangesysimport-bd_exrate_tree", new MultiLangEnumBridge("\u6c47\u7387\u7ba1\u7406", "ExchangeRateMaintainPlugin_21", "fi-bcm-common"));
        }
    };

    protected Member getMemberByNumber(String dimNumber, String memberNumber) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)memberNumber)) {
            return null;
        }
        IDNumberTreeNode memberByNumber = MemberReader.findMemberByNumber((String)this.getCubeNumber(), (String)dimNumber, (String)memberNumber);
        if (memberByNumber == IDNumberTreeNode.NotFoundTreeNode) {
            return null;
        }
        return new Member(memberByNumber.getId(), memberByNumber.getNumber(), memberByNumber.getName());
    }

    protected void customStyle(EntryFieldAp f7Field) {
        super.customStyle(f7Field);
        if (f7Field.getKey().equals("f7_" + DimTypesEnum.ENTITY.getNumber().toLowerCase(Locale.ENGLISH))) {
            Tips tips = new Tips();
            tips.setContent(new LocaleString(ResManager.loadKDString((String)"\u5f53\u8fc7\u7a0b\u6210\u5458\u4e3aEJE\u3001ADJ\u7b49\u201c\u5728\u5408\u5e76\u8282\u70b9\u5bf9\u5176\u4e0b\u7ea7\u7684\u8c03\u6574\u62b5\u9500\u201d\u7684\u6210\u5458\u65f6\uff0c\u9009\u62e9\u7684\u7ec4\u7ec7\u6210\u5458\u89c6\u540c\u4e3a\u4e0b\u7ea7\u7ec4\u7ec7\u6210\u5458\uff0c\u7237_\u7236_\u5b50\u8de8\u5c42\u7ea7\u7684\u62b5\u9500\uff0c\u201c\u7237\u201d\u5408\u5e76\u8282\u70b9\u62b5\u9500\u201c\u5b50\u201d\uff0c\u5176\u591a\u7ef4\u6570\u636e\u5b58\u5728\u201c\u7237_\u7236\u201d\u7ec4\u7ec7\u6210\u5458\u4e0a\uff0c\u67e5\u8be2\u8be5\u7c7b\u8de8\u5c42\u7ea7EJE\u62b5\u9500\u6570\u636e\uff0c\u5176\u7ec4\u7ec7\u6210\u5458\u9700\u8981\u9009\u62e9\u201c\u7236\u201d", (String)"OlapDataLogDimPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
            tips.setType("text");
            f7Field.setCtlTips(tips);
        }
    }

    protected String getOpTypeDesc(Map<String, String> opTypeMap, String optype, String formId) {
        String desc = super.getOpTypeDesc(opTypeMap, optype, formId);
        if (StringUtils.isEmpty((String)desc) && StringUtils.isNotEmpty((String)formId)) {
            desc = opTypeMap.getOrDefault(LogESHelper.getOperateType((String)formId), opTypeMap.get(OlapOpTypeEnum.BIZ_RULE.getCode()));
        }
        return desc;
    }

    protected TraceOpLogService getTraceOpLogService() {
        return BcmTraceOpLogService.getInstance();
    }

    protected Set<String> getSingleDims() {
        if (this.isAuditLog()) {
            return new HashSet<String>(16);
        }
        return singleDims;
    }

    protected String getEntityNumberWithOlapLogMsg() {
        return "bcm_olap_log_msg";
    }

    protected String getCubeNumber() {
        return MemberReader.findModelNumberById((Object)this.getModelId());
    }

    protected List<Dimension> getDimensionList() {
        Map cachedDimension = MemberReader.getDimDyoByModelId((long)this.getModelId());
        ArrayList<DynamicObject> dimensionList = new ArrayList<DynamicObject>();
        cachedDimension.forEach((k, v) -> dimensionList.add((DynamicObject)v));
        dimensionList.sort(Comparator.comparingInt(dy -> dy.getInt("dseq")));
        return dimensionList.stream().map(this::convertDy2Dimension).collect(Collectors.toList());
    }

    private Dimension convertDy2Dimension(DynamicObject dimensionDy) {
        return new Dimension(Long.valueOf(dimensionDy.getLong("id")), dimensionDy.getString("number"), dimensionDy.getString("name"), dimensionDy.getString("membermodel"), dimensionDy.getBoolean("issysdimension"));
    }

    protected Map<String, Set<String>> getMemberMap() {
        List currencyConGrp;
        boolean processEmptyOrIncludeRelaProcess;
        HashMap<String, Set<String>> memberMap = new HashMap<String, Set<String>>();
        this.getDimMapping().forEach((f7Key, dimNumber) -> {
            Object f7Value = this.getModel().getValue(f7Key);
            List memberNumbersFromCache = f7Value == null || f7Value.toString().length() == 0 ? null : this.getMemberNumbersFromCache((String)f7Key);
            if (memberNumbersFromCache != null) {
                Set<String> includeLeafMemberNumbers = this.searchLeafMembers((String)dimNumber, memberNumbersFromCache);
                memberMap.put((String)dimNumber, (Set<String>)new HashSet<String>(includeLeafMemberNumbers));
            }
        });
        Set processes = memberMap.getOrDefault(DimTypesEnum.PROCESS.getNumber(), Collections.emptySet());
        boolean bl = processEmptyOrIncludeRelaProcess = CollectionUtils.isEmpty(processes) || processes.stream().anyMatch(OrgRelaProcessMembPool::isRelaProcess);
        if (memberMap.get(DimTypesEnum.ENTITY.getNumber()) != null && processEmptyOrIncludeRelaProcess) {
            Set entitys = (Set)memberMap.get(DimTypesEnum.ENTITY.getNumber());
            String modelNumberById = this.getCubeNumber();
            HashSet orgs = new HashSet(16);
            entitys.forEach(e -> {
                IDNumberTreeNode node = MemberReader.findEntityMemberByNum((String)modelNumberById, (String)e);
                orgs.add(node.getNumber());
                orgs.add(node.getParent_SonNumber());
                node.getShareNodes().forEach(s -> orgs.add(s.getParent_SonNumber()));
            });
            memberMap.put(DimTypesEnum.ENTITY.getNumber(), orgs);
        }
        Set bpnums = (Set)memberMap.get(DimTypesEnum.PROCESS.getNumber());
        TransMemberUtil.toNEProcess((Set)bpnums);
        Set currentnums = (Set)memberMap.get(DimTypesEnum.CURRENCY.getNumber());
        Set entitynums = (Set)memberMap.get(DimTypesEnum.ENTITY.getNumber());
        if (CollectionUtils.isNotEmpty((Collection)currentnums) && currentnums.size() == 1 && CollectionUtils.containsAny((Collection)currentnums, SPECIAL_CURRENCY) && CollectionUtils.isNotEmpty((Collection)entitynums) && entitynums.size() == 1 && CollectionUtils.isNotEmpty((Collection)bpnums) && bpnums.size() == 1 && CollectionUtils.isNotEmpty((Collection)(currencyConGrp = AuditLogESHelper.buildCurrencyConditionGroup((long)this.getModelId(), (String)((String)entitynums.iterator().next()), (Set)bpnums, (Set)currentnums)))) {
            currentnums.clear();
            currentnums.addAll(((AuditLogESHelper.CurrencyConditionGrp)currencyConGrp.get(0)).getCurrencyNums());
        }
        return memberMap;
    }

    private Set<String> searchLeafMembers(String dimNumber, List<String> memberNumbersFromCache) {
        HashSet<String> leafMembers = new HashSet<String>(memberNumbersFromCache);
        if (DimTypesEnum.ENTITY.getNumber().equalsIgnoreCase(dimNumber)) {
            return leafMembers;
        }
        memberNumbersFromCache.forEach(member -> {
            IDNumberTreeNode node = MemberReader.findMemberByNumber((String)this.getCubeNumber(), (String)dimNumber, (String)member);
            if (!node.isLeaf()) {
                List leafChildren = node.getAllChildren(2);
                Set leafNumbers = leafChildren.stream().map(IDNumberTreeNode::getNumber).collect(Collectors.toSet());
                leafMembers.addAll(leafNumbers);
            }
        });
        return leafMembers;
    }

    protected void openF7(String f7Key, String dimNumber) {
        BcmMemberF7Parameter f7Param = this.getMemberF7Parameter(dimNumber);
        f7Param.setOrderBy("longnumber");
        f7Param.setShowCustomProperty(true);
        f7Param.setShowType(ShowTypeEnum.NUMNAME.getValue());
        if (DimTypesEnum.ENTITY.getNumber().equals(dimNumber)) {
            this.searchDefaultCslScheme(f7Param);
            f7Param.setShowView(true);
            f7Param.setEnableView(true);
        }
        f7Param.setReturnClassName(ListSelectedRow.class.getName());
        Object f7Value = this.getModel().getValue(f7Key);
        List memberIdsFromCache = f7Value == null || f7Value.toString().length() == 0 ? new ArrayList(10) : this.getMemberIdsFromCache(f7Key);
        f7Param.setSelectIds(memberIdsFromCache == null ? null : new HashSet(memberIdsFromCache));
        if (this.getSingleDims().contains(dimNumber)) {
            f7Param.setMultiSelect(false);
        }
        if (DimTypesEnum.CURRENCY.getNumber().equals(dimNumber)) {
            f7Param.setCustomFilters(new QFilter("number", "not in", Arrays.asList("DC", "PC", "EC")).toSerializedString());
        }
        NewF7Utils.openF7((IFormView)this.getView(), (AbstractMemberF7Parameter)f7Param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, f7Key));
    }

    @NotNull
    protected BcmMemberF7Parameter getMemberF7Parameter(String dimNumber) {
        return new BcmMemberF7Parameter(this.getModelId(), dimNumber);
    }

    private void searchDefaultCslScheme(BcmMemberF7Parameter f7Param) {
        Long defaultCslScheme = (Long)GlobalCacheServiceHelper.getOrLoadFromCommonCache((String)(this.getModelId() + "|" + "DefaultScheme"), () -> {
            DynamicObject cslScheme = QueryServiceHelper.queryOne((String)"bcm_cslscheme", (String)"id", (QFilter[])new QFilter("model", "=", (Object)this.getModelId()).and("number", "=", (Object)"DefaultScheme").toArray());
            if (cslScheme != null) {
                return cslScheme.getLong("id");
            }
            return 0L;
        });
        if (defaultCslScheme != 0L) {
            f7Param.setViewId(defaultCslScheme);
        }
    }

    protected IOlapLogListFunction getCustomFunction() {
        return new BcmOlapLogListFunction();
    }

    protected Map<String, String> getOpTargetList() {
        HashMap<String, String> opTargetList = new HashMap<String, String>(16);
        for (OlapOpTargetEnum value : OlapOpTargetEnum.values()) {
            opTargetList.put(value.getCode(), value.getDesc());
        }
        return opTargetList;
    }

    protected String getOpTargetDesc(Map<String, String> opTargetList, String optarget) {
        if (StringUtils.isEmpty((String)optarget)) {
            return optarget;
        }
        MultiLangEnumBridge bridge = CustomOpTargetMap.get(optarget);
        if (null != bridge) {
            return bridge.loadKDString();
        }
        if (null == this.entityMap) {
            this.entityMap = Maps.newLinkedHashMapWithExpectedSize((int)100);
        }
        String entityName = this.entityMap.computeIfAbsent(optarget, f -> {
            try {
                MainEntityType type = EntityMetadataCache.getDataEntityType((String)f);
                if (type != null && type.getDisplayName() != null) {
                    return type.getDisplayName().getLocaleValue();
                }
            }
            catch (Exception ex) {
                log.warn("parse-metadata-error", (Throwable)ex);
            }
            return f;
        });
        return entityName;
    }

    static class BcmOlapLogListFunction
    extends CommonOlapLogListFunction {
        BcmOlapLogListFunction() {
        }

        public void buildOperateType(BoolQueryBuilder conditionBuilder, AuditLogQueryParam queryParam) {
            if (!queryParam.isHistory()) {
                super.buildOperateType(conditionBuilder, queryParam);
            } else {
                AuditLogESHelper.buildTransactionTag((BoolQueryBuilder)conditionBuilder, (String)queryParam.getTransactionTag());
            }
        }
    }
}

