/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.logmanage;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.filter.FilterContainer;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.fi.bcm.business.model.UserSelectModel;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.serviceHelper.UserSelectServiceHelper;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.dimension.util.ModelUtil;

public class FunctionPermLogListPlugin
extends AbstractBaseListPlugin
implements SetFilterListener {
    private static final String BILLLISTAP = "billlistap";
    private static final String TOOLBARAP = "toolbarap";
    private static final String FILTERCONTAINER = "filtercontainerap";
    private static final String BTN_REFRESH = "btn_refresh";
    private static final String BTN_EXPORT = "btn_export";
    private static final String MODEL = "model";
    private static final String MODELId = "modelid";
    private static final String APPNUMBER = "appnumber";
    private static Long RoleModelId = 17299999999L;

    @Override
    public void initialize() {
        super.initialize();
        FilterContainer filterContainer = (FilterContainer)this.getControl(FILTERCONTAINER);
        filterContainer.getContext();
        filterContainer.setBillFormId("bcm_functionpermlog");
        filterContainer.setTitle(new LocaleString(ResManager.loadKDString((String)"\u529f\u80fd\u6743\u9650\u53d8\u52a8\u65e5\u5fd7", (String)"FunctionPermLogListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
        filterContainer.addSearchClickListener(this::doRefreshBillList);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(TOOLBARAP);
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        billList.addSetFilterListener((SetFilterListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        UserSelectModel user = UserSelectServiceHelper.getUserSelect((String)Long.toString(this.getUserId()), (String)"issummury,id,model,model.id,isadjustlisttype,application,entity,year,period,scenario,currency,modifier,modifydate,onlymodel,formid,version,cslscheme,dmmodel", (ApplicationTypeEnum)ApplicationTypeEnum.CM);
        String modelId = user.getModel();
        Set modelIds = MemberPermHelper.getLimitedModelListByUser();
        if (modelId != null && modelIds.contains(Long.parseLong(modelId))) {
            this.getPageCache().put(MODELId, modelId);
            this.getModel().setValue(MODEL, (Object)user.getModel());
            this.refreshBillList(Long.parseLong(modelId));
        } else {
            this.refreshBillList(-1L);
        }
    }

    private void doRefreshBillList(SearchClickEvent evt) {
        FilterParameter filterParameter = evt.getFilterParameter();
        List fastQFilters = evt.getFastQFilters();
        List commonFilters = filterParameter.getQFilters();
        String modelId = this.getPageCache().get(MODELId);
        if (modelId != null) {
            BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
            ArrayList modelIds = Lists.newArrayListWithExpectedSize((int)2);
            modelIds.add(RoleModelId);
            modelIds.add(Long.parseLong(modelId));
            QFilter qFilter = new QFilter(MODELId, "in", (Object)modelIds);
            if (fastQFilters != null && fastQFilters.size() > 0) {
                for (QFilter fastFilter : fastQFilters) {
                    qFilter.and(fastFilter);
                }
            }
            if (commonFilters != null && commonFilters.size() > 0) {
                for (QFilter commonFilter : commonFilters) {
                    qFilter.and(commonFilter);
                }
            }
            billList.clearSelection();
            billList.getFilterParameter().getQFilters().add(qFilter);
            billList.refresh();
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String changeModel = e.getProperty().getName();
        if (MODEL.equals(changeModel)) {
            String bizAppId = this.getBizAppId();
            ApplicationTypeEnum appEnum = ApplicationTypeEnum.CM;
            if ("rpt".equals(bizAppId)) {
                appEnum = ApplicationTypeEnum.RPT;
            }
            this.propertyChangedModelUse(new ArrayList<String>());
            UserSelectModel user = UserSelectServiceHelper.getUserSelect((String)Long.toString(this.getUserId()), (String)"issummury,id,model,model.id,isadjustlisttype,application,entity,year,period,scenario,currency,modifier,modifydate,onlymodel,formid,version,cslscheme,dmmodel", (ApplicationTypeEnum)appEnum);
            String modelId = user.getModel();
            this.getPageCache().put(MODELId, modelId);
            this.refreshBillList(Long.parseLong(modelId));
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "btn_refresh": {
                String modelId = this.getPageCache().get(MODELId);
                if (modelId == null) break;
                this.refreshBillList(Long.parseLong(modelId));
                break;
            }
            case "btn_export": {
                String modelId1 = this.getPageCache().get(MODELId);
                if (modelId1 == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"AbstractBaseListPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                ArrayList<Long> modelIds = new ArrayList<Long>();
                modelIds.add(this.getModelId());
                if (this.getModelId() != 0L) {
                    modelIds.add(RoleModelId);
                }
                String bizAppId = this.getBizAppId();
                QFBuilder filter = new QFBuilder(MODELId, "in", modelIds);
                filter.add(APPNUMBER, "=", (Object)bizAppId);
                BillList list = (BillList)this.getControl(BILLLISTAP);
                if (list.getSelectedRows().size() != 0) {
                    ListSelectedRowCollection rows = list.getSelectedRows();
                    ArrayList ids = Lists.newArrayListWithCapacity((int)rows.size());
                    for (ListSelectedRow row : rows) {
                        ids.add(row.getPrimaryKeyValue());
                    }
                    filter.add("id", "in", (Object)ids);
                }
                this.exportData("bcm_functionpermlog", filter.toArray(), ResManager.loadKDString((String)"\u4f53\u7cfb\u529f\u80fd\u6743\u9650\u65e5\u5fd7", (String)"FunctionPermLogListPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), "bcm_functionperm_log", "47150e89000000ac");
                OpNameMultiLangEnumBridge opName = new OpNameMultiLangEnumBridge("\u5bfc\u51fa", "DataPermLogListPlugin_2", "fi-bcm-formplugin", "export");
                OPDescMultiLangEnumBridge opDes = new OPDescMultiLangEnumBridge("\u5168\u90e8\u5bfc\u51fa\u6210\u529f\u3002", "DataPermLogListPlugin_3", "fi-bcm-formplugin", null);
                this.writeMultiLangLog(opName, opDes);
                break;
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        String modelId = this.getPageCache().get(MODELId);
        if (modelId != null) {
            ArrayList<Long> modelIds = new ArrayList<Long>();
            modelIds.add(RoleModelId);
            modelIds.add(Long.parseLong(modelId));
            QFilter modelFilter = new QFilter(MODELId, "in", modelIds);
            ApplicationTypeEnum application = ModelUtil.queryApp(this.getView());
            QFilter appFilter = new QFilter(APPNUMBER, "=", (Object)application.appnum);
            e.getQFilters().add(modelFilter);
            e.getQFilters().add(appFilter);
            e.setOrderBy("modifytime desc");
        }
    }

    private void refreshBillList(Long modelId) {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        FilterParameter filterParameter = new FilterParameter();
        ArrayList<Long> modelIds = new ArrayList<Long>();
        if (modelId != -1L) {
            modelIds.add(RoleModelId);
        }
        modelIds.add(modelId);
        QFilter modelFilter = new QFilter(MODELId, "in", modelIds);
        filterParameter.getQFilters().add(modelFilter);
        ApplicationTypeEnum application = ModelUtil.queryApp(this.getView());
        QFilter appFilter = new QFilter(APPNUMBER, "=", (Object)application.appnum);
        filterParameter.getQFilters().add(modelFilter);
        filterParameter.getQFilters().add(appFilter);
        filterParameter.setOrderBy("modifytime desc");
        billList.setFilterParameter(filterParameter);
        billList.refresh();
        billList.clearSelection();
        billList.refreshData();
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        List<QFilter> qFilterList = ModelUtil.getModelFilters(this.getView());
        showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
    }
}

