/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.mergecontrol;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.chkcheck.util.DimMemberQueryUtil;
import kd.fi.bcm.business.dimension.helper.OrgCurrencyServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.Recorder;
import kd.fi.bcm.common.enums.chkcheck.CHKFormulaStatusEnum;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import org.apache.commons.compress.utils.Sets;

public class MergeCheckShowByBpPlugin
extends AbstractBaseListPlugin
implements HyperLinkClickListener {
    private static final String entryentity = "entryentity";
    private static final Set<String> columns = Sets.newHashSet((Object[])new String[]{"eirpt", "eradj", "erpt", "irpt", "radj", "rpt", "adj", "arpt", "cadj", "prpt", "eje", "cc", "ccadj", "cctotal"});

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl(entryentity);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setData();
    }

    private void setData() {
        Map param = this.getView().getFormShowParameter().getCustomParams();
        Label title = (Label)this.getControl("title");
        title.setText(param.get("title").toString());
        this.setColVisible(param.get("bpType").toString());
        this.setRowsData(param);
    }

    private void setColVisible(String bpType) {
        IFormView view = this.getView();
        view.setVisible(Boolean.valueOf(bpType.equals("erpt")), this.getCol("erpt"));
        view.setVisible(Boolean.valueOf(bpType.equals("rpt")), this.getCol("rpt"));
        view.setVisible(Boolean.valueOf(bpType.equals("arpt")), this.getCol("arpt"));
        view.setVisible(Boolean.valueOf(bpType.equals("prpt")), this.getCol("prpt"));
        view.setVisible(Boolean.valueOf(bpType.equals("eje")), this.getCol("eje"));
        view.setVisible(Boolean.valueOf(bpType.equals("cctotal")), this.getCol("cctotal"));
    }

    private String[] getCol(String bpType) {
        switch (bpType) {
            case "erpt": {
                return new String[]{"eirpt", "eradj", "erpt"};
            }
            case "rpt": {
                return new String[]{"irpt", "radj", "rpt"};
            }
            case "arpt": {
                return new String[]{"adj", "arpt"};
            }
            case "prpt": {
                return new String[]{"cadj", "prpt"};
            }
            case "eje": {
                return new String[]{"eje"};
            }
            case "cctotal": {
                return new String[]{"cc", "ccadj", "cctotal"};
            }
        }
        return null;
    }

    private void setRowsData(Map<String, Object> param) {
        DynamicObject currency;
        Map mergedim = (Map)this.deSerializedBytes(param.get("mergedim").toString());
        Pair model = (Pair)mergedim.get("model");
        HashMap pbNumber2Id = new HashMap(16);
        Set dimAllSonMembs = DimMemberQueryUtil.findDimAllSonMembs((Long)((Long)model.p1), (String)"bcm_processmembertree", Arrays.asList("CCTotal", "CT"));
        BusinessDataServiceHelper.loadFromCache((String)"bcm_processmembertree", (String)"id, number", (QFilter[])new QFBuilder("id", "in", (Object)dimAllSonMembs).toArray()).values().forEach(bp -> pbNumber2Id.put(bp.getString("number").toLowerCase(Locale.ENGLISH), bp.getLong("id")));
        String bpType = param.get("bpType").toString();
        Pair scenario = (Pair)mergedim.get("scenario");
        Pair year = (Pair)mergedim.get("year");
        Pair period = (Pair)mergedim.get("period");
        Pair org = (Pair)mergedim.get("org");
        DynamicObject parent = BusinessDataServiceHelper.loadSingle((Object)org.p1, (String)"bcm_entitymembertree", (String)"parent.id, parent.number").getDynamicObject("parent");
        long orgparent = parent.getLong("id");
        if (bpType.equals("erpt")) {
            currency = OrgCurrencyServiceHelper.getCurrencyDynById((Long)((Long)org.p1), (String)((String)year.p2), (Long)((Long)period.p1));
        } else {
            if (parent.getString("number").equals("Entity")) {
                return;
            }
            currency = OrgCurrencyServiceHelper.getCurrencyDynById((Long)orgparent, (String)((String)year.p2), (Long)((Long)period.p1));
        }
        this.getPageCache().put("mergedim", param.get("mergedim").toString());
        this.getPageCache().put("currencyId", currency.getString("id"));
        this.getPageCache().put("pbNumber2Id", this.toByteSerialized(pbNumber2Id));
        Long orgId = (Long)org.p1;
        long copyfromId = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"bcm_entitymembertree", (String)"copyfrom.id").getLong("copyfrom.id");
        if (copyfromId != 0L) {
            orgId = copyfromId;
        }
        QFBuilder qfChkReport = new QFBuilder("model", "=", model.p1);
        qfChkReport.add("scenario", "=", scenario.p1);
        qfChkReport.add("year", "=", year.p1);
        qfChkReport.add("period", "=", period.p1);
        qfChkReport.add("org", "=", (Object)orgId);
        qfChkReport.add("currency", "=", (Object)currency.getLong("id"));
        qfChkReport.add("orgparent", "=", (Object)orgparent).or("orgparent", "=", (Object)0);
        DynamicObjectCollection chkReports = QueryServiceHelper.query((String)"bcm_chkreport", (String)"chkresulttype, process.number, chkformula.id", (QFilter[])qfChkReport.toArray());
        if (!chkReports.isEmpty()) {
            List chkSettingIds = chkReports.stream().map(report -> report.getLong("chkformula.id")).collect(Collectors.toList());
            DynamicObjectCollection chkSetting = QueryServiceHelper.query((String)"bcm_chkformulasetting", (String)"id,number,name,status", (QFilter[])new QFBuilder("id", "in", chkSettingIds).toArray());
            HashMap enableSetting = new HashMap();
            chkSetting.stream().filter(setting -> CHKFormulaStatusEnum.enable.getIndex().equals(setting.getString("status"))).forEach(set -> enableSetting.put(set.getLong("id"), set));
            if (enableSetting.size() == 0) {
                return;
            }
            List afterReports = chkReports.stream().filter(chk -> enableSetting.containsKey(chk.getLong("chkformula.id"))).collect(Collectors.toList());
            HashSet cols = Sets.newHashSet((Object[])Objects.requireNonNull(this.getCol(bpType)));
            ArrayList<Integer> toDelRowIndex = new ArrayList<Integer>();
            Map<Long, List<DynamicObject>> chkId2Reports = afterReports.stream().collect(Collectors.groupingBy(r -> r.getLong("chkformula.id")));
            this.getModel().batchCreateNewEntryRow(entryentity, chkId2Reports.size());
            int record = 0;
            for (List<DynamicObject> rpts : chkId2Reports.values()) {
                Recorder isToDel = new Recorder((Object)Boolean.TRUE);
                DynamicObject chk2 = rpts.get(0);
                DynamicObject toView = this.getModel().getEntryRowEntity(entryentity, record);
                toView.set("chksettingid", (Object)chk2.getString("chkformula.id"));
                toView.set("chknumber", (Object)((DynamicObject)enableSetting.get(chk2.getLong("chkformula.id"))).getString("number"));
                toView.set("chkname", (Object)((DynamicObject)enableSetting.get(chk2.getLong("chkformula.id"))).getString("name"));
                HashMap process2ChkResult = new HashMap(16);
                rpts.forEach(r -> {
                    if (r.getString("process.number") == null) {
                        return;
                    }
                    String col = r.getString("process.number").toLowerCase(Locale.ENGLISH);
                    if (columns.contains(col)) {
                        HashSet<String> chkResultSet = (HashSet<String>)process2ChkResult.get(col);
                        if (chkResultSet == null) {
                            chkResultSet = new HashSet<String>(16);
                        }
                        chkResultSet.add(r.getString("chkresulttype"));
                        process2ChkResult.put(col, chkResultSet);
                    }
                    if (cols.contains(col)) {
                        isToDel.setRecord((Object)Boolean.FALSE);
                    }
                });
                for (Map.Entry entry : process2ChkResult.entrySet()) {
                    String colKey = (String)entry.getKey();
                    Set resultSet = (Set)entry.getValue();
                    if (resultSet.isEmpty()) {
                        toView.set(colKey, (Object)"0");
                        continue;
                    }
                    if (resultSet.contains("2")) {
                        toView.set(colKey, (Object)"2");
                        continue;
                    }
                    toView.set(colKey, (Object)"1");
                }
                if (Boolean.TRUE.equals(isToDel.getRecord())) {
                    toDelRowIndex.add(record);
                }
                ++record;
            }
            if (!toDelRowIndex.isEmpty()) {
                int[] del = new int[toDelRowIndex.size()];
                for (int i = 0; i < del.length; ++i) {
                    del[i] = (Integer)toDelRowIndex.get(i);
                }
                this.getModel().deleteEntryRows(entryentity, del);
            }
            this.getView().updateView(entryentity);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        String key = arg0.getFieldName();
        EntryGrid entryGrid = (EntryGrid)this.getControl(entryentity);
        int[] selectRows = entryGrid.getSelectRows();
        DynamicObject selectedRow = this.getModel().getEntryRowEntity(entryentity, selectRows[0]);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setCustomParam("chksettingid", (Object)selectedRow.getLong("chksettingid"));
        showParameter.setCustomParam("mergedim", (Object)this.getPageCache().get("mergedim"));
        showParameter.setCustomParam("currencyId", (Object)this.getPageCache().get("currencyId"));
        Map pbNumber2Id = (Map)this.deSerializedBytes(this.getPageCache().get("pbNumber2Id"));
        showParameter.setCustomParam("processId", pbNumber2Id.get(key));
        this.getView().returnDataToParent((Object)this.toByteSerialized(showParameter));
        this.getView().close();
    }
}

