/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.mergecontrol;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.userconfig.UserConfig;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormUserConfig;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.form.FormUserConfig;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.fi.bcm.business.dimension.datalock.LockScopeServiceHelper;
import kd.fi.bcm.business.dimension.datalock.StageServiceHelper;
import kd.fi.bcm.business.dimension.helper.CslSchemeServiceHelper;
import kd.fi.bcm.business.dimension.helper.OrgServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.dimension.util.ModelUtil;
import kd.fi.bcm.business.mergecontrol.MergeCondition;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.mergecontrol.MergeControlService;
import kd.fi.bcm.business.mergecontrol.MergeEntityService;
import kd.fi.bcm.business.mergecontrol.MergeMessage;
import kd.fi.bcm.business.mergecontrol.MergeStatusHelper;
import kd.fi.bcm.business.mergecontrol.flow.FlowStepServiceHelper;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.business.model.FixedItem;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.business.model.UserSelectModel;
import kd.fi.bcm.business.period.PeriodConstant;
import kd.fi.bcm.business.permission.perm.PermissionService;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.UserSelectServiceHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.config.CM053TypeEnum;
import kd.fi.bcm.common.config.SceneSettingVo;
import kd.fi.bcm.common.enums.AdjustTypeEnum;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.StageOpTypeEnum;
import kd.fi.bcm.common.enums.config.ConfigEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.json.JSONObjectUtil;
import kd.fi.bcm.common.merge.UserConfigUtils;
import kd.fi.bcm.common.model.MessageInfo;
import kd.fi.bcm.common.model.ResultBox;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.BlackListUtils;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.AppHome.MergeMonitorPlugin;
import kd.fi.bcm.formplugin.MethodOpProxy;
import kd.fi.bcm.formplugin.batch.BatchInsertService;
import kd.fi.bcm.formplugin.guidemenu.GuidePageUtils;
import kd.fi.bcm.formplugin.mergecontrol.taskjob.RealTimeJobHelper;
import kd.fi.bcm.formplugin.util.TreeEntryEntityUtil;
import kd.fi.bcm.formplugin.util.UserSelectUtil;
import org.apache.commons.collections.CollectionUtils;

public class MergeControlListPlugin
extends AbstractBaseListPlugin
implements TreeNodeQueryListener,
HyperLinkClickListener {
    private static final String ID = "id";
    private static final String TOOLBAR_AP = "mergetoolbarap";
    protected static final String TREE_ENTITY = "treeentryentity";
    private static final String ITEM_KEYMERGE = "onekeymerge";
    private static final String ITEM_ALLMERGE = "allmerge";
    private static final String ITEM_MERGE_SUM = "mergesum";
    private static final String ITEM_CAL = "execcalculate";
    private static final String ITEM_CONVERT = "execconvert";
    private static final String ITEM_CONTRIBUTE = "execcontribution";
    private static final String ITEM_STAGEAPPR = "stageappr";
    private static final String ITEM_STAGECOMMIT = "stagecommit";
    private static final String ITEM_STAGEBACK = "stageback";
    private static final String ITEM_ARCHIVE = "archive";
    private static final String ITEM_CANCELARCHIVE = "cancelarchive";
    private static final String ITEM_FORCECOMMIT = "forcecommit";
    private static final String ITEM_CHKCHECK = "chkcheck";
    private static final String ITEM_COMPLETECHECK = "btn_completecheck";
    private static final String ITEM_UNAUDIT = "btn_unaudit";
    private static final String ITEM_VERSIONED = "versioned";
    private static final String ITEM_CANCEVERSIONED = "cancelversioned";
    private static final String ITEM_STAGEOP = "stageop";
    private static final String ITEM_SHOWCONFIG = "showconfig";
    private static final String ITEM_REMINDER = "reminder";
    private static final String ITEM_MERGEREMINDER = "mergereminder";
    private static final String ITEM_TASKREMINDER = "taskreminder";
    private static final String CHECK_FLOWSTATUS = "checkflowstatus";
    private static final String PROCESS = "process";
    private static final String PAGE_ITEM = "pageItem";
    private static final String FIELD_NAME = "name";
    protected static final List<String> DIM_KEYS = Lists.newArrayList((Object[])new String[]{"scenario", "year", "period"});
    protected static final List<String> NO_LEAF_KEYS = Lists.newArrayList((Object[])new String[]{"entity"});
    private static final Set<String> ALL_KEYS = Sets.newHashSet((Object[])new String[]{"scenario", "year", "period", "entity"});
    private static final String[] SINGLE_OPTION_KEYS = new String[]{"onekeymerge", "allmerge", "mergesum", "showprogress", "showoperationlog", "execcontribution", "chkrecord", "showworkpaper", "showadjustlist", "reminder"};
    private static final List<String> CHECK_PERIOD_KEYS = Lists.newArrayList((Object[])new String[]{"onekeymerge", "allmerge", "mergesum", "execcalculate", "execconvert", "execcontribution", "stagestart", "stageappr", "stagecommit", "stageback", "archive", "cancelarchive", "chkcheck", "forcecommit", "versioned", "cancelversioned", "btn_completecheck", "btn_unaudit", "mergereminder", "taskreminder"});
    private static final List<String> ALL_VERSIONED_KEYS = Lists.newArrayList((Object[])new String[]{"onekeymerge", "allmerge", "mergesum", "execcontribution"});
    List<String> PART_VERSIONED_KEYS = Lists.newArrayList((Object[])new String[]{"execcalculate", "execconvert", "chkcheck", "stagecommit", "stageback", "archive", "cancelarchive", "forcecommit", "stagestart", "stageappr", "btn_completecheck", "btn_unaudit"});
    private final MergeControlService mergeService = MergeControlService.getInstance();
    private static final Set<String> noLeafCheck = Sets.newHashSet((Object[])new String[]{"execconvert", "chkcheck", "btn_completecheck", "btn_unaudit", "stageappr", "stagecommit", "stageback", "archive", "cancelarchive", "forcecommit", "versioned", "cancelversioned"});
    public static final String CACHE_CHK_REPORT_TAB = "cache_chkReportTab";

    @Override
    public void initialize() {
        super.initialize();
        this.addItemClickListeners(TOOLBAR_AP);
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(TREE_ENTITY);
        treeEntry.addHyperClickListener((HyperLinkClickListener)this);
        treeEntry.addCellClickListener((TreeNodeQueryListener)this);
        treeEntry.addRowClickListener(new RowClickEventListener(){

            public void entryRowClick(RowClickEvent evt) {
                int[] rows = MergeControlListPlugin.this.getTreeSelectedRows();
                if (rows.length == 1) {
                    MergeControlListPlugin.this.resetStatusOnEntryClick(rows[0]);
                }
                if (rows.length > 1) {
                    MergeControlListPlugin.this.resetStatusMultiSelect();
                }
            }
        });
        HashMap map = new HashMap();
        this.asMapF7toType(DIM_KEYS, SingleF7TypeEnum.LEAF, map);
        this.asMapF7toType(NO_LEAF_KEYS, SingleF7TypeEnum.COMMON, map);
        super.initSingleMemberF7(map);
        if (BlackListUtils.hasFeatureInCm((String)"CMTra")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{ITEM_CONVERT, "pccalstatus", "pcflowstatus"});
        }
        if (BlackListUtils.hasFeatureInCm((String)"CMCSTE")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"mergedatasource"});
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        DynamicObject modelDy;
        super.afterCreateNewData(e);
        this.refreshBillByUserSelect(DIM_KEYS, true);
        String entityId = GuidePageUtils.getUserSelectOrg(this.getView(), this.getUserId(), this.getModelId(), false, false);
        if (StringUtils.isBlank((CharSequence)entityId)) {
            UserSelectModel userSelect = UserSelectServiceHelper.getUserSelect((String)Long.toString(this.getUserId()), (String)"issummury,id,model,model.id,isadjustlisttype,application,entity,year,period,scenario,currency,modifier,modifydate,onlymodel,formid,version,cslscheme,dmmodel", (ApplicationTypeEnum)ApplicationTypeEnum.CM);
            entityId = userSelect.getOrg();
        }
        if ((modelDy = this.getCtrl("model")) != null && StringUtils.isNotBlank((CharSequence)entityId)) {
            if (!CslSchemeServiceHelper.checkOrgIsRateOrgById((long)modelDy.getLong(ID), (long)LongUtil.toLong((Object)entityId))) {
                this.getModel().setValue("entity", (Object)Long.valueOf(entityId));
                this.changeEntityF7ShowName(Boolean.FALSE);
                this.saveUserSelect();
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u975e\u6c47\u7387\u7ec4\u7ec7\u89c6\u56fe\u7684\u7ec4\u7ec7\u3002", (String)"MergeControlListPlugin_62", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        }
        this.loadEntityMember(true);
        DynamicObject entityDyn = this.getCtrl("entity");
        DynamicObject entryRowEntity = this.getView().getControl(TREE_ENTITY).getModel().getEntryRowEntity(TREE_ENTITY, 0);
        if (entityDyn != null && entryRowEntity != null) {
            entityDyn.set(FIELD_NAME, (Object)entryRowEntity.getString(FIELD_NAME));
            this.getView().updateView("entity");
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setVisible();
        this.dealDataLockStage();
    }

    public void queryTreeNodeChildren(TreeNodeEvent evt) {
        if (this.getModel().getEntryEntity(TREE_ENTITY).size() < evt.getRowKey() + 1) {
            return;
        }
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(TREE_ENTITY);
        int[] re = this.addChildRows(evt.getRowKey());
        if (re == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8d22\u5e74\u671f\u95f4\u4e0b\uff0c\u6ca1\u6709\u6709\u6548\u7684\u4e0b\u7ea7\u7ec4\u7ec7\u8282\u70b9\u3002", (String)"MergeControlListPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            treeEntry.collapse(evt.getRowKey());
            return;
        }
        IClientViewProxy po = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        po.invokeControlMethod(TREE_ENTITY, "collapseAllNode", new Object[]{re});
        treeEntry.selectRows(evt.getRowKey());
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String key = evt.getFieldName();
        Long modelId = this.getCtrlId("model");
        Long sceneId = this.getCtrlId("scenario");
        Long yearId = this.getCtrlId("year");
        Long periodId = this.getCtrlId("period");
        DynamicObjectCollection orgTree = this.getModel().getEntryEntity(TREE_ENTITY);
        DynamicObject selectRow = (DynamicObject)orgTree.get(evt.getRowIndex());
        long currentOrgId = selectRow.getLong("memberid");
        IDNumberTreeNode sceneNode = MemberReader.findScenaMemberById((Long)modelId, (Long)sceneId);
        boolean isVersioned = Boolean.TRUE.equals(sceneNode.getProperty("isversioned"));
        String sceneNameTitle = sceneNode.getName();
        if (isVersioned && !MergeEntityService.getInstance().isVersionedOrg(modelId, sceneId, yearId, periodId, Long.valueOf(currentOrgId))) {
            sceneId = (Long)sceneNode.getProperty("scenequote.id");
            sceneNameTitle = MemberReader.findScenaMemberById((Long)modelId, (Long)sceneId).getName();
        }
        if (key.equals("flowstatus") || key.equals("pcflowstatus") || key.startsWith("flowstatusstage") || key.startsWith("pcflowstatusstage")) {
            FormShowParameter parameter = new FormShowParameter();
            if (key.startsWith("pcflowstatus")) {
                parameter.setCustomParam("bizid", (Object)selectRow.getLong("pcdataid"));
            } else {
                parameter.setCustomParam("bizid", (Object)selectRow.getLong("ecdataid"));
            }
            String stageName = "";
            if (key.startsWith("flowstatusstage") || key.startsWith("pcflowstatusstage")) {
                HashMap<Object, Object> planStageMap = new HashMap<Object, Object>(16);
                HashMap<Object, Object> planStageNameMap = new HashMap<Object, Object>(16);
                Long currentScenarioId = this.getCtrlId("scenario");
                Pair dataLockPlanInfo = StageServiceHelper.getDataLockPlanInfo((Long)modelId, (Long)currentScenarioId, (Long)yearId, (Long)periodId);
                if ((Long)dataLockPlanInfo.p1 > 0L) {
                    for (Tuple stageItem : (List)dataLockPlanInfo.p2) {
                        planStageMap.put(stageItem.p2, stageItem.p1);
                        planStageNameMap.put(stageItem.p2, stageItem.p3);
                    }
                }
                String stageLevel = key.substring(key.length() - 1);
                stageName = (String)planStageNameMap.get(stageLevel);
                parameter.setCustomParam("stageid", planStageMap.get(stageLevel));
            }
            String title = "";
            if (key.equals("flowstatus")) {
                title = ResManager.loadKDString((String)"\u7ec4\u7ec7\u9ed8\u8ba4\u5e01\u5ba1\u6279\u5386\u53f2\u67e5\u770b", (String)"MergeControlListPlugin_69", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            } else if (key.equals("pcflowstatus")) {
                title = ResManager.loadKDString((String)"\u7ec4\u7ec7\u6298\u7b97\u5e01\u5ba1\u6279\u5386\u53f2\u67e5\u770b", (String)"MergeControlListPlugin_70", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            } else if (key.startsWith("flowstatusstage")) {
                title = String.format(ResManager.loadKDString((String)"%s\u9ed8\u8ba4\u5e01\u5ba1\u6279\u5386\u53f2\u67e5\u770b", (String)"MergeControlListPlugin_71", (String)"fi-bcm-formplugin", (Object[])new Object[0]), stageName);
            } else if (key.startsWith("pcflowstatusstage")) {
                title = String.format(ResManager.loadKDString((String)"%s\u6298\u7b97\u5e01\u5ba1\u6279\u5386\u53f2\u67e5\u770b", (String)"MergeControlListPlugin_72", (String)"fi-bcm-formplugin", (Object[])new Object[0]), stageName);
            }
            parameter.setCaption(title);
            parameter.setFormId("bcm_viewdealinfo");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(parameter);
        } else if (key.startsWith("pcflowstatus")) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setCustomParam("bizid", (Object)selectRow.getLong("pcdataid"));
            parameter.setFormId("bcm_viewdealinfo");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(parameter);
        } else if ("adjuststatus".equals(key)) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setCustomParam("enterType", (Object)"mergeView");
            parameter.setCustomParam("selectedOrgid", (Object)selectRow.getLong("memberid"));
            parameter.setCustomParam("adjustStatus", (Object)selectRow.getInt("adjuststatus"));
            parameter.setCustomParam("modelId", (Object)modelId);
            parameter.setCustomParam("scenarioId", (Object)sceneId);
            parameter.setCustomParam("yearId", (Object)yearId);
            parameter.setCustomParam("perioId", (Object)periodId);
            parameter.setFormId("bcm_rptadjust_list");
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(parameter);
        } else if ("chkstatus".equals(key)) {
            DynamicObject modeldo = this.getCtrl("model");
            DynamicObject scenariodo = this.getCtrl("scenario");
            DynamicObject yeardo = this.getCtrl("year");
            DynamicObject perioddo = this.getCtrl("period");
            StringBuilder title = new StringBuilder();
            title.append(DimTypesEnum.SCENARIO.getName()).append("\uff1a").append(sceneNameTitle).append(" | ");
            title.append(DimTypesEnum.YEAR.getName()).append("\uff1a").append(yeardo.getString(FIELD_NAME)).append(" | ");
            title.append(DimTypesEnum.PERIOD.getName()).append("\uff1a").append(perioddo.getString(FIELD_NAME)).append(" | ");
            title.append(DimTypesEnum.ENTITY.getName()).append("\uff1a").append(selectRow.getString(FIELD_NAME));
            FormShowParameter parameter = new FormShowParameter();
            HashMap<String, Pair> mergedim = new HashMap<String, Pair>(8);
            mergedim.put("model", Pair.onePair((Object)modeldo.getLong(ID), (Object)modeldo.getString("number")));
            mergedim.put("scenario", Pair.onePair((Object)sceneId, (Object)scenariodo.getString("number")));
            mergedim.put("year", Pair.onePair((Object)yeardo.getLong(ID), (Object)yeardo.getString("number")));
            mergedim.put("period", Pair.onePair((Object)perioddo.getLong(ID), (Object)perioddo.getString("number")));
            mergedim.put("org", Pair.onePair((Object)currentOrgId, (Object)selectRow.getString("number")));
            parameter.setCustomParam("mergedim", (Object)this.toByteSerialized(mergedim));
            parameter.setCustomParam("bpType", (Object)(this.getProcess() != null ? this.getProcess() : AdjustTypeEnum.ERPT.getValue()));
            parameter.setCustomParam("title", (Object)title);
            parameter.setFormId("bcm_mergecheckshowbybp");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bcm_mergecheckshowbybp"));
            this.getView().showForm(parameter);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        Long modelId = this.getCtrlId("model");
        Long sceneId = this.getCtrlId("scenario");
        Long yearId = this.getCtrlId("year");
        Long periodId = this.getCtrlId("period");
        String modelNumber = this.getCtrlNumber("model");
        if (PROCESS.equals(propName)) {
            if (modelId == null || sceneId == null || yearId == null || periodId == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f53\u7cfb\u3001\u60c5\u666f\u3001\u8d22\u5e74\u3001\u671f\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MergeControlListPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            this.reloadAllData();
            return;
        }
        if (e.getChangeSet()[0].getNewValue() != null && !(e.getChangeSet()[0].getNewValue() instanceof DynamicObject)) {
            return;
        }
        DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
        DynamicObject oldValue = (DynamicObject)e.getChangeSet()[0].getOldValue();
        if (newValue != null && oldValue != null && newValue.getLong(ID) == oldValue.getLong(ID)) {
            return;
        }
        if ("model".equals(propName)) {
            this.propertyChangedModelUse(new ArrayList<String>(ALL_KEYS));
            this.getModel().deleteEntryData(TREE_ENTITY);
            this.setVisible();
        } else if ("entity".equals(propName)) {
            String schemeName;
            DynamicObject newEntity;
            if (null != newValue && null != modelId) {
                QFilter changeOrgFilter = new QFilter("model", "=", (Object)modelId).and(ID, "=", (Object)newValue.getLong(ID));
                DynamicObject changeToOrg = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)PeriodConstant.getOrgSelectStr(), (QFilter[])changeOrgFilter.toArray());
                if (null == changeToOrg) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u4e0d\u5b58\u5728\u8be5\u7ec4\u7ec7\uff0c\u5df2\u91cd\u7f6e\u6e05\u7a7a\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"MergeControlListPlugin_63", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue("entity", null);
                    this.savetUserSelectWhenOtherChange("entity", new UserSelectModel());
                    return;
                }
            }
            DynamicObject oldEntity = (DynamicObject)e.getChangeSet()[0].getOldValue();
            String oldSchemeName = null;
            if (oldEntity != null) {
                oldSchemeName = this.mergeService.getSchemeNameById(Long.valueOf(oldEntity.getLong(ID)));
            }
            if ((newEntity = (DynamicObject)e.getChangeSet()[0].getNewValue()) != null && StringUtils.isNotBlank((CharSequence)(schemeName = this.mergeService.getSchemeNameById(Long.valueOf(newEntity.getLong(ID))))) && !schemeName.equals(oldSchemeName)) {
                String msg = String.format(MergeMessage.TIP_SCHEMA.getText(), schemeName);
                this.getView().showSuccessNotification(msg);
            }
            this.changeEntityF7ShowName(Boolean.FALSE);
        } else if (DIM_KEYS.contains(propName)) {
            Boolean isSureReturn = this.propertyChangedDimUse(propName, newValue, false, false);
            if (Boolean.FALSE.equals(isSureReturn)) {
                return;
            }
            if ("scenario".equals(propName)) {
                IDNumberTreeNode sceneNode = MemberReader.findScenaMemberById((String)modelNumber, (Long)sceneId);
                this.getView().setVisible(Boolean.valueOf(Boolean.TRUE.equals(sceneNode.getProperty("isversioned"))), new String[]{ITEM_VERSIONED, ITEM_CANCEVERSIONED, "scenename"});
                this.updateCheckStatusView();
            }
            if (modelId == null || sceneId == null || yearId == null || periodId == null) {
                this.getModel().setValue("entity", null);
                return;
            }
            this.changeEntityF7ShowName(true);
        }
        this.saveUserSelect();
        this.loadEntityMember(true);
        this.setVisible();
        this.dealDataLockStage();
    }

    private void changeEntityF7ShowName(boolean isNoMerge) {
        DynamicObject scenario = (DynamicObject)this.getValue("scenario");
        DynamicObject year = (DynamicObject)this.getValue("year");
        DynamicObject period = (DynamicObject)this.getValue("period");
        DynamicObject org = (DynamicObject)this.getValue("entity");
        if (scenario != null && year != null && period != null && org != null) {
            DynamicObjectCollection noMerge;
            CloneUtils cloneUtils = new CloneUtils(true, false);
            DynamicObject clone = (DynamicObject)cloneUtils.clone(org.getDataEntityType(), (Object)org);
            FilterOrgStructParam param = new FilterOrgStructParam(this.getModelId(), scenario.getLong(ID), year.getString("number"), period.getLong(ID));
            DynamicObjectCollection dys = new DynamicObjectCollection();
            dys.add((Object)clone);
            EntityVersioningUtil.filterOrgsByMergeStruct((FilterOrgStructParam)param, (List)dys);
            if (CollectionUtils.isEmpty((Collection)dys)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u671f\u95f4\u8303\u56f4\u7ec4\u7ec7\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u91cd\u9009\u62e9\u7ec4\u7ec7\u6210\u5458\u3002", (String)"MergeControlListPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("entity", null);
                return;
            }
            if (isNoMerge && CollectionUtils.isNotEmpty((Collection)(noMerge = OrgServiceHelper.getNoMergeOrgList((DynamicObjectCollection)dys, (Long)this.getModelId(), (Long)scenario.getLong(ID), (Long)year.getLong(ID), (Long)period.getLong(ID))))) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d,\u5728\u6b64\u671f\u95f4\u4e0d\u53c2\u4e0e\u5408\u5e76\u3002", (String)"MergeControlListPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ((DynamicObject)noMerge.get(0)).getString(FIELD_NAME)));
                if (!ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"CM030") || !ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"CM030") && !ConfigServiceHelper.getNonLeafOfCM030((Long)this.getModelId())) {
                    this.getModel().setValue("entity", null);
                    return;
                }
            }
            this.getModel().setValue("entity", (Object)clone);
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        boolean lockArchive;
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (itemKey.equals("exit")) {
            return;
        }
        if (itemKey.equals("lockarchive")) {
            this.showDataLockArchive();
            return;
        }
        switch (itemKey) {
            case "refresh": {
                this.reloadAllData();
                return;
            }
            case "showprogress": {
                this.showMergeProgress(null);
                return;
            }
            case "showoperationlog": {
                this.openOperationLog();
                return;
            }
            case "showchkrecord": {
                this.openChkReport();
                return;
            }
            case "showadjustlist": {
                this.openAdjustList();
                return;
            }
            case "showworkpaper": {
                this.openWorkPaperList();
                return;
            }
            case "showcolumnconfig": {
                return;
            }
            case "showconfig": {
                this.openShowConfig();
                return;
            }
            case "elicitdata": {
                Button button = (Button)this.getControl("elicit_data_real");
                button.click();
                this.writeMultiLangLog(OpNameMultiLangEnumBridge.genOpNameBridge((MultiLangEnumBridge)OpItemEnum.EXPORT.getMultiLangEnumBridge(), (String)"Export"), new OPDescMultiLangEnumBridge("\u5bfc\u51fa\u6210\u529f", "MergeControlListPlugin_73", "fi-bcm-formplugin", null));
                return;
            }
        }
        Long modelId = this.getCtrlId("model");
        Long scenarioId = this.getCtrlId("scenario");
        Long yearId = this.getCtrlId("year");
        Long periodId = this.getCtrlId("period");
        Long entityId = this.getCtrlId("entity");
        if (modelId == null || scenarioId == null || yearId == null || periodId == null || entityId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f53\u7cfb\u3001\u60c5\u666f\u3001\u8d22\u5e74\u3001\u671f\u95f4\u3001\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MergeControlListPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        List<DynamicObject> selectRows = this.getSelectRows();
        if (selectRows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"MergeControlListPlugin_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (LockScopeServiceHelper.isExistLockDim((long)this.getModelId()) && CHECK_PERIOD_KEYS.contains(itemKey) && (lockArchive = StageServiceHelper.isLockArchive((Long)modelId, (Long)scenarioId, (Long)yearId, (Long)periodId))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u60c5\u666f\u3001\u8d22\u5e74\u3001\u671f\u95f4\u4e0b\u9501\u5b9a\u8bb0\u5f55\u5df2\u5f52\u6863\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\uff0c\u8bf7\u524d\u5f80\u5206\u6bb5\u9501\u5b9a\u5f52\u6863\u8fdb\u884c\u53cd\u5f52\u6863\u3002", (String)"MergeControlListPlugin_68", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"CM012") && CHECK_PERIOD_KEYS.contains(itemKey)) {
            String orgNumber = this.getSelectRow().getString("number");
            if (!this.checkPeriodStatus(this.getModelId(), orgNumber, scenarioId, yearId, periodId, "datastatus")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u6570\u636e\u671f\u95f4\u5df2\u5173\u95ed\u6216\u672a\u5f00\u542f\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\uff0c\u8bf7\u524d\u5f80\u671f\u95f4\u7ba1\u7406\u8fdb\u884c\u5f00\u542f\u3002", (String)"MergeControlListPlugin_23", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        if ((ALL_VERSIONED_KEYS.contains(itemKey) || this.PART_VERSIONED_KEYS.contains(itemKey)) && MergeControlHelper.isQuoteScene((Long)modelId, (Long)scenarioId)) {
            List notVersions = selectRows.stream().filter(d -> !d.getBoolean("isversioned")).collect(Collectors.toList());
            if (ALL_VERSIONED_KEYS.contains(itemKey) && !notVersions.isEmpty() || notVersions.size() == selectRows.size()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u7ec4\u7ec7\u672a\u7248\u672c\u5316\u3002", (String)"MergeControlListPlugin_58", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        if (!noLeafCheck.contains(itemKey) && !this.onlySelectedLeafChk()) {
            return;
        }
        long orgId = selectRows.get(0).getLong(ID);
        String orgNumber = selectRows.get(0).getString("number");
        FixedItem fixedItem = this.getFixedItem();
        fixedItem.setOrg(SimpleItem.newOne((Object)orgId, (String)orgNumber));
        List orgList = selectRows.stream().map(r -> SimpleItem.newOne((Object)r.getLong(ID), (String)r.getString("number"))).collect(Collectors.toList());
        fixedItem.setOrgList(orgList);
        switch (itemKey) {
            case "onekeymerge": {
                ResultBox keyResult = this.mergeService.checkMerge(fixedItem, OpItemEnum.EXEC_KEYMERGE);
                if (keyResult.isSuccess()) {
                    this.showConfirmDialog("bcm_mergeoneconfirm", ITEM_KEYMERGE, fixedItem);
                    break;
                }
                this.getView().showTipNotification(keyResult.getMessageText());
                break;
            }
            case "allmerge": {
                ResultBox allResult = this.mergeService.checkMerge(fixedItem, OpItemEnum.EXEC_ALLMERGE);
                if (allResult.isSuccess()) {
                    Long mergeProgressId = this.mergeService.execAllMerge(fixedItem);
                    if (mergeProgressId != null) {
                        this.showMergeProgress(mergeProgressId);
                        break;
                    }
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5408\u5e76\u8fdb\u5ea6\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u6267\u884c\u201d\u667a\u80fd\u5408\u5e76\u201c\u64cd\u4f5c\u3002", (String)"MergeControlListPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.getView().showTipNotification(allResult.getMessageText());
                break;
            }
            case "mergesum": {
                ResultBox mergeSumCheckResult = this.mergeService.checkMerge(fixedItem, OpItemEnum.EXEC_MERGE_SUM);
                if (mergeSumCheckResult.isSuccess()) {
                    fixedItem.setOrgList(orgList);
                    RealTimeJobHelper.createMergeSumTask((AbstractFormPlugin)this, this.mergeService.defaultMergeCondition(), fixedItem);
                    break;
                }
                this.getView().showTipNotification(mergeSumCheckResult.getMessageText());
                break;
            }
            case "execcalculate": {
                ResultBox result = this.mergeService.checkCalculate(fixedItem, OpItemEnum.EXEC_CALCULATE);
                if (result.isSuccess()) {
                    this.showConfirmDialog("bcm_mergecalconfirm", ITEM_CAL, fixedItem);
                    break;
                }
                this.getView().showTipNotification(result.getMessageText());
                break;
            }
            case "execconvert": {
                ResultBox convResult = this.mergeService.checkCalculate(fixedItem, OpItemEnum.EXEC_CONVERT);
                if (convResult.isSuccess()) {
                    this.showConfirmDialog("bcm_mergecalconfirm", ITEM_CONVERT, fixedItem);
                    break;
                }
                this.getView().showTipNotification(convResult.getMessageText());
                break;
            }
            case "execcontribution": {
                ResultBox contResult = this.mergeService.checkCalculate(fixedItem, OpItemEnum.EXEC_CONTRIBUTION);
                if (contResult.isSuccess()) {
                    this.mergeService.execContribution(fixedItem);
                    String msg = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u6267\u884c\u4e2d\uff0c\u7a0d\u540e\u53ef\u4ee5\u901a\u8fc7\u5237\u65b0\u67e5\u770b\u6267\u884c\u72b6\u6001\uff0c\u6216\u8005\u5728\u5408\u5e76\u6267\u884c\u65e5\u5fd7\u4e2d\u67e5\u770b\u6267\u884c\u7ed3\u679c\u3002", (String)"MergeControlListPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]), OpItemEnum.EXEC_CONTRIBUTION.getName());
                    this.getView().showSuccessNotification(msg);
                    break;
                }
                this.getView().showTipNotification(contResult.getMessageText());
                break;
            }
            case "stageappr": {
                this.openSelectStepForm(StageOpTypeEnum.APPR);
                break;
            }
            case "stagecommit": {
                this.openSelectStepForm(StageOpTypeEnum.COMMIT);
                break;
            }
            case "stageback": {
                this.openSelectStepForm(StageOpTypeEnum.BACK);
                break;
            }
            case "archive": {
                this.archive();
                break;
            }
            case "cancelarchive": {
                this.cancelArchive();
                break;
            }
            case "forcecommit": {
                this.openForceSelectStepForm();
                break;
            }
            case "chkcheck": {
                this.chkCheck();
                break;
            }
            case "btn_completecheck": 
            case "btn_unaudit": {
                this.openSelectOrgForm(itemKey);
                break;
            }
            case "versioned": {
                this.openVerSelectForm(true);
                break;
            }
            case "cancelversioned": {
                this.openVerSelectForm(false);
                break;
            }
            case "mergereminder": 
            case "taskreminder": {
                this.reminder(itemKey);
                break;
            }
        }
    }

    private boolean checkSelectOneData() {
        List<DynamicObject> selectRows = this.getSelectRows();
        if (selectRows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"MergeControlListPlugin_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    public Set<Long> unionPermEntityIds() {
        List<DynamicObject> selectRows = this.getSelectRows();
        if (CollectionUtils.isEmpty(selectRows)) {
            return Collections.emptySet();
        }
        return selectRows.stream().map(r -> r.getLong(ID)).collect(Collectors.toSet());
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        Map resultMap;
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (returnData instanceof String) {
            String data = (String)evt.getReturnData();
            if (StringUtils.isEmpty((CharSequence)data)) {
                return;
            }
            if (ITEM_SHOWCONFIG.equals(actionId)) {
                this.showPageByConfig(data);
            }
        } else if (returnData instanceof MergeCondition) {
            MergeCondition condition = (MergeCondition)evt.getReturnData();
            if (!condition.isConfirmed()) {
                return;
            }
            switch (actionId) {
                case "onekeymerge": {
                    this.executeCslInOne(condition);
                    break;
                }
                case "execcalculate": {
                    this.executeCalculateByTaskJob(condition);
                    break;
                }
                case "execconvert": {
                    this.executeConvertByTaskJob(condition);
                    break;
                }
                case "chkcheck": {
                    if (1 == condition.getCheckCondition()) {
                        this.checkUpChk(false);
                        break;
                    }
                    if (2 != condition.getCheckCondition()) break;
                    this.checkUpChk(true);
                    break;
                }
            }
        }
        if (ITEM_STAGEOP.equals(actionId)) {
            resultMap = (Map)evt.getReturnData();
            if (resultMap == null) {
                return;
            }
            this.stageOp(resultMap);
        } else if (ITEM_COMPLETECHECK.equals(actionId) || ITEM_UNAUDIT.equals(actionId)) {
            if (evt.getReturnData() == null) {
                return;
            }
            resultMap = (Map)evt.getReturnData();
            if (Objects.equals(-1, resultMap.get("data"))) {
                return;
            }
            this.updateCheckStatus(actionId, Objects.equals("2", String.valueOf(resultMap.get("data"))));
        } else if ("bcm_mergecheckshowbybp".equals(actionId) && evt.getReturnData() != null) {
            FormShowParameter parameter = (FormShowParameter)this.deSerializedBytes(evt.getReturnData().toString());
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setParentPageId(this.getView().getParentView().getPageId());
            showParameter.setParentFormId(this.getView().getParentView().getFormShowParameter().getFormId());
            Map customParams = parameter.getCustomParams();
            customParams.put("KEY_MODEL_ID", String.valueOf(this.getModelId()));
            showParameter.setCustomParams(customParams);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setFormId("bcm_chkspeechlist");
            this.getView().showForm(showParameter);
        } else if ("calculateTaskCloseBack".equals(actionId) || "convertTaskCloseBack".equals(actionId) || "mergeSumTaskCloseBack".equals(actionId)) {
            if (returnData != null) {
                String taskInfoJson = (String)((Map)returnData).get("taskinfo");
                JSONObject taskInfo = JSONObjectUtil.parseObjectOrder((String)taskInfoJson);
                boolean success = taskInfo.getJSONObject("data").getBoolean("success");
                if (success) {
                    this.reloadAllData();
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\u3002", (String)"MergeControlListPlugin_59", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                } else {
                    JSONObject errorInfo = taskInfo.getJSONObject("data").getJSONObject("error");
                    Set entries = errorInfo.entrySet();
                    ArrayList<String> errorMsgItem = new ArrayList<String>(entries.size());
                    for (Map.Entry entry : entries) {
                        errorMsgItem.add((String)entry.getKey() + ":" + entry.getValue());
                    }
                    String title = ResManager.loadKDString((String)"\u6267\u884c\u5931\u8d25\u60c5\u51b5", (String)"MergeControlListPlugin_67", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                    this.getView().showMessage(title, Joiner.on((String)"\n").join(errorMsgItem), MessageTypes.Default);
                }
            }
        } else if (ITEM_VERSIONED.equals(actionId)) {
            resultMap = (Map)evt.getReturnData();
            if (resultMap == null) {
                return;
            }
            this.versioned(resultMap);
        } else if (ITEM_CANCEVERSIONED.equals(actionId)) {
            Map conMap = (Map)evt.getReturnData();
            if (conMap == null) {
                return;
            }
            this.cancelVersioned(conMap);
        } else if ("mergeProgress".equals(actionId)) {
            this.reloadAllData();
        }
    }

    private FixedItem getFixedItem() {
        DynamicObject modelDy = this.getCtrl("model");
        DynamicObject scenarioDy = this.getCtrl("scenario");
        DynamicObject yearDy = this.getCtrl("year");
        DynamicObject periodDy = this.getCtrl("period");
        DynamicObject entityDy = this.getCtrl("entity");
        FixedItem ctx = FixedItem.newOne((SimpleItem)SimpleItem.newOne((Object)modelDy.getLong(ID), (String)modelDy.getString("number")), (SimpleItem)SimpleItem.newOne((Object)scenarioDy.getLong(ID), (String)scenarioDy.getString("number")), (SimpleItem)SimpleItem.newOne((Object)yearDy.getLong(ID), (String)yearDy.getString("number")), (SimpleItem)SimpleItem.newOne((Object)periodDy.getLong(ID), (String)periodDy.getString("number")), (SimpleItem)SimpleItem.newOne((Object)entityDy.getLong(ID), (String)entityDy.getString("number")));
        return ctx;
    }

    private void setVisible() {
        boolean mergePerm = true;
        try {
            this.doCheckPermission("bcm_mergecontrollist", "/=NALZ=PRF4B");
        }
        catch (KDBizException e) {
            mergePerm = false;
        }
        boolean rptPerm = true;
        if (!mergePerm) {
            try {
                this.doCheckPermission("bcm_mergecontrollist", "/=NAJMRI3LY0");
            }
            catch (KDBizException e) {
                rptPerm = false;
            }
        }
        this.getView().setVisible(Boolean.valueOf(rptPerm), new String[]{"calculate"});
        Long modelId = this.getCtrlId("model");
        if (modelId != null) {
            DynamicObjectCollection flowSteps = FlowStepServiceHelper.getBeforeFlowSteps((long)modelId);
            this.getView().setVisible(Boolean.valueOf(!flowSteps.isEmpty()), new String[]{ITEM_STAGEAPPR});
            boolean boolParam = ConfigServiceHelper.getBoolParam((Long)modelId, (String)ConfigEnum.CM025.getNumber());
            this.getView().setVisible(Boolean.valueOf(boolParam), new String[]{ITEM_FORCECOMMIT});
            boolean isNotice = ConfigServiceHelper.getBoolParam((Long)modelId, (String)ConfigEnum.IS_NOTICE_BY_REMINDER.getNumber());
            this.getView().setVisible(Boolean.valueOf(isNotice), new String[]{ITEM_REMINDER});
            boolean isContribution = ConfigServiceHelper.getBoolParam((Long)modelId, (String)"isContribution");
            this.getView().setVisible(Boolean.valueOf(isContribution), new String[]{ITEM_CONTRIBUTE});
            this.updateCheckStatusView();
        }
        String modelNumber = this.getCtrlNumber("model");
        Long sceneId = this.getCtrlId("scenario");
        boolean isVersioned = false;
        if (sceneId != null && modelNumber != null) {
            IDNumberTreeNode sceneNode = MemberReader.findScenaMemberById((String)modelNumber, (Long)sceneId);
            isVersioned = Boolean.TRUE.equals(sceneNode.getProperty("isversioned"));
        }
        this.getView().setVisible(Boolean.valueOf(isVersioned), new String[]{ITEM_VERSIONED, ITEM_CANCEVERSIONED, "scenename"});
        this.getView().setEnable(Boolean.valueOf(!isVersioned), new String[]{ITEM_STAGEAPPR, ITEM_STAGECOMMIT, ITEM_STAGEBACK, ITEM_ARCHIVE, ITEM_CANCELARCHIVE, ITEM_FORCECOMMIT});
    }

    private void dealDataLockStage() {
        if (this.isFromCardMonitor()) {
            return;
        }
        Long modelId = this.getCtrlId("model");
        Long sceneId = this.getCtrlId("scenario");
        Long yearId = this.getCtrlId("year");
        Long periodId = this.getCtrlId("period");
        if (modelId != null && sceneId != null && yearId != null && periodId != null) {
            Pair dataLockPlanInfo = StageServiceHelper.getDataLockPlanInfo((Long)modelId, (Long)sceneId, (Long)yearId, (Long)periodId);
            if ((Long)dataLockPlanInfo.p1 > 0L && !((List)dataLockPlanInfo.p2).isEmpty()) {
                EntryGrid grid = (EntryGrid)this.getControl(TREE_ENTITY);
                ArrayList<String> steps = new ArrayList<String>(16);
                for (Tuple tuple : (List)dataLockPlanInfo.p2) {
                    steps.add((String)tuple.p2);
                    String stageLevelKey = "stagegroup" + (String)tuple.p2;
                    grid.setColumnProperty(stageLevelKey, "header", (Object)new LocaleString((String)tuple.p3));
                }
                this.setStepVisible(Boolean.FALSE, null);
                this.setStepVisible(Boolean.TRUE, steps);
                this.getView().setVisible(Boolean.TRUE, new String[]{"lockarchive"});
                return;
            }
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"lockarchive"});
        this.setStepVisible(Boolean.FALSE, null);
    }

    private void setStepVisible(boolean isVisible, List<String> steps) {
        steps = steps == null ? Lists.newArrayList((Object[])new String[]{"1", "2", "3", "4", "5"}) : steps;
        steps.forEach(item -> this.getView().setVisible(Boolean.valueOf(isVisible), new String[]{"stagegroup" + item, "flowstatusstage" + item, "pcflowstatusstage" + item, "chkstatusstage" + item}));
    }

    private void setBtnEnableStatus(boolean enabled) {
        this.getView().setEnable(Boolean.valueOf(enabled), new String[]{ITEM_KEYMERGE, ITEM_ALLMERGE, "showprogress", "showoperationlog", "calculate", ITEM_CAL, ITEM_CONVERT, ITEM_CONTRIBUTE, ITEM_MERGE_SUM, ITEM_CHKCHECK, "showchkrecord", "showworkpaper", "showadjustlist", ITEM_COMPLETECHECK, ITEM_UNAUDIT, ITEM_REMINDER});
    }

    private void resetStatusMultiSelect() {
        this.getView().setEnable(Boolean.valueOf(false), SINGLE_OPTION_KEYS);
        this.resetClickControlBySceneVersion();
    }

    private void resetStatusOnEntryClick(int rowidx) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(TREE_ENTITY);
        if (entryEntity.size() < rowidx + 1) {
            return;
        }
        DynamicObject selectRow = (DynamicObject)entryEntity.get(rowidx);
        if ("1".equals(selectRow.getString("level"))) {
            this.setBtnEnableStatus(false);
        } else {
            if (!selectRow.getBoolean("isleaf")) {
                this.setBtnEnableStatus(true);
            } else {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{ITEM_KEYMERGE, ITEM_ALLMERGE, ITEM_MERGE_SUM, ITEM_REMINDER});
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"calculate", ITEM_CAL, ITEM_CONVERT, ITEM_CONTRIBUTE, ITEM_CHKCHECK, "showchkrecord", "refresh", ITEM_ARCHIVE, ITEM_CANCELARCHIVE, ITEM_STAGECOMMIT, ITEM_STAGEAPPR, ITEM_STAGEBACK, ITEM_FORCECOMMIT, "stagestart", "showprogress", "showoperationlog", "showworkpaper", "showadjustlist", ITEM_COMPLETECHECK, ITEM_UNAUDIT});
            }
            this.resetClickControlBySceneVersion();
        }
    }

    private void resetClickControlBySceneVersion() {
        Long modelId = this.getCtrlId("model");
        Long scenarioId = this.getCtrlId("scenario");
        if (modelId == null || scenarioId == null) {
            return;
        }
        List<DynamicObject> selectRows = this.getSelectRows();
        if (MergeControlHelper.isQuoteScene((Long)modelId, (Long)scenarioId)) {
            List notVersions = selectRows.stream().filter(d -> !d.getBoolean("isversioned")).collect(Collectors.toList());
            this.getView().setEnable(Boolean.valueOf(!selectRows.isEmpty() && notVersions.isEmpty()), ALL_VERSIONED_KEYS.toArray(new String[0]));
            this.getView().setEnable(Boolean.valueOf(!selectRows.isEmpty() && notVersions.size() < selectRows.size()), this.PART_VERSIONED_KEYS.toArray(new String[0]));
        }
        if (this.getSelectRows().stream().anyMatch(e -> e.getBoolean("isleaf"))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{ITEM_KEYMERGE, ITEM_ALLMERGE, ITEM_MERGE_SUM});
        }
    }

    private void showConfirmDialog(String formId, String itemName, FixedItem fixedItem) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        if (itemName.equals(ITEM_CONVERT)) {
            showParameter.setCaption(ResManager.loadKDString((String)"\u62a5\u8868\u6298\u7b97\u64cd\u4f5c\u786e\u8ba4", (String)"MergeControlListPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("dialogtype", (Object)itemName);
        showParameter.setCustomParam("modelId", (Object)this.getCtrlId("model"));
        showParameter.setCustomParam("scenarioId", (Object)this.getCtrlId("scenario"));
        showParameter.setCustomParam("yearId", (Object)this.getCtrlId("year"));
        showParameter.setCustomParam("yearNum", (Object)this.getCtrlNumber("year"));
        showParameter.setCustomParam("periodId", (Object)this.getCtrlId("period"));
        showParameter.setCustomParam("ctxContext", (Object)SerializationUtils.serializeToBase64((Object)fixedItem));
        DynamicObject selectRow = this.getSelectRow();
        if (!selectRow.getBoolean("isleaf")) {
            showParameter.setCustomParam("selectOrgNumber", (Object)selectRow.getString("number"));
            showParameter.setCustomParam("selectOrgId", (Object)selectRow.getLong("memberid"));
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, itemName);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void showMergeProgress(Long mergeProgressId) {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("bcm_showprogress");
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCustomParam("KEY_MODEL_ID", (Object)this.getCtrlId("model"));
        param.setCustomParam("scenario", (Object)this.getCtrlId("scenario"));
        param.setCustomParam("year", (Object)this.getCtrlId("year"));
        param.setCustomParam("period", (Object)this.getCtrlId("period"));
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "mergeProgress"));
        if (mergeProgressId != null) {
            param.setCustomParam("mergeProgressId", (Object)mergeProgressId);
        }
        this.getView().showForm(param);
    }

    private void showPageByConfig(String data) {
        HashMap returnData = (HashMap)SerializationUtils.fromJsonString((String)data, HashMap.class);
        String pageItem = returnData.get(PAGE_ITEM).toString();
        this.getPageCache().put(PAGE_ITEM, pageItem);
        this.loadEntityMember(true);
    }

    private void openOperationLog() {
        String pageId = this.getView().getPageId() + "mergeoperationlog";
        IFormView view = this.getView();
        IFormView parentView = view.getParentView();
        IFormView mainPageView = view.getMainView();
        IFormView childView = null;
        if (null != mainPageView) {
            childView = mainPageView.getView(pageId);
        }
        if (childView == null) {
            Long modelId = this.getCtrlId("model");
            if (modelId == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u4f53\u7cfb\u3002", (String)"MergeControlListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            FormShowParameter param = new FormShowParameter();
            param.setPageId(pageId);
            param.setFormId("bcm_mergeoperationlog");
            param.setCustomParam("fromMerge", (Object)true);
            param.setCustomParam("model", (Object)modelId);
            param.setCustomParam("scenario", (Object)this.getCtrlId("scenario"));
            param.setCustomParam("year", (Object)this.getCtrlId("year"));
            param.setCustomParam("period", (Object)this.getCtrlId("period"));
            DynamicObject selectedRow = this.getSelectRow();
            param.setCustomParam("selectedOrgid", (Object)selectedRow.getString(ID));
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            if (null != parentView) {
                parentView.showForm(param);
                view.sendFormAction(parentView);
            } else {
                this.getView().showForm(param);
            }
        } else {
            childView.activate();
            view.sendFormAction(childView);
        }
    }

    private void openSelectStepForm(StageOpTypeEnum opEnum) {
        this.openSelectStepForm(opEnum, false);
    }

    private void openSelectStepForm(StageOpTypeEnum opEnum, boolean isForce) {
        Long modelId = this.getCtrlId("model");
        Long sceneId = this.getCtrlId("scenario");
        Long yearId = this.getCtrlId("year");
        Long periodId = this.getCtrlId("period");
        boolean isShowStage = false;
        if (modelId != null && sceneId != null && yearId != null && periodId != null) {
            Pair dataLockPlanInfo = StageServiceHelper.getDataLockPlanInfo((Long)modelId, (Long)sceneId, (Long)yearId, (Long)periodId);
            if ((Long)dataLockPlanInfo.p1 > 0L && !((List)dataLockPlanInfo.p2).isEmpty()) {
                isShowStage = true;
            }
        }
        FormShowParameter param = new FormShowParameter();
        param.setCaption(opEnum.getText());
        param.setFormId("bcm_selectflowstep");
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCustomParam("modelId", (Object)modelId);
        param.setCustomParam("sceneId", (Object)sceneId);
        param.setCustomParam("yearId", (Object)yearId);
        param.setCustomParam("periodId", (Object)periodId);
        param.setCustomParam("isShowStage", (Object)isShowStage);
        param.setCustomParam("stageaction", (Object)opEnum.getCode());
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ITEM_STAGEOP));
        StyleCss css = new StyleCss();
        css.setWidth("520");
        if (opEnum == StageOpTypeEnum.APPR) {
            css.setHeight(isShowStage ? "655" : "455");
        } else {
            css.setHeight(isShowStage ? "595" : "395");
        }
        if (isForce) {
            param.setCustomParam(ITEM_FORCECOMMIT, (Object)true);
        }
        param.getOpenStyle().setInlineStyleCss(css);
        this.getView().showForm(param);
    }

    private void openForceSelectStepForm() {
        StageOpTypeEnum opEnum = StageOpTypeEnum.COMMIT;
        this.openSelectStepForm(opEnum, true);
    }

    private void openChkReport() {
        IFormView mainPageView = this.getView().getMainView();
        String modelId = UserSelectUtil.getF7SelectId(this.getView(), "model");
        String sceneId = UserSelectUtil.getF7SelectId(this.getView(), "scenario");
        String yearId = UserSelectUtil.getF7SelectId(this.getView(), "year");
        String periodId = UserSelectUtil.getF7SelectId(this.getView(), "period");
        int[] selectRows = ((TreeEntryGrid)this.getControl(TREE_ENTITY)).getSelectRows();
        DynamicObject treeEntity = (DynamicObject)this.getModel().getEntryEntity(TREE_ENTITY).get(selectRows == null || selectRows.length == 0 ? 0 : selectRows[0]);
        long treeEntityId = 0L;
        if (treeEntity.get("number") != null && !"Entity".equals(treeEntity.get("number"))) {
            treeEntityId = treeEntity.getLong(ID);
        }
        String cslSchemeId = this.mergeService.getSchemeById(this.getCtrlId("model"), Long.valueOf(treeEntityId));
        String pageId = this.getView().getPageId() + "openChkReport" + treeEntityId;
        if (mainPageView == null || mainPageView.getView(pageId) == null) {
            IFormView view;
            if (mainPageView != null && this.getPageCache().get(CACHE_CHK_REPORT_TAB) != null && (view = mainPageView.getView(this.getPageCache().get(CACHE_CHK_REPORT_TAB))) != null) {
                view.close();
                this.getView().sendFormAction(view);
            }
            this.getPageCache().put(CACHE_CHK_REPORT_TAB, pageId);
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("bcm_chkspeechlist");
            showParameter.setPageId(pageId);
            IFormView pageView = this.getView().getParentView();
            if (pageView != null) {
                showParameter.setParentPageId(this.getView().getParentView().getPageId());
            }
            showParameter.setCustomParam("page", (Object)"MergeControl");
            showParameter.setCustomParam("model", (Object)modelId);
            showParameter.setCustomParam("scenario", (Object)sceneId);
            showParameter.setCustomParam("year", (Object)yearId);
            showParameter.setCustomParam("period", (Object)periodId);
            showParameter.setCustomParam("entity", (Object)treeEntity.getString(ID));
            showParameter.setCustomParam("cslscheme", (Object)cslSchemeId);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(showParameter);
            if (pageView == null) {
                pageView = this.getView();
            }
            pageView.showForm(showParameter);
        } else {
            IFormView pageView = mainPageView.getView(pageId);
            pageView.getModel().setValue("model", (Object)modelId);
            pageView.getModel().setValue("scenario", (Object)sceneId);
            pageView.getModel().setValue("year", (Object)yearId);
            pageView.getModel().setValue("period", (Object)periodId);
            pageView.getModel().setValue("cslscheme", (Object)cslSchemeId);
            pageView.activate();
            this.getView().sendFormAction(pageView);
        }
    }

    private void openAdjustList() {
        if (this.checkSelectOneData()) {
            IFormView mainPageView = this.getView().getMainView();
            DynamicObject selectedRow = this.getSelectRow();
            String pageId = this.getView().getPageId() + "adjust" + selectedRow.getString("memberid");
            if (mainPageView == null || mainPageView.getView(pageId) == null) {
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("bcm_rptadjust_list");
                formShowParameter.setPageId(pageId);
                formShowParameter.setStatus(OperationStatus.EDIT);
                formShowParameter.setCustomParam("enterType", (Object)"mergeView");
                formShowParameter.setCustomParam("selectedOrgid", (Object)selectedRow.getLong("memberid"));
                formShowParameter.setCustomParam("adjustStatus", (Object)selectedRow.getInt("adjuststatus"));
                formShowParameter.setCustomParam("modelId", (Object)this.getCtrlId("model"));
                formShowParameter.setCustomParam("scenarioId", (Object)this.getCtrlId("scenario"));
                formShowParameter.setCustomParam("yearId", (Object)this.getCtrlId("year"));
                formShowParameter.setCustomParam("perioId", (Object)this.getCtrlId("period"));
                formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                IFormView pageView = this.getView().getParentView();
                if (pageView == null) {
                    pageView = this.getView();
                }
                pageView.showForm(formShowParameter);
                this.getView().sendFormAction(pageView);
            } else {
                IFormView pageView = mainPageView.getView(pageId);
                pageView.activate();
                this.getView().sendFormAction(pageView);
            }
        }
    }

    private void openWorkPaperList() {
        if (this.checkSelectOneData()) {
            DynamicObject selectedRow = this.getSelectRow();
            IFormView mainPageView = this.getView().getMainView();
            String pageId = this.getView().getPageId() + "workpaper" + selectedRow.getString("memberid");
            if (mainPageView == null || mainPageView.getView(pageId) == null) {
                ListShowParameter formShowParameter = new ListShowParameter();
                formShowParameter.setFormId("bcm_workpaper_list");
                formShowParameter.setPageId(pageId);
                formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getCtrlId("model"));
                formShowParameter.setCustomParam("model", (Object)this.getCtrlId("model"));
                formShowParameter.setCustomParam("scenario", (Object)this.getCtrlId("scenario"));
                formShowParameter.setCustomParam("year", (Object)this.getCtrlId("year"));
                formShowParameter.setCustomParam("period", (Object)this.getCtrlId("period"));
                formShowParameter.setCustomParam("common_guide_page", this.getView().getFormShowParameter().getCustomParam("common_guide_page"));
                formShowParameter.setCustomParam("selectedOrgid", (Object)selectedRow.getString("memberid"));
                formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                formShowParameter.setCaption(ResManager.loadKDString((String)"\u5de5\u4f5c\u5e95\u7a3f\u5217\u8868", (String)"MergeControlListPlugin_51", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                IFormView pageView = this.getView().getParentView();
                if (pageView == null) {
                    pageView = this.getView();
                }
                pageView.showForm((FormShowParameter)formShowParameter);
                this.getView().sendFormAction(pageView);
            } else {
                IFormView pageView = mainPageView.getView(pageId);
                pageView.activate();
                this.getView().sendFormAction(pageView);
            }
        }
    }

    private void openShowConfig() {
        if (!this.checkSelectParam(true)) {
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        if (this.getPageCache().get(PAGE_ITEM) != null) {
            showParameter.setCustomParam(PAGE_ITEM, (Object)this.getPageCache().get(PAGE_ITEM));
            this.getView().setVisible(Boolean.valueOf("show_table".equals(this.getPageCache().get(PAGE_ITEM))), new String[]{"elicit_data"});
        }
        showParameter.setFormId("bcm_showconfig");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ITEM_SHOWCONFIG);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void openVerSelectForm(boolean isVersioned) {
        OpItemEnum opEnum = isVersioned ? OpItemEnum.VERSION : OpItemEnum.CANCELVERSION;
        FormShowParameter param = new FormShowParameter();
        param.setCaption(opEnum.getName());
        param.setFormId("bcm_versionedconfirm");
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCustomParam("isVersioned", (Object)isVersioned);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, isVersioned ? ITEM_VERSIONED : ITEM_CANCEVERSIONED));
        this.getView().showForm(param);
    }

    private boolean checkSelectParam(boolean showTips) {
        DynamicObject modelDyn = this.getCtrl("model");
        DynamicObject sceneDyn = this.getCtrl("scenario");
        DynamicObject yearDyn = this.getCtrl("year");
        DynamicObject periodDyn = this.getCtrl("period");
        if (modelDyn == null || sceneDyn == null || yearDyn == null || periodDyn == null) {
            if (showTips) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f53\u7cfb\u3001\u60c5\u666f\u3001\u8d22\u5e74\u3001\u671f\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MergeControlListPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            return false;
        }
        return true;
    }

    private void loadEntityMember(boolean isClearCache) {
        Long modelId = this.getCtrlId("model");
        Long sceneId = this.getCtrlId("scenario");
        Long yearId = this.getCtrlId("year");
        Long periodId = this.getCtrlId("period");
        Long entityId = this.getCtrlId("entity");
        String pageItem = this.getPageCache().get(PAGE_ITEM);
        if (modelId == null || sceneId == null || yearId == null || periodId == null || entityId == null) {
            this.getModel().deleteEntryData(TREE_ENTITY);
            return;
        }
        if (modelId > 0L && entityId > 0L) {
            Long dimId;
            PermissionService instance;
            if (CslSchemeServiceHelper.checkOrgIsRateOrgById((long)modelId, (long)entityId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u975e\u6c47\u7387\u7ec4\u7ec7\u89c6\u56fe\u7684\u7ec4\u7ec7\u3002", (String)"MergeControlListPlugin_62", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("entity", null);
                return;
            }
            if (!"show_table".equals(pageItem) && (instance = PermissionServiceImpl.getInstance((Long)modelId)).hasNoPerm(dimId = MemberReader.getDimensionIdByNum((long)modelId, (String)"Entity"), entityId)) {
                this.getModel().deleteEntryData(TREE_ENTITY);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u65e0\u6743\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u6709\u6743\u9650\u7684\u7ec4\u7ec7\u3002", (String)"MergeControlListPlugin_66", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("entity", null);
                return;
            }
        }
        this.getModel().deleteEntryData(TREE_ENTITY);
        EntryType entityType = (EntryType)this.getModel().getDataEntityType().getAllEntities().get(TREE_ENTITY);
        DynamicObjectCollection orgTree = this.mergeService.queryMergeControlEntity(this.getFixedItem(), entityId, entityType, pageItem, true, this.getProcess(), this.isFromCardMonitor());
        if (CollectionUtils.isNotEmpty((Collection)orgTree)) {
            List properties = this.mergeService.getProperties(modelId, sceneId, yearId, periodId, this.isFromCardMonitor());
            if (!"show_table".equals(pageItem)) {
                TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(TREE_ENTITY);
                int parentLevel = ((DynamicObject)orgTree.get(0)).getInt("level");
                int[] re = TreeEntryEntityUtil.createTreeEntry(this.getView(), orgTree, properties, String.valueOf(parentLevel), false);
                if (isClearCache) {
                    treeEntry.setCollapse(false);
                    treeEntry.collapse(re);
                    treeEntry.selectRows(0);
                }
            } else {
                BatchInsertService<DynamicObject> bs = new BatchInsertService<DynamicObject>(TREE_ENTITY, properties.toArray(new String[0]));
                bs.batchCreateNewEntryRow(this.getView(), (Collection<DynamicObject>)orgTree, mcData -> {
                    ArrayList mcRowData = new ArrayList(10);
                    properties.forEach(p -> mcRowData.add(mcData.get(p)));
                    return mcRowData.toArray();
                });
            }
        }
        this.getView().setVisible(Boolean.valueOf("show_table".equals(pageItem)), new String[]{"elicitdata"});
        this.getView().updateView(TREE_ENTITY);
    }

    private void reloadAllData() {
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(TREE_ENTITY);
        this.loadEntityMember(false);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"elicit_data"});
        if ("show_table".equals(this.getPageCache().get(PAGE_ITEM))) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"elicit_data"});
            return;
        }
        ArrayList<Integer> rows = new ArrayList<Integer>(10);
        ArrayList exids = new ArrayList(10);
        Object expandNodes = treeEntry.getExpandNodes();
        if (Objects.nonNull(expandNodes)) {
            exids.addAll((List)expandNodes);
        }
        while (CollectionUtils.isNotEmpty(exids)) {
            DynamicObjectCollection objs = this.getModel().getEntryEntity(TREE_ENTITY);
            for (int i = 1; i < objs.size(); ++i) {
                if (!exids.contains(((DynamicObject)objs.get(i)).getString(ID))) continue;
                rows.add(i);
                exids.remove(((DynamicObject)objs.get(i)).getString(ID));
                break;
            }
            if (CollectionUtils.isEmpty(rows)) break;
            for (Integer rid : rows) {
                this.addChildRows(rid);
            }
            rows.clear();
        }
        this.updateCheckStatusView();
        this.dealDataLockStage();
    }

    private int[] addChildRows(int rowKey) {
        DynamicObject obj = this.getModel().getEntryRowEntity(TREE_ENTITY, rowKey);
        if (obj == null) {
            return new int[0];
        }
        long pid = (Long)obj.get(ID);
        try {
            DynamicObject next = this.getModel().getEntryRowEntity(TREE_ENTITY, rowKey + 1);
            if (next != null && next.getLong("pid") == pid && StringUtils.isNotBlank((CharSequence)next.getString("number"))) {
                return new int[0];
            }
        }
        catch (Exception t) {
            log.error(String.format("MergeControlListPlugin - addChildRows:%n%s", ThrowableHelper.toString((Exception)t)));
        }
        Long modelId = this.getCtrlId("model");
        Long sceneId = this.getCtrlId("scenario");
        Long yearId = this.getCtrlId("year");
        Long periodId = this.getCtrlId("period");
        if (modelId == null || sceneId == null || yearId == null || periodId == null) {
            return new int[0];
        }
        EntryType entityType = (EntryType)this.getModel().getDataEntityType().getAllEntities().get(TREE_ENTITY);
        DynamicObjectCollection orgChildren = this.mergeService.queryMergeControlEntity(this.getFixedItem(), Long.valueOf(pid), entityType, null, false, this.getProcess(), this.isFromCardMonitor());
        List properties = this.mergeService.getProperties(modelId, sceneId, yearId, periodId, this.isFromCardMonitor());
        return TreeEntryEntityUtil.insertTreeEntry(this.getView(), orgChildren, properties, rowKey, pid, false);
    }

    private void saveUserSelect() {
        String modelId = UserSelectUtil.getF7SelectId(this.getView(), "model");
        String sceneId = UserSelectUtil.getF7SelectId(this.getView(), "scenario");
        String yearId = UserSelectUtil.getF7SelectId(this.getView(), "year");
        String periodId = UserSelectUtil.getF7SelectId(this.getView(), "period");
        String entityId = UserSelectUtil.getF7SelectId(this.getView(), "entity");
        if (StringUtils.isBlank((CharSequence)modelId) || StringUtils.isBlank((CharSequence)sceneId) || StringUtils.isBlank((CharSequence)yearId) || StringUtils.isBlank((CharSequence)periodId) || StringUtils.isBlank((CharSequence)entityId)) {
            return;
        }
        UserSelectModel userModel = new UserSelectModel();
        userModel.setApplication(ModelUtil.queryApp((IFormView)this.getView()));
        userModel.setModel(modelId);
        userModel.setScene(sceneId);
        userModel.setPeriod(periodId);
        userModel.setYear(yearId);
        userModel.setOrg(entityId);
        userModel.setModifier(RequestContext.getOrCreate().getUserId());
        UserSelectUtil.savetUserSelect(userModel);
    }

    private boolean onlySelectedLeafChk() {
        boolean result = true;
        List<DynamicObject> rows = this.getSelectRows();
        if (rows.size() < 2) {
            rows.clear();
            return true;
        }
        long count = rows.stream().filter(t -> !t.getBoolean("isleaf")).count();
        if (count > 0L) {
            result = false;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u660e\u7ec6\u7ec4\u7ec7\u3002", (String)"MergeControlListPlugin_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        rows.clear();
        return result;
    }

    private DynamicObject getSelectRow() {
        if (CollectionUtils.isNotEmpty(this.getSelectRows())) {
            return this.getSelectRows().get(0);
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"MergeControlListPlugin_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    private List<DynamicObject> getSelectRowsFilterVersion() {
        List<Object> selectRows = this.getSelectRows();
        if (MergeControlHelper.isQuoteScene((Long)this.getCtrlId("model"), (Long)this.getCtrlId("scenario"))) {
            selectRows = selectRows.stream().filter(d -> d.getBoolean("isversioned")).collect(Collectors.toList());
        }
        return selectRows;
    }

    private List<DynamicObject> getSelectRows() {
        int[] rs;
        ArrayList<DynamicObject> rows = new ArrayList<DynamicObject>(10);
        for (int r : rs = this.getTreeSelectedRows()) {
            if (this.getModel().getEntryRowEntity(TREE_ENTITY, r) == null) continue;
            rows.add(this.getModel().getEntryRowEntity(TREE_ENTITY, r));
        }
        if (rows.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"MergeControlListPlugin_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        return rows;
    }

    private int[] getTreeSelectedRows() {
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(TREE_ENTITY);
        return treeEntry.getSelectRows();
    }

    private String getProcess() {
        return (String)this.getModel().getValue(PROCESS);
    }

    private DynamicObject getCtrl(String ctl) {
        return (DynamicObject)this.getModel().getValue(ctl);
    }

    private Long getCtrlId(String ctl) {
        DynamicObject obj = this.getCtrl(ctl);
        return obj != null ? Long.valueOf(obj.getLong(ID)) : null;
    }

    private String getCtrlNumber(String ctl) {
        DynamicObject obj = this.getCtrl(ctl);
        return obj != null ? obj.getString("number") : null;
    }

    private void executeCslInOne(MergeCondition condition) {
        DynamicObject selectRow = this.getSelectRow();
        long orgId = selectRow.getLong(ID);
        String orgNumber = selectRow.getString("number");
        FixedItem fixedItem = this.getFixedItem();
        fixedItem.setOrg(SimpleItem.newOne((Object)orgId, (String)orgNumber));
        ResultBox result = this.mergeService.checkOnProcessing(fixedItem);
        if (result.isSuccess()) {
            Long mergeProgressId = this.mergeService.executeCslInOne(fixedItem, condition);
            if (mergeProgressId != null) {
                this.showMergeProgress(mergeProgressId);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5408\u5e76\u8fdb\u5ea6\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u6267\u884c\u201d\u667a\u80fd\u5408\u5e76\u201c\u64cd\u4f5c\u3002", (String)"MergeControlListPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        } else {
            this.getView().showTipNotification(result.getMessageText());
        }
    }

    private void executeCalculateByTaskJob(MergeCondition condition) {
        FixedItem fixedItem = this.getFixedItem();
        List orgList = this.getSelectRowsFilterVersion().stream().sorted(Comparator.comparingInt(t -> t.getInt("level")).reversed()).map(r -> SimpleItem.newOne((Object)r.getLong(ID), (String)r.getString("number"))).collect(Collectors.toList());
        fixedItem.setOrgList(orgList);
        RealTimeJobHelper.createTask((AbstractFormPlugin)this, condition, fixedItem, "1");
    }

    private void executeConvertByTaskJob(MergeCondition condition) {
        FixedItem fixedItem = this.getFixedItem();
        List orgList = this.getSelectRowsFilterVersion().stream().sorted(Comparator.comparingInt(t -> t.getInt("level")).reversed()).map(r -> SimpleItem.newOne((Object)r.getLong(ID), (String)r.getString("number"))).collect(Collectors.toList());
        fixedItem.setOrgList(orgList);
        RealTimeJobHelper.createTask((AbstractFormPlugin)this, condition, fixedItem, "2");
    }

    private void stageOp(Map<String, Object> resultMap) {
        FixedItem fixedItem = this.getFixedItem();
        List orgList = this.getSelectRows().stream().map(r -> SimpleItem.newOne((Object)r.getLong(ID), (String)r.getString("number"))).collect(Collectors.toList());
        fixedItem.setOrgList(orgList);
        String opType = (String)resultMap.get("stageoptype");
        String includeSon = (String)resultMap.get("includeson");
        String stageId = (String)resultMap.get("stageId");
        StageOpTypeEnum opEnum = StageOpTypeEnum.getEnumByCode((String)opType);
        String opTypeText = "";
        String opTypeItem = "";
        if (opEnum != null) {
            opTypeText = opEnum.getText();
            opTypeItem = opEnum.getItem();
        }
        ResultBox result = (ResultBox)MethodOpProxy.createInstance(this.getBizAppId(), fixedItem.getModelNum(), this.getClass(), opTypeItem).executeWithResult(() -> this.mergeService.stageOp(fixedItem, resultMap));
        StringBuilder message = new StringBuilder();
        message.append(fixedItem.getScenarioNum()).append(" ");
        message.append(fixedItem.getFyNum()).append(" ");
        message.append(fixedItem.getPeriodNum()).append(" ");
        if (StringUtils.isNotBlank((CharSequence)stageId)) {
            DynamicObject stage = StageServiceHelper.getStageById((long)LongUtil.toLong((Object)stageId));
            message.append(stage.getString(FIELD_NAME)).append(" ");
        }
        DynamicObject selectRow = this.getSelectRow();
        String number = selectRow.getString("number");
        String name = selectRow.getString(FIELD_NAME);
        message.append(number).append(" ").append(name);
        if (this.getSelectRows().size() > 1) {
            message.append(" ").append(String.format(ResManager.loadKDString((String)"\u53ca\u6240\u6709\u9009\u62e9\u7684%d\u5bb6\u7ec4\u7ec7", (String)"MergeControlListPlugin_34", (String)"fi-bcm-formplugin", (Object[])new Object[0]), this.getSelectRows().size()));
        }
        if ("2".equals(includeSon)) {
            message.append(ResManager.loadKDString((String)"\u76f4\u63a5\u4e0b\u7ea7", (String)"MergeControlListPlugin_35", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        } else if ("3".equals(includeSon)) {
            message.append(ResManager.loadKDString((String)"\u6240\u6709\u4e0b\u7ea7", (String)"MergeControlListPlugin_36", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (result.isSuccess()) {
            String msg = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5df2\u5b8c\u6210\u3002", (String)"MergeControlListPlugin_31", (String)"fi-bcm-formplugin", (Object[])new Object[0]), opTypeText);
            this.getView().showSuccessNotification(msg);
            message.append(msg);
        } else {
            String title = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5b58\u5728\u672a\u5904\u7406\u7684\u8bb0\u5f55\u3002", (String)"MergeControlListPlugin_32", (String)"fi-bcm-formplugin", (Object[])new Object[0]), opTypeText);
            List messageList = result.getMessageList();
            List msgs = messageList.stream().map(MessageInfo::getMessage).collect(Collectors.toList());
            this.getView().showMessage(title, Joiner.on((String)"\n").join(msgs), MessageTypes.Default);
            message.append(title).append(" ");
            message.append(Joiner.on((String)"\n").join(msgs));
        }
        if (opEnum != null) {
            this.writeMultiLangLog(OpNameMultiLangEnumBridge.genOpNameBridge((MultiLangEnumBridge)opEnum.getBridge(), (String)opEnum.getItem()), OPDescMultiLangEnumBridge.genUnTransBridge((String)message.toString()));
        }
        this.reloadAllData();
    }

    private void archive() {
        FixedItem fixedItem = this.getFixedItem();
        List orgList = this.getSelectRows().stream().map(r -> SimpleItem.newOne((Object)r.getLong(ID), (String)r.getString("number"))).collect(Collectors.toList());
        fixedItem.setOrgList(orgList);
        ResultBox result = this.mergeService.archive(fixedItem);
        StringBuilder message = new StringBuilder();
        message.append(fixedItem.getScenarioNum()).append(" ");
        message.append(fixedItem.getFyNum()).append(" ");
        message.append(fixedItem.getPeriodNum()).append(" ");
        DynamicObject selectRow = this.getSelectRow();
        String number = selectRow.getString("number");
        String name = selectRow.getString(FIELD_NAME);
        message.append(number).append(" ").append(name);
        if (this.getSelectRows().size() > 1) {
            message.append(" ").append(String.format(ResManager.loadKDString((String)"\u53ca\u6240\u6709\u9009\u62e9\u7684%d\u5bb6\u7ec4\u7ec7", (String)"MergeControlListPlugin_34", (String)"fi-bcm-formplugin", (Object[])new Object[0]), this.getSelectRows().size()));
        }
        if (result.isSuccess()) {
            String msg = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5df2\u5b8c\u6210\u3002", (String)"MergeControlListPlugin_31", (String)"fi-bcm-formplugin", (Object[])new Object[0]), OpItemEnum.ARCHIVE.getName());
            this.getView().showSuccessNotification(msg);
            message.append(msg);
        } else {
            String title = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5b58\u5728\u672a\u5904\u7406\u7684\u8bb0\u5f55\u3002", (String)"MergeControlListPlugin_32", (String)"fi-bcm-formplugin", (Object[])new Object[0]), OpItemEnum.ARCHIVE.getName());
            List messageList = result.getMessageList();
            List msgs = messageList.stream().map(MessageInfo::getMessage).collect(Collectors.toList());
            this.getView().showMessage(title, Joiner.on((String)"\n").join(msgs), MessageTypes.Default);
            message.append(title).append(" ");
            message.append(Joiner.on((String)"\n").join(msgs));
        }
        this.writeMultiLangLog(OpNameMultiLangEnumBridge.genOpNameBridge((MultiLangEnumBridge)OpItemEnum.ARCHIVE.getMultiLangEnumBridge(), (String)"Archive"), OPDescMultiLangEnumBridge.genUnTransBridge((String)message.toString()));
        this.reloadAllData();
    }

    private void cancelArchive() {
        FixedItem fixedItem = this.getFixedItem();
        List orgList = this.getSelectRows().stream().map(r -> SimpleItem.newOne((Object)r.getLong(ID), (String)r.getString("number"))).collect(Collectors.toList());
        fixedItem.setOrgList(orgList);
        ResultBox result = this.mergeService.cancelArchive(fixedItem);
        StringBuilder message = new StringBuilder();
        message.append(fixedItem.getScenarioNum()).append(" ");
        message.append(fixedItem.getFyNum()).append(" ");
        message.append(fixedItem.getPeriodNum()).append(" ");
        DynamicObject selectRow = this.getSelectRow();
        String number = selectRow.getString("number");
        String name = selectRow.getString(FIELD_NAME);
        message.append(number).append(" ").append(name);
        if (this.getSelectRows().size() > 1) {
            message.append(" ").append(String.format(ResManager.loadKDString((String)"\u53ca\u6240\u6709\u9009\u62e9\u7684%d\u5bb6\u7ec4\u7ec7", (String)"MergeControlListPlugin_34", (String)"fi-bcm-formplugin", (Object[])new Object[0]), this.getSelectRows().size()));
        }
        if (result.isSuccess()) {
            String msg = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5df2\u5b8c\u6210\u3002", (String)"MergeControlListPlugin_31", (String)"fi-bcm-formplugin", (Object[])new Object[0]), OpItemEnum.CANCEL_ARCHIVE.getName());
            this.getView().showSuccessNotification(msg);
            message.append(msg);
        } else {
            String title = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5b58\u5728\u672a\u5904\u7406\u7684\u8bb0\u5f55\u3002", (String)"MergeControlListPlugin_32", (String)"fi-bcm-formplugin", (Object[])new Object[0]), OpItemEnum.CANCEL_ARCHIVE.getName());
            List messageList = result.getMessageList();
            List msgs = messageList.stream().map(MessageInfo::getMessage).collect(Collectors.toList());
            this.getView().showMessage(title, Joiner.on((String)"\n").join(msgs), MessageTypes.Default);
            message.append(title).append(" ");
            message.append(Joiner.on((String)"\n").join(msgs));
        }
        this.writeMultiLangLog(OpNameMultiLangEnumBridge.genOpNameBridge((MultiLangEnumBridge)OpItemEnum.CANCEL_ARCHIVE.getMultiLangEnumBridge(), (String)"Unarchive"), OPDescMultiLangEnumBridge.genUnTransBridge((String)message.toString()));
        this.reloadAllData();
    }

    private void chkCheck() {
        boolean containsParent = false;
        FixedItem fixedItem = this.getFixedItem();
        List orgList = this.getSelectRows().stream().map(r -> SimpleItem.newOne((Object)r.getLong(ID), (String)r.getString("number"))).collect(Collectors.toList());
        Map mcStatusMap = MergeStatusHelper.batchGetMcStatus((Long)fixedItem.getModelId(), (Long)fixedItem.getScenarioId(), (Long)fixedItem.getFyId(), (Long)fixedItem.getPeriodId(), (Collection)orgList.stream().map(o -> (Long)o.getId()).collect(Collectors.toList()));
        boolean hasFlowSubmit = mcStatusMap.values().stream().anyMatch(s -> s.getFlow().isSubmitOrApproval());
        if (hasFlowSubmit) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u7ec4\u7ec7\u7684\u9ed8\u8ba4\u5e01\u6d41\u7a0b\u72b6\u6001\u4e3a\u201c\u5df2\u5ba1\u6279\u201d\u6216\u201c\u5df2\u63d0\u4ea4\u201d\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u52fe\u7a3d\u68c0\u67e5\u3002", (String)"MergeControlListPlugin_41", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        for (DynamicObject row : this.getSelectRows()) {
            if (row.getBoolean("isleaf")) continue;
            containsParent = true;
            break;
        }
        if (!this.getSelectRow().getBoolean("isleaf") || containsParent) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("bcm_checkconfirm");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ITEM_CHKCHECK);
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(showParameter);
        } else {
            this.checkUpChk(false);
        }
    }

    private void checkUpChk(boolean containsChild) {
        FixedItem fixedItem = this.getFixedItem();
        List orgList = this.getSelectRows().stream().map(r -> SimpleItem.newOne((Object)r.getLong(ID), (String)r.getString("number"))).collect(Collectors.toList());
        fixedItem.setOrgList(orgList);
        this.mergeService.batchCheckUpChk(fixedItem, containsChild, "0");
        String msg = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u6267\u884c\u4e2d\uff0c\u7a0d\u540e\u53ef\u4ee5\u901a\u8fc7\u5237\u65b0\u67e5\u770b\u6267\u884c\u72b6\u6001\uff0c\u6216\u8005\u5728\u5408\u5e76\u6267\u884c\u65e5\u5fd7\u4e2d\u67e5\u770b\u6267\u884c\u7ed3\u679c\u3002", (String)"MergeControlListPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]), OpItemEnum.EXEC_CHKCHECK.getName());
        this.getView().showSuccessNotification(msg);
    }

    private void openSelectOrgForm(String itemKey) {
        List<DynamicObject> dyns = this.getSelectRows();
        boolean existUnitOrg = dyns.stream().anyMatch(s -> s.getBoolean("isleaf") == Boolean.FALSE.booleanValue());
        if (existUnitOrg) {
            FormShowParameter param = new FormShowParameter();
            param.setFormId("bcm_confirm_copyhis");
            param.setCustomParam("operationKey", (Object)itemKey);
            if (dyns.size() == 1 && "Entity".equals(dyns.get(0).get("number"))) {
                param.setCustomParam("isOnlyEntity", (Object)"true");
            }
            param.setCaption(ResManager.loadKDString((String)"\u64cd\u4f5c\u786e\u8ba4", (String)"PeriodSettingPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, itemKey));
            param.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(param);
        } else {
            this.updateCheckStatus(itemKey, Boolean.FALSE);
        }
    }

    private void updateCheckStatus(String itemKey, Boolean includeChildren) {
        boolean isComplete = Objects.equals(itemKey, ITEM_COMPLETECHECK);
        FixedItem fixedItem = this.getFixedItem();
        List orgList = this.getSelectRows().stream().map(r -> SimpleItem.newOne((Object)r.getLong(ID), (String)r.getString("number"))).collect(Collectors.toList());
        fixedItem.setOrgList(orgList);
        ResultBox result = this.mergeService.updateCheckStatus(fixedItem, isComplete, includeChildren);
        String opName = isComplete ? OpItemEnum.EXEC_COMPLETECHECK.getName() : OpItemEnum.EXEC_UNCHECK.getName();
        boolean success = true;
        if (result.isSuccess()) {
            String msg = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u64cd\u4f5c\u6210\u529f\u3002", (String)"MergeControlListPlugin_56", (String)"fi-bcm-formplugin", (Object[])new Object[0]), opName);
            this.getView().showSuccessNotification(msg);
        } else {
            success = false;
            List messageList = result.getMessageList();
            String title = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5b58\u5728\u8df3\u8fc7\u7684\u8bb0\u5f55\u3002", (String)"MergeControlListPlugin_57", (String)"fi-bcm-formplugin", (Object[])new Object[0]), opName);
            List tipMsgList = messageList.stream().map(MessageInfo::getMessage).collect(Collectors.toList());
            this.getView().showMessage(title, Joiner.on((String)"\n").join(tipMsgList), MessageTypes.Default);
        }
        StringBuilder oplog = new StringBuilder();
        oplog.append(fixedItem.getScenarioNum()).append(" ");
        oplog.append(fixedItem.getFyNum()).append(" ");
        oplog.append(fixedItem.getPeriodNum()).append(" ");
        Collection itemOrgList = fixedItem.getOrgList();
        DynamicObject selectRow = this.getSelectRow();
        String number = selectRow.getString("number");
        String name = selectRow.getString(FIELD_NAME);
        oplog.append(number).append(" ").append(name);
        if (itemOrgList.size() > 1) {
            oplog.append(" ").append(String.format(ResManager.loadKDString((String)"\u53ca\u6240\u6709\u9009\u62e9\u7684%d\u5bb6\u7ec4\u7ec7", (String)"MergeControlListPlugin_34", (String)"fi-bcm-formplugin", (Object[])new Object[0]), this.getSelectRows().size()));
        }
        oplog.append(opName).append(success ? ResultStatusEnum.SUCCESS.getName() : ResultStatusEnum.FAIL.getName());
        OperationLogUtil.writeOperationLog((String)opName, (String)oplog.toString(), (Long)fixedItem.getModelId(), (String)"bcm_mergecontrollist");
        this.reloadAllData();
    }

    private void updateCheckStatusView() {
        Pair cm044SceneSetting = ConfigServiceHelper.getCM044SceneSetting((Long)this.getModelId());
        boolean checkParam = false;
        String sceneNumber = this.getCtrlNumber("scenario");
        if (((Boolean)cm044SceneSetting.p1).booleanValue()) {
            checkParam = true;
            for (SceneSettingVo sceneSettingVo : (List)cm044SceneSetting.p2) {
                if (!sceneSettingVo.getSceneNumber().equals(sceneNumber) || !CM053TypeEnum.EXCEPTION.getValue().equals(sceneSettingVo.getType())) continue;
                checkParam = false;
                break;
            }
        }
        this.getView().setVisible(Boolean.valueOf(checkParam), new String[]{"checkstatus"});
        this.getView().setVisible(Boolean.valueOf(checkParam), new String[]{ITEM_COMPLETECHECK, ITEM_UNAUDIT});
        this.getView().updateView("entity");
    }

    @Override
    protected Map<String, Object> getF7CustomData(String f7Key) {
        if ("entity".equals(f7Key)) {
            HashMap<String, Object> customData = new HashMap<String, Object>(16);
            DynamicObject yearDy = this.getCtrl("year");
            String periodId = UserSelectUtil.getF7SelectId(this.getView(), "period");
            DynamicObject scenarioDy = this.getCtrl("scenario");
            if (yearDy != null) {
                customData.put("yearNum", yearDy.getString("number"));
                customData.put("yearId", yearDy.getLong(ID));
            }
            if (periodId != null) {
                customData.put("periodId", periodId);
            }
            if (scenarioDy != null) {
                customData.put("scenarioId", scenarioDy.getLong(ID));
            }
            customData.put("isContainShare", true);
            customData.put("disableRateCls", true);
            if ("show_table".equals(this.getPageCache().get(PAGE_ITEM))) {
                customData.put("selectMemberCheckPerm", false);
            }
            customData.put("org_fuzzySearch_flag", 1);
            return customData;
        }
        return Collections.emptyMap();
    }

    private void versioned(Map<String, Object> resultMap) {
        FixedItem fixedItem = this.getFixedItem();
        List orgList = this.getSelectRows().stream().map(r -> SimpleItem.newOne((Object)r.getLong(ID), (String)r.getString("number"))).collect(Collectors.toList());
        fixedItem.setOrgList(orgList);
        ResultBox result = this.mergeService.versioned(fixedItem, resultMap);
        StringBuilder message = new StringBuilder();
        message.append(this.getCtrlNumber("scenario")).append(" ").append(this.getCtrlNumber("year")).append(" ").append(this.getCtrlNumber("period")).append(" ");
        DynamicObject selectRow = this.getSelectRow();
        String number = selectRow.getString("number");
        String name = selectRow.getString(FIELD_NAME);
        message.append(number).append(" ").append(name);
        if (this.getSelectRows().size() > 1) {
            message.append(" ").append(String.format(ResManager.loadKDString((String)"\u53ca\u6240\u6709\u9009\u62e9\u7684%d\u5bb6\u7ec4\u7ec7", (String)"MergeControlListPlugin_34", (String)"fi-bcm-formplugin", (Object[])new Object[0]), this.getSelectRows().size()));
        }
        if (result.isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7248\u672c\u5316\u6210\u529f\u3002", (String)"MergeControlListPlugin_64", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            message.append(OpItemEnum.VERSION.getName()).append(ResultStatusEnum.SUCCESS.getName());
        } else {
            String title = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5b58\u5728\u672a\u5904\u7406\u7684\u8bb0\u5f55\u3002", (String)"MergeControlListPlugin_32", (String)"fi-bcm-formplugin", (Object[])new Object[0]), OpItemEnum.VERSION.getName());
            List messageList = result.getMessageList();
            List msgErrorS = messageList.stream().map(MessageInfo::getMessage).collect(Collectors.toList());
            this.getView().showMessage(title, Joiner.on((String)"\n").join(msgErrorS), MessageTypes.Default);
            message.append(OpItemEnum.VERSION.getName()).append(ResultStatusEnum.FAIL.getName());
        }
        this.writeMultiLangLog(OpNameMultiLangEnumBridge.genOpNameBridge((MultiLangEnumBridge)OpItemEnum.VERSION.getMultiLangEnumBridge(), (String)"Versioning"), OPDescMultiLangEnumBridge.genUnTransBridge((String)message.toString()));
        this.reloadAllData();
    }

    private void cancelVersioned(Map<String, Object> resultMap) {
        FixedItem fixedItem = this.getFixedItem();
        List orgList = this.getSelectRows().stream().map(r -> SimpleItem.newOne((Object)r.getLong(ID), (String)r.getString("number"))).collect(Collectors.toList());
        fixedItem.setOrgList(orgList);
        ResultBox result = this.mergeService.cancelVersioned(fixedItem, resultMap);
        StringBuilder message = new StringBuilder();
        message.append(this.getCtrlNumber("scenario")).append(" ").append(this.getCtrlNumber("year")).append(" ").append(this.getCtrlNumber("period")).append(" ");
        DynamicObject selectRow = this.getSelectRow();
        String number = selectRow.getString("number");
        String name = selectRow.getString(FIELD_NAME);
        message.append(number).append(" ").append(name);
        if (result.isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u7248\u672c\u5316\u6210\u529f\u3002", (String)"MergeControlListPlugin_65", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            message.append(OpItemEnum.CANCELVERSION.getName()).append(ResultStatusEnum.SUCCESS.getName());
        } else {
            String title = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5b58\u5728\u672a\u5904\u7406\u7684\u8bb0\u5f55\u3002", (String)"MergeControlListPlugin_32", (String)"fi-bcm-formplugin", (Object[])new Object[0]), OpItemEnum.CANCELVERSION.getName());
            List messageList = result.getMessageList();
            List msgErrorS = messageList.stream().map(MessageInfo::getMessage).collect(Collectors.toList());
            this.getView().showMessage(title, Joiner.on((String)"\n").join(msgErrorS), MessageTypes.Default);
            message.append(OpItemEnum.CANCELVERSION.getName()).append(ResultStatusEnum.FAIL.getName());
        }
        this.writeMultiLangLog(OpNameMultiLangEnumBridge.genOpNameBridge((MultiLangEnumBridge)OpItemEnum.CANCELVERSION.getMultiLangEnumBridge(), (String)"Unversion"), OPDescMultiLangEnumBridge.genUnTransBridge((String)message.toString()));
        this.reloadAllData();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        try {
            FormView formView = (FormView)e.getSource();
            FormUserConfig service = (FormUserConfig)formView.getService(IFormUserConfig.class);
            UserConfig gridConfig = service.loadUserConfig(UserConfigUtils.buildUserConfigKey((String)formView.getFormId(), (String)TREE_ENTITY));
            String treeEntitySetting = gridConfig.getSetting();
            if (!StringUtils.isEmpty((CharSequence)treeEntitySetting)) {
                UserConfigServiceHelper.clearSetting((long)RequestContext.get().getCurrUserId(), (String)UserConfigUtils.buildUserConfigKey((String)formView.getFormId(), (String)TREE_ENTITY));
            }
        }
        catch (Exception ex) {
            log.error("clearTableSetting error", (Throwable)ex);
        }
    }

    private void reminder(String itemKey) {
        String status;
        OpNameMultiLangEnumBridge opName;
        String resultMsg = null;
        DynamicObject currentOrg = this.getSelectRow();
        if (Objects.equals(ITEM_MERGEREMINDER, itemKey)) {
            this.mergeService.mergeReminder(this.getFixedItem(), currentOrg);
            opName = OpNameMultiLangEnumBridge.genOpNameBridge((MultiLangEnumBridge)OpItemEnum.MERGE_REMINDER.getMultiLangEnumBridge(), (String)"Merge Remind");
        } else {
            resultMsg = this.mergeService.taskReminder(this.getFixedItem(), currentOrg);
            opName = OpNameMultiLangEnumBridge.genOpNameBridge((MultiLangEnumBridge)OpItemEnum.TASK_REMINDER.getMultiLangEnumBridge(), (String)"Task Remind");
        }
        if (StringUtils.isNotEmpty((CharSequence)resultMsg)) {
            this.getView().showTipNotification(resultMsg);
            status = ResultStatusEnum.FAIL.getName() + ":" + resultMsg;
        } else {
            resultMsg = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u64cd\u4f5c\u6210\u529f\u3002", (String)"MergeControlListPlugin_56", (String)"fi-bcm-formplugin", (Object[])new Object[0]), opName.loadKDString());
            this.getView().showSuccessNotification(resultMsg);
            status = ResultStatusEnum.SUCCESS.getName();
        }
        String opDescription = String.format("%1$s %2$s %3$s %4$s%5$s", currentOrg.getString("number"), this.getCtrlNumber("year"), this.getCtrlNumber("period"), opName, status);
        this.writeMultiLangLog(opName, OPDescMultiLangEnumBridge.genUnTransBridge((String)opDescription));
    }

    private boolean isFromCardMonitor() {
        return this.getPlugin() instanceof MergeMonitorPlugin;
    }

    private void showDataLockArchive() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bcm_datalockbackup");
        showParameter.setPageId(this.getView().getPageId() + "bcm_datalockbackup");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.getOpenStyle().setTargetKey("_submaintab_");
        showParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        showParameter.setCaption(ResManager.loadKDString((String)"\u5206\u6bb5\u5f52\u6863", (String)"SceneEnableStageList_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        this.getView().showForm(showParameter);
    }
}

