/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.mergecontrol;

import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.login.actions.SerializationUtils;
import kd.fi.bcm.business.mergecontrol.MergeCondition;
import kd.fi.bcm.business.mergecontrol.MergeControlService;
import kd.fi.bcm.business.model.FixedItem;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.taskmanage.helper.TaskRecordServiceHelper;
import kd.fi.bcm.common.config.CM053SettingEnum;
import kd.fi.bcm.common.enums.config.ConfigEnum;
import kd.fi.bcm.common.util.BlackListUtils;

public class MergeOneConfirmPlugin
extends AbstractFormPlugin {
    private final MergeControlService mergeService = MergeControlService.getInstance();

    public void initialize() {
        if (BlackListUtils.hasFeatureInCm((String)"CMTra")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap5"});
        }
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btn_close", "btn_ok"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String scope;
        String propName = e.getProperty().getName();
        if ("mergeradiogroup".equals(propName)) {
            String newV = (String)e.getChangeSet()[0].getNewValue();
            this.getModel().setValue("ecradiogroup", (Object)newV);
            this.getModel().setValue("pcradiogroup", (Object)newV);
            this.getView().setEnable(Boolean.valueOf(newV.equals("1")), new String[]{"ecradiogroup", "pcradiogroup"});
        } else if ("mergescopegroup".equals(propName) && "2".equals(scope = (String)e.getChangeSet()[0].getNewValue())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u76f4\u63a5\u4e0b\u7ea7\u7ec4\u7ec7\u7684\u6570\u636e\u4e3a\u6700\u8fd1\u4e00\u6b21\u5408\u5e76\u6216\u8ba1\u7b97\u7ed3\u679c\uff0c\u53ef\u80fd\u672a\u5305\u542b\u5176\u4e0b\u7ea7\u6240\u6709\u6210\u5458\u7684\u6700\u65b0\u6570\u636e\u3002", (String)"MergeOneConfirmPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private void fillConfirmData(MergeCondition condition) {
        condition.setMergeScope(this.getModel().getDataEntity().getInt("mergescopegroup"));
        condition.setMergeCondition(this.getModel().getDataEntity().getInt("mergeradiogroup"));
        condition.setEcRuleCondition(this.getModel().getDataEntity().getInt("ecradiogroup"));
        condition.setPcRuleCondition(this.getModel().getDataEntity().getInt("pcradiogroup"));
        condition.setInterCheckCondition(this.getModel().getDataEntity().getInt("chkradiogroup"));
        condition.setInvElimCondition(this.getModel().getDataEntity().getInt("rightoffsetgroup"));
        condition.setCommonPaperElimCondition(this.getModel().getDataEntity().getInt("commonpapergroup"));
        condition.setIntrElimCondition(this.getModel().getDataEntity().getInt("intrradiogroup"));
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey().toLowerCase(Locale.ENGLISH);
        MergeCondition condition = new MergeCondition();
        switch (key) {
            case "btn_ok": {
                if (!this.checkOrgStatusAndTip()) break;
                this.fillConfirmData(condition);
                this.getView().returnDataToParent((Object)condition);
                this.getView().close();
                break;
            }
            case "btn_close": {
                condition.setConfirmed(false);
                this.getView().returnDataToParent((Object)condition);
                this.getView().close();
                break;
            }
            default: {
                condition.setConfirmed(false);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (Objects.equals(callBackId, "checkflowstatus") && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            MergeCondition condition = new MergeCondition();
            this.fillConfirmData(condition);
            this.getView().returnDataToParent((Object)condition);
            this.getView().close();
        }
        if (Objects.equals(callBackId, "forbiddenMerge")) {
            this.getView().close();
        }
    }

    private boolean checkOrgStatusAndTip() {
        FixedItem fixedItem = (FixedItem)SerializationUtils.deSerializeFromBase64((String)((String)this.getView().getFormShowParameter().getCustomParam("ctxContext")));
        CM053SettingEnum settingEnum = ConfigServiceHelper.checkCM053SceneSetting((Long)fixedItem.getModelId(), (Long)fixedItem.getScenarioId());
        if (settingEnum != CM053SettingEnum.NOT_CONTROL) {
            boolean boolParam = ConfigServiceHelper.getBoolParam((Long)fixedItem.getModelId(), (String)ConfigEnum.IS_CHECK_REPORTSSTATUS.getNumber());
            int mergeScope = this.getModel().getDataEntity().getInt("mergescopegroup");
            List unCommitOrgList = this.mergeService.getUnCommitOrgs(fixedItem, mergeScope);
            Set<Long> unCommitIds = unCommitOrgList.stream().map(s -> (Long)s.p1).collect(Collectors.toSet());
            if (boolParam) {
                Set<Long> unCommitReportIds = this.getUnCommitReportIds(unCommitIds, fixedItem);
                String info = unCommitOrgList.stream().filter(o -> unCommitReportIds.contains(o.p1)).map(s -> (String)s.p2 + " " + (String)s.p3).collect(Collectors.joining("\n"));
                if (unCommitReportIds.size() > 0) {
                    this.oneKeyMergeConfirm(info, unCommitReportIds.size(), settingEnum, true);
                    return false;
                }
            } else if (unCommitIds.size() > 0) {
                String info = unCommitOrgList.stream().map(s -> (String)s.p2 + " " + (String)s.p3).collect(Collectors.joining("\n"));
                this.oneKeyMergeConfirm(info, unCommitIds.size(), settingEnum, false);
                return false;
            }
        }
        return true;
    }

    private Set<Long> getUnCommitReportIds(Set<Long> unCommitIds, FixedItem fixedItem) {
        Map orgCommitStatusMap = TaskRecordServiceHelper.getOrgDisReportCommitStatusMap((long)fixedItem.getModelId(), (long)fixedItem.getScenarioId(), (long)fixedItem.getFyId(), (long)fixedItem.getPeriodId(), unCommitIds);
        orgCommitStatusMap.entrySet().removeIf(Map.Entry::getValue);
        return orgCommitStatusMap.keySet();
    }

    private void oneKeyMergeConfirm(String detailMsg, int count, CM053SettingEnum settingEnum, boolean showReport) {
        if (settingEnum == CM053SettingEnum.ONLY_TIP) {
            String msg = showReport ? String.format(ResManager.loadKDString((String)"\u5b58\u5728\u7ec4\u7ec7\u672a\u63d0\u4ea4\uff0c\u5176\u4e2d%1$s\u5bb6\u7ec4\u7ec7\u62a5\u8868\u672a\u4e0a\u62a5\u5b8c\u6574\uff0c\u662f\u5426\u7ee7\u7eed\u667a\u80fd\u5408\u5e76\uff1f", (String)"MergeOneConfirmPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), count) : String.format(ResManager.loadKDString((String)"%1$s\u5bb6\u4e0b\u7ea7\u7ec4\u7ec7\u6d41\u7a0b\u72b6\u6001\u672a\u63d0\u4ea4\uff0c\u662f\u5426\u7ee7\u7eed\u667a\u80fd\u5408\u5e76\uff1f", (String)"MergeOneConfirmPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), count);
            this.getView().showConfirm(msg, detailMsg, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("checkflowstatus", (IFormPlugin)this));
        } else {
            String msg = showReport ? String.format(ResManager.loadKDString((String)"%s \u5bb6\u4e0b\u7ea7\u7ec4\u7ec7\u62a5\u8868\u5c1a\u672a\u4e0a\u62a5\uff0c\u4e0d\u5141\u8bb8\u667a\u80fd\u5408\u5e76\u3002", (String)"MergeOneConfirmPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), count) : String.format(ResManager.loadKDString((String)"%s \u5bb6\u4e0b\u7ea7\u7ec4\u7ec7\u6d41\u7a0b\u72b6\u6001\u5c1a\u672a\u63d0\u4ea4\uff0c\u4e0d\u5141\u8bb8\u667a\u80fd\u5408\u5e76\u3002", (String)"MergeOneConfirmPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), count);
            this.getView().showConfirm(msg, detailMsg, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("forbiddenMerge", (IFormPlugin)this));
        }
    }
}

