/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.mergecontrol;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.allinone.service.MergeProgressHelper;
import kd.fi.bcm.business.allinone.service.thread.AbortThreadHelper;
import kd.fi.bcm.business.allinone.service.thread.ProcessStatusHeartBeatChecker;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.MergeTaskTypeEnum;
import kd.fi.bcm.common.enums.ProgressStatusEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.util.DateUtils;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.util.OrgUtils;
import kd.fi.bcm.formplugin.util.UserSelectUtil;

public class MergeOperLogListPlugin
extends AbstractBaseListPlugin
implements HyperLinkClickListener,
CreateListDataProviderListener {
    private static final Set<String> f7KEYS = Sets.newHashSet((Object[])new String[]{"model", "scenario", "year", "period", "entity"});
    private static final List<String> dimKeys = Arrays.asList("scenario", "year", "period");
    private static final List<String> alldimKeys = Arrays.asList("scenario", "year", "period", "entity");
    private static final List<String> noLeafKeys = Collections.singletonList("entity");
    private static final String BILL_LIST_AP = "billlistap";
    private boolean setNewModel = true;

    @Override
    public void initialize() {
        HashMap map = new HashMap(16);
        this.asMapF7toType(dimKeys, SingleF7TypeEnum.LEAF, map);
        this.asMapF7toType(noLeafKeys, SingleF7TypeEnum.COMMON, map);
        this.initSingleMemberF7(map);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList billList = (BillList)this.getControl(BILL_LIST_AP);
        billList.addHyperClickListener((HyperLinkClickListener)this);
        billList.addCreateListDataProviderListener((CreateListDataProviderListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        boolean fromMerge;
        super.afterCreateNewData(e);
        Object fromMergeObj = this.getFormCustomParam("fromMerge");
        boolean bl = fromMerge = fromMergeObj != null && Boolean.parseBoolean(fromMergeObj.toString());
        if (fromMerge) {
            this.setDefaultValue();
        } else {
            this.refreshBillByUserSelect(alldimKeys, false);
        }
        BillList billList = (BillList)this.getControl(BILL_LIST_AP);
        billList.addCreateListDataProviderListener((CreateListDataProviderListener)this);
    }

    private void setDefaultValue() {
        this.setDefaultSingleValue("entity", "selectedOrgid");
        this.setDefaultSingleValue("model", "model");
        this.setDefaultSingleValue("scenario", "scenario");
        this.setDefaultSingleValue("year", "year");
        this.setDefaultSingleValue("period", "period");
        this.changeOrgName();
    }

    private void setDefaultSingleValue(String fieldName, String paramName) {
        if (this.getView().getFormShowParameter().getCustomParam(paramName) != null) {
            this.getModel().setValue(fieldName, this.getView().getFormShowParameter().getCustomParam(paramName));
            if ("model".equals(fieldName)) {
                this.getPlugin().getPageCache().put("KEY_MODEL_ID", this.getView().getFormShowParameter().getCustomParam(paramName).toString());
            }
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("refresh".equals(itemKey)) {
            BillList billList = (BillList)this.getControl(BILL_LIST_AP);
            billList.refresh();
            this.checkDeadProcess();
        } else if ("btn_delete".equals(itemKey)) {
            BillList billList = (BillList)this.getControl(BILL_LIST_AP);
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (selectedRows.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8981\u5f3a\u5236\u5931\u8d25\u7684\u8bb0\u5f55\u3002", (String)"MergeOperLogListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u662f\u5426\u5f3a\u5236\u5931\u8d25\u5408\u5e76\u6267\u884c\u65e5\u5fd7\u7684\u8bb0\u5f55\uff1f", (String)"MergeOperLogListPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("action_delete", (IFormPlugin)this));
            }
        } else if ("taskstop".equals(itemKey)) {
            BillList billList = (BillList)this.getControl(BILL_LIST_AP);
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (selectedRows.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8981\u7ec8\u6b62\u7684\u8bb0\u5f55\u3002", (String)"MergeOperLogListPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            } else {
                List<Long> ids = this.getRunRecorderIds(selectedRows);
                if (ids.isEmpty()) {
                    billList.refresh();
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8fd0\u884c\u4e2d\u72b6\u6001\u7684\u8bb0\u5f55\u3002", (String)"MergeOperLogListPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u8bf7\u786e\u5b9a\u662f\u5426\u7ec8\u6b62\u8fd0\u884c\u4e2d\u7684\u667a\u80fd\u5408\u5e76\u8fdb\u7a0b?", (String)"MergeOperLogListPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("action_taskstop", (IFormPlugin)this));
                }
            }
        }
    }

    public List<Long> getRunRecorderIds(ListSelectedRowCollection selectedRows) {
        ArrayList<Long> selectIds = new ArrayList<Long>(10);
        for (ListSelectedRow selectedRow : selectedRows) {
            Long primaryKey = (Long)selectedRow.getPrimaryKeyValue();
            selectIds.add(primaryKey);
        }
        return this.getRunRecorderIds(selectIds);
    }

    protected List<Long> getRunRecorderIds(List<Long> ids) {
        DynamicObjectCollection dos = MergeProgressHelper.queryProgress((String)"id,fstatus", (QFBuilder)new QFBuilder().add("id", "in", ids).add("fstatus", "=", (Object)"1"));
        return dos.stream().map(d -> d.getLong("id")).collect(Collectors.toList());
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        if ("viewlog".equals(e.getOperateKey())) {
            BillList billList = (BillList)this.getControl(BILL_LIST_AP);
            ListSelectedRow currentSelectedRowInfo = billList.getCurrentSelectedRowInfo();
            Object primaryKeyValue = currentSelectedRowInfo.getPrimaryKeyValue();
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("bcm_showbizruleloginfo");
            formShowParameter.setCustomParam("pk", primaryKeyValue);
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(formShowParameter);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("action_delete".equals(messageBoxClosedEvent.getCallBackId())) {
            if ("Yes".equals(messageBoxClosedEvent.getResultValue())) {
                BillList billList = (BillList)this.getControl(BILL_LIST_AP);
                ListSelectedRowCollection selectedRows = billList.getSelectedRows();
                HashSet<Long> deleteIds = new HashSet<Long>(16);
                for (ListSelectedRow lr : selectedRows) {
                    deleteIds.add((Long)lr.getPrimaryKeyValue());
                }
                QFilter qf = new QFilter("id", "in", deleteIds);
                qf.and("fstatus", "in", Arrays.asList(ProgressStatusEnum.FAIL.getCode(), ProgressStatusEnum.SUCCESS.getCode(), ProgressStatusEnum.TERMINATION.getCode()));
                boolean exists = QueryServiceHelper.exists((String)"bcm_mergeprogressentity", (QFilter[])qf.toArray());
                if (exists) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5f3a\u5236\u5931\u8d25\u8fdb\u884c\u4e2d\u6216\u7ec8\u6b62\u4e2d\u7684\u8bb0\u5f55\u3002", (String)"MergeOperLogListPlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                StringJoiner joiner = new StringJoiner(",");
                for (Long pkId : deleteIds) {
                    joiner.add(pkId.toString());
                }
                String deleteSql = "update t_bcm_mergeprogress set fstatus = 3 where fid in (%s)";
                DB.update((DBRoute)BCMConstant.DBROUTE, (String)String.format(deleteSql, joiner));
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"MergeOperLogListPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                OperationLogUtil.writeOperationLog((String)ResManager.loadKDString((String)"\u5f3a\u5236\u5931\u8d25\u5408\u5e76\u6267\u884c\u65e5\u5fd7", (String)"MergeOperLogListPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u5f3a\u5236\u5931\u8d25\u64cd\u4f5c\u6210\u529f", (String)"MergeOperLogListPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (Long)this.getModelId(), (String)this.getView().getModel().getDataEntityType().getName());
                billList.addCreateListDataProviderListener((CreateListDataProviderListener)this);
                billList.setClearSelection(true);
                billList.refresh();
            }
        } else if ("action_taskstop".equals(messageBoxClosedEvent.getCallBackId()) && "Yes".equals(messageBoxClosedEvent.getResultValue())) {
            BillList billList = (BillList)this.getControl(BILL_LIST_AP);
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            List<Long> ids = this.getRunRecorderIds(selectedRows);
            if (!ids.isEmpty()) {
                MergeProgressHelper.updateStatus((String)ProgressStatusEnum.TERMING.getCode(), ids);
                AbortThreadHelper.setMergerProcessAbortFlag(ids);
            }
            billList.addCreateListDataProviderListener((CreateListDataProviderListener)this);
            billList.refresh();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d1\u8d77\u7ec8\u6b62\u6210\u529f\uff0c\u8bf7\u7a0d\u540e\u5237\u65b0\u67e5\u770b\u72b6\u6001\u3002", (String)"MergeOperLogListPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("model".equals(key)) {
            Object newValue = e.getChangeSet()[0].getNewValue();
            if (newValue == null) {
                this.setNewModel = false;
                this.getModel().setValue(key, e.getChangeSet()[0].getOldValue());
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MergeOperLogListPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            IDataModel model = this.getModel();
            if (this.setNewModel) {
                for (String f7key : f7KEYS) {
                    this.cacheControls.remove(f7key);
                }
                model.beginInit();
                model.setValue("scenario", null);
                model.setValue("year", null);
                model.setValue("period", null);
                model.setValue("entity", null);
                model.endInit();
            }
            this.getView().updateView("flexpanelap");
            BillList billList = (BillList)this.getControl(BILL_LIST_AP);
            billList.addCreateListDataProviderListener((CreateListDataProviderListener)this);
            billList.refresh();
            DynamicObject modelDyn = (DynamicObject)model.getValue("model");
            if (modelDyn != null) {
                this.getPageCache().put("KEY_MODEL_ID", modelDyn.getString("id"));
            }
            return;
        }
        if (dimKeys.contains(key)) {
            this.changeOrgName();
        } else if ("entity".equals(key) && e.getChangeSet()[0].getNewValue() != null) {
            DynamicObject oldValue = (DynamicObject)e.getChangeSet()[0].getOldValue();
            DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (oldValue == null || oldValue.getLong("id") != newValue.getLong("id")) {
                this.changeOrgName();
            }
        }
        if (f7KEYS.contains(key)) {
            BillList billList = (BillList)this.getControl(BILL_LIST_AP);
            billList.addCreateListDataProviderListener((CreateListDataProviderListener)this);
            billList.refresh();
            billList.clearSelection();
        }
    }

    private void changeOrgName() {
        DynamicObject scenario = (DynamicObject)this.getValue("scenario");
        DynamicObject year = (DynamicObject)this.getValue("year");
        DynamicObject period = (DynamicObject)this.getValue("period");
        DynamicObject org = (DynamicObject)this.getValue("entity");
        if (scenario != null && year != null && period != null && org != null) {
            OrgUtils.changeOrgName2Dy(this.getModelId(), year.getLong("id"), period.getLong("id"), Collections.singletonList(org), null, false);
            this.getView().updateView("entity");
        }
    }

    protected void geneQFilters(List<QFilter> qFilters, IDataModel dataModel) {
        this.geneBillListQfilter(qFilters, dataModel, "model", "issueid");
        this.geneBillListQfilter(qFilters, dataModel, "scenario", "scenarioid");
        this.geneBillListQfilter(qFilters, dataModel, "year", "yearid");
        this.geneBillListQfilter(qFilters, dataModel, "period", "periodid");
        this.geneBillListQfilter(qFilters, dataModel, "entity", "orgid");
        qFilters.add(new QFilter("deletestatus", "!=", (Object)1));
    }

    protected void geneBillListQfilter(List<QFilter> qFilters, IDataModel dataModel, String property, String qfield) {
        DynamicObject vModel = (DynamicObject)dataModel.getValue(property);
        if (vModel != null) {
            long id = (Long)vModel.getPkValue();
            if ("entity".equals(property)) {
                HashSet<Long> orgIds = new HashSet<Long>(16);
                IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)this.getModelId(), (Long)id);
                IDNumberTreeNode baseOrg = orgNode.isShare() ? orgNode.getBaseTreeNode() : orgNode;
                orgIds.add(baseOrg.getId());
                for (IDNumberTreeNode shareNode : baseOrg.getShareNodes()) {
                    orgIds.add(shareNode.getId());
                }
                qFilters.add(new QFilter(qfield, "in", orgIds));
            } else {
                qFilters.add(new QFilter(qfield, "=", (Object)id));
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        String fieldName = e.getFieldName();
        BillList billList = (BillList)this.getControl(BILL_LIST_AP);
        ListSelectedRow currentSelectedRowInfo = billList.getCurrentSelectedRowInfo();
        Object primaryKeyValue = currentSelectedRowInfo.getPrimaryKeyValue();
        if ("fstatus".equals(fieldName)) {
            DynamicObject queryResult = QueryServiceHelper.queryOne((String)"bcm_mergeprogressentity", (String)"id, failedlog, fstatus, tasktype", (QFilter[])new QFilter[]{QFilter.of((String)"id=?", (Object[])new Object[]{primaryKeyValue})});
            this.showErrorMessage(queryResult);
        } else if ("datasource".equals(fieldName)) {
            this.showDataSetting(primaryKeyValue);
        }
    }

    private void showDataSetting(Object primaryKeyValue) {
        IFormView view = this.getView();
        IFormView parentView = view.getParentView();
        String pageId = view.getPageId() + primaryKeyValue;
        IFormView childView = view.getView(pageId);
        if (childView == null) {
            ListShowParameter listShowParameter = new ListShowParameter();
            listShowParameter.setPageId(pageId);
            listShowParameter.setBillFormId("bcm_mergedatasetlog");
            listShowParameter.setFormId("bos_list");
            listShowParameter.setCaption(ResManager.loadKDString((String)"\u5408\u5e76\u8bbe\u7f6e\u65e5\u5fd7", (String)"MergeOperLogListPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            ListFilterParameter listFilterParameter = new ListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            qFilters.add(new QFilter("logid", "=", primaryKeyValue));
            listShowParameter.setListFilterParameter(listFilterParameter);
            parentView.showForm((FormShowParameter)listShowParameter);
            view.sendFormAction(parentView);
        } else {
            childView.activate();
            view.sendFormAction(childView);
        }
    }

    private void showErrorMessage(DynamicObject obj) {
        if (ProgressStatusEnum.FAIL.getCode().equals(obj.getString("fstatus"))) {
            FormShowParameter param = new FormShowParameter();
            param.setFormId("bcm_showmessage");
            String caption = ResManager.loadKDString((String)"\u5408\u5e76\u5931\u8d25", (String)"MergeOperLogListPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            String tasktype = obj.getString("tasktype");
            if (Objects.equals(tasktype, MergeTaskTypeEnum.Calculate.getCode())) {
                caption = ResManager.loadKDString((String)"\u62a5\u8868\u8ba1\u7b97\u5931\u8d25", (String)"MergeOperLogListPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            } else if (Objects.equals(tasktype, MergeTaskTypeEnum.Convert.getCode())) {
                caption = ResManager.loadKDString((String)"\u62a5\u8868\u6298\u7b97\u5931\u8d25", (String)"MergeOperLogListPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            } else if (Objects.equals(tasktype, MergeTaskTypeEnum.Contribution.getCode())) {
                caption = ResManager.loadKDString((String)"\u5408\u5e76\u8d21\u732e\u5931\u8d25", (String)"MergeOperLogListPlugin_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            }
            param.setCaption(caption);
            param.getOpenStyle().setShowType(ShowType.Modal);
            param.setCustomParam("message", (Object)obj.getString("failedlog"));
            this.getView().showForm(param);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5931\u8d25\u7684\u8bb0\u5f55\u53ef\u4ee5\u8fdb\u884c\u67e5\u770b\u3002", (String)"MergeOperLogListPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    public void createListDataProvider(BeforeCreateListDataProviderArgs args) {
        final ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        IDataModel model = this.getModel();
        this.geneQFilters(filters, model);
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){
            private DynamicSimpleProperty dataSimpleProperty = new DynamicSimpleProperty();
            private DynamicSimpleProperty speedSimpleProperty = new DynamicSimpleProperty();
            {
                this.dataSimpleProperty.setName("datasource");
                this.speedSimpleProperty.setName("speedtime");
            }

            public int getRealCount() {
                return MergeOperLogListPlugin.this.getPageCache().get("realCount") != null ? Integer.parseInt(MergeOperLogListPlugin.this.getPageCache().get("realCount")) : 0;
            }

            public DynamicObjectCollection getData(int arg0, int arg1) {
                if (this.getOrderByExpr() == null) {
                    this.setOrderByExpr("begintime desc");
                }
                List qFilters = this.getQFilters();
                qFilters.addAll(filters);
                this.setQFilters(qFilters);
                int realCount = QueryServiceHelper.query((String)"bcm_mergeprogressentity", (String)"id", (QFilter[])filters.toArray(new QFilter[0])).size();
                MergeOperLogListPlugin.this.getPageCache().put("realCount", String.valueOf(realCount));
                DynamicObjectCollection collection = super.getData(arg0, arg1);
                if (!collection.isEmpty()) {
                    DataEntityPropertyCollection properties = ((DynamicObject)collection.get(0)).getDataEntityType().getProperties();
                    properties.add((Object)this.dataSimpleProperty);
                    properties.add((Object)this.speedSimpleProperty);
                }
                DynamicObject year = (DynamicObject)MergeOperLogListPlugin.this.getValue("year");
                DynamicObject period = (DynamicObject)MergeOperLogListPlugin.this.getValue("period");
                Map<Long, String> id2NumMap = OrgUtils.getOrgChangeName2Map(MergeOperLogListPlugin.this.getModelId(), year == null ? 0L : year.getLong("id"), period == null ? 0L : period.getLong("id"), collection.stream().map(e -> e.getLong("orgid.id")).collect(Collectors.toList()));
                collection.forEach(v -> {
                    String orgName;
                    v.set("datasource", (Object)ResManager.loadKDString((String)"\u6570\u636e\u8bbe\u7f6e", (String)"MergeOperLogListPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    Date beginTime = v.getDate("begintime");
                    Date endTime = v.getDate("endtime");
                    if (beginTime != null && endTime != null) {
                        String costTime = DateUtils.dealCostTime((Date)beginTime, (Date)endTime);
                        v.set("speedtime", (Object)costTime);
                    }
                    if (StringUtils.isNotEmpty((CharSequence)(orgName = (String)id2NumMap.get(v.getLong("orgid.id"))))) {
                        v.set("orgid.name", (Object)orgName);
                    }
                });
                return collection;
            }

            public List<ListField> getKeyFields() {
                List keyFields = super.getKeyFields();
                return keyFields;
            }

            public void setKeyFields(List<ListField> keyFields) {
                super.setKeyFields(keyFields);
                List listFields = this.getListFields();
                for (ListField field : listFields) {
                    DynamicSimpleProperty sourceSimpleProperty;
                    String fieldName = field.getFieldName();
                    if ("datasource".equals(fieldName)) {
                        field.setFieldProp((IDataEntityProperty)this.dataSimpleProperty);
                        sourceSimpleProperty = new DynamicSimpleProperty();
                        sourceSimpleProperty.setName("listdatasource");
                        field.setSrcFieldProp((IDataEntityProperty)sourceSimpleProperty);
                        continue;
                    }
                    if (!"speedtime".equals(fieldName)) continue;
                    field.setFieldProp((IDataEntityProperty)this.speedSimpleProperty);
                    sourceSimpleProperty = new DynamicSimpleProperty();
                    sourceSimpleProperty.setName("listspeedtime");
                }
            }
        });
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.checkDeadProcess();
    }

    private void checkDeadProcess() {
        BillList billList = (BillList)this.getControl(BILL_LIST_AP);
        DynamicObjectCollection collection = billList.getListModel().getQueryResult().getCollection();
        if (collection != null) {
            long currentTime = System.currentTimeMillis();
            long deadtime = 1800000L;
            List running = collection.stream().filter(p -> (ProgressStatusEnum.PROCESSING.getCode().equals(p.getString("fstatus")) || ProgressStatusEnum.TERMING.getCode().equals(p.getString("fstatus"))) && currentTime - p.getDate("begintime").getTime() > deadtime).collect(Collectors.toList());
            List ids = Lists.transform(running, c -> c.getLong("id"));
            List runningIds = this.getRunRecorderIds(ids);
            if (runningIds != null && !runningIds.isEmpty()) {
                runningIds = ProcessStatusHeartBeatChecker.maybeAbortProcess(runningIds);
                MergeProgressHelper.updateStatus((String)ProgressStatusEnum.TERMINATION.getCode(), (List)runningIds);
                billList.refresh();
            }
        }
    }

    @Override
    protected Map<String, Object> getF7CustomData(String f7Key) {
        if ("entity".equals(f7Key)) {
            HashMap<String, Object> customData = new HashMap<String, Object>(16);
            DynamicObject yearDy = (DynamicObject)this.getValue("year");
            String periodId = UserSelectUtil.getF7SelectId(this.getView(), "period");
            DynamicObject scenarioDy = (DynamicObject)this.getValue("scenario");
            if (yearDy != null) {
                customData.put("yearNum", yearDy.getString("number"));
                customData.put("yearId", yearDy.getLong("id"));
            }
            if (periodId != null) {
                customData.put("periodId", periodId);
            }
            if (scenarioDy != null) {
                customData.put("scenarioId", scenarioDy.getLong("id"));
            }
            customData.put("org_fuzzySearch_flag", 1);
            return customData;
        }
        return null;
    }
}

