/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.mergecontrol;

import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.allinone.service.MergeProgressHelper;
import kd.fi.bcm.business.allinone.service.thread.AbortThreadHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.serviceHelper.AppCacheServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.MergeTaskTypeEnum;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;
import kd.fi.bcm.common.enums.ProgressStatusEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.DateUtils;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.util.OrgUtils;

public class MergeProgressPlugin
extends AbstractBaseListPlugin
implements ProgresssListener {
    private List<String> dimKeys = Lists.newArrayList((Object[])new String[]{"scenario", "year", "period"});
    private static final String f7CACHEKEY = "f7Cache";
    private static final String BILL_LIST_AP = "billlistap";

    @Override
    public void initialize() {
        super.initialize();
        this.addItemClickListeners("mergeprogressbar");
        ((ProgressBar)this.getControl("progressbarap")).addProgressListener((ProgresssListener)this);
        HashMap map = new HashMap(16);
        this.asMapF7toType(this.dimKeys, SingleF7TypeEnum.LEAF, map);
        this.initSingleMemberF7(map);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        Long mergeProgressId;
        super.afterCreateNewData(e);
        Long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        this.getPageCache().put("KEY_MODEL_ID", String.valueOf(modelId));
        this.getModel().setValue("model", (Object)modelId);
        this.getModel().setValue("scenario", this.getView().getFormShowParameter().getCustomParam("scenario"));
        this.getModel().setValue("year", this.getView().getFormShowParameter().getCustomParam("year"));
        this.getModel().setValue("period", this.getView().getFormShowParameter().getCustomParam("period"));
        this.setF7CacheKey();
        this.refreshBillList();
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        if (billList.getSelectedRows().isEmpty() && (mergeProgressId = (Long)this.getFormCustomParam("mergeProgressId")) != null) {
            this.dealProgressInfo(mergeProgressId, true, null);
        }
    }

    @Override
    public long getModelId() {
        DynamicObject modelObj = (DynamicObject)this.getModel().getValue("model");
        if (modelObj == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MergeProgressPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        return modelObj.getLong("id");
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("progclose", "progrefresh", "progstop");
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        billList.addListRowClickListener((ListRowClickListener)this);
        billList.addAfterBindDataListener(this::afterBindData);
        billList.addCreateListDataProviderListener(this::beforeCreateListDataProvider);
    }

    @Override
    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        final DynamicObject year = (DynamicObject)this.getValue("year");
        final DynamicObject period = (DynamicObject)this.getValue("period");
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection cols = super.getData(start, limit);
                if (!cols.isEmpty()) {
                    OrgUtils.changeOrgName2Dy(MergeProgressPlugin.this.getModelId(), year == null ? 0L : year.getLong("id"), period == null ? 0L : period.getLong("id"), (Collection<DynamicObject>)cols, "orgid", false);
                }
                return cols;
            }
        });
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        billList.selectRows(0);
    }

    public void listRowClick(ListRowClickEvent evt) {
        super.listRowClick(evt);
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        if (!billList.getSelectedRows().isEmpty()) {
            long progressId = (Long)billList.getSelectedRows().get(0).getPrimaryKeyValue();
            this.dealProgressInfo(progressId, true, null);
        }
    }

    @Override
    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        switch (key) {
            case "progclose": {
                this.getView().close();
                break;
            }
            case "progrefresh": {
                Long mergeProgressId;
                this.refreshBillList();
                if (!billList.getSelectedRows().isEmpty() || (mergeProgressId = (Long)this.getFormCustomParam("mergeProgressId")) == null) break;
                this.dealProgressInfo(mergeProgressId, true, null);
                break;
            }
            case "progstop": {
                this.doCheckPermission("bcm_mergeoperationlog", "3=RYT098KPS9");
                ListSelectedRowCollection selectedRows = billList.getSelectedRows();
                if (selectedRows.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8981\u7ec8\u6b62\u7684\u8bb0\u5f55\u3002", (String)"MergeProgressPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    break;
                }
                List<Long> ids = this.getRunRecorderIds(selectedRows);
                if (ids.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8fd0\u884c\u4e2d\u72b6\u6001\u7684\u8bb0\u5f55\u3002", (String)"MergeProgressPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u7ec8\u6b62\u8fd0\u884c\u4e2d\u7684\u667a\u80fd\u5408\u5e76\u8fdb\u7a0b\u5417?", (String)"MergeProgressPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("action_taskstop", (IFormPlugin)this));
            }
        }
    }

    protected List<Long> getRunRecorderIds(ListSelectedRowCollection selectedRows) {
        List ids = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        DynamicObjectCollection dos = MergeProgressHelper.queryProgress((String)"id,fstatus", (QFBuilder)new QFBuilder().add("id", "in", ids).add("fstatus", "=", (Object)"1"));
        return dos.stream().map(d -> d.getLong("id")).collect(Collectors.toList());
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if ("scenario".equals(propertyName)) {
            this.getModel().getDataEntity().set("period", null);
        } else if ("model".equals(propertyName)) {
            this.getModel().getDataEntity().set("scenario", null);
            this.getModel().getDataEntity().set("year", null);
            this.getModel().getDataEntity().set("period", null);
        }
        this.refreshBillList();
        this.getView().updateView();
    }

    private void setF7CacheKey() {
        HashMap<String, Object> f7KeyMap = new HashMap<String, Object>(16);
        this.setSingleF7CacheKey(f7KeyMap, "model");
        this.setSingleF7CacheKey(f7KeyMap, "year");
        this.setSingleF7CacheKey(f7KeyMap, "scenario");
        this.setSingleF7CacheKey(f7KeyMap, "period");
        this.getPageCache().put(f7CACHEKEY, SerializationUtils.toJsonString(f7KeyMap));
    }

    private void setSingleF7CacheKey(Map<String, Object> f7KeyMap, String key) {
        if (this.getModel().getValue(key) != null) {
            DynamicObject yearObj = (DynamicObject)this.getModel().getValue(key);
            f7KeyMap.put(key, yearObj.getLong("id"));
        }
    }

    private void refreshBillList() {
        ArrayList<String> showstatus = new ArrayList<String>();
        showstatus.add(ProgressStatusEnum.PROCESSING.getCode());
        showstatus.add(ProgressStatusEnum.TERMING.getCode());
        if (((Boolean)this.getModel().getValue("showsuccess")).booleanValue()) {
            showstatus.add(ProgressStatusEnum.SUCCESS.getCode());
        }
        if (((Boolean)this.getModel().getValue("showfailed")).booleanValue()) {
            showstatus.add(ProgressStatusEnum.FAIL.getCode());
        }
        if (((Boolean)this.getModel().getValue("showstoped")).booleanValue()) {
            showstatus.add(ProgressStatusEnum.TERMINATION.getCode());
        }
        this.refreshBillList(showstatus);
    }

    private void refreshBillList(List<String> showstatus) {
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        FilterParameter fp = new FilterParameter();
        long modelId = this.getModelId();
        QFilter filter = new QFilter("issueid", "=", (Object)modelId);
        if (this.getModel().getValue("scenario") != null) {
            DynamicObject scen = (DynamicObject)this.getModel().getValue("scenario");
            filter.and("scenarioid", "=", (Object)scen.getLong("id"));
        }
        if (this.getModel().getValue("year") != null) {
            DynamicObject yearObj = (DynamicObject)this.getModel().getValue("year");
            filter.and("yearid", "=", (Object)yearObj.getLong("id"));
        }
        if (this.getModel().getValue("period") != null) {
            DynamicObject periodObj = (DynamicObject)this.getModel().getValue("period");
            filter.and("periodid", "=", (Object)periodObj.getLong("id"));
        }
        long orgDimId = DimensionServiceHelper.getIdByNum((String)"bcm_dimension", (long)modelId, (String)DimEntityNumEnum.ENTITY.getNumber());
        filter.and(PermissionServiceImpl.getInstance((Long)modelId).getReadOrWritePermFilter(Long.valueOf(orgDimId), "bcm_entitymembertree", "orgid"));
        filter.and("fstatus", "in", showstatus);
        filter.and("fstatus", "in", showstatus);
        filter.and("tasktype", "=", (Object)MergeTaskTypeEnum.OneKeyMerge.getCode());
        fp.setFilter(filter);
        billList.setFilterParameter(fp);
        billList.refresh();
        billList.selectRows(0);
    }

    private void dealProgressInfo(Long progressId, boolean isClick, ProgressEvent evt) {
        ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
        QFilter qcs = new QFilter("id", "=", (Object)progressId);
        QFilter[] memberFilters = new QFilter[]{qcs};
        DynamicObject obj = QueryServiceHelper.queryOne((String)"bcm_mergeprogressentity", (String)"", (QFilter[])memberFilters);
        OrgUtils.changeOrgName2Dy(obj.getLong("issueid.id"), obj.getLong("yearid.id"), obj.getLong("periodid.id"), Collections.singletonList(obj), "orgid", false);
        String status = obj.getString("fstatus");
        int orgleafcount = obj.getInt("orgleafcount");
        int orgsubcount = obj.getInt("orgsubcount");
        String leafText = String.format(ResManager.loadKDString((String)"\u53c2\u4e0e\u5408\u5e76\u7684\u5355\u4f53\u7ec4\u7ec7 %d \u5bb6", (String)"MergeProgressPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), orgleafcount);
        String subText = String.format(ResManager.loadKDString((String)"\u53c2\u4e0e\u5408\u5e76\u7684\u5408\u5e76\u8282\u70b9 %d \u4e2a", (String)"MergeProgressPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), orgsubcount);
        int percent = 0;
        String progressStr = ResManager.loadKDString((String)"\u65e0\u4efb\u52a1", (String)"MergeProgressPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        if (ProgressStatusEnum.PROCESSING.getCode().equals(status)) {
            Pair pair = MergeProgressHelper.getFinishedCount((Long)progressId);
            int leafFinishedCount = (Integer)pair.p1;
            int subFinishedCount = (Integer)pair.p2;
            if ((Integer)pair.p1 == -1) {
                leafFinishedCount = orgleafcount;
                subFinishedCount = orgsubcount;
            }
            leafText = String.format(ResManager.loadKDString((String)"\u53c2\u4e0e\u5408\u5e76\u7684\u5355\u4f53\u7ec4\u7ec7 %1$s \u5bb6\uff0c\u5df2\u5904\u7406 %2$s \u5bb6", (String)"MergeProgressPlugin_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]), orgleafcount, leafFinishedCount);
            subText = String.format(ResManager.loadKDString((String)"\u53c2\u4e0e\u5408\u5e76\u7684\u5408\u5e76\u8282\u70b9 %1$s \u4e2a\uff0c\u5df2\u5904\u7406 %2$s \u4e2a", (String)"MergeProgressPlugin_23", (String)"fi-bcm-formplugin", (Object[])new Object[0]), orgsubcount, subFinishedCount);
            int totalCount = orgleafcount + orgsubcount;
            int finishCount = leafFinishedCount + subFinishedCount;
            percent = totalCount != 0 ? finishCount * 100 / totalCount : finishCount * 100;
            Integer lastPercent = (Integer)AppCacheServiceHelper.get((String)("processPercent" + progressId), Integer.class);
            if (lastPercent != null && lastPercent > percent) {
                percent = lastPercent;
            }
            AppCacheServiceHelper.put((String)("processPercent" + progressId), (Object)percent);
            progressStr = String.format(ResManager.loadKDString((String)"\u8fdb\u5ea6 %s%%", (String)"MergeProgressPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]), percent);
            bar.start();
        } else if (ProgressStatusEnum.FAIL.getCode().equals(status)) {
            progressStr = ResManager.loadKDString((String)"\u5408\u5e76\u5931\u8d25", (String)"MergeProgressPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            if (!isClick) {
                this.refreshById(progressId);
                bar.stop();
            }
        } else if (ProgressStatusEnum.SUCCESS.getCode().equals(status)) {
            percent = 100;
            progressStr = ResManager.loadKDString((String)"\u5b8c\u6210", (String)"MergeProgressPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            if (!isClick) {
                this.refreshById(progressId);
                bar.stop();
            }
        } else if (ProgressStatusEnum.TERMING.getCode().equals(status)) {
            progressStr = ProgressStatusEnum.TERMING.getText();
        } else if (ProgressStatusEnum.TERMINATION.getCode().equals(status)) {
            progressStr = ResManager.loadKDString((String)"\u5df2\u7ec8\u6b62", (String)"MergeProgressPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            if (!isClick) {
                this.refreshById(progressId);
                bar.stop();
            }
        }
        if (evt != null) {
            evt.setProgress(percent);
            evt.setText(progressStr);
        } else {
            bar.setPercent(percent, progressStr);
        }
        this.showProgressInfo(obj, leafText, subText);
        if (isClick && ProgressStatusEnum.FAIL.getCode().equals(status)) {
            this.showErrorMessage(obj);
        }
    }

    private void refreshById(Long progressId) {
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        FilterParameter fp = new FilterParameter();
        fp.setFilter(new QFilter("id", "=", (Object)progressId));
        billList.setFilterParameter(fp);
        billList.refresh();
    }

    private void showErrorMessage(DynamicObject obj) {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("bcm_showmessage");
        param.setCaption(ResManager.loadKDString((String)"\u5408\u5e76\u5df2\u5b8c\u6210\uff0c\u5b58\u5728\u5f02\u5e38\u4fe1\u606f\u3002", (String)"MergeProgressPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCustomParam("message", (Object)obj.getString("failedlog"));
        this.getView().showForm(param);
    }

    private void showProgressInfo(DynamicObject obj, String leafCount, String orgsubcount) {
        Date beginTime = obj.getDate("begintime");
        Date endTime = obj.getDate("endtime");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ((Label)this.getControl("orgnameright")).setText(obj.getString("orgid.name"));
        ((Label)this.getControl("leafcount")).setText(leafCount);
        ((Label)this.getControl("subcount")).setText(orgsubcount);
        ((Label)this.getControl("begintime")).setText(String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\uff1a%s", (String)"MergeProgressPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]), sdf.format(beginTime)));
        String costTimeStr = "";
        String entTimeStr = "";
        if (endTime != null) {
            costTimeStr = DateUtils.dealCostTime((Date)beginTime, (Date)endTime);
            entTimeStr = sdf.format(endTime);
        }
        ((Label)this.getControl("endtime")).setText(String.format(ResManager.loadKDString((String)"\u7ed3\u675f\u65f6\u95f4\uff1a%s", (String)"MergeProgressPlugin_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]), entTimeStr));
        ((Label)this.getControl("costtime")).setText(String.format(ResManager.loadKDString((String)"\u8017\u65f6\uff1a%s", (String)"MergeProgressPlugin_24", (String)"fi-bcm-formplugin", (Object[])new Object[0]), costTimeStr));
    }

    public void onProgress(ProgressEvent progressEvent) {
        Control control = (Control)progressEvent.getSource();
        if ("progressbarap".equals(control.getKey())) {
            try {
                Long mergeProgressId = (Long)this.getFormCustomParam("mergeProgressId");
                if (mergeProgressId != null) {
                    this.dealProgressInfo(mergeProgressId, false, progressEvent);
                } else {
                    BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
                    if (!billList.getSelectedRows().isEmpty()) {
                        long progressId = (Long)billList.getSelectedRows().get(0).getPrimaryKeyValue();
                        this.dealProgressInfo(progressId, false, progressEvent);
                    }
                }
            }
            catch (Exception e) {
                log.error("show process error:", (Throwable)e);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("action_taskstop".equals(messageBoxClosedEvent.getCallBackId()) && "Yes".equals(messageBoxClosedEvent.getResultValue())) {
            BillList billList = (BillList)this.getControl(BILL_LIST_AP);
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            DynamicObjectCollection selectInfo = this.getSelectInfo(selectedRows);
            List<Long> ids = this.getRunRecorderIds(selectedRows);
            if (!ids.isEmpty()) {
                MergeProgressHelper.updateStatus((String)ProgressStatusEnum.TERMING.getCode(), ids);
                AbortThreadHelper.setMergerProcessAbortFlag(ids);
                for (DynamicObject dyn : selectInfo) {
                    String opDescription = String.format("%s %s%s", dyn.getString("orgid.number"), dyn.getString("orgid.name"), OpItemEnum.OPERATION_STOP.getName());
                    this.writeMultiLangLog(OpNameMultiLangEnumBridge.genOpNameBridge((MultiLangEnumBridge)OpItemEnum.OPERATION_STOP.getMultiLangEnumBridge(), (String)"Stop"), OPDescMultiLangEnumBridge.genUnTransBridge((String)opDescription));
                }
            }
            this.refreshBillList();
        }
    }

    protected DynamicObjectCollection getSelectInfo(ListSelectedRowCollection selectedRows) {
        List ids = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        return MergeProgressHelper.queryProgress((String)"id,orgid.name,orgid.number", (QFBuilder)new QFBuilder().add("id", "in", ids).add("fstatus", "=", (Object)"1"));
    }
}

