/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.mergecontrol;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Locale;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.control.Control;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.pageinteraction.DynamicPage;

public class ShowConfigPlugin
extends AbstractBaseFormPlugin
implements DynamicPage {
    private static final String PAGE_ITEM = "pageItem";
    private static final String CHECK_ITEM = "checkItem";
    private static final String BTN_OK = "btn_ok";
    private static final String BTN_CLOSE = "btn_close";
    private static final String PAGE_TYPE_RADIO_GROUP = "pagetyperadiogroup";
    private static final String CHECK_RADIO_GROUP = "checkradiogroup";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setDefaultData();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(BTN_CLOSE, BTN_OK);
    }

    @Override
    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey().toLowerCase(Locale.ENGLISH)) {
            case "btn_ok": {
                this.getView().returnDataToParent((Object)SerializationUtils.toJsonString(this.getPageItemData()));
                this.getView().close();
                break;
            }
            case "btn_close": {
                this.getView().close();
                break;
            }
        }
    }

    private void setDefaultData() {
        String pageItem = (String)this.getView().getFormShowParameter().getCustomParams().get(PAGE_ITEM);
        String checkItem = (String)this.getView().getFormShowParameter().getCustomParams().get(CHECK_ITEM);
        if (pageItem != null) {
            this.getModel().setValue(PAGE_TYPE_RADIO_GROUP, (Object)pageItem);
        }
        if (checkItem != null) {
            this.getModel().setValue(CHECK_RADIO_GROUP, (Object)checkItem);
        }
    }

    private HashMap<String, Object> getPageItemData() {
        MainEntityType mainEntityType = this.getModel().getDataEntityType();
        DataEntityPropertyCollection props = mainEntityType.getProperties();
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (IDataEntityProperty pro : props) {
            if (!(pro instanceof ComboProp)) continue;
            if (PAGE_TYPE_RADIO_GROUP.equals(pro.getName())) {
                map.put(PAGE_ITEM, this.getModel().getValue(pro.getName()).toString());
                continue;
            }
            map.put(CHECK_ITEM, this.getModel().getValue(pro.getName()).toString());
        }
        return map;
    }
}

