/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.mergecontrol.taskjob;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.MessageHandler;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.epm.epbs.business.log.trace.OlapTraceServiceHelper;
import kd.fi.bcm.business.allinone.model.ExecuteContext;
import kd.fi.bcm.business.mergecontrol.MergeControlService;
import kd.fi.bcm.business.model.FixedItem;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.MergeTaskTypeEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.msservice.MsServiceHelper;
import kd.fi.bcm.common.util.ObjectSerialUtil;

public class RealTimeJobCalculateHandler
extends AbstractTask {
    private static final Log log = LogFactory.getLog(RealTimeJobCalculateHandler.class);

    public MessageHandler getMessageHandle() {
        return super.getMessageHandle();
    }

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        OperationContext context = OperationContext.get();
        if (context != null) {
            context.setFormId("bcm_mergecontrollist");
        }
        OlapTraceServiceHelper.setTraceOpInfo((String)ResManager.loadKDString((String)"\u8ba1\u7b97", (String)"RealTimeJobCalculateHandler_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        this.feedbackProgress(0, ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u4efb\u52a1", (String)"RealTimeJobCalculateHandler_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), null);
        String fixeItemSerial = (String)map.get("fixedItem");
        FixedItem fixedItem = (FixedItem)ObjectSerialUtil.deSerializedBytes((String)fixeItemSerial);
        String executeContextSerial = (String)map.get("executeContext");
        ExecuteContext ctx = (ExecuteContext)ObjectSerialUtil.deSerializedBytes((String)executeContextSerial);
        List orgList = (List)fixedItem.getOrgList();
        HashSet<String> successOrgList = new HashSet<String>(orgList.size());
        HashSet<String> failOrgList = new HashSet<String>(orgList.size());
        int time = orgList.size();
        HashMap<String, String> errorInfo = new HashMap<String, String>(time);
        for (int i = 0; i < orgList.size(); ++i) {
            if (this.isStop()) {
                this.stop();
            }
            SimpleItem org = (SimpleItem)orgList.get(i);
            ctx.setOrg(org);
            String desc = String.format(ResManager.loadKDString((String)"\u6b63\u5728\u8fdb\u884c\u7b2c%1$s/%2$s\u6b21\u6267\u884c\uff0c\u7ec4\u7ec7\uff1a%3$s\u3002", (String)"RealTimeJobCalculateHandler_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), i + 1, time, org.getNumber());
            int progress = 100 * i / time;
            this.feedbackProgress(progress, desc, null);
            ctx.setSingleCalc(true);
            try {
                MergeControlService.getInstance().fillCtxProgressIdByLeafOrg(fixedItem, ctx, MergeTaskTypeEnum.Calculate.getCode());
                MsServiceHelper.invokeMcCalculateService((String)ctx.toString());
                successOrgList.add(org.getNumber());
                continue;
            }
            catch (Exception e) {
                errorInfo.put(org.getNumber(), e.getMessage());
                failOrgList.add(org.getNumber());
                log.error(org.getNumber() + " Calculate error:" + e.getMessage());
                log.error((Throwable)e);
            }
        }
        HashMap<String, Serializable> result = new HashMap<String, Serializable>(4);
        boolean success = errorInfo.isEmpty();
        result.put("success", Boolean.valueOf(success));
        result.put("successOrgList", successOrgList);
        result.put("error", errorInfo);
        result.put("failOrgList", failOrgList);
        this.feedbackCustomdata(result);
        String op = MergeTaskTypeEnum.Calculate.getText();
        StringBuilder detail = new StringBuilder().append(MemberReader.findScenaMemberById((Long)((Long)ctx.getModel().getId()), (Long)((Long)ctx.getScenario().getId())).getNumber()).append(" ").append(MemberReader.findFyMemberById((Long)((Long)ctx.getModel().getId()), (Long)((Long)ctx.getFy().getId())).getNumber()).append(" ").append(MemberReader.findPeriodMemberById((Long)((Long)ctx.getModel().getId()), (Long)((Long)ctx.getPeriod().getId())).getNumber()).append(": ");
        if (success) {
            if (successOrgList.size() > 0) {
                for (Object e : successOrgList) {
                    detail.append(e).append(" ");
                }
                detail.append(op).append(ResultStatusEnum.SUCCESS.getName()).append(";");
            }
        } else if (failOrgList.size() > 0) {
            for (Object e : failOrgList) {
                detail.append(e).append(" ");
            }
            detail.append(op).append(ResultStatusEnum.FAIL.getName()).append(";");
        }
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        AppLogInfo appLogInfo = OperationLogUtil.buildLogInfo((String)op, (String)detail.toString(), (Long)((Long)ctx.getModel().getId()), (String)"bcm_mergecontrollist");
        appLogInfo.setClientType((String)map.get("loginClient"));
        appLogInfo.setClientName((String)map.get("loginClient"));
        appLogInfo.setClientIP((String)map.get("loginClientIP"));
        logService.addLog(appLogInfo);
    }
}

