/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.mergecontrol.taskjob;

import java.util.HashMap;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.fi.bcm.business.allinone.model.ExecuteContext;
import kd.fi.bcm.business.mergecontrol.MergeCondition;
import kd.fi.bcm.business.mergecontrol.MergeControlService;
import kd.fi.bcm.business.model.FixedItem;
import kd.fi.bcm.common.util.ObjectSerialUtil;

public class RealTimeJobHelper {
    public static final String PARAM_FIXEDITEM = "fixedItem";
    public static final String PARAM_CTX = "executeContext";
    public static final String CLOSE_CALLBACK_CALCULATE = "calculateTaskCloseBack";
    public static final String CLOSE_CALLBACK_CONVERT = "convertTaskCloseBack";
    public static final String CLOSE_CALLBACK_MERGE_SUM = "mergeSumTaskCloseBack";
    private static final String CALCULATE_HANDLER_CLASS_NAME = "kd.fi.bcm.formplugin.mergecontrol.taskjob.RealTimeJobCalculateHandler";
    private static final String CONVERT_HANDLER_CLASS_NAME = "kd.fi.bcm.formplugin.mergecontrol.taskjob.RealTimeJobConvertHandler";
    private static final String MERGE_SUM_HANDLER_CLASS_NAME = "kd.fi.bcm.formplugin.mergecontrol.taskjob.RealTimeJobMergeSumHandler";

    public static void createTask(AbstractFormPlugin plugin, MergeCondition condition, FixedItem fixedItem, String type) {
        String jobTitle;
        JobInfo jobInfo = new JobInfo();
        IFormView view = plugin.getView();
        jobInfo.setAppId(view.getFormShowParameter().getServiceAppId());
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setId(UUID.randomUUID().toString());
        if ("1".equals(type)) {
            jobTitle = ResManager.loadKDString((String)"\u62a5\u8868\u8ba1\u7b97", (String)"RealTimeJobHelper_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            jobInfo.setTaskClassname(CALCULATE_HANDLER_CLASS_NAME);
        } else {
            jobTitle = ResManager.loadKDString((String)"\u62a5\u8868\u6298\u7b97", (String)"RealTimeJobHelper_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            jobInfo.setTaskClassname(CONVERT_HANDLER_CLASS_NAME);
        }
        jobInfo.setName(jobTitle);
        HashMap<String, String> params = new HashMap<String, String>();
        ExecuteContext executeContext = MergeControlService.getInstance().fillExecuteContextForTask(fixedItem, condition);
        params.put(PARAM_FIXEDITEM, ObjectSerialUtil.toByteSerialized((Object)fixedItem));
        params.put(PARAM_CTX, ObjectSerialUtil.toByteSerialized((Object)executeContext));
        params.put("loginClient", RequestContext.get().getClient());
        params.put("loginClientIP", RequestContext.get().getLoginIP());
        jobInfo.setParams(params);
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setRunByUserId(Long.parseLong(RequestContext.get().getUserId()));
        jobInfo.setRunByOrgId(RequestContext.get().getOrgId());
        JobFormInfo clientJobInfo = new JobFormInfo(jobInfo);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)plugin, "1".equals(type) ? CLOSE_CALLBACK_CALCULATE : CLOSE_CALLBACK_CONVERT);
        clientJobInfo.setCloseCallBack(closeCallBack);
        clientJobInfo.setCanBackground(true);
        clientJobInfo.setTimeout(3600);
        clientJobInfo.setParentPageId(view.getPageId());
        JobForm.dispatch((JobFormInfo)clientJobInfo, (IFormView)view);
    }

    public static void createMergeSumTask(AbstractFormPlugin plugin, MergeCondition condition, FixedItem fixedItem) {
        JobInfo jobInfo = new JobInfo();
        IFormView view = plugin.getView();
        jobInfo.setAppId(view.getFormShowParameter().getServiceAppId());
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setId(UUID.randomUUID().toString());
        String jobTitle = ResManager.loadKDString((String)"\u5408\u5e76\u6c47\u603b", (String)"RealTimeJobHelper_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        jobInfo.setTaskClassname(MERGE_SUM_HANDLER_CLASS_NAME);
        jobInfo.setName(jobTitle);
        HashMap<String, String> params = new HashMap<String, String>();
        ExecuteContext executeContext = MergeControlService.getInstance().fillExecuteContextForTask(fixedItem, condition);
        params.put(PARAM_FIXEDITEM, ObjectSerialUtil.toByteSerialized((Object)fixedItem));
        params.put(PARAM_CTX, ObjectSerialUtil.toByteSerialized((Object)executeContext));
        params.put("loginClient", RequestContext.get().getClient());
        params.put("loginClientIP", RequestContext.get().getLoginIP());
        jobInfo.setParams(params);
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setRunByUserId(Long.parseLong(RequestContext.get().getUserId()));
        jobInfo.setRunByOrgId(RequestContext.get().getOrgId());
        JobFormInfo clientJobInfo = new JobFormInfo(jobInfo);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)plugin, CLOSE_CALLBACK_MERGE_SUM);
        clientJobInfo.setCloseCallBack(closeCallBack);
        clientJobInfo.setCanBackground(true);
        clientJobInfo.setTimeout(3600);
        clientJobInfo.setParentPageId(view.getPageId());
        JobForm.dispatch((JobFormInfo)clientJobInfo, (IFormView)view);
    }
}

