/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.mergecontrol.taskjob;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.MessageHandler;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.fi.bcm.business.allinone.OrgBuilder;
import kd.fi.bcm.business.allinone.model.ExecuteContext;
import kd.fi.bcm.business.allinone.model.OrgNode;
import kd.fi.bcm.business.allinone.service.report.MergeSumExecuteService;
import kd.fi.bcm.business.mergecontrol.MergeControlService;
import kd.fi.bcm.business.model.FixedItem;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.MergeTaskTypeEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.util.ObjectSerialUtil;

public class RealTimeJobMergeSumHandler
extends AbstractTask {
    private static final Log log = LogFactory.getLog(RealTimeJobMergeSumHandler.class);

    public MessageHandler getMessageHandle() {
        return super.getMessageHandle();
    }

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        this.feedbackProgress(0, ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u4efb\u52a1", (String)"RealTimeJobMergeSumHandler_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), null);
        String fixeItemSerial = (String)map.get("fixedItem");
        FixedItem fixedItem = (FixedItem)ObjectSerialUtil.deSerializedBytes((String)fixeItemSerial);
        String executeContextSerial = (String)map.get("executeContext");
        ExecuteContext ctx = (ExecuteContext)ObjectSerialUtil.deSerializedBytes((String)executeContextSerial);
        OrgBuilder build = OrgBuilder.build((Long)((Long)ctx.getModel().getId()), (Long)((Long)ctx.getScenario().getId()), (Long)((Long)ctx.getFy().getId()), (Long)((Long)ctx.getPeriod().getId()));
        OrgNode node = build.genOrgNode((Long)ctx.getOrg().getId());
        build.extendDirectChildren(node);
        String desc = String.format(ResManager.loadKDString((String)"\u6b63\u5728\u5bf9\u7ec4\u7ec7\u201c%s\u201d\u8fdb\u884c\u5408\u5e76\u6c47\u603b", (String)"RealTimeJobMergeSumHandler_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), node.getNumber());
        this.feedbackProgress(0, desc, null);
        if (this.isStop()) {
            this.stop();
        }
        HashMap<String, String> errorInfo = new HashMap<String, String>(1);
        HashSet<String> successOrgList = new HashSet<String>(1);
        HashSet<String> failOrgList = new HashSet<String>(1);
        try {
            MergeControlService.getInstance().fillCtxProgressIdForMergeSum(fixedItem, ctx, MergeTaskTypeEnum.MergeSum.getCode());
            ctx.setEntryCtx(true);
            ctx.setMergeSum(true);
            new MergeSumExecuteService(node).executeService(ctx);
            successOrgList.add(node.getNumber());
        }
        catch (Exception e) {
            failOrgList.add(node.getNumber());
            errorInfo.put(node.getNumber(), e.getMessage());
            log.error(node.getNumber() + " Merge Sum error:" + e.getMessage());
            log.error((Throwable)e);
        }
        HashMap<String, Serializable> result = new HashMap<String, Serializable>(4);
        boolean success = errorInfo.isEmpty();
        result.put("success", Boolean.valueOf(success));
        result.put("successOrgList", successOrgList);
        result.put("error", errorInfo);
        result.put("failOrgList", failOrgList);
        this.feedbackCustomdata(result);
        String op = MergeTaskTypeEnum.MergeSum.getText();
        StringBuilder detail = new StringBuilder().append(MemberReader.findScenaMemberById((Long)((Long)ctx.getModel().getId()), (Long)((Long)ctx.getScenario().getId())).getNumber()).append(" ").append(MemberReader.findFyMemberById((Long)((Long)ctx.getModel().getId()), (Long)((Long)ctx.getFy().getId())).getNumber()).append(" ").append(MemberReader.findPeriodMemberById((Long)((Long)ctx.getModel().getId()), (Long)((Long)ctx.getPeriod().getId())).getNumber()).append(": ");
        if (success) {
            if (successOrgList.size() > 0) {
                for (Object e : successOrgList) {
                    detail.append(e).append(" ");
                }
                detail.append(op).append(ResultStatusEnum.SUCCESS.getName()).append(";");
            }
        } else if (failOrgList.size() > 0) {
            for (Object e : failOrgList) {
                detail.append(e).append(" ");
            }
            detail.append(op).append(ResultStatusEnum.FAIL.getName()).append(";");
        }
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        AppLogInfo appLogInfo = OperationLogUtil.buildLogInfo((String)op, (String)detail.toString(), (Long)((Long)ctx.getModel().getId()), (String)"bcm_mergecontrollist");
        appLogInfo.setClientType((String)map.get("loginClient"));
        appLogInfo.setClientName((String)map.get("loginClient"));
        appLogInfo.setClientIP((String)map.get("loginClientIP"));
        logService.addLog(appLogInfo);
    }
}

