/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.model;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.page.model.Area;
import kd.fi.bcm.business.page.model.Element;
import kd.fi.bcm.business.page.model.Page;
import kd.fi.bcm.business.page.model.TextEditElement;
import kd.fi.bcm.business.scheme.Dimension;
import kd.fi.bcm.business.scheme.DimensionScope;
import kd.fi.bcm.business.scheme.ModelOlapScheme;
import kd.fi.bcm.business.scheme.SchemeContext;
import kd.fi.bcm.common.util.MulTiF7FilterTempleUtils;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.pageinteraction.DynamicPage;
import kd.fi.bcm.spread.common.util.StringUtil;

public class AbstractModelOlapOperation
extends AbstractBaseFormPlugin
implements DynamicPage {
    protected static final String FROM = "from_";
    protected static final String TO = "to_";
    protected static final String CLEAR = "clear_";
    protected static final String MODELOLAPSCHEME_CACHE = "ModelOlapScheme";
    protected static final Character BR = Character.valueOf('\n');
    protected ModelOlapScheme modelOlapScheme;
    private SchemeContext schemeContext;
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private static final String FLEXPANELAP1 = "flexpanelap1";
    private static final String DUPLICATE_TIPS = "duplicateTips";
    private static final Set<String> dims = Sets.newHashSet((Object[])new String[]{"Entity", "Scenario", "Year", "Period"});

    public ModelOlapScheme getModelOlapScheme() {
        if (this.modelOlapScheme == null) {
            String cacheValue = this.getPageCache().get(MODELOLAPSCHEME_CACHE);
            this.modelOlapScheme = StringUtils.isEmpty((String)cacheValue) ? new ModelOlapScheme(this.getModelId(), this.isCopy() ? "0" : "1") : (ModelOlapScheme)SerializationUtils.deSerializeFromBase64((String)cacheValue);
        }
        return this.modelOlapScheme;
    }

    public void cacheModelOlapScheme() {
        this.getPageCache().put(MODELOLAPSCHEME_CACHE, SerializationUtils.serializeToBase64((Object)this.getModelOlapScheme()));
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btn_copy", "btn_clear", "btn_change", "btn_reset", "btn_save", "btn_ok");
    }

    @Override
    public void onGetControl(OnGetControlArgs e) {
        Element controller;
        String key = e.getKey();
        if (!StringUtil.isEmptyString((String)key) && (key.startsWith(FROM) || key.startsWith(TO) || key.startsWith(CLEAR)) && (controller = this.getPage(this.getView()).findElementBySign(e.getKey())) != null) {
            TextEdit del = (TextEdit)controller.getControl(this.getView());
            del.addClickListener((ClickListener)this);
            e.setControl((Control)del);
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        long model = this.getModelId();
        if (model == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u64cd\u4f5c\u3002", (String)"AbstractModelOlapOperation_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
        this.loadModelOlapViewByModel();
        this.setVisiable();
        this.setDefautValue();
    }

    private void setDefautValue() {
        this.getModel().setValue("model", (Object)this.getModelId());
        Boolean isdatacollect = (Boolean)this.getView().getFormShowParameter().getCustomParam("isdatacollect");
        if (isdatacollect != null && isdatacollect.booleanValue()) {
            this.initPassValue();
            this.getView().setVisible(Boolean.valueOf(false), new String[]{FLEXPANELAP1, "btn_reset"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{FLEXPANELAP1, "btn_save"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{FLEXPANELAP1, "btn_change"});
        }
    }

    protected void initPassValue() {
        Map paramData = (Map)this.getView().getFormShowParameter().getCustomParam("paramData");
        Boolean isEdit = (Boolean)this.getView().getFormShowParameter().getCustomParam("isEdit");
        if (paramData != null) {
            try {
                this.modelOlapScheme = new ModelOlapScheme(this.getModelId(), "1");
                paramData.forEach((key, value) -> {
                    JSONObject dimemJson = (JSONObject)value;
                    Dimension dimension = this.getSchemeContext().getDimensionByNumber(key);
                    HashMap<Long, Integer> memMap = new HashMap<Long, Integer>(dimemJson.size());
                    for (Map.Entry s : dimemJson.entrySet()) {
                        Long memberID = Long.valueOf((String)s.getKey());
                        Integer scope = (Integer)s.getValue();
                        memMap.put(memberID, scope);
                    }
                    DimensionScope dimensionScope = new DimensionScope(String.valueOf(this.getModelId()), dimension, memMap);
                    this.getSchemeDetails().get("2").put(dimension, dimensionScope);
                    List members = dimensionScope.getdimMembers();
                    String source = dimensionScope.toString();
                    for (Map member : members) {
                        source = source.replace((CharSequence)member.get("name"), (String)member.get("name") + "(" + (String)member.get("number") + ")");
                    }
                    this.setValue(CLEAR + key, source);
                    if (isEdit != null && !isEdit.booleanValue()) {
                        this.setEnable(CLEAR + key.toLowerCase(Locale.ENGLISH));
                    }
                });
                this.cacheModelOlapScheme();
            }
            catch (Exception e) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u6761\u4ef6\u5e26\u5165\u5931\u8d25\u3002", (String)"AbstractModelOlapOperation_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            }
        }
    }

    private void setVisiable() {
        this.getView().setVisible(Boolean.valueOf(this.isCopy()), new String[]{"flexpanelap2", "btn_copy"});
        this.getView().setVisible(Boolean.valueOf(!this.isCopy()), new String[]{FLEXPANELAP1, "btn_clear"});
    }

    private void setEnable(String dimNumber) {
        this.getView().setEnable(Boolean.valueOf(false), new String[]{dimNumber});
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (StringUtil.isEmptyString((String)((String)e.getChangeSet()[0].getNewValue()))) {
            Dimension dimension = this.getDimensionByFieldKey(key);
            if (this.isCopy()) {
                String fromKey = FROM + dimension.getNumber().toLowerCase(Locale.ENGLISH);
                String toKey = TO + dimension.getNumber().toLowerCase(Locale.ENGLISH);
                this.setDimensionRange(fromKey, null);
                this.setDimensionRange(toKey, null);
                this.getView().setEnable(Boolean.TRUE, new String[]{toKey, fromKey});
            } else {
                this.setDimensionRange(CLEAR + dimension.getNumber().toLowerCase(Locale.ENGLISH), null);
            }
            this.cacheModelOlapScheme();
        }
    }

    private void loadModelOlapViewByModel() {
        Page page = this.createArea(this.getModelOlapScheme().getSchemeContext());
        this.cacheModelOlapScheme();
        this.setPage(this.getView(), page);
        page.updatePage(this.getView());
    }

    private Page createArea(SchemeContext schemeContext) {
        Page page = new Page();
        if (this.isCopy()) {
            Area areafrom = new Area("from");
            Area areato = new Area("to");
            for (Dimension dimension : schemeContext.getDimensions()) {
                TextEditElement fromElement = new TextEditElement(dimension.getName(), FROM + dimension.getNumber().toLowerCase(Locale.ENGLISH), "entity");
                fromElement.setEditStyle(1);
                areafrom.addElement((Element)fromElement);
                TextEditElement toElement = new TextEditElement(dimension.getName(), TO + dimension.getNumber().toLowerCase(Locale.ENGLISH), "entity");
                fromElement.setEditStyle(1);
                areato.addElement((Element)toElement);
            }
            page.addArea(areafrom);
            page.addArea(areato);
        } else {
            Area areaclear = new Area("clear");
            for (Dimension dimension : schemeContext.getDimensions()) {
                TextEditElement fromElement = new TextEditElement(dimension.getName(), CLEAR + dimension.getNumber().toLowerCase(Locale.ENGLISH), "entity");
                fromElement.setEditStyle(1);
                if (dims.contains(dimension.getNumber())) {
                    fromElement.setMustInput(true);
                }
                fromElement.setLabelWidth(new LocaleString("30%"));
                areaclear.addElement((Element)fromElement);
            }
            page.addArea(areaclear);
        }
        return page;
    }

    public SchemeContext getSchemeContext() {
        if (this.schemeContext == null) {
            this.schemeContext = this.getModelOlapScheme().getSchemeContext();
        }
        return this.schemeContext;
    }

    protected Map<String, Map<Dimension, DimensionScope>> getSchemeDetails() {
        return this.getModelOlapScheme().getSchemeDetails();
    }

    protected void setDimensionRange(String key, DimensionScope dimensionScope) {
        this.setDimensionRange(key, dimensionScope, true);
    }

    protected void setDimensionRangeContainNumber(String key, DimensionScope dimensionScope) {
        Dimension dimension = this.getDimensionByFieldKey(key);
        String type = "2";
        if (dimensionScope == null) {
            this.getSchemeDetails().get(type).remove(dimension);
            this.setValue(key, null);
        } else {
            if (dimensionScope.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u9009\u62e9\u7a7a\u8303\u56f4\u3002", (String)"AbstractModelOlapOperation_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            }
            this.getSchemeDetails().get(type).put(dimension, dimensionScope);
            this.setValue(key, dimensionScope.toString());
        }
    }

    protected void setDimensionRange(String key, DimensionScope dimensionScope, boolean intoCache) {
        String type;
        Dimension dimension = this.getDimensionByFieldKey(key);
        String string = this.isCopy() ? (key.startsWith(FROM) ? "0" : "1") : (type = "2");
        if (dimensionScope == null) {
            this.getSchemeDetails().get(type).remove(dimension);
            this.setValue(key, null);
        } else {
            if (dimensionScope.isEmpty() && ThreadCache.get((Object)DUPLICATE_TIPS) == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u9009\u62e9\u7a7a\u8303\u56f4\u3002", (String)"AbstractModelOlapOperation_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                ThreadCache.put((Object)DUPLICATE_TIPS, (Object)"yes");
            }
            if (intoCache) {
                this.getSchemeDetails().get(type).put(dimension, dimensionScope);
            } else {
                this.getSchemeDetails().get(type).remove(dimension);
            }
            this.setValue(key, dimensionScope.toString());
        }
    }

    protected DimensionScope getDimensionRange(String fieldKey) {
        Dimension dimension = this.getDimensionByFieldKey(fieldKey);
        DimensionScope ds = null;
        if (this.isCopy()) {
            boolean isfrom = fieldKey.startsWith(FROM);
            ds = this.getSchemeDetails().get(isfrom ? "0" : "1").get(dimension);
            DimensionScope otherDs = this.getSchemeDetails().get(isfrom ? "1" : "0").get(dimension);
            if (ds == null && otherDs != null && otherDs.size() > 1) {
                ds = otherDs;
            }
        } else {
            ds = this.getSchemeDetails().get("2").get(dimension);
        }
        return ds;
    }

    protected Dimension getDimensionByFieldKey(String fieldKey) {
        return this.getSchemeContext().getDimensionByNumber(fieldKey.split("\\_")[1]);
    }

    protected void resetForm() {
        this.getPageCache().remove(MODELOLAPSCHEME_CACHE);
        this.loadModelOlapViewByModel();
        this.getSchemeContext().getDimensions().stream().forEach(dim -> {
            if (this.isCopy()) {
                this.setValue(FROM + dim.getNumber().toLowerCase(Locale.ENGLISH), null);
                this.setValue(TO + dim.getNumber().toLowerCase(Locale.ENGLISH), null);
            } else {
                this.setValue(CLEAR + dim.getNumber().toLowerCase(Locale.ENGLISH), null);
            }
        });
    }

    protected boolean isCopy() {
        return (Boolean)this.getView().getFormShowParameter().getCustomParam("operationStatus");
    }

    @Override
    public long getModelId() {
        return (Long)this.getView().getFormShowParameter().getCustomParam("model");
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (!StringUtil.isEmptyString((String)key) && (key.startsWith(FROM) || key.startsWith(TO) || key.startsWith(CLEAR))) {
            Dimension dimension = this.getDimensionByFieldKey(key);
            this.getPageCache().remove(dimension.getNumber());
            FormShowParameter para = MulTiF7FilterTempleUtils.createMulTiF7ShowParameter((IPageCache)this.getPageCache(), (long)this.getModelId(), (String)dimension.getNumber(), (String)dimension.getName());
            DimensionScope dimensionScope = this.getDimensionRange(key);
            if (dimensionScope != null) {
                this.getPageCache().put(dimension.getNumber(), SerializationUtils.toJsonString((Object)dimensionScope.getdimMembers()));
            }
            assert (para != null);
            para.setCustomParam("sign", (Object)dimension.getNumber());
            para.setCustomParam("KEY_MODEL_ID", (Object)String.valueOf(this.getModelId()));
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
            para.setCloseCallBack(closeCallBack);
            this.getView().showForm(para);
        }
    }
}

