/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.util.ModelUtil;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.util.ThirdPartyDataCenterUtil;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.DataCenterCheckStatusEnum;
import kd.fi.bcm.common.enums.YearScopeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.BlackListUtils;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.computing.util.BatchProcessHelper;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.model.transfer.ModelTransferHelper;
import kd.fi.bcm.formplugin.model.transfer.ModelTransferParam;
import kd.fi.bcm.formplugin.model.transfer.ModelTransferProcessService;
import kd.fi.bcm.formplugin.model.transfer.ModelTransferProgress;
import kd.fi.bcm.formplugin.model.transfer.core.ModelCheckInfo;
import kd.fi.bcm.formplugin.model.transfer.core.ModelTransferType;
import kd.fi.bcm.formplugin.model.transfer.core.TransferMsgUtils;
import kd.fi.bcm.formplugin.model.transfer.core.service.ModelTransferServiceValidator;

public class BcmModelCopyAndTransferPlugin
extends AbstractBaseFormPlugin
implements ProgresssListener {
    private static final String COPY_RADIO_VAL = "1";
    private static final String TRANSFER_RADIO_VAL = "2";
    private static final String EXPORT_RADIO_VAL = "10";
    private static final String TYPE_RADIO_GROUP = "typeradiogroup";
    private static final String ALL_RADIO_VAL = "4";
    private static final String IS_DATA_BOX = "isdatabox";
    private static final String MODEL_GROUP = "modelgroup";
    private static final String TG_MODEL = "tgmodel";
    private static final String PREFIX = "bcm_";
    private static final String BUTTON_OK = "buttonok";
    private static final String BUTTON_EXIT = "btnexit";
    private static final String MODEL_NAME = "modelname";
    private static final String THIRD_DATA_CENTER = "thirddatacenter";
    private static final String DIMENSION_MUL = "dimensionmul";
    private static final String RECONCILE_MUL = "reconcilemul";
    private static final String INVELIM_MUL = "invelimmul";
    private static final String REPORT_FORM_MUL = "reportformmul";
    private static final String BUSINESS_MUL = "businessmul";
    private static final String INV_SHEET = "invsheet";
    private static final String MODEL_IDS_KYE = "model_ids_kye";
    private static final String RULE_IDS_KYE = "RULE_ids_kye";
    private static final String MODEL = "model";
    private static final String REGEX = "^[0-9a-zA-Z_]{1,}$";
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(BcmModelCopyAndTransferPlugin.class);
    private static final String TG_MODEL_NUMBER = "tgModelNumber";
    private static final String PROGRESSBARAP = "progressbarap";
    private static final String FILTER_ENTITY = "filterentity";
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private static final String ISMANAGER = "ISMANAGER";
    private static final String PARENTFORMID = "parentFormId";
    private static final String ENCRYPT_EXP = "encryptexp";
    private static final String SECRET_KEY = "secretkey";
    private static final String REGEX_PASS_Z = ".*[a-zA-Z].*";
    private static final String REGEX_PASS_S = ".*[0-9].*";
    private static final String MUL_SCENE = "mulscene";
    private static final String MUL_YEAR = "mulyear";
    private static final String MUL_PERIOD = "mulperiod";

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        String name = beforeF7SelectEvent.getProperty().getName();
        if (MODEL.equals(name)) {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            String billFormId = "";
            if (this.getView() != null && this.getView().getFormShowParameter().getCustomParams().containsKey(PARENTFORMID)) {
                billFormId = (String)this.getView().getFormShowParameter().getCustomParam(PARENTFORMID);
            }
            ApplicationTypeEnum application = ModelUtil.queryApp((IFormView)this.getView());
            showParameter.setCustomParam(ISMANAGER, (Object)MemberPermHelper.isManager((ApplicationTypeEnum)application, (String)billFormId));
            Set modelIds = MemberPermHelper.getLimitedModelListByUser((String)billFormId, (ApplicationTypeEnum)application);
            QFilter qFilter = new QFilter("id", "in", (Object)modelIds);
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
            qFilters.add(qFilter);
            beforeF7SelectEvent.setCustomQFilters(qFilters);
        } else if (THIRD_DATA_CENTER.equals(name)) {
            QFilter qf = new QFilter("teststatus", "in", Arrays.asList(DataCenterCheckStatusEnum.SUCCESS.getIndex(), DataCenterCheckStatusEnum.NO_STATUS.getIndex()));
            qf.and(new QFilter("apptype", "=", (Object)(this.isCM() ? ApplicationTypeEnum.CM.getOIndex() : ApplicationTypeEnum.RPT.getOIndex())));
            QFilter qf1 = new QFilter(MODEL, "=", (Object)0);
            if (!Objects.isNull(this.getValue(MODEL))) {
                QFilter qf2 = new QFilter(MODEL, "=", (Object)((DynamicObject)this.getValue(MODEL)).getLong("id"));
                qf.and(qf1.or(qf2));
            } else {
                qf.and(qf1);
            }
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
            qFilters.add(qf);
            beforeF7SelectEvent.setCustomQFilters(qFilters);
        } else if (MUL_SCENE.equals(name) || MUL_YEAR.equals(name) || MUL_PERIOD.equals(name)) {
            Object modelDy = this.getModel().getValue(MODEL);
            QFilter qf = null;
            if (modelDy != null) {
                qf = new QFilter(MODEL, "=", (Object)((DynamicObject)modelDy).getLong("id"));
                if (MUL_SCENE.equals(name)) {
                    qf.and("level", "!=", (Object)1);
                } else if (MUL_YEAR.equals(name)) {
                    QFilter qf1 = new QFilter("number", "=", (Object)YearScopeEnum.ALLYEAR.getNumber());
                    DynamicObject fyDy = QueryServiceHelper.queryOne((String)"bcm_fymembertree", (String)"id", (QFilter[])new QFilter[]{qf, qf1});
                    if (fyDy != null) {
                        qf.and("parent", "=", (Object)fyDy.getLong("id"));
                    }
                } else {
                    DynamicObjectCollection scenes = (DynamicObjectCollection)this.getModel().getValue(MUL_SCENE);
                    if (scenes == null || scenes.size() == 0) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u60c5\u666f\u3002", (String)"ExtendsDataDumpPlugin_32", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                    }
                    Set sceneIds = scenes.stream().map(y -> y.getLong("fbasedataid.id")).collect(Collectors.toSet());
                    QFilter qfq = new QFilter("id", "in", sceneIds);
                    DynamicObject[] result = BusinessDataServiceHelper.load((String)"bcm_scenemembertree", (String)"sceneperiod", (QFilter[])qfq.toArray());
                    Set sceneperiod = Arrays.stream(result).map(sc -> sc.getDynamicObjectCollection("sceneperiod")).collect(Collectors.toSet());
                    Set periodIds = sceneperiod.stream().flatMap(sc -> sc.stream().map(per -> per.getLong("fbasedataid.id"))).collect(Collectors.toSet());
                    qf.and("id", "in", periodIds);
                }
            } else {
                qf = new QFilter(MODEL, "=", (Object)0);
            }
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(1);
            qFilters.add(qf);
            beforeF7SelectEvent.setCustomQFilters(qFilters);
        }
    }

    public void onProgress(ProgressEvent progressEvent) {
        ProgressBar progressbarap = (ProgressBar)this.getControl(PROGRESSBARAP);
        ModelTransferProgress progressData = ModelTransferProgress.fromCache(this.getView());
        if (Objects.nonNull(progressData)) {
            int percent = progressData.getPercent();
            String message = progressData.getMessage();
            if (percent == -1) {
                progressEvent.setProgress(0);
                this.getView().showErrorNotification(message);
                progressbarap.stop();
                this.getView().setVisible(Boolean.FALSE, new String[]{PROGRESSBARAP});
                this.getView().setEnable(Boolean.TRUE, new String[]{BUTTON_OK, BUTTON_EXIT});
            } else {
                progressEvent.setProgress(percent);
                if (percent == 100) {
                    this.getView().showSuccessNotification(message);
                    progressbarap.stop();
                    String modelExportUrl = this.getPageCache().get("ModelExportUrl");
                    if (StringUtils.isNotEmpty((String)modelExportUrl)) {
                        this.downloadFile(RequestContext.get().getClientFullContextPath() + "attachment/download.do?path=" + modelExportUrl, "bcm_modelperm", "1G2FW/G3YIL8");
                        this.getPageCache().remove("ModelExportUrl");
                    }
                    this.getView().setVisible(Boolean.FALSE, new String[]{PROGRESSBARAP});
                    this.getView().setEnable(Boolean.TRUE, new String[]{BUTTON_OK, BUTTON_EXIT});
                }
            }
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setDefault();
        this.getView().setVisible(Boolean.FALSE, new String[]{PROGRESSBARAP, ENCRYPT_EXP, SECRET_KEY});
        Long modelIdParam = (Long)this.getView().getFormShowParameter().getCustomParam("modelIdParam");
        if (modelIdParam != null) {
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bcm_modelperm", (String)"model.id, model.name", (QFilter[])new QFilter("id", "=", (Object)modelIdParam).toArray());
            long id = dynamicObject.getLong("model.id");
            String name = dynamicObject.getString("model.name");
            this.builderMul(id);
            this.getModel().setValue(MODEL, (Object)id);
            this.getModel().setValue(MODEL_NAME, (Object)name);
        }
        if (BlackListUtils.hasFeatureInCm((String)"CMMultiModel")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"copyradio", "cpmodelpanel"});
            this.getModel().setValue(MODEL_GROUP, (Object)EXPORT_RADIO_VAL);
        }
        this.bindDataOfFilterentity();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners("toolbarap");
        ProgressBar progressbarap = (ProgressBar)this.getControl(PROGRESSBARAP);
        progressbarap.addProgressListener((ProgresssListener)this);
        BasedataEdit control = (BasedataEdit)this.getControl(THIRD_DATA_CENTER);
        control.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit sceneBase = (MulBasedataEdit)this.getControl(MUL_SCENE);
        sceneBase.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit yearBase = (MulBasedataEdit)this.getControl(MUL_YEAR);
        yearBase.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit periodBase = (MulBasedataEdit)this.getControl(MUL_PERIOD);
        periodBase.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        String value = this.getModel().getValue(MODEL_GROUP).toString();
        if (BUTTON_OK.equals(itemKey)) {
            ModelTransferType transferType;
            StringBuilder sbl = new StringBuilder();
            if (this.validation(sbl)) {
                this.getView().showTipNotification(sbl.toString());
                return;
            }
            HashMap<String, Set<Long>> ids = new HashMap<String, Set<Long>>(16);
            this.getMulboxVal(ids);
            this.getSingleSelVal(ids);
            boolean bool = ALL_RADIO_VAL.equals(this.getModel().getValue(TYPE_RADIO_GROUP).toString());
            if (!bool) {
                if (ids.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u64cd\u4f5c\u5185\u5bb9\u3002", (String)"BcmModelCopyAndTransferPlugin_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                    return;
                }
                if (this.validationModelAndBusiness(ids)) {
                    return;
                }
            }
            switch (value) {
                case "1": {
                    transferType = ModelTransferType.LOCAL_COPY;
                    break;
                }
                case "2": {
                    transferType = ModelTransferType.REMOTE_COPY;
                    break;
                }
                default: {
                    transferType = ModelTransferType.EXPORT;
                }
            }
            String tgModelNumber = this.getModel().getValue(TG_MODEL).toString();
            this.getPageCache().put(TG_MODEL_NUMBER, tgModelNumber);
            ModelTransferServiceValidator validator = new ModelTransferServiceValidator(transferType, tgModelNumber, null);
            ModelCheckInfo checkInfo = validator.validateRepeatModel();
            if (!checkInfo.getErrors().isEmpty() && ModelTransferType.LOCAL_COPY.toString().equals(transferType.toString())) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u7ecf\u5b58\u5728\uff0c\u662f\u5426\u8986\u76d6\u539f\u6709\u4f53\u7cfb\uff0c\u5982\u679c\u8986\u76d6\u5219\u4f1a\u5220\u9664\u5bf9\u5e94\u7684\u914d\u7f6e\u53ca\u6570\u636e\u8bb0\u5f55\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"BcmModelCopyAndTransferPlugin_17", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("bcmModelCopyAndTransfer", (IFormPlugin)this));
                return;
            }
            this.modelCopyAndTransfer(value);
        }
    }

    private void getSingleSelVal(Map<String, Set<Long>> ids) {
        Map allFields = this.getModel().getDataEntityType().getAllFields();
        allFields.forEach((key, prop) -> {
            Boolean value;
            if (key.startsWith(PREFIX) && (value = (Boolean)this.getModel().getValue(key)).booleanValue()) {
                ids.put((String)key, (Set<Long>)null);
            }
        });
    }

    private void getMulboxVal(Map<String, Set<Long>> ids) {
        String invSheet;
        String invelimmul;
        String reportformmul;
        String reconcilemul;
        String businessmul;
        String dimensionmul = (String)this.getModel().getValue(DIMENSION_MUL);
        if (StringUtils.isNotEmpty((String)dimensionmul)) {
            ArrayList<String> list = new ArrayList<String>(Arrays.asList(dimensionmul.split(",")));
            ids.put("bcm_dimension", this.parseListToSet(list));
        }
        if (StringUtils.isNotEmpty((String)(businessmul = (String)this.getModel().getValue(BUSINESS_MUL)))) {
            List<String> list = Arrays.asList(businessmul.split(","));
            ids.put("bcm_bizruleentity", this.parseListToSet(list));
        }
        if (StringUtils.isNotEmpty((String)(reconcilemul = (String)this.getModel().getValue(RECONCILE_MUL)))) {
            List<String> list = Arrays.asList(reconcilemul.split(","));
            ids.put("bcm_checktmpl", this.parseListToSet(list));
        }
        if (StringUtils.isNotEmpty((String)(reportformmul = (String)this.getModel().getValue(REPORT_FORM_MUL)))) {
            List<String> list = Arrays.asList(reportformmul.split(","));
            ids.put("bcm_templateentity", this.parseListToSet(list));
        }
        if (StringUtils.isNotEmpty((String)(invelimmul = (String)this.getModel().getValue(INVELIM_MUL)))) {
            List<String> list = Arrays.asList(invelimmul.split(","));
            ids.put("bcm_invelimtemplate", this.parseListToSet(list));
        }
        if (StringUtils.isNotEmpty((String)(invSheet = (String)this.getModel().getValue(INV_SHEET)))) {
            List<String> list = Arrays.asList(invSheet.split(","));
            ids.put("bcm_papertemplate", this.parseListToSet(list));
        }
    }

    private Set<Long> parseListToSet(List<String> list) {
        long[] longs = list.stream().filter(StringUtils::isNotEmpty).mapToLong(Long::parseLong).toArray();
        HashSet<Long> set = new HashSet<Long>(16);
        for (long aLong : longs) {
            set.add(aLong);
        }
        return set;
    }

    private void exportModel(long modelId, boolean bool, Map<String, Set<Long>> ids, String secretkey, String filterEntityNum, Map<String, Set<Long>> dim2Ids) {
        ModelTransferParam modelTransferParam;
        boolean isTransferOlapData = false;
        if (bool) {
            boolean bol = Boolean.parseBoolean(this.getModel().getValue(IS_DATA_BOX).toString());
            if (bol) {
                isTransferOlapData = true;
            }
            modelTransferParam = ModelTransferParam.buildForExport(modelId, isTransferOlapData, null, secretkey, filterEntityNum, dim2Ids);
        } else {
            modelTransferParam = ModelTransferParam.buildForExport(modelId, isTransferOlapData, ids, secretkey, "", dim2Ids);
        }
        ModelTransferProcessService.transferOnLocal(modelTransferParam, this.getView());
        String modelName = (String)this.getModel().getValue(MODEL_NAME);
        OpNameMultiLangEnumBridge opName = new OpNameMultiLangEnumBridge("\u5bfc\u51fa\u4f53\u7cfb", "BcmModelCopyAndTransferPlugin_23", FI_BCM_FORMPLUGIN, "exportModel");
        OPDescMultiLangEnumBridge opDes = new OPDescMultiLangEnumBridge("%s\u5bfc\u51fa\u6210\u529f\u3002", "BcmModelCopyAndTransferPlugin_24", FI_BCM_FORMPLUGIN, OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{modelName}));
        this.writeMultiLangLog(opName, opDes);
    }

    private void transferModel(long modelId, boolean bool, Map<String, Set<Long>> ids, String filterEntityNum, Map<String, Set<Long>> dim2Ids) {
        ModelTransferParam modelTransferParam;
        String targetmodelNumber = this.getModel().getValue(TG_MODEL).toString();
        String targetmodelName = ((OrmLocaleValue)this.getModel().getValue("tgmodelname")).getLocaleValue();
        DynamicObject thirdDataCenter = (DynamicObject)this.getModel().getValue(THIRD_DATA_CENTER);
        String domainurl = thirdDataCenter.getString("address");
        String accountid = thirdDataCenter.getString("datasource");
        String appId = thirdDataCenter.getString("appid");
        String appPwd = thirdDataCenter.getString("password");
        String loginmobile = this.getModel().getValue("loginmobile").toString();
        String password = this.getModel().getValue("password").toString();
        try {
            ModelTransferHelper.getLoginToken(domainurl, accountid, loginmobile, password, appId, ThirdPartyDataCenterUtil.decrypterPwd((String)appPwd));
        }
        catch (KDBizException e) {
            this.getView().showErrorNotification(TransferMsgUtils.loginRemoteFailed());
        }
        boolean isTransferOlapData = false;
        boolean isForceMetaConsistent = Boolean.parseBoolean(this.getModel().getValue("forceconsistent").toString());
        if (bool) {
            boolean bol = Boolean.parseBoolean(this.getModel().getValue(IS_DATA_BOX).toString());
            if (bol) {
                isTransferOlapData = true;
            }
            modelTransferParam = ModelTransferParam.buildForRemoteCopy(modelId, targetmodelNumber, targetmodelName, isTransferOlapData, domainurl, accountid, loginmobile, password, null, isForceMetaConsistent, filterEntityNum, appId, appPwd, dim2Ids);
        } else {
            modelTransferParam = ModelTransferParam.buildForRemoteCopy(modelId, targetmodelNumber, targetmodelName, isTransferOlapData, domainurl, accountid, loginmobile, password, ids, isForceMetaConsistent, "", appId, appPwd, dim2Ids);
        }
        ModelTransferProcessService.transferOnLocal(modelTransferParam, this.getView());
        String modelName = (String)this.getModel().getValue(MODEL_NAME);
        OpNameMultiLangEnumBridge opName = new OpNameMultiLangEnumBridge("\u8fc1\u79fb\u4f53\u7cfb", "BcmModelCopyAndTransferPlugin_25", FI_BCM_FORMPLUGIN, "transferModel");
        OPDescMultiLangEnumBridge opDes = new OPDescMultiLangEnumBridge("%s\u8fc1\u79fb\u6210\u529f\u3002", "BcmModelCopyAndTransferPlugin_26", FI_BCM_FORMPLUGIN, OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{modelName}));
        this.writeMultiLangLog(opName, opDes);
    }

    private void copyModel(long modelId, boolean bool, Map<String, Set<Long>> ids, String filterEntityNum, Map<String, Set<Long>> dim2Ids) {
        ModelTransferParam modelTransferParam;
        String tgModelNumber = this.getModel().getValue(TG_MODEL).toString();
        String tgModelName = ((OrmLocaleValue)this.getModel().getValue("tgmodelname")).getLocaleValue();
        boolean isTransferOlapData = false;
        if (bool) {
            boolean bol = Boolean.parseBoolean(this.getModel().getValue(IS_DATA_BOX).toString());
            if (bol) {
                isTransferOlapData = true;
            }
            modelTransferParam = ModelTransferParam.buildForLocalCopy(modelId, tgModelNumber, tgModelName, isTransferOlapData, null, filterEntityNum, dim2Ids);
        } else {
            modelTransferParam = ModelTransferParam.buildForLocalCopy(modelId, tgModelNumber, tgModelName, true, ids, "", dim2Ids);
        }
        ModelTransferProcessService.transferOnLocal(modelTransferParam, this.getView());
        String modelName = (String)this.getModel().getValue(MODEL_NAME);
        OpNameMultiLangEnumBridge opName = new OpNameMultiLangEnumBridge("\u590d\u5236\u4f53\u7cfb", "BcmModelCopyAndTransferPlugin_27", FI_BCM_FORMPLUGIN, "transferModel");
        OPDescMultiLangEnumBridge opDes = new OPDescMultiLangEnumBridge("%s\u590d\u5236\u6210\u529f\u3002", "BcmModelCopyAndTransferPlugin_28", FI_BCM_FORMPLUGIN, OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{modelName}));
        this.writeMultiLangLog(opName, opDes);
    }

    private boolean validationModelAndBusiness(Map<String, Set<Long>> mapIds) {
        String ruleIds;
        Set<Long> checkIds = Optional.ofNullable(mapIds.get("bcm_checktmpl")).orElse(Collections.EMPTY_SET);
        Set<Long> formTempIds = Optional.ofNullable(mapIds.get("bcm_templateentity")).orElse(Collections.EMPTY_SET);
        Set<Long> invelimIds = Optional.ofNullable(mapIds.get("bcm_invelimtemplate")).orElse(Collections.EMPTY_SET);
        Set<Long> invSheetIds = Optional.ofNullable(mapIds.get("bcm_papertemplate")).orElse(Collections.EMPTY_SET);
        Set<Long> ruleSet = mapIds.get("bcm_bizruleentity");
        boolean bol = !checkIds.isEmpty() || !formTempIds.isEmpty() || !invelimIds.isEmpty() || !invSheetIds.isEmpty();
        String modelIds = this.getPageCache().get(MODEL_IDS_KYE);
        if (modelIds != null && StringUtils.isNotEmpty((String)modelIds)) {
            boolean b1;
            List ids = (List)ObjectSerialUtil.deSerializedBytes((String)modelIds);
            Set<Long> set = mapIds.get("bcm_dimension");
            boolean bl = b1 = ruleSet != null && !ruleSet.isEmpty();
            if ((bol || b1) && set == null || ids.size() != set.size()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7531\u4e8e\u4e1a\u52a1\u5173\u8054\u5173\u7cfb\uff0c\u8bf7\u5168\u9009\u7ef4\u5ea6\u5217\u8868\u3002", (String)"BcmModelCopyAndTransferPlugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return true;
            }
        }
        if (bol && (ruleIds = this.getPageCache().get(RULE_IDS_KYE)) != null && StringUtils.isNotEmpty((String)ruleIds)) {
            List ids = (List)ObjectSerialUtil.deSerializedBytes((String)ruleIds);
            if (ruleSet != null && ids.size() != ruleSet.size()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7531\u4e8e\u4e1a\u52a1\u5173\u8054\u5173\u7cfb\uff0c\u8bf7\u5168\u9009\u4e1a\u52a1\u89c4\u5219\u5217\u8868\u3002", (String)"BcmModelCopyAndTransferPlugin_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return true;
            }
        }
        return false;
    }

    private boolean validation(StringBuilder sbl) {
        String value = this.getModel().getValue(MODEL_GROUP).toString();
        DynamicObject model = (DynamicObject)this.getModel().getValue(MODEL);
        Boolean encryptExp = (Boolean)this.getModel().getValue(ENCRYPT_EXP);
        if (model == null) {
            sbl.append(ResManager.loadKDString((String)"\u6e90\u4f53\u7cfb\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BcmModelCopyAndTransferPlugin_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return true;
        }
        if (COPY_RADIO_VAL.equals(value)) {
            Object tgModel = this.getModel().getValue(TG_MODEL);
            String tgmodelname = ((OrmLocaleValue)this.getModel().getValue("tgmodelname")).getLocaleValue();
            if (tgModel == null || StringUtils.isEmpty((String)tgModel.toString())) {
                sbl.append(ResManager.loadKDString((String)"\u76ee\u6807\u4f53\u7cfb\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BcmModelCopyAndTransferPlugin_5", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return true;
            }
            String str = tgModel.toString();
            Pattern pattern = Pattern.compile(REGEX);
            Matcher matcher = pattern.matcher(str);
            if (!matcher.matches()) {
                sbl.append(ResManager.loadKDString((String)"\u76ee\u6807\u4f53\u7cfb\u7f16\u7801\u53ea\u80fd\u5305\u542b\u6570\u5b57\u3001\u5b57\u6bcd\u548c\u4e0b\u5212\u7ebf\u3002", (String)"BcmModelCopyAndTransferPlugin_6", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return true;
            }
            if (StringUtils.isEmpty((String)tgmodelname)) {
                sbl.append(ResManager.loadKDString((String)"\u76ee\u6807\u4f53\u7cfb\u540d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BcmModelCopyAndTransferPlugin_7", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return true;
            }
            String modelNumber = model.getString("shownumber");
            String tgModelNumber = this.getModel().getValue(TG_MODEL).toString();
            if (tgModelNumber.equals(modelNumber)) {
                sbl.append(ResManager.loadKDString((String)"\u76ee\u6807\u4f53\u7cfb\u4e0e\u539f\u4f53\u7cfb\u7f16\u7801\u4e0d\u80fd\u76f8\u540c\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u6b21\u6267\u884c\u3002", (String)"BcmModelCopyAndTransferPlugin_16", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return true;
            }
            if (tgModelNumber.length() > 25) {
                sbl.append(ResManager.loadKDString((String)"\u4f53\u7cfb\u7f16\u7801\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc725\u4f4d\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"BcmModelCopyAndTransferPlugin_22", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return true;
            }
        } else if (EXPORT_RADIO_VAL.equals(value)) {
            if (!encryptExp.booleanValue()) {
                return false;
            }
            String secretKey = (String)this.getModel().getValue(SECRET_KEY);
            if (StringUtils.isEmpty((String)secretKey)) {
                sbl.append(ResManager.loadKDString((String)"\u52a0\u5bc6\u5bfc\u51fa\u65f6\uff0c\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BcmModelCopyAndTransferPlugin_18", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return true;
            }
            if (secretKey.length() != 6) {
                sbl.append(ResManager.loadKDString((String)"\u52a0\u5bc6\u5bc6\u7801\u5fc5\u987b\u662f6\u4f4d\u6570\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u64cd\u4f5c\u3002", (String)"BcmModelCopyAndTransferPlugin_20", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return true;
            }
            Pattern pattern_z = Pattern.compile(REGEX_PASS_Z);
            Pattern pattern_s = Pattern.compile(REGEX_PASS_S);
            Matcher matcher_z = pattern_z.matcher(secretKey);
            Matcher matcher_s = pattern_s.matcher(secretKey);
            if (!matcher_z.matches() || !matcher_s.matches()) {
                sbl.append(ResManager.loadKDString((String)"\u52a0\u5bc6\u5bc6\u7801\u5fc5\u987b\u5305\u542b\u6570\u5b57\u548c\u5b57\u6bcd\u3002", (String)"BcmModelCopyAndTransferPlugin_19", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return true;
            }
        } else {
            Object targetmodel = this.getModel().getValue(TG_MODEL);
            String targetmodelname = ((OrmLocaleValue)this.getModel().getValue("tgmodelname")).getLocaleValue();
            Object thirdDataCenter = this.getModel().getValue(THIRD_DATA_CENTER);
            Object loginmobile = this.getModel().getValue("loginmobile");
            Object password = this.getModel().getValue("password");
            if (targetmodel == null || StringUtils.isEmpty((String)targetmodel.toString())) {
                sbl.append(ResManager.loadKDString((String)"\u76ee\u6807\u73af\u5883\u4f53\u7cfb\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BcmModelCopyAndTransferPlugin_8", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return true;
            }
            if (StringUtils.isEmpty((String)targetmodelname)) {
                sbl.append(ResManager.loadKDString((String)"\u76ee\u6807\u73af\u5883\u4f53\u7cfb\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BcmModelCopyAndTransferPlugin_9", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return true;
            }
            if (thirdDataCenter == null) {
                sbl.append(ResManager.loadKDString((String)"\u7b2c\u4e09\u65b9\u6570\u636e\u4e2d\u5fc3\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BcmModelCopyAndTransferPlugin_10", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return true;
            }
            if (loginmobile == null || StringUtils.isEmpty((String)loginmobile.toString())) {
                sbl.append(ResManager.loadKDString((String)"\u8fdc\u7a0b\u767b\u5f55\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BcmModelCopyAndTransferPlugin_12", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return true;
            }
            if (password == null || StringUtils.isEmpty((String)password.toString())) {
                sbl.append(ResManager.loadKDString((String)"\u8fdc\u7a0b\u767b\u5f55\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BcmModelCopyAndTransferPlugin_21", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return true;
            }
            if (targetmodel.toString().length() > 25) {
                sbl.append(ResManager.loadKDString((String)"\u4f53\u7cfb\u7f16\u7801\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc725\u4f4d\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"BcmModelCopyAndTransferPlugin_22", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return true;
            }
        }
        return false;
    }

    private void setDefault() {
        this.getModel().setValue(MODEL_GROUP, (Object)COPY_RADIO_VAL);
        this.getModel().setValue(IS_DATA_BOX, (Object)true);
        this.getModel().setValue(TYPE_RADIO_GROUP, (Object)ALL_RADIO_VAL);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String propertyVal;
        super.propertyChanged(e);
        switch (propertyVal = e.getProperty().getName()) {
            case "modelname": {
                DynamicObject model = (DynamicObject)this.getModel().getValue(MODEL);
                if (model == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6e90\u4f53\u7cfb\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BcmModelCopyAndTransferPlugin_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                    return;
                }
                this.builderMul(model.getLong("id"));
                break;
            }
            case "businessmul": {
                this.linkDimensionMul(DIMENSION_MUL, MODEL_IDS_KYE);
                break;
            }
            case "reconcilemul": 
            case "reportformmul": 
            case "invelimmul": 
            case "invsheet": {
                this.linkDimensionMul(DIMENSION_MUL, MODEL_IDS_KYE);
                this.linkDimensionMul(BUSINESS_MUL, RULE_IDS_KYE);
                break;
            }
            case "modelgroup": {
                this.setVisibleofEncryptexp();
            }
            case "encryptexp": {
                Boolean value = (Boolean)this.getModel().getValue(ENCRYPT_EXP);
                this.getView().setVisible(value, new String[]{SECRET_KEY});
                if (value.booleanValue()) {
                    FieldEdit secretKey = (FieldEdit)this.getView().getControl(SECRET_KEY);
                    secretKey.setMustInput(true);
                } else {
                    FieldEdit secretKey = (FieldEdit)this.getView().getControl(SECRET_KEY);
                    secretKey.setMustInput(false);
                }
            }
            case "mulscene": {
                this.getModel().setValue(MUL_PERIOD, null);
            }
            case "model": {
                this.getModel().setValue(THIRD_DATA_CENTER, null);
            }
        }
        if (propertyVal.startsWith(PREFIX)) {
            this.linkDimensionMul(DIMENSION_MUL, MODEL_IDS_KYE);
        }
    }

    private void builderMul(Long modelId) {
        String s1;
        if (modelId == 0L) {
            return;
        }
        String s = this.getPageCache().get(MODEL_IDS_KYE);
        if (StringUtils.isNotEmpty((String)s)) {
            this.getPageCache().remove(MODEL_IDS_KYE);
        }
        if (StringUtils.isNotEmpty((String)(s1 = this.getPageCache().get(RULE_IDS_KYE)))) {
            this.getPageCache().remove(RULE_IDS_KYE);
        }
        this.clearMulVal();
        this.clearCheckVal();
        this.setDimensionComboItem(modelId);
        this.setReconcileComboItem(modelId);
        this.setInvelimComboItem(modelId);
        this.setReportFormComboItem(modelId);
        this.setBusRuleComboItem(modelId);
        this.setInvSheetComboItem(modelId);
    }

    private void linkDimensionMul(String mul, String cacheKey) {
        String s;
        Object value = this.getModel().getValue(mul);
        List<Object> list = new ArrayList();
        if (value != null) {
            list = Arrays.stream(value.toString().split(",")).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
        }
        if (StringUtils.isEmpty((String)(s = this.getPageCache().get(cacheKey)))) {
            return;
        }
        List idSet = (List)ObjectSerialUtil.deSerializedBytes((String)s);
        if (list.size() != idSet.size()) {
            StringBuilder sb = new StringBuilder(",");
            idSet.forEach(key -> sb.append(key).append(','));
            this.getModel().setValue(mul, (Object)sb.toString());
        }
    }

    private void clearMulVal() {
        Arrays.asList(BUSINESS_MUL, REPORT_FORM_MUL, INVELIM_MUL, RECONCILE_MUL, DIMENSION_MUL).forEach(mul -> this.getModel().setValue(mul, null));
        this.getModel().setValue(MUL_SCENE, null);
        this.getModel().setValue(MUL_YEAR, null);
        this.getModel().setValue(MUL_PERIOD, null);
    }

    private void clearCheckVal() {
        Map allFields = this.getModel().getDataEntityType().getAllFields();
        allFields.forEach((key, prop) -> {
            if (key.startsWith(PREFIX)) {
                this.getModel().setValue(key, (Object)false);
            }
        });
    }

    private void setDimensionComboItem(Long modelId) {
        String selectFields = "id,name,number,shortnumber,membermodel,issysdimension,dseq";
        QFilter fmodelId = new QFilter(MODEL, "=", (Object)modelId);
        QFilter[] filters = new QFilter[]{fmodelId};
        String orderBys = "dseq";
        DynamicObjectCollection bcmDimension = QueryServiceHelper.query((String)"bcm_dimension", (String)selectFields, (QFilter[])filters, (String)orderBys);
        ArrayList idSet = new ArrayList(16);
        bcmDimension.forEach(dy -> idSet.add(dy.getLong("id")));
        this.getPageCache().put(MODEL_IDS_KYE, ObjectSerialUtil.toByteSerialized(idSet));
        this.setMulCombo(bcmDimension, DIMENSION_MUL);
    }

    private void setReconcileComboItem(Long modelId) {
        String selectFields = "id,name,number";
        QFilter fmodelId = new QFilter(MODEL, "=", (Object)modelId);
        QFilter[] filters = new QFilter[]{fmodelId};
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bcm_checktmpl", (String)selectFields, (QFilter[])filters);
        this.setMulCombo(dynamicObjects, RECONCILE_MUL);
    }

    private void setInvelimComboItem(Long modelId) {
        String selectFields = "id,name,billno";
        QFilter fmodelId = new QFilter(MODEL, "=", (Object)modelId);
        QFilter[] filters = new QFilter[]{fmodelId};
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bcm_invelimtemplate", (String)selectFields, (QFilter[])filters);
        this.setMulCombo(dynamicObjects, INVELIM_MUL);
    }

    private void setReportFormComboItem(Long modelId) {
        String selectFields = "id,name,number";
        QFilter fmodelId = new QFilter(MODEL, "=", (Object)modelId);
        QFilter ftemplatetype = new QFilter("templatetype", "in", Arrays.asList("0", COPY_RADIO_VAL));
        QFilter[] filters = new QFilter[]{fmodelId, ftemplatetype};
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bcm_templateentity", (String)selectFields, (QFilter[])filters);
        this.setMulCombo(dynamicObjects, REPORT_FORM_MUL);
    }

    private void setBusRuleComboItem(Long modelId) {
        String selectFields = "bizrule";
        QFilter fmodelId = new QFilter(MODEL, "=", (Object)modelId);
        QFilter[] filters = new QFilter[]{fmodelId};
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bcm_bizrulealloprocess", (String)selectFields, (QFilter[])filters);
        HashSet idSet = new HashSet();
        dynamicObjects.forEach(dy -> idSet.add(dy.getLong("bizrule")));
        fmodelId.and(new QFilter("id", "in", idSet));
        DynamicObjectCollection ruleDatas = QueryServiceHelper.query((String)"bcm_bizruleentity", (String)"id,number,name", (QFilter[])fmodelId.toArray());
        ArrayList list = new ArrayList(16);
        ruleDatas.forEach(dy -> list.add(dy.getLong("id")));
        this.getPageCache().put(RULE_IDS_KYE, ObjectSerialUtil.toByteSerialized(list));
        this.setMulCombo(ruleDatas, BUSINESS_MUL);
    }

    private void setMulCombo(DynamicObjectCollection bcmDimension, String control) {
        this.getModel().setValue(control, null);
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(16);
        MulComboEdit comboEdit = (MulComboEdit)this.getControl(control);
        if (bcmDimension == null || bcmDimension.isEmpty()) {
            comboEdit.setComboItems(comboItems);
            return;
        }
        for (DynamicObject dynamicObject : bcmDimension) {
            String number = dynamicObject.getString("id");
            String name = dynamicObject.getString("name");
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(name));
            comboItem.setValue(number);
            comboItems.add(comboItem);
        }
        comboEdit.setComboItems(comboItems);
    }

    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        super.confirmCallBack(mbce);
        String value = this.getModel().getValue(MODEL_GROUP).toString();
        String callBackId = mbce.getCallBackId();
        if ("bcmModelCopyAndTransfer".equals(callBackId) && mbce.getResult().equals((Object)MessageBoxResult.Yes)) {
            String tgModelNumber = this.getModel().getValue(TG_MODEL).toString();
            if (!this.isHaveDeletePerm(tgModelNumber)) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u539f\u4f53\u7cfb\u201c%s\u201d\u7684\u7ba1\u7406\u6743\uff0c\u65e0\u6cd5\u8986\u76d6\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"BcmModelCopyAndTransferPlugin_14", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), tgModelNumber));
                return;
            }
            Map<String, String> resultMap = this.deleteModel();
            String result = resultMap.get("result");
            if ("fail".equals(result)) {
                this.getView().showTipNotification(resultMap.get("msg"));
                return;
            }
            this.modelCopyAndTransfer(value);
        }
    }

    private void modelCopyAndTransfer(String value) {
        HashMap<String, Set<Long>> ids = new HashMap<String, Set<Long>>(16);
        this.getMulboxVal(ids);
        this.getSingleSelVal(ids);
        DynamicObject dynamic = (DynamicObject)this.getModel().getValue(MODEL);
        Boolean isSecret = (Boolean)this.getModel().getValue(ENCRYPT_EXP);
        String secretkey = isSecret != false ? (String)this.getModel().getValue(SECRET_KEY) : "";
        Object filter_entity = this.getModel().getValue(FILTER_ENTITY);
        String filterEntityNum = filter_entity == null ? "" : filter_entity.toString();
        HashMap<String, Set<Long>> dim2Ids = new HashMap<String, Set<Long>>(3);
        this.getFilterIds(dim2Ids);
        long modelId = dynamic.getLong("id");
        boolean bool = ALL_RADIO_VAL.equals(this.getModel().getValue(TYPE_RADIO_GROUP).toString());
        ProgressBar progressbarap = (ProgressBar)this.getControl(PROGRESSBARAP);
        switch (value) {
            case "1": {
                progressbarap.start();
                progressbarap.setPercent(0);
                this.getView().setVisible(Boolean.TRUE, new String[]{PROGRESSBARAP});
                this.getView().setEnable(Boolean.FALSE, new String[]{BUTTON_OK, BUTTON_EXIT});
                BatchProcessHelper.handleAsync(() -> this.copyModel(modelId, bool, ids, filterEntityNum, dim2Ids));
                break;
            }
            case "2": {
                progressbarap.start();
                progressbarap.setPercent(0);
                this.getView().setVisible(Boolean.TRUE, new String[]{PROGRESSBARAP});
                this.getView().setEnable(Boolean.FALSE, new String[]{BUTTON_OK, BUTTON_EXIT});
                BatchProcessHelper.handleAsync(() -> this.transferModel(modelId, bool, ids, filterEntityNum, dim2Ids));
                break;
            }
            case "10": {
                progressbarap.start();
                progressbarap.setPercent(0);
                this.getView().setVisible(Boolean.TRUE, new String[]{PROGRESSBARAP});
                this.getView().setEnable(Boolean.FALSE, new String[]{BUTTON_OK, BUTTON_EXIT});
                BatchProcessHelper.handleAsync(() -> this.exportModel(modelId, bool, ids, secretkey, filterEntityNum, dim2Ids));
                break;
            }
        }
    }

    private void getFilterIds(Map<String, Set<Long>> dim2Ids) {
        MulBasedataDynamicObjectCollection scenes = (MulBasedataDynamicObjectCollection)this.getModel().getValue(MUL_SCENE);
        HashSet<Long> sceneIds = new HashSet<Long>(10);
        if (scenes.size() != 0) {
            for (DynamicObject scene : scenes) {
                sceneIds.add(((DynamicObject)scene.get("fbasedataid")).getLong("id"));
            }
        }
        MulBasedataDynamicObjectCollection years = (MulBasedataDynamicObjectCollection)this.getModel().getValue(MUL_YEAR);
        HashSet<Long> yearIds = new HashSet<Long>(10);
        if (years.size() != 0) {
            for (DynamicObject year : years) {
                yearIds.add(((DynamicObject)year.get("fbasedataid")).getLong("id"));
            }
        }
        MulBasedataDynamicObjectCollection periods = (MulBasedataDynamicObjectCollection)this.getModel().getValue(MUL_PERIOD);
        HashSet<Long> periodIds = new HashSet<Long>(10);
        if (periods.size() != 0) {
            for (DynamicObject period : periods) {
                periodIds.add(((DynamicObject)period.get("fbasedataid")).getLong("id"));
            }
        }
        dim2Ids.put("scene", sceneIds);
        dim2Ids.put("year", yearIds);
        dim2Ids.put("period", periodIds);
    }

    private Map<String, String> deleteModel() {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        String tgModelNumber = this.getPageCache().get(TG_MODEL_NUMBER);
        this.getPageCache().remove(TG_MODEL_NUMBER);
        DynamicObject modelDy = QueryServiceHelper.queryOne((String)"bcm_model", (String)"id", (QFilter[])new QFilter("shownumber", "=", (Object)tgModelNumber).toArray());
        HashSet<Long> idSet = new HashSet<Long>(16);
        idSet.add(modelDy.getLong("id"));
        OperateOption op = OperateOption.create();
        String appId = this.getView().getFormShowParameter().getAppId();
        op.setVariableValue("appnumber", appId);
        OperationResult executeOperate = OperationServiceHelper.executeOperate((String)"modelforcedel", (String)"bcm_model", (Object[])idSet.toArray(), (OperateOption)op);
        if (executeOperate.getMessage() == null || executeOperate.getMessage().isEmpty()) {
            String number = this.getModel().getValue(TG_MODEL).toString();
            OpNameMultiLangEnumBridge opName = new OpNameMultiLangEnumBridge("\u5220\u9664", "ModelDistributeListPlugin_27", FI_BCM_FORMPLUGIN, "delete");
            OPDescMultiLangEnumBridge opDes = new OPDescMultiLangEnumBridge("\u201c%s\u201d\uff0c\u5220\u9664\u6210\u529f\u3002", "ModelDistributeListPlugin_26", FI_BCM_FORMPLUGIN, OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{number}));
            this.writeMultiLangLog(opName, opDes);
            resultMap.put("result", "success");
        } else {
            List error = executeOperate.getAllErrorOrValidateInfo();
            String errorMeg = error.isEmpty() ? executeOperate.getMessage() : ((IOperateInfo)error.get(0)).getMessage();
            resultMap.put("result", "fail");
            resultMap.put("msg", errorMeg);
            String number = this.getModel().getValue(TG_MODEL).toString();
            OpNameMultiLangEnumBridge opName = new OpNameMultiLangEnumBridge("\u5220\u9664", "ModelDistributeListPlugin_27", FI_BCM_FORMPLUGIN, "delete");
            OPDescMultiLangEnumBridge opDes = new OPDescMultiLangEnumBridge("\u201c%s\u201d\uff0c\u5220\u9664\u6210\u529f\u3002", "ModelDistributeListPlugin_26", FI_BCM_FORMPLUGIN, OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{number}));
            this.writeMultiLangLog(opName, opDes);
        }
        return resultMap;
    }

    private boolean isHaveDeletePerm(String tgModelNumber) {
        DynamicObject modelDy = QueryServiceHelper.queryOne((String)"bcm_model", (String)"id", (QFilter[])new QFilter("shownumber", "=", (Object)tgModelNumber).toArray());
        QFilter qfmodel = new QFilter(MODEL, "=", modelDy.get("id"));
        QFilter qfuser = new QFilter("modelpermentry.eusers", "=", (Object)Long.valueOf(RequestContext.get().getUserId()));
        DynamicObject doc = QueryServiceHelper.queryOne((String)"bcm_modelperm", (String)"modelpermentry.id", (QFilter[])new QFilter[]{qfmodel, qfuser});
        return doc != null;
    }

    private void setVisibleofEncryptexp() {
        String value = (String)this.getModel().getValue(MODEL_GROUP);
        if (EXPORT_RADIO_VAL.equals(value)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{ENCRYPT_EXP, SECRET_KEY});
        } else {
            this.getModel().setValue(ENCRYPT_EXP, (Object)false);
            this.getModel().setValue(SECRET_KEY, (Object)"");
            this.getView().setVisible(Boolean.valueOf(false), new String[]{ENCRYPT_EXP, SECRET_KEY});
        }
    }

    private void bindDataOfFilterentity() {
        DynamicObjectCollection filerMetas = QueryServiceHelper.query((String)"bcm_modelfiltermetaname", (String)"id,number,name", null);
        if (filerMetas == null || filerMetas.size() == 0) {
            return;
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl(FILTER_ENTITY);
        ArrayList items = new ArrayList();
        filerMetas.stream().forEach(n -> items.add(new ComboItem(new LocaleString(n.getString("name")), n.getString("number"))));
        comboEdit.setComboItems(items);
    }

    private void setInvSheetComboItem(Long modelId) {
        QFilter qf = new QFilter(MODEL, "=", (Object)modelId);
        QFilter qfNum = new QFilter("number", "=", (Object)"InvElim");
        DynamicObjectCollection paperCatelogs = QueryServiceHelper.query((String)"bcm_papertemplatecatalog", (String)"id", (QFilter[])new QFilter[]{qf, qfNum});
        Set ids = paperCatelogs.stream().map(x -> x.getLong("id")).collect(Collectors.toSet());
        qf.and(new QFilter("templatecatalog", "in", ids));
        DynamicObjectCollection invDatas = QueryServiceHelper.query((String)"bcm_papertemplate", (String)"id,name,number", (QFilter[])qf.toArray());
        this.setMulCombo(invDatas, INV_SHEET);
    }
}

