/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.model;

import java.util.EventObject;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.FyEnum;
import kd.fi.bcm.common.enums.PeriodLangENEnum;
import kd.fi.bcm.common.util.BlackListUtils;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.BCMBaseFunction;
import kd.fi.bcm.formplugin.dimension.util.ModelUtil;
import kd.fi.bcm.formplugin.util.OpenMenuPageUtil;
import kd.fi.bcm.formplugin.util.PageParamModel;

public class ModelDetailsViewEditPlugin
extends AbstractFormPlugin
implements BCMBaseFunction {
    private QFilter mfilter = null;

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"model", "dimension", "template", "bizrule", "taskconfig", "checked", "workpaper", "checktmpl"});
        this.addClickListeners(new String[]{"dsum", "msum", "ldsum", "tsize", "bsize", "labelc21", "labelc11", "tcsize", "tcsize"});
        if (BlackListUtils.hasFeatureInCm((String)"CMTask")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"taskconfig"});
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map map = this.getView().getFormShowParameter().getCustomParams();
        if (map == null) {
            return;
        }
        String modelId = map.get("KEY_MODEL_ID").toString();
        this.getPageCache().put("KEY_MODEL_ID", modelId);
        long longModelId = Long.parseLong(modelId);
        this.mfilter = new QFilter("model", "=", (Object)longModelId);
        String appNum = ModelUtil.queryApp((IFormView)this.getView()).appnum;
        if (appNum.equals(ApplicationTypeEnum.EB.appnum) || appNum.equals(ApplicationTypeEnum.BGMD.appnum) || appNum.equals(ApplicationTypeEnum.BGBD.appnum)) {
            this.setEbData();
        } else {
            this.setData(longModelId);
        }
        if (!ObjectUtils.isEmpty((Object)this.getView().getParentView()) && !ObjectUtils.isEmpty((Object)this.getView().getParentView().getParentView())) {
            String parentPage = this.getView().getParentView().getParentView().getPageId();
            this.getPageCache().put("appPageId", parentPage);
        }
    }

    private DynamicObject queryModelData(long modelId) {
        String selectFields = "id,number,name,presetyear,startfy,modifier.name,modifytime,beginperiodtext,shownumber,isspptproject,enable";
        QFilter qf = new QFilter("id", "=", (Object)modelId);
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"model", (String)"bcm_model", (String)selectFields, (QFilter[])qf.toArray(), null);
        if (doc.size() == 1) {
            return (DynamicObject)doc.get(0);
        }
        return null;
    }

    private DynamicObjectCollection queryDimensionData(QFilter mfilter) {
        DynamicObjectCollection doc;
        boolean result = this.isInterMem(mfilter);
        String selectFields = "id,name,number,issysdimension,membermodel,membertable";
        QFBuilder qBuilder = new QFBuilder();
        qBuilder.add("number", "!=", (Object)DimTypesEnum.DATATYPE.getNumber());
        qBuilder.add("number", "!=", (Object)DimTypesEnum.METRIC.getNumber());
        qBuilder.add(mfilter);
        String appNum = ModelUtil.queryApp(this.getView()).getAppnum();
        if (appNum.equals(ApplicationTypeEnum.BGBD.appnum) || appNum.equals(ApplicationTypeEnum.BGMD.appnum)) {
            qBuilder.add("number", "!=", (Object)DimTypesEnum.SCENARIO.getNumber());
            if (MemberReader.isExistAuditTrailDimension((long)this.getModelId())) {
                qBuilder.add("number", "!=", (Object)DimTypesEnum.AUDITTRIAL.getNumber());
            }
            qBuilder.add("number", "!=", (Object)DimTypesEnum.PROCESS.getNumber());
            if (this.getModel().getValue("isspptproject").equals(false)) {
                qBuilder.add("number", "!=", (Object)DimTypesEnum.CURRENCY.getNumber());
            }
        } else if (appNum.equals(ApplicationTypeEnum.EB.appnum)) {
            qBuilder.add("number", "!=", (Object)DimTypesEnum.SCENARIO.getNumber());
            qBuilder.add("number", "!=", (Object)DimTypesEnum.PROCESS.getNumber());
        }
        if (!result) {
            qBuilder.add("number", "!=", (Object)DimTypesEnum.INTERCOMPANY.getNumber());
        }
        if (!(doc = QueryServiceHelper.query((String)"bcm_dimension", (String)selectFields, (QFilter[])qBuilder.toArray())).isEmpty()) {
            return doc;
        }
        return null;
    }

    private boolean isInterMem(QFilter mfilter) {
        QFilter filter3 = new QFilter("issysmember", "!=", (Object)1);
        QFilter[] filters = new QFilter[]{mfilter, filter3};
        return QueryServiceHelper.exists((String)"bcm_icmembertree", (QFilter[])filters);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        if (!this.isModelHasDelete()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u5df2\u7ecf\u4e0d\u5b58\u5728\u3002", (String)"ModelDetailsViewEditPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "dimension": 
            case "dsum": 
            case "msum": 
            case "ldsum": {
                FormShowParameter parm = new FormShowParameter();
                if (ApplicationTypeEnum.RPT == ModelUtil.queryApp(this.getView())) {
                    parm.setCaption(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599", (String)"ModelDetailsViewEditPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                } else {
                    parm.setCaption(ResManager.loadKDString((String)"\u7ef4\u5ea6\u7ba1\u7406", (String)"ModelDetailsViewEditPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                this.showListView("bcm_dimensionmanager", parm, null);
                break;
            }
            case "template": 
            case "tsize": 
            case "bsize": {
                this.showListView("bcm_templatelist", (FormShowParameter)new ListShowParameter(), "bcm_templateentity");
                break;
            }
            case "bizrule": 
            case "labelc21": 
            case "labelc11": {
                ListShowParameter bizParm = new ListShowParameter();
                bizParm.setCaption(ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219\u5217\u8868", (String)"ModelDetailsViewEditPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                this.showListView("bcm_bizrulelist", (FormShowParameter)bizParm, "bcm_bizrulealloprocess");
                break;
            }
            case "taskconfig": 
            case "tcsize": 
            case "confsize": {
                this.showListView("bcm_tasklist", new FormShowParameter(), null);
                break;
            }
            case "model": {
                this.showBaseView(ShowType.Modal, "bcm_model", this.getPageCache().get("KEY_MODEL_ID"));
                break;
            }
            case "checked": {
                this.showListView("bcm_checkuplist", new FormShowParameter(), this.getPageCache().get("KEY_MODEL_ID"));
                break;
            }
            case "workpaper": {
                this.showListView("bcm_paperlist", (FormShowParameter)new ListShowParameter(), null);
                break;
            }
            case "checktmpl": {
                ListShowParameter listShowParameter = new ListShowParameter();
                listShowParameter.setCaption(ResManager.loadKDString((String)"\u5bf9\u8d26\u6a21\u677f\u5217\u8868", (String)"ModelDetailsViewEditPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                this.showListView("bcm_checktmpllist", (FormShowParameter)listShowParameter, "bcm_checktmpl");
                break;
            }
        }
    }

    private boolean isModelHasDelete() {
        return QueryServiceHelper.exists((String)"bcm_model", (Object)this.getPageCache().get("KEY_MODEL_ID"));
    }

    private void setData(long modelId) {
        this.setModelData(modelId);
        this.setDimensionData();
        this.setTemplateData();
        this.setTaskData();
        this.setCalculateData(true);
        this.setMergeData(true);
        this.setWorkPagper();
        this.setChecktmpl();
    }

    private void setEbData() {
        this.setTemplateData();
        this.setEbComputeRule();
        this.setEbTaskInfo();
        this.setEbTaskState();
        this.setEbUserInfo();
        this.setDimensionData();
    }

    private void setCheckedData() {
        int size = QueryServiceHelper.query((String)"bcm_chkformulasetting", (String)"id", (QFilter[])new QFilter[]{this.mfilter}).size();
        if (size > 0) {
            this.setLabelText("labelc11", String.valueOf(size));
            this.setVisible(true, "labelc11", "labelc12");
            this.setVisible(false, "imagec1", "labelc1");
        } else {
            this.setVisible(false, "labelc11");
        }
    }

    private void setTaskData() {
        int cSize = QueryServiceHelper.query((String)"bcm_taskcatalog", (String)"id", (QFilter[])new QFilter[]{this.mfilter}).size();
        if (cSize > 0) {
            this.setLabelText("tcsize", String.valueOf(cSize));
            this.setVisible(false, "imagetc1", "labeltc1");
        } else {
            this.setVisible(false, "tcsize", "labeltc");
        }
        QFilter filter1 = new QFilter("tasktype", "in", (Object)new String[]{"3", "5"});
        int tSize = QueryServiceHelper.query((String)"bcm_taskconfig", (String)"id", (QFilter[])new QFilter[]{this.mfilter, filter1}).size();
        if (tSize > 0) {
            this.setLabelText("confsize", String.valueOf(tSize));
            this.setVisible(false, "imagetc2", "labeltc2");
        } else {
            this.setVisible(false, "confsize", "labelconf");
        }
    }

    private void setEbComputeRule() {
        this.setVisible(false, "labelc21", "labelc22");
        this.setVisible(false, "labelc11", "labelc12");
    }

    private void setEbTaskInfo() {
        this.setVisible(false, "labeltc", "tcsize");
        this.setVisible(false, "confsize", "labelconf");
    }

    private void setEbTaskState() {
        this.setVisible(false, "tcsize1", "labeltc3");
        this.setVisible(false, "confsize1", "labelconf1");
        this.setVisible(false, "confsize11", "labelconf11");
    }

    private void setEbUserInfo() {
        this.setVisible(false, "labelc211", "labelc221");
        this.setVisible(false, "labelc111", "labelc121");
    }

    private void setCalculateData(boolean value) {
        if (value) {
            this.setVisible(false, "labelc11", "labelc12");
        } else {
            this.setVisible(false, "imagec1", "labelc1");
        }
        this.setBizRuleData();
        this.setCheckedData();
    }

    private void setBizRuleData() {
        QFilter filter = new QFilter("deletestatus", "=", (Object)false);
        int size = QueryServiceHelper.query((String)"bcm_bizruleentity", (String)"id", (QFilter[])new QFilter[]{this.mfilter, filter}).size();
        if (size > 0) {
            this.setLabelText("labelc21", String.valueOf(size));
            this.setVisible(false, "imagec2", "labelc2");
        } else {
            this.setVisible(false, "labelc21", "labelc22");
        }
    }

    private void setMergeData(boolean value) {
        if (value) {
            this.setVisible(false, "labelm11", "labelm12", "labelm21", "labelm22", "labelm31", "labelm32", "labelm41", "labelm42");
        } else {
            this.setVisible(false, "imagem1", "imagem2", "imagem3", "imagem4", "labelm1", "labelm2", "labelm3", "labelm4");
        }
    }

    private void setLabelText(String pname, String text) {
        Label countLabel = (Label)this.getControl(pname);
        countLabel.setText(text);
    }

    private void setModelData(long modelId) {
        DynamicObject dt = this.queryModelData(modelId);
        if (dt == null) {
            return;
        }
        boolean language = !Lang.get().equals((Object)Lang.zh_CN) && !Lang.get().equals((Object)Lang.zh_TW);
        this.setLabelText("mnumber", dt.getString("shownumber") + " " + dt.getString("name"));
        this.setLabelText("presetyear", dt.getString("beginperiodtext"));
        String beginperiodtext = dt.getString("beginperiodtext");
        if (language) {
            String year = dt.getString("beginperiodtext").substring(0, 2);
            String yearLs = ResManager.loadKDString((String)"\u5e74", (String)"ModelList_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            String monthLs = ResManager.loadKDString((String)"\u6708", (String)"ModelList_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            if ((FyEnum.CURRENT.getName().equals(year) || FyEnum.PRE.getName().equals(year)) && beginperiodtext.contains(yearLs) && beginperiodtext.contains(monthLs)) {
                String mouth = beginperiodtext.substring(2, beginperiodtext.length() - 1);
                String newyear = FyEnum.CURRENT.getName().equals(year) ? FyEnum.CURRENT.getName() : FyEnum.PRE.getName();
                String newbeginperiodtext = newyear + PeriodLangENEnum.getMouthByIndex((int)Integer.parseInt(mouth));
                this.setLabelText("presetyear", newbeginperiodtext);
            }
        }
        String yearLs = ResManager.loadKDString((String)"\u5e74", (String)"ModelDetailsViewEditPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        String strStartfy = language ? String.valueOf(dt.getInt("startfy") + 1997 - 1) : dt.getInt("startfy") + 1997 - 1 + yearLs;
        this.setLabelText("startfy", strStartfy);
        this.setLabelText("modifier", dt.getString("modifier.name"));
        this.setLabelText("modifytime", dt.getString("modifytime").substring(0, dt.getString("modifytime").lastIndexOf(46)));
    }

    private void setDimensionData() {
        DynamicObjectCollection doc = this.queryDimensionData(this.mfilter);
        if (doc == null) {
            return;
        }
        int dsum = 0;
        int msum = 0;
        for (DynamicObject d : doc) {
            if (Boolean.parseBoolean(d.getString("issysdimension"))) {
                ++dsum;
            }
            QFilter[] filters = null;
            QFilter dFilter = new QFilter("dimension", "=", (Object)d.getLong("id"));
            if ("bcm_entitymembertree".equals(d.getString("membermodel"))) {
                QFilter filter = new QFilter("isexchangerate", "=", (Object)false);
                filters = new QFilter[]{this.mfilter, filter, dFilter};
            } else {
                filters = new QFilter[]{this.mfilter, dFilter};
            }
            msum += this.querySizeFromModel(d.getString("membermodel"), filters);
        }
        this.setLabelText("dsum", doc.size() + "");
        this.setLabelText("ldsum", doc.size() - dsum + "");
        if (doc.size() - dsum == 0) {
            this.setVisible(false, "ldsum", "labeld");
            this.setVisible(true, "imaged1", "labeld1");
        } else {
            this.setVisible(true, "ldsum", "labeld");
            this.setVisible(false, "imaged1", "labeld1");
        }
        this.setLabelText("msum", msum + "");
    }

    private void setVisible(boolean value, String ... ctlKeys) {
        this.getView().setVisible(Boolean.valueOf(value), ctlKeys);
    }

    private int querySizeFromModel(String entityName, QFilter[] qFilters) {
        return ORM.create().count("querySizeFromModel", entityName, qFilters);
    }

    private void setTemplateData() {
        int tsize = this.querySizeFromModel("bcm_templateentity", new QFilter[]{this.mfilter});
        QFilter filter1 = new QFilter("usage", "=", (Object)"1");
        int bsize = this.querySizeFromModel("bcm_templateentity", new QFilter[]{filter1, this.mfilter});
        this.setLabelText("tsize", tsize + "");
        if (tsize == 0) {
            this.setVisible(false, "tsize", "labeltsize");
            this.setVisible(true, "imaget1", "labelt1");
        } else {
            this.setVisible(true, "tsize", "labeltsize");
            this.setVisible(false, "imaget1", "labelt1");
        }
        this.setLabelText("bsize", bsize + "");
        if (bsize == 0) {
            this.setVisible(false, "bsize", "labelbsize");
            this.setVisible(true, "imaget2", "labelt2");
        } else {
            this.setVisible(false, "imaget2", "labelt2");
            this.setVisible(true, "bsize", "labelbsize");
        }
    }

    private void showBaseView(ShowType showtype, String formid, Object pkid) {
        BaseShowParameter param = new BaseShowParameter();
        param.getOpenStyle().setShowType(showtype);
        param.setFormId(formid);
        param.setPkId(pkid);
        param.setStatus(OperationStatus.EDIT);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "status"));
        this.getView().showForm((FormShowParameter)param);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if (actionId.equals("status") && "success".equals(event.getReturnData())) {
            String modelId = this.getPageCache().get("KEY_MODEL_ID");
            this.setModelData(Long.parseLong(modelId));
        }
    }

    private void showListView(String formId, FormShowParameter param, String billFormId) {
        if (param instanceof ListShowParameter) {
            ((ListShowParameter)param).setBillFormId(billFormId);
        }
        PageParamModel pageModel = new PageParamModel(this.getView(), true, this.getPageCache().get("KEY_MODEL_ID"), this.getPageCache().get("appPageId"), formId, param);
        OpenMenuPageUtil.showFormViewByParam(pageModel);
    }

    private void setWorkPagper() {
        QFilter q = new QFilter("templatetype", "=", (Object)"2");
        DynamicObjectCollection dc = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id", (QFilter[])new QFilter[]{q, this.mfilter});
        int i = dc.size();
        if (i != 0) {
            this.setLabelText("labelm11", i + "");
            this.setVisible(true, "labelm11", "labelm12");
            this.setVisible(false, "imagem1", "labelm1");
        } else {
            this.setVisible(false, "labelm11", "labelm12");
            this.setVisible(true, "imagem1", "labelm1");
        }
    }

    private void setChecktmpl() {
        int i = this.querySizeFromModel("bcm_checktmpl", this.mfilter.toArray());
        if (i != 0) {
            this.setLabelText("labelm21", i + "");
            this.setVisible(true, "labelm21", "labelm22");
            this.setVisible(false, "imagem2", "labelm2");
        } else {
            this.setVisible(false, "labelm21", "labelm22");
            this.setVisible(true, "imagem2", "labelm2");
        }
    }

    @Override
    public AbstractFormPlugin getPlugin() {
        return this;
    }
}

