/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.model;

import com.google.common.collect.Sets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.mvc.base.BaseView;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.epbs.business.bd.model.ModelSyncHelper;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.interfaces.IInitSpecialTree;
import kd.fi.bcm.business.dimension.model.AbstractDimensionMemTree;
import kd.fi.bcm.business.dimension.predimensionhelper.DimensionXmlFactory;
import kd.fi.bcm.business.dimension.predimensionhelper.PreDimensionUtil;
import kd.fi.bcm.business.dimension.util.ModelDataClearUtils;
import kd.fi.bcm.business.dimension.util.ModelUtil;
import kd.fi.bcm.business.serviceHelper.AppCacheServiceHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.ICVersionServiceHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.AggOprtEnum;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.enums.FyEnum;
import kd.fi.bcm.common.enums.PeriodLangENEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.computing.util.BatchProcessHelper;
import kd.fi.bcm.formplugin.BCMBaseFunction;
import kd.fi.bcm.formplugin.IOperationLog;
import kd.fi.bcm.formplugin.util.FormUtils;

public class ModelEdit
extends AbstractFormPlugin
implements ClickListener,
BCMBaseFunction,
IOperationLog {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(ModelEdit.class);
    private static final String SYSPERIOD = "sysperiod";
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private static final String NUMBER = "number";
    private static final String MODEL = "model";
    private static final String START_FY = "startfy";
    private static final String PRESENT_FY = "presetyear";
    private static final String DIMENSION = "dimension";
    private static final String BTN_EDIT = "btn_edit";
    private static final String GLOABLEDIMENSION = "gloabledimension";
    private static final String ISDETAILTOMONTH = "isdetailtomonth";
    private static final String MINCLUDEQRT = "mincludeqrt";
    private static final String MINCLUDEYEAR = "mincludeyear";
    private static final String MONTHINCLUDE13 = "monthinclude13";
    private static final String ISDETAILTOQRT = "isdetailtoqrt";
    private static final String QRTINCLUDEYEAR = "qrtincludeyear";
    private static final String ISDETAILTODAY = "isdetailtoday";
    private static final String QRTINCLUDEMOUTH = "qrtincludemouth";
    private static final String BEGINYEAROFMONTH = "beginyearofmonth";
    private static final String BEGINPERIOD = "beginperiod";
    private static final String ISSPPTMYCOMPANY = "isspptmycompany";
    private static final String ISDETAILTOHALFYEAR = "isdetailtohalfyear";
    private static final String CALLBACK_SAVE_SOURCE = "callback_save_source";
    private static final String CALLBACK_SAVE_SOURCE_CLOSE = "callback_save_source_close";
    private static final String CALLBACK_SAVE_LOCK = "callback_save_lock";
    private static final String CALLBACK_SAVE_UNLOCK = "callback_save_unlock";

    private String getOperationStstusFail() {
        return ResManager.loadKDString((String)"\u5931\u8d25", (String)"ModelEdit_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    private String getOperationStstusSuccess() {
        return ResManager.loadKDString((String)"\u6210\u529f", (String)"ModelEdit_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    private String getOperationCreateNew() {
        return ResManager.loadKDString((String)"\u65b0\u589e\u4fdd\u5b58", (String)"ModelEdit_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    public void initialize() {
        super.initialize();
        ComboEdit edit = (ComboEdit)this.getView().getControl(START_FY);
        LocalDate today = LocalDate.now();
        int curYear = today.getYear();
        int firstYear = 1997;
        int index = curYear - firstYear + 1;
        int startTitle = curYear - 50;
        int startValue = index - 50;
        boolean language = !Lang.get().equals((Object)Lang.zh_CN) && !Lang.get().equals((Object)Lang.zh_TW);
        ArrayList<String[]> keysAndValues = new ArrayList<String[]>(56);
        String yearLs = ResManager.getLocaleString((String)"\u5e74", (String)"ModelEdit_21", (String)FI_BCM_FORMPLUGIN).getLocaleValue_zh_CN();
        for (int i = 0; i <= 55; ++i) {
            String[] keysAndValue = new String[]{language ? String.valueOf(startTitle) : startTitle + yearLs, String.valueOf(startValue)};
            keysAndValues.add(keysAndValue);
            ++startTitle;
            ++startValue;
        }
        FormUtils.customDynamicEnum(keysAndValues, edit);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_EDIT, GLOABLEDIMENSION});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object propValue = changeSet[0].getNewValue();
        switch (propName) {
            case "isdetailtomonth": {
                if ("true".equals(propValue.toString())) {
                    this.getView().setEnable(Boolean.TRUE, new String[]{MINCLUDEQRT});
                    this.getView().setEnable(Boolean.TRUE, new String[]{MINCLUDEYEAR});
                    this.getView().setEnable(Boolean.TRUE, new String[]{MONTHINCLUDE13});
                    break;
                }
                this.getView().setEnable(Boolean.FALSE, new String[]{MINCLUDEQRT});
                this.getView().setEnable(Boolean.FALSE, new String[]{MINCLUDEYEAR});
                this.getView().setEnable(Boolean.FALSE, new String[]{MONTHINCLUDE13});
                this.getModel().setValue(MINCLUDEQRT, (Object)Boolean.FALSE);
                this.getModel().setValue(MINCLUDEYEAR, (Object)Boolean.FALSE);
                this.getModel().setValue(MONTHINCLUDE13, (Object)Boolean.FALSE);
                break;
            }
            case "isdetailtoqrt": {
                if ("true".equals(propValue.toString())) {
                    this.getView().setEnable(Boolean.TRUE, new String[]{QRTINCLUDEYEAR});
                    break;
                }
                this.getView().setEnable(Boolean.FALSE, new String[]{QRTINCLUDEYEAR});
                this.getModel().setValue(QRTINCLUDEYEAR, (Object)Boolean.FALSE);
                break;
            }
            case "isdetailtoday": {
                if ("true".equals(propValue.toString())) {
                    this.getView().setEnable(Boolean.TRUE, new String[]{QRTINCLUDEMOUTH});
                    this.getModel().setValue(QRTINCLUDEMOUTH, (Object)Boolean.TRUE);
                    break;
                }
                this.getView().setEnable(Boolean.FALSE, new String[]{QRTINCLUDEMOUTH});
                this.getModel().setValue(QRTINCLUDEMOUTH, (Object)Boolean.FALSE);
                break;
            }
            case "beginyearofmonth": {
                int i;
                ArrayList<String[]> months = new ArrayList<String[]>();
                if (FyEnum.PRE.index.equals(this.getModel().getValue(BEGINYEAROFMONTH))) {
                    for (i = 2; i < 13; ++i) {
                        months.add(new String[]{PeriodLangENEnum.getMouthByIndex((int)i), i + ""});
                    }
                } else {
                    for (i = 1; i < 13; ++i) {
                        months.add(new String[]{PeriodLangENEnum.getMouthByIndex((int)i), i + ""});
                    }
                }
                ComboEdit monthcom = (ComboEdit)this.getView().getControl(BEGINPERIOD);
                FormUtils.customDynamicEnum(months, monthcom);
                this.getModel().setValue(BEGINPERIOD, (Object)((String[])months.get(0))[1]);
                break;
            }
            case "startfy": {
                if (OperationStatus.EDIT != this.getView().getFormShowParameter().getStatus()) break;
                String orify = this.getPageCache().get(START_FY);
                String oldpresetyear = this.getPageCache().get(PRESENT_FY);
                String fy = (String)this.getModel().getValue(START_FY);
                int diff = Integer.parseInt(orify) - Integer.parseInt(fy);
                if (diff < 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u9009\u62e9\u6bd4\u539f\u672c\u5927\u7684\u8d22\u5e74\u3002", (String)"ModelEdit_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                    this.getModel().getDataEntity().set(START_FY, (Object)orify);
                } else {
                    int presetyear = Integer.parseInt(oldpresetyear) + diff;
                    this.getModel().setValue(PRESENT_FY, (Object)presetyear);
                }
                this.getPageCache().put("startfyIsChange", "true");
                break;
            }
            case "issourcemeasure": {
                if (ThreadCache.exists((Object)"issourcemeasure")) {
                    return;
                }
                boolean isSourceMeasure = (Boolean)this.getModel().getValue("issourcemeasure");
                if (isSourceMeasure) {
                    DynamicObject ds = (DynamicObject)this.getModel().getValue("datasource");
                    if (ds != null && !OlapServiceHelper.canAddMeasure((Long)ds.getLong("id"))) {
                        ThreadCache.put((Object)"issourcemeasure", (Object)true);
                        this.getModel().setValue("issourcemeasure", (Object)false);
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u591a\u7ef4\u5e93\u7248\u672c\u4e0d\u652f\u6301\u5f00\u542f\uff0c\u8bf7\u5347\u7ea7\u591a\u7ef4\u5e93\u7248\u672c\u540e\u518d\u5f00\u542f\u3002", (String)"OlapServiceHelper_22", (String)"fi-bcm-business", (Object[])new Object[0]));
                        return;
                    }
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u542f\u7528\u6570\u636e\u6765\u6e90\u6807\u8bb0\u540e,\u4f1a\u5728\u591a\u7ef4\u5e93\u4e2d\u589e\u52a0\u4e00\u4e2a\u540d\u4e3aFSOURCE\u7684\u5ea6\u91cf\uff0c\u7528\u4e8e\u8bb0\u5f55\u591a\u7ef4\u6570\u636e\u7684\u6765\u6e90\u6807\u8bb0\u3002\u786e\u8ba4\u5f00\u542f\uff1f", (String)"ModelEdit_12", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CALLBACK_SAVE_SOURCE, (IFormPlugin)this));
                    break;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5173\u95ed\u6570\u636e\u6765\u6e90\u6807\u8bb0\u540e,\u4e0d\u518d\u8bb0\u5f55\u591a\u7ef4\u6570\u636e\u7684\u6765\u6e90\u6807\u8bb0\u3002\u786e\u8ba4\u5173\u95ed\uff1f", (String)"ModelEdit_17", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CALLBACK_SAVE_SOURCE_CLOSE, (IFormPlugin)this));
                break;
            }
            case "islockmeasure": {
                if (ThreadCache.exists((Object)"islockmeasure")) {
                    return;
                }
                boolean isLockmeasure = (Boolean)this.getModel().getValue("islockmeasure");
                if (isLockmeasure) {
                    DynamicObject ds = (DynamicObject)this.getModel().getValue("datasource");
                    if (ds != null && !OlapServiceHelper.canAddMeasure((Long)ds.getLong("id"))) {
                        ThreadCache.put((Object)"islockmeasure", (Object)true);
                        this.getModel().setValue("islockmeasure", (Object)false);
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u591a\u7ef4\u5e93\u7248\u672c\u4e0d\u652f\u6301\u5f00\u542f\uff0c\u8bf7\u5347\u7ea7\u591a\u7ef4\u5e93\u7248\u672c\u540e\u518d\u5f00\u542f\u3002", (String)"OlapServiceHelper_22", (String)"fi-bcm-business", (Object[])new Object[0]));
                        return;
                    }
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5f00\u542f\u62a5\u8868\u6570\u636e\u9501\u5b9a\u6807\u8bb0\u540e\uff0c\u4f1a\u5728\u591a\u7ef4\u5e93\u4e2d\u589e\u52a0\u4e00\u4e2a\u540d\u4e3aFLOCK\u7684\u5ea6\u91cf\uff0c\u5728\u62a5\u8868\u4e0a\u62a5\u65f6\u4f1a\u5199\u5165\u9501\u5b9a\u6807\u8bb0\u7528\u4e8e\u9501\u5b9a\u62a5\u8868\u6570\u636e\uff1b\u4e14\u5f00\u542f\u540e\uff0cCM034\u53c2\u6570\u4f1a\u5f3a\u5236\u5f00\u542f\uff0c\u7236\u7ea7\u7ec4\u7ec7\u62a5\u8868\u4e0a\u62a5\u65f6\u8981\u6c42\u4e0b\u7ea7\u7ec4\u7ec7\u62a5\u8868\u5fc5\u987b\u5148\u4e0a\u62a5\uff0c\u4e14\u5df2\u4e0a\u62a5\u7684\u62a5\u8868\u4e0d\u5141\u8bb8\u6267\u884c\u72b6\u6001\u91cd\u7f6e\u3002\u786e\u8ba4\u5f00\u542f\uff1f", (String)"ModelEdit_14", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CALLBACK_SAVE_LOCK, (IFormPlugin)this));
                    break;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5173\u95ed\u62a5\u8868\u6570\u636e\u9501\u5b9a\u6807\u8bb0\u540e\uff0c\u62a5\u8868\u4e0a\u62a5\u4e0d\u518d\u9501\u5b9a\u6570\u636e\uff0c\u4e14\u9700\u624b\u5de5\u68c0\u67e5CM034\u53c2\u6570\u8bbe\u7f6e\uff0c\u6309\u9700\u91cd\u65b0\u8bbe\u7f6e\u3002\u786e\u8ba4\u5173\u95ed\uff1f", (String)"ModelEdit_16", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CALLBACK_SAVE_UNLOCK, (IFormPlugin)this));
                break;
            }
        }
    }

    private void updateBeginDateReference(Object modelID) {
        if (this.getPageCache().get("startfyIsChange") == null) {
            return;
        }
        long modelId = LongUtil.toLong((Object)modelID);
        int firstYear = Integer.parseInt((String)this.getModel().getValue(START_FY)) + 1997 - 1;
        int firstMonth = Integer.parseInt((String)this.getModel().getValue(BEGINPERIOD));
        String beginYearType = (String)this.getModel().getValue(BEGINYEAROFMONTH);
        if (FyEnum.PRE.index.equals(beginYearType)) {
            --firstYear;
        }
        String dateStr = String.valueOf(firstYear).concat("-").concat(String.valueOf(firstMonth)).concat("-01");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-M-dd");
        long userId = this.getUserId();
        Date nowDate = TimeServiceHelper.now();
        Object[] parms = new Object[4];
        try {
            parms[0] = dateFormat.parse(dateStr);
        }
        catch (ParseException e) {
            log.error("error", (Throwable)e);
        }
        parms[1] = userId;
        parms[2] = nowDate;
        parms[3] = modelId;
        DBRoute route = new DBRoute("bcm");
        try {
            DB.execute((DBRoute)route, (String)"update t_bcm_entitybizrecord set feffdate = ?,FMODIFIER = ?,FMODIFYTIME = ? where fseq = 1 and fid in ( SELECT fid from t_bcm_structofent WHERE fmodelid = ?)", (Object[])parms);
            DB.execute((DBRoute)route, (String)"update t_bcm_entitynamerecord set feffdate = ?,FMODIFIER = ?,FMODIFYTIME = ? where fseq = 1 and fid in ( SELECT fid from t_bcm_structofent WHERE fmodelid = ?)", (Object[])parms);
            DB.execute((DBRoute)route, (String)"update t_bcm_currencyrecord set fcurrencyeffdate = ?,FCURRENCYMODIFIER = ?,FCURRENCYMODIFYTIME = ? where fseq = 1 and fid in ( SELECT fid from t_bcm_structofent WHERE fmodelid = ?)", (Object[])parms);
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4fee\u6539\u5931\u8d25\uff1a\u66f4\u65b0\u7ec4\u7ec7\u7684\u53d8\u66f4\u8bb0\u5f55\u7684\u751f\u6548\u65e5\u671f\u7684\u5f15\u7528\u5931\u8d25\u3002", (String)"ModelEdit_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
        try {
            Date newEffectiveDate = (Date)parms[0];
            QFilter qFilter = new QFilter(MODEL, "=", (Object)ConvertUtil.convertObjToLong((Object)modelID));
            qFilter.and("versionnumber", "=", (Object)1);
            DynamicObject[] templates = BusinessDataServiceHelper.load((String)"bcm_templateentity", (String)"effectivedate,modifier,modifytime", (QFilter[])new QFilter[]{qFilter});
            if (templates != null && templates.length > 0) {
                for (DynamicObject template : templates) {
                    template.set("effectivedate", (Object)newEffectiveDate);
                    template.set("modifier", (Object)userId);
                    template.set("modifytime", (Object)nowDate);
                }
                SaveServiceHelper.save((DynamicObject[])templates);
            }
        }
        catch (Exception e) {
            log.error("error", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u4fee\u6539\u5931\u8d25\uff1a\u66f4\u65b0\u62a5\u8868\u6a21\u677f\u751f\u6548\u65e5\u671f\u5931\u8d25\u3002", (String)"ModelEdit_6", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
        try {
            if (ConfigServiceHelper.getBoolParam((Long)modelId, (String)"CM060")) {
                DB.execute((DBRoute)route, (String)"update t_bcm_icchangerecord set feffdate = ?,fmodifierid = ?,fmodifytime = ? where fseq = 1 and fid in (select fid from t_bcm_structoficentity where fmodelid = ?)", (Object[])parms);
                BatchProcessHelper.handleAsync(() -> ICVersionServiceHelper.batchSynchroMemberSlowEvolving((long)modelId));
            }
        }
        catch (Exception e) {
            log.error(ResManager.loadKDString((String)"\u66f4\u65b0\u5f80\u6765\u7ec4\u7ec7\u7981\u7528\u8bb0\u5f55\u7684\u5f00\u59cb\u65e5\u671f\u5931\u8d25\u3002", (String)"ModelEdit_20", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
        this.getPageCache().remove("startfyIsChange");
    }

    private boolean getPreperiod(String preperiod) {
        Object isdetailtomonth = this.getModel().getValue(preperiod);
        if (isdetailtomonth != null) {
            return Boolean.parseBoolean(isdetailtomonth.toString());
        }
        return false;
    }

    private boolean isEDIT() {
        return OperationStatus.EDIT == this.getView().getFormShowParameter().getStatus();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean isdetailtomonth = this.getPreperiod(ISDETAILTOMONTH);
        this.getView().setEnable(Boolean.valueOf(isdetailtomonth), new String[]{MINCLUDEQRT});
        this.getView().setEnable(Boolean.valueOf(isdetailtomonth), new String[]{MINCLUDEYEAR});
        this.getView().setEnable(Boolean.valueOf(isdetailtomonth), new String[]{MONTHINCLUDE13});
        boolean isdetailtoqrt = this.getPreperiod(ISDETAILTOQRT);
        this.getView().setEnable(Boolean.valueOf(isdetailtoqrt), new String[]{QRTINCLUDEYEAR});
        boolean isdetailtoday = this.getPreperiod(ISDETAILTODAY);
        this.getView().setEnable(Boolean.valueOf(isdetailtoday), new String[]{QRTINCLUDEYEAR});
        this.getView().setEnable(Boolean.valueOf(isdetailtoday), new String[]{QRTINCLUDEMOUTH});
        this.getView().setVisible(Boolean.valueOf(ConfigServiceHelper.getGlobalBoolParam((String)"isOpenDataSourceTemp")), new String[]{"issourcemeasure"});
        this.hideItems();
        this.initEdit();
        this.initGloableValue();
        this.setIsSpptMyCompanyEnable();
        this.getModel().setDataChanged(false);
    }

    private void setIsSpptMyCompanyEnable() {
        if (OperationStatus.EDIT == this.getView().getFormShowParameter().getStatus()) {
            this.getModel().setValue(ISSPPTMYCOMPANY, (Object)DimensionServiceHelper.existsMyCompanyDim((long)((Long)this.getModel().getValue("id"))));
            this.getView().setEnable(Boolean.FALSE, new String[]{ISSPPTMYCOMPANY});
        }
        this.getView().setVisible(Boolean.valueOf(ConfigServiceHelper.getGlobalBoolParam((String)"CM01")), new String[]{ISSPPTMYCOMPANY});
    }

    private void initGloableValue() {
        if (OperationStatus.EDIT == this.getView().getFormShowParameter().getStatus()) {
            boolean ismonth = (Boolean)this.getModel().getValue(ISDETAILTOMONTH);
            boolean isqrt = (Boolean)this.getModel().getValue(ISDETAILTOQRT);
            int value = ismonth ? 2 : (isqrt ? 1 : 0);
            this.getModel().setValue(SYSPERIOD, (Object)value);
            Object modelid = ((BaseShowParameter)this.getView().getFormShowParameter()).getPkId();
            if (modelid != null) {
                Long modelIdLong = Long.valueOf(modelid.toString());
                QFilter modelQfilter = new QFilter(MODEL, "=", (Object)modelIdLong);
                QFilter gloableQfilter = new QFilter("issysdimension", "=", (Object)"1");
                QFilter userdefiedQfilter = new QFilter("issysdimension", "=", (Object)"0");
                QFilter modelidQfilter = new QFilter("id", "=", (Object)modelIdLong);
                DynamicObject modelobj = QueryServiceHelper.queryOne((String)"bcm_model", (String)"issourcemeasure,islockmeasure,isspptproject", (QFilter[])new QFilter[]{modelidQfilter});
                HashSet notseeItems = Sets.newHashSet((Object[])new String[]{DimEntityNumEnum.SCENARIO.getNumber(), DimEntityNumEnum.PROCESS.getNumber(), DimEntityNumEnum.CHANGETYPE.getNumber(), DimEntityNumEnum.AUDITTRIAL.getNumber(), DimEntityNumEnum.DATETYPE.getNumber(), DimEntityNumEnum.INTERCOMPANY.getNumber()});
                if (!modelobj.getBoolean("isspptproject")) {
                    notseeItems.add(DimEntityNumEnum.CURRENCY.getNumber());
                }
                boolean isSourcemeasure = modelobj.getBoolean("issourcemeasure");
                this.getModel().setValue("issourcemeasure", (Object)isSourcemeasure);
                boolean isLockMeasure = modelobj.getBoolean("islockmeasure");
                this.getModel().setValue("islockmeasure", (Object)isLockMeasure);
                DynamicObjectCollection gloableObjs = QueryServiceHelper.query((String)"bcm_dimension", (String)"name, number", (QFilter[])new QFilter[]{modelQfilter, gloableQfilter});
                DynamicObjectCollection userObjs = QueryServiceHelper.query((String)"bcm_dimension", (String)"name", (QFilter[])new QFilter[]{modelQfilter, userdefiedQfilter});
                StringBuilder sbGlo = new StringBuilder();
                StringBuilder sbUser = new StringBuilder();
                gloableObjs.forEach(e -> {
                    String number = e.getString(NUMBER);
                    if (!notseeItems.contains(number)) {
                        sbGlo.append(e.getString("name")).append('\uff0c');
                    }
                });
                userObjs.forEach(e -> sbUser.append(e.getString("name")).append('\uff0c'));
                if (sbGlo.length() > 0) {
                    this.getModel().setValue(GLOABLEDIMENSION, (Object)sbGlo.substring(0, sbGlo.length() - 1));
                }
                if (sbUser.length() > 0) {
                    this.getModel().setValue("userdimension", (Object)sbUser.substring(0, sbUser.length() - 1));
                }
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"userdimension"});
        }
    }

    private void initEdit() {
        if (this.isEDIT()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_EDIT});
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_save"});
            if (this.getModel().getValue(MONTHINCLUDE13).toString().equals("true")) {
                this.getView().setEnable(Boolean.FALSE, new String[]{MONTHINCLUDE13});
            }
            String fy = (String)this.getModel().getValue(START_FY);
            this.getPageCache().put(START_FY, fy);
            String presetyear = this.getModel().getValue(PRESENT_FY).toString();
            this.getPageCache().put(PRESENT_FY, presetyear);
            this.getView().setEnable(Boolean.TRUE, new String[]{"datasource"});
            Object datasource = this.getModel().getValue("datasource");
            if (datasource != null) {
                this.getPageCache().put("datasource_id", ((DynamicObject)datasource).getString("id"));
            }
            this.getView().setEnable(Boolean.valueOf(!this.getPreperiod(ISDETAILTODAY)), new String[]{"flexpanelap11"});
            this.getView().setEnable(Boolean.valueOf(!this.getPreperiod(ISDETAILTOMONTH)), new String[]{MINCLUDEQRT, MINCLUDEYEAR, ISDETAILTOMONTH});
            this.getView().setEnable(Boolean.valueOf(!this.getPreperiod(ISDETAILTOQRT)), new String[]{"flexpanelap1"});
            this.getView().setEnable(Boolean.valueOf(!this.getPreperiod(ISDETAILTOHALFYEAR)), new String[]{"flexpanelap3"});
            Object modelId = ((BaseShowParameter)this.getView().getFormShowParameter()).getPkId();
            boolean isOpenAdjust = ConfigServiceHelper.getBoolParam((Long)LongUtil.toLong((Object)modelId), (String)"isOpenAdjust");
            if (isOpenAdjust || !this.getPreperiod(ISDETAILTOMONTH)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{MONTHINCLUDE13});
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        LocalDate today = LocalDate.now();
        int curYear = today.getYear();
        int firstYear = 1997;
        int index = curYear - firstYear + 1;
        this.getModel().setValue(START_FY, (Object)String.valueOf(index));
        long datasource = OlapServiceHelper.selectDatasource((boolean)false);
        if (datasource == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u53ef\u7528\u7684OLAP\u670d\u52a1\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u914d\u7f6e\u540e\u91cd\u8bd5\u3002", (String)"ModelEdit_7", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        } else {
            this.getModel().setValue("datasource", (Object)datasource);
        }
        this.hideItems();
        this.getView().setEnable(Boolean.valueOf(this.getPreperiod(ISDETAILTODAY)), new String[]{QRTINCLUDEMOUTH});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        ApplicationTypeEnum application = ModelUtil.queryApp((IFormView)this.getView());
        switch (application) {
            case RPT: {
                this.getModel().setValue("reporttype", (Object)ApplicationTypeEnum.RPT.index);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        if ("save".equals(key)) {
            boolean issuccess;
            boolean bl = issuccess = e.getOperationResult().getValidateResult().isSuccess() && e.getOperationResult().isSuccess();
            if (issuccess) {
                DynamicObject dy;
                DynamicObject model;
                this.getView().returnDataToParent(e.getOperationResult().getSuccessPkIds().get(0));
                Long modelId = (Long)e.getOperationResult().getSuccessPkIds().get(0);
                ConfigServiceHelper.upgradeConfig((Object)modelId);
                if (ConfigServiceHelper.getBoolParam((Long)modelId, (String)"CM006") && (model = BusinessDataServiceHelper.loadSingle((Object)modelId, (String)"bcm_model", (String)NUMBER)) != null) {
                    OlapServiceHelper.setProcessShieldRule((String)model.getString(NUMBER));
                }
                if ((dy = QueryServiceHelper.queryOne((String)"bcm_model", (String)"name,shownumber,number,islockmeasure", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)modelId)})).getBoolean("islockmeasure")) {
                    ConfigServiceHelper.lockCM034((Long)modelId);
                }
                OpNameMultiLangEnumBridge opName = new OpNameMultiLangEnumBridge("\u65b0\u589e\u4fdd\u5b58", "ModelEdit_0", FI_BCM_FORMPLUGIN, "addSave");
                OPDescMultiLangEnumBridge opDes = new OPDescMultiLangEnumBridge("%1$s-%2$s\u6210\u529f\u3002", "ModelEdit_27", FI_BCM_FORMPLUGIN, OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{dy.getString("shownumber"), dy.getString("name")}));
                this.writeMultiLangLog(opName, opDes);
                this.getView().close();
                OlapServiceHelper.addPartitions((String)MemberReader.findModelNumberById((Object)modelId));
            } else {
                List errorInfos = e.getOperationResult().getAllErrorOrValidateInfo();
                StringBuilder message = new StringBuilder();
                String name = this.getPageCache().get("name");
                String shownumber = this.getPageCache().get("shownumber");
                OpNameMultiLangEnumBridge opName = new OpNameMultiLangEnumBridge("\u65b0\u589e\u4fdd\u5b58", "ModelEdit_0", FI_BCM_FORMPLUGIN, "addSave");
                OPDescMultiLangEnumBridge opDes = new OPDescMultiLangEnumBridge("%1$s-%2$s\u5931\u8d25\u3002", "ModelEdit_28", FI_BCM_FORMPLUGIN, OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{shownumber, name}));
                this.writeMultiLangLog(opName, opDes);
                if (errorInfos.isEmpty() && e.getOperationResult().getMessage() != null && !e.getOperationResult().getMessage().contains("Olap") && !e.getOperationResult().getMessage().contains("olap")) {
                    message.append(e.getOperationResult().getMessage());
                    this.getView().showTipNotification(message.toString());
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId;
        super.confirmCallBack(event);
        switch (callBackId = event.getCallBackId()) {
            case "callback_save_source": {
                if (!MessageBoxResult.Cancel.equals((Object)event.getResult())) break;
                this.updateValue("issourcemeasure", false);
                break;
            }
            case "callback_save_lock": {
                if (!MessageBoxResult.Cancel.equals((Object)event.getResult())) break;
                this.updateValue("islockmeasure", false);
                break;
            }
            case "callback_save_source_close": {
                if (!MessageBoxResult.Cancel.equals((Object)event.getResult())) break;
                this.updateValue("issourcemeasure", true);
                break;
            }
            case "callback_save_unlock": {
                if (!MessageBoxResult.Cancel.equals((Object)event.getResult())) break;
                this.updateValue("islockmeasure", true);
                break;
            }
        }
    }

    private void updateValue(String name, boolean value) {
        IDataModel model = this.getModel();
        model.beginInit();
        model.setValue(name, (Object)value);
        model.endInit();
        this.getView().updateView(name);
    }

    private void hideItems() {
        String[] hideitems = new String[]{SYSPERIOD, "gloableflex"};
        this.getView().setVisible(Boolean.FALSE, hideitems);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_EDIT.equals(key)) {
            OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue("name");
            if (name == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ModelEdit_8", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            }
            String orify = this.getPageCache().get(START_FY);
            String fy = this.getModel().getValue(START_FY).toString();
            long modelId = LongUtil.toLong((Object)((BaseShowParameter)this.getView().getFormShowParameter()).getPkId());
            DynamicObject model = BusinessDataServiceHelper.loadSingle((Object)modelId, (String)"bcm_model");
            String modelNum = model.getString(NUMBER);
            try (TXHandle tx = TX.required();){
                try {
                    OpNameMultiLangEnumBridge opName;
                    OPDescMultiLangEnumBridge opDes;
                    OpNameMultiLangEnumBridge opName2;
                    if (Boolean.parseBoolean(this.getModel().getValue(MONTHINCLUDE13).toString()) && !model.getBoolean(MONTHINCLUDE13)) {
                        this.saveM13Period(model);
                        model.set(MONTHINCLUDE13, (Object)1);
                    }
                    if (!fy.equals(orify)) {
                        this.insertYear(orify, fy, model);
                        model.set(START_FY, (Object)fy);
                        model.set(PRESENT_FY, this.getModel().getValue(PRESENT_FY));
                        this.getPageCache().put(START_FY, fy);
                        this.getPageCache().put(PRESENT_FY, this.getModel().getValue(PRESENT_FY).toString());
                    }
                    String description = this.getModel().getValue("description").toString();
                    model.set("description", (Object)description);
                    if (this.getModel().getValue("datasource") == null) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u6e90\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ModelEdit_9", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                    }
                    boolean isSourceMeasure = (Boolean)this.getModel().getValue("issourcemeasure");
                    if (isSourceMeasure && !model.getBoolean("issourcemeasure")) {
                        model.set("issourcemeasure", (Object)Boolean.TRUE);
                        model.set("sourcemeasureoptime", (Object)TimeServiceHelper.now());
                        opName2 = new OpNameMultiLangEnumBridge("\u4fee\u6539", "ModelEdit_22", FI_BCM_FORMPLUGIN, "update");
                        opDes = new OPDescMultiLangEnumBridge("%s\u542f\u7528\u6570\u636e\u6765\u6e90\u6807\u8bb0\u6210\u529f\u3002", "ModelEdit_23", FI_BCM_FORMPLUGIN, OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{name.getLocaleValue() == null ? name.toString() : name.getLocaleValue()}));
                        this.writeMultiLangLog(opName2, opDes);
                    } else if (!isSourceMeasure && model.getBoolean("issourcemeasure")) {
                        model.set("issourcemeasure", (Object)false);
                        model.set("sourcemeasureoptime", (Object)TimeServiceHelper.now());
                        opName2 = new OpNameMultiLangEnumBridge("\u4fee\u6539", "ModelEdit_22", FI_BCM_FORMPLUGIN, "update");
                        opDes = new OPDescMultiLangEnumBridge("%s\u5173\u95ed\u6570\u636e\u6765\u6e90\u6807\u8bb0\u6210\u529f\u3002", "ModelEdit_24", FI_BCM_FORMPLUGIN, OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{name.getLocaleValue() == null ? name.toString() : name.getLocaleValue()}));
                        this.writeMultiLangLog(opName2, opDes);
                    }
                    boolean isLockMeasure = (Boolean)this.getModel().getValue("islockmeasure");
                    if (isLockMeasure && !model.getBoolean("islockmeasure")) {
                        model.set("islockmeasure", (Object)Boolean.TRUE);
                        model.set("lockmeasureoptime", (Object)TimeServiceHelper.now());
                        opName = new OpNameMultiLangEnumBridge("\u4fee\u6539", "ModelEdit_22", FI_BCM_FORMPLUGIN, "update");
                        OPDescMultiLangEnumBridge opDes2 = new OPDescMultiLangEnumBridge("%s\u542f\u7528\u62a5\u8868\u6570\u636e\u9501\u5b9a\u6807\u8bb0\u6210\u529f\u3002", "ModelEdit_25", FI_BCM_FORMPLUGIN, OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{name.getLocaleValue() == null ? name.toString() : name.getLocaleValue()}));
                        this.writeMultiLangLog(opName, opDes2);
                    } else if (!isLockMeasure && model.getBoolean("islockmeasure")) {
                        model.set("islockmeasure", (Object)false);
                        model.set("lockmeasureoptime", (Object)TimeServiceHelper.now());
                        opName = new OpNameMultiLangEnumBridge("\u4fee\u6539", "ModelEdit_22", FI_BCM_FORMPLUGIN, "update");
                        OPDescMultiLangEnumBridge opDes3 = new OPDescMultiLangEnumBridge("%s\u5173\u95ed\u62a5\u8868\u6570\u636e\u9501\u5b9a\u6807\u8bb0\u6210\u529f\u3002", "ModelEdit_26", FI_BCM_FORMPLUGIN, OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{name.getLocaleValue() == null ? name.toString() : name.getLocaleValue()}));
                        this.writeMultiLangLog(opName, opDes3);
                    }
                    model.set("datasource", this.getModel().getValue("datasource"));
                    model.set("modifier", (Object)RequestContext.get().getCurrUserId());
                    model.set("modifytime", (Object)TimeServiceHelper.now());
                    this.updateSceneAndPeriodDimensionMembers(model);
                    model.set("name", (Object)name);
                    BusinessDataWriter.save((IDataEntityType)model.getDataEntityType(), (Object[])new Object[]{model});
                    this.updateBeginDateReference(modelId);
                    ModelDataClearUtils.reMoveCatalogCache((String)model.getString(NUMBER));
                    Set measures = OlapServiceHelper.getCubeMeasures((String)modelNum);
                    if (isSourceMeasure && !measures.contains(FacTabFieldDefEnum.FIELD_SOURCE.getField())) {
                        OlapServiceHelper.createMeasureSchemes((String)modelNum, (boolean)true, (String[])new String[]{FacTabFieldDefEnum.FIELD_SOURCE.getField()});
                        measures.add(FacTabFieldDefEnum.FIELD_SOURCE.getField());
                    }
                    if (isLockMeasure && !measures.contains(FacTabFieldDefEnum.FIELD_LOCK.getField())) {
                        OlapServiceHelper.createMeasureSchemes((String)modelNum, (boolean)true, (String[])new String[]{FacTabFieldDefEnum.FIELD_LOCK.getField()});
                        measures.add(FacTabFieldDefEnum.FIELD_LOCK.getField());
                    }
                    if (measures.contains(FacTabFieldDefEnum.FIELD_LOCK.getField())) {
                        OlapServiceHelper.lockMeasure((String)modelNum, (String)FacTabFieldDefEnum.FIELD_MONEY.getField(), (boolean)isLockMeasure);
                        if (measures.contains(FacTabFieldDefEnum.FIELD_SOURCE.getField())) {
                            OlapServiceHelper.lockMeasure((String)modelNum, (String)FacTabFieldDefEnum.FIELD_SOURCE.getField(), (boolean)isLockMeasure);
                        }
                    }
                    AppCacheServiceHelper.clearMeasureCache((String)modelNum);
                    GlobalCacheServiceHelper.getCommonCache().invalidateByKey("checkOlapDataSourceIsEffect" + model.getString(NUMBER));
                }
                catch (Throwable e1) {
                    tx.markRollback();
                    throw new KDBizException(new ErrorCode("Model_modifyError", e1.getMessage()), new Object[]{e1});
                }
            }
            if (((Boolean)this.getModel().getValue("islockmeasure")).booleanValue()) {
                ConfigServiceHelper.lockCM034((Long)modelId);
            }
            ModelSyncHelper.saveEpbsModel((Long)modelId, (String)model.getString("reporttype"));
            this.getModel().setDataChanged(false);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ModelEdit_10", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            this.getView().close();
        }
    }

    private void updateSceneAndPeriodDimensionMembers(DynamicObject model) {
        if (this.isEDIT()) {
            DynamicObject modelCopy = (DynamicObject)OrmUtils.clone((Object)model, (IDataEntityType)model.getDataEntityType(), (boolean)false, (boolean)false);
            boolean oldisdetailtoday = !model.getBoolean(ISDETAILTODAY) && this.getPreperiod(ISDETAILTODAY);
            boolean oldisdetailtomonth = !model.getBoolean(ISDETAILTOMONTH) && this.getPreperiod(ISDETAILTOMONTH);
            boolean oldisdetailtoqrt = !model.getBoolean(ISDETAILTOQRT) && this.getPreperiod(ISDETAILTOQRT);
            boolean oldisdetailtohalfyear = !model.getBoolean(ISDETAILTOHALFYEAR) && this.getPreperiod(ISDETAILTOHALFYEAR);
            modelCopy.set(ISDETAILTODAY, (Object)oldisdetailtoday);
            modelCopy.set(ISDETAILTOMONTH, (Object)oldisdetailtomonth);
            modelCopy.set(ISDETAILTOQRT, (Object)oldisdetailtoqrt);
            modelCopy.set(ISDETAILTOHALFYEAR, (Object)oldisdetailtohalfyear);
            if (oldisdetailtoday) {
                boolean qrtincludemouth = this.getPreperiod(QRTINCLUDEMOUTH);
                modelCopy.set(QRTINCLUDEMOUTH, (Object)qrtincludemouth);
                model.set(ISDETAILTODAY, (Object)Boolean.TRUE);
                model.set(QRTINCLUDEMOUTH, (Object)qrtincludemouth);
            }
            if (oldisdetailtomonth) {
                boolean mincludeqrt = this.getPreperiod(MINCLUDEQRT);
                boolean mincludeyear = this.getPreperiod(MINCLUDEYEAR);
                modelCopy.set(MINCLUDEQRT, (Object)mincludeqrt);
                modelCopy.set(MINCLUDEYEAR, (Object)mincludeyear);
                model.set(ISDETAILTOMONTH, (Object)Boolean.TRUE);
                model.set(MINCLUDEQRT, (Object)mincludeqrt);
                model.set(MINCLUDEYEAR, (Object)mincludeyear);
            }
            if (oldisdetailtoqrt) {
                boolean qrtincludeyear = this.getPreperiod(QRTINCLUDEYEAR);
                modelCopy.set(QRTINCLUDEYEAR, (Object)qrtincludeyear);
                model.set(ISDETAILTOQRT, (Object)Boolean.TRUE);
                model.set(QRTINCLUDEYEAR, (Object)qrtincludeyear);
            }
            if (oldisdetailtohalfyear) {
                model.set(ISDETAILTOHALFYEAR, (Object)Boolean.TRUE);
            }
            PreDimensionUtil.checkAndSetScenario((DynamicObject)modelCopy);
            AbstractDimensionMemTree treemodel = DimensionXmlFactory.getXmlTreemodel((String)DimTypesEnum.PERIOD.getNumber());
            treemodel.setModel(modelCopy);
            QFilter modelFilter = new QFilter(MODEL, "=", model.getPkValue());
            QFilter dimensionFilter = new QFilter(NUMBER, "=", (Object)DimTypesEnum.PERIOD.getNumber());
            DynamicObject dimensionId = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"id", (QFilter[])new QFilter[]{modelFilter, dimensionFilter});
            DynamicObject dimension = BusinessDataServiceHelper.loadSingle((Object)dimensionId.getLong("id"), (String)"bcm_dimension");
            treemodel.setDimension((Object)dimension);
            Long root = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_periodmembertree", (QFilter[])new QFilter[]{modelFilter, new QFilter("longnumber", "=", (Object)DimTypesEnum.PERIOD.getNumber())}).getLong("id");
            treemodel.setLongnumber(DimTypesEnum.PERIOD.getNumber());
            treemodel.setNumber(DimTypesEnum.PERIOD.getNumber());
            ((IInitSpecialTree)treemodel).initSpecialTrees();
            treemodel.setModel(model);
            int max = BusinessDataServiceHelper.loadFromCache((String)"bcm_periodmembertree", (QFilter[])new QFilter[]{modelFilter, new QFilter("parent", "=", (Object)root)}).size();
            for (AbstractDimensionMemTree treeDimensionModel : treemodel.getChildren()) {
                treeDimensionModel.setDseq(++max);
                treeDimensionModel.setParent(root);
                treeDimensionModel.actionSaveTreeMemAndOlap(true, true);
            }
            PreDimensionUtil.presetSPConfig((DynamicObject)modelCopy);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String page = ((BaseView)e.getSource()).getFormShowParameter().getParentFormId();
        if ("bcm_modelview".equals(page) || "eb_modelview".equals(page)) {
            this.getView().returnDataToParent((Object)"success");
        }
    }

    private void insertYear(String orify, String fy, DynamicObject model) {
        int oldfy = 1997 + Integer.parseInt(orify) - 1;
        int newfy = 1997 + Integer.parseInt(fy) - 1;
        int num = oldfy - newfy;
        Object[] mem = new DynamicObject[num];
        Object[] memTree = new DynamicObject[num];
        QFilter qfmodel = new QFilter(MODEL, "=", model.get("id"));
        QFilter qfdim = new QFilter("parent.number", "=", (Object)"AllYear");
        Object[] olds = BusinessDataServiceHelper.load((String)"bcm_fymembertree", (String)"id,name,number,model,dimension,dseq,parent,parent.longnumber,level", (QFilter[])new QFilter[]{qfdim, qfmodel}, (String)"dseq desc");
        boolean language = !Lang.get().equals((Object)Lang.zh_CN) && !Lang.get().equals((Object)Lang.zh_TW);
        String yearLs = ResManager.getLocaleString((String)"\u5e74", (String)"ModelEdit_21", (String)FI_BCM_FORMPLUGIN).getLocaleValue_zh_CN();
        for (int i = 0; i < num; ++i) {
            String number = "FY" + (newfy + i);
            String name = language ? String.valueOf(newfy + i) : newfy + i + yearLs;
            DynamicObject dynamicObject = olds[0];
            DynamicObject fymem = BusinessDataServiceHelper.newDynamicObject((String)"bcm_fymember");
            fymem.set(NUMBER, (Object)number);
            fymem.set("id", (Object)GlobalIdUtil.genGlobalLongId());
            fymem.set("name", (Object)name);
            fymem.set(MODEL, (Object)model);
            fymem.set(DIMENSION, dynamicObject.get(DIMENSION));
            fymem.set("status", (Object)"C");
            fymem.set("enable", (Object)1);
            fymem.set("modifier", (Object)RequestContext.get().getUserId());
            fymem.set("modifytime", (Object)TimeServiceHelper.now());
            fymem.set("creator", (Object)RequestContext.get().getUserId());
            fymem.set("createtime", (Object)TimeServiceHelper.now());
            DynamicObject fymemtree = BusinessDataServiceHelper.newDynamicObject((String)"bcm_fymembertree");
            fymemtree.set(MODEL, (Object)model);
            fymemtree.set(DIMENSION, dynamicObject.get(DIMENSION));
            fymemtree.set("member", (Object)fymem);
            fymemtree.set("aggoprt", (Object)AggOprtEnum.ADD.sign);
            fymemtree.set("storagetype", (Object)StorageTypeEnum.UNSHARE.index);
            fymemtree.set("level", dynamicObject.get("level"));
            fymemtree.set("isleaf", (Object)Boolean.TRUE);
            fymemtree.set(NUMBER, (Object)number);
            fymemtree.set("name", (Object)name);
            fymemtree.set("issysmember", (Object)1);
            fymemtree.set("dseq", (Object)(i + 1));
            fymemtree.set("parent", dynamicObject.get("parent"));
            fymemtree.set("longnumber", (Object)(dynamicObject.getString("parent.longnumber") + '!' + number));
            fymemtree.set("status", (Object)"C");
            fymemtree.set("enable", (Object)1);
            fymemtree.set("modifier", (Object)RequestContext.get().getUserId());
            fymemtree.set("modifytime", (Object)TimeServiceHelper.now());
            fymemtree.set("creator", (Object)RequestContext.get().getUserId());
            fymemtree.set("createtime", (Object)TimeServiceHelper.now());
            mem[i] = fymem;
            memTree[i] = fymemtree;
        }
        BusinessDataWriter.save((IDataEntityType)mem[0].getDataEntityType(), (Object[])mem);
        BusinessDataWriter.save((IDataEntityType)memTree[0].getDataEntityType(), (Object[])memTree);
        for (DynamicObject dynamicObject : olds) {
            dynamicObject.set("dseq", (Object)(dynamicObject.getInt("dseq") + num));
        }
        BusinessDataWriter.save((IDataEntityType)olds[0].getDataEntityType(), (Object[])olds);
        for (int i = 0; i < num; ++i) {
            String number = "FY" + (newfy + i);
            OlapServiceHelper.createMember((String)model.getString(NUMBER), (String)DimTypesEnum.YEAR.getNumber(), (String)number, (int)1, (String)"AllYear");
        }
    }

    private void saveM13Period(DynamicObject model) {
        QFilter qfmodel = new QFilter(MODEL, "=", model.get("id"));
        QFilter filter = new QFilter(NUMBER, "=", (Object)"M_M13");
        if (QueryServiceHelper.exists((String)"bcm_periodmember", (QFilter[])new QFilter[]{qfmodel, filter})) {
            return;
        }
        QFilter qfdim = new QFilter(NUMBER, "=", (Object)"M_M12");
        DynamicObject m12Mem = BusinessDataServiceHelper.loadSingle((String)"bcm_periodmember", (String)"id,name,number,model,dimension", (QFilter[])new QFilter[]{qfdim, qfmodel});
        DynamicObject permem = BusinessDataServiceHelper.newDynamicObject((String)"bcm_periodmember");
        permem.set(NUMBER, (Object)"M_M13");
        permem.set("name", (Object)ResManager.loadKDString((String)"13\u671f", (String)"ModelEdit_11", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        permem.set(MODEL, (Object)model);
        permem.set(DIMENSION, m12Mem.get(DIMENSION));
        permem.set("status", (Object)"C");
        permem.set("enable", (Object)1);
        permem.set("modifier", (Object)RequestContext.get().getUserId());
        permem.set("modifytime", (Object)TimeServiceHelper.now());
        BusinessDataWriter.save((IDataEntityType)permem.getDynamicObjectType(), (Object[])new Object[]{permem});
        DynamicObject m12MemTree = BusinessDataServiceHelper.loadSingle((String)"bcm_periodmembertree", (String)"id,name,number,model,dimension,dseq,parent,parent.number,parent.longnumber,level,expdate,effdate,expmonth,expday,effmonth,effday", (QFilter[])new QFilter[]{qfdim, qfmodel});
        DynamicObject entityTree = BusinessDataServiceHelper.newDynamicObject((String)"bcm_periodmembertree");
        entityTree.set(MODEL, (Object)model);
        entityTree.set(DIMENSION, m12MemTree.get(DIMENSION));
        entityTree.set("member", (Object)permem);
        entityTree.set("aggoprt", (Object)AggOprtEnum.SKIP.sign);
        entityTree.set("storagetype", (Object)StorageTypeEnum.STORAGE.index);
        entityTree.set("level", m12MemTree.get("level"));
        entityTree.set("isleaf", (Object)Boolean.TRUE);
        entityTree.set(NUMBER, (Object)"M_M13");
        entityTree.set("name", (Object)ResManager.loadKDString((String)"13\u671f", (String)"ModelEdit_11", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        entityTree.set("issysmember", (Object)1);
        entityTree.set("dseq", (Object)(m12MemTree.getInt("dseq") + 1));
        entityTree.set("parent", m12MemTree.get("parent"));
        entityTree.set("longnumber", (Object)(m12MemTree.getString("parent.longnumber") + '!' + "M_M13"));
        entityTree.set("status", (Object)"C");
        entityTree.set("enable", (Object)1);
        entityTree.set("creator", (Object)RequestContext.get().getUserId());
        entityTree.set("createtime", (Object)TimeServiceHelper.now());
        entityTree.set("modifier", (Object)RequestContext.get().getUserId());
        entityTree.set("modifytime", (Object)TimeServiceHelper.now());
        entityTree.set("expdate", (Object)m12MemTree.getString("expdate"));
        entityTree.set("effdate", (Object)m12MemTree.getString("expdate"));
        entityTree.set("expmonth", (Object)m12MemTree.getString("expmonth"));
        entityTree.set("expday", (Object)m12MemTree.getString("expday"));
        entityTree.set("effmonth", (Object)m12MemTree.getString("expmonth"));
        entityTree.set("effday", (Object)m12MemTree.getString("expday"));
        entityTree.set("relatednumber", (Object)"M_M12");
        entityTree.set("isadjust", (Object)"1");
        String yearNum = DimensionServiceHelper.getAllUseYear((long)model.getLong("id"));
        entityTree.set("useyear", (Object)yearNum);
        BusinessDataWriter.save((IDataEntityType)entityTree.getDynamicObjectType(), (Object[])new Object[]{entityTree});
        OlapServiceHelper.createMember((String)model.getString(NUMBER), (String)DimTypesEnum.PERIOD.getNumber(), (String)"M_M13", (int)5, (String)m12MemTree.getString("parent.number"));
    }

    @Override
    public AbstractFormPlugin getPlugin() {
        return this;
    }

    @Override
    public String getBizEntityNumber() {
        return this.getModel().getDataEntityType().getName();
    }

    @Override
    public String getBizAppId() {
        return this.getView().getFormShowParameter().getAppId();
    }

    @Override
    @Deprecated
    public void writeLog(String opName, String opDescriotion) {
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        AppLogInfo logInfo = OperationLogUtil.buildLogInfo((String)opName, (String)opDescriotion, null, (String)this.getBizEntityNumber());
        logService.addLog(logInfo);
    }

    @Deprecated
    public void writeOperationLog(String opName, String objNumber, String objName, String result) {
        this.writeLog(opName, objNumber + objName + "," + opName + result);
    }
}

