/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.bill.AbstractBillWebApiPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.serviceHelper.ModelPermHelper;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.json.JacksonUtils;
import kd.fi.bcm.common.util.OpenApiUtil;

public class ModelExistServerPlugin
extends AbstractBillWebApiPlugin {
    private static final Log LOG = LogFactory.getLog(ModelExistServerPlugin.class);
    private static final String appUrl = "/app/cm/modelInfo";

    public ApiResult doCustomService(Map<String, Object> params) {
        LOG.info("model_exist_server:" + JacksonUtils.toJson(params));
        Optional<String> paraValidator = this.validateParam(params);
        if (paraValidator.isPresent()) {
            return ApiResult.fail((String)paraValidator.get(), (String)"000001");
        }
        String reportType = (String)params.get("reportType");
        String modelNumber = (String)params.get("number");
        String modelName = (String)params.get("name");
        QFilter numberFilter = new QFilter("shownumber", "=", (Object)modelNumber);
        QFilter nameFilter = new QFilter("name", "=", (Object)modelName);
        QFilter reporttypeFilter = new QFilter("reporttype", "=", (Object)reportType);
        DynamicObject[] data = BusinessDataServiceHelper.load((String)"bcm_model", (String)"id", (QFilter[])new QFilter[]{numberFilter, nameFilter, reporttypeFilter});
        ArrayList resList = new ArrayList();
        HashMap<String, Long> resMap = null;
        String info = ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u4e0d\u5b58\u5728\u6216\u7528\u6237\u65e0\u5f53\u524d\u4f53\u7cfb\u4f7f\u7528\u6743\u3002", (String)"ModelExistServerPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        if (data != null && data.length > 0) {
            for (DynamicObject dynamicObject : data) {
                if (OpenApiUtil.getAuthStatus((String)appUrl) && !ModelPermHelper.hasModelPerm((long)dynamicObject.getLong("id"))) {
                    ApiResult res = ApiResult.success(resList);
                    res.setMessage(info);
                    return res;
                }
                resMap = new HashMap<String, Long>();
                resMap.put("id", dynamicObject.getLong("id"));
                resList.add(resMap);
            }
        }
        ApiResult res = ApiResult.success(resList);
        if (resList.size() == 0) {
            res.setMessage(info);
        }
        return res;
    }

    private Optional<String> validateParam(Map<String, Object> params) {
        if (Objects.isNull(params.get("number"))) {
            return Optional.of("param modelNumber is required.");
        }
        if (Objects.isNull(params.get("name"))) {
            return Optional.of("param modelName is required.");
        }
        String reportType = (String)params.get("reportType");
        if (Objects.isNull(reportType)) {
            return Optional.of("param reportType is required.");
        }
        if (!ApplicationTypeEnum.CM.getOIndex().equals(reportType) && !ApplicationTypeEnum.RPT.getOIndex().equals(reportType)) {
            return Optional.of("CM or RPT.");
        }
        return Optional.empty();
    }
}

