/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.model;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.login.utils.ErrorCodeUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.bos.zip.ZipFile;
import kd.bos.zip.exception.ZipException;
import kd.fi.bcm.business.dimension.helper.ImportJsonServiceHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.BlackListUtils;
import kd.fi.bcm.common.util.DownFileUtil;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.computing.util.BatchProcessHelper;
import kd.fi.bcm.formplugin.BCMBaseFunction;
import kd.fi.bcm.formplugin.model.transfer.ModelImportParam;
import kd.fi.bcm.formplugin.model.transfer.ModelTransferProcessService;
import kd.fi.bcm.formplugin.model.transfer.ModelTransferProgress;
import kd.fi.bcm.formplugin.model.transfer.core.ModelCheckInfo;
import kd.fi.bcm.formplugin.model.transfer.core.ModelTransferServiceHelper;
import kd.fi.bcm.formplugin.model.transfer.core.ModelTransferType;
import kd.fi.bcm.formplugin.model.transfer.core.service.ModelTransferServiceValidator;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;

public class ModelImportPlugin
extends AbstractFormPlugin
implements BCMBaseFunction,
UploadListener,
ProgresssListener {
    private static final String KEY_ATTACHMENTPANEL = "attachment";
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private static final WatchLogger LOG = BcmLogFactory.getWatchLogInstance(ModelImportPlugin.class);
    private static final String REGEX = "^[0-9a-zA-Z_]{1,}$";
    private List<Object> urls;
    private static final String[] controlName = new String[]{"number", "name", "forceconsistent"};
    private static final String IMPORT_CONFIRM = "confirm";
    private static final String IMPORT_CLOSE = "close";
    private static final String IMPORT_PROCESS_BAR = "importpgbarap";
    private static final String IMPORTOLDTYPE = "importoldtype";
    private static final String T_BCM_MODEL = "t_bcm_model";
    private static final String DATASOURCE = "datasource";
    private static final String URLS = "urls";
    private static final String DATACONNECT = "dataconnect";
    private static final String CYPHER = "cypher";
    private static final String IS_ENCRYPT = "isEncrypt";
    private static final String LOCAL_FILE_URL = "local_file_url";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl(KEY_ATTACHMENTPANEL);
        attachmentPanel.addUploadListener((UploadListener)this);
        this.addClickListeners(new String[]{IMPORT_CONFIRM});
        ProgressBar progressbarap = (ProgressBar)this.getControl(IMPORT_PROCESS_BAR);
        progressbarap.addProgressListener((ProgresssListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        String isBlackList = (String)this.getView().getFormShowParameter().getCustomParam("isBlackList");
        if (BlackListUtils.hasFeatureInCm((String)"CMMultiModel") && "1".equals(isBlackList)) {
            boolean isCM = ApplicationTypeEnum.CM.getAppnum().equals(this.getApplicationType().getAppnum());
            String number = isCM ? "CMNG" : "FRNG";
            String name = isCM ? ResManager.loadKDString((String)"\u4e2d\u578b\u4f01\u4e1a\u6807\u51c6\u7248\u5408\u5e76\u62a5\u8868\u4f53\u7cfb", (String)"ModelImportPlugin_15", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4e2d\u578b\u4f01\u4e1a\u6807\u51c6\u7248\u8d22\u52a1\u62a5\u8868\u4f53\u7cfb", (String)"ModelImportPlugin_16", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
            this.getModel().setValue("number", (Object)number);
            this.getModel().setValue("name", (Object)name);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{IMPORTOLDTYPE, KEY_ATTACHMENTPANEL});
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{CYPHER});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (IMPORT_CONFIRM.equals(control.getKey())) {
            boolean importoldtype = (Boolean)this.getModel().getValue(IMPORTOLDTYPE);
            if (importoldtype) {
                this.importJSONCheck();
            } else {
                this.importZIPCheck();
            }
        }
    }

    private void importJSONCheck() {
        if (this.getPageCache().get(URLS) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6587\u4ef6", (String)"ModelUploadJsonFilePlugin_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        this.urls = (List)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(URLS));
        if (this.urls == null || this.urls.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6587\u4ef6", (String)"ModelUploadJsonFilePlugin_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        LOG.info(String.format(ResManager.loadKDString((String)"urls\u5143\u7d20\u4e2a\u6570\u4e3a%s", (String)"ModelImportPlugin_8", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), this.urls.size()));
        LOG.info(String.format(ResManager.loadKDString((String)"urls.get(0)\u4e3a%s", (String)"ModelImportPlugin_9", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), this.urls.get(0).toString()));
        StringBuilder sb = new StringBuilder();
        boolean flag = false;
        String modelNumber = "";
        LinkedHashMap linkedHashMap = (LinkedHashMap)this.urls.get(0);
        String type = linkedHashMap.get("type").toString();
        if (!"json".equals(type)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u6570\u636e\u683c\u5f0f\u5e94\u4e3aJSON\u683c\u5f0f\u3002", (String)"ModelImportPlugin_7", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        for (Object url : this.urls) {
            String json = ImportJsonServiceHelper.loadTextFileString((String)((String)((Map)url).get("url")));
            JSONObject jsonObject = null;
            try {
                jsonObject = JSONObject.parseObject((String)json, (Feature[])new Feature[]{Feature.OrderedField});
            }
            catch (Exception e) {
                LOG.error("169--JSONObject.parseObject() error\uff1a" + e.getMessage(), (Throwable)e);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u89e3\u6790\u6587\u4ef6\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u8be5\u6587\u4ef6\u662f\u5426\u662f\u672c\u5e94\u7528\u4f53\u7cfb\u6587\u4ef6\u3002", (String)"ModelImportPlugin_12", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            JSONObject modelObj = (JSONObject)jsonObject.get((Object)"bcm_model");
            JSONArray model = (JSONArray)modelObj.getJSONArray(T_BCM_MODEL).get(0);
            int reporttypeIndex = model.indexOf((Object)"FREPORTTYPE");
            String reporttype = ((JSONArray)modelObj.getJSONArray(T_BCM_MODEL).get(1)).get(reporttypeIndex).toString();
            if (!this.getApplicationType().getOIndex().equals(reporttype)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u8de8\u5e94\u7528\u5bfc\u5165\u3002", (String)"ModelTransferProcessService_14", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            int index = model.indexOf((Object)"FSHOWNUMBER");
            int nameindex = model.indexOf((Object)"FNAME");
            if (index == -1) continue;
            String strNumber = ((JSONArray)modelObj.getJSONArray(T_BCM_MODEL).get(1)).get(index).toString();
            String strName = ((JSONArray)modelObj.getJSONArray(T_BCM_MODEL).get(1)).get(nameindex).toString();
            sb.append(strNumber).append("_").append(strName).append(" ");
            if (this.isExist(strNumber)) {
                flag = true;
            }
            modelNumber = strNumber;
        }
        if (flag) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5df2\u7ecf\u5b58\u5728\u7f16\u7801\u4e3a%s\u7684\u4f53\u7cfb,\u4e0d\u652f\u6301\u8986\u76d6\u5bfc\u5165\u3002", (String)"ModelUploadJsonFilePlugin_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), modelNumber));
        }
        Boolean connectionFlag = this.checkDataSource();
        if (!connectionFlag.booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fde\u63a5\u5931\u8d25\u3002", (String)"DataSourceEdit_7", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u786e\u5b9a\u5bfc\u5165\u7f16\u7801\u4e3a%s\u7684\u4f53\u7cfb\uff1f", (String)"ModelUploadJsonFilePlugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), modelNumber), MessageBoxOptions.YesNo, new ConfirmCallBackListener(IMPORT_CONFIRM, (IFormPlugin)this));
    }

    private void importZIPCheck() {
        Boolean connectionFlag;
        String number = this.getModel().getValue("number").toString();
        OrmLocaleValue strName = (OrmLocaleValue)this.getModel().getValue("name");
        DynamicObject datasource = (DynamicObject)this.getModel().getValue(DATASOURCE);
        if (StringUtils.isEmpty((String)number)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u4f53\u7cfb\u7f16\u7801\u3002", (String)"ModelImportPlugin_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        Pattern pattern = Pattern.compile(REGEX);
        Matcher matcher = pattern.matcher(number);
        if (!matcher.matches()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f53\u7cfb\u7f16\u7801\u53ea\u80fd\u5305\u542b\u6570\u5b57\u3001\u5b57\u6bcd\u548c\u4e0b\u5212\u7ebf\u3002", (String)"ModelImportPlugin_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isEmpty((String)strName.getLocaleValue())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u4f53\u7cfb\u540d\u79f0\u3002", (String)"ModelImportPlugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        if (datasource == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u6e90\u914d\u7f6e\u3002", (String)"ModelImportPlugin_13", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        String isBlackList = (String)this.getView().getFormShowParameter().getCustomParam("isBlackList");
        if (!BlackListUtils.hasFeatureInCm((String)"CMMultiModel") || !"1".equals(isBlackList)) {
            String fileUrl = this.getPageCache().get("file_url");
            if (fileUrl == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u5bfc\u5165\u6570\u636e\u3002", (String)"ModelImportPlugin_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            }
            if (StringUtils.isEmpty((String)this.getPageCache().get(URLS))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u5bfc\u5165\u6570\u636e\u3002", (String)"ModelImportPlugin_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            }
            List urls = (List)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(URLS));
            if (CollectionUtils.isEmpty((Collection)urls)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u5bfc\u5165\u6570\u636e\u3002", (String)"ModelImportPlugin_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            }
            LinkedHashMap linkedHashMap = (LinkedHashMap)urls.get(0);
            String type = linkedHashMap.get("type").toString();
            if (!"zip".equals(type)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u683c\u5f0f\u9519\u8bef\uff0c\u5e94\u5bfc\u5165ZIP\u683c\u5f0f\u6570\u636e\u3002", (String)"ModelImportPlugin_11", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
        }
        if (!(connectionFlag = this.checkDataSource()).booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fde\u63a5\u5931\u8d25\u3002", (String)"DataSourceEdit_7", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        String isEncrypt = this.getPageCache().get(IS_ENCRYPT);
        if (Boolean.TRUE.toString().equals(isEncrypt)) {
            String secretKey = (String)this.getModel().getValue(CYPHER);
            if (StringUtils.isEmpty((String)secretKey)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u52a0\u5bc6\u6587\u4ef6\u7684\u5bc6\u7801\u4e3a\u7a7a\uff0c\u8bf7\u8f93\u5165\u5bc6\u7801\u3002", (String)"ModelImportPlugin_14", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            if (secretKey.length() != 6) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u52a0\u5bc6\u5bc6\u7801\u5fc5\u987b\u662f6\u4f4d\u6570\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u64cd\u4f5c\u3002", (String)"BcmModelCopyAndTransferPlugin_20", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
        }
        Double sourceServiceVersion = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)String.valueOf(ModelTransferServiceHelper.getCurrentServiceVersion())) ? null : Double.valueOf(ModelTransferServiceHelper.getCurrentServiceVersion());
        ModelTransferServiceValidator validator = new ModelTransferServiceValidator(ModelTransferType.IMPORT, number, sourceServiceVersion);
        ModelCheckInfo checkInfo = validator.validate();
        LOG.info("model_transfer_import_validate end");
        if (!checkInfo.getErrors().isEmpty()) {
            this.getView().showErrorNotification(checkInfo.getErrors().get(0));
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u5bfc\u5165\u4f53\u7cfb\uff1f\u5f53\u524d\u64cd\u4f5c\u4e0d\u53ef\u9006\u3002", (String)"ModelImportPlugin_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(IMPORT_CONFIRM, (IFormPlugin)this));
    }

    private Boolean checkDataSource() {
        DynamicObject dataSourceObject = (DynamicObject)this.getModel().getValue(DATASOURCE);
        if (dataSourceObject != null) {
            String dataConnect = dataSourceObject.getString(DATACONNECT);
            String userName = dataSourceObject.getString("username");
            String passWord = dataSourceObject.getString("password");
            if (StringUtils.isNotEmpty((String)dataConnect) && StringUtils.isNotEmpty((String)userName) && StringUtils.isNotEmpty((String)passWord)) {
                Boolean connectionFlag = OlapServiceHelper.checkIsOnline((String)dataConnect, (String)userName, (String)passWord);
                return connectionFlag;
            }
        }
        return Boolean.TRUE;
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        block19: {
            super.confirmCallBack(event);
            String callBackId = event.getCallBackId();
            if (MessageBoxResult.Yes.getValue() == event.getResult().getValue() && IMPORT_CONFIRM.equals(callBackId)) {
                boolean importoldtype = (Boolean)this.getModel().getValue(IMPORTOLDTYPE);
                if (importoldtype) {
                    this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u5bfc\u5165\uff0c\u8bf7\u7a0d\u540e\u3002", (String)"ModelImportPlugin_5", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0])));
                    this.importJSONType();
                } else {
                    ProgressBar progressbarap = (ProgressBar)this.getControl(IMPORT_PROCESS_BAR);
                    progressbarap.start();
                    progressbarap.setPercent(0);
                    this.getView().setVisible(Boolean.TRUE, new String[]{IMPORT_PROCESS_BAR});
                    this.getView().setEnable(Boolean.FALSE, new String[]{IMPORT_CONFIRM, IMPORT_CLOSE});
                    String isBlackList = (String)this.getView().getFormShowParameter().getCustomParam("isBlackList");
                    if (BlackListUtils.hasFeatureInCm((String)"CMMultiModel") && "1".equals(isBlackList)) {
                        String path = ApplicationTypeEnum.CM.getAppnum().equals(this.getApplicationType().getAppnum()) ? "model/cm/model_cm.zip" : "model/rpt/model_rpt.zip";
                        try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(path);){
                            Long dataSource;
                            File modelDataFile = DownFileUtil.downloadFile((InputStream)inputStream);
                            ModelImportParam importParam = new ModelImportParam();
                            importParam.setTargetModelNumber(this.getModel().getValue("number").toString());
                            importParam.setTargetModelName(((OrmLocaleValue)this.getModel().getValue("name")).getLocaleValue());
                            importParam.setDataURL(modelDataFile.getAbsolutePath());
                            importParam.setIsForceMetaConsistent(false);
                            importParam.setRequestSerializeID(GlobalIdUtil.genStringId());
                            importParam.setUnitTestFlag(false);
                            DynamicObject dataSourceObject = (DynamicObject)this.getModel().getValue(DATASOURCE);
                            if (dataSourceObject != null && (dataSource = (Long)dataSourceObject.getPkValue()) != null) {
                                importParam.setDataSourceId(dataSource);
                            }
                            ModelTransferProcessService.transferOnRemote(importParam, this.getView());
                            break block19;
                        }
                        catch (Exception e) {
                            throw new KDBizException((Throwable)e, ErrorCodeUtils.getSystemErrorCode((String)e.getMessage()), new Object[0]);
                        }
                    }
                    BatchProcessHelper.handleAsync(this::importZIPType);
                }
            }
        }
    }

    private void importZIPType() {
        String number = this.getModel().getValue("number").toString();
        OrmLocaleValue strName = (OrmLocaleValue)this.getModel().getValue("name");
        boolean isForceMetaConsistent = Boolean.parseBoolean(this.getModel().getValue("forceconsistent").toString());
        try {
            Long dataSource;
            String localFileUrl = this.getPageCache().get(LOCAL_FILE_URL);
            LOG.info("local cache file url\uff1a" + localFileUrl);
            localFileUrl = this.checkExistOfFile(localFileUrl);
            LOG.info("after check local cache file url\uff1a" + localFileUrl);
            ModelImportParam importParam = new ModelImportParam();
            importParam.setTargetModelNumber(number);
            importParam.setTargetModelName(strName.getLocaleValue());
            importParam.setDataURL(localFileUrl);
            importParam.setIsForceMetaConsistent(isForceMetaConsistent);
            importParam.setRequestSerializeID(GlobalIdUtil.genStringId());
            importParam.setCypher((String)this.getModel().getValue(CYPHER));
            importParam.setUnitTestFlag(false);
            DynamicObject dataSourceObject = (DynamicObject)this.getModel().getValue(DATASOURCE);
            if (dataSourceObject != null && (dataSource = (Long)dataSourceObject.getPkValue()) != null) {
                importParam.setDataSourceId(dataSource);
            }
            ModelTransferProcessService.transferOnRemote(importParam, this.getView());
        }
        catch (Exception e) {
            LOG.error("model_transfer_failed\uff1a" + e.getMessage(), (Throwable)e);
            throw new KDBizException((Throwable)e, ErrorCodeUtils.getSystemErrorCode((String)e.getMessage()), new Object[0]);
        }
    }

    private void importJSONType() {
        this.urls = (List)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(URLS));
        for (Object fileUrl : this.urls) {
            String json = ImportJsonServiceHelper.loadTextFileString((String)((String)((Map)fileUrl).get("url")));
            String cubeName = ImportJsonServiceHelper.getCubeName((String)json);
            if (OlapServiceHelper.isExistCube((String)cubeName)) {
                this.getView().hideLoading();
                String msgFormatter = ResManager.loadKDString((String)"\u5df2\u7ecf\u5b58\u5728\u540c\u540d(%s)\u7684\u591a\u7ef4\u6570\u636e\u5e93\uff0c\u8bf7\u624b\u52a8\u5220\u9664\u3002", (String)"ModelUploadJsonFilePlugin_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
                throw new KDBizException(String.format(msgFormatter, cubeName));
            }
            ModelImportPlugin.saveJson(json);
            OperationLogUtil.writeOperationLog((IFormView)this.getView(), (String)ResManager.loadKDString((String)"\u5bfc\u5165", (String)"ModelUploadJsonFilePlugin_5", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f", (String)"ModelUploadJsonFilePlugin_6", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), null);
        }
        this.getView().hideLoading();
        this.getView().returnDataToParent((Object)true);
        this.getView().close();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (IMPORTOLDTYPE.equals(name)) {
            Boolean importoldtype = (Boolean)this.getModel().getValue(IMPORTOLDTYPE);
            this.getModel().setValue("forceconsistent", (Object)(importoldtype == false ? 1 : 0));
            this.getView().setEnable(Boolean.valueOf(importoldtype == false), controlName);
            if (importoldtype.booleanValue()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{DATASOURCE});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{DATASOURCE});
            }
        }
    }

    public void upload(UploadEvent evt) {
        super.upload(evt);
        Boolean flag = (Boolean)this.getModel().getValue(IMPORTOLDTYPE);
        for (Object url : evt.getUrls()) {
            int nameIndex;
            String fileUrl = (String)((Map)url).get("url");
            this.getPageCache().put("file_url", (String)((Map)url).get("url"));
            if (flag.booleanValue()) continue;
            String name = ((LinkedHashMap)url).get("name").toString();
            String type = name.substring((nameIndex = name.lastIndexOf(46)) + 1);
            if (!"zip".equals(type)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u683c\u5f0f\u9519\u8bef\uff0c\u5e94\u5bfc\u5165ZIP\u683c\u5f0f\u6570\u636e\u3002", (String)"ModelImportPlugin_11", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            }
            String[] reqParams = new String[]{};
            try {
                reqParams = new URL(fileUrl).getQuery().split("&");
            }
            catch (MalformedURLException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw new KDBizException(e.getMessage());
            }
            HashMap<String, String> map = new HashMap<String, String>(reqParams.length);
            for (String param : reqParams) {
                String[] p = param.split("=");
                map.put(p[0], p[1]);
            }
            TempFileCacheDownloadable fileCache = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
            InputStream inputStream = fileCache.get((String)map.get("configKey"), (String)map.get("id")).getInputStream();
            File modelDataFile = DownFileUtil.downloadFile((InputStream)inputStream);
            ZipFile zipFile = new ZipFile(modelDataFile.getAbsolutePath());
            try {
                FieldEdit cypher;
                if (zipFile.isEncrypted()) {
                    cypher = (FieldEdit)this.getView().getControl(CYPHER);
                    cypher.setMustInput(true);
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{CYPHER});
                    this.getPageCache().put(IS_ENCRYPT, Boolean.TRUE.toString());
                } else {
                    cypher = (FieldEdit)this.getView().getControl(CYPHER);
                    cypher.setMustInput(false);
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{CYPHER});
                    this.getPageCache().put(IS_ENCRYPT, Boolean.FALSE.toString());
                }
                this.getPageCache().put(LOCAL_FILE_URL, modelDataFile.getAbsolutePath());
            }
            catch (ZipException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw new KDBizException(e.getMessage());
            }
            finally {
                try {
                    if (modelDataFile.exists()) {
                        FileUtils.forceDelete((File)modelDataFile);
                    }
                }
                catch (IOException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private boolean isExist(String number) {
        QFilter filter = new QFilter("shownumber", "=", (Object)number);
        return QueryServiceHelper.exists((String)"bcm_model", (QFilter[])filter.toArray());
    }

    public static void saveJson(String json) {
        String cubeName = ImportJsonServiceHelper.getCubeName((String)json);
        String modelid = null;
        try (TXHandle tx = TX.requiresNew();){
            try {
                ImportJsonServiceHelper.importSave((String)json);
                modelid = ImportJsonServiceHelper.changeModelPerm((String)json);
                if (!OlapServiceHelper.isExistCube((String)cubeName)) {
                    ImportJsonServiceHelper.createCube((String)json);
                }
            }
            catch (Throwable e1) {
                tx.markRollback();
                if (OlapServiceHelper.isExistCube((String)cubeName)) {
                    OlapServiceHelper.dropCubeSchemes((String)cubeName);
                }
                LOG.error("import model error:", e1);
                throw new KDBizException(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e1, (int)30));
            }
        }
        tx = TX.requiresNew();
        var4_4 = null;
        try {
            try {
                ImportJsonServiceHelper.addAllRootPermByUser((String)modelid);
            }
            catch (Throwable e1) {
                tx.markRollback();
            }
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    public void afterRemove(UploadEvent evt) {
        this.urls = (List)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(URLS));
        Object temp = null;
        for (Object o : evt.getUrls()) {
            for (Object url : this.urls) {
                if (!((Map)o).get("url").equals(((Map)url).get("url"))) continue;
                temp = url;
                break;
            }
            if (temp != null) break;
        }
        this.urls.remove(temp);
        this.getPageCache().put(URLS, ObjectSerialUtil.toByteSerialized(this.urls));
    }

    public void afterUpload(UploadEvent evt) {
        this.urls = new ArrayList<Object>();
        Collections.addAll(this.urls, evt.getUrls());
        this.getPageCache().put(URLS, ObjectSerialUtil.toByteSerialized(this.urls));
    }

    public void onProgress(ProgressEvent progressEvent) {
        ProgressBar progressbarap = (ProgressBar)this.getControl(IMPORT_PROCESS_BAR);
        ModelTransferProgress progressData = ModelTransferProgress.fromCache(this.getView());
        if (Objects.nonNull(progressData)) {
            int percent = progressData.getPercent();
            String message = progressData.getMessage();
            if (percent == -1) {
                progressEvent.setProgress(0);
                this.getView().showErrorNotification(message);
                progressbarap.stop();
                this.getView().setVisible(Boolean.FALSE, new String[]{IMPORT_PROCESS_BAR});
                this.getView().setEnable(Boolean.TRUE, new String[]{IMPORT_CONFIRM, IMPORT_CLOSE});
            } else {
                progressEvent.setProgress(percent);
                if (percent == 100) {
                    this.getView().showSuccessNotification(message);
                    progressbarap.stop();
                    this.getView().setVisible(Boolean.FALSE, new String[]{IMPORT_PROCESS_BAR});
                    this.getView().setEnable(Boolean.TRUE, new String[]{IMPORT_CONFIRM, IMPORT_CLOSE});
                    this.getView().returnDataToParent((Object)true);
                    this.getView().close();
                }
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        int percent;
        super.beforeClosed(e);
        ModelTransferProgress progressData = ModelTransferProgress.fromCache(this.getView());
        if (Objects.nonNull(progressData) && (percent = progressData.getPercent()) >= 0 && percent < 100) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f53\u7cfb\u5bfc\u5165\u6b63\u5728\u8fdb\u884c\u4e2d\uff0c\u8bf7\u52ff\u5173\u95ed\u6b64\u9875\u9762\u3002", (String)"ModelImportPlugin_10", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        this.bcmPreOpen(e);
    }

    @Override
    public AbstractFormPlugin getPlugin() {
        return this;
    }

    private String checkExistOfFile(String localFileUrl) throws Exception {
        String fileUrl = this.getPageCache().get("file_url");
        File file = new File(localFileUrl);
        if (!file.exists()) {
            LOG.info("localFileUrl file is not exist\uff1a" + localFileUrl);
            String[] reqParams = new URL(fileUrl).getQuery().split("&");
            HashMap<String, String> map = new HashMap<String, String>(reqParams.length);
            for (String param : reqParams) {
                String[] p = param.split("=");
                map.put(p[0], p[1]);
            }
            TempFileCacheDownloadable fileCache = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
            InputStream inputStream = fileCache.get((String)map.get("configKey"), (String)map.get("id")).getInputStream();
            File modelDataFile = DownFileUtil.downloadFile((InputStream)inputStream);
            localFileUrl = modelDataFile.getAbsolutePath();
        }
        return localFileUrl;
    }
}

