/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.serviceHelper.AppCacheServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.serviceHelper.UpgradeServiceHelper;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.FyEnum;
import kd.fi.bcm.common.enums.PeriodLangENEnum;
import kd.fi.bcm.common.enums.PermControlEnum;
import kd.fi.bcm.common.util.BlackListUtils;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.dimension.util.ModelUtil;
import kd.fi.bcm.formplugin.model.ListDataProviderExt;
import kd.fi.bcm.formplugin.util.BillListHyperLinkClickUtil;
import kd.fi.bcm.spread.common.util.StringUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;

public class ModelList
extends AbstractBaseListPlugin
implements ClickListener {
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private static final String BILLLISTTAP = "billlistap";
    private static final String DISTRIBUTE = "distribute";
    private static final List<String> NEED_ADMIN_PERMISSION = Arrays.asList("bcm_user_assignperm", "bcm_user_assignrole", "bcm_roleorguser", "perm_user_assigndisfun");
    public static final String ISMANAGER = "ISMANAGER";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btnok");
    }

    @Override
    public void preOpenForm(PreOpenFormEventArgs e) {
        long currUserId;
        super.preOpenForm(e);
        String appNum = e.getFormShowParameter().getAppId();
        if (StringUtils.isNotEmpty((String)appNum) && !PermissionServiceHelper.hasViewPermission((long)(currUserId = RequestContext.get().getCurrUserId()), (String)AppMetadataCache.getAppInfo((String)appNum).getId(), (String)"bcm_model")) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u65e0\u4efb\u4f55\u62a5\u8868\u4f53\u7cfb\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u4f53\u7cfb\u7ba1\u7406\u5458\u3002", (String)"UserSelectUtil_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
    }

    public void packageData(PackageDataEvent e) {
        String key;
        if (ColumnDesc.class.isAssignableFrom(e.getSource().getClass()) && StringUtil.equals((String)(key = ((ColumnDesc)e.getSource()).getKey()), (String)"beginperiodtext")) {
            boolean needTranslation;
            String value = e.getRowData().get(key).toString();
            boolean bl = needTranslation = !Lang.get().equals((Object)Lang.zh_CN) && !Lang.get().equals((Object)Lang.zh_TW);
            if (needTranslation) {
                String year = value.substring(0, 2);
                String yearLs = ResManager.loadKDString((String)"\u5e74", (String)"ModelList_18", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
                String monthLs = ResManager.loadKDString((String)"\u6708", (String)"ModelList_19", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
                if ((FyEnum.CURRENT.getName().equals(year) || FyEnum.PRE.getName().equals(year)) && value.contains(yearLs) && value.contains(monthLs)) {
                    String mouth = value.substring(2, value.length() - 1);
                    String newyear = FyEnum.CURRENT.getName().equals(year) ? FyEnum.CURRENT.getName() : FyEnum.PRE.getName();
                    e.setFormatValue((Object)(newyear + PeriodLangENEnum.getMouthByIndex((int)Integer.parseInt(mouth))));
                }
            }
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if ("btnok".equals(source.getKey())) {
            QFilter filters;
            ListSelectedRow selectedRow;
            Long modelId;
            DynamicObject[] orgs;
            if (this.isEPM() || this.isRPT()) {
                return;
            }
            BillList billList = (BillList)this.getControl(BILLLISTTAP);
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (!selectedRows.isEmpty() && (orgs = UpgradeServiceHelper.getOrgLevel2List((long)(modelId = (Long)(selectedRow = selectedRows.get(0)).getPrimaryKeyValue()))).length > 0 && !QueryServiceHelper.exists((String)"bcm_cslscheme", (QFilter[])(filters = QFilter.of((String)"model = ?", (Object[])new Object[]{modelId})).toArray())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u8fdb\u5165\u3010\u5e94\u7528\u4f53\u7cfb\u5217\u8868\u3011\u5347\u7ea7\u7ec4\u7ec7\u89c6\u56fe\u3002", (String)"ModelList_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            }
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        Boolean isManager;
        super.afterCreateNewData(e);
        RequestContext tx = RequestContext.get();
        long userId = Long.parseLong(tx.getUserId());
        boolean checkIsManager = this.getView().getFormShowParameter().getCustomParams().containsKey(ISMANAGER);
        if (checkIsManager && (isManager = (Boolean)this.getView().getFormShowParameter().getCustomParam(ISMANAGER)).booleanValue()) {
            AppCacheServiceHelper.put((String)(userId + ISMANAGER), (Object)true);
            this.getView().getPageCache().put(ISMANAGER, "true");
        }
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"f7selectedlistap"});
        ApplicationTypeEnum application = ModelUtil.queryApp(this.getView());
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"tblupdateorg"});
        if (ApplicationTypeEnum.CM != application) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_updateorgview"});
        }
        if (BlackListUtils.hasFeatureInCm((String)"CMMultiModel")) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"premodel"});
            DynamicObject[] model = this.getExitModel();
            if (model.length > 0) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"tblnew"});
            } else {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"tblnew"});
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"premodel"});
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        RequestContext tx = RequestContext.get();
        long userId = Long.parseLong(tx.getUserId());
        String isManager = this.getView().getPageCache().get(ISMANAGER);
        if (AppCacheServiceHelper.get((String)(userId + ISMANAGER)) != null || StringUtils.isNotEmpty((String)isManager)) {
            if ("true".equals(isManager)) {
                AppCacheServiceHelper.put((String)(userId + ISMANAGER), (Object)true);
            } else {
                AppCacheServiceHelper.put((String)(userId + ISMANAGER), (Object)false);
            }
        }
        this.filterByPermControl(e);
        if (this.noNeedDefaultQFilter()) {
            return;
        }
        e.getQFilters().add(ModelUtil.getModelQfilterByApp(this.getView()));
        IFormView parentViewNoPlugin = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentViewNoPlugin != null && (NEED_ADMIN_PERMISSION.contains(parentViewNoPlugin.getEntityId()) || parentViewNoPlugin.getEntityId().contains("apphome"))) {
            Set ids = MemberPermHelper.getLimitedModelListByUser();
            if (CollectionUtils.isNotEmpty((Collection)ids)) {
                e.getQFilters().add(new QFilter("id", "in", (Object)ids));
            } else {
                e.getQFilters().add(QFilter.of((String)"1 != 1", (Object[])new Object[0]));
            }
        }
    }

    private void filterByPermControl(SetFilterEvent e) {
        String cp = null;
        String matchValue = null;
        Set ids = null;
        List qFilters = e.getQFilters();
        Iterator iterator = qFilters.iterator();
        while (iterator.hasNext()) {
            QFilter next = (QFilter)iterator.next();
            if (!"permcontrol".equals(next.getProperty())) continue;
            ids = MemberPermHelper.getLimitedModelListByUser();
            matchValue = String.valueOf(next.getValue());
            cp = next.getCP();
            iterator.remove();
            break;
        }
        if (cp != null && cp.length() > 0) {
            switch (cp) {
                case "=": {
                    this.equalsPermControl(e, matchValue, ids);
                    break;
                }
                case "<>": {
                    this.notEqualsPermControl(e, matchValue, ids);
                    break;
                }
                case "like": {
                    this.likePermControl(e, matchValue, ids);
                    break;
                }
                case "not like": {
                    this.notLikePermControl(e, matchValue, ids);
                    break;
                }
                case "is null": {
                    this.isNullPermControl(e, ids);
                    break;
                }
            }
        }
    }

    private void isNullPermControl(SetFilterEvent e, Set<Long> ids) {
        e.getQFilters().add(new QFilter("id", "is null", ids));
    }

    private void notLikePermControl(SetFilterEvent e, String matchValue, Set<Long> ids) {
        String newMatch = matchValue.replace("%", "");
        if (matchValue.startsWith("%") && matchValue.endsWith("%")) {
            if (PermControlEnum.MANAGE.getName().contains(newMatch) && !PermControlEnum.USE.getName().contains(newMatch)) {
                e.getQFilters().add(new QFilter("id", "not in", ids));
            } else if (!PermControlEnum.MANAGE.getName().contains(newMatch) && PermControlEnum.USE.getName().contains(newMatch)) {
                e.getQFilters().add(new QFilter("id", "in", ids));
            } else if (PermControlEnum.MANAGE.getName().contains(newMatch) && PermControlEnum.USE.getName().contains(newMatch)) {
                this.isNullPermControl(e, ids);
            }
        }
    }

    private void likePermControl(SetFilterEvent e, String matchValue, Set<Long> ids) {
        String newMatch = matchValue.replace("%", "");
        if (matchValue.startsWith("%") && matchValue.endsWith("%")) {
            if (PermControlEnum.MANAGE.getName().contains(newMatch) && !PermControlEnum.USE.getName().contains(newMatch)) {
                e.getQFilters().add(new QFilter("id", "in", ids));
            } else if (!PermControlEnum.MANAGE.getName().contains(newMatch) && PermControlEnum.USE.getName().contains(newMatch)) {
                e.getQFilters().add(new QFilter("id", "not in", ids));
            } else if (!PermControlEnum.MANAGE.getName().contains(newMatch) && !PermControlEnum.USE.getName().contains(newMatch)) {
                this.isNullPermControl(e, ids);
            }
        } else if (!matchValue.startsWith("%") && matchValue.endsWith("%")) {
            this.startWithPermControl(e, ids, newMatch);
        } else if (matchValue.startsWith("%") && !matchValue.endsWith("%")) {
            this.endWithPermControl(e, ids, newMatch);
        }
    }

    private void endWithPermControl(SetFilterEvent e, Set<Long> ids, String newMatch) {
        if (PermControlEnum.MANAGE.getName().endsWith(newMatch) && !PermControlEnum.USE.getName().endsWith(newMatch)) {
            e.getQFilters().add(new QFilter("id", "in", ids));
        } else if (!PermControlEnum.MANAGE.getName().endsWith(newMatch) && PermControlEnum.USE.getName().endsWith(newMatch)) {
            e.getQFilters().add(new QFilter("id", "not in", ids));
        } else if (!PermControlEnum.MANAGE.getName().endsWith(newMatch) && !PermControlEnum.USE.getName().endsWith(newMatch)) {
            this.isNullPermControl(e, ids);
        }
    }

    private void startWithPermControl(SetFilterEvent e, Set<Long> ids, String newMatch) {
        if (PermControlEnum.MANAGE.getName().startsWith(newMatch) && !PermControlEnum.USE.getName().startsWith(newMatch)) {
            e.getQFilters().add(new QFilter("id", "in", ids));
        } else if (!PermControlEnum.MANAGE.getName().startsWith(newMatch) && PermControlEnum.USE.getName().startsWith(newMatch)) {
            e.getQFilters().add(new QFilter("id", "not in", ids));
        } else if (!PermControlEnum.MANAGE.getName().startsWith(newMatch) && !PermControlEnum.USE.getName().startsWith(newMatch)) {
            this.isNullPermControl(e, ids);
        }
    }

    private void notEqualsPermControl(SetFilterEvent e, String matchValue, Set<Long> ids) {
        if (PermControlEnum.MANAGE.getName().equals(matchValue)) {
            e.getQFilters().add(new QFilter("id", "not in", ids));
        } else if (PermControlEnum.USE.getName().equals(matchValue)) {
            e.getQFilters().add(new QFilter("id", "in", ids));
        }
    }

    private void equalsPermControl(SetFilterEvent e, String matchValue, Set<Long> ids) {
        if (PermControlEnum.MANAGE.getName().equals(matchValue)) {
            e.getQFilters().add(new QFilter("id", "in", ids));
        } else if (PermControlEnum.USE.getName().equals(matchValue)) {
            e.getQFilters().add(new QFilter("id", "not in", ids));
        } else {
            this.isNullPermControl(e, ids);
        }
    }

    private boolean noNeedDefaultQFilter() {
        return this.getView().getFormShowParameter().getCustomParam("noNeedDefaultQFilter") != null;
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        DynamicObject[] model;
        super.beforeItemClick(evt);
        String key = evt.getItemKey();
        BillList billList = (BillList)this.getControl(BILLLISTTAP);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (!("premodel".equals(key) || "import".equals(key) || "tblnew".equals(key) || "tblrefresh".equals(key) || "tblclose".equals(key) || !selectedRows.isEmpty())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6267\u884c\u6570\u636e\u3002", (String)"ModelList_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
        if (("tblnew".equals(key) || "premodel".equals(key)) && BlackListUtils.hasFeatureInCm((String)"CMMultiModel") && (model = this.getExitModel()).length > 0) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"tblnew"});
            String number = model[0].getString("model.shownumber");
            String name = model[0].getString("username");
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5df2\u7ecf\u5b58\u5728\u7f16\u7801\u4e3a\u201c%1$s\u201d\u7684\u4f53\u7cfb\uff0c\u5176\u4f53\u7cfb\u7ba1\u7406\u5458\u4e3a\u201c%2$s\u201d\u3002\u5f53\u524d\u8bb8\u53ef\u4e0d\u652f\u6301\u521b\u5efa\u591a\u4f53\u7cfb\u3002", (String)"ModelList_14", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), number, name));
        }
    }

    private DynamicObject[] getExitModel() {
        QFBuilder qf = new QFBuilder("model.reporttype", "=", (Object)ApplicationTypeEnum.getEnumByNumber((String)this.getBizAppId()).getOIndex());
        qf.and("model.shownumber", "!=", (Object)"");
        DynamicObject[] model = BusinessDataServiceHelper.load((String)"bcm_modelperm", (String)"id,username,model", (QFilter[])qf.toArray(), (String)"createtime desc");
        return model;
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("tblnew".equals(key)) {
            String appId = AppMetadataCache.getAppInfo((String)(this.isCM() ? ApplicationTypeEnum.CM.appnum : ApplicationTypeEnum.RPT.appnum)).getId();
            boolean hasPermission = PermissionServiceHelper.hasSpecificPerm((long)RequestContext.get().getCurrUserId(), (String)appId, (String)"bcm_model", (String)"47156aff000000ac");
            if (!hasPermission) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u65b0\u589e\u4f53\u7cfb\u7684\u64cd\u4f5c\u6743\u9650\u3002", (String)"ModelList_16", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            BaseShowParameter param = new BaseShowParameter();
            param.getOpenStyle().setShowType(ShowType.Modal);
            param.setFormId("bcm_model");
            param.setStatus(OperationStatus.ADDNEW);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "modelnew");
            param.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)param);
        } else if ("premodel".equals(key)) {
            FormShowParameter formparam = new FormShowParameter();
            formparam.setCaption(ResManager.loadKDString((String)"\u5bfc\u5165\u9884\u8bbe\u4f53\u7cfb", (String)"ModelList_15", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            formparam.setFormId("bcm_model_upload");
            formparam.getOpenStyle().setShowType(ShowType.Modal);
            formparam.setStatus(OperationStatus.ADDNEW);
            formparam.setCustomParam("isBlackList", (Object)"1");
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
            formparam.setCloseCallBack(closeCallBack);
            this.getView().showForm(formparam);
            this.reload();
        }
    }

    @Override
    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProviderExt());
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String formid = this.getView().getFormShowParameter().getFormId();
        if (!formid.equals("bos_listf7")) {
            this.showModelEditView(BillListHyperLinkClickUtil.getObjectPkIdFromEvt(args));
            args.setCancel(true);
        }
    }

    @Override
    public void listRowDoubleClick(ListRowClickEvent evt) {
        super.listRowDoubleClick(evt);
        BillList list = (BillList)evt.getSource();
        String formId = list.getView().getFormShowParameter().getFormId();
        if (!formId.endsWith("f7") && list.getFocusRowPkId() != null) {
            this.showModelEditView(list.getFocusRowPkId().toString());
            evt.setCancel(true);
        }
    }

    private void showModelEditView(Object modelid) {
        FormShowParameter param = new FormShowParameter();
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.getOpenStyle().setTargetKey("_submaintab_");
        param.setFormId("bcm_modelview");
        param.setStatus(OperationStatus.VIEW);
        param.setCustomParam("KEY_MODEL_ID", modelid);
        this.getView().showForm(param);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        IListView listView = (IListView)this.getView();
        switch (actionId) {
            case "modelnew": {
                if (ObjectUtils.isEmpty((Object)e.getReturnData())) {
                    return;
                }
                listView.clearSelection();
                listView.refresh();
                FormShowParameter param = new FormShowParameter();
                param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                param.getOpenStyle().setTargetKey("_submaintab_");
                param.setFormId("bcm_modelview");
                param.setStatus(OperationStatus.VIEW);
                param.setCustomParam("KEY_MODEL_ID", e.getReturnData());
                param.setCustomParam("view", this.getView().getParentView() != null ? this.getView().getParentView().getPageId() : null);
                this.getView().showForm(param);
                break;
            }
            case "upgradeorgschemecallback": {
                if (e.getReturnData() == null) break;
                UpgradeServiceHelper.showUpgradeInfo((String)e.getReturnData().toString(), (IFormView)this.getView());
            }
        }
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        RequestContext tx = RequestContext.get();
        long userId = Long.parseLong(tx.getUserId());
        Boolean isManager = (Boolean)AppCacheServiceHelper.get((String)(userId + ISMANAGER));
        if (isManager != null) {
            AppCacheServiceHelper.remove((String)(userId + ISMANAGER));
            String isManagerPageCache = this.getView().getPageCache().get(ISMANAGER);
            if (StringUtils.isNotEmpty((String)isManagerPageCache)) {
                this.getView().getPageCache().remove(ISMANAGER);
            }
        }
    }

    static {
        ListUtils.unmodifiableList(NEED_ADMIN_PERMISSION);
    }
}

