/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.bill.AbstractBillWebApiPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.integrationnew.provider.standard2my.ModelDataProvider;
import kd.fi.bcm.business.serviceHelper.ModelPermHelper;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.json.JacksonUtils;
import kd.fi.bcm.common.util.OpenApiUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;

public class ModelOlapDataQueryPlugin
extends AbstractBillWebApiPlugin {
    private static final Log LOG = LogFactory.getLog(ModelOlapDataQueryPlugin.class);
    private static final String ALL = "*";
    private static final String appUrl = "/app/cm/olapData";

    public ApiResult doCustomService(Map<String, Object> params) {
        LOG.info("ModelOlapDataQueryPlugin params :" + JacksonUtils.toJson(params));
        try {
            Optional<String> paraValidator = this.validateParam(params);
            if (paraValidator.isPresent()) {
                return ApiResult.fail((String)paraValidator.get(), (String)"000001");
            }
            String showNumber = (String)params.get("modelShowNumber");
            String modelName = (String)params.get("modelName");
            String modelNumber = (String)params.get("modelNumber");
            Map filter = (Map)params.get("filter");
            QFBuilder modelFilter = new QFBuilder("shownumber", "=", (Object)showNumber);
            modelFilter.add("name", "=", (Object)modelName);
            if (!ObjectUtils.isEmpty((Object)modelNumber)) {
                modelFilter.add("number", "=", (Object)modelNumber);
            }
            DynamicObject model = BusinessDataServiceHelper.loadSingle((String)"bcm_model", (String)"id,number", (QFilter[])modelFilter.toArray());
            HashMap<String, Object> result = new HashMap<String, Object>(3);
            if (model != null) {
                if (OpenApiUtil.getAuthStatus((String)appUrl) && !ModelPermHelper.hasModelPerm((long)model.getLong("id"))) {
                    String info = ResManager.loadKDString((String)"\u7528\u6237\u65e0\u5f53\u524d\u4f53\u7cfb\u4f7f\u7528\u6743\u9650\u3002", (String)"ModelOlapDataQueryPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                    return ApiResult.fail((String)info, (String)"000001");
                }
            } else {
                String error = String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u8be2\u5230\u7f16\u7801\u4e3a%s\u7684\u4f53\u7cfb\u3002", (String)"ModelOlapDataQueryPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), showNumber);
                return ApiResult.fail((String)error, (String)"000001");
            }
            List allDims = DimensionServiceHelper.getDimensionNumListByModel((Object)model.getLong("id"));
            Map dataList = ModelDataProvider.queryOlap((String)model.getString("number"), (List)allDims, (Map)filter, (String)(Objects.isNull(params.get("isWithName")) ? "" : params.get("isWithName").toString()));
            result.put("dataList", dataList);
            result.put("total", ((List)dataList.get("data")).size());
            return ApiResult.success(result);
        }
        catch (Throwable e) {
            LOG.error("--ModelOlapDataQueryPlugin--error\n" + ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30));
            return ApiResult.fail((String)ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30));
        }
    }

    private Optional<String> validateParam(Map<String, Object> params) {
        if (Objects.isNull(params.get("modelShowNumber"))) {
            return Optional.of("param modelShowNumber is required.");
        }
        if (Objects.isNull(params.get("modelName"))) {
            return Optional.of("param modelName is required.");
        }
        if (ObjectUtils.isEmpty((Object)params.get("filter"))) {
            return Optional.of("param filter is required.");
        }
        Map filter = (Map)params.get("filter");
        if (filter.get("needAllDims") == null && (ObjectUtils.isEmpty(filter.get(PresetConstant.ENTITY_DIM)) || ObjectUtils.isEmpty(filter.get(PresetConstant.SCENE_DIM)) || ObjectUtils.isEmpty(filter.get(PresetConstant.FY_DIM)) || ObjectUtils.isEmpty(filter.get(PresetConstant.PERIOD_DIM)) || ObjectUtils.isEmpty(filter.get(PresetConstant.CURRENCY_DIM)) || ((Collection)filter.get(PresetConstant.ENTITY_DIM)).size() != 1 || ((Collection)filter.get(PresetConstant.SCENE_DIM)).size() != 1 || ((Collection)filter.get(PresetConstant.FY_DIM)).size() != 1 || ((Collection)filter.get(PresetConstant.PERIOD_DIM)).size() != 1 || ((Collection)filter.get(PresetConstant.CURRENCY_DIM)).size() != 1)) {
            return Optional.of("Entity|Scenario|Year|Period|Currency parameters are required in filter and each item can only pass a unique value.");
        }
        return Optional.empty();
    }
}

