/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.model;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.bcm.business.adjust.operation.AdjustOperationThreadHelper;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.util.ImportAndExportUtil;

public class ModelOlapOperationListPlugin
extends AbstractBaseListPlugin {
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private static final String BCM_MODELOLAP_RECORD = "bcm_modelolap_record";
    private static final String STORAGETYPE = "storagetype";
    private static final String RUNMODEL = "runmodel";
    private static final String BILLLISTTAP = "billlistap";
    private static final String BTN_DELETE = "btn_delete";

    @Override
    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getView().getControl(BILLLISTTAP);
        if (this.isAdjustPage()) {
            billList.setBillFormId("bcm_adjustprogressentity");
        } else {
            billList.setBillFormId(this.isShowLog() ? "bcm_modelolap_list" : "bcm_modelolap_template");
        }
        billList.addCreateListDataProviderListener(this::beforeCreateListDataProvider);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners("toolbarap");
        BillList billList = (BillList)this.getView().getControl(BILLLISTTAP);
        billList.addListRowDoubleClickListener((ListRowClickListener)this);
        billList.addHyperClickListener(this::billListHyperLinkClick);
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        BillList billList = (BillList)this.getView().getControl(BILLLISTTAP);
        switch (key) {
            case "baritemap": {
                billList.refreshData();
                billList.clearSelection();
                break;
            }
            case "btn_fill": {
                ListSelectedRowCollection selectRow = billList.getSelectedRows();
                if (selectRow.size() != 1) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u65b9\u6848\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ModelOlapOperationListPlugin_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                }
                this.actionFillIn((Long)selectRow.get(0).getPrimaryKeyValue());
                break;
            }
            case "btn_delete": {
                ListSelectedRowCollection selectRows = billList.getSelectedRows();
                if (selectRows.isEmpty()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u65b9\u6848\u8fdb\u884c\u5220\u9664\u3002", (String)"ModelOlapOperationListPlugin_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                }
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(BTN_DELETE);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u6b64\u64cd\u4f5c\u5c06\u5220\u9664\u5df2\u9009\u65b9\u6848\uff0c\u4ecd\u8981\u8fdb\u884c\uff1f", (String)"ModelOlapOperationListPlugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Delete, confirmCallBacks);
                break;
            }
            case "btn_export": {
                this.exportExcel();
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        BillList billList = (BillList)this.getView().getControl(BILLLISTTAP);
        if (BTN_DELETE.equals(callBackId) && !"No".equals(messageBoxClosedEvent.getResultValue())) {
            DeleteServiceHelper.delete((String)BCM_MODELOLAP_RECORD, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)billList.getSelectedRows().getPrimaryKeyValues())});
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"ModelOlapOperationListPlugin_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            billList.refreshData();
            billList.clearSelection();
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("model");
        this.getModel().setValue("model", (Object)modelId);
        BillList billList = (BillList)this.getView().getControl(BILLLISTTAP);
        FilterParameter filterParameter = new FilterParameter();
        filterParameter.setFilter(new QFilter("model", "=", this.getModel().getValue("model_id")));
        if (!this.isAdjustPage()) {
            if (this.isShowLog()) {
                filterParameter.setFilter(new QFilter(STORAGETYPE, "=", (Object)"0"));
            } else {
                filterParameter.setFilter(new QFilter(STORAGETYPE, "=", (Object)"1"));
                filterParameter.setFilter(new QFilter(RUNMODEL, "=", (Object)(this.isCopy() ? "0" : "1")));
            }
            filterParameter.setOrderBy("createdate desc");
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_export"});
        }
        billList.setFilterParameter(filterParameter);
    }

    @Override
    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int arg0, int arg1) {
                DynamicObjectCollection rows = super.getData(arg0, arg1);
                if (rows.isEmpty()) {
                    return rows;
                }
                if (!((DynamicObject)rows.get(0)).getDataEntityType().getProperties().containsKey((Object)"status")) {
                    return rows;
                }
                for (DynamicObject row : rows) {
                    row.set("status", (Object)row.getString("status").trim());
                    if (!ModelOlapOperationListPlugin.this.isAdjustPage()) continue;
                    row.set("failedlog", (Object)ResManager.loadKDString((String)"\u70b9\u51fb\u67e5\u770b\u8be6\u60c5", (String)"AdjustOperationProgressPlugin_12", (String)ModelOlapOperationListPlugin.FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                }
                return rows;
            }
        });
    }

    private void billListHyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        Long selectId = (Long)((BillList)hyperLinkClickEvent.getSource()).getFocusRowPkId();
        if (this.isAdjustPage() && "failedlog".equals(hyperLinkClickEvent.getFieldName())) {
            AdjustOperationThreadHelper.showDetailLogForm((IFormView)this.getView(), (long)selectId);
        } else {
            this.actionFillIn(selectId);
        }
    }

    @Override
    public void listRowDoubleClick(ListRowClickEvent evt) {
        if (this.isAdjustPage()) {
            return;
        }
        Long selectId = (Long)evt.getCurrentListSelectedRow().getPrimaryKeyValue();
        this.actionFillIn(selectId);
    }

    private void actionFillIn(Long selectId) {
        this.getView().returnDataToParent((Object)selectId);
        if (!this.isShowLog()) {
            this.getView().close();
        }
    }

    private boolean isShowLog() {
        return (Boolean)this.getView().getFormShowParameter().getCustomParam("isShowLog");
    }

    private boolean isCopy() {
        return (Boolean)this.getView().getFormShowParameter().getCustomParam("isCopy");
    }

    private boolean isAdjustPage() {
        return this.getView().getFormShowParameter().getCustomParam("adjust") != null;
    }

    private DynamicObjectCollection queryDatas(String entityName, List<String> selectFieldList, ListSelectedRowCollection selectedRows) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < selectFieldList.size(); ++i) {
            if (i == selectFieldList.size() - 1) {
                stringBuilder.append(selectFieldList.get(i));
                continue;
            }
            stringBuilder.append(selectFieldList.get(i)).append(",");
        }
        String selectFields = stringBuilder.toString();
        DynamicObjectCollection dynamicObjects = null;
        QFilter qFilter = new QFilter("model", "=", this.getModel().getValue("model_id"));
        if (!selectedRows.isEmpty()) {
            qFilter = new QFilter("id", "in", (Object)selectedRows.getPrimaryKeyValues());
        }
        if (!this.isAdjustPage()) {
            if (this.isShowLog()) {
                qFilter.and(new QFilter(STORAGETYPE, "=", (Object)"0"));
            } else {
                qFilter.and(new QFilter(STORAGETYPE, "=", (Object)"1"));
                qFilter.and(new QFilter(RUNMODEL, "=", (Object)(this.isCopy() ? "0" : "1")));
            }
            dynamicObjects = QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])qFilter.toArray(), (String)"createdate desc");
        } else {
            dynamicObjects = QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])qFilter.toArray());
        }
        return dynamicObjects;
    }

    private String getFieldKey(String mainEntityName, IListColumn listColumns) {
        if (listColumns.getEntityName().equals(mainEntityName)) {
            return listColumns.getListFieldKey();
        }
        return listColumns.getEntityName() + "." + listColumns.getListFieldKey();
    }

    private void exportExcel() {
        BillList billList = (BillList)this.getView().getControl(BILLLISTTAP);
        List listFieldsControlColumns = billList.getListFieldsControlColumns();
        List showListColumns = billList.getShowListColumns();
        int size = showListColumns.size();
        ListSelectedRowCollection selectRowsexport = billList.getSelectedRows();
        String title = ResManager.loadKDString((String)"\u591a\u7ef4\u6570\u636e\u64cd\u4f5c\u65e5\u5fd7", (String)"ModelOlapOperationListPlugin_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
        ArrayList<String> selectFieldList = new ArrayList<String>(size);
        int k = 0;
        String[] captions = new String[size];
        captions[k++] = "#";
        if (!listFieldsControlColumns.isEmpty()) {
            for (Map column : listFieldsControlColumns) {
                if ((Integer)column.get("visible") == 0) continue;
                captions[k++] = (String)column.get("caption");
                selectFieldList.add((String)column.get("listFieldKey"));
            }
        } else {
            for (Map column : showListColumns) {
                if (STORAGETYPE.equals(column.getListFieldKey()) || "fseq".equals(column.getListFieldKey())) continue;
                captions[k++] = column.getCaption().getLocaleValue();
                selectFieldList.add(this.getFieldKey(BCM_MODELOLAP_RECORD, (IListColumn)column));
            }
        }
        size = selectFieldList.size() + 1;
        DynamicObjectCollection dynamicObjects = this.queryDatas(BCM_MODELOLAP_RECORD, selectFieldList, selectRowsexport);
        ArrayList<String[]> excelList = new ArrayList<String[]>(dynamicObjects.size());
        int index = 1;
        for (DynamicObject dynamicObject : dynamicObjects) {
            int k1 = 0;
            String[] stringList = new String[size];
            stringList[k1++] = String.valueOf(index++);
            for (String filed : selectFieldList) {
                Object fieldValue = dynamicObject.get(filed);
                if (Objects.isNull(fieldValue)) continue;
                String value = fieldValue.toString();
                if (filed.equals(STORAGETYPE)) {
                    if ("0".equals(value)) {
                        stringList[k1++] = ResManager.loadKDString((String)"\u8bb0\u5f55", (String)"ModelOlapOperationListPlugin_5", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
                        continue;
                    }
                    if (!"1".equals(value)) continue;
                    stringList[k1++] = ResManager.loadKDString((String)"\u65b9\u6848", (String)"ModelOlapOperationListPlugin_6", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
                    continue;
                }
                if (filed.equals(RUNMODEL)) {
                    if ("0".equals(value)) {
                        stringList[k1++] = ResManager.loadKDString((String)"\u590d\u5236", (String)"ModelOlapOperationListPlugin_7", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
                        continue;
                    }
                    if (!"1".equals(value)) continue;
                    stringList[k1++] = ResManager.loadKDString((String)"\u6e05\u9664", (String)"ModelOlapOperationListPlugin_8", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
                    continue;
                }
                stringList[k1++] = value;
            }
            excelList.add(stringList);
        }
        ThreeTuple objectObjectObjectThreeTuple = new ThreeTuple((Object)title, (Object)captions, excelList);
        String url = ImportAndExportUtil.export(title, objectObjectObjectThreeTuple);
        if (url != null) {
            this.downloadFile(url, "bcm_modelperm", "47150e89000000ac");
        }
    }
}

