/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.model;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.scheme.Dimension;
import kd.fi.bcm.business.scheme.DimensionScope;
import kd.fi.bcm.business.scheme.ModelOlapScheme;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.formplugin.model.AbstractModelOlapOperation;
import kd.fi.bcm.formplugin.util.CodeRuleUtil;
import kd.fi.bcm.spread.common.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;

public class ModelOlapOperationPlugin
extends AbstractModelOlapOperation {
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private static final String BTN_CLEAR = "btn_clear";
    private static final String BTN_OK = "btn_ok";
    private static final String BTN_RESET = "btn_reset";
    private static final String BTN_SAVE = "btn_save";
    private static final String BTN_CHANGE = "btn_change";
    private static final String CACHECLEARCONFIG = "cacheClearConfig";
    private static final String PREDIMENSIONSCOPE = "preDimensionScope";
    private static final String MODELOLAP_KEY = "MODEL_OLAP_THREAD_";
    protected static WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, ModelOlapOperationPlugin.class);

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Boolean isClearData = (Boolean)this.getView().getFormShowParameter().getCustomParam("isClearData");
        if (isClearData != null && isClearData.booleanValue()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_CLEAR, BTN_RESET, BTN_SAVE, BTN_CHANGE});
            this.initPassValue();
            this.hidePreDimension();
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_OK});
        }
    }

    private void hidePreDimension() {
        String replacedimension = (String)this.getView().getFormShowParameter().getCustomParam("replacedimension");
        if (replacedimension != null) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"clear_" + replacedimension.toLowerCase()});
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"clear_" + DimEntityNumEnum.ENTITY.getNumber().toLowerCase()});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"clear_" + DimEntityNumEnum.YEAR.getNumber().toLowerCase()});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"clear_" + DimEntityNumEnum.PERIOD.getNumber().toLowerCase()});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"clear_" + DimEntityNumEnum.SCENARIO.getNumber().toLowerCase()});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"clear_" + DimEntityNumEnum.CURRENCY.getNumber().toLowerCase()});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"clear_" + DimEntityNumEnum.PROCESS.getNumber().toLowerCase()});
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (StringUtil.equals((String)key, (String)BTN_CLEAR) || StringUtil.equals((String)key, (String)"btn_copy") || StringUtil.equals((String)key, (String)BTN_SAVE) || StringUtil.equals((String)key, (String)BTN_OK)) {
            this.getModelOlapScheme().setResolveParams(this.getMultiF7Param());
            String rundetails = this.getModelOlapScheme().toString();
            switch (key) {
                case "btn_clear": {
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(BTN_CLEAR);
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u6b64\u64cd\u4f5c\u4e0d\u53ef\u9006\uff0c\u5c06\u6e05\u9664\u5df2\u9009\u6210\u5458\u7684\u6240\u6709\u591a\u7ef4\u6570\u636e\uff0c\u4ecd\u8981\u8fdb\u884c\uff1f\u6240\u6709\u5df2\u9009\u6210\u5458\u5982\u4e0b\uff1a", (String)"ModelOlapOperationPlugin_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]) + "\n" + rundetails, MessageBoxOptions.YesNo, ConfirmTypes.Delete, confirmCallBacks);
                    break;
                }
                case "btn_copy": {
                    this.batchExcute();
                    String number = ((DynamicObject)this.getModel().getValue("model")).getString("shownumber");
                    String name = ((DynamicObject)this.getModel().getValue("model")).getString("name");
                    String msg = number + " " + name;
                    OpNameMultiLangEnumBridge opName = new OpNameMultiLangEnumBridge("\u590d\u5236\u6570\u636e", "ModelOlapOperationPlugin_1", FI_BCM_FORMPLUGIN, "copyData");
                    OPDescMultiLangEnumBridge opDes = new OPDescMultiLangEnumBridge("\u201c%s\u201d\uff0c\u590d\u5236\u6570\u636e\u6210\u529f\u3002", "ModelOlapOperationPlugin_2", FI_BCM_FORMPLUGIN, OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{msg}));
                    this.writeMultiLangLog(opName, opDes);
                    break;
                }
                case "btn_save": {
                    this.getModelOlapScheme().setStoragetype("1");
                    FormShowParameter formShowParameter = new FormShowParameter();
                    formShowParameter.setFormId("bcm_modelolap_record");
                    formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                    formShowParameter.setCaption(ResManager.loadKDString((String)"\u65b9\u6848\u53e6\u5b58\u4e3a", (String)"ModelOlapOperationPlugin_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                    formShowParameter.setCustomParam("model", (Object)this.getModelId());
                    formShowParameter.setCustomParam("scheme", (Object)SerializationUtils.serializeToBase64((Object)this.getModelOlapScheme()));
                    CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "saveTemplate");
                    formShowParameter.setCloseCallBack(closeCallBack);
                    this.getView().showForm(formShowParameter);
                    break;
                }
                case "btn_ok": {
                    this.finalSetClearConfig();
                    this.getView().close();
                    break;
                }
            }
        } else if (StringUtil.equals((String)key, (String)BTN_CHANGE)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setFormId("bcm_modelolap_temp");
            formShowParameter.setCaption(this.isCopy() ? ResManager.loadKDString((String)"\u4f53\u7cfb\u591a\u7ef4\u6570\u636e\u590d\u5236\u65b9\u6848", (String)"ModelOlapOperationPlugin_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4f53\u7cfb\u591a\u7ef4\u6570\u636e\u6e05\u9664\u65b9\u6848", (String)"ModelOlapOperationPlugin_5", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            formShowParameter.setCustomParam("isCopy", (Object)this.isCopy());
            formShowParameter.setCustomParam("isShowLog", (Object)false);
            formShowParameter.setCustomParam("model", (Object)this.getModelId());
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
            formShowParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(formShowParameter);
        } else if (StringUtil.equals((String)key, (String)BTN_RESET)) {
            this.resetForm();
        }
    }

    private void finalSetClearConfig() {
        LinkedHashMap cacheMap = new LinkedHashMap();
        String clearConfig = this.getView().getParentView().getPageCache().get(CACHECLEARCONFIG);
        if (kd.bos.util.StringUtils.isNotEmpty((String)clearConfig)) {
            cacheMap = (LinkedHashMap)JSONObject.parseObject((String)clearConfig, LinkedHashMap.class);
        }
        Map dataMap = new HashMap(16);
        String preDimensionScopeStr = this.getView().getParentView().getPageCache().get(PREDIMENSIONSCOPE);
        if (kd.bos.util.StringUtils.isNotEmpty((String)preDimensionScopeStr)) {
            dataMap = (Map)JSONObject.parseObject((String)preDimensionScopeStr, LinkedHashMap.class);
        }
        for (Dimension dim : this.getSchemeContext().getDimensions()) {
            String value = (String)this.getModel().getValue("clear_" + dim.getNumber().toLowerCase(Locale.ENGLISH));
            if (!kd.bos.util.StringUtils.isEmpty((String)value)) continue;
            cacheMap.remove(dim.getNumber());
            dataMap.remove(dim.getNumber());
        }
        this.getView().getParentView().getPageCache().put(CACHECLEARCONFIG, JSONObject.toJSONString((Object)cacheMap));
        this.getView().getParentView().getPageCache().put(PREDIMENSIONSCOPE, JSONObject.toJSONString(dataMap));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        String actionId = closedCallBackEvent.getActionId();
        if (actionId != null && (actionId.startsWith("from_") || actionId.startsWith("to_") || actionId.startsWith("clear_"))) {
            DynamicObjectCollection returnDatas = (DynamicObjectCollection)closedCallBackEvent.getReturnData();
            Dimension dim2 = this.getSchemeContext().getDimensionByNumber(actionId.split("\\_")[1]);
            DimensionScope dimensionScope = new DimensionScope(Long.toString(this.getModelId()), dim2, returnDatas);
            Boolean isClearData = (Boolean)this.getView().getFormShowParameter().getCustomParam("isClearData");
            if (isClearData != null && isClearData.booleanValue()) {
                this.cacheClearConfig(dim2, returnDatas, dimensionScope);
            }
            if (this.isCopy()) {
                if (dimensionScope.size() != 1) {
                    this.setDimensionRange("from_" + dim2.getNumber().toLowerCase(Locale.ENGLISH), dimensionScope);
                    this.setDimensionRange("to_" + dim2.getNumber().toLowerCase(Locale.ENGLISH), dimensionScope, false);
                } else {
                    DimensionScope oldValue = this.getDimensionRange(actionId);
                    if (oldValue != null && oldValue.size() >= 1) {
                        this.setDimensionRange((actionId.startsWith("from_") ? "to_" : "from_") + dim2.getNumber().toLowerCase(Locale.ENGLISH), null);
                        this.getView().setEnable(Boolean.TRUE, new String[]{"to_" + dim2.getNumber().toLowerCase(Locale.ENGLISH), "from_" + dim2.getNumber().toLowerCase(Locale.ENGLISH)});
                    }
                    this.setDimensionRange(actionId, dimensionScope);
                }
            } else {
                this.setDimensionRangeContainNumber(actionId, dimensionScope);
            }
            this.cacheModelOlapScheme();
        } else if (StringUtil.equals((String)actionId, (String)BTN_CHANGE)) {
            this.resetForm();
            long pkid = (Long)closedCallBackEvent.getReturnData();
            DynamicObject dy = BusinessDataServiceHelper.loadSingleFromCache((Object)pkid, (String)"bcm_modelolap_record");
            this.modelOlapScheme = new ModelOlapScheme(Long.valueOf(this.getModelId()), dy);
            this.cacheModelOlapScheme();
            if (this.isCopy()) {
                this.getSchemeDetails().get("0").forEach((dim, dimscope) -> {
                    this.setDimensionRange("from_" + dim.getNumber().toLowerCase(Locale.ENGLISH), (DimensionScope)dimscope);
                    boolean isScope = dimscope.size() != 1;
                    this.setDimensionRange("to_" + dim.getNumber().toLowerCase(Locale.ENGLISH), isScope ? dimscope : this.getSchemeDetails().get("1").get(dim), isScope);
                    this.getView().setEnable(Boolean.valueOf(!isScope), new String[]{"to_" + dim.getNumber().toLowerCase(Locale.ENGLISH)});
                });
            } else {
                this.getSchemeDetails().get("2").forEach((dim, dimscope) -> this.setDimensionRange("clear_" + dim.getNumber().toLowerCase(Locale.ENGLISH), (DimensionScope)dimscope));
            }
        } else if (StringUtil.equals((String)actionId, (String)"saveTemplate") && closedCallBackEvent.getReturnData() != null) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u65b9\u6848\u4fdd\u5b58\u6210\u529f\u3002", (String)"ModelOlapOperationPlugin_6", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        } else if (StringUtil.equals((String)actionId, (String)"model_olap_task_close_back")) {
            this.taskCallBack(closedCallBackEvent.getReturnData());
            String modelnumber = ((DynamicObject)this.getModel().getValue("model")).getString("number");
            GlobalCacheServiceHelper.getCommonCache().invalidateByKey(MODELOLAP_KEY + modelnumber);
            this.modelOlapScheme = null;
            return;
        }
    }

    private void taskCallBack(Object returnData) {
        TaskInfo taskInfo;
        String taskInfoStr;
        Map result;
        if (returnData == null) {
            return;
        }
        if (returnData instanceof Map && (result = (Map)returnData).containsKey("taskinfo") && StringUtils.isNotBlank((CharSequence)(taskInfoStr = (String)result.get("taskinfo"))) && (taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class)).isTaskEnd()) {
            String data = taskInfo.getData();
            JSONObject jsonData = JSON.parseObject((String)data);
            String message = jsonData.getString("message");
            if (Boolean.FALSE.toString().equals(jsonData.getString("success"))) {
                if (this.isCopy()) {
                    this.getView().showTipNotification(message);
                } else if ("500".equals(jsonData.getString("code"))) {
                    this.showTipView(message);
                } else {
                    this.getView().showTipNotification(message);
                }
            } else {
                this.getView().showMessage(message);
            }
        }
    }

    private void showTipView(String checkMsg) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bcm_olapclear_check");
        formShowParameter.setCustomParam("checkInfos", (Object)checkMsg);
        formShowParameter.setCustomParam("msg", (Object)ResManager.loadKDString((String)"\u65e0\u6cd5\u6267\u884c\u6570\u636e\u6e05\u9664\u64cd\u4f5c\uff0c\u539f\u56e0\u548c\u5bf9\u5e94\u64cd\u4f5c\u8def\u5f84\u5982\u4e0b\uff1a", (String)"ModelOlapOperationPlugin_20", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formShowParameter);
    }

    private void cacheClearConfig(Dimension dim, DynamicObjectCollection returnDatas, DimensionScope dimensionScope) {
        LinkedHashMap cacheMap = new LinkedHashMap();
        String clearConfig = this.getView().getParentView().getPageCache().get(CACHECLEARCONFIG);
        if (kd.bos.util.StringUtils.isNotEmpty((String)clearConfig)) {
            cacheMap = (LinkedHashMap)JSONObject.parseObject((String)clearConfig, LinkedHashMap.class);
        }
        HashMap<String, Object> innerMap = new HashMap<String, Object>();
        innerMap.put("dimList", this.getDimList(returnDatas));
        innerMap.put("dimDescription", dim.getName() + "|" + dimensionScope.toString());
        cacheMap.put(dim.getNumber(), innerMap);
        this.getView().getParentView().getPageCache().put(CACHECLEARCONFIG, JSONObject.toJSONString((Object)cacheMap));
        Map<String, Map<Long, Integer>> dataMap = this.getDataMap(dim.getNumber(), returnDatas);
        this.getView().getParentView().getPageCache().put(PREDIMENSIONSCOPE, JSONObject.toJSONString(dataMap));
    }

    private Map<String, Map<Long, Integer>> getDataMap(String dimtype, DynamicObjectCollection returnDatas) {
        String dimensionScopeStr = this.getView().getParentView().getPageCache().get(PREDIMENSIONSCOPE);
        Map<Object, Object> dataMap = new HashMap(16);
        if (kd.bos.util.StringUtils.isNotEmpty((String)dimensionScopeStr)) {
            dataMap = this.turnDataMap(dimensionScopeStr);
        }
        HashMap<Long, Integer> dimMembers = new HashMap<Long, Integer>();
        for (DynamicObject dynamicObject : returnDatas) {
            dimMembers.put(Long.parseLong(String.valueOf(dynamicObject.getLong("mid1"))), dynamicObject.getInt("filltypevalue1"));
        }
        dataMap.put(dimtype, dimMembers);
        return dataMap;
    }

    private Map<String, Map<Long, Integer>> turnDataMap(String dimensionScopeStr) {
        this.getModelOlapScheme().getSchemeDetails();
        Map dataMap = (Map)JSONObject.parseObject((String)dimensionScopeStr, Map.class);
        HashMap<String, Map<Long, Integer>> newDataMap = new HashMap<String, Map<Long, Integer>>();
        Map newMapInner = null;
        for (Map.Entry map : dataMap.entrySet()) {
            for (Map.Entry mapInner : ((Map)map.getValue()).entrySet()) {
                newMapInner = newDataMap.computeIfAbsent((String)map.getKey(), (Function<String, Map<Long, Integer>>)((Function<String, Map>)k -> new HashMap()));
                newMapInner.put(Long.parseLong(String.valueOf(mapInner.getKey())), Integer.parseInt(String.valueOf(mapInner.getValue())));
            }
        }
        return newDataMap;
    }

    private JSONArray getDimList(DynamicObjectCollection returnDatas) {
        JSONArray ja = new JSONArray();
        JSONObject jo = null;
        for (DynamicObject dynamicObject : returnDatas) {
            jo = new JSONObject();
            jo.put("id", (Object)dynamicObject.getLong("mid1"));
            jo.put("number", (Object)dynamicObject.getString("mnum1"));
            jo.put("scope", (Object)dynamicObject.getString("filltypevalue1"));
            ja.add((Object)jo);
        }
        return ja;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (BTN_CLEAR.equals(callBackId) && !"No".equals(messageBoxClosedEvent.getResultValue())) {
            this.batchExcute();
            String number = ((DynamicObject)this.getModel().getValue("model")).getString("shownumber");
            String name = ((DynamicObject)this.getModel().getValue("model")).getString("name");
            String msg = number + " " + name;
            OpNameMultiLangEnumBridge opName = new OpNameMultiLangEnumBridge("\u6e05\u9664\u6570\u636e", "ModelOlapOperationPlugin_7", FI_BCM_FORMPLUGIN, "clearData");
            OPDescMultiLangEnumBridge opDes = new OPDescMultiLangEnumBridge("\u201c%s\u201d\uff0c\u6e05\u9664\u6210\u529f\u3002", "ModelOlapOperationPlugin_8", FI_BCM_FORMPLUGIN, OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{msg}));
            this.writeMultiLangLog(opName, opDes);
        }
    }

    private void batchExcute() {
        this.modelOlapScheme = this.getModelOlapScheme();
        String modelnumber = ((DynamicObject)this.getModel().getValue("model")).getString("number");
        Object ob = GlobalCacheServiceHelper.getCommonCache().getIfPresent(MODELOLAP_KEY + modelnumber);
        if (ob == null) {
            String number = CodeRuleUtil.getCodeRuleNumber("bcm_analyticssoluentry", "createtime");
            if (number == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5206\u6790\u65b9\u6848\u5b9e\u4f53\u7f16\u7801\u89c4\u5219\u4e3a\u7a7a\uff0c\u8bf7\u5728\u914d\u7f6e\u5de5\u5177\u4e2d\u914d\u7f6e\u8be5\u89c4\u5219\u3002", (String)"ModelOlapOperationPlugin_14", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            this.modelOlapScheme.setNumber(number);
            GlobalCacheServiceHelper.getCommonCache().replaceCache(MODELOLAP_KEY + modelnumber, (Object)this.modelOlapScheme.getNumber());
            this.dispatch(this.modelOlapScheme, modelnumber);
        } else {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8be5\u4f53\u7cfb\u6b63\u5728\u8fdb\u884c\u591a\u7ef4\u5e93\u6570\u636e\u590d\u5236\u6216\u8005\u6e05\u9664\u64cd\u4f5c\uff0c\u8981\u7b49\u5176\u7ed3\u675f\u65b9\u53ef\u64cd\u4f5c\u3002", (String)"ModelOlapOperationPlugin_9", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), modelnumber));
        }
    }

    private void dispatch(ModelOlapScheme modelOlapScheme, String modelnumber) {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("modelOlapScheme", SerializationUtils.serializeToBase64((Object)modelOlapScheme));
        params.put("modelnumber", modelnumber);
        params.put("multiparam", SerializationUtils.toJsonString(this.getMultiF7Param()));
        params.put("operationStatus", this.getView().getFormShowParameter().getCustomParam("operationStatus"));
        params.put("dimensions", SerializationUtils.toJsonString(this.getSchemeContext().getDimensions().stream().map(x -> x.getNumber()).collect(Collectors.toSet())));
        params.put("creater", RequestContext.get().getCurrUserId());
        JobInfo jobInfo = new JobInfo();
        String appId = this.getModel().getDataEntityType().getAppId();
        jobInfo.setAppId(appId);
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setName(String.format(ResManager.loadKDString((String)"\u591a\u7ef4\u6570\u636e%s\u4efb\u52a1", (String)"ModelOlapOperationPlugin_24", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), this.isCopy() ? ResManager.loadKDString((String)"\u590d\u5236", (String)"ModelOlapOperationListPlugin_7", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6e05\u9664", (String)"ModelOlapOperationListPlugin_8", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0])));
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname("kd.fi.bcm.formplugin.model.ModelOlapOperationTask");
        jobInfo.setParams(params);
        jobInfo.setRunByLang(Lang.get());
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "model_olap_task_close_back");
        JobFormInfo clientJobInfo = new JobFormInfo(jobInfo);
        clientJobInfo.setCloseCallBack(closeCallBack);
        clientJobInfo.setCanBackground(true);
        clientJobInfo.setTimeout(3600);
        clientJobInfo.setParentPageId(this.getView().getPageId());
        JobForm.dispatch((JobFormInfo)clientJobInfo, (IFormView)this.getView());
    }

    private Map<String, Set<String>> getMultiF7Param() {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        boolean isAllEqual = true;
        for (Dimension dimension : this.getSchemeContext().getDimensions()) {
            if (this.isCopy()) {
                DimensionScope toDS;
                DimensionScope fromDS = this.getSchemeDetails().get("0").get(dimension);
                if (fromDS == null ^ (toDS = this.getSchemeDetails().get("1").get(dimension)) == null) {
                    DimensionScope ds;
                    DimensionScope dimensionScope = ds = fromDS == null ? toDS : fromDS;
                    if (ds.isEmpty() || ds.size() == 1) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6e90\u7ef4\u5ea6\u548c\u76ee\u6807\u7ef4\u5ea6\u4e0d\u5e94\u5b58\u5728\u4e00\u65b9\u4e3a\u7a7a\u4e00\u65b9\u6709\u503c\u7684\u573a\u666f\uff0c\u8bf7\u68c0\u67e5\u7ef4\u5ea6%s\u3002", (String)"ModelOlapOperationPlugin_11", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), dimension.getName()));
                    }
                    result.put(dimension.getNumber().toLowerCase(Locale.ENGLISH), ds.getResolveScopes());
                    continue;
                }
                if (fromDS == null || toDS == null) continue;
                result.put("from_" + dimension.getNumber().toLowerCase(Locale.ENGLISH), fromDS.getResolveScopes());
                result.put("to_" + dimension.getNumber().toLowerCase(Locale.ENGLISH), toDS.getResolveScopes());
                isAllEqual = isAllEqual && ((String)toDS.getResolveScopes().iterator().next()).equalsIgnoreCase((String)fromDS.getResolveScopes().iterator().next());
                continue;
            }
            String clearKey = "clear_" + dimension.getNumber().toLowerCase(Locale.ENGLISH);
            DimensionScope clearDS = this.getDimensionRange(clearKey);
            if (clearDS == null) continue;
            Set scopes = clearDS.getResolveScopes();
            if ("Process".equals(dimension.getNumber())) {
                this.replaceProcess(scopes);
            }
            result.put(clearKey, scopes);
        }
        String pageFrom = (String)this.getView().getFormShowParameter().getCustomParam("pageFrom");
        if (result.isEmpty() && !"IsScheme".equals(pageFrom)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65b9\u6848\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ModelOlapOperationPlugin_12", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
        if (this.isCopy() && isAllEqual) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6e90\u7ef4\u5ea6\u548c\u76ee\u6807\u7ef4\u5ea6\u4e0d\u80fd\u5b8c\u5168\u76f8\u540c\u3002", (String)"ModelOlapOperationPlugin_13", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
        return result;
    }

    private void replaceProcess(Set<String> process) {
        if (CollectionUtils.isNotEmpty(process)) {
            if (process.remove("EIRpt")) {
                process.add("IRpt");
            }
            if (process.remove("ERAdj")) {
                process.add("RAdj");
            }
        }
    }

    private List<String> descartes(List<String> ... lists) {
        List<String> tempList = new ArrayList<String>(16);
        for (List<String> list : lists) {
            tempList = tempList.isEmpty() ? list : tempList.stream().flatMap(item -> list.stream().map(item2 -> item + "_" + item2)).collect(Collectors.toList());
        }
        return tempList;
    }
}

