/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.model;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.epbs.business.log.trace.OlapTraceServiceHelper;
import kd.fi.bcm.business.allinone.model.McStatus;
import kd.fi.bcm.business.olap.verify.OlapDataVerifyServiceHelper;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.scheme.Dimension;
import kd.fi.bcm.business.scheme.DimensionScope;
import kd.fi.bcm.business.scheme.ModelOlapScheme;
import kd.fi.bcm.business.scheme.model.AbstractDimensionMember;
import kd.fi.bcm.business.script.RunScriptRecordUtil;
import kd.fi.bcm.business.script.run.RunScriptBuilder;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PairList;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.enums.ModelOlapOpResult;
import kd.fi.bcm.common.enums.OlapSourceEnum;
import kd.fi.bcm.common.enums.RptAdjustStatusEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import org.apache.commons.collections.CollectionUtils;

public class ModelOlapOperationTask
extends AbstractTask {
    private static final WatchLogger LOG = BcmLogFactory.getWatchLogInstance(ModelOlapOperationTask.class);
    protected static final String FROM = "from_";
    protected static final String TO = "to_";
    private static int EXCUTE_LIMIT = 1000;
    private static final List<String> checkDimensions = Arrays.asList(PresetConstant.ENTITY_DIM, PresetConstant.SCENE_DIM, PresetConstant.FY_DIM, PresetConstant.PERIOD_DIM, PresetConstant.CURRENCY_DIM);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        Map<String, String> result;
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        boolean opeType = (Boolean)map.get("operationStatus");
        String modelnumber = map.get("modelnumber").toString();
        long creater = Long.parseLong(map.get("creater").toString());
        ModelOlapScheme modelOlapScheme = (ModelOlapScheme)SerializationUtils.deSerializeFromBase64((String)map.get("modelOlapScheme").toString());
        Map mos = (Map)SerializationUtils.fromJsonString((String)map.get("multiparam").toString(), Map.class);
        Set dimensions = (Set)SerializationUtils.fromJsonString((String)map.get("dimensions").toString(), Set.class);
        this.feedBack(15, opeType);
        this.doneHandle(ModelOlapOpResult.BEGIN.getIndex(), modelOlapScheme, null, creater);
        try {
            result = this.checkDimCombs(modelnumber, opeType, mos, dimensions, modelOlapScheme.getSchemeDetails());
        }
        catch (Exception e) {
            if ("paramError".equals(e.getMessage())) {
                LOG.error("dim param is error");
                this.doneHandle(ModelOlapOpResult.SUCCESS.getIndex(), modelOlapScheme, "", creater);
                resultMap.put("code", "200");
                resultMap.put("success", "true");
                resultMap.put("message", ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"ModelOlapOperationTask_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                this.feedbackCustomdata(resultMap);
                this.feedBack(100, opeType);
                this.feedbackCustomdata(resultMap);
                return;
            }
            throw e;
        }
        if (result.size() > 0) {
            String msg = result.get("checkMsg");
            this.doneHandle(ModelOlapOpResult.FAIL.getIndex(), modelOlapScheme, msg, creater);
            resultMap.put("code", "500");
            resultMap.put("success", "false");
            resultMap.put("message", result.get("tipMsg"));
            this.feedbackCustomdata(resultMap);
            return;
        }
        this.feedBack(60, opeType);
        OperationContext context = OperationContext.get();
        if (context != null) {
            context.setFormId("bcm_modelperm");
        }
        OlapTraceServiceHelper.setTraceOpInfo((String)ResManager.loadKDString((String)"\u591a\u7ef4\u6570\u636e\u6e05\u9664", (String)"ISSchemeDataCollectPlugin2_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        this.opCopyOrClearOlapData(resultMap, opeType, modelnumber, modelOlapScheme, mos, dimensions, creater);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void opCopyOrClearOlapData(Map<String, Object> resultMap, boolean opeType, String modelnumber, ModelOlapScheme modelOlapScheme, Map<String, List<String>> mos, Set<String> dimensions, long creater) {
        String message = "";
        String type = opeType ? ResManager.loadKDString((String)"\u590d\u5236", (String)"ModelOlapOperationTask_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6e05\u9664", (String)"ModelOlapOperationTask_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        long startTime = System.currentTimeMillis();
        try {
            List<String> entityScope = mos.get("entity");
            if (entityScope == null || entityScope.size() <= EXCUTE_LIMIT) {
                this.excute(modelnumber, mos, opeType, dimensions);
            } else {
                this.groupList(new ArrayList<String>(entityScope)).values().forEach(p -> {
                    mos.put("entity", new ArrayList(p));
                    this.excute(modelnumber, mos, opeType, dimensions);
                });
            }
            this.doneHandle(ModelOlapOpResult.SUCCESS.getIndex(), modelOlapScheme, null, creater);
            long totalTime = System.currentTimeMillis() - startTime;
            LOG.info("EA\u591a\u7ef4\u6570\u636e\u64cd\u4f5c\u603b\u5171\u8017\u65f6:" + totalTime);
            message = String.format(ResManager.loadKDString((String)"%1$s\u591a\u7ef4\u6570\u636e\u6210\u529f\uff0c\u8017\u65f6%2$s\u6beb\u79d2", (String)"ModelOlapOperationTask_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), type, totalTime);
            resultMap.put("code", "200");
            resultMap.put("success", "true");
            resultMap.put("message", message);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            this.doneHandle(ModelOlapOpResult.INTERRUPT.getIndex(), modelOlapScheme, e.getMessage(), creater);
            message = String.format(ResManager.loadKDString((String)"%1$s\u591a\u7ef4\u6570\u636e\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0:%2$s", (String)"ModelOlapOperationTask_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), type, e.getMessage());
            resultMap.put("code", "502");
            resultMap.put("success", "false");
            resultMap.put("message", message);
        }
        finally {
            this.feedBack(100, opeType);
            this.feedbackCustomdata(resultMap);
        }
    }

    private Map<String, List<String>> groupList(List<String> list) {
        int listSize = list.size();
        int toIndex = EXCUTE_LIMIT;
        HashMap<String, List<String>> map = new HashMap<String, List<String>>(16);
        for (int i = 0; i < list.size(); i += EXCUTE_LIMIT) {
            if (i + EXCUTE_LIMIT > listSize) {
                toIndex = listSize - i;
            }
            List<String> newList = list.subList(i, i + toIndex);
            map.put((String)((Object)Integer.valueOf(i)), newList);
        }
        return map;
    }

    private void excute(String modelnumber, Map<String, List<String>> resolveParams, boolean isCopy, Set<String> dimensions) {
        RunScriptBuilder run = new RunScriptBuilder(modelnumber);
        if (OlapServiceHelper.checkMeasure((String)modelnumber, (String)FacTabFieldDefEnum.FIELD_SOURCE.getField())) {
            run.setSourceEnum(isCopy ? OlapSourceEnum.A1 : OlapSourceEnum.A2);
        }
        if (isCopy) {
            PairList leftpairList = new PairList();
            PairList rightpairList = new PairList();
            resolveParams.forEach((key, dimmemnums) -> {
                if (dimmemnums.size() > 1) {
                    run.addDimensionScope(dimensions.stream().filter(x -> x.equalsIgnoreCase((String)key)).findFirst().get(), dimmemnums.toArray(new String[0]));
                } else {
                    (key.startsWith(TO) ? leftpairList : rightpairList).addPair((Object)this.getDimensionByFieldKey((String)key, dimensions), dimmemnums.get(0));
                }
            });
            run.appendV(leftpairList);
            run.appendEqualSign();
            run.appendV(rightpairList);
            run.endRunExpress();
            run.runScript(false);
        } else {
            Map.Entry<String, List<String>> scope = resolveParams.entrySet().iterator().next();
            String dimennum = this.getDimensionByFieldKey(scope.getKey(), dimensions);
            resolveParams.forEach((key, dimmemnums) -> {
                if (!key.equalsIgnoreCase((String)scope.getKey())) {
                    run.addDimensionScope(this.getDimensionByFieldKey((String)key, dimensions), dimmemnums.toArray(new String[0]));
                }
            });
            scope.getValue().forEach(dim -> {
                run.appendV(PairList.newWithParam((Object)dimennum, (Object)dim));
                run.appendEqualSign();
                run.appendStr(null);
                run.endRunExpress();
            });
            run.runScript(false);
        }
    }

    protected String getDimensionByFieldKey(String fieldKey, Set<String> dimensions) {
        return dimensions.stream().filter(x -> x.equalsIgnoreCase(fieldKey.split("\\_")[1])).findFirst().get();
    }

    private void doneHandle(String status, ModelOlapScheme mos, String remark, long creater) {
        mos.setStoragetype("0");
        mos.setStatus(status);
        mos.setRemark(remark);
        DynamicObject record = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_modelolap_record", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)mos.getModel()), new QFilter("number", "=", (Object)mos.getNumber())});
        if (record == null) {
            record = mos.toDy();
            record.set("creater", (Object)creater);
        }
        switch (status) {
            case "1": {
                record.set("modifydate", (Object)TimeServiceHelper.now());
                record.set("opresult", (Object)ModelOlapOpResult.SUCCESS.getIndex());
                break;
            }
            case "0": {
                record.set("modifydate", (Object)TimeServiceHelper.now());
                record.set("remark", (Object)remark);
                record.set("opresult", (Object)ModelOlapOpResult.FAIL.getIndex());
                break;
            }
            case "2": {
                record.set("modifydate", (Object)TimeServiceHelper.now());
                record.set("remark", (Object)remark);
                record.set("opresult", (Object)ModelOlapOpResult.INTERRUPT.getIndex());
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{record});
    }

    private Map<String, String> checkDimCombs(String modelnumber, boolean opeType, Map<String, List<String>> mos, Set<String> dimensions, Map<String, Map<Dimension, DimensionScope>> schemeDetails) {
        HashMap<String, String> result = new HashMap<String, String>(16);
        Map<String, List<String>> checkMsg = null;
        if (opeType) {
            checkMsg = this.dealDataCheckOfCopy(modelnumber, mos, dimensions);
            List<String> periodCombs = checkMsg.get("period");
            List<String> mergeCombs = checkMsg.get("merge");
            if (CollectionUtils.isNotEmpty(periodCombs) || CollectionUtils.isNotEmpty(mergeCombs)) {
                String msg = this.getMsg(periodCombs, mergeCombs, null);
                result.put("code", "500");
                result.put("tipMsg", ResManager.loadKDString((String)"\u7ef4\u5ea6\u7ec4\u5408\u6821\u9a8c\u5931\u8d25\uff0c\u5177\u4f53\u8bf7\u67e5\u770b\u4f53\u7cfb\u53d8\u52a8\u8bb0\u5f55", (String)"ModelOlapOperationTask_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                result.put("checkMsg", msg);
            }
        } else {
            checkMsg = this.dealDataCheck(modelnumber, schemeDetails);
            List<String> noOpen = checkMsg.get("noOpen");
            List<String> merged = checkMsg.get("merged");
            List<String> adjust = checkMsg.get("adjust");
            if (noOpen != null || merged != null || adjust != null) {
                String msg = this.getMsg(noOpen, merged, adjust);
                result.put("code", "500");
                result.put("tipMsg", SerializationUtils.serializeToBase64(checkMsg));
                result.put("checkMsg", msg);
            }
        }
        return result;
    }

    public Map<String, List<String>> dealDataCheck(String modelNumber, Map<String, Map<Dimension, DimensionScope>> schemeDetails) {
        HashMap<String, List<String>> dimMap = new HashMap<String, List<String>>(16);
        HashSet<Long> orgIds = new HashSet<Long>(16);
        HashSet<Long> sceneIds = new HashSet<Long>(16);
        HashSet<Long> yearIds = new HashSet<Long>(16);
        HashSet<Long> periodIds = new HashSet<Long>(16);
        long modelId = MemberReader.findModelIdByNum((String)modelNumber);
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        Map<Dimension, DimensionScope> dimensionDimensionScopeMap = schemeDetails.get("2");
        QFilter qf1 = new QFilter("issysdimension", "=", (Object)"0");
        DynamicObjectCollection udDims = QueryServiceHelper.query((String)"bcm_dimension", (String)"number, fieldmapped", (QFilter[])new QFilter[]{qf, qf1});
        if (dimensionDimensionScopeMap.size() > 0) {
            for (Map.Entry<Dimension, DimensionScope> entry : dimensionDimensionScopeMap.entrySet()) {
                Dimension dimension = entry.getKey();
                List list = dimensionDimensionScopeMap.get(dimension).getDimensionMembers();
                ArrayList collect = new ArrayList(list.size());
                for (AbstractDimensionMember dim : list) {
                    new MembRangeItem(dimension.getEntity(), dim.getId(), dim.getNumber(), dim.getScope(), false, (Object)modelId).matchItems(item -> collect.add(LongUtil.toLong((Object)item.id)));
                }
                if (dimension.getNumber().equalsIgnoreCase("Account")) {
                    qf.and(new QFilter("account", "in", collect));
                    continue;
                }
                if (dimension.getNumber().equalsIgnoreCase("Period")) {
                    qf.and(new QFilter("period", "in", collect));
                    periodIds.addAll(collect);
                    continue;
                }
                if (dimension.getNumber().equalsIgnoreCase("Scenario")) {
                    qf.and(new QFilter("scenario", "in", collect));
                    sceneIds.addAll(collect);
                    continue;
                }
                if (dimension.getNumber().equalsIgnoreCase("Year")) {
                    qf.and(new QFilter("year", "in", collect));
                    yearIds.addAll(collect);
                    continue;
                }
                if (dimension.getNumber().equalsIgnoreCase("Entity")) {
                    qf.and(new QFilter("entity", "in", collect));
                    orgIds.addAll(collect);
                    continue;
                }
                if (dimension.getNumber().equalsIgnoreCase("AuditTrail")) {
                    qf.and(new QFilter("audittrail", "in", collect));
                    continue;
                }
                if (dimension.getNumber().equalsIgnoreCase("Process")) {
                    qf.and(new QFilter("process", "in", collect));
                    continue;
                }
                if (dimension.getNumber().equalsIgnoreCase("Changetype")) {
                    qf.and(new QFilter("changetype", "in", collect));
                    continue;
                }
                if (dimension.getNumber().equalsIgnoreCase("Currency")) {
                    qf.and(new QFilter("currency", "in", collect));
                    continue;
                }
                if (dimension.getNumber().equalsIgnoreCase("Datasort")) {
                    qf.and(new QFilter("datasort", "in", collect));
                    continue;
                }
                if (dimension.getNumber().equalsIgnoreCase("Multigaap")) {
                    qf.and(new QFilter("multigaap", "in", collect));
                    continue;
                }
                if (dimension.getNumber().equalsIgnoreCase("Internalcompany")) {
                    qf.and(new QFilter("internalcompany", "in", collect));
                    continue;
                }
                if (!CollectionUtils.isNotEmpty((Collection)udDims)) continue;
                for (DynamicObject udDim : udDims) {
                    if (!dimension.getNumber().equalsIgnoreCase(udDim.getString("number"))) continue;
                    qf.and(new QFilter(udDim.getString("fieldmapped"), "in", collect));
                }
            }
        }
        Set<String> dimsList = this.realDims(orgIds, sceneIds, yearIds, periodIds, modelId);
        ArrayList<String> tipInfoItem = new ArrayList<String>(10);
        if (dimsList.size() > 0) {
            LOG.error("no open period:" + String.join((CharSequence)",", dimsList));
            for (String string : dimsList) {
                String[] numberStrArray = string.split(";");
                if (numberStrArray.length < 4) continue;
                tipInfoItem.add(string);
                if (tipInfoItem.size() != 10) continue;
                break;
            }
        }
        if (tipInfoItem.size() > 0) {
            dimMap.put("noOpen", tipInfoItem);
        }
        ArrayList<String> mergedDims = new ArrayList<String>(10);
        block4: for (Long sceneId : sceneIds) {
            for (Long yearId : yearIds) {
                for (Long periodId : periodIds) {
                    Map mcs = McStatus.batchGetMcStatus((Object)modelId, orgIds, (Object)sceneId, (Object)yearId, (Object)periodId);
                    for (Map.Entry next : mcs.entrySet()) {
                        Long orgId = (Long)next.getKey();
                        McStatus mc = (McStatus)next.getValue();
                        if (mc == null || !mc.getFlow().isSubmit() && !mc.getArchive().isArchive()) continue;
                        IDNumberTreeNode sceneMember = MemberReader.findScenaMemberById((Long)modelId, (Long)sceneId);
                        IDNumberTreeNode fyMember = MemberReader.findFyMemberById((Long)modelId, (Long)yearId);
                        IDNumberTreeNode periodMember = MemberReader.findPeriodMemberById((Long)modelId, (Long)periodId);
                        IDNumberTreeNode orgNumber = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
                        mergedDims.add(String.format("%s;%s;%s;%s", orgNumber.getNumber(), sceneMember.getNumber(), fyMember.getNumber(), periodMember.getNumber()));
                        if (mergedDims.size() != 10) continue;
                        continue block4;
                    }
                }
            }
        }
        if (mergedDims.size() > 0) {
            dimMap.put("merged", mergedDims);
        }
        ArrayList<String> arrayList = new ArrayList<String>(10);
        String selectFileds = "adjust,adjust.number as number, entity, scenario, year, period, process";
        DynamicObjectCollection data = QueryServiceHelper.query((String)"bcm_rptadjustdata", (String)selectFileds, (QFilter[])new QFilter[]{qf});
        if (CollectionUtils.isNotEmpty((Collection)data)) {
            List dataList = data.stream().map(d -> d.getLong("adjust")).collect(Collectors.toList());
            QFilter qsf = new QFilter("id", "in", dataList);
            qsf.and(new QFilter("status", "=", (Object)RptAdjustStatusEnum.AUDIT.status()));
            DynamicObjectCollection rptAjusts = QueryServiceHelper.query((String)"bcm_rptadjust", (String)"id", (QFilter[])new QFilter[]{qsf});
            if (rptAjusts.size() > 0) {
                Set adjustIds = rptAjusts.stream().map(x -> x.getLong("id")).collect(Collectors.toSet());
                List adjustDatas = data.stream().filter(x -> adjustIds.contains(x.getLong("adjust"))).collect(Collectors.toList());
                if (adjustDatas.size() > 0) {
                    adjustDatas = adjustDatas.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<DynamicObject>(Comparator.comparing(x -> x.getString("number")))), ArrayList::new));
                    for (DynamicObject x2 : adjustDatas) {
                        IDNumberTreeNode sceneMember = MemberReader.findScenaMemberById((Long)modelId, (Long)x2.getLong("scenario"));
                        IDNumberTreeNode fyMember = MemberReader.findFyMemberById((Long)modelId, (Long)x2.getLong("year"));
                        IDNumberTreeNode periodMember = MemberReader.findPeriodMemberById((Long)modelId, (Long)x2.getLong("period"));
                        IDNumberTreeNode orgNumber = MemberReader.findEntityMemberById((Long)modelId, (Long)x2.getLong("entity"));
                        IDNumberTreeNode proNumber = MemberReader.findProcessMemberById((String)MemberReader.findModelNumberById((Object)modelId), (Long)x2.getLong("process"));
                        String number = x2.getString("number");
                        arrayList.add(String.format("%s;%s;%s;%s;%s;%s", orgNumber.getNumber(), sceneMember.getNumber(), fyMember.getNumber(), periodMember.getNumber(), proNumber.getNumber(), number));
                        if (arrayList.size() != 10) continue;
                        break;
                    }
                }
            }
        }
        if (arrayList.size() > 0) {
            dimMap.put("adjust", arrayList);
        }
        return dimMap;
    }

    private Set<String> realDims(Set<Long> orgIds, Set<Long> sceneIds, Set<Long> yearIds, Set<Long> periodIds, long modelId) {
        DynamicObject[] sceneDyArray;
        if (!ConfigServiceHelper.getBoolParam((String)MemberReader.findModelNumberById((Object)modelId), (String)"CM012")) {
            return Sets.newHashSet();
        }
        HashMap sceneToPeriodMap = new HashMap(16);
        QFBuilder filter = new QFBuilder("model", "=", (Object)modelId);
        filter.and("id", "in", sceneIds);
        for (DynamicObject scenedy : sceneDyArray = BusinessDataServiceHelper.load((String)"bcm_scenemembertree", (String)"id,sceneperiod", (QFilter[])filter.toArray())) {
            DynamicObjectCollection coll = (DynamicObjectCollection)scenedy.get("sceneperiod");
            HashSet periodIdStrSet = new HashSet(16);
            coll.forEach(c -> periodIdStrSet.add(c.getString("fbasedataid_id")));
            sceneToPeriodMap.put(scenedy.getString("id"), periodIdStrSet);
        }
        Map periodStatusMap = PeriodSettingHelper.batchCheckPeriodStatusOnVersion((long)modelId, orgIds, sceneIds, yearIds, periodIds, (String)"datastatus");
        HashSet closeKey = new HashSet(16);
        for (Map.Entry entry : periodStatusMap.entrySet()) {
            if (((Boolean)entry.getValue()).booleanValue()) continue;
            closeKey.add(entry.getKey());
        }
        HashSet<String> notOpenKeySet = new HashSet<String>(16);
        for (String key : closeKey) {
            String[] idStrArray = key.split("_");
            if (idStrArray.length < 4) continue;
            String orgNumber = idStrArray[0];
            String sceneIdStr = idStrArray[1];
            String fyIdStr = idStrArray[2];
            String periodIdStr = idStrArray[3];
            Set periodSet = (Set)sceneToPeriodMap.get(sceneIdStr);
            if (null == periodSet || !periodSet.contains(periodIdStr)) continue;
            IDNumberTreeNode sceneMember = MemberReader.findScenaMemberById((Long)modelId, (Long)LongUtil.toLong((Object)sceneIdStr));
            IDNumberTreeNode fyMember = MemberReader.findFyMemberById((Long)modelId, (Long)LongUtil.toLong((Object)fyIdStr));
            IDNumberTreeNode periodMember = MemberReader.findPeriodMemberById((Long)modelId, (Long)LongUtil.toLong((Object)periodIdStr));
            notOpenKeySet.add(String.format("%s;%s;%s;%s", orgNumber, sceneMember.getNumber(), fyMember.getNumber(), periodMember.getNumber()));
        }
        return notOpenKeySet;
    }

    private Map<String, List<String>> dealDataCheckOfCopy(String modelnumber, Map<String, List<String>> mos, Set<String> dimensions) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>(16);
        if (OlapServiceHelper.isSandBoxCube((String)modelnumber)) {
            return result;
        }
        HashMap<String, Set<String>> scopeDims = new HashMap<String, Set<String>>(16);
        ArrayList<Pair<String, String>> pairList = new ArrayList<Pair<String, String>>(10);
        mos.forEach((key, dimmemnums) -> {
            if (dimmemnums.size() > 1) {
                scopeDims.put(dimensions.stream().filter(x -> x.equalsIgnoreCase((String)key)).findFirst().get(), new HashSet(dimmemnums));
            } else if (key.startsWith(TO)) {
                Pair pair = new Pair((Object)this.getDimensionByFieldKey((String)key, dimensions), dimmemnums.get(0));
                pairList.add(pair);
            }
        });
        this.checkDimensionDataStatus(scopeDims, pairList, modelnumber, result);
        return result;
    }

    private void checkDimensionDataStatus(Map<String, Set<String>> scopeDims, List<Pair<String, String>> pointDims, String cubecatalog, Map<String, List<String>> result) {
        ArrayList dimNum2MemNumDims = new ArrayList(10);
        for (Map.Entry<String, Set<String>> next : scopeDims.entrySet()) {
            String key = next.getKey();
            if (!checkDimensions.stream().anyMatch(x -> x.equalsIgnoreCase(key))) continue;
            Set<String> scopeDim = next.getValue();
            ArrayList dimNum2MemNumLists = new ArrayList(scopeDim.size());
            for (String memNum : scopeDim) {
                HashMap<String, String> dimNum2MemNums = new HashMap<String, String>();
                dimNum2MemNums.put(key, memNum);
                dimNum2MemNumLists.add(dimNum2MemNums);
            }
            dimNum2MemNumDims.add(dimNum2MemNumLists);
        }
        List cartMembers = Lists.cartesianProduct(dimNum2MemNumDims);
        this.verifyScript(pointDims, cubecatalog, cartMembers, result);
    }

    private void verifyScript(List<Pair<String, String>> pointDims, String cubecatalog, List<List<Map<String, String>>> cartMembers, Map<String, List<String>> result) {
        block18: {
            String periodNum;
            String fyNum;
            String scenarioNum;
            String storageCurrencyNum;
            String entityNum;
            Long periodId;
            Long yearId;
            Long scenarioId;
            Long entityId;
            block17: {
                String msg;
                block19: {
                    entityId = null;
                    scenarioId = null;
                    yearId = null;
                    periodId = null;
                    entityNum = null;
                    storageCurrencyNum = null;
                    scenarioNum = null;
                    fyNum = null;
                    periodNum = null;
                    for (Pair<String, String> pair : pointDims) {
                        String dimNum = (String)pair.p1;
                        String memNum = (String)pair.p2;
                        if (dimNum.equals(PresetConstant.ENTITY_DIM)) {
                            entityId = RunScriptRecordUtil.findMemberIdByNumber((String)cubecatalog, (String)PresetConstant.ENTITY_DIM, (String)memNum);
                            entityNum = memNum;
                            continue;
                        }
                        if (dimNum.equals(PresetConstant.SCENE_DIM)) {
                            scenarioId = RunScriptRecordUtil.findMemberIdByNumber((String)cubecatalog, (String)PresetConstant.SCENE_DIM, (String)memNum);
                            scenarioNum = memNum;
                            continue;
                        }
                        if (dimNum.equals(PresetConstant.FY_DIM)) {
                            yearId = RunScriptRecordUtil.findMemberIdByNumber((String)cubecatalog, (String)PresetConstant.FY_DIM, (String)memNum);
                            fyNum = memNum;
                            continue;
                        }
                        if (dimNum.equals(PresetConstant.PERIOD_DIM)) {
                            periodId = RunScriptRecordUtil.findMemberIdByNumber((String)cubecatalog, (String)PresetConstant.PERIOD_DIM, (String)memNum);
                            periodNum = memNum;
                            continue;
                        }
                        if (!dimNum.equals(PresetConstant.CURRENCY_DIM)) continue;
                        storageCurrencyNum = memNum;
                    }
                    if (!CollectionUtils.isEmpty(cartMembers)) break block17;
                    if (entityId != null && storageCurrencyNum == null) {
                        storageCurrencyNum = MemberReader.findEntityMemberById((String)cubecatalog, entityId).getCurrency();
                    }
                    if (entityId == null || scenarioId == null || yearId == null || periodId == null || storageCurrencyNum == null) {
                        throw new KDBizException("paramError");
                    }
                    msg = ModelOlapOperationTask.verifyCanExecute(cubecatalog, entityId, scenarioId, yearId, periodId, storageCurrencyNum);
                    if (!StringUtils.isNotEmpty((String)msg)) break block18;
                    if (!"period".equals(msg)) break block19;
                    result.put("period", Collections.singletonList(String.format("%s;%s;%s;%s", entityNum, scenarioNum, fyNum, periodNum)));
                    break block18;
                }
                if (!"merge".equals(msg)) break block18;
                result.put("merge", Collections.singletonList(String.format("%s;%s;%s;%s", entityNum, scenarioNum, fyNum, periodNum)));
                break block18;
            }
            boolean scriptNoEntity = entityNum == null;
            boolean scriptNoScenario = scenarioNum == null;
            boolean scriptNoFy = fyNum == null;
            boolean scriptNoPeriod = periodNum == null;
            boolean scriptNoCurrency = storageCurrencyNum == null;
            ArrayList<String> checkedList = new ArrayList<String>(10);
            for (List<Map<String, String>> cross : cartMembers) {
                for (Map<String, String> one : cross) {
                    for (Map.Entry<String, String> e : one.entrySet()) {
                        if (scriptNoEntity && e.getKey().equals(PresetConstant.ENTITY_DIM)) {
                            entityId = RunScriptRecordUtil.findMemberIdByNumber((String)cubecatalog, (String)PresetConstant.ENTITY_DIM, (String)e.getValue());
                            entityNum = e.getValue();
                            continue;
                        }
                        if (scriptNoScenario && e.getKey().equals(PresetConstant.SCENE_DIM)) {
                            scenarioId = RunScriptRecordUtil.findMemberIdByNumber((String)cubecatalog, (String)PresetConstant.SCENE_DIM, (String)e.getValue());
                            scenarioNum = e.getValue();
                            continue;
                        }
                        if (scriptNoFy && e.getKey().equals(PresetConstant.FY_DIM)) {
                            yearId = RunScriptRecordUtil.findMemberIdByNumber((String)cubecatalog, (String)PresetConstant.FY_DIM, (String)e.getValue());
                            fyNum = e.getValue();
                            continue;
                        }
                        if (scriptNoPeriod && e.getKey().equals(PresetConstant.PERIOD_DIM)) {
                            periodId = RunScriptRecordUtil.findMemberIdByNumber((String)cubecatalog, (String)PresetConstant.PERIOD_DIM, (String)e.getValue());
                            periodNum = e.getValue();
                            continue;
                        }
                        if (!scriptNoCurrency || !e.getKey().equals(PresetConstant.CURRENCY_DIM)) continue;
                        storageCurrencyNum = e.getValue();
                    }
                }
                String checkedKey = String.format("%s|%s|%s|%s|%s", entityNum, scenarioNum, fyNum, periodNum, storageCurrencyNum);
                if (checkedList.contains(checkedKey)) continue;
                checkedList.add(checkedKey);
                if (entityId != null && storageCurrencyNum == null) {
                    storageCurrencyNum = MemberReader.findEntityMemberById((String)cubecatalog, (Long)entityId).getCurrency();
                }
                if (entityId == null || scenarioId == null || yearId == null || periodId == null || storageCurrencyNum == null) {
                    throw new KDBizException("paramError");
                }
                String msg = ModelOlapOperationTask.verifyCanExecute(cubecatalog, entityId, scenarioId, yearId, periodId, storageCurrencyNum);
                if (!StringUtils.isNotEmpty((String)msg)) continue;
                if ("period".equals(msg)) {
                    result.computeIfAbsent("period", k -> new ArrayList(10)).add(String.format("%s;%s;%s;%s", entityNum, scenarioNum, fyNum, periodNum));
                    continue;
                }
                if (!"merge".equals(msg)) continue;
                result.computeIfAbsent("merge", k -> new ArrayList(10)).add(String.format("%s;%s;%s;%s", entityNum, scenarioNum, fyNum, periodNum));
            }
        }
    }

    public static String verifyCanExecute(String modelNum, long entityId, long scenarioId, long fyId, long periodId, String execCurrency) {
        return (String)ThreadCache.get((Object)Joiner.on((char)'|').join((Object)modelNum, (Object)entityId, new Object[]{scenarioId, fyId, periodId, execCurrency}), () -> {
            IDNumberTreeNode baseTreeNode = MemberReader.findEntityMemberById((String)modelNum, (Long)entityId).getBaseTreeNode();
            if (!OlapDataVerifyServiceHelper.checkPeriodOpenStatus((long)baseTreeNode.getModelId(), (String)modelNum, (String)baseTreeNode.getNumber(), (long)scenarioId, (long)fyId, (long)periodId)) {
                return "period";
            }
            McStatus mc = McStatus.getMcStatus((Object)MemberReader.findModelIdByNum((String)modelNum), (Object)baseTreeNode.getId(), (Object)scenarioId, (Object)fyId, (Object)periodId);
            String ec = baseTreeNode.getCurrency();
            if (ec == null) {
                return "";
            }
            if ((mc.getArchive().isArchive() || mc.getFlow().isSubmit()) && ec.equals(execCurrency)) {
                return "merge";
            }
            return "";
        });
    }

    private String getMsg(List<String> noOpen, List<String> merged, List<String> adjust) {
        StringBuilder sb = new StringBuilder();
        sb.append(ResManager.loadKDString((String)"\u6821\u9a8c\u5931\u8d25\uff1a", (String)"ModelOlapOperationTask_6", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(System.getProperty("line.separator"));
        if (CollectionUtils.isNotEmpty(noOpen)) {
            sb.append(ResManager.loadKDString((String)"\u671f\u95f4\u672a\u5f00\u542f\uff1a", (String)"ModelOlapOperationTask_7", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(System.getProperty("line.separator"));
            for (String msg : noOpen) {
                sb.append(msg);
                if (sb.length() >= 200) {
                    sb.append("...");
                    return sb.toString();
                }
                sb.append(System.getProperty("line.separator"));
            }
        }
        if (CollectionUtils.isNotEmpty(merged)) {
            if (sb.length() > 0) {
                sb.append(System.getProperty("line.separator"));
            }
            sb.append(ResManager.loadKDString((String)"\u667a\u80fd\u5408\u5e76\u6d41\u7a0b\u5df2\u63d0\u4ea4\uff1a", (String)"ModelOlapOperationTask_8", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(System.getProperty("line.separator"));
            for (String msg : merged) {
                sb.append(msg).append(",");
                if (sb.length() >= 200) {
                    sb.append("...");
                    return sb.toString();
                }
                sb.append(",");
            }
        }
        if (CollectionUtils.isNotEmpty(adjust)) {
            if (sb.length() > 0) {
                sb.append(System.getProperty("line.separator"));
            }
            sb.append(ResManager.loadKDString((String)"\u8c03\u6574\u62b5\u9500\u5206\u5f55\u5df2\u5ba1\u6838\uff1a", (String)"ModelOlapOperationTask_9", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(System.getProperty("line.separator"));
            for (String msg : adjust) {
                sb.append(msg).append(",");
                if (sb.length() >= 200) {
                    sb.append("...");
                    return sb.toString();
                }
                sb.append(",");
            }
        }
        return sb.toString();
    }

    private void feedBack(int num, boolean opType) {
        String opTip = opType ? ResManager.loadKDString((String)"\u590d\u5236", (String)"ModelOlapOperationTask_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6e05\u9664", (String)"ModelOlapOperationTask_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        String desc = String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u6570\u636e%s", (String)"ModelOlapOperationTask_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), opTip);
        this.feedbackProgress(num, desc, null);
    }
}

