/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.epbs.business.bd.model.ModelSyncHelper;
import kd.fi.bcm.business.dimension.util.ModelDataClearUtils;
import kd.fi.bcm.business.dimension.util.ModelUtil;
import kd.fi.bcm.business.serviceHelper.MemberPermSpreadLogic;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.ModelStatusEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.util.ModelDeleteUtil;
import org.apache.commons.collections.CollectionUtils;

public class ModelRemovalListPlugin
extends AbstractBaseListPlugin {
    private static final WatchLogger LOG = BcmLogFactory.getWatchLogInstance(ModelRemovalListPlugin.class);
    private static final String BILLLIST_AP = "billlistap";
    private static final String BILLLIST_AP2 = "billlistap2";
    private static final String RESTORE_BTN = "restore";
    private static final String DELETE_BTN = "delete";
    private static final String BTN_NEXT = "btnnext";
    private static final String BTN_PREV = "btnprev";
    private static final String BTN_OK = "btnok";

    @Override
    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getControl(BILLLIST_AP);
        billList.addSetFilterListener(e -> {
            this.addFilters(e);
            e.getQFilters().add(new QFilter("status", "=", (Object)ModelStatusEnum.REMOVAL.getValue()));
            e.setOrderBy("modifytime desc");
        });
        BillList billList2 = (BillList)this.getControl(BILLLIST_AP2);
        billList2.addSetFilterListener(e -> {
            this.addFilters(e);
            e.getQFilters().add(new QFilter("status", "in", Arrays.asList(ModelStatusEnum.RESTORE.getValue(), ModelStatusEnum.DELETE.getValue())));
            e.setOrderBy("modifytime desc");
        });
        billList2.addCreateListDataProviderListener(this::beforeCreateListDataProvider);
    }

    @Override
    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int arg0, int arg1) {
                DynamicObjectCollection rows = super.getData(arg0, arg1);
                if (rows.isEmpty()) {
                    return rows;
                }
                for (DynamicObject row : rows) {
                    String status = row.getString("status");
                    String sign = ModelStatusEnum.RESTORE.getValue().equals(status) ? ResManager.loadKDString((String)"\u8fd8\u539f", (String)"ModelRemovalListPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5220\u9664", (String)"ModelRemovalListPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                    row.set("description", (Object)sign);
                }
                return rows;
            }
        });
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Label restoreLable = (Label)this.getControl(RESTORE_BTN);
        restoreLable.addClickListener((ClickListener)this);
        Label deleteLable = (Label)this.getControl(DELETE_BTN);
        deleteLable.addClickListener((ClickListener)this);
        this.addClickListeners(BTN_NEXT, BTN_PREV, BTN_OK);
        ((Tab)this.getControl("guidecontent")).addTabSelectListener(this::modelDelTab);
    }

    private void modelDelTab(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        if ("tabpageap".equals(tabKey)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_PREV, BTN_OK});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BTN_NEXT, RESTORE_BTN, DELETE_BTN});
        } else if ("tabpageap1".equals(tabKey)) {
            BillList billList = (BillList)this.getControl(BILLLIST_AP2);
            billList.refresh();
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BTN_PREV, BTN_OK});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_NEXT, RESTORE_BTN, DELETE_BTN});
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_PREV, BTN_OK});
    }

    @Override
    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "restore": {
                this.restoreModel();
                break;
            }
            case "delete": {
                this.deleteModel();
                break;
            }
            case "btnnext": {
                BillList billList = (BillList)this.getControl(BILLLIST_AP2);
                billList.refresh();
                this.getView().setVisible(Boolean.valueOf(true), new String[]{BTN_PREV, BTN_OK});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_NEXT, RESTORE_BTN, DELETE_BTN});
                break;
            }
            case "btnprev": {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_PREV, BTN_OK});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{BTN_NEXT, RESTORE_BTN, DELETE_BTN});
                break;
            }
            case "btnok": {
                this.restoreAndDelete();
            }
        }
    }

    protected void addFilters(SetFilterEvent e) {
        ApplicationTypeEnum sign = ModelUtil.queryApp((IFormView)this.getView());
        e.getQFilters().add(ModelRemovalListPlugin.getModelPermFilterOfNoStatus("id", this.getBizEntityNumber(), sign));
        QFilter qf = null;
        if (ApplicationTypeEnum.CM == sign) {
            qf = new QFilter("reporttype", "=", (Object)ApplicationTypeEnum.CM.getOIndex());
        } else if (ApplicationTypeEnum.RPT == sign) {
            qf = new QFilter("reporttype", "=", (Object)ApplicationTypeEnum.RPT.getOIndex());
        }
        e.getQFilters().add(qf);
        e.getQFilters().add(new QFilter("enable", "=", (Object)"0"));
    }

    protected void restoreModel() {
        DynamicObject[] dys;
        BillList billList = (BillList)this.getControl(BILLLIST_AP);
        ListSelectedRowCollection selectModels = billList.getSelectedRows();
        if (selectModels.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ModelDistributeListPlugin_36", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        Set ids = selectModels.stream().map(x -> x.getPrimaryKeyValue()).collect(Collectors.toSet());
        QFilter qf = new QFilter("id", "in", ids);
        for (DynamicObject dy : dys = BusinessDataServiceHelper.load((String)"bcm_model", (String)"enable, status, modifier, modifytime", (QFilter[])qf.toArray())) {
            dy.set("status", (Object)ModelStatusEnum.RESTORE.getValue());
            dy.set("modifier", (Object)RequestContext.get().getCurrUserId());
            dy.set("modifytime", (Object)new Date());
        }
        SaveServiceHelper.save((DynamicObject[])dys);
        billList.clearSelection();
        billList.refresh();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"ModelRemovalListPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    private void deleteModel() {
        ArrayList<DynamicObject> leaveDys;
        String appNumber;
        BillList billList = (BillList)this.getControl(BILLLIST_AP);
        ListSelectedRowCollection selectModels = billList.getSelectedRows();
        if (selectModels.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ModelDistributeListPlugin_36", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        Set ids = selectModels.stream().map(x -> x.getPrimaryKeyValue()).collect(Collectors.toSet());
        QFilter qf = new QFilter("id", "in", ids);
        DynamicObject[] dys = BusinessDataServiceHelper.load((String)"bcm_model", (String)"status, modifier, modifytime", (QFilter[])qf.toArray());
        String msg = ModelDeleteUtil.validate(dys, appNumber = this.isCM() ? ApplicationTypeEnum.CM.getAppnum() : ApplicationTypeEnum.RPT.getAppnum(), leaveDys = new ArrayList<DynamicObject>(16));
        if (StringUtils.isNotEmpty((String)msg)) {
            if (leaveDys.size() != 0) {
                for (DynamicObject dy : leaveDys) {
                    dy.set("status", (Object)ModelStatusEnum.DELETE.getValue());
                    dy.set("modifier", (Object)RequestContext.get().getCurrUserId());
                    dy.set("modifytime", (Object)new Date());
                }
                SaveServiceHelper.save((DynamicObject[])leaveDys.toArray(new DynamicObject[0]));
                billList.clearSelection();
                billList.refresh();
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5904\u7406\u7ed3\u679c\uff1a%1$s\u6761\u6210\u529f\uff0c%2$s\u6761\u5931\u8d25\u3002", (String)"ModelRemovalListPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), leaveDys.size(), dys.length - leaveDys.size()));
                return;
            }
            this.getView().showTipNotification(msg);
            return;
        }
        for (DynamicObject dy : dys) {
            dy.set("status", (Object)ModelStatusEnum.DELETE.getValue());
            dy.set("modifier", (Object)RequestContext.get().getCurrUserId());
            dy.set("modifytime", (Object)new Date());
        }
        SaveServiceHelper.save((DynamicObject[])dys);
        billList.clearSelection();
        billList.refresh();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"ModelRemovalListPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    private void restoreAndDelete() {
        BillList billList = (BillList)this.getControl(BILLLIST_AP2);
        ListSelectedRowCollection selectModels = billList.getSelectedRows();
        if (selectModels.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ModelDistributeListPlugin_36", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        Map<String, List<ListSelectedRow>> groups = selectModels.stream().collect(Collectors.groupingBy(x -> x.getBillStatus()));
        HashMap<String, List<String>> opLogNums = new HashMap<String, List<String>>(16);
        try (TXHandle tx = TX.required((String)"ModelRemovalListPlugin.restoreAndDelete");){
            try {
                for (Map.Entry<String, List<ListSelectedRow>> next : groups.entrySet()) {
                    if (ModelStatusEnum.RESTORE.getValue().equals(next.getKey()) && next.getValue().size() > 0) {
                        this.realRestoreModel(next.getValue(), opLogNums);
                        continue;
                    }
                    if (next.getValue().size() <= 0) continue;
                    this.realDeleteModel(next.getValue(), opLogNums);
                }
            }
            catch (Exception e) {
                tx.markRollback();
                LOG.error(e.getMessage(), (Throwable)e);
                throw new KDBizException(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30));
            }
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5b8c\u6210\u3002", (String)"ModelRemovalListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        billList.clearSelection();
        billList.refresh();
        ListSelectedRowCollection allRowCollection = billList.getCurrentListAllRowCollection();
        BillList billList1 = (BillList)this.getControl(BILLLIST_AP);
        ListSelectedRowCollection allRowCollection1 = billList1.getCurrentListAllRowCollection();
        this.writeOpeLog(opLogNums);
        if (allRowCollection.size() == 0 && allRowCollection1.size() == 0) {
            this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5b8c\u6210\u3002", (String)"ModelRemovalListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            this.getView().close();
        }
    }

    private void writeOpeLog(Map<String, List<String>> opLogNums) {
        if (opLogNums.size() > 0) {
            StringBuilder sb = new StringBuilder();
            List<String> restores = opLogNums.get(RESTORE_BTN);
            List<String> deletes = opLogNums.get(DELETE_BTN);
            if (CollectionUtils.isNotEmpty(restores)) {
                sb.append(ResManager.loadKDString((String)"\u8fd8\u539f%s\u4f53\u7cfb\u6210\u529f\u3002", (String)"ModelDistributeListPlugin_65", (String)"fi-bcm-formplugin", (Object[])new Object[]{String.join((CharSequence)",", restores)}));
            }
            if (CollectionUtils.isNotEmpty(deletes)) {
                sb.append(ResManager.loadKDString((String)"\u5220\u9664%s\u4f53\u7cfb\u6210\u529f\u3002", (String)"ModelDistributeListPlugin_66", (String)"fi-bcm-formplugin", (Object[])new Object[]{String.join((CharSequence)",", deletes)}));
            }
            OpNameMultiLangEnumBridge opName = new OpNameMultiLangEnumBridge("\u4f53\u7cfb\u5220\u9664\u4e0e\u8fd8\u539f", "ModelDistributeListPlugin_64", "fi-bcm-formplugin", "modelDelAndRestore");
            this.writeMultiLangLog(opName, OPDescMultiLangEnumBridge.genUnTransBridge((String)sb.toString()));
        }
    }

    private void realRestoreModel(List<ListSelectedRow> selectedRows, Map<String, List<String>> opLogNums) {
        DynamicObject[] dys;
        Set ids = selectedRows.stream().map(x -> x.getPrimaryKeyValue()).collect(Collectors.toSet());
        LOG.info("realRestoreModel ids\uff1a" + Arrays.toString(ids.toArray()));
        QFilter qf = new QFilter("id", "in", ids);
        for (DynamicObject dy : dys = BusinessDataServiceHelper.load((String)"bcm_model", (String)"shownumber, enable, status, modifier, modifytime", (QFilter[])qf.toArray())) {
            dy.set("status", (Object)ModelStatusEnum.AUDIT.getValue());
            dy.set("enable", (Object)"1");
            dy.set("modifier", (Object)RequestContext.get().getCurrUserId());
            dy.set("modifytime", (Object)new Date());
        }
        SaveServiceHelper.save((DynamicObject[])dys);
        ModelSyncHelper.updateEpbsModel((Collection)selectedRows.stream().map(x -> (Long)x.getPrimaryKeyValue()).collect(Collectors.toList()));
        opLogNums.computeIfAbsent(RESTORE_BTN, k -> new ArrayList(10)).addAll(Arrays.stream(dys).map(x -> x.getString("shownumber")).collect(Collectors.toList()));
    }

    private void realDeleteModel(List<ListSelectedRow> selectedRows, Map<String, List<String>> opLogNums) {
        this.getView().showLoading(ResManager.getLocaleString((String)"\u4f53\u7cfb\u6b63\u5728\u5220\u9664\u4e2d...", (String)"ModelRemovalListPlugin_5", (String)"fi-bcm-formplugin"));
        Set ids = selectedRows.stream().map(x -> x.getPrimaryKeyValue()).collect(Collectors.toSet());
        LOG.info("realDeleteModel ids\uff1a" + Arrays.toString(ids.toArray()));
        QFilter qf = new QFilter("id", "in", ids);
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"bcm_model", (String)"number, shownumber", (QFilter[])qf.toArray());
        ModelDataClearUtils.clearModels((Object[])ids.toArray());
        Set<String> numbers = dys.stream().map(x -> x.getString("number")).collect(Collectors.toSet());
        numbers.forEach(number -> {
            if (OlapServiceHelper.isExistCube((String)number)) {
                OlapServiceHelper.dropCubeSchemes((String)number);
            }
        });
        ModelSyncHelper.deleteEpbsModel((Collection)selectedRows.stream().map(x -> (Long)x.getPrimaryKeyValue()).collect(Collectors.toList()));
        opLogNums.computeIfAbsent(DELETE_BTN, k -> new ArrayList(10)).addAll(dys.stream().map(x -> x.getString("shownumber")).collect(Collectors.toList()));
        this.getView().hideLoading();
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        DynamicObject[] models;
        super.beforeClosed(e);
        BillList billList = (BillList)this.getControl(BILLLIST_AP2);
        ListSelectedRowCollection selectModels = billList.getCurrentListAllRowCollection();
        if (selectModels.size() == 0) {
            return;
        }
        Set selectedIds = selectModels.stream().map(x -> (Long)x.getPrimaryKeyValue()).collect(Collectors.toSet());
        QFilter qf = new QFilter("id", "in", selectedIds);
        for (DynamicObject dynamicObject : models = BusinessDataServiceHelper.load((String)"bcm_model", (String)"status", (QFilter[])qf.toArray())) {
            dynamicObject.set("status", (Object)ModelStatusEnum.REMOVAL.getValue());
        }
        SaveServiceHelper.save((DynamicObject[])models);
    }

    public static QFilter getModelPermFilterOfNoStatus(String filterField, String formId, ApplicationTypeEnum application) {
        MemberPermSpreadLogic memberPermSpreadLogic = new MemberPermSpreadLogic();
        if ("bcm_modelperm_manager".equals(formId) || "report_modelperm_manager".equals(formId)) {
            return new QFilter(filterField, "in", (Object)memberPermSpreadLogic.getLimitedModelListByUser(application, Boolean.valueOf(true), Boolean.valueOf(false)));
        }
        return new QFilter(filterField, "in", (Object)memberPermSpreadLogic.getLimitedModelListByUser(application, Boolean.valueOf(false), Boolean.valueOf(false)));
    }
}

