/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.model;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.olap.shield.ShieldRuleBulider;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.upgrade.AbstractUpgradeService;
import kd.fi.bcm.business.upgrade.AccountMulTransactionUpgradeService;
import kd.fi.bcm.business.upgrade.AnalyticsSolutionDataUpgradeService;
import kd.fi.bcm.business.upgrade.BaseDataConfigUpgradeService;
import kd.fi.bcm.business.upgrade.BizRuleManagerUpgradeService;
import kd.fi.bcm.business.upgrade.CHKUpgradeService;
import kd.fi.bcm.business.upgrade.ConvertRelatedUpgradeService;
import kd.fi.bcm.business.upgrade.DimensionUpgradeIService;
import kd.fi.bcm.business.upgrade.IUpgradeService;
import kd.fi.bcm.business.upgrade.InvlimTempUpgradeService;
import kd.fi.bcm.business.upgrade.LinksourceUpgradeService;
import kd.fi.bcm.business.upgrade.PlatformPermUpgradeService;
import kd.fi.bcm.business.upgrade.RateCslSchemeUpgradeService;
import kd.fi.bcm.business.upgrade.ReportAdjustProcessUpgradeService;
import kd.fi.bcm.business.upgrade.ReportTempUpgradeService;
import kd.fi.bcm.business.upgrade.RptAdjustQuerySchemeUpgradeService;
import kd.fi.bcm.business.upgrade.UpgradeContext;
import kd.fi.bcm.business.upgrade.UpgradeServieceManager;
import kd.fi.bcm.business.upgrade.WorkPaperUpgradeService;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;

public class ModelUpgradeLogPlugin
extends AbstractBaseListPlugin
implements ProgresssListener {
    private static final String BILL_LIST_AP = "billlistap";
    private static final String BTN_START = "btn_start";
    private static final String BTN_RE_START = "btn_re_start";
    private static final String ENABLEYEAR = "enableyear";
    private static final String EXCEPERIOD = "exceperiod";
    private static final String MODELCONSTANT = "model";
    private static final String STATUS = "status";
    private static final String NUMBER = "number";
    private static final String PARENTCHILD = "parentchild";
    private static final String DIMENSION = "dimension";
    private static final String PROGRESSBARAP = "progressbarap";
    private static final String BCM_UPGRADE_DYNCALCINFO = "bcm_upgrade_dyncalcinfo";
    private static final String DATA = "data";
    private static final String SUCCESS = "1";
    private static WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, ModelUpgradeLogPlugin.class);

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btn_close", BTN_START, BTN_RE_START, "btn_re_process", "save");
        ((ProgressBar)this.getControl(PROGRESSBARAP)).addProgressListener((ProgresssListener)this);
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        long modelId = this.getModelId();
        Set upgradeItemsSet = null;
        boolean dimensionUpgradedOnly = false;
        boolean flagNewStart = true;
        switch (key) {
            case "btn_re_start": {
                BillList billList = (BillList)this.getControl(BILL_LIST_AP);
                ListSelectedRowCollection selectedRows = billList.getSelectedRows();
                if (selectedRows.size() < 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u5347\u7ea7\u9879\u3002", (String)"ModelUpgradeLogPlugin_24", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                QFilter IdQf = new QFilter("id", "in", selectedRows.stream().map(x -> x.getPrimaryKeyValue()).collect(Collectors.toSet()));
                DynamicObjectCollection selectItems = QueryServiceHelper.query((String)"bcm_upgradestatus", (String)NUMBER, (QFilter[])new QFilter[]{IdQf});
                upgradeItemsSet = selectItems.stream().map(x -> x.getString(NUMBER)).collect(Collectors.toSet());
                dimensionUpgradedOnly = this.isOnlyDimensionUpgraded(this.getModelId());
                OpNameMultiLangEnumBridge opName = new OpNameMultiLangEnumBridge("\u70b9\u51fb\u7acb\u5373\u5347\u7ea7", "ModelUpgradeLogPlugin_27", "fi-bcm-formplugin", "clickUpgradeNow");
                OPDescMultiLangEnumBridge opDes = new OPDescMultiLangEnumBridge("\u518d\u6b21\u70b9\u51fb\u6210\u529f\u3002", "ModelUpgradeLogPlugin_28", "fi-bcm-formplugin", null);
                this.writeMultiLangLog(opName, opDes);
                flagNewStart = false;
            }
            case "btn_start": {
                boolean sucess;
                String enableYear = (String)this.getModel().getValue(ENABLEYEAR);
                if (StringUtils.isEmpty((CharSequence)enableYear)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u52a8\u6001\u8ba1\u7b97\u542f\u7528\u5e74\u4efd\u3002", (String)"ModelUpgradeLogPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                String[] enableDateArr = enableYear.split("FY");
                String dateValue = enableDateArr[1];
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy");
                Date date = null;
                try {
                    date = dateFormat.parse(dateValue);
                }
                catch (ParseException e) {
                    log.error((Throwable)e);
                }
                DynamicObject model = BusinessDataServiceHelper.loadSingle((Object)modelId, (String)"bcm_model", (String)NUMBER);
                boolean isSupportDy = OlapServiceHelper.checkCubeIsEnableDynamic((String)model.getString(NUMBER));
                if (!isSupportDy) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u6570\u636e\u6e90\u4e0d\u652f\u6301\u52a8\u6001\u8ba1\u7b97\uff0c\u65e0\u6cd5\u5347\u7ea7\u3002\u8bf7\u5148\u901a\u77e5\u8fd0\u7ef4\u4eba\u5458\u5347\u7ea7\u52a8\u6001\u8ba1\u7b97\u6570\u636e\u6e90\uff0c\u4ee5\u652f\u6301\u52a8\u6001\u8ba1\u7b97\u3002", (String)"ModelUpgradeLogPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                ProgressBar bar = (ProgressBar)this.getControl(PROGRESSBARAP);
                bar.start();
                UpgradeContext context = new UpgradeContext(model.getString(NUMBER), modelId, date);
                Long upgradeid = (Long)this.getView().getFormShowParameter().getCustomParam("upgradeid");
                this.initOldContextMemb(context, upgradeid);
                UpgradeServieceManager upgrader = new UpgradeServieceManager(upgradeid.longValue(), context);
                upgrader.addUpgradeService((IUpgradeService)new DimensionUpgradeIService((List)Lists.newArrayList(), DIMENSION, ResManager.getLocaleString((String)"\u7ef4\u5ea6", (String)"ModelUpgradeLogPlugin_3", (String)"fi-bcm-formplugin"), context));
                if (upgradeItemsSet == null || upgradeItemsSet.contains("InvElim") || dimensionUpgradedOnly) {
                    upgrader.addUpgradeService((IUpgradeService)new InvlimTempUpgradeService((List)Lists.newArrayList((Object[])new String[]{DIMENSION}), "InvElim", ResManager.getLocaleString((String)"\u6743\u76ca", (String)"ModelUpgradeLogPlugin_4", (String)"fi-bcm-formplugin"), context));
                }
                if (upgradeItemsSet == null || upgradeItemsSet.contains("AccountMul") || dimensionUpgradedOnly) {
                    upgrader.addUpgradeService((IUpgradeService)new AccountMulTransactionUpgradeService((List)Lists.newArrayList((Object[])new String[]{DIMENSION}), "AccountMul", ResManager.getLocaleString((String)"\u5bf9\u8d26\u6a21\u677f", (String)"ModelUpgradeLogPlugin_5", (String)"fi-bcm-formplugin"), context));
                }
                if (upgradeItemsSet == null || upgradeItemsSet.contains("template") || dimensionUpgradedOnly) {
                    upgrader.addUpgradeService((IUpgradeService)new ReportTempUpgradeService((List)Lists.newArrayList((Object[])new String[]{DIMENSION}), "template", ResManager.getLocaleString((String)"\u62a5\u8868\u6a21\u677f", (String)"ModelUpgradeLogPlugin_6", (String)"fi-bcm-formplugin"), context));
                }
                if (upgradeItemsSet == null || upgradeItemsSet.contains("chk") || dimensionUpgradedOnly) {
                    upgrader.addUpgradeService((IUpgradeService)new CHKUpgradeService((List)Lists.newArrayList((Object[])new String[]{DIMENSION}), "chk", ResManager.getLocaleString((String)"\u52fe\u7a3d\u5173\u7cfb", (String)"ModelUpgradeLogPlugin_7", (String)"fi-bcm-formplugin"), context));
                }
                if (upgradeItemsSet == null || upgradeItemsSet.contains("Linksource") || dimensionUpgradedOnly) {
                    upgrader.addUpgradeService((IUpgradeService)new LinksourceUpgradeService((List)Lists.newArrayList((Object[])new String[]{DIMENSION}), "Linksource", ResManager.getLocaleString((String)"\u4e3b\u9644\u8054\u52a8\u8bbe\u7f6e", (String)"ModelUpgradeLogPlugin_8", (String)"fi-bcm-formplugin"), context));
                }
                if (upgradeItemsSet == null || upgradeItemsSet.contains("ReportAdjustProcess") || dimensionUpgradedOnly) {
                    upgrader.addUpgradeService((IUpgradeService)new ReportAdjustProcessUpgradeService((List)Lists.newArrayList((Object[])new String[]{DIMENSION}), "ReportAdjustProcess", ResManager.getLocaleString((String)"\u8868\u5f0f\u8c03\u6574", (String)"ModelUpgradeLogPlugin_9", (String)"fi-bcm-formplugin"), context));
                }
                if (upgradeItemsSet == null || upgradeItemsSet.contains("RptAdjustQueryScheme") || dimensionUpgradedOnly) {
                    upgrader.addUpgradeService((IUpgradeService)new RptAdjustQuerySchemeUpgradeService((List)Lists.newArrayList((Object[])new String[]{DIMENSION}), "RptAdjustQueryScheme", ResManager.getLocaleString((String)"\u8c03\u6574\u62b5\u6d88\u67e5\u8be2", (String)"ModelUpgradeLogPlugin_10", (String)"fi-bcm-formplugin"), context));
                }
                if (upgradeItemsSet == null || upgradeItemsSet.contains("WorkPaper") || dimensionUpgradedOnly) {
                    upgrader.addUpgradeService((IUpgradeService)new WorkPaperUpgradeService((List)Lists.newArrayList((Object[])new String[]{DIMENSION}), "WorkPaper", ResManager.getLocaleString((String)"\u5de5\u4f5c\u5e95\u7a3f", (String)"ModelUpgradeLogPlugin_11", (String)"fi-bcm-formplugin"), context));
                }
                if (upgradeItemsSet == null || upgradeItemsSet.contains("Convert") || dimensionUpgradedOnly) {
                    upgrader.addUpgradeService((IUpgradeService)new ConvertRelatedUpgradeService((List)Lists.newArrayList((Object[])new String[]{DIMENSION}), "Convert", ResManager.getLocaleString((String)"\u6298\u7b97\u76f8\u5173", (String)"ModelUpgradeLogPlugin_12", (String)"fi-bcm-formplugin"), context));
                }
                if (!this.isUpgradedSuccessful(this.getModelId(), "BizRule") || dimensionUpgradedOnly) {
                    upgrader.addUpgradeService((IUpgradeService)new BizRuleManagerUpgradeService((List)Lists.newArrayList((Object[])new String[]{DIMENSION}), "BizRule", ResManager.getLocaleString((String)"\u4e1a\u52a1\u89c4\u5219", (String)"ModelUpgradeLogPlugin_13", (String)"fi-bcm-formplugin"), context));
                }
                if (upgradeItemsSet == null || upgradeItemsSet.contains("rate") || dimensionUpgradedOnly) {
                    upgrader.addUpgradeService((IUpgradeService)new RateCslSchemeUpgradeService((List)Lists.newArrayList((Object[])new String[]{DIMENSION}), "rate", ResManager.getLocaleString((String)"\u6c47\u7387\u7ec4\u7ec7\u89c6\u56fe", (String)"ModelUpgradeLogPlugin_14", (String)"fi-bcm-formplugin"), context));
                }
                if (upgradeItemsSet == null || upgradeItemsSet.contains("AnalyticsSolutionData") || dimensionUpgradedOnly) {
                    upgrader.addUpgradeService((IUpgradeService)new AnalyticsSolutionDataUpgradeService((List)Lists.newArrayList((Object[])new String[]{DIMENSION}), "AnalyticsSolutionData", ResManager.getLocaleString((String)"\u591a\u7ef4\u67e5\u8be2\u65b9\u6848", (String)"ModelUpgradeLogPlugin_23", (String)"fi-bcm-formplugin"), context));
                }
                if (!this.isUpgradedSuccessful(this.getModelId(), "perm") || dimensionUpgradedOnly) {
                    upgrader.addUpgradeService((IUpgradeService)new PlatformPermUpgradeService((List)Lists.newArrayList((Object[])new String[]{DIMENSION}), "perm", ResManager.getLocaleString((String)"\u6743\u9650", (String)"perm_1", (String)"fi-bcm-formplugin"), context));
                }
                if (upgradeItemsSet == null || upgradeItemsSet.contains("baseDataConfig") || dimensionUpgradedOnly || !this.isUpgradedSuccessful(this.getModelId(), "baseDataConfig")) {
                    upgrader.addUpgradeService((IUpgradeService)new BaseDataConfigUpgradeService((List)Lists.newArrayList((Object[])new String[]{DIMENSION}), "baseDataConfig", ResManager.getLocaleString((String)"\u57fa\u7840\u914d\u7f6e\u6570\u636e", (String)"ModelUpgradeLogPlugin_25", (String)"fi-bcm-formplugin"), context));
                }
                if (sucess = upgrader.excuteUpgrade()) {
                    QFilter modelFilter = new QFilter(MODELCONSTANT, "=", (Object)modelId);
                    QFilter[] filters = new QFilter[]{modelFilter};
                    Boolean dynamicCalcInfoExist = QueryServiceHelper.exists((String)BCM_UPGRADE_DYNCALCINFO, (QFilter[])filters);
                    try {
                        this.saveMultiDimensional();
                        this.saveDynamicCalculateInfo(modelId, Boolean.FALSE, dynamicCalcInfoExist, filters);
                    }
                    catch (Exception exception) {
                        log.error((Throwable)exception);
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u52a8\u6001\u8ba1\u7b97\u671f\u95f4\u8bbe\u7f6e\u5931\u8d25\uff0c%s\u3002", (String)"ModelUpgradeLogPlugin_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]), exception.getMessage()));
                    }
                }
                if (flagNewStart) {
                    OpNameMultiLangEnumBridge opNa = new OpNameMultiLangEnumBridge("\u70b9\u51fb\u7acb\u5373\u5347\u7ea7", "ModelUpgradeLogPlugin_27", "fi-bcm-formplugin", "clickUpgradeNow");
                    OPDescMultiLangEnumBridge opDesription = new OPDescMultiLangEnumBridge("\u70b9\u51fb\u6210\u529f\u3002", "ModelUpgradeLogPlugin_29", "fi-bcm-formplugin", null);
                    this.writeMultiLangLog(opNa, opDesription);
                }
                this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_START});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{BTN_RE_START});
                break;
            }
            case "progrefresh": {
                BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
                billList.refresh();
                break;
            }
            case "save": {
                String enableYearVal = (String)this.getModel().getValue(ENABLEYEAR);
                if (StringUtils.isEmpty((CharSequence)enableYearVal)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u52a8\u6001\u8ba1\u7b97\u542f\u7528\u5e74\u4efd\u3002", (String)"ModelUpgradeLogPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                QFilter modelFilter = new QFilter(MODELCONSTANT, "=", (Object)modelId);
                QFilter[] filters = new QFilter[]{modelFilter};
                Boolean dynamicCalcInfoExist = QueryServiceHelper.exists((String)BCM_UPGRADE_DYNCALCINFO, (QFilter[])filters);
                try {
                    this.saveMultiDimensional();
                    this.saveDynamicCalculateInfo(modelId, Boolean.TRUE, dynamicCalcInfoExist, filters);
                    break;
                }
                catch (Exception exception) {
                    log.error((Throwable)exception);
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u52a8\u6001\u8ba1\u7b97\u671f\u95f4\u8bbe\u7f6e\u5931\u8d25\uff0c%s\u3002", (String)"ModelUpgradeLogPlugin_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]), exception.getMessage()));
                }
            }
        }
    }

    private void saveMultiDimensional() {
        long modelId = this.getModelId();
        DynamicObject model = BusinessDataServiceHelper.loadSingle((Object)modelId, (String)"bcm_model", (String)NUMBER);
        this.handleFyShieldRule(model.getString(NUMBER), modelId);
    }

    private void saveDynamicCalculateInfo(Long modelId, Boolean isSaveOperate, Boolean dynamicCalcInfoExist, QFilter[] filters) {
        String expPeriodVal = (String)this.getModel().getValue(EXCEPERIOD);
        String enableYearVal = (String)this.getModel().getValue(ENABLEYEAR);
        if (dynamicCalcInfoExist.booleanValue()) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)BCM_UPGRADE_DYNCALCINFO, (String)"enableyear,exceperiod,modifier,modifydate,data", (QFilter[])filters);
            String enableYear = (String)dynamicObject.get(ENABLEYEAR);
            Boolean modelChanged = Boolean.FALSE;
            if (enableYearVal != null && !enableYearVal.equals(enableYear)) {
                dynamicObject.set(ENABLEYEAR, (Object)enableYearVal);
                modelChanged = Boolean.TRUE;
            }
            String fianleExpPeriod = null;
            String expPeriod = (String)dynamicObject.get(EXCEPERIOD);
            String expPeriodData = (String)dynamicObject.get(DATA);
            if (StringUtils.isNotEmpty((CharSequence)expPeriodData)) {
                fianleExpPeriod = expPeriodData;
                dynamicObject.set(EXCEPERIOD, null);
            } else if (StringUtils.isNotEmpty((CharSequence)expPeriod)) {
                fianleExpPeriod = expPeriod;
                dynamicObject.set(EXCEPERIOD, null);
            }
            if (expPeriodVal != null && !expPeriodVal.equals(fianleExpPeriod) || expPeriodVal == null && fianleExpPeriod != null) {
                dynamicObject.set(DATA, (Object)expPeriodVal);
                modelChanged = Boolean.TRUE;
            }
            if (modelChanged.booleanValue()) {
                this.updateCalculateInfo(dynamicObject, isSaveOperate);
            } else if (isSaveOperate.booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u65e0\u53d8\u66f4\u3002", (String)"ModelUpgradeLogPlugin_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        } else {
            this.addCalculateInfo(modelId, enableYearVal, expPeriodVal, isSaveOperate);
        }
    }

    private void updateCalculateInfo(DynamicObject dynamicObject, Boolean flag) {
        Long currentUserId = Long.parseLong(RequestContext.get().getUserId());
        Long modifierId = dynamicObject.getLong("modifier.id");
        if (modifierId != null && modifierId.equals(currentUserId)) {
            dynamicObject.set("modifier", (Object)currentUserId);
        }
        dynamicObject.set("modifydate", (Object)new Date());
        SaveServiceHelper.update((DynamicObject)dynamicObject);
        if (flag.booleanValue()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ModelUpgradeLogPlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private void addCalculateInfo(Long modelId, String enableYear, String expPeriodVal, Boolean flag) {
        Long currentUserId = Long.parseLong(RequestContext.get().getUserId());
        DynamicObject newDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)BCM_UPGRADE_DYNCALCINFO);
        newDynamicObject.set(MODELCONSTANT, (Object)modelId);
        newDynamicObject.set(ENABLEYEAR, (Object)enableYear);
        if (expPeriodVal != null) {
            newDynamicObject.set(DATA, (Object)expPeriodVal);
        }
        newDynamicObject.set("creater", (Object)currentUserId);
        newDynamicObject.set("createdate", (Object)new Date());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newDynamicObject});
        if (flag.booleanValue()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ModelUpgradeLogPlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private void handleFyShieldRule(String modelNum, long modelId) {
        String curr_Fy = (String)this.getModel().getValue(ENABLEYEAR);
        if (StringUtils.isNotEmpty((CharSequence)curr_Fy)) {
            IDNumberTreeNode allYearNode = MemberReader.findFyMemberByNum((String)modelNum, (String)"AllYear");
            ArrayList allDimsShortNum = new ArrayList(MemberReader.getDimensionShortNumber2NumberMap((String)modelNum).keySet());
            allDimsShortNum.remove(DimTypesEnum.YEAR.getShortNumber());
            allDimsShortNum.remove(DimTypesEnum.PROCESS.getShortNumber());
            allDimsShortNum.remove(DimTypesEnum.ENTITY.getShortNumber());
            allDimsShortNum.remove(DimTypesEnum.AUDITTRIAL.getShortNumber());
            String dimsKey = Joiner.on((char)',').join(allDimsShortNum);
            String excePeriod = (String)this.getModel().getValue(EXCEPERIOD);
            Boolean hasExcePeriod = Boolean.FALSE;
            for (IDNumberTreeNode treeNode : allYearNode.getChildren()) {
                ShieldRuleBulider srb;
                String number = treeNode.getNumber();
                if (StringUtils.isNotEmpty((CharSequence)number) && (number.compareTo(curr_Fy) < 0 || number.equals(curr_Fy) && StringUtils.isNotEmpty((CharSequence)excePeriod))) {
                    srb = new ShieldRuleBulider((Object)modelId);
                    long srid = srb.getShieldRule((Object)treeNode.getDimId(), dimsKey);
                    if (number.equals(curr_Fy)) {
                        number = null;
                        if (StringUtils.isNotEmpty((CharSequence)excePeriod)) {
                            hasExcePeriod = Boolean.TRUE;
                        }
                    }
                    srb.saveDynOlapInfo(curr_Fy, number, treeNode.getDimId().longValue(), treeNode.getId().longValue(), srid, excePeriod, hasExcePeriod);
                    hasExcePeriod = Boolean.FALSE;
                    continue;
                }
                hasExcePeriod = Boolean.FALSE;
                srb = new ShieldRuleBulider((Object)modelId);
                srb.saveDynOlapInfo(curr_Fy, number, treeNode.getDimId().longValue(), treeNode.getId().longValue(), 0L, excePeriod, hasExcePeriod);
            }
        }
    }

    private void initOldContextMemb(UpgradeContext context, Long upgradeid) {
        DynamicObject upgradeDy = BusinessDataServiceHelper.loadSingle((Object)upgradeid, (String)"bcm_upgradecontent");
        for (DynamicObject modelRecord : upgradeDy.getDynamicObjectCollection("entryentity")) {
            String data;
            if (modelRecord.getLong("model.id") != context.getModelId() || StringUtils.isEmpty((CharSequence)(data = modelRecord.getString(DATA)))) continue;
            JSONObject contextJS = (JSONObject)JSONObject.parse((String)data);
            JSONObject del_bps = (JSONObject)contextJS.get((Object)"del_bps");
            JSONObject del_at = (JSONObject)contextJS.get((Object)"del_at");
            JSONObject del_c = (JSONObject)contextJS.get((Object)"del_c");
            for (Map.Entry bpentry : del_bps.entrySet()) {
                context.getDel_bps().put(bpentry.getKey(), (Long)bpentry.getValue());
            }
            for (Map.Entry atentry : del_at.entrySet()) {
                context.getDel_bps().put(atentry.getKey(), (Long)atentry.getValue());
            }
            for (Map.Entry centry : del_c.entrySet()) {
                context.getDel_bps().put(centry.getKey(), (Long)centry.getValue());
            }
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long modelId = this.getModelId();
        DynamicObject model = BusinessDataServiceHelper.loadSingle((Object)modelId, (String)"bcm_model", (String)NUMBER);
        String modelNum = model.getString(NUMBER);
        List<String> yearList = this.setYearCombo(modelNum);
        this.setMounthCombo();
        this.setDynCalcValue(modelId, yearList);
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        FilterParameter fp = new FilterParameter();
        QFilter filter = new QFilter(MODELCONSTANT, "=", (Object)modelId);
        fp.setFilter(filter);
        billList.setFilterParameter(fp);
        this.setExcuteDynacalTime();
        this.setBartonVisibleByUpgradeStatus();
        this.getModel().setValue("textareafield", (Object)ResManager.loadKDString((String)"\u672c\u6b21\u5347\u7ea7\u5c06\u542f\u7528\u52a8\u6001\u8ba1\u7b97\u529f\u80fd\u3002\u52a8\u6001\u8ba1\u7b97\u6307\uff1a\u975e\u660e\u7ec6\u7ef4\u6210\u5458\u503c\u6839\u636e\u7ef4\u6210\u5458\u7236\u5b50\u7ed3\u6784\u81ea\u52a8\u8ba1\u7b97\uff0c\u7236\u503c=\u805a\u5408\u7b97\u6cd5\u201c+\u201d\u7684\u5b50\u503c\u5408\u8ba1\u201c\u51cf\u53bb\u201d\u805a\u5408\u7b97\u6cd5\u201c-\u201d\u7684\u5b50\u503c\u5408\u8ba1\u3002\u9ed8\u8ba4\u4ee5\u4e0b\u7ef4\u5ea6\u542f\u7528\u52a8\u6001\u8ba1\u7b97\uff1a\u79d1\u76ee\u7ef4\u3001\u8fc7\u7a0b\u7ef4\u3001\u5ba1\u8ba1\u7ebf\u7d22\u7ef4\u3001\u53d8\u52a8\u7c7b\u578b\u7ef4\u3001\u5f80\u6765\u7ec4\u7ec7\u7ef4\u3001\u81ea\u5b9a\u4e49\u7ef4\u3002\u4e3a\u786e\u4fdd\u5728\u542f\u7528\u52a8\u6001\u8ba1\u7b97\u540e\uff0c\u4e0d\u5bf9\u5386\u53f2\u8d22\u5e74\u671f\u95f4\u7684Agg\u8ba1\u7b97\u7ed3\u679c\u4ea7\u751f\u5f71\u54cd\uff0c\u8bf7\u9009\u62e9\u542f\u7528\u5e74\u548c\u4f8b\u5916\u671f\u95f4\u3002\u793a\u4f8b\u8bf4\u660e\uff1a\u542f\u7528\u5e74\u9009\u62e92021\u5e74\uff0c\u4f8b\u5916\u671f\u95f4\u4e0d\u9009\uff0c\u90a3\u4e48\uff0c2020\u5e74\u7b49\u5386\u53f2\u8d22\u5e74\u5747\u4e0d\u6267\u884c\u52a8\u6001\u8ba1\u7b97\uff1b\u542f\u7528\u5e74\u9009\u62e92021\u5e74\uff0c\u4f8b\u5916\u671f\u95f4\u9009\u62e91\u6708\u548c2\u6708\uff0c\u90a3\u4e48\uff0c2021\u5e741\u6708\u548c2021\u5e742\u6708\u53ca2020\u5e74\u7b49\u5386\u53f2\u8d22\u5e74\u5747\u4e0d\u6267\u884c\u52a8\u6001\u8ba1\u7b97\u3002", (String)"ModelUpgradeLogPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    private void setDynCalcValue(Long modelId, List<String> yearList) {
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        String currentYear = "FY" + year;
        QFilter modelFilter = new QFilter(MODELCONSTANT, "=", (Object)modelId);
        QFilter[] filters = new QFilter[]{modelFilter};
        Boolean dynamicCalcInfoExist = QueryServiceHelper.exists((String)BCM_UPGRADE_DYNCALCINFO, (QFilter[])filters);
        if (dynamicCalcInfoExist.booleanValue()) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)BCM_UPGRADE_DYNCALCINFO, (String)"enableyear,exceperiod,data", (QFilter[])filters);
            String enableYear = (String)dynamicObject.get(ENABLEYEAR);
            if (StringUtils.isNotEmpty((CharSequence)enableYear)) {
                this.getModel().setValue(ENABLEYEAR, (Object)enableYear);
            } else if (yearList.contains(currentYear)) {
                this.getModel().setValue(ENABLEYEAR, (Object)currentYear);
            }
            String periodData = (String)dynamicObject.get(DATA);
            String period = (String)dynamicObject.get(EXCEPERIOD);
            if (StringUtils.isNotEmpty((CharSequence)periodData)) {
                this.getModel().setValue(EXCEPERIOD, (Object)periodData);
            } else if (StringUtils.isNotEmpty((CharSequence)period)) {
                this.getModel().setValue(EXCEPERIOD, (Object)period);
            }
        } else if (yearList.contains(currentYear)) {
            this.getModel().setValue(ENABLEYEAR, (Object)currentYear);
        }
    }

    private void setMounthCombo() {
        ComboEdit enableMonthCombo = (ComboEdit)this.getView().getControl(EXCEPERIOD);
        QFilter modelFilter = new QFilter(MODELCONSTANT, "=", (Object)this.getModelId());
        QFilter leafFilter = new QFilter("isleaf", "=", (Object)Character.valueOf('1'));
        ArrayList<String> notInNumbers = new ArrayList<String>(2);
        notInNumbers.add("CurrentPeriod");
        notInNumbers.add("LastPeriod");
        QFilter nouNumberFilter = new QFilter(NUMBER, "not in", notInNumbers);
        QFilter[] filters = new QFilter[]{modelFilter, leafFilter, nouNumberFilter};
        DynamicObjectCollection members = QueryServiceHelper.query((String)"bcm_periodmembertree", (String)NUMBER, (QFilter[])filters, (String)"number asc");
        ArrayList<ComboItem> monthComboList = new ArrayList<ComboItem>();
        for (DynamicObject dynamicObject : members) {
            String number = dynamicObject.getString(NUMBER);
            monthComboList.add(new ComboItem(new LocaleString(number), number));
        }
        enableMonthCombo.setComboItems(monthComboList);
    }

    private List<String> setYearCombo(String modelNum) {
        IDNumberTreeNode allYearNode = MemberReader.findFyMemberByNum((String)modelNum, (String)"AllYear");
        ArrayList<String> yearList = new ArrayList<String>(allYearNode.getChildren().size());
        allYearNode.getChildren().forEach(c -> {
            String yearNumber = c.getNumber();
            yearList.add(yearNumber);
        });
        ComboEdit enableYearCombo = (ComboEdit)this.getView().getControl(ENABLEYEAR);
        ArrayList<ComboItem> FYYearComboList = new ArrayList<ComboItem>(16);
        for (String FYYear : yearList) {
            FYYearComboList.add(new ComboItem(new LocaleString(FYYear), FYYear));
        }
        enableYearCombo.setComboItems(FYYearComboList);
        return yearList;
    }

    private void setExcuteDynacalTime() {
        Long upgradeId = (Long)this.getView().getFormShowParameter().getCustomParam("upgradeid");
        DynamicObject dy = BusinessDataServiceHelper.loadSingle((Object)upgradeId, (String)"bcm_upgradecontent");
        for (DynamicObject modelRecord : dy.getDynamicObjectCollection("entryentity")) {
            if (modelRecord.getLong("model.id") != this.getModelId() || modelRecord.getBoolean(STATUS)) continue;
            this.getView().setEnable(Boolean.valueOf(true), new String[]{BTN_START});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_RE_START});
        }
    }

    private void setBartonVisibleByUpgradeStatus() {
        boolean isRestartButtonVisible = false;
        if (this.isUpgraded()) {
            isRestartButtonVisible = true;
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_START});
        }
        this.getView().setVisible(Boolean.valueOf(isRestartButtonVisible), new String[]{BTN_RE_START});
    }

    private boolean isUpgraded() {
        Long upgradeId = (Long)this.getView().getFormShowParameter().getCustomParam("upgradeid");
        DynamicObject dy = BusinessDataServiceHelper.loadSingle((Object)upgradeId, (String)"bcm_upgradecontent");
        for (DynamicObject modelRecord : dy.getDynamicObjectCollection("entryentity")) {
            if (modelRecord.getLong("model.id") != this.getModelId()) continue;
            return true;
        }
        return false;
    }

    private boolean isUpgradedSuccessful(long modelId, String number) {
        DynamicObject dy = BusinessDataServiceHelper.loadSingle((String)"bcm_upgradestatus", (String)STATUS, (QFilter[])this.getUpgradeRdsFilters(modelId, number));
        return dy != null && SUCCESS.equals(dy.getString(STATUS));
    }

    private boolean isOnlyDimensionUpgraded(long modelId) {
        QFilter modelQf = new QFilter("model.id", "=", (Object)modelId);
        DynamicObject[] dys = BusinessDataServiceHelper.load((String)"bcm_upgradestatus", (String)STATUS, (QFilter[])new QFilter[]{modelQf});
        return dys == null || dys.length <= 1;
    }

    private QFilter[] getUpgradeRdsFilters(long modelId, String number) {
        QFilter modelQf = new QFilter("model.id", "=", (Object)modelId);
        QFilter numberQf = new QFilter(NUMBER, "=", (Object)number);
        return new QFilter[]{modelQf, numberQf};
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{PROGRESSBARAP});
    }

    public void onProgress(ProgressEvent progressEvent) {
        Control control = (Control)progressEvent.getSource();
        if (PROGRESSBARAP.equals(control.getKey())) {
            try {
                this.refreshBillList();
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        }
    }

    private void refreshBillList() {
        ProgressBar bar = (ProgressBar)this.getControl(PROGRESSBARAP);
        bar.setPercent(10);
        bar.start();
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        FilterParameter fp = new FilterParameter();
        long modelId = this.getModelId();
        QFilter filter = new QFilter(MODELCONSTANT, "=", (Object)modelId);
        fp.setFilter(filter);
        billList.setFilterParameter(fp);
        billList.refresh();
        billList.selectRows(0);
        billList.entryRowClick(Integer.valueOf(0));
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_upgradestatus", (String)STATUS, (QFilter[])new QFilter[]{new QFilter(MODELCONSTANT, "=", (Object)this.getModelId())});
        boolean isEnd = doc.stream().allMatch(d -> d.getInt(STATUS) != AbstractUpgradeService.ExcuteEnum.EXCUTING.getIndex());
        if (isEnd) {
            bar.stop();
            this.setExcuteDynacalTime();
            this.getView().hideLoading();
            billList.refresh();
        }
    }

    private static final class UpgradeType {
        public static final String UPGRADE_INVELIM = "InvElim";
        public static final String UPGRADE_ACCOUNT_MUL = "AccountMul";
        public static final String UPGRADE_TEMPLE = "template";
        public static final String UPGRADE_CHK = "chk";
        public static final String UPGRADE_LINK_SOURCE = "Linksource";
        public static final String UPGRADE_REPORTADJUSTPROCESS = "ReportAdjustProcess";
        public static final String UPGRADE_RPTADJUSTQUERYSCHEME = "RptAdjustQueryScheme";
        public static final String UPGRADE_WORKPAPER = "WorkPaper";
        public static final String UPGRADE_CONVERT = "Convert";
        public static final String UPGRADE_RATE = "rate";
        public static final String UPGRADE_ANALYTICSSOLUTIONDATA = "AnalyticsSolutionData";
        public static final String UPGRADE_BASE_DATA = "baseDataConfig";

        private UpgradeType() {
        }
    }
}

