/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.model;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.util.ThirdPartyDataCenterUtil;
import kd.fi.bcm.common.LogConstant;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;

public class ThirdPartyDataCenterListPlugin
extends AbstractBaseListPlugin {
    private static final WatchLogger LOG = BcmLogFactory.getWatchLogInstance(ThirdPartyDataCenterListPlugin.class);
    private static final String BARITE_ADD = "bariteadd";
    private static final String BARITE_DEL = "baritedel";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.getQFilters().add(new QFilter("apptype", "=", (Object)(this.isCM() ? ApplicationTypeEnum.CM.getOIndex() : ApplicationTypeEnum.RPT.getOIndex())));
        e.setOrderBy("modifytime desc");
    }

    @Override
    public void listRowDoubleClick(ListRowClickEvent evt) {
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        String appId = AppMetadataCache.getAppInfo((String)(this.isCM() ? ApplicationTypeEnum.CM.appnum : ApplicationTypeEnum.RPT.appnum)).getId();
        String msg_del = ThirdPartyDataCenterUtil.checkSysPerm((String)appId, (String)"47156aff000000ac");
        if (StringUtils.isNotEmpty((String)msg_del)) {
            this.getView().showTipNotification(msg_del);
            return;
        }
        switch (key = evt.getItemKey()) {
            case "bariteadd": {
                this.addDataCenter();
                break;
            }
            case "baritedel": {
                this.deleteDataCenter();
                break;
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if ("add_data_center".equals(actionId) || "edit_data_center".equals(actionId)) {
            ((IListView)this.getView()).refresh();
        }
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        Long id = (Long)((BillListHyperLinkClickEvent)args.getHyperLinkClickEvent()).getCurrentRow().getPrimaryKeyValue();
        DynamicObject dy = QueryServiceHelper.queryOne((String)"bcm_tdp_datacenter", (String)"ismodifypwd, teststatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        HashMap<String, String> openParameter = new HashMap<String, String>();
        openParameter.put("formId", "bcm_tdp_datacenter");
        openParameter.put("pkId", String.valueOf(id));
        FormShowParameter param = FormShowParameter.createFormShowParameter(openParameter);
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setFormId("bcm_tdp_datacenter");
        param.setCustomParam("ismodifypwd", (Object)dy.getBoolean("ismodifypwd"));
        param.setCustomParam("teststatus", (Object)dy.getString("teststatus"));
        param.setStatus(OperationStatus.EDIT);
        param.getOpenStyle().setTargetKey("_submaintab_");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "edit_data_center");
        param.setCloseCallBack(closeCallBack);
        this.getView().showForm(param);
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        if ("del_member_confirm".equals(callBackId) && MessageBoxResult.Yes == evt.getResult()) {
            ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
            Set delIds = (Set)SerializationUtils.fromJsonString((String)this.getPageCache().get("delIds"), Set.class);
            QFilter qf = new QFilter("id", "in", (Object)delIds);
            DeleteServiceHelper.delete((String)"bcm_tdp_datacenter", (QFilter[])qf.toArray());
            Map<String, String> num2Names = selectedRows.stream().collect(Collectors.toMap(k -> k.getNumber(), v -> v.getName(), (v1, v2) -> v1));
            num2Names.forEach((k, v) -> this.writeOperationLog(LogConstant.getOperationStatusDel(), (String)k, (String)v, LogConstant.getOperationStatusSuccess()));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"ThirdPartyDataCenterPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            BillList billList = (BillList)this.getControl("billlistap");
            billList.clearSelection();
            billList.refresh();
        }
    }

    private void addDataCenter() {
        BaseShowParameter param = new BaseShowParameter();
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setFormId("bcm_tdp_datacenter");
        param.setStatus(OperationStatus.ADDNEW);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "add_data_center");
        param.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)param);
    }

    private void deleteDataCenter() {
        IListView view = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = view.getSelectedRows();
        if (selectedRows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u884c", (String)"ThirdPartyDataCenterPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        Set ids = selectedRows.stream().map(x -> (Long)x.getPrimaryKeyValue()).collect(Collectors.toSet());
        this.getPageCache().put("delIds", SerializationUtils.toJsonString(ids));
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u662f\u5426\u5220\u9664\uff1f", (String)"ThirdPartyDataCenterPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("del_member_confirm", (IFormPlugin)this));
    }

    @Override
    public String getBizEntityNumber() {
        String name = this.getModel().getDataEntityType().getName();
        if ("bos_list".equals(name)) {
            return ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
        }
        return name;
    }
}

