/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.util.ThirdPartyDataCenterUtil;
import kd.fi.bcm.common.LogConstant;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.DataCenterCheckStatusEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.model.transfer.ModelTransferHelper;

public class ThirdPartyDataCenterPlugin
extends AbstractBaseFormPlugin {
    private static final WatchLogger LOG = BcmLogFactory.getWatchLogInstance(ThirdPartyDataCenterPlugin.class);
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String ADDRESS = "address";
    private static final String DATASOURCE = "datasource";
    private static final String DESCRIPTION = "description";
    private static final String IS_SPE_MODEL = "isspemodel";
    private static final String MODEL = "model";
    private static final String APP_ID = "appid";
    private static final String PASSWORD = "password";
    private static final String BARITE_TEST = "baritetest";
    private static final String BARITE_SAVE = "baritesave";
    private static final String BCM_PEER = "bcm_peer";
    private static final String PWD_VALIDATE_STATUS = "pwd_validate_status";
    private static final String IS_MODIFY_PWD = "is_modify_pwd";

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(BARITE_TEST, BARITE_SAVE);
    }

    @Override
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        String formId = e.getFormShowParameter().getFormId();
        long currUserId = RequestContext.get().getCurrUserId();
        if (!PermissionServiceHelper.hasViewPermission((long)currUserId, (String)AppMetadataCache.getAppInfo((String)ApplicationTypeEnum.CM.getAppnum()).getId(), (String)formId)) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u65e0\u4efb\u4f55\u62a5\u8868\u4f53\u7cfb\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u4f53\u7cfb\u7ba1\u7406\u5458\u3002", (String)"UserSelectUtil_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        super.beforeF7Select(e);
        String key = e.getProperty().getName();
        if (MODEL.equals(key)) {
            ApplicationTypeEnum app = this.isCM() ? ApplicationTypeEnum.CM : ApplicationTypeEnum.RPT;
            QFilter qf = new QFilter("reporttype", "=", (Object)app.getOIndex());
            qf.and("id", "in", (Object)MemberPermHelper.getLimitedModelListByUser((ApplicationTypeEnum)app));
            ListShowParameter param = (ListShowParameter)e.getFormShowParameter();
            param.getListFilterParameter().setFilter(qf);
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{MODEL, APP_ID, PASSWORD});
        this.getModel().setValue(PASSWORD, (Object)ThirdPartyDataCenterUtil.encrypterPwd((String)ThirdPartyDataCenterUtil.getThirdAppPassword()));
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.EDIT == status) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{NUMBER});
            if (!((Boolean)this.getModel().getValue(IS_SPE_MODEL)).booleanValue()) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{MODEL});
            }
            if (!((Boolean)this.getView().getFormShowParameter().getCustomParam("ismodifypwd")).booleanValue()) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{APP_ID, PASSWORD});
                this.getPageCache().put(IS_MODIFY_PWD, Boolean.FALSE.toString());
            } else {
                this.getPageCache().put(IS_MODIFY_PWD, Boolean.TRUE.toString());
            }
            this.getPageCache().put(PWD_VALIDATE_STATUS, (String)this.getView().getFormShowParameter().getCustomParam("teststatus"));
            String address = (String)this.getModel().getValue(ADDRESS);
            if (StringUtils.isNotEmpty((String)address)) {
                this.getDataSourceByAddress();
            }
        }
        this.getModel().setValue(APP_ID, (Object)BCM_PEER);
        this.getModel().setDataChanged(false);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{APP_ID});
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String appId = AppMetadataCache.getAppInfo((String)(this.isCM() ? ApplicationTypeEnum.CM.appnum : ApplicationTypeEnum.RPT.appnum)).getId();
        String msg_add = ThirdPartyDataCenterUtil.checkSysPerm((String)appId, (String)"47156aff000000ac");
        if (StringUtils.isNotEmpty((String)msg_add)) {
            this.getView().showTipNotification(msg_add);
            return;
        }
        String key = ((Control)evt.getSource()).getKey();
        if (BARITE_TEST.equals(key)) {
            this.testDataAndPwd();
        } else if (BARITE_SAVE.equals(key)) {
            this.saveThirdDataCenter();
        }
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        switch (name = e.getProperty().getName()) {
            case "address": {
                this.getModel().setValue(DATASOURCE, (Object)"");
                this.getDataSourceByAddress();
                if (OperationStatus.EDIT != status) break;
                this.getPageCache().put(PWD_VALIDATE_STATUS, DataCenterCheckStatusEnum.STATELESS.getIndex());
                break;
            }
            case "datasource": {
                if (OperationStatus.EDIT != status) break;
                this.getPageCache().put(PWD_VALIDATE_STATUS, DataCenterCheckStatusEnum.STATELESS.getIndex());
                break;
            }
            case "isspemodel": {
                if (((Boolean)this.getModel().getValue(IS_SPE_MODEL)).booleanValue()) {
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{MODEL});
                    ((BasedataEdit)this.getControl(MODEL)).setMustInput(true);
                    break;
                }
                this.getView().setVisible(Boolean.valueOf(false), new String[]{MODEL});
                this.getModel().setValue(MODEL, null);
                break;
            }
            case "password": {
                this.getPageCache().put(PWD_VALIDATE_STATUS, DataCenterCheckStatusEnum.STATELESS.getIndex());
                this.getPageCache().put(IS_MODIFY_PWD, Boolean.TRUE.toString());
                break;
            }
        }
    }

    private void recordTestingStatus(long id, boolean valResult) {
        QFilter qf = new QFilter("id", "=", (Object)id);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bcm_tdp_datacenter", (String)"teststatus, modifytime, testtime", (QFilter[])qf.toArray());
        if (valResult) {
            dynamicObject.set("teststatus", (Object)DataCenterCheckStatusEnum.SUCCESS.getIndex());
        } else {
            dynamicObject.set("teststatus", (Object)DataCenterCheckStatusEnum.FAIL.getIndex());
        }
        Date date = new Date();
        dynamicObject.set("testtime", (Object)date);
        dynamicObject.set("modifytime", (Object)date);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    private DynamicObject getDyByNumber() {
        QFilter qf = new QFilter(NUMBER, "=", this.getModel().getValue(NUMBER));
        return QueryServiceHelper.queryOne((String)"bcm_tdp_datacenter", (String)"id, ismodifypwd, password", (QFilter[])qf.toArray());
    }

    private String validateCom(DynamicObject dy) {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        String number = (String)this.getModel().getValue(NUMBER);
        Object name = this.getModel().getValue(NAME);
        String address = (String)this.getModel().getValue(ADDRESS);
        String datasource = (String)this.getModel().getValue(DATASOURCE);
        Boolean isSpeModel = (Boolean)this.getModel().getValue(IS_SPE_MODEL);
        Object model = this.getModel().getValue(MODEL);
        String password = (String)this.getModel().getValue(PASSWORD);
        if (StringUtils.isEmpty((String)number)) {
            return ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"ThirdPartyDataCenterPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        String regEx = "[A-Za-z0-9_]+";
        Pattern pattern = Pattern.compile(regEx);
        Matcher matcher = pattern.matcher(number);
        if (!matcher.matches()) {
            return ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u53ef\u5305\u542b\u6570\u5b57\uff0c\u5b57\u6bcd\u548c\u4e0b\u5212\u7ebf\u4ee5\u5916\u7684\u5b57\u7b26\u3002", (String)"ThirdPartyDataCenterPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        if (OperationStatus.ADDNEW == status && dy != null) {
            return ResManager.loadKDString((String)"\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u540e\u63d0\u4ea4\u3002", (String)"ThirdPartyDataCenterPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        if (Objects.isNull(name) || ((OrmLocaleValue)name).size() == 0) {
            return ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ThirdPartyDataCenterPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        List noEmptys = ((OrmLocaleValue)name).values().stream().filter(x -> StringUtils.isNotEmpty((String)x)).collect(Collectors.toList());
        if (noEmptys.size() == 0) {
            return ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ThirdPartyDataCenterPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        if (StringUtils.isEmpty((String)address)) {
            return ResManager.loadKDString((String)"\u76ee\u6807\u73af\u5883\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ThirdPartyDataCenterPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        if (StringUtils.isEmpty((String)datasource)) {
            return ResManager.loadKDString((String)"\u201c\u6570\u636e\u4e2d\u5fc3\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ThirdPartyDataCenterPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        if (isSpeModel.booleanValue() && Objects.isNull(model)) {
            return ResManager.loadKDString((String)"\u9002\u7528\u7279\u5b9a\u4f53\u7cfb\u5f00\u542f\u540e\uff0c\u4f53\u7cfb\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ThirdPartyDataCenterPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        if (StringUtils.isEmpty((String)password)) {
            return ResManager.loadKDString((String)"\u5e94\u7528\u5bc6\u94a5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ThirdPartyDataCenterPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    private boolean validateAppPwd() {
        String address = (String)this.getModel().getValue(ADDRESS);
        String datasource = (String)this.getModel().getValue(DATASOURCE);
        String appId = (String)this.getModel().getValue(APP_ID);
        String pwd = (String)this.getModel().getValue(PASSWORD);
        pwd = ThirdPartyDataCenterUtil.decrypterPwd((String)pwd);
        return ThirdPartyDataCenterUtil.getAppToken((String)address, (String)datasource, (String)appId, (String)pwd);
    }

    private void saveThirdDataCenter() {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        DynamicObject dy = this.getDyByNumber();
        String msg = this.validateCom(dy);
        if (StringUtils.isNotEmpty((String)msg)) {
            this.getView().showTipNotification(msg);
            return;
        }
        if (OperationStatus.ADDNEW == status || dy != null && !dy.getBoolean("ismodifypwd")) {
            boolean valResult = this.validateAppPwd();
            if (valResult) {
                this.setStatusOfPwdCheck();
                if (OperationStatus.ADDNEW == status) {
                    this.saveThirdDataCenterFirst();
                } else {
                    this.saveThirdDataCenterOfEdit();
                }
                this.getModel().setDataChanged(false);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"ThirdPartyDataCenterPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                this.getView().close();
            } else {
                this.getPageCache().put(PWD_VALIDATE_STATUS, DataCenterCheckStatusEnum.FAIL.getIndex());
                String isModify = this.getPageCache().get(IS_MODIFY_PWD);
                if (Boolean.TRUE.toString().equals(isModify)) {
                    if (OperationStatus.ADDNEW == status) {
                        this.saveThirdDataCenterFirst();
                    } else {
                        this.saveThirdDataCenterOfEdit();
                    }
                    this.getModel().setDataChanged(false);
                    this.getView().close();
                } else {
                    this.getPageCache().put(IS_MODIFY_PWD, Boolean.TRUE.toString());
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7b2c\u4e09\u65b9\u9a8c\u6743\u5931\u8d25\uff0c\u8bf7\u4fee\u6539\u5bc6\u94a5\u540e\u91cd\u65b0\u4fdd\u5b58\u3002", (String)"ThirdPartyDataCenterPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{APP_ID, PASSWORD});
                }
            }
        } else {
            this.saveThirdDataCenterOfEdit();
            this.getModel().setDataChanged(false);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"ThirdPartyDataCenterPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            this.getView().close();
        }
    }

    private void saveThirdDataCenterOfEdit() {
        DynamicObject dy = BusinessDataServiceHelper.loadSingle((Object)this.getModel().getValue("id"), (String)"bcm_tdp_datacenter");
        String pwd = ThirdPartyDataCenterUtil.decrypterPwd((String)dy.getString(PASSWORD));
        String pwdNew = (String)this.getModel().getValue(PASSWORD);
        if (!(pwdNew = ThirdPartyDataCenterUtil.decrypterPwd((String)pwdNew)).equals(pwd)) {
            dy.set(PASSWORD, (Object)ThirdPartyDataCenterUtil.encrypterPwd((String)pwdNew));
        }
        dy.set("teststatus", (Object)this.getPageCache().get(PWD_VALIDATE_STATUS));
        dy.set("ismodifypwd", (Object)(Boolean.TRUE.toString().equals(this.getPageCache().get(IS_MODIFY_PWD)) ? "1" : "0"));
        dy.set(NAME, this.getModel().getValue(NAME));
        dy.set(ADDRESS, this.getModel().getValue(ADDRESS));
        dy.set(DATASOURCE, this.getModel().getValue(DATASOURCE));
        dy.set(DESCRIPTION, this.getModel().getValue(DESCRIPTION));
        dy.set(IS_SPE_MODEL, this.getModel().getValue(IS_SPE_MODEL));
        dy.set(MODEL, this.getModel().getValue(MODEL));
        dy.set("modifytime", (Object)new Date());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dy});
        this.writeOperationLog(LogConstant.getOperationStatusSave(), this.getModel().getValue(NUMBER).toString(), ((OrmLocaleValue)this.getModel().getValue(NAME)).getLocaleValue(), LogConstant.getOperationStatusSuccess());
    }

    private void saveThirdDataCenterFirst() {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bcm_tdp_datacenter");
        dynamicObject.set(NUMBER, this.getModel().getValue(NUMBER));
        dynamicObject.set(NAME, this.getModel().getValue(NAME));
        dynamicObject.set(ADDRESS, this.getModel().getValue(ADDRESS));
        dynamicObject.set(DATASOURCE, this.getModel().getValue(DATASOURCE));
        dynamicObject.set(DESCRIPTION, this.getModel().getValue(DESCRIPTION));
        dynamicObject.set(IS_SPE_MODEL, this.getModel().getValue(IS_SPE_MODEL));
        dynamicObject.set(MODEL, this.getModel().getValue(MODEL));
        dynamicObject.set(APP_ID, this.getModel().getValue(APP_ID));
        String pwd = (String)this.getModel().getValue(PASSWORD);
        dynamicObject.set(PASSWORD, (Object)ThirdPartyDataCenterUtil.encrypterPwd((String)pwd));
        dynamicObject.set("apptype", (Object)(this.isCM() ? ApplicationTypeEnum.CM.getOIndex() : ApplicationTypeEnum.RPT.getOIndex()));
        dynamicObject.set("teststatus", (Object)this.getPageCache().get(PWD_VALIDATE_STATUS));
        dynamicObject.set("status", (Object)"C");
        boolean flag = Boolean.TRUE.toString().equals(this.getPageCache().get(IS_MODIFY_PWD));
        dynamicObject.set("ismodifypwd", (Object)(flag ? "1" : "0"));
        dynamicObject.set("creator", (Object)RequestContext.get().getCurrUserId());
        dynamicObject.set("modifier", (Object)RequestContext.get().getCurrUserId());
        Date date = new Date();
        dynamicObject.set("createtime", (Object)date);
        dynamicObject.set("modifytime", (Object)date);
        dynamicObject.set("testtime", (Object)date);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        this.writeOperationLog(LogConstant.getOperationStatusAddSave(), this.getModel().getValue(NUMBER).toString(), ((OrmLocaleValue)this.getModel().getValue(NAME)).getLocaleValue(), LogConstant.getOperationStatusSuccess());
    }

    private void testDataAndPwd() {
        DynamicObject dy = this.getDyByNumber();
        String msg = this.validateCom(dy);
        if (StringUtils.isNotEmpty((String)msg)) {
            this.getView().showTipNotification(msg);
            return;
        }
        boolean valResult = this.validateAppPwd();
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW == status || dy != null && !dy.getBoolean("ismodifypwd")) {
            if (valResult) {
                this.setStatusOfPwdCheck();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u9a8c\u8bc1\u6210\u529f", (String)"ThirdPartyDataCenterPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            } else {
                this.getPageCache().put(IS_MODIFY_PWD, Boolean.TRUE.toString());
                this.getPageCache().put(PWD_VALIDATE_STATUS, DataCenterCheckStatusEnum.FAIL.getIndex());
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9a8c\u8bc1\u5931\u8d25", (String)"ThirdPartyDataCenterPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                this.getView().setVisible(Boolean.valueOf(true), new String[]{APP_ID, PASSWORD});
            }
        } else {
            if (dy == null) {
                throw new KDBizException("the object is not found");
            }
            this.recordTestingStatus(dy.getLong("id"), valResult);
            if (valResult) {
                this.getPageCache().put(PWD_VALIDATE_STATUS, DataCenterCheckStatusEnum.SUCCESS.getIndex());
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u9a8c\u8bc1\u6210\u529f", (String)"ThirdPartyDataCenterPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            } else {
                this.getPageCache().put(PWD_VALIDATE_STATUS, DataCenterCheckStatusEnum.FAIL.getIndex());
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7b2c\u4e09\u65b9\u9a8c\u6743\u5931\u8d25\uff0c\u8bf7\u4fee\u6539\u5bc6\u94a5\u540e\u91cd\u65b0\u4fdd\u5b58\u3002", (String)"ThirdPartyDataCenterPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void getDataSourceByAddress() {
        String domainUrl = (String)this.getModel().getValue(ADDRESS);
        ComboEdit comboEdit = (ComboEdit)this.getControl(DATASOURCE);
        comboEdit.setComboItems(null);
        try {
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(16);
            List<Pair<String, String>> pairs = ModelTransferHelper.listSiteAccounts(domainUrl);
            for (Pair<String, String> pair : pairs) {
                ComboItem comboItem = new ComboItem();
                comboItem.setCaption(new LocaleString((String)pair.p2));
                comboItem.setValue((String)pair.p1);
                comboItems.add(comboItem);
            }
            comboEdit.setComboItems(comboItems);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u4e2d\u5fc3\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u76ee\u6807\u73af\u5883\u5730\u5740\u662f\u5426\u6b63\u786e\u3002", (String)"BcmModelCopyAndTransferPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private void setStatusOfPwdCheck() {
        String isModify = this.getPageCache().get(IS_MODIFY_PWD);
        if (Boolean.TRUE.toString().equals(isModify)) {
            this.getPageCache().put(PWD_VALIDATE_STATUS, DataCenterCheckStatusEnum.SUCCESS.getIndex());
        } else {
            this.getPageCache().put(PWD_VALIDATE_STATUS, DataCenterCheckStatusEnum.NO_STATUS.getIndex());
        }
    }
}

