/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.model.transfer;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.ErrorCodeUtils;
import kd.bos.util.HttpClientUtils;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.json.JacksonUtils;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.model.transfer.ModelImportParam;
import kd.fi.bcm.formplugin.model.transfer.core.TransferMsgUtils;
import org.apache.commons.io.FileUtils;

public class ModelTransferHelper {
    private static final Log LOG = LogFactory.getLog(ModelTransferHelper.class);
    private static final int HTTP_CONN_TIMEOUT = 3000;
    private static final int HTTP_READ_TIMEOUT = 10000;
    private static final int HTTP_FILEUPLOAD_TIMEOUT = 600000;
    private static volatile Function<Map<String, Object>, Pair<String, String>> toAccountInfo = x -> new Pair(x.get("accountId"), x.get("accountName"));
    private static Map<String, String> REST_HEADER = new HashMap<String, String>(8);

    public static String getCurrentSiteAccountName() {
        try {
            List<Pair<String, String>> accounts = ModelTransferHelper.listSiteAccounts(RequestContext.get().getClientFullContextPath());
            String curAccountId = RequestContext.get().getAccountId();
            for (Pair<String, String> x : accounts) {
                if (!curAccountId.equals(x.p1)) continue;
                return (String)x.p2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static List<Pair<String, String>> listSiteAccounts(String domainContextUrl) throws Exception {
        String response = HttpClientUtils.get((String)(domainContextUrl + "/auth/getAllDatacenters.do"), (int)3000, (int)10000);
        List accountsInfo = (List)JacksonUtils.fromJson((String)response, List.class);
        List<Pair<String, String>> result = accountsInfo.stream().map(toAccountInfo).collect(Collectors.toList());
        Optional<Pair<String, String>> defaultAcct = accountsInfo.stream().filter(x -> x.get("default").toString().equalsIgnoreCase(Boolean.TRUE.toString())).map(toAccountInfo).findFirst();
        if (defaultAcct.isPresent()) {
            ArrayList<Pair<String, String>> newResult = new ArrayList<Pair<String, String>>(2);
            newResult.add(defaultAcct.get());
            newResult.addAll(result.stream().filter(x -> !((String)x.p1).equals(((Pair)defaultAcct.get()).p1)).collect(Collectors.toList()));
            return newResult;
        }
        return result;
    }

    public static String getLoginToken(String targetDomainContextUrl, String accountId, String loginUserMobile, String password, String appId, String appPwd) {
        try {
            String appToken = ModelTransferHelper.getAppToken(targetDomainContextUrl, accountId, appId, appPwd);
            return ModelTransferHelper.getAccessToken(targetDomainContextUrl, accountId, appToken, loginUserMobile, password);
        }
        catch (Exception e) {
            LOG.error(String.format("failed_remote_login: url: %s, accountId: %s, loginMobile: %s", targetDomainContextUrl, accountId, loginUserMobile), (Throwable)e);
            throw new KDBizException((Throwable)e, ErrorCodeUtils.getSystemErrorCode((String)TransferMsgUtils.loginRemoteFailed()), new Object[0]);
        }
    }

    private static String getAppToken(String targetDomainContextUrl, String accountId, String appId, String appPwd) throws IOException {
        HashMap<String, String> requestBody = new HashMap<String, String>(6);
        requestBody.put("appId", appId);
        requestBody.put("appSecuret", appPwd);
        requestBody.put("accountId", accountId);
        requestBody.put("language", "zh_CN");
        String response = HttpClientUtils.postjson((String)(targetDomainContextUrl + "/api/getAppToken.do"), REST_HEADER, (String)JacksonUtils.toJson(requestBody), (int)3000, (int)10000);
        return (String)ModelTransferHelper.extractResponseData(response).get("app_token");
    }

    private static String getAccessToken(String targetDomainContextUrl, String accountId, String appToken, String loginUserMobile, String password) throws IOException {
        HashMap<String, String> requestBody = new HashMap<String, String>(5);
        requestBody.put("user", loginUserMobile);
        requestBody.put("password", password);
        requestBody.put("apptoken", appToken);
        requestBody.put("accountId", accountId);
        requestBody.put("logintype", "2");
        String response = HttpClientUtils.postjson((String)(targetDomainContextUrl + "/api/login.do"), REST_HEADER, (String)JacksonUtils.toJson(requestBody), (int)3000, (int)10000);
        return (String)ModelTransferHelper.extractResponseData(response).get("access_token");
    }

    private static Map<String, Object> extractResponseData(String response) {
        Map responseBody = (Map)JacksonUtils.fromJson((String)response, Map.class);
        if ("success".equals(responseBody.get("state"))) {
            return (Map)responseBody.get("data");
        }
        throw new KDBizException((String)responseBody.get("errorMsg"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String uploadFileToRemoteApp(String targetDomainContextUrl, String accessToken, File localFile, boolean isDelAfterUploaded) {
        HashMap<String, String> uploadHeader = new HashMap<String, String>(4);
        uploadHeader.put("accessToken", accessToken);
        uploadHeader.put("api", "true");
        long tick = System.currentTimeMillis();
        FileInputStream inputStream = null;
        try {
            inputStream = FileUtils.openInputStream((File)localFile);
            ArrayList<HttpClientUtils.FormDataEntity> formDatas = new ArrayList<HttpClientUtils.FormDataEntity>();
            formDatas.add(new HttpClientUtils.FormDataEntity("file", (InputStream)inputStream, localFile.getPath()));
            formDatas.add(new HttpClientUtils.FormDataEntity("url", localFile.getPath()));
            formDatas.add(new HttpClientUtils.FormDataEntity("appId", ApplicationTypeEnum.CM.getAppnum()));
            formDatas.add(new HttpClientUtils.FormDataEntity("fId", "bcm_modelcopyandtransfer"));
            String requestFullUrl = ModelTransferHelper.concatUrl(targetDomainContextUrl, "/attachment/upload.do");
            String uploadResponse = HttpClientUtils.postFormData((String)requestFullUrl, uploadHeader, formDatas, (int)3000, (int)600000);
            LOG.info(String.format("upload_file with targetURL: %s, accessToken: %s, local File: %s, uploaded response: %s, cost: %s", targetDomainContextUrl, accessToken, localFile.getPath(), uploadResponse, System.currentTimeMillis() - tick));
            if (!StringUtils.isNotEmpty((CharSequence)uploadResponse)) throw new IllegalStateException("upload file failed: " + uploadResponse);
            Map uploadResponseJson = (Map)JacksonUtils.fromJson((String)uploadResponse, (TypeReference)new TypeReference<Map<String, Object>>(){

                public Type getType() {
                    return super.getType();
                }
            });
            if ("success".equals(uploadResponseJson.get("status"))) {
                if (isDelAfterUploaded) {
                    inputStream.close();
                    FileUtils.forceDelete((File)localFile);
                }
                String string = uploadResponseJson.get("url").toString();
                return string;
            }
            try {
                if (!"error".equals(uploadResponseJson.get("status"))) throw new IllegalStateException("upload file failed: " + uploadResponse);
                throw new KDBizException(uploadResponseJson.get("description").toString());
            }
            catch (Exception e) {
                LOG.error(String.format("upload_file failed targetURL: %s, accessToken: %s, local File: %s, cost: %s", targetDomainContextUrl, accessToken, localFile.getPath(), System.currentTimeMillis() - tick), (Throwable)e);
                throw new KDBizException((Throwable)e, ErrorCodeUtils.getSystemErrorCode((String)TransferMsgUtils.uploadFileFailed(e.getMessage())), new Object[0]);
            }
        }
        finally {
            if (Objects.nonNull(inputStream)) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
        }
    }

    public static void executeRemoteImportModel(String targetDomainContextUrl, ModelImportParam importParam, String accessToken) {
        block4: {
            HashMap<String, String> requestHeader = new HashMap<String, String>(4);
            requestHeader.put("access_token", accessToken);
            String paramJson = JacksonUtils.toJson((Object)importParam);
            long tick = System.currentTimeMillis();
            try {
                String response = HttpClientUtils.postjson((String)ModelTransferHelper.concatUrl(targetDomainContextUrl, "/kapi/app/cm/modelTransfer"), requestHeader, (String)paramJson, (int)1000, (int)1800000);
                LOG.info(String.format("upload_file with targetURL: %s, accessToken: %s, param: %s, uploaded response: %s, cost: %s", targetDomainContextUrl, accessToken, paramJson, response, System.currentTimeMillis() - tick));
                if (StringUtils.isNotEmpty((CharSequence)response)) {
                    Map responseJson = (Map)JacksonUtils.fromJson((String)response, (TypeReference)new TypeReference<Map<String, Object>>(){

                        public Type getType() {
                            return super.getType();
                        }
                    });
                    if (!Boolean.parseBoolean(responseJson.get("success").toString())) {
                        LOG.error(String.format("model_transfer_remote_import failed targetURL: %s, accessToken: %s, param: %s on: %s", targetDomainContextUrl, accessToken, paramJson, responseJson.get("message"), System.currentTimeMillis() - tick));
                        throw new KDBizException(responseJson.get("message").toString());
                    }
                    break block4;
                }
                LOG.error(String.format("model_transfer_remote_import failed targetURL: %s, accessToken: %s, param: %s with result: %s", targetDomainContextUrl, accessToken, paramJson, response));
                throw new IllegalStateException("open service call failed with empty response.");
            }
            catch (Exception e) {
                LOG.error(String.format("model_transfer_remote_import failed targetURL: %s, accessToken: %s, param: %s, cost: %s", targetDomainContextUrl, accessToken, paramJson, System.currentTimeMillis() - tick), (Throwable)e);
                String message = e instanceof IllegalStateException ? TransferMsgUtils.remoteImportModelFailed(e.getMessage()) : e.getMessage();
                throw new KDBizException((Throwable)e, ErrorCodeUtils.getSystemErrorCode((String)message), new Object[0]);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public static File downloadFile(String uploadFileUrl) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String concatUrl(String domainContext, String path) {
        boolean expression;
        boolean bl = expression = StringUtils.isNotEmpty((CharSequence)domainContext) && StringUtils.isNotEmpty((CharSequence)path);
        if (!expression) {
            throw new IllegalArgumentException("param domainContext or path is empty");
        }
        if (domainContext.endsWith("/")) {
            return domainContext.substring(0, domainContext.length() - 1) + path;
        }
        return domainContext + path;
    }

    public static String buildExceptionMsg(Throwable e, int stackLimit, boolean isSimple) {
        List stackMsgs = Arrays.stream(e.getStackTrace()).filter(ele -> Objects.nonNull(ele.getClassName()) && ele.getClassName().startsWith("kd.fi.bcm")).map(ele -> isSimple ? String.format("%s:%s", ele.getFileName(), ele.getLineNumber()) : ele.toString()).collect(Collectors.toList());
        if (stackLimit > 0) {
            stackMsgs = stackMsgs.subList(0, Math.min(stackMsgs.size(), stackLimit));
        }
        return String.format("%s[%s] %s", e.getMessage(), RequestContext.get().getTraceId(), String.join((CharSequence)",", stackMsgs));
    }

    public static String unexpectedError() {
        return ResManager.loadKDString((String)"\u672a\u77e5\u5f02\u5e38\uff1a", (String)"ModelTransferHelper_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    static {
        REST_HEADER.put("Content-Type", "application/json");
    }
}

