/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.model.transfer;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.model.transfer.core.ModelTransferType;

public class ModelTransferParam {
    private long sourceModelId;
    private String targetModelNumber;
    private String targetModelName;
    private String remoteSiteUrl;
    private String remoteAccountId;
    private String remoteLoginUserMobile;
    private String password;
    private boolean isTransferOLAPData;
    private boolean isForceMetaConsistent = false;
    private ModelTransferType transferType;
    private String secretkey;
    private Map<String, Set<Long>> transferEntities = new HashMap<String, Set<Long>>(8);
    private String filterEntityNums;
    private String appId;
    private String appPwd;
    private Map<String, Set<Long>> dim2Ids;

    private ModelTransferParam() {
    }

    public static ModelTransferParam buildForExport(long sourceModelId, boolean isTransferOLAPData, Map<String, Set<Long>> transferEntities, String secretkey, String filterEntityNum, Map<String, Set<Long>> dim2Ids) {
        if (sourceModelId <= 0L) {
            throw new IllegalArgumentException();
        }
        ModelTransferParam param = new ModelTransferParam();
        param.sourceModelId = sourceModelId;
        param.isTransferOLAPData = isTransferOLAPData;
        param.transferEntities = transferEntities;
        param.filterEntityNums = filterEntityNum;
        param.transferType = ModelTransferType.EXPORT;
        param.secretkey = secretkey;
        param.dim2Ids = dim2Ids;
        return param;
    }

    public static ModelTransferParam buildForLocalCopy(long sourceModelId, String targetModelNumber, String targetModelName, boolean isTransferOLAPData, Map<String, Set<Long>> transferEntities, String filterEntityNum, Map<String, Set<Long>> dim2Ids) {
        boolean expression;
        ModelTransferParam param = ModelTransferParam.buildForExport(sourceModelId, isTransferOLAPData, transferEntities, "", filterEntityNum, dim2Ids);
        boolean bl = expression = StringUtils.isNotEmpty((CharSequence)targetModelNumber) && StringUtils.isNotEmpty((CharSequence)targetModelName);
        if (!expression) {
            throw new IllegalArgumentException("param targetModelNumber/targetModelName is empty");
        }
        param.targetModelNumber = targetModelNumber;
        param.targetModelName = targetModelName;
        param.transferType = ModelTransferType.LOCAL_COPY;
        return param;
    }

    public static ModelTransferParam buildForRemoteCopy(long sourceModelId, String targetModelNumber, String targetModelName, boolean isTransferOLAPData, String remoteSiteUrl, String remoteAccountId, String remoteLoginUserMobile, String password, Map<String, Set<Long>> transferEntities, boolean isForceMetaConsistent, String filterEntityNum, String appId, String appPwd, Map<String, Set<Long>> dim2Ids) {
        boolean expression;
        ModelTransferParam param = ModelTransferParam.buildForLocalCopy(sourceModelId, targetModelNumber, targetModelName, isTransferOLAPData, transferEntities, filterEntityNum, dim2Ids);
        boolean bl = expression = StringUtils.isNotEmpty((CharSequence)remoteSiteUrl) && StringUtils.isNotEmpty((CharSequence)remoteAccountId) && StringUtils.isNotEmpty((CharSequence)remoteLoginUserMobile) && StringUtils.isNotEmpty((CharSequence)password);
        if (!expression) {
            throw new IllegalArgumentException("param remoteSiteUrl/remoteAccountId/remoteLoginUserMobile is empty");
        }
        param.remoteSiteUrl = remoteSiteUrl;
        param.remoteAccountId = remoteAccountId;
        param.remoteLoginUserMobile = remoteLoginUserMobile;
        param.isForceMetaConsistent = isForceMetaConsistent;
        param.password = password;
        param.transferType = ModelTransferType.REMOTE_COPY;
        param.appId = appId;
        param.appPwd = appPwd;
        return param;
    }

    public long getSourceModelId() {
        return this.sourceModelId;
    }

    public String getTargetModelNumber() {
        return this.targetModelNumber;
    }

    public String getTargetModelName() {
        return this.targetModelName;
    }

    public String getRemoteSiteUrl() {
        return this.remoteSiteUrl;
    }

    public String getRemoteAccountId() {
        return this.remoteAccountId;
    }

    public String getRemoteLoginUserMobile() {
        return this.remoteLoginUserMobile;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isTransferOLAPData() {
        return this.isTransferOLAPData;
    }

    public Map<String, Set<Long>> getTransferEntities() {
        return this.transferEntities;
    }

    public ModelTransferType getTransferType() {
        return this.transferType;
    }

    public boolean getIsForceMetaConsistent() {
        return this.isForceMetaConsistent;
    }

    public String getSecretkey() {
        return this.secretkey;
    }

    public String getFilterEntityNums() {
        return this.filterEntityNums;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAppPwd() {
        return this.appPwd;
    }

    public void setAppPwd(String appPwd) {
        this.appPwd = appPwd;
    }

    public Map<String, Set<Long>> getDim2Ids() {
        return this.dim2Ids;
    }

    public void setDim2Ids(Map<String, Set<Long>> dim2Ids) {
        this.dim2Ids = dim2Ids;
    }
}

